// third_party/blink/public/mojom/render_accessibility.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_RENDER_ACCESSIBILITY_MOJOM_SHARED_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_RENDER_ACCESSIBILITY_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/render_accessibility.mojom-shared-internal.h"
#include "ui/accessibility/ax_enums.mojom-shared.h"
#include "ui/accessibility/mojom/ax_action_data.mojom-shared.h"
#include "ui/accessibility/mojom/ax_event.mojom-shared.h"
#include "ui/accessibility/mojom/ax_mode.mojom-shared.h"
#include "ui/accessibility/mojom/ax_relative_bounds.mojom-shared.h"
#include "ui/accessibility/mojom/ax_tree_id.mojom-shared.h"
#include "ui/accessibility/mojom/ax_tree_update.mojom-shared.h"
#include "ui/accessibility/mojom/ax_updates_and_events.mojom-shared.h"
#include "ui/accessibility/mojom/ax_location_and_scroll_updates.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "third_party/blink/public/mojom/tokens/tokens.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "third_party/blink/public/mojom/render_accessibility.mojom-data-view.h"
#include "base/component_export.h"




namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::HitTestResponseDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::HitTestResponseDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::HitTestResponse_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::stitched_child_tree_id(input)) in_stitched_child_tree_id = Traits::stitched_child_tree_id(input);
    mojo::internal::MessageFragment<decltype(fragment->stitched_child_tree_id)>
        stitched_child_tree_id_fragment(fragment.message());
    stitched_child_tree_id_fragment.Claim(&fragment->stitched_child_tree_id);
    
    mojo::internal::Serialize<::ax::mojom::AXTreeIDDataView>(
      in_stitched_child_tree_id,
      stitched_child_tree_id_fragment,
      true);

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->stitched_child_tree_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null stitched_child_tree_id in HitTestResponse struct");

    decltype(Traits::hit_frame_token(input)) in_hit_frame_token = Traits::hit_frame_token(input);
    mojo::internal::MessageFragment<decltype(fragment->hit_frame_token)>
        hit_frame_token_fragment(fragment.message());
    hit_frame_token_fragment.Claim(&fragment->hit_frame_token);
    
    mojo::internal::Serialize<::blink::mojom::FrameTokenDataView>(
      in_hit_frame_token,
      hit_frame_token_fragment,
      true);

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->hit_frame_token.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null hit_frame_token in HitTestResponse struct");

    decltype(Traits::hit_frame_transformed_point(input)) in_hit_frame_transformed_point = Traits::hit_frame_transformed_point(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->hit_frame_transformed_point)::BaseType> hit_frame_transformed_point_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::gfx::mojom::PointDataView>(
      in_hit_frame_transformed_point,
      hit_frame_transformed_point_fragment);

    fragment->hit_frame_transformed_point.Set(
        hit_frame_transformed_point_fragment.is_null() ? nullptr : hit_frame_transformed_point_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->hit_frame_transformed_point.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null hit_frame_transformed_point in HitTestResponse struct");

    fragment->hit_node_id = Traits::hit_node_id(input);
  }

  static bool Deserialize(::blink::mojom::internal::HitTestResponse_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::HitTestResponseDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace blink::mojom {

inline void HitTestResponseDataView::GetStitchedChildTreeIdDataView(
    ::ax::mojom::AXTreeIDDataView* output) {
  auto pointer = &data_->stitched_child_tree_id;
  *output = ::ax::mojom::AXTreeIDDataView(pointer, message_);
}
inline void HitTestResponseDataView::GetHitFrameTokenDataView(
    ::blink::mojom::FrameTokenDataView* output) {
  auto pointer = &data_->hit_frame_token;
  *output = ::blink::mojom::FrameTokenDataView(pointer, message_);
}
inline void HitTestResponseDataView::GetHitFrameTransformedPointDataView(
    ::gfx::mojom::PointDataView* output) {
  auto pointer = data_->hit_frame_transformed_point.Get();
  *output = ::gfx::mojom::PointDataView(pointer, message_);
}



}  // blink::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_RENDER_ACCESSIBILITY_MOJOM_SHARED_H_