// third_party/blink/public/mojom/render_accessibility.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_RENDER_ACCESSIBILITY_MOJOM_DATA_VIEW_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_RENDER_ACCESSIBILITY_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/blink/public/mojom/render_accessibility.mojom-shared-internal.h"
#include "ui/accessibility/ax_enums.mojom-shared.h"
#include "ui/accessibility/mojom/ax_action_data.mojom-shared.h"
#include "ui/accessibility/mojom/ax_event.mojom-shared.h"
#include "ui/accessibility/mojom/ax_mode.mojom-shared.h"
#include "ui/accessibility/mojom/ax_relative_bounds.mojom-shared.h"
#include "ui/accessibility/mojom/ax_tree_id.mojom-shared.h"
#include "ui/accessibility/mojom/ax_tree_update.mojom-shared.h"
#include "ui/accessibility/mojom/ax_updates_and_events.mojom-shared.h"
#include "ui/accessibility/mojom/ax_location_and_scroll_updates.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "third_party/blink/public/mojom/tokens/tokens.mojom-shared.h"


namespace blink::mojom {
class HitTestResponseDataView;



}  // blink::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::blink::mojom::HitTestResponseDataView> {
  using Data = ::blink::mojom::internal::HitTestResponse_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace blink::mojom {
// Interface base classes. They are used for type safety check.
class RenderAccessibilityHostInterfaceBase {};

using RenderAccessibilityHostPtrDataView =
    mojo::InterfacePtrDataView<RenderAccessibilityHostInterfaceBase>;
using RenderAccessibilityHostRequestDataView =
    mojo::InterfaceRequestDataView<RenderAccessibilityHostInterfaceBase>;
using RenderAccessibilityHostAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<RenderAccessibilityHostInterfaceBase>;
using RenderAccessibilityHostAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<RenderAccessibilityHostInterfaceBase>;
class RenderAccessibilityInterfaceBase {};

using RenderAccessibilityPtrDataView =
    mojo::InterfacePtrDataView<RenderAccessibilityInterfaceBase>;
using RenderAccessibilityRequestDataView =
    mojo::InterfaceRequestDataView<RenderAccessibilityInterfaceBase>;
using RenderAccessibilityAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<RenderAccessibilityInterfaceBase>;
using RenderAccessibilityAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<RenderAccessibilityInterfaceBase>;


class HitTestResponseDataView {
 public:
  HitTestResponseDataView() = default;

  HitTestResponseDataView(
      internal::HitTestResponse_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetStitchedChildTreeIdDataView(
      ::ax::mojom::AXTreeIDDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadStitchedChildTreeId(UserType* output) {
    
    auto* pointer = !data_->stitched_child_tree_id.is_null() ? &data_->stitched_child_tree_id : nullptr;
    return mojo::internal::Deserialize<::ax::mojom::AXTreeIDDataView>(
        pointer, output, message_);
  }
  inline void GetHitFrameTokenDataView(
      ::blink::mojom::FrameTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadHitFrameToken(UserType* output) {
    
    auto* pointer = !data_->hit_frame_token.is_null() ? &data_->hit_frame_token : nullptr;
    return mojo::internal::Deserialize<::blink::mojom::FrameTokenDataView>(
        pointer, output, message_);
  }
  inline void GetHitFrameTransformedPointDataView(
      ::gfx::mojom::PointDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadHitFrameTransformedPoint(UserType* output) {
    
    auto* pointer = data_->hit_frame_transformed_point.Get();
    return mojo::internal::Deserialize<::gfx::mojom::PointDataView>(
        pointer, output, message_);
  }
  int32_t hit_node_id() const {
    return data_->hit_node_id;
  }
 private:
  internal::HitTestResponse_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // blink::mojom

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_RENDER_ACCESSIBILITY_MOJOM_DATA_VIEW_H_