// third_party/blink/public/mojom/push_messaging/push_messaging.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_PUSH_MESSAGING_PUSH_MESSAGING_MOJOM_SHARED_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_PUSH_MESSAGING_PUSH_MESSAGING_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/push_messaging/push_messaging.mojom-shared-internal.h"
#include "third_party/blink/public/mojom/push_messaging/push_messaging_status.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "third_party/blink/public/mojom/push_messaging/push_messaging.mojom-data-view.h"
#include "base/component_export.h"




namespace std {

template <>
struct hash<::blink::mojom::PushErrorType>
    : public mojo::internal::EnumHashImpl<::blink::mojom::PushErrorType> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::PushErrorType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::PushErrorType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::PushErrorType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::PushSubscriptionOptionsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::PushSubscriptionOptionsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::PushSubscriptionOptions_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->user_visible_only = Traits::user_visible_only(input);

    decltype(Traits::application_server_key(input)) in_application_server_key = Traits::application_server_key(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->application_server_key)::BaseType>
        application_server_key_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& application_server_key_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
      in_application_server_key,
      application_server_key_fragment,
      &application_server_key_validate_params);

    fragment->application_server_key.Set(
        application_server_key_fragment.is_null() ? nullptr : application_server_key_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->application_server_key.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null application_server_key in PushSubscriptionOptions struct");
  }

  static bool Deserialize(::blink::mojom::internal::PushSubscriptionOptions_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::PushSubscriptionOptionsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::PushSubscriptionDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::PushSubscriptionDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::PushSubscription_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::endpoint(input)) in_endpoint = Traits::endpoint(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->endpoint)::BaseType> endpoint_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_endpoint,
      endpoint_fragment);

    fragment->endpoint.Set(
        endpoint_fragment.is_null() ? nullptr : endpoint_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->endpoint.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null endpoint in PushSubscription struct");

    decltype(Traits::expirationTime(input)) in_expirationTime = Traits::expirationTime(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->expirationTime)::BaseType> expirationTime_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::TimeDataView>(
      in_expirationTime,
      expirationTime_fragment);

    fragment->expirationTime.Set(
        expirationTime_fragment.is_null() ? nullptr : expirationTime_fragment.data());

    decltype(Traits::options(input)) in_options = Traits::options(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->options)::BaseType> options_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::blink::mojom::PushSubscriptionOptionsDataView>(
      in_options,
      options_fragment);

    fragment->options.Set(
        options_fragment.is_null() ? nullptr : options_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->options.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null options in PushSubscription struct");

    decltype(Traits::p256dh(input)) in_p256dh = Traits::p256dh(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->p256dh)::BaseType>
        p256dh_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& p256dh_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
      in_p256dh,
      p256dh_fragment,
      &p256dh_validate_params);

    fragment->p256dh.Set(
        p256dh_fragment.is_null() ? nullptr : p256dh_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->p256dh.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null p256dh in PushSubscription struct");

    decltype(Traits::auth(input)) in_auth = Traits::auth(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->auth)::BaseType>
        auth_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& auth_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
      in_auth,
      auth_fragment,
      &auth_validate_params);

    fragment->auth.Set(
        auth_fragment.is_null() ? nullptr : auth_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->auth.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null auth in PushSubscription struct");
  }

  static bool Deserialize(::blink::mojom::internal::PushSubscription_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::PushSubscriptionDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace blink::mojom {

inline void PushSubscriptionOptionsDataView::GetApplicationServerKeyDataView(
    mojo::ArrayDataView<uint8_t>* output) {
  auto pointer = data_->application_server_key.Get();
  *output = mojo::ArrayDataView<uint8_t>(pointer, message_);
}


inline void PushSubscriptionDataView::GetEndpointDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->endpoint.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void PushSubscriptionDataView::GetExpirationTimeDataView(
    ::mojo_base::mojom::TimeDataView* output) {
  auto pointer = data_->expirationTime.Get();
  *output = ::mojo_base::mojom::TimeDataView(pointer, message_);
}
inline void PushSubscriptionDataView::GetOptionsDataView(
    PushSubscriptionOptionsDataView* output) {
  auto pointer = data_->options.Get();
  *output = PushSubscriptionOptionsDataView(pointer, message_);
}
inline void PushSubscriptionDataView::GetP256dhDataView(
    mojo::ArrayDataView<uint8_t>* output) {
  auto pointer = data_->p256dh.Get();
  *output = mojo::ArrayDataView<uint8_t>(pointer, message_);
}
inline void PushSubscriptionDataView::GetAuthDataView(
    mojo::ArrayDataView<uint8_t>* output) {
  auto pointer = data_->auth.Get();
  *output = mojo::ArrayDataView<uint8_t>(pointer, message_);
}



}  // blink::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::blink::mojom::PushErrorType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::blink::mojom::PushErrorType value);
};

} // namespace perfetto

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_PUSH_MESSAGING_PUSH_MESSAGING_MOJOM_SHARED_H_