// third_party/blink/public/mojom/push_messaging/push_messaging.mojom-lite.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';


mojo.internal.exportModule('blink.mojom');





/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
blink.mojom.PushErrorTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
blink.mojom.PushErrorType = {
  
  ABORT: 0,
  NETWORK: 1,
  NONE: 2,
  NOT_ALLOWED: 3,
  NOT_FOUND: 4,
  NOT_SUPPORTED: 5,
  INVALID_STATE: 6,
  MIN_VALUE: 0,
  MAX_VALUE: 6,
};





/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.PushMessagingPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.PushMessaging.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { blink.mojom.PushMessagingInterface }
 */
blink.mojom.PushMessagingRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.PushMessagingPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.PushMessagingPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.PushMessagingPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !bigint } serviceWorkerRegistrationId
   * @param { !blink.mojom.PushSubscriptionOptions } options
   * @param { !boolean } userGesture
   * @return {!Promise<{
        status: !blink.mojom.PushRegistrationStatus,
        subscription: ?blink.mojom.PushSubscription,
   *  }>}
   */

  subscribe(
      serviceWorkerRegistrationId,
      options,
      userGesture) {
    return this.proxy.sendMessage(
        0,
        blink.mojom.PushMessaging_Subscribe_ParamsSpec.$,
        blink.mojom.PushMessaging_Subscribe_ResponseParamsSpec.$,
        [
          serviceWorkerRegistrationId,
          options,
          userGesture
        ],
        false);
  }

  
  /**
   * @param { !bigint } serviceWorkerRegistrationId
   * @return {!Promise<{
        errorType: !blink.mojom.PushErrorType,
        didUnsubscribe: !boolean,
        errorMessage: ?string,
   *  }>}
   */

  unsubscribe(
      serviceWorkerRegistrationId) {
    return this.proxy.sendMessage(
        1,
        blink.mojom.PushMessaging_Unsubscribe_ParamsSpec.$,
        blink.mojom.PushMessaging_Unsubscribe_ResponseParamsSpec.$,
        [
          serviceWorkerRegistrationId
        ],
        false);
  }

  
  /**
   * @param { !bigint } serviceWorkerRegistrationId
   * @return {!Promise<{
        status: !blink.mojom.PushGetRegistrationStatus,
        subscription: ?blink.mojom.PushSubscription,
   *  }>}
   */

  getSubscription(
      serviceWorkerRegistrationId) {
    return this.proxy.sendMessage(
        2,
        blink.mojom.PushMessaging_GetSubscription_ParamsSpec.$,
        blink.mojom.PushMessaging_GetSubscription_ResponseParamsSpec.$,
        [
          serviceWorkerRegistrationId
        ],
        false);
  }
};

/**
 * An object which receives request messages for the PushMessaging
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.PushMessagingReceiver = class {
  /**
   * @param {!blink.mojom.PushMessagingInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.PushMessagingRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.PushMessagingRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.PushMessagingRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.PushMessaging_Subscribe_ParamsSpec.$,
        blink.mojom.PushMessaging_Subscribe_ResponseParamsSpec.$,
        impl.subscribe.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        blink.mojom.PushMessaging_Unsubscribe_ParamsSpec.$,
        blink.mojom.PushMessaging_Unsubscribe_ResponseParamsSpec.$,
        impl.unsubscribe.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        blink.mojom.PushMessaging_GetSubscription_ParamsSpec.$,
        blink.mojom.PushMessaging_GetSubscription_ResponseParamsSpec.$,
        impl.getSubscription.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.PushMessaging = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.PushMessaging";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.PushMessagingRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.PushMessagingRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the PushMessaging
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.PushMessagingCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.PushMessagingRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.PushMessagingRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.subscribe =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.PushMessaging_Subscribe_ParamsSpec.$,
        blink.mojom.PushMessaging_Subscribe_ResponseParamsSpec.$,
        this.subscribe.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.unsubscribe =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        blink.mojom.PushMessaging_Unsubscribe_ParamsSpec.$,
        blink.mojom.PushMessaging_Unsubscribe_ResponseParamsSpec.$,
        this.unsubscribe.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getSubscription =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        blink.mojom.PushMessaging_GetSubscription_ParamsSpec.$,
        blink.mojom.PushMessaging_GetSubscription_ResponseParamsSpec.$,
        this.getSubscription.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};



/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.PushSubscriptionOptionsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.PushSubscriptionSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.PushMessaging_Subscribe_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.PushMessaging_Subscribe_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.PushMessaging_Unsubscribe_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.PushMessaging_Unsubscribe_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.PushMessaging_GetSubscription_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.PushMessaging_GetSubscription_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    blink.mojom.PushSubscriptionOptionsSpec.$,
    'PushSubscriptionOptions',
    [
      mojo.internal.StructField(
        'userVisibleOnly', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'applicationServerKey', 8,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
blink.mojom.PushSubscriptionOptions = class {
  constructor() {
    /** @export { !boolean } */
    this.userVisibleOnly;
    /** @export { !Array<!number> } */
    this.applicationServerKey;
  }
};



mojo.internal.Struct(
    blink.mojom.PushSubscriptionSpec.$,
    'PushSubscription',
    [
      mojo.internal.StructField(
        'endpoint', 0,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'expirationTime', 8,
        0,
        mojoBase.mojom.TimeSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'options', 16,
        0,
        blink.mojom.PushSubscriptionOptionsSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'p256dh', 24,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'auth', 32,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 48],]);





/** @record */
blink.mojom.PushSubscription = class {
  constructor() {
    /** @export { !url.mojom.Url } */
    this.endpoint;
    /** @export { (mojoBase.mojom.Time|undefined) } */
    this.expirationTime;
    /** @export { !blink.mojom.PushSubscriptionOptions } */
    this.options;
    /** @export { !Array<!number> } */
    this.p256dh;
    /** @export { !Array<!number> } */
    this.auth;
  }
};



mojo.internal.Struct(
    blink.mojom.PushMessaging_Subscribe_ParamsSpec.$,
    'PushMessaging_Subscribe_Params',
    [
      mojo.internal.StructField(
        'serviceWorkerRegistrationId', 0,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'options', 8,
        0,
        blink.mojom.PushSubscriptionOptionsSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'userGesture', 16,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);





/** @record */
blink.mojom.PushMessaging_Subscribe_Params = class {
  constructor() {
    /** @export { !bigint } */
    this.serviceWorkerRegistrationId;
    /** @export { !blink.mojom.PushSubscriptionOptions } */
    this.options;
    /** @export { !boolean } */
    this.userGesture;
  }
};



mojo.internal.Struct(
    blink.mojom.PushMessaging_Subscribe_ResponseParamsSpec.$,
    'PushMessaging_Subscribe_ResponseParams',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        blink.mojom.PushRegistrationStatusSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'subscription', 8,
        0,
        blink.mojom.PushSubscriptionSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
blink.mojom.PushMessaging_Subscribe_ResponseParams = class {
  constructor() {
    /** @export { !blink.mojom.PushRegistrationStatus } */
    this.status;
    /** @export { (blink.mojom.PushSubscription|undefined) } */
    this.subscription;
  }
};



mojo.internal.Struct(
    blink.mojom.PushMessaging_Unsubscribe_ParamsSpec.$,
    'PushMessaging_Unsubscribe_Params',
    [
      mojo.internal.StructField(
        'serviceWorkerRegistrationId', 0,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.PushMessaging_Unsubscribe_Params = class {
  constructor() {
    /** @export { !bigint } */
    this.serviceWorkerRegistrationId;
  }
};



mojo.internal.Struct(
    blink.mojom.PushMessaging_Unsubscribe_ResponseParamsSpec.$,
    'PushMessaging_Unsubscribe_ResponseParams',
    [
      mojo.internal.StructField(
        'errorType', 0,
        0,
        blink.mojom.PushErrorTypeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'didUnsubscribe', 4,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'errorMessage', 8,
        0,
        mojo.internal.String,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
blink.mojom.PushMessaging_Unsubscribe_ResponseParams = class {
  constructor() {
    /** @export { !blink.mojom.PushErrorType } */
    this.errorType;
    /** @export { !boolean } */
    this.didUnsubscribe;
    /** @export { (string|undefined) } */
    this.errorMessage;
  }
};



mojo.internal.Struct(
    blink.mojom.PushMessaging_GetSubscription_ParamsSpec.$,
    'PushMessaging_GetSubscription_Params',
    [
      mojo.internal.StructField(
        'serviceWorkerRegistrationId', 0,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.PushMessaging_GetSubscription_Params = class {
  constructor() {
    /** @export { !bigint } */
    this.serviceWorkerRegistrationId;
  }
};



mojo.internal.Struct(
    blink.mojom.PushMessaging_GetSubscription_ResponseParamsSpec.$,
    'PushMessaging_GetSubscription_ResponseParams',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        blink.mojom.PushGetRegistrationStatusSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'subscription', 8,
        0,
        blink.mojom.PushSubscriptionSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
blink.mojom.PushMessaging_GetSubscription_ResponseParams = class {
  constructor() {
    /** @export { !blink.mojom.PushGetRegistrationStatus } */
    this.status;
    /** @export { (blink.mojom.PushSubscription|undefined) } */
    this.subscription;
  }
};

