// third_party/blink/public/mojom/push_messaging/push_messaging.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_PUSH_MESSAGING_PUSH_MESSAGING_MOJOM_BLINK_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_PUSH_MESSAGING_PUSH_MESSAGING_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/push_messaging/push_messaging.mojom-features.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/push_messaging/push_messaging.mojom-shared.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/push_messaging/push_messaging.mojom-blink-forward.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/push_messaging/push_messaging_status.mojom-blink-forward.h"
#include "url/mojom/url.mojom-blink.h"
#include "mojo/public/mojom/base/time.mojom-blink.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "third_party/blink/renderer/platform/platform_export.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace blink::mojom::blink {

class PushMessagingProxy;

template <typename ImplRefTraits>
class PushMessagingStub;

class PushMessagingRequestValidator;
class PushMessagingResponseValidator;


class PLATFORM_EXPORT PushMessaging
    : public PushMessagingInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "blink.mojom.PushMessaging";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = PushMessagingInterfaceBase;
  using Proxy_ = PushMessagingProxy;

  template <typename ImplRefTraits>
  using Stub_ = PushMessagingStub<ImplRefTraits>;

  using RequestValidator_ = PushMessagingRequestValidator;
  using ResponseValidator_ = PushMessagingResponseValidator;
  enum MethodMinVersions : uint32_t {
    kSubscribeMinVersion = 0,
    kUnsubscribeMinVersion = 0,
    kGetSubscriptionMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct Subscribe_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Unsubscribe_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetSubscription_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~PushMessaging() = default;

  using SubscribeCallback = base::OnceCallback<void(::blink::mojom::blink::PushRegistrationStatus, PushSubscriptionPtr)>;
  using SubscribeMojoCallback = base::OnceCallback<void(::blink::mojom::blink::PushRegistrationStatus, PushSubscriptionPtr)>;

  virtual void Subscribe(int64_t service_worker_registration_id, PushSubscriptionOptionsPtr options, bool user_gesture, SubscribeCallback callback) = 0;

  using UnsubscribeCallback = base::OnceCallback<void(PushErrorType, bool, const ::blink::String&)>;
  using UnsubscribeMojoCallback = base::OnceCallback<void(PushErrorType, bool, const ::blink::String&)>;

  virtual void Unsubscribe(int64_t service_worker_registration_id, UnsubscribeCallback callback) = 0;

  using GetSubscriptionCallback = base::OnceCallback<void(::blink::mojom::blink::PushGetRegistrationStatus, PushSubscriptionPtr)>;
  using GetSubscriptionMojoCallback = base::OnceCallback<void(::blink::mojom::blink::PushGetRegistrationStatus, PushSubscriptionPtr)>;

  virtual void GetSubscription(int64_t service_worker_registration_id, GetSubscriptionCallback callback) = 0;
};



class PLATFORM_EXPORT PushMessagingProxy
    : public PushMessaging {
 public:
  using InterfaceType = PushMessaging;

  explicit PushMessagingProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void Subscribe(int64_t service_worker_registration_id, PushSubscriptionOptionsPtr options, bool user_gesture, SubscribeCallback callback) final;
  
  void Unsubscribe(int64_t service_worker_registration_id, UnsubscribeCallback callback) final;
  
  void GetSubscription(int64_t service_worker_registration_id, GetSubscriptionCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class PLATFORM_EXPORT PushMessagingStubDispatch {
 public:
  static bool Accept(PushMessaging* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      PushMessaging* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<PushMessaging>>
class PushMessagingStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  PushMessagingStub() = default;
  ~PushMessagingStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PushMessagingStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PushMessagingStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class PLATFORM_EXPORT PushMessagingRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class PLATFORM_EXPORT PushMessagingResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};









class PLATFORM_EXPORT PushSubscriptionOptions {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<PushSubscriptionOptions, T>::value>;
  using DataView = PushSubscriptionOptionsDataView;
  using Data_ = internal::PushSubscriptionOptions_Data;

  template <typename... Args>
  static PushSubscriptionOptionsPtr New(Args&&... args) {
    return PushSubscriptionOptionsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PushSubscriptionOptionsPtr From(const U& u) {
    return mojo::TypeConverter<PushSubscriptionOptionsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PushSubscriptionOptions>::Convert(*this);
  }


  PushSubscriptionOptions();

  PushSubscriptionOptions(
      bool user_visible_only,
      ::blink::Vector<uint8_t> application_server_key);


  ~PushSubscriptionOptions();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PushSubscriptionOptionsPtr>
  PushSubscriptionOptionsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, PushSubscriptionOptions::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, PushSubscriptionOptions::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, PushSubscriptionOptions::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PushSubscriptionOptions::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PushSubscriptionOptions::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PushSubscriptionOptions::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::PushSubscriptionOptions_UnserializedMessageContext<
            UserType, PushSubscriptionOptions::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<PushSubscriptionOptions::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return PushSubscriptionOptions::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::PushSubscriptionOptions_UnserializedMessageContext<
            UserType, PushSubscriptionOptions::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<PushSubscriptionOptions::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  bool user_visible_only;
  
  ::blink::Vector<uint8_t> application_server_key;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, PushSubscriptionOptions::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, PushSubscriptionOptions::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, PushSubscriptionOptions::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, PushSubscriptionOptions::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class PLATFORM_EXPORT PushSubscription {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<PushSubscription, T>::value>;
  using DataView = PushSubscriptionDataView;
  using Data_ = internal::PushSubscription_Data;

  template <typename... Args>
  static PushSubscriptionPtr New(Args&&... args) {
    return PushSubscriptionPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PushSubscriptionPtr From(const U& u) {
    return mojo::TypeConverter<PushSubscriptionPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PushSubscription>::Convert(*this);
  }


  PushSubscription();

  PushSubscription(
      const ::blink::KURL& endpoint,
      std::optional<::base::Time> expirationTime,
      PushSubscriptionOptionsPtr options,
      ::blink::Vector<uint8_t> p256dh,
      ::blink::Vector<uint8_t> auth);

PushSubscription(const PushSubscription&) = delete;
PushSubscription& operator=(const PushSubscription&) = delete;

  ~PushSubscription();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PushSubscriptionPtr>
  PushSubscriptionPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, PushSubscription::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, PushSubscription::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, PushSubscription::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PushSubscription::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PushSubscription::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PushSubscription::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::PushSubscription_UnserializedMessageContext<
            UserType, PushSubscription::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<PushSubscription::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return PushSubscription::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::PushSubscription_UnserializedMessageContext<
            UserType, PushSubscription::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<PushSubscription::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::KURL endpoint;
  
  std::optional<::base::Time> expirationTime;
  
  PushSubscriptionOptionsPtr options;
  
  ::blink::Vector<uint8_t> p256dh;
  
  ::blink::Vector<uint8_t> auth;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, PushSubscription::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, PushSubscription::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, PushSubscription::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, PushSubscription::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
PushSubscriptionOptionsPtr PushSubscriptionOptions::Clone() const {
  return New(
      mojo::Clone(user_visible_only),
      mojo::Clone(application_server_key)
  );
}

template <typename T, PushSubscriptionOptions::EnableIfSame<T>*>
bool PushSubscriptionOptions::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->user_visible_only, other_struct.user_visible_only))
    return false;
  if (!mojo::Equals(this->application_server_key, other_struct.application_server_key))
    return false;
  return true;
}

template <typename T, PushSubscriptionOptions::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.user_visible_only < rhs.user_visible_only)
    return true;
  if (rhs.user_visible_only < lhs.user_visible_only)
    return false;
  if (lhs.application_server_key < rhs.application_server_key)
    return true;
  if (rhs.application_server_key < lhs.application_server_key)
    return false;
  return false;
}
template <typename StructPtrType>
PushSubscriptionPtr PushSubscription::Clone() const {
  return New(
      mojo::Clone(endpoint),
      mojo::Clone(expirationTime),
      mojo::Clone(options),
      mojo::Clone(p256dh),
      mojo::Clone(auth)
  );
}

template <typename T, PushSubscription::EnableIfSame<T>*>
bool PushSubscription::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->endpoint, other_struct.endpoint))
    return false;
  if (!mojo::Equals(this->expirationTime, other_struct.expirationTime))
    return false;
  if (!mojo::Equals(this->options, other_struct.options))
    return false;
  if (!mojo::Equals(this->p256dh, other_struct.p256dh))
    return false;
  if (!mojo::Equals(this->auth, other_struct.auth))
    return false;
  return true;
}

template <typename T, PushSubscription::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.endpoint < rhs.endpoint)
    return true;
  if (rhs.endpoint < lhs.endpoint)
    return false;
  if (lhs.expirationTime < rhs.expirationTime)
    return true;
  if (rhs.expirationTime < lhs.expirationTime)
    return false;
  if (lhs.options < rhs.options)
    return true;
  if (rhs.options < lhs.options)
    return false;
  if (lhs.p256dh < rhs.p256dh)
    return true;
  if (rhs.p256dh < lhs.p256dh)
    return false;
  if (lhs.auth < rhs.auth)
    return true;
  if (rhs.auth < lhs.auth)
    return false;
  return false;
}


}  // blink::mojom::blink

namespace mojo {


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::PushSubscriptionOptions::DataView,
                                         ::blink::mojom::blink::PushSubscriptionOptionsPtr> {
  static bool IsNull(const ::blink::mojom::blink::PushSubscriptionOptionsPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::PushSubscriptionOptionsPtr* output) { output->reset(); }

  static decltype(::blink::mojom::blink::PushSubscriptionOptions::user_visible_only) user_visible_only(
      const ::blink::mojom::blink::PushSubscriptionOptionsPtr& input) {
    return input->user_visible_only;
  }

  static const decltype(::blink::mojom::blink::PushSubscriptionOptions::application_server_key)& application_server_key(
      const ::blink::mojom::blink::PushSubscriptionOptionsPtr& input) {
    return input->application_server_key;
  }

  static bool Read(::blink::mojom::blink::PushSubscriptionOptions::DataView input, ::blink::mojom::blink::PushSubscriptionOptionsPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::PushSubscription::DataView,
                                         ::blink::mojom::blink::PushSubscriptionPtr> {
  static bool IsNull(const ::blink::mojom::blink::PushSubscriptionPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::PushSubscriptionPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::blink::PushSubscription::endpoint)& endpoint(
      const ::blink::mojom::blink::PushSubscriptionPtr& input) {
    return input->endpoint;
  }

  static const decltype(::blink::mojom::blink::PushSubscription::expirationTime)& expirationTime(
      const ::blink::mojom::blink::PushSubscriptionPtr& input) {
    return input->expirationTime;
  }

  static const decltype(::blink::mojom::blink::PushSubscription::options)& options(
      const ::blink::mojom::blink::PushSubscriptionPtr& input) {
    return input->options;
  }

  static const decltype(::blink::mojom::blink::PushSubscription::p256dh)& p256dh(
      const ::blink::mojom::blink::PushSubscriptionPtr& input) {
    return input->p256dh;
  }

  static const decltype(::blink::mojom::blink::PushSubscription::auth)& auth(
      const ::blink::mojom::blink::PushSubscriptionPtr& input) {
    return input->auth;
  }

  static bool Read(::blink::mojom::blink::PushSubscription::DataView input, ::blink::mojom::blink::PushSubscriptionPtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_PUSH_MESSAGING_PUSH_MESSAGING_MOJOM_BLINK_H_