// third_party/blink/public/mojom/private_aggregation/private_aggregation_host.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'third_party/blink/public/mojom/private_aggregation/private_aggregation_host.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('blink.mojom');
  var aggregatable_report$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/aggregation_service/aggregatable_report.mojom', '../aggregation_service/aggregatable_report.mojom.js');
  }


  var PrivateAggregationErrorEvent = {};
  PrivateAggregationErrorEvent.kReportSuccess = 0;
  PrivateAggregationErrorEvent.kTooManyContributions = 1;
  PrivateAggregationErrorEvent.kEmptyReportDropped = 2;
  PrivateAggregationErrorEvent.kPendingReportLimitReached = 3;
  PrivateAggregationErrorEvent.kInsufficientBudget = 4;
  PrivateAggregationErrorEvent.kContributionTimeoutReached = 5;
  PrivateAggregationErrorEvent.kAlreadyTriggeredExternalError = 6;
  PrivateAggregationErrorEvent.MIN_VALUE = 0;
  PrivateAggregationErrorEvent.MAX_VALUE = 6;

  PrivateAggregationErrorEvent.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
    case 4:
    case 5:
    case 6:
      return true;
    }
    return false;
  };

  PrivateAggregationErrorEvent.toKnownEnumValue = function(value) {
    return value;
  };

  PrivateAggregationErrorEvent.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };

  function DebugKey(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  DebugKey.prototype.initDefaults_ = function() {
    this.value = 0;
  };
  DebugKey.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  DebugKey.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  DebugKey.encodedSize = codec.kStructHeaderSize + 8;

  DebugKey.decode = function(decoder) {
    var packed;
    var val = new DebugKey();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.value =
        decoder.decodeStruct(codec.Uint64);
    return val;
  };

  DebugKey.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(DebugKey.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Uint64, val.value);
  };
  function DebugModeDetails(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  DebugModeDetails.prototype.initDefaults_ = function() {
    this.isEnabled = false;
    this.debugKey = null;
  };
  DebugModeDetails.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  DebugModeDetails.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    // validate DebugModeDetails.debugKey
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, DebugKey, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  DebugModeDetails.encodedSize = codec.kStructHeaderSize + 16;

  DebugModeDetails.decode = function(decoder) {
    var packed;
    var val = new DebugModeDetails();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.isEnabled = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.debugKey =
        decoder.decodeStructPointer(DebugKey);
    return val;
  };

  DebugModeDetails.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(DebugModeDetails.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.isEnabled & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(DebugKey, val.debugKey);
  };
  function PrivateAggregationHost_ContributeToHistogram_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  PrivateAggregationHost_ContributeToHistogram_Params.prototype.initDefaults_ = function() {
    this.contributions = null;
  };
  PrivateAggregationHost_ContributeToHistogram_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  PrivateAggregationHost_ContributeToHistogram_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate PrivateAggregationHost_ContributeToHistogram_Params.contributions
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 8, new codec.PointerTo(aggregatable_report$.AggregatableReportHistogramContribution), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  PrivateAggregationHost_ContributeToHistogram_Params.encodedSize = codec.kStructHeaderSize + 8;

  PrivateAggregationHost_ContributeToHistogram_Params.decode = function(decoder) {
    var packed;
    var val = new PrivateAggregationHost_ContributeToHistogram_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.contributions =
        decoder.decodeArrayPointer(new codec.PointerTo(aggregatable_report$.AggregatableReportHistogramContribution));
    return val;
  };

  PrivateAggregationHost_ContributeToHistogram_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(PrivateAggregationHost_ContributeToHistogram_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(new codec.PointerTo(aggregatable_report$.AggregatableReportHistogramContribution), val.contributions);
  };
  function PrivateAggregationHost_ContributeToHistogramOnEvent_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  PrivateAggregationHost_ContributeToHistogramOnEvent_Params.prototype.initDefaults_ = function() {
    this.errorEvent = 0;
    this.contributions = null;
  };
  PrivateAggregationHost_ContributeToHistogramOnEvent_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  PrivateAggregationHost_ContributeToHistogramOnEvent_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate PrivateAggregationHost_ContributeToHistogramOnEvent_Params.errorEvent
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, PrivateAggregationErrorEvent);
    if (err !== validator.validationError.NONE)
        return err;


    // validate PrivateAggregationHost_ContributeToHistogramOnEvent_Params.contributions
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 8, 8, new codec.PointerTo(aggregatable_report$.AggregatableReportHistogramContribution), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  PrivateAggregationHost_ContributeToHistogramOnEvent_Params.encodedSize = codec.kStructHeaderSize + 16;

  PrivateAggregationHost_ContributeToHistogramOnEvent_Params.decode = function(decoder) {
    var packed;
    var val = new PrivateAggregationHost_ContributeToHistogramOnEvent_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.errorEvent =
        decoder.decodeStruct(new codec.Enum(PrivateAggregationErrorEvent));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.contributions =
        decoder.decodeArrayPointer(new codec.PointerTo(aggregatable_report$.AggregatableReportHistogramContribution));
    return val;
  };

  PrivateAggregationHost_ContributeToHistogramOnEvent_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(PrivateAggregationHost_ContributeToHistogramOnEvent_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.errorEvent);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeArrayPointer(new codec.PointerTo(aggregatable_report$.AggregatableReportHistogramContribution), val.contributions);
  };
  function PrivateAggregationHost_EnableDebugMode_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  PrivateAggregationHost_EnableDebugMode_Params.prototype.initDefaults_ = function() {
    this.debugKey = null;
  };
  PrivateAggregationHost_EnableDebugMode_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  PrivateAggregationHost_EnableDebugMode_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate PrivateAggregationHost_EnableDebugMode_Params.debugKey
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, DebugKey, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  PrivateAggregationHost_EnableDebugMode_Params.encodedSize = codec.kStructHeaderSize + 8;

  PrivateAggregationHost_EnableDebugMode_Params.decode = function(decoder) {
    var packed;
    var val = new PrivateAggregationHost_EnableDebugMode_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.debugKey =
        decoder.decodeStructPointer(DebugKey);
    return val;
  };

  PrivateAggregationHost_EnableDebugMode_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(PrivateAggregationHost_EnableDebugMode_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(DebugKey, val.debugKey);
  };
  var kPrivateAggregationHost_ContributeToHistogram_Name = 0;
  var kPrivateAggregationHost_ContributeToHistogramOnEvent_Name = 1;
  var kPrivateAggregationHost_EnableDebugMode_Name = 2;

  function PrivateAggregationHostPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(PrivateAggregationHost,
                                                   handleOrPtrInfo);
  }

  function PrivateAggregationHostAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        PrivateAggregationHost, associatedInterfacePtrInfo);
  }

  PrivateAggregationHostAssociatedPtr.prototype =
      Object.create(PrivateAggregationHostPtr.prototype);
  PrivateAggregationHostAssociatedPtr.prototype.constructor =
      PrivateAggregationHostAssociatedPtr;

  function PrivateAggregationHostProxy(receiver) {
    this.receiver_ = receiver;
  }
  PrivateAggregationHostPtr.prototype.contributeToHistogram = function() {
    return PrivateAggregationHostProxy.prototype.contributeToHistogram
        .apply(this.ptr.getProxy(), arguments);
  };

  PrivateAggregationHostProxy.prototype.contributeToHistogram = function(contributions) {
    var params_ = new PrivateAggregationHost_ContributeToHistogram_Params();
    params_.contributions = contributions;
    var builder = new codec.MessageV0Builder(
        kPrivateAggregationHost_ContributeToHistogram_Name,
        codec.align(PrivateAggregationHost_ContributeToHistogram_Params.encodedSize));
    builder.encodeStruct(PrivateAggregationHost_ContributeToHistogram_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  PrivateAggregationHostPtr.prototype.contributeToHistogramOnEvent = function() {
    return PrivateAggregationHostProxy.prototype.contributeToHistogramOnEvent
        .apply(this.ptr.getProxy(), arguments);
  };

  PrivateAggregationHostProxy.prototype.contributeToHistogramOnEvent = function(errorEvent, contributions) {
    var params_ = new PrivateAggregationHost_ContributeToHistogramOnEvent_Params();
    params_.errorEvent = errorEvent;
    params_.contributions = contributions;
    var builder = new codec.MessageV0Builder(
        kPrivateAggregationHost_ContributeToHistogramOnEvent_Name,
        codec.align(PrivateAggregationHost_ContributeToHistogramOnEvent_Params.encodedSize));
    builder.encodeStruct(PrivateAggregationHost_ContributeToHistogramOnEvent_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  PrivateAggregationHostPtr.prototype.enableDebugMode = function() {
    return PrivateAggregationHostProxy.prototype.enableDebugMode
        .apply(this.ptr.getProxy(), arguments);
  };

  PrivateAggregationHostProxy.prototype.enableDebugMode = function(debugKey) {
    var params_ = new PrivateAggregationHost_EnableDebugMode_Params();
    params_.debugKey = debugKey;
    var builder = new codec.MessageV0Builder(
        kPrivateAggregationHost_EnableDebugMode_Name,
        codec.align(PrivateAggregationHost_EnableDebugMode_Params.encodedSize));
    builder.encodeStruct(PrivateAggregationHost_EnableDebugMode_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function PrivateAggregationHostStub(delegate) {
    this.delegate_ = delegate;
  }
  PrivateAggregationHostStub.prototype.contributeToHistogram = function(contributions) {
    return this.delegate_ && this.delegate_.contributeToHistogram && this.delegate_.contributeToHistogram(contributions);
  }
  PrivateAggregationHostStub.prototype.contributeToHistogramOnEvent = function(errorEvent, contributions) {
    return this.delegate_ && this.delegate_.contributeToHistogramOnEvent && this.delegate_.contributeToHistogramOnEvent(errorEvent, contributions);
  }
  PrivateAggregationHostStub.prototype.enableDebugMode = function(debugKey) {
    return this.delegate_ && this.delegate_.enableDebugMode && this.delegate_.enableDebugMode(debugKey);
  }

  PrivateAggregationHostStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kPrivateAggregationHost_ContributeToHistogram_Name:
      var params = reader.decodeStruct(PrivateAggregationHost_ContributeToHistogram_Params);
      this.contributeToHistogram(params.contributions);
      return true;
    case kPrivateAggregationHost_ContributeToHistogramOnEvent_Name:
      var params = reader.decodeStruct(PrivateAggregationHost_ContributeToHistogramOnEvent_Params);
      this.contributeToHistogramOnEvent(params.errorEvent, params.contributions);
      return true;
    case kPrivateAggregationHost_EnableDebugMode_Name:
      var params = reader.decodeStruct(PrivateAggregationHost_EnableDebugMode_Params);
      this.enableDebugMode(params.debugKey);
      return true;
    default:
      return false;
    }
  };

  PrivateAggregationHostStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  function validatePrivateAggregationHostRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kPrivateAggregationHost_ContributeToHistogram_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = PrivateAggregationHost_ContributeToHistogram_Params;
      break;
      case kPrivateAggregationHost_ContributeToHistogramOnEvent_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = PrivateAggregationHost_ContributeToHistogramOnEvent_Params;
      break;
      case kPrivateAggregationHost_EnableDebugMode_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = PrivateAggregationHost_EnableDebugMode_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validatePrivateAggregationHostResponse(messageValidator) {
    return validator.validationError.NONE;
  }

  var PrivateAggregationHost = {
    name: 'blink.mojom.PrivateAggregationHost',
    kVersion: 0,
    ptrClass: PrivateAggregationHostPtr,
    proxyClass: PrivateAggregationHostProxy,
    stubClass: PrivateAggregationHostStub,
    validateRequest: validatePrivateAggregationHostRequest,
    validateResponse: null,
  };
  PrivateAggregationHostStub.prototype.validator = validatePrivateAggregationHostRequest;
  PrivateAggregationHostProxy.prototype.validator = null;
  exports.PrivateAggregationErrorEvent = PrivateAggregationErrorEvent;
  exports.DebugKey = DebugKey;
  exports.DebugModeDetails = DebugModeDetails;
  exports.PrivateAggregationHost = PrivateAggregationHost;
  exports.PrivateAggregationHostPtr = PrivateAggregationHostPtr;
  exports.PrivateAggregationHostAssociatedPtr = PrivateAggregationHostAssociatedPtr;
})();