// third_party/blink/public/mojom/private_aggregation/private_aggregation_host.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_PRIVATE_AGGREGATION_PRIVATE_AGGREGATION_HOST_MOJOM_BLINK_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_PRIVATE_AGGREGATION_PRIVATE_AGGREGATION_HOST_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/private_aggregation/private_aggregation_host.mojom-features.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/private_aggregation/private_aggregation_host.mojom-shared.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/private_aggregation/private_aggregation_host.mojom-blink-forward.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/aggregation_service/aggregatable_report.mojom-blink-forward.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "third_party/blink/renderer/platform/platform_export.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace blink::mojom::blink {

class PrivateAggregationHostProxy;

template <typename ImplRefTraits>
class PrivateAggregationHostStub;

class PrivateAggregationHostRequestValidator;


class PLATFORM_EXPORT PrivateAggregationHost
    : public PrivateAggregationHostInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "blink.mojom.PrivateAggregationHost";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = PrivateAggregationHostInterfaceBase;
  using Proxy_ = PrivateAggregationHostProxy;

  template <typename ImplRefTraits>
  using Stub_ = PrivateAggregationHostStub<ImplRefTraits>;

  using RequestValidator_ = PrivateAggregationHostRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kContributeToHistogramMinVersion = 0,
    kContributeToHistogramOnEventMinVersion = 0,
    kEnableDebugModeMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct ContributeToHistogram_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ContributeToHistogramOnEvent_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct EnableDebugMode_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~PrivateAggregationHost() = default;

  virtual void ContributeToHistogram(::blink::Vector<::blink::mojom::blink::AggregatableReportHistogramContributionPtr> contributions) = 0;

  virtual void ContributeToHistogramOnEvent(PrivateAggregationErrorEvent error_event, ::blink::Vector<::blink::mojom::blink::AggregatableReportHistogramContributionPtr> contributions) = 0;

  virtual void EnableDebugMode(DebugKeyPtr debug_key) = 0;
};



class PLATFORM_EXPORT PrivateAggregationHostProxy
    : public PrivateAggregationHost {
 public:
  using InterfaceType = PrivateAggregationHost;

  explicit PrivateAggregationHostProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void ContributeToHistogram(::blink::Vector<::blink::mojom::blink::AggregatableReportHistogramContributionPtr> contributions) final;
  
  void ContributeToHistogramOnEvent(PrivateAggregationErrorEvent error_event, ::blink::Vector<::blink::mojom::blink::AggregatableReportHistogramContributionPtr> contributions) final;
  
  void EnableDebugMode(DebugKeyPtr debug_key) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class PLATFORM_EXPORT PrivateAggregationHostStubDispatch {
 public:
  static bool Accept(PrivateAggregationHost* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      PrivateAggregationHost* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<PrivateAggregationHost>>
class PrivateAggregationHostStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  PrivateAggregationHostStub() = default;
  ~PrivateAggregationHostStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PrivateAggregationHostStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PrivateAggregationHostStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class PLATFORM_EXPORT PrivateAggregationHostRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





class PLATFORM_EXPORT DebugKey {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<DebugKey, T>::value>;
  using DataView = DebugKeyDataView;
  using Data_ = internal::DebugKey_Data;

  template <typename... Args>
  static DebugKeyPtr New(Args&&... args) {
    return DebugKeyPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static DebugKeyPtr From(const U& u) {
    return mojo::TypeConverter<DebugKeyPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, DebugKey>::Convert(*this);
  }


  DebugKey();

  explicit DebugKey(
      uint64_t value);


  ~DebugKey();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = DebugKeyPtr>
  DebugKeyPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, DebugKey::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, DebugKey::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, DebugKey::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DebugKey::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DebugKey::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        DebugKey::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::DebugKey_UnserializedMessageContext<
            UserType, DebugKey::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<DebugKey::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return DebugKey::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::DebugKey_UnserializedMessageContext<
            UserType, DebugKey::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<DebugKey::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  uint64_t value;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, DebugKey::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, DebugKey::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, DebugKey::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, DebugKey::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}









class PLATFORM_EXPORT DebugModeDetails {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<DebugModeDetails, T>::value>;
  using DataView = DebugModeDetailsDataView;
  using Data_ = internal::DebugModeDetails_Data;

  template <typename... Args>
  static DebugModeDetailsPtr New(Args&&... args) {
    return DebugModeDetailsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static DebugModeDetailsPtr From(const U& u) {
    return mojo::TypeConverter<DebugModeDetailsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, DebugModeDetails>::Convert(*this);
  }


  DebugModeDetails();

  DebugModeDetails(
      bool is_enabled,
      DebugKeyPtr debug_key);

DebugModeDetails(const DebugModeDetails&) = delete;
DebugModeDetails& operator=(const DebugModeDetails&) = delete;

  ~DebugModeDetails();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = DebugModeDetailsPtr>
  DebugModeDetailsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, DebugModeDetails::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, DebugModeDetails::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, DebugModeDetails::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DebugModeDetails::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DebugModeDetails::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        DebugModeDetails::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::DebugModeDetails_UnserializedMessageContext<
            UserType, DebugModeDetails::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<DebugModeDetails::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return DebugModeDetails::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::DebugModeDetails_UnserializedMessageContext<
            UserType, DebugModeDetails::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<DebugModeDetails::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  bool is_enabled;
  
  DebugKeyPtr debug_key;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, DebugModeDetails::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, DebugModeDetails::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, DebugModeDetails::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, DebugModeDetails::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
DebugKeyPtr DebugKey::Clone() const {
  return New(
      mojo::Clone(value)
  );
}

template <typename T, DebugKey::EnableIfSame<T>*>
bool DebugKey::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->value, other_struct.value))
    return false;
  return true;
}

template <typename T, DebugKey::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.value < rhs.value)
    return true;
  if (rhs.value < lhs.value)
    return false;
  return false;
}
template <typename StructPtrType>
DebugModeDetailsPtr DebugModeDetails::Clone() const {
  return New(
      mojo::Clone(is_enabled),
      mojo::Clone(debug_key)
  );
}

template <typename T, DebugModeDetails::EnableIfSame<T>*>
bool DebugModeDetails::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->is_enabled, other_struct.is_enabled))
    return false;
  if (!mojo::Equals(this->debug_key, other_struct.debug_key))
    return false;
  return true;
}

template <typename T, DebugModeDetails::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.is_enabled < rhs.is_enabled)
    return true;
  if (rhs.is_enabled < lhs.is_enabled)
    return false;
  if (lhs.debug_key < rhs.debug_key)
    return true;
  if (rhs.debug_key < lhs.debug_key)
    return false;
  return false;
}


}  // blink::mojom::blink

namespace mojo {


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::DebugKey::DataView,
                                         ::blink::mojom::blink::DebugKeyPtr> {
  static bool IsNull(const ::blink::mojom::blink::DebugKeyPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::DebugKeyPtr* output) { output->reset(); }

  static decltype(::blink::mojom::blink::DebugKey::value) value(
      const ::blink::mojom::blink::DebugKeyPtr& input) {
    return input->value;
  }

  static bool Read(::blink::mojom::blink::DebugKey::DataView input, ::blink::mojom::blink::DebugKeyPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::DebugModeDetails::DataView,
                                         ::blink::mojom::blink::DebugModeDetailsPtr> {
  static bool IsNull(const ::blink::mojom::blink::DebugModeDetailsPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::DebugModeDetailsPtr* output) { output->reset(); }

  static decltype(::blink::mojom::blink::DebugModeDetails::is_enabled) is_enabled(
      const ::blink::mojom::blink::DebugModeDetailsPtr& input) {
    return input->is_enabled;
  }

  static const decltype(::blink::mojom::blink::DebugModeDetails::debug_key)& debug_key(
      const ::blink::mojom::blink::DebugModeDetailsPtr& input) {
    return input->debug_key;
  }

  static bool Read(::blink::mojom::blink::DebugModeDetails::DataView input, ::blink::mojom::blink::DebugModeDetailsPtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_PRIVATE_AGGREGATION_PRIVATE_AGGREGATION_HOST_MOJOM_BLINK_H_