// third_party/blink/public/mojom/printing/web_printing.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'third_party/blink/public/mojom/printing/web_printing.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('blink.mojom');
  var blob$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/blob/blob.mojom', '../blob/blob.mojom.js');
  }
  var geometry$ =
      mojo.internal.exposeNamespace('gfx.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'ui/gfx/geometry/mojom/geometry.mojom', '../../../../../ui/gfx/geometry/mojom/geometry.mojom.js');
  }


  var WebPrintingMultipleDocumentHandling = {};
  WebPrintingMultipleDocumentHandling.kSeparateDocumentsCollatedCopies = 0;
  WebPrintingMultipleDocumentHandling.kSeparateDocumentsUncollatedCopies = 1;
  WebPrintingMultipleDocumentHandling.MIN_VALUE = 0;
  WebPrintingMultipleDocumentHandling.MAX_VALUE = 1;

  WebPrintingMultipleDocumentHandling.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
      return true;
    }
    return false;
  };

  WebPrintingMultipleDocumentHandling.toKnownEnumValue = function(value) {
    return value;
  };

  WebPrintingMultipleDocumentHandling.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var WebPrintingSides = {};
  WebPrintingSides.kOneSided = 0;
  WebPrintingSides.kTwoSidedLongEdge = 1;
  WebPrintingSides.kTwoSidedShortEdge = 2;
  WebPrintingSides.MIN_VALUE = 0;
  WebPrintingSides.MAX_VALUE = 2;

  WebPrintingSides.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
      return true;
    }
    return false;
  };

  WebPrintingSides.toKnownEnumValue = function(value) {
    return value;
  };

  WebPrintingSides.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var WebPrintQuality = {};
  WebPrintQuality.kDraft = 0;
  WebPrintQuality.kNormal = 1;
  WebPrintQuality.kHigh = 2;
  WebPrintQuality.MIN_VALUE = 0;
  WebPrintQuality.MAX_VALUE = 2;

  WebPrintQuality.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
      return true;
    }
    return false;
  };

  WebPrintQuality.toKnownEnumValue = function(value) {
    return value;
  };

  WebPrintQuality.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var WebPrintColorMode = {};
  WebPrintColorMode.kColor = 0;
  WebPrintColorMode.kMonochrome = 1;
  WebPrintColorMode.MIN_VALUE = 0;
  WebPrintColorMode.MAX_VALUE = 1;

  WebPrintColorMode.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
      return true;
    }
    return false;
  };

  WebPrintColorMode.toKnownEnumValue = function(value) {
    return value;
  };

  WebPrintColorMode.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var WebPrintingOrientationRequested = {};
  WebPrintingOrientationRequested.kPortrait = 0;
  WebPrintingOrientationRequested.kLandscape = 1;
  WebPrintingOrientationRequested.MIN_VALUE = 0;
  WebPrintingOrientationRequested.MAX_VALUE = 1;

  WebPrintingOrientationRequested.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
      return true;
    }
    return false;
  };

  WebPrintingOrientationRequested.toKnownEnumValue = function(value) {
    return value;
  };

  WebPrintingOrientationRequested.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var WebPrinterState = {};
  WebPrinterState.kIdle = 0;
  WebPrinterState.kProcessing = 1;
  WebPrinterState.kStopped = 2;
  WebPrinterState.MIN_VALUE = 0;
  WebPrinterState.MAX_VALUE = 2;

  WebPrinterState.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
      return true;
    }
    return false;
  };

  WebPrinterState.toKnownEnumValue = function(value) {
    return value;
  };

  WebPrinterState.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var WebPrinterStateReason = {};
  WebPrinterStateReason.kNone = 0;
  WebPrinterStateReason.kOther = 1;
  WebPrinterStateReason.kConnectingToDevice = 2;
  WebPrinterStateReason.kCoverOpen = 3;
  WebPrinterStateReason.kDeveloperEmpty = 4;
  WebPrinterStateReason.kDeveloperLow = 5;
  WebPrinterStateReason.kDoorOpen = 6;
  WebPrinterStateReason.kFuserOverTemp = 7;
  WebPrinterStateReason.kFuserUnderTemp = 8;
  WebPrinterStateReason.kInputTrayMissing = 9;
  WebPrinterStateReason.kInterlockOpen = 10;
  WebPrinterStateReason.kInterpreterResourceUnavailable = 11;
  WebPrinterStateReason.kMarkerSupplyEmpty = 12;
  WebPrinterStateReason.kMarkerSupplyLow = 13;
  WebPrinterStateReason.kMarkerWasteAlmostFull = 14;
  WebPrinterStateReason.kMarkerWasteFull = 15;
  WebPrinterStateReason.kMediaEmpty = 16;
  WebPrinterStateReason.kMediaJam = 17;
  WebPrinterStateReason.kMediaLow = 18;
  WebPrinterStateReason.kMediaNeeded = 19;
  WebPrinterStateReason.kMovingToPaused = 20;
  WebPrinterStateReason.kOpcLifeOver = 21;
  WebPrinterStateReason.kOpcNearEol = 22;
  WebPrinterStateReason.kOutputAreaAlmostFull = 23;
  WebPrinterStateReason.kOutputAreaFull = 24;
  WebPrinterStateReason.kOutputTrayMissing = 25;
  WebPrinterStateReason.kPaused = 26;
  WebPrinterStateReason.kShutdown = 27;
  WebPrinterStateReason.kSpoolAreaFull = 28;
  WebPrinterStateReason.kStoppedPartly = 29;
  WebPrinterStateReason.kStopping = 30;
  WebPrinterStateReason.kTimedOut = 31;
  WebPrinterStateReason.kTonerEmpty = 32;
  WebPrinterStateReason.kTonerLow = 33;
  WebPrinterStateReason.kCupsPkiExpired = 34;
  WebPrinterStateReason.MIN_VALUE = 0;
  WebPrinterStateReason.MAX_VALUE = 34;

  WebPrinterStateReason.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
    case 4:
    case 5:
    case 6:
    case 7:
    case 8:
    case 9:
    case 10:
    case 11:
    case 12:
    case 13:
    case 14:
    case 15:
    case 16:
    case 17:
    case 18:
    case 19:
    case 20:
    case 21:
    case 22:
    case 23:
    case 24:
    case 25:
    case 26:
    case 27:
    case 28:
    case 29:
    case 30:
    case 31:
    case 32:
    case 33:
    case 34:
      return true;
    }
    return false;
  };

  WebPrinterStateReason.toKnownEnumValue = function(value) {
    return value;
  };

  WebPrinterStateReason.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var WebPrintJobState = {};
  WebPrintJobState.kPending = 0;
  WebPrintJobState.kProcessing = 1;
  WebPrintJobState.kCompleted = 2;
  WebPrintJobState.kCanceled = 3;
  WebPrintJobState.kAborted = 4;
  WebPrintJobState.MIN_VALUE = 0;
  WebPrintJobState.MAX_VALUE = 4;

  WebPrintJobState.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
    case 4:
      return true;
    }
    return false;
  };

  WebPrintJobState.toKnownEnumValue = function(value) {
    return value;
  };

  WebPrintJobState.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var GetPrintersError = {};
  GetPrintersError.kUserPermissionDenied = 0;
  GetPrintersError.MIN_VALUE = 0;
  GetPrintersError.MAX_VALUE = 0;

  GetPrintersError.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
      return true;
    }
    return false;
  };

  GetPrintersError.toKnownEnumValue = function(value) {
    return value;
  };

  GetPrintersError.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var WebPrinterFetchError = {};
  WebPrinterFetchError.kPrinterUnreachable = 0;
  WebPrinterFetchError.kUserPermissionDenied = 1;
  WebPrinterFetchError.MIN_VALUE = 0;
  WebPrinterFetchError.MAX_VALUE = 1;

  WebPrinterFetchError.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
      return true;
    }
    return false;
  };

  WebPrinterFetchError.toKnownEnumValue = function(value) {
    return value;
  };

  WebPrinterFetchError.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var WebPrintError = {};
  WebPrintError.kPrinterUnreachable = 0;
  WebPrintError.kDocumentMalformed = 1;
  WebPrintError.kPrintJobTemplateAttributesMismatch = 2;
  WebPrintError.kUserPermissionDenied = 3;
  WebPrintError.MIN_VALUE = 0;
  WebPrintError.MAX_VALUE = 3;

  WebPrintError.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
      return true;
    }
    return false;
  };

  WebPrintError.toKnownEnumValue = function(value) {
    return value;
  };

  WebPrintError.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };

  function WebPrinterInfo(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  WebPrinterInfo.prototype.initDefaults_ = function() {
    this.printerName = null;
    this.printerId = null;
    this.printerRemote = new WebPrinterPtr();
  };
  WebPrinterInfo.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  WebPrinterInfo.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WebPrinterInfo.printerName
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate WebPrinterInfo.printerId
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate WebPrinterInfo.printerRemote
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 16, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  WebPrinterInfo.encodedSize = codec.kStructHeaderSize + 24;

  WebPrinterInfo.decode = function(decoder) {
    var packed;
    var val = new WebPrinterInfo();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.printerName =
        decoder.decodeStruct(codec.String);
    val.printerId =
        decoder.decodeStruct(codec.String);
    val.printerRemote =
        decoder.decodeStruct(new codec.Interface(WebPrinterPtr));
    return val;
  };

  WebPrinterInfo.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(WebPrinterInfo.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.printerName);
    encoder.encodeStruct(codec.String, val.printerId);
    encoder.encodeStruct(new codec.Interface(WebPrinterPtr), val.printerRemote);
  };
  function WebPrintingRange(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  WebPrintingRange.prototype.initDefaults_ = function() {
    this.from = 0;
    this.to = 0;
  };
  WebPrintingRange.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  WebPrintingRange.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    return validator.validationError.NONE;
  };

  WebPrintingRange.encodedSize = codec.kStructHeaderSize + 8;

  WebPrintingRange.decode = function(decoder) {
    var packed;
    var val = new WebPrintingRange();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.from =
        decoder.decodeStruct(codec.Uint32);
    val.to =
        decoder.decodeStruct(codec.Uint32);
    return val;
  };

  WebPrintingRange.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(WebPrintingRange.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Uint32, val.from);
    encoder.encodeStruct(codec.Uint32, val.to);
  };
  function WebPrintingMediaSize(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  WebPrintingMediaSize.prototype.initDefaults_ = function() {
    this.xDimension = null;
    this.yDimension = null;
  };
  WebPrintingMediaSize.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  WebPrintingMediaSize.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 40}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WebPrintingMediaSize.xDimension
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 0, WebPrintingMediaSizeDimension, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WebPrintingMediaSize.yDimension
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 16, WebPrintingMediaSizeDimension, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  WebPrintingMediaSize.encodedSize = codec.kStructHeaderSize + 32;

  WebPrintingMediaSize.decode = function(decoder) {
    var packed;
    var val = new WebPrintingMediaSize();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.xDimension =
        decoder.decodeStruct(WebPrintingMediaSizeDimension);
    val.yDimension =
        decoder.decodeStruct(WebPrintingMediaSizeDimension);
    return val;
  };

  WebPrintingMediaSize.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(WebPrintingMediaSize.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(WebPrintingMediaSizeDimension, val.xDimension);
    encoder.encodeStruct(WebPrintingMediaSizeDimension, val.yDimension);
  };
  function WebPrintingMediaCollection(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  WebPrintingMediaCollection.prototype.initDefaults_ = function() {
    this.mediaSize = null;
    this.mediaSizeName = null;
  };
  WebPrintingMediaCollection.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  WebPrintingMediaCollection.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WebPrintingMediaCollection.mediaSize
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, WebPrintingMediaSize, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WebPrintingMediaCollection.mediaSizeName
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  WebPrintingMediaCollection.encodedSize = codec.kStructHeaderSize + 16;

  WebPrintingMediaCollection.decode = function(decoder) {
    var packed;
    var val = new WebPrintingMediaCollection();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.mediaSize =
        decoder.decodeStructPointer(WebPrintingMediaSize);
    val.mediaSizeName =
        decoder.decodeStruct(codec.String);
    return val;
  };

  WebPrintingMediaCollection.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(WebPrintingMediaCollection.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(WebPrintingMediaSize, val.mediaSize);
    encoder.encodeStruct(codec.String, val.mediaSizeName);
  };
  function WebPrinterAttributes(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  WebPrinterAttributes.prototype.initDefaults_ = function() {
    this.copiesDefault = 0;
    this.multipleDocumentHandlingDefault = 0;
    this.copiesSupported = null;
    this.mediaColDefault = null;
    this.mediaColDatabase = null;
    this.mediaSourceDefault = null;
    this.mediaSourceSupported = null;
    this.multipleDocumentHandlingSupported = null;
    this.orientationRequestedDefault = 0;
    this.printColorModeDefault = 0;
    this.orientationRequestedSupported = null;
    this.printerResolutionDefault = null;
    this.printerResolutionSupported = null;
    this.printColorModeSupported = null;
    this.print_quality_default_$flag = false;
    this.sides_default_$flag = false;
    this.print_quality_default_$value = 0;
    this.printQualitySupported = null;
    this.printerState = 0;
    this.sides_default_$value = 0;
    this.printerStateMessage = null;
    this.printerStateReasons = null;
    this.sidesSupported = null;
    this.printerId = null;
  };
  WebPrinterAttributes.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  WebPrinterAttributes.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 160}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    // validate WebPrinterAttributes.copiesSupported
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, WebPrintingRange, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WebPrinterAttributes.mediaColDefault
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, WebPrintingMediaCollection, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WebPrinterAttributes.mediaColDatabase
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 24, 8, new codec.PointerTo(WebPrintingMediaCollection), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WebPrinterAttributes.mediaSourceDefault
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 32, true)
    if (err !== validator.validationError.NONE)
        return err;


    // validate WebPrinterAttributes.mediaSourceSupported
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 40, 8, codec.String, false, [0, 0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WebPrinterAttributes.multipleDocumentHandlingDefault
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 4, WebPrintingMultipleDocumentHandling);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WebPrinterAttributes.multipleDocumentHandlingSupported
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 48, 4, new codec.Enum(WebPrintingMultipleDocumentHandling), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WebPrinterAttributes.orientationRequestedDefault
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 56, WebPrintingOrientationRequested);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WebPrinterAttributes.orientationRequestedSupported
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 64, 4, new codec.Enum(WebPrintingOrientationRequested), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WebPrinterAttributes.printerResolutionDefault
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 72, geometry$.Size, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WebPrinterAttributes.printerResolutionSupported
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 80, 8, new codec.PointerTo(geometry$.Size), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WebPrinterAttributes.printColorModeDefault
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 60, WebPrintColorMode);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WebPrinterAttributes.printColorModeSupported
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 88, 4, new codec.Enum(WebPrintColorMode), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;



    // validate WebPrinterAttributes.print_quality_default_$value
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 100, WebPrintQuality);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WebPrinterAttributes.printQualitySupported
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 104, 4, new codec.Enum(WebPrintQuality), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WebPrinterAttributes.printerState
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 112, WebPrinterState);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WebPrinterAttributes.printerStateMessage
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 120, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate WebPrinterAttributes.printerStateReasons
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 128, 4, new codec.Enum(WebPrinterStateReason), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;



    // validate WebPrinterAttributes.sides_default_$value
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 116, WebPrintingSides);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WebPrinterAttributes.sidesSupported
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 136, 4, new codec.Enum(WebPrintingSides), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WebPrinterAttributes.printerId
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 144, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  WebPrinterAttributes.encodedSize = codec.kStructHeaderSize + 152;

  WebPrinterAttributes.decode = function(decoder) {
    var packed;
    var val = new WebPrinterAttributes();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.copiesDefault =
        decoder.decodeStruct(codec.Uint32);
    val.multipleDocumentHandlingDefault =
        decoder.decodeStruct(new codec.Enum(WebPrintingMultipleDocumentHandling));
    val.copiesSupported =
        decoder.decodeStructPointer(WebPrintingRange);
    val.mediaColDefault =
        decoder.decodeStructPointer(WebPrintingMediaCollection);
    val.mediaColDatabase =
        decoder.decodeArrayPointer(new codec.PointerTo(WebPrintingMediaCollection));
    val.mediaSourceDefault =
        decoder.decodeStruct(codec.String);
    val.mediaSourceSupported =
        decoder.decodeArrayPointer(codec.String);
    val.multipleDocumentHandlingSupported =
        decoder.decodeArrayPointer(new codec.Enum(WebPrintingMultipleDocumentHandling));
    val.orientationRequestedDefault =
        decoder.decodeStruct(new codec.Enum(WebPrintingOrientationRequested));
    val.printColorModeDefault =
        decoder.decodeStruct(new codec.Enum(WebPrintColorMode));
    val.orientationRequestedSupported =
        decoder.decodeArrayPointer(new codec.Enum(WebPrintingOrientationRequested));
    val.printerResolutionDefault =
        decoder.decodeStructPointer(geometry$.Size);
    val.printerResolutionSupported =
        decoder.decodeArrayPointer(new codec.PointerTo(geometry$.Size));
    val.printColorModeSupported =
        decoder.decodeArrayPointer(new codec.Enum(WebPrintColorMode));
    packed = decoder.readUint8();
    val.print_quality_default_$flag = (packed >> 0) & 1 ? true : false;
    val.sides_default_$flag = (packed >> 1) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.print_quality_default_$value =
        decoder.decodeStruct(new codec.Enum(WebPrintQuality));
    val.printQualitySupported =
        decoder.decodeArrayPointer(new codec.Enum(WebPrintQuality));
    val.printerState =
        decoder.decodeStruct(new codec.Enum(WebPrinterState));
    val.sides_default_$value =
        decoder.decodeStruct(new codec.Enum(WebPrintingSides));
    val.printerStateMessage =
        decoder.decodeStruct(codec.String);
    val.printerStateReasons =
        decoder.decodeArrayPointer(new codec.Enum(WebPrinterStateReason));
    val.sidesSupported =
        decoder.decodeArrayPointer(new codec.Enum(WebPrintingSides));
    val.printerId =
        decoder.decodeStruct(codec.String);
    return val;
  };

  WebPrinterAttributes.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(WebPrinterAttributes.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Uint32, val.copiesDefault);
    encoder.encodeStruct(codec.Int32, val.multipleDocumentHandlingDefault);
    encoder.encodeStructPointer(WebPrintingRange, val.copiesSupported);
    encoder.encodeStructPointer(WebPrintingMediaCollection, val.mediaColDefault);
    encoder.encodeArrayPointer(new codec.PointerTo(WebPrintingMediaCollection), val.mediaColDatabase);
    encoder.encodeStruct(codec.String, val.mediaSourceDefault);
    encoder.encodeArrayPointer(codec.String, val.mediaSourceSupported);
    encoder.encodeArrayPointer(new codec.Enum(WebPrintingMultipleDocumentHandling), val.multipleDocumentHandlingSupported);
    encoder.encodeStruct(codec.Int32, val.orientationRequestedDefault);
    encoder.encodeStruct(codec.Int32, val.printColorModeDefault);
    encoder.encodeArrayPointer(new codec.Enum(WebPrintingOrientationRequested), val.orientationRequestedSupported);
    encoder.encodeStructPointer(geometry$.Size, val.printerResolutionDefault);
    encoder.encodeArrayPointer(new codec.PointerTo(geometry$.Size), val.printerResolutionSupported);
    encoder.encodeArrayPointer(new codec.Enum(WebPrintColorMode), val.printColorModeSupported);
    packed = 0;
    packed |= (val.print_quality_default_$flag & 1) << 0
    packed |= (val.sides_default_$flag & 1) << 1
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.Int32, val.print_quality_default_$value);
    encoder.encodeArrayPointer(new codec.Enum(WebPrintQuality), val.printQualitySupported);
    encoder.encodeStruct(codec.Int32, val.printerState);
    encoder.encodeStruct(codec.Int32, val.sides_default_$value);
    encoder.encodeStruct(codec.String, val.printerStateMessage);
    encoder.encodeArrayPointer(new codec.Enum(WebPrinterStateReason), val.printerStateReasons);
    encoder.encodeArrayPointer(new codec.Enum(WebPrintingSides), val.sidesSupported);
    encoder.encodeStruct(codec.String, val.printerId);
  };
  function WebPrintingMediaCollectionRequested(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  WebPrintingMediaCollectionRequested.prototype.initDefaults_ = function() {
    this.mediaSize = null;
  };
  WebPrintingMediaCollectionRequested.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  WebPrintingMediaCollectionRequested.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WebPrintingMediaCollectionRequested.mediaSize
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, geometry$.Size, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  WebPrintingMediaCollectionRequested.encodedSize = codec.kStructHeaderSize + 8;

  WebPrintingMediaCollectionRequested.decode = function(decoder) {
    var packed;
    var val = new WebPrintingMediaCollectionRequested();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.mediaSize =
        decoder.decodeStructPointer(geometry$.Size);
    return val;
  };

  WebPrintingMediaCollectionRequested.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(WebPrintingMediaCollectionRequested.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(geometry$.Size, val.mediaSize);
  };
  function WebPrintJobTemplateAttributes(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  WebPrintJobTemplateAttributes.prototype.initDefaults_ = function() {
    this.jobName = null;
    this.copies = 0;
    this.multiple_document_handling_$flag = false;
    this.orientation_requested_$flag = false;
    this.print_color_mode_$flag = false;
    this.print_quality_$flag = false;
    this.sides_$flag = false;
    this.mediaCol = null;
    this.mediaSource = null;
    this.multiple_document_handling_$value = 0;
    this.orientation_requested_$value = 0;
    this.printerResolution = null;
    this.print_color_mode_$value = 0;
    this.print_quality_$value = 0;
    this.sides_$value = 0;
  };
  WebPrintJobTemplateAttributes.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  WebPrintJobTemplateAttributes.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 72}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WebPrintJobTemplateAttributes.jobName
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;



    // validate WebPrintJobTemplateAttributes.mediaCol
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, WebPrintingMediaCollectionRequested, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WebPrintJobTemplateAttributes.mediaSource
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 24, true)
    if (err !== validator.validationError.NONE)
        return err;



    // validate WebPrintJobTemplateAttributes.multiple_document_handling_$value
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 32, WebPrintingMultipleDocumentHandling);
    if (err !== validator.validationError.NONE)
        return err;



    // validate WebPrintJobTemplateAttributes.orientation_requested_$value
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 36, WebPrintingOrientationRequested);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WebPrintJobTemplateAttributes.printerResolution
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 40, geometry$.Size, true);
    if (err !== validator.validationError.NONE)
        return err;



    // validate WebPrintJobTemplateAttributes.print_color_mode_$value
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 48, WebPrintColorMode);
    if (err !== validator.validationError.NONE)
        return err;



    // validate WebPrintJobTemplateAttributes.print_quality_$value
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 52, WebPrintQuality);
    if (err !== validator.validationError.NONE)
        return err;



    // validate WebPrintJobTemplateAttributes.sides_$value
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 56, WebPrintingSides);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  WebPrintJobTemplateAttributes.encodedSize = codec.kStructHeaderSize + 64;

  WebPrintJobTemplateAttributes.decode = function(decoder) {
    var packed;
    var val = new WebPrintJobTemplateAttributes();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.jobName =
        decoder.decodeStruct(codec.String);
    val.copies =
        decoder.decodeStruct(codec.Uint32);
    packed = decoder.readUint8();
    val.multiple_document_handling_$flag = (packed >> 0) & 1 ? true : false;
    val.orientation_requested_$flag = (packed >> 1) & 1 ? true : false;
    val.print_color_mode_$flag = (packed >> 2) & 1 ? true : false;
    val.print_quality_$flag = (packed >> 3) & 1 ? true : false;
    val.sides_$flag = (packed >> 4) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.mediaCol =
        decoder.decodeStructPointer(WebPrintingMediaCollectionRequested);
    val.mediaSource =
        decoder.decodeStruct(codec.String);
    val.multiple_document_handling_$value =
        decoder.decodeStruct(new codec.Enum(WebPrintingMultipleDocumentHandling));
    val.orientation_requested_$value =
        decoder.decodeStruct(new codec.Enum(WebPrintingOrientationRequested));
    val.printerResolution =
        decoder.decodeStructPointer(geometry$.Size);
    val.print_color_mode_$value =
        decoder.decodeStruct(new codec.Enum(WebPrintColorMode));
    val.print_quality_$value =
        decoder.decodeStruct(new codec.Enum(WebPrintQuality));
    val.sides_$value =
        decoder.decodeStruct(new codec.Enum(WebPrintingSides));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  WebPrintJobTemplateAttributes.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(WebPrintJobTemplateAttributes.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.jobName);
    encoder.encodeStruct(codec.Uint32, val.copies);
    packed = 0;
    packed |= (val.multiple_document_handling_$flag & 1) << 0
    packed |= (val.orientation_requested_$flag & 1) << 1
    packed |= (val.print_color_mode_$flag & 1) << 2
    packed |= (val.print_quality_$flag & 1) << 3
    packed |= (val.sides_$flag & 1) << 4
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(WebPrintingMediaCollectionRequested, val.mediaCol);
    encoder.encodeStruct(codec.String, val.mediaSource);
    encoder.encodeStruct(codec.Int32, val.multiple_document_handling_$value);
    encoder.encodeStruct(codec.Int32, val.orientation_requested_$value);
    encoder.encodeStructPointer(geometry$.Size, val.printerResolution);
    encoder.encodeStruct(codec.Int32, val.print_color_mode_$value);
    encoder.encodeStruct(codec.Int32, val.print_quality_$value);
    encoder.encodeStruct(codec.Int32, val.sides_$value);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function WebPrintJobUpdate(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  WebPrintJobUpdate.prototype.initDefaults_ = function() {
    this.state = 0;
    this.pagesPrinted = 0;
  };
  WebPrintJobUpdate.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  WebPrintJobUpdate.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WebPrintJobUpdate.state
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, WebPrintJobState);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  WebPrintJobUpdate.encodedSize = codec.kStructHeaderSize + 8;

  WebPrintJobUpdate.decode = function(decoder) {
    var packed;
    var val = new WebPrintJobUpdate();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.state =
        decoder.decodeStruct(new codec.Enum(WebPrintJobState));
    val.pagesPrinted =
        decoder.decodeStruct(codec.Uint32);
    return val;
  };

  WebPrintJobUpdate.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(WebPrintJobUpdate.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.state);
    encoder.encodeStruct(codec.Uint32, val.pagesPrinted);
  };
  function WebPrintJobInfo(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  WebPrintJobInfo.prototype.initDefaults_ = function() {
    this.jobName = null;
    this.jobPages = 0;
    this.observer = new bindings.InterfaceRequest();
    this.controller = new WebPrintJobControllerPtr();
  };
  WebPrintJobInfo.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  WebPrintJobInfo.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WebPrintJobInfo.jobName
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;



    // validate WebPrintJobInfo.observer
    err = messageValidator.validateInterfaceRequest(offset + codec.kStructHeaderSize + 12, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate WebPrintJobInfo.controller
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 16, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  WebPrintJobInfo.encodedSize = codec.kStructHeaderSize + 24;

  WebPrintJobInfo.decode = function(decoder) {
    var packed;
    var val = new WebPrintJobInfo();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.jobName =
        decoder.decodeStruct(codec.String);
    val.jobPages =
        decoder.decodeStruct(codec.Uint32);
    val.observer =
        decoder.decodeStruct(codec.InterfaceRequest);
    val.controller =
        decoder.decodeStruct(new codec.Interface(WebPrintJobControllerPtr));
    return val;
  };

  WebPrintJobInfo.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(WebPrintJobInfo.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.jobName);
    encoder.encodeStruct(codec.Uint32, val.jobPages);
    encoder.encodeStruct(codec.InterfaceRequest, val.observer);
    encoder.encodeStruct(new codec.Interface(WebPrintJobControllerPtr), val.controller);
  };
  function WebPrintJobStateObserver_OnWebPrintJobUpdate_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  WebPrintJobStateObserver_OnWebPrintJobUpdate_Params.prototype.initDefaults_ = function() {
    this.update = null;
  };
  WebPrintJobStateObserver_OnWebPrintJobUpdate_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  WebPrintJobStateObserver_OnWebPrintJobUpdate_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WebPrintJobStateObserver_OnWebPrintJobUpdate_Params.update
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, WebPrintJobUpdate, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  WebPrintJobStateObserver_OnWebPrintJobUpdate_Params.encodedSize = codec.kStructHeaderSize + 8;

  WebPrintJobStateObserver_OnWebPrintJobUpdate_Params.decode = function(decoder) {
    var packed;
    var val = new WebPrintJobStateObserver_OnWebPrintJobUpdate_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.update =
        decoder.decodeStructPointer(WebPrintJobUpdate);
    return val;
  };

  WebPrintJobStateObserver_OnWebPrintJobUpdate_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(WebPrintJobStateObserver_OnWebPrintJobUpdate_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(WebPrintJobUpdate, val.update);
  };
  function WebPrintJobController_Cancel_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  WebPrintJobController_Cancel_Params.prototype.initDefaults_ = function() {
  };
  WebPrintJobController_Cancel_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  WebPrintJobController_Cancel_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  WebPrintJobController_Cancel_Params.encodedSize = codec.kStructHeaderSize + 0;

  WebPrintJobController_Cancel_Params.decode = function(decoder) {
    var packed;
    var val = new WebPrintJobController_Cancel_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  WebPrintJobController_Cancel_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(WebPrintJobController_Cancel_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function WebPrinter_FetchAttributes_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  WebPrinter_FetchAttributes_Params.prototype.initDefaults_ = function() {
  };
  WebPrinter_FetchAttributes_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  WebPrinter_FetchAttributes_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  WebPrinter_FetchAttributes_Params.encodedSize = codec.kStructHeaderSize + 0;

  WebPrinter_FetchAttributes_Params.decode = function(decoder) {
    var packed;
    var val = new WebPrinter_FetchAttributes_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  WebPrinter_FetchAttributes_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(WebPrinter_FetchAttributes_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function WebPrinter_FetchAttributes_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  WebPrinter_FetchAttributes_ResponseParams.prototype.initDefaults_ = function() {
    this.result = null;
  };
  WebPrinter_FetchAttributes_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  WebPrinter_FetchAttributes_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WebPrinter_FetchAttributes_ResponseParams.result
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 0, WebPrinterFetchResult, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  WebPrinter_FetchAttributes_ResponseParams.encodedSize = codec.kStructHeaderSize + 16;

  WebPrinter_FetchAttributes_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new WebPrinter_FetchAttributes_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.result =
        decoder.decodeStruct(WebPrinterFetchResult);
    return val;
  };

  WebPrinter_FetchAttributes_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(WebPrinter_FetchAttributes_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(WebPrinterFetchResult, val.result);
  };
  function WebPrinter_Print_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  WebPrinter_Print_Params.prototype.initDefaults_ = function() {
    this.document = new blob$.BlobPtr();
    this.attributes = null;
  };
  WebPrinter_Print_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  WebPrinter_Print_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WebPrinter_Print_Params.document
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 0, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WebPrinter_Print_Params.attributes
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, WebPrintJobTemplateAttributes, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  WebPrinter_Print_Params.encodedSize = codec.kStructHeaderSize + 16;

  WebPrinter_Print_Params.decode = function(decoder) {
    var packed;
    var val = new WebPrinter_Print_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.document =
        decoder.decodeStruct(new codec.Interface(blob$.BlobPtr));
    val.attributes =
        decoder.decodeStructPointer(WebPrintJobTemplateAttributes);
    return val;
  };

  WebPrinter_Print_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(WebPrinter_Print_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(new codec.Interface(blob$.BlobPtr), val.document);
    encoder.encodeStructPointer(WebPrintJobTemplateAttributes, val.attributes);
  };
  function WebPrinter_Print_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  WebPrinter_Print_ResponseParams.prototype.initDefaults_ = function() {
    this.result = null;
  };
  WebPrinter_Print_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  WebPrinter_Print_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WebPrinter_Print_ResponseParams.result
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 0, WebPrintResult, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  WebPrinter_Print_ResponseParams.encodedSize = codec.kStructHeaderSize + 16;

  WebPrinter_Print_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new WebPrinter_Print_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.result =
        decoder.decodeStruct(WebPrintResult);
    return val;
  };

  WebPrinter_Print_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(WebPrinter_Print_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(WebPrintResult, val.result);
  };
  function WebPrintingService_GetPrinters_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  WebPrintingService_GetPrinters_Params.prototype.initDefaults_ = function() {
  };
  WebPrintingService_GetPrinters_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  WebPrintingService_GetPrinters_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  WebPrintingService_GetPrinters_Params.encodedSize = codec.kStructHeaderSize + 0;

  WebPrintingService_GetPrinters_Params.decode = function(decoder) {
    var packed;
    var val = new WebPrintingService_GetPrinters_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  WebPrintingService_GetPrinters_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(WebPrintingService_GetPrinters_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function WebPrintingService_GetPrinters_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  WebPrintingService_GetPrinters_ResponseParams.prototype.initDefaults_ = function() {
    this.result = null;
  };
  WebPrintingService_GetPrinters_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  WebPrintingService_GetPrinters_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WebPrintingService_GetPrinters_ResponseParams.result
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 0, GetPrintersResult, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  WebPrintingService_GetPrinters_ResponseParams.encodedSize = codec.kStructHeaderSize + 16;

  WebPrintingService_GetPrinters_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new WebPrintingService_GetPrinters_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.result =
        decoder.decodeStruct(GetPrintersResult);
    return val;
  };

  WebPrintingService_GetPrinters_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(WebPrintingService_GetPrinters_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(GetPrintersResult, val.result);
  };

  function WebPrintingMediaSizeDimension(value) {
    this.initDefault_();
    this.initValue_(value);
  }


  WebPrintingMediaSizeDimension.Tags = {
    range: 0,
    value: 1,
  };

  WebPrintingMediaSizeDimension.prototype.initDefault_ = function() {
    this.$data = null;
    this.$tag = undefined;
  }

  WebPrintingMediaSizeDimension.prototype.initValue_ = function(value) {
    if (value == undefined) {
      return;
    }

    var keys = Object.keys(value);
    if (keys.length == 0) {
      return;
    }

    if (keys.length > 1) {
      throw new TypeError("You may set only one member on a union.");
    }

    var fields = [
        "range",
        "value",
    ];

    if (fields.indexOf(keys[0]) < 0) {
      throw new ReferenceError(keys[0] + " is not a WebPrintingMediaSizeDimension member.");

    }

    this[keys[0]] = value[keys[0]];
  }
  Object.defineProperty(WebPrintingMediaSizeDimension.prototype, "range", {
    get: function() {
      if (this.$tag != WebPrintingMediaSizeDimension.Tags.range) {
        throw new ReferenceError(
            "WebPrintingMediaSizeDimension.range is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = WebPrintingMediaSizeDimension.Tags.range;
      this.$data = value;
    }
  });
  Object.defineProperty(WebPrintingMediaSizeDimension.prototype, "value", {
    get: function() {
      if (this.$tag != WebPrintingMediaSizeDimension.Tags.value) {
        throw new ReferenceError(
            "WebPrintingMediaSizeDimension.value is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = WebPrintingMediaSizeDimension.Tags.value;
      this.$data = value;
    }
  });


    WebPrintingMediaSizeDimension.encode = function(encoder, val) {
      if (val == null) {
        encoder.writeUint64(0);
        encoder.writeUint64(0);
        return;
      }
      if (val.$tag == undefined) {
        throw new TypeError("Cannot encode unions with an unknown member set.");
      }

      encoder.writeUint32(16);
      encoder.writeUint32(val.$tag);
      switch (val.$tag) {
        case WebPrintingMediaSizeDimension.Tags.range:
          encoder.encodeStructPointer(WebPrintingRange, val.range);
          break;
        case WebPrintingMediaSizeDimension.Tags.value:
          encoder.encodeStruct(codec.Uint32, val.value);
          break;
      }
      encoder.align();
    };


    WebPrintingMediaSizeDimension.decode = function(decoder) {
      var size = decoder.readUint32();
      if (size == 0) {
        decoder.readUint32();
        decoder.readUint64();
        return null;
      }

      var result = new WebPrintingMediaSizeDimension();
      var tag = decoder.readUint32();
      switch (tag) {
        case WebPrintingMediaSizeDimension.Tags.range:
          result.range = decoder.decodeStructPointer(WebPrintingRange);
          break;
        case WebPrintingMediaSizeDimension.Tags.value:
          result.value = decoder.decodeStruct(codec.Uint32);
          break;
      }
      decoder.align();

      return result;
    };


    WebPrintingMediaSizeDimension.validate = function(messageValidator, offset) {
      var size = messageValidator.decodeUnionSize(offset);
      if (size != 16) {
        return validator.validationError.INVALID_UNION_SIZE;
      }

      var tag = messageValidator.decodeUnionTag(offset);
      var data_offset = offset + 8;
      var err;
      switch (tag) {
        case WebPrintingMediaSizeDimension.Tags.range:
          

    // validate WebPrintingMediaSizeDimension.range
    err = messageValidator.validateStructPointer(data_offset, WebPrintingRange, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
        case WebPrintingMediaSizeDimension.Tags.value:
          

          break;
      }

      return validator.validationError.NONE;
    };

  WebPrintingMediaSizeDimension.encodedSize = 16;

  function GetPrintersResult(value) {
    this.initDefault_();
    this.initValue_(value);
  }


  GetPrintersResult.Tags = {
    printers: 0,
    error: 1,
  };

  GetPrintersResult.prototype.initDefault_ = function() {
    this.$data = null;
    this.$tag = undefined;
  }

  GetPrintersResult.prototype.initValue_ = function(value) {
    if (value == undefined) {
      return;
    }

    var keys = Object.keys(value);
    if (keys.length == 0) {
      return;
    }

    if (keys.length > 1) {
      throw new TypeError("You may set only one member on a union.");
    }

    var fields = [
        "printers",
        "error",
    ];

    if (fields.indexOf(keys[0]) < 0) {
      throw new ReferenceError(keys[0] + " is not a GetPrintersResult member.");

    }

    this[keys[0]] = value[keys[0]];
  }
  Object.defineProperty(GetPrintersResult.prototype, "printers", {
    get: function() {
      if (this.$tag != GetPrintersResult.Tags.printers) {
        throw new ReferenceError(
            "GetPrintersResult.printers is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = GetPrintersResult.Tags.printers;
      this.$data = value;
    }
  });
  Object.defineProperty(GetPrintersResult.prototype, "error", {
    get: function() {
      if (this.$tag != GetPrintersResult.Tags.error) {
        throw new ReferenceError(
            "GetPrintersResult.error is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = GetPrintersResult.Tags.error;
      this.$data = value;
    }
  });


    GetPrintersResult.encode = function(encoder, val) {
      if (val == null) {
        encoder.writeUint64(0);
        encoder.writeUint64(0);
        return;
      }
      if (val.$tag == undefined) {
        throw new TypeError("Cannot encode unions with an unknown member set.");
      }

      encoder.writeUint32(16);
      encoder.writeUint32(val.$tag);
      switch (val.$tag) {
        case GetPrintersResult.Tags.printers:
          encoder.encodeArrayPointer(new codec.PointerTo(WebPrinterInfo), val.printers);
          break;
        case GetPrintersResult.Tags.error:
          encoder.encodeStruct(codec.Int32, val.error);
          break;
      }
      encoder.align();
    };


    GetPrintersResult.decode = function(decoder) {
      var size = decoder.readUint32();
      if (size == 0) {
        decoder.readUint32();
        decoder.readUint64();
        return null;
      }

      var result = new GetPrintersResult();
      var tag = decoder.readUint32();
      switch (tag) {
        case GetPrintersResult.Tags.printers:
          result.printers = decoder.decodeArrayPointer(new codec.PointerTo(WebPrinterInfo));
          break;
        case GetPrintersResult.Tags.error:
          result.error = decoder.decodeStruct(new codec.Enum(GetPrintersError));
          break;
      }
      decoder.align();

      return result;
    };


    GetPrintersResult.validate = function(messageValidator, offset) {
      var size = messageValidator.decodeUnionSize(offset);
      if (size != 16) {
        return validator.validationError.INVALID_UNION_SIZE;
      }

      var tag = messageValidator.decodeUnionTag(offset);
      var data_offset = offset + 8;
      var err;
      switch (tag) {
        case GetPrintersResult.Tags.printers:
          

    // validate GetPrintersResult.printers
    err = messageValidator.validateArrayPointer(data_offset, 8, new codec.PointerTo(WebPrinterInfo), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;
          break;
        case GetPrintersResult.Tags.error:
          

    // validate GetPrintersResult.error
    err = messageValidator.validateEnum(data_offset, GetPrintersError);
    if (err !== validator.validationError.NONE)
        return err;
          break;
      }

      return validator.validationError.NONE;
    };

  GetPrintersResult.encodedSize = 16;

  function WebPrinterFetchResult(value) {
    this.initDefault_();
    this.initValue_(value);
  }


  WebPrinterFetchResult.Tags = {
    printerAttributes: 0,
    error: 1,
  };

  WebPrinterFetchResult.prototype.initDefault_ = function() {
    this.$data = null;
    this.$tag = undefined;
  }

  WebPrinterFetchResult.prototype.initValue_ = function(value) {
    if (value == undefined) {
      return;
    }

    var keys = Object.keys(value);
    if (keys.length == 0) {
      return;
    }

    if (keys.length > 1) {
      throw new TypeError("You may set only one member on a union.");
    }

    var fields = [
        "printerAttributes",
        "error",
    ];

    if (fields.indexOf(keys[0]) < 0) {
      throw new ReferenceError(keys[0] + " is not a WebPrinterFetchResult member.");

    }

    this[keys[0]] = value[keys[0]];
  }
  Object.defineProperty(WebPrinterFetchResult.prototype, "printerAttributes", {
    get: function() {
      if (this.$tag != WebPrinterFetchResult.Tags.printerAttributes) {
        throw new ReferenceError(
            "WebPrinterFetchResult.printerAttributes is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = WebPrinterFetchResult.Tags.printerAttributes;
      this.$data = value;
    }
  });
  Object.defineProperty(WebPrinterFetchResult.prototype, "error", {
    get: function() {
      if (this.$tag != WebPrinterFetchResult.Tags.error) {
        throw new ReferenceError(
            "WebPrinterFetchResult.error is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = WebPrinterFetchResult.Tags.error;
      this.$data = value;
    }
  });


    WebPrinterFetchResult.encode = function(encoder, val) {
      if (val == null) {
        encoder.writeUint64(0);
        encoder.writeUint64(0);
        return;
      }
      if (val.$tag == undefined) {
        throw new TypeError("Cannot encode unions with an unknown member set.");
      }

      encoder.writeUint32(16);
      encoder.writeUint32(val.$tag);
      switch (val.$tag) {
        case WebPrinterFetchResult.Tags.printerAttributes:
          encoder.encodeStructPointer(WebPrinterAttributes, val.printerAttributes);
          break;
        case WebPrinterFetchResult.Tags.error:
          encoder.encodeStruct(codec.Int32, val.error);
          break;
      }
      encoder.align();
    };


    WebPrinterFetchResult.decode = function(decoder) {
      var size = decoder.readUint32();
      if (size == 0) {
        decoder.readUint32();
        decoder.readUint64();
        return null;
      }

      var result = new WebPrinterFetchResult();
      var tag = decoder.readUint32();
      switch (tag) {
        case WebPrinterFetchResult.Tags.printerAttributes:
          result.printerAttributes = decoder.decodeStructPointer(WebPrinterAttributes);
          break;
        case WebPrinterFetchResult.Tags.error:
          result.error = decoder.decodeStruct(new codec.Enum(WebPrinterFetchError));
          break;
      }
      decoder.align();

      return result;
    };


    WebPrinterFetchResult.validate = function(messageValidator, offset) {
      var size = messageValidator.decodeUnionSize(offset);
      if (size != 16) {
        return validator.validationError.INVALID_UNION_SIZE;
      }

      var tag = messageValidator.decodeUnionTag(offset);
      var data_offset = offset + 8;
      var err;
      switch (tag) {
        case WebPrinterFetchResult.Tags.printerAttributes:
          

    // validate WebPrinterFetchResult.printerAttributes
    err = messageValidator.validateStructPointer(data_offset, WebPrinterAttributes, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
        case WebPrinterFetchResult.Tags.error:
          

    // validate WebPrinterFetchResult.error
    err = messageValidator.validateEnum(data_offset, WebPrinterFetchError);
    if (err !== validator.validationError.NONE)
        return err;
          break;
      }

      return validator.validationError.NONE;
    };

  WebPrinterFetchResult.encodedSize = 16;

  function WebPrintResult(value) {
    this.initDefault_();
    this.initValue_(value);
  }


  WebPrintResult.Tags = {
    printJobInfo: 0,
    error: 1,
  };

  WebPrintResult.prototype.initDefault_ = function() {
    this.$data = null;
    this.$tag = undefined;
  }

  WebPrintResult.prototype.initValue_ = function(value) {
    if (value == undefined) {
      return;
    }

    var keys = Object.keys(value);
    if (keys.length == 0) {
      return;
    }

    if (keys.length > 1) {
      throw new TypeError("You may set only one member on a union.");
    }

    var fields = [
        "printJobInfo",
        "error",
    ];

    if (fields.indexOf(keys[0]) < 0) {
      throw new ReferenceError(keys[0] + " is not a WebPrintResult member.");

    }

    this[keys[0]] = value[keys[0]];
  }
  Object.defineProperty(WebPrintResult.prototype, "printJobInfo", {
    get: function() {
      if (this.$tag != WebPrintResult.Tags.printJobInfo) {
        throw new ReferenceError(
            "WebPrintResult.printJobInfo is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = WebPrintResult.Tags.printJobInfo;
      this.$data = value;
    }
  });
  Object.defineProperty(WebPrintResult.prototype, "error", {
    get: function() {
      if (this.$tag != WebPrintResult.Tags.error) {
        throw new ReferenceError(
            "WebPrintResult.error is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = WebPrintResult.Tags.error;
      this.$data = value;
    }
  });


    WebPrintResult.encode = function(encoder, val) {
      if (val == null) {
        encoder.writeUint64(0);
        encoder.writeUint64(0);
        return;
      }
      if (val.$tag == undefined) {
        throw new TypeError("Cannot encode unions with an unknown member set.");
      }

      encoder.writeUint32(16);
      encoder.writeUint32(val.$tag);
      switch (val.$tag) {
        case WebPrintResult.Tags.printJobInfo:
          encoder.encodeStructPointer(WebPrintJobInfo, val.printJobInfo);
          break;
        case WebPrintResult.Tags.error:
          encoder.encodeStruct(codec.Int32, val.error);
          break;
      }
      encoder.align();
    };


    WebPrintResult.decode = function(decoder) {
      var size = decoder.readUint32();
      if (size == 0) {
        decoder.readUint32();
        decoder.readUint64();
        return null;
      }

      var result = new WebPrintResult();
      var tag = decoder.readUint32();
      switch (tag) {
        case WebPrintResult.Tags.printJobInfo:
          result.printJobInfo = decoder.decodeStructPointer(WebPrintJobInfo);
          break;
        case WebPrintResult.Tags.error:
          result.error = decoder.decodeStruct(new codec.Enum(WebPrintError));
          break;
      }
      decoder.align();

      return result;
    };


    WebPrintResult.validate = function(messageValidator, offset) {
      var size = messageValidator.decodeUnionSize(offset);
      if (size != 16) {
        return validator.validationError.INVALID_UNION_SIZE;
      }

      var tag = messageValidator.decodeUnionTag(offset);
      var data_offset = offset + 8;
      var err;
      switch (tag) {
        case WebPrintResult.Tags.printJobInfo:
          

    // validate WebPrintResult.printJobInfo
    err = messageValidator.validateStructPointer(data_offset, WebPrintJobInfo, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
        case WebPrintResult.Tags.error:
          

    // validate WebPrintResult.error
    err = messageValidator.validateEnum(data_offset, WebPrintError);
    if (err !== validator.validationError.NONE)
        return err;
          break;
      }

      return validator.validationError.NONE;
    };

  WebPrintResult.encodedSize = 16;
  var kWebPrintJobStateObserver_OnWebPrintJobUpdate_Name = 0;

  function WebPrintJobStateObserverPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(WebPrintJobStateObserver,
                                                   handleOrPtrInfo);
  }

  function WebPrintJobStateObserverAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        WebPrintJobStateObserver, associatedInterfacePtrInfo);
  }

  WebPrintJobStateObserverAssociatedPtr.prototype =
      Object.create(WebPrintJobStateObserverPtr.prototype);
  WebPrintJobStateObserverAssociatedPtr.prototype.constructor =
      WebPrintJobStateObserverAssociatedPtr;

  function WebPrintJobStateObserverProxy(receiver) {
    this.receiver_ = receiver;
  }
  WebPrintJobStateObserverPtr.prototype.onWebPrintJobUpdate = function() {
    return WebPrintJobStateObserverProxy.prototype.onWebPrintJobUpdate
        .apply(this.ptr.getProxy(), arguments);
  };

  WebPrintJobStateObserverProxy.prototype.onWebPrintJobUpdate = function(update) {
    var params_ = new WebPrintJobStateObserver_OnWebPrintJobUpdate_Params();
    params_.update = update;
    var builder = new codec.MessageV0Builder(
        kWebPrintJobStateObserver_OnWebPrintJobUpdate_Name,
        codec.align(WebPrintJobStateObserver_OnWebPrintJobUpdate_Params.encodedSize));
    builder.encodeStruct(WebPrintJobStateObserver_OnWebPrintJobUpdate_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function WebPrintJobStateObserverStub(delegate) {
    this.delegate_ = delegate;
  }
  WebPrintJobStateObserverStub.prototype.onWebPrintJobUpdate = function(update) {
    return this.delegate_ && this.delegate_.onWebPrintJobUpdate && this.delegate_.onWebPrintJobUpdate(update);
  }

  WebPrintJobStateObserverStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kWebPrintJobStateObserver_OnWebPrintJobUpdate_Name:
      var params = reader.decodeStruct(WebPrintJobStateObserver_OnWebPrintJobUpdate_Params);
      this.onWebPrintJobUpdate(params.update);
      return true;
    default:
      return false;
    }
  };

  WebPrintJobStateObserverStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  function validateWebPrintJobStateObserverRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kWebPrintJobStateObserver_OnWebPrintJobUpdate_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = WebPrintJobStateObserver_OnWebPrintJobUpdate_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateWebPrintJobStateObserverResponse(messageValidator) {
    return validator.validationError.NONE;
  }

  var WebPrintJobStateObserver = {
    name: 'blink.mojom.WebPrintJobStateObserver',
    kVersion: 0,
    ptrClass: WebPrintJobStateObserverPtr,
    proxyClass: WebPrintJobStateObserverProxy,
    stubClass: WebPrintJobStateObserverStub,
    validateRequest: validateWebPrintJobStateObserverRequest,
    validateResponse: null,
  };
  WebPrintJobStateObserverStub.prototype.validator = validateWebPrintJobStateObserverRequest;
  WebPrintJobStateObserverProxy.prototype.validator = null;
  var kWebPrintJobController_Cancel_Name = 0;

  function WebPrintJobControllerPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(WebPrintJobController,
                                                   handleOrPtrInfo);
  }

  function WebPrintJobControllerAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        WebPrintJobController, associatedInterfacePtrInfo);
  }

  WebPrintJobControllerAssociatedPtr.prototype =
      Object.create(WebPrintJobControllerPtr.prototype);
  WebPrintJobControllerAssociatedPtr.prototype.constructor =
      WebPrintJobControllerAssociatedPtr;

  function WebPrintJobControllerProxy(receiver) {
    this.receiver_ = receiver;
  }
  WebPrintJobControllerPtr.prototype.cancel = function() {
    return WebPrintJobControllerProxy.prototype.cancel
        .apply(this.ptr.getProxy(), arguments);
  };

  WebPrintJobControllerProxy.prototype.cancel = function() {
    var params_ = new WebPrintJobController_Cancel_Params();
    var builder = new codec.MessageV0Builder(
        kWebPrintJobController_Cancel_Name,
        codec.align(WebPrintJobController_Cancel_Params.encodedSize));
    builder.encodeStruct(WebPrintJobController_Cancel_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function WebPrintJobControllerStub(delegate) {
    this.delegate_ = delegate;
  }
  WebPrintJobControllerStub.prototype.cancel = function() {
    return this.delegate_ && this.delegate_.cancel && this.delegate_.cancel();
  }

  WebPrintJobControllerStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kWebPrintJobController_Cancel_Name:
      var params = reader.decodeStruct(WebPrintJobController_Cancel_Params);
      this.cancel();
      return true;
    default:
      return false;
    }
  };

  WebPrintJobControllerStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  function validateWebPrintJobControllerRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kWebPrintJobController_Cancel_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = WebPrintJobController_Cancel_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateWebPrintJobControllerResponse(messageValidator) {
    return validator.validationError.NONE;
  }

  var WebPrintJobController = {
    name: 'blink.mojom.WebPrintJobController',
    kVersion: 0,
    ptrClass: WebPrintJobControllerPtr,
    proxyClass: WebPrintJobControllerProxy,
    stubClass: WebPrintJobControllerStub,
    validateRequest: validateWebPrintJobControllerRequest,
    validateResponse: null,
  };
  WebPrintJobControllerStub.prototype.validator = validateWebPrintJobControllerRequest;
  WebPrintJobControllerProxy.prototype.validator = null;
  var kWebPrinter_FetchAttributes_Name = 0;
  var kWebPrinter_Print_Name = 1;

  function WebPrinterPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(WebPrinter,
                                                   handleOrPtrInfo);
  }

  function WebPrinterAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        WebPrinter, associatedInterfacePtrInfo);
  }

  WebPrinterAssociatedPtr.prototype =
      Object.create(WebPrinterPtr.prototype);
  WebPrinterAssociatedPtr.prototype.constructor =
      WebPrinterAssociatedPtr;

  function WebPrinterProxy(receiver) {
    this.receiver_ = receiver;
  }
  WebPrinterPtr.prototype.fetchAttributes = function() {
    return WebPrinterProxy.prototype.fetchAttributes
        .apply(this.ptr.getProxy(), arguments);
  };

  WebPrinterProxy.prototype.fetchAttributes = function() {
    var params_ = new WebPrinter_FetchAttributes_Params();
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kWebPrinter_FetchAttributes_Name,
          codec.align(WebPrinter_FetchAttributes_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(WebPrinter_FetchAttributes_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(WebPrinter_FetchAttributes_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  WebPrinterPtr.prototype.print = function() {
    return WebPrinterProxy.prototype.print
        .apply(this.ptr.getProxy(), arguments);
  };

  WebPrinterProxy.prototype.print = function(document, attributes) {
    var params_ = new WebPrinter_Print_Params();
    params_.document = document;
    params_.attributes = attributes;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kWebPrinter_Print_Name,
          codec.align(WebPrinter_Print_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(WebPrinter_Print_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(WebPrinter_Print_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };

  function WebPrinterStub(delegate) {
    this.delegate_ = delegate;
  }
  WebPrinterStub.prototype.fetchAttributes = function() {
    return this.delegate_ && this.delegate_.fetchAttributes && this.delegate_.fetchAttributes();
  }
  WebPrinterStub.prototype.print = function(document, attributes) {
    return this.delegate_ && this.delegate_.print && this.delegate_.print(document, attributes);
  }

  WebPrinterStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  WebPrinterStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kWebPrinter_FetchAttributes_Name:
      var params = reader.decodeStruct(WebPrinter_FetchAttributes_Params);
      this.fetchAttributes().then(function(response) {
        var responseParams =
            new WebPrinter_FetchAttributes_ResponseParams();
        responseParams.result = response.result;
        var builder = new codec.MessageV1Builder(
            kWebPrinter_FetchAttributes_Name,
            codec.align(WebPrinter_FetchAttributes_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(WebPrinter_FetchAttributes_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kWebPrinter_Print_Name:
      var params = reader.decodeStruct(WebPrinter_Print_Params);
      this.print(params.document, params.attributes).then(function(response) {
        var responseParams =
            new WebPrinter_Print_ResponseParams();
        responseParams.result = response.result;
        var builder = new codec.MessageV1Builder(
            kWebPrinter_Print_Name,
            codec.align(WebPrinter_Print_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(WebPrinter_Print_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    default:
      return false;
    }
  };

  function validateWebPrinterRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kWebPrinter_FetchAttributes_Name:
        if (message.expectsResponse())
          paramsClass = WebPrinter_FetchAttributes_Params;
      break;
      case kWebPrinter_Print_Name:
        if (message.expectsResponse())
          paramsClass = WebPrinter_Print_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateWebPrinterResponse(messageValidator) {
   var message = messageValidator.message;
   var paramsClass = null;
   switch (message.getName()) {
      case kWebPrinter_FetchAttributes_Name:
        if (message.isResponse())
          paramsClass = WebPrinter_FetchAttributes_ResponseParams;
        break;
      case kWebPrinter_Print_Name:
        if (message.isResponse())
          paramsClass = WebPrinter_Print_ResponseParams;
        break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  var WebPrinter = {
    name: 'blink.mojom.WebPrinter',
    kVersion: 0,
    ptrClass: WebPrinterPtr,
    proxyClass: WebPrinterProxy,
    stubClass: WebPrinterStub,
    validateRequest: validateWebPrinterRequest,
    validateResponse: validateWebPrinterResponse,
  };
  WebPrinterStub.prototype.validator = validateWebPrinterRequest;
  WebPrinterProxy.prototype.validator = validateWebPrinterResponse;
  var kWebPrintingService_GetPrinters_Name = 0;

  function WebPrintingServicePtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(WebPrintingService,
                                                   handleOrPtrInfo);
  }

  function WebPrintingServiceAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        WebPrintingService, associatedInterfacePtrInfo);
  }

  WebPrintingServiceAssociatedPtr.prototype =
      Object.create(WebPrintingServicePtr.prototype);
  WebPrintingServiceAssociatedPtr.prototype.constructor =
      WebPrintingServiceAssociatedPtr;

  function WebPrintingServiceProxy(receiver) {
    this.receiver_ = receiver;
  }
  WebPrintingServicePtr.prototype.getPrinters = function() {
    return WebPrintingServiceProxy.prototype.getPrinters
        .apply(this.ptr.getProxy(), arguments);
  };

  WebPrintingServiceProxy.prototype.getPrinters = function() {
    var params_ = new WebPrintingService_GetPrinters_Params();
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kWebPrintingService_GetPrinters_Name,
          codec.align(WebPrintingService_GetPrinters_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(WebPrintingService_GetPrinters_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(WebPrintingService_GetPrinters_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };

  function WebPrintingServiceStub(delegate) {
    this.delegate_ = delegate;
  }
  WebPrintingServiceStub.prototype.getPrinters = function() {
    return this.delegate_ && this.delegate_.getPrinters && this.delegate_.getPrinters();
  }

  WebPrintingServiceStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  WebPrintingServiceStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kWebPrintingService_GetPrinters_Name:
      var params = reader.decodeStruct(WebPrintingService_GetPrinters_Params);
      this.getPrinters().then(function(response) {
        var responseParams =
            new WebPrintingService_GetPrinters_ResponseParams();
        responseParams.result = response.result;
        var builder = new codec.MessageV1Builder(
            kWebPrintingService_GetPrinters_Name,
            codec.align(WebPrintingService_GetPrinters_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(WebPrintingService_GetPrinters_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    default:
      return false;
    }
  };

  function validateWebPrintingServiceRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kWebPrintingService_GetPrinters_Name:
        if (message.expectsResponse())
          paramsClass = WebPrintingService_GetPrinters_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateWebPrintingServiceResponse(messageValidator) {
   var message = messageValidator.message;
   var paramsClass = null;
   switch (message.getName()) {
      case kWebPrintingService_GetPrinters_Name:
        if (message.isResponse())
          paramsClass = WebPrintingService_GetPrinters_ResponseParams;
        break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  var WebPrintingService = {
    name: 'blink.mojom.WebPrintingService',
    kVersion: 0,
    ptrClass: WebPrintingServicePtr,
    proxyClass: WebPrintingServiceProxy,
    stubClass: WebPrintingServiceStub,
    validateRequest: validateWebPrintingServiceRequest,
    validateResponse: validateWebPrintingServiceResponse,
  };
  WebPrintingServiceStub.prototype.validator = validateWebPrintingServiceRequest;
  WebPrintingServiceProxy.prototype.validator = validateWebPrintingServiceResponse;
  exports.WebPrintingMultipleDocumentHandling = WebPrintingMultipleDocumentHandling;
  exports.WebPrintingSides = WebPrintingSides;
  exports.WebPrintQuality = WebPrintQuality;
  exports.WebPrintColorMode = WebPrintColorMode;
  exports.WebPrintingOrientationRequested = WebPrintingOrientationRequested;
  exports.WebPrinterState = WebPrinterState;
  exports.WebPrinterStateReason = WebPrinterStateReason;
  exports.WebPrintJobState = WebPrintJobState;
  exports.GetPrintersError = GetPrintersError;
  exports.WebPrinterFetchError = WebPrinterFetchError;
  exports.WebPrintError = WebPrintError;
  exports.WebPrinterInfo = WebPrinterInfo;
  exports.WebPrintingRange = WebPrintingRange;
  exports.WebPrintingMediaSize = WebPrintingMediaSize;
  exports.WebPrintingMediaCollection = WebPrintingMediaCollection;
  exports.WebPrinterAttributes = WebPrinterAttributes;
  exports.WebPrintingMediaCollectionRequested = WebPrintingMediaCollectionRequested;
  exports.WebPrintJobTemplateAttributes = WebPrintJobTemplateAttributes;
  exports.WebPrintJobUpdate = WebPrintJobUpdate;
  exports.WebPrintJobInfo = WebPrintJobInfo;
  exports.WebPrintingMediaSizeDimension = WebPrintingMediaSizeDimension;
  exports.GetPrintersResult = GetPrintersResult;
  exports.WebPrinterFetchResult = WebPrinterFetchResult;
  exports.WebPrintResult = WebPrintResult;
  exports.WebPrintJobStateObserver = WebPrintJobStateObserver;
  exports.WebPrintJobStateObserverPtr = WebPrintJobStateObserverPtr;
  exports.WebPrintJobStateObserverAssociatedPtr = WebPrintJobStateObserverAssociatedPtr;
  exports.WebPrintJobController = WebPrintJobController;
  exports.WebPrintJobControllerPtr = WebPrintJobControllerPtr;
  exports.WebPrintJobControllerAssociatedPtr = WebPrintJobControllerAssociatedPtr;
  exports.WebPrinter = WebPrinter;
  exports.WebPrinterPtr = WebPrinterPtr;
  exports.WebPrinterAssociatedPtr = WebPrinterAssociatedPtr;
  exports.WebPrintingService = WebPrintingService;
  exports.WebPrintingServicePtr = WebPrintingServicePtr;
  exports.WebPrintingServiceAssociatedPtr = WebPrintingServiceAssociatedPtr;
})();