// third_party/blink/public/mojom/printing/web_printing.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_PRINTING_WEB_PRINTING_MOJOM_SHARED_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_PRINTING_WEB_PRINTING_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/printing/web_printing.mojom-shared-internal.h"
#include "third_party/blink/public/mojom/blob/blob.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "third_party/blink/public/mojom/printing/web_printing.mojom-data-view.h"
#include "base/component_export.h"




namespace std {

template <>
struct hash<::blink::mojom::WebPrintingMultipleDocumentHandling>
    : public mojo::internal::EnumHashImpl<::blink::mojom::WebPrintingMultipleDocumentHandling> {};

template <>
struct hash<::blink::mojom::WebPrintingSides>
    : public mojo::internal::EnumHashImpl<::blink::mojom::WebPrintingSides> {};

template <>
struct hash<::blink::mojom::WebPrintQuality>
    : public mojo::internal::EnumHashImpl<::blink::mojom::WebPrintQuality> {};

template <>
struct hash<::blink::mojom::WebPrintColorMode>
    : public mojo::internal::EnumHashImpl<::blink::mojom::WebPrintColorMode> {};

template <>
struct hash<::blink::mojom::WebPrintingOrientationRequested>
    : public mojo::internal::EnumHashImpl<::blink::mojom::WebPrintingOrientationRequested> {};

template <>
struct hash<::blink::mojom::WebPrinterState>
    : public mojo::internal::EnumHashImpl<::blink::mojom::WebPrinterState> {};

template <>
struct hash<::blink::mojom::WebPrinterStateReason>
    : public mojo::internal::EnumHashImpl<::blink::mojom::WebPrinterStateReason> {};

template <>
struct hash<::blink::mojom::WebPrintJobState>
    : public mojo::internal::EnumHashImpl<::blink::mojom::WebPrintJobState> {};

template <>
struct hash<::blink::mojom::GetPrintersError>
    : public mojo::internal::EnumHashImpl<::blink::mojom::GetPrintersError> {};

template <>
struct hash<::blink::mojom::WebPrinterFetchError>
    : public mojo::internal::EnumHashImpl<::blink::mojom::WebPrinterFetchError> {};

template <>
struct hash<::blink::mojom::WebPrintError>
    : public mojo::internal::EnumHashImpl<::blink::mojom::WebPrintError> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::WebPrintingMultipleDocumentHandling, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::WebPrintingMultipleDocumentHandling, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::WebPrintingMultipleDocumentHandling>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::WebPrintingSides, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::WebPrintingSides, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::WebPrintingSides>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::WebPrintQuality, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::WebPrintQuality, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::WebPrintQuality>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::WebPrintColorMode, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::WebPrintColorMode, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::WebPrintColorMode>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::WebPrintingOrientationRequested, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::WebPrintingOrientationRequested, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::WebPrintingOrientationRequested>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::WebPrinterState, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::WebPrinterState, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::WebPrinterState>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::WebPrinterStateReason, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::WebPrinterStateReason, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::WebPrinterStateReason>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::WebPrintJobState, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::WebPrintJobState, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::WebPrintJobState>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::GetPrintersError, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::GetPrintersError, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::GetPrintersError>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::WebPrinterFetchError, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::WebPrinterFetchError, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::WebPrinterFetchError>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::WebPrintError, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::WebPrintError, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::WebPrintError>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::WebPrinterInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::WebPrinterInfoDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::WebPrinterInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::printer_name(input)) in_printer_name = Traits::printer_name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->printer_name)::BaseType> printer_name_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_printer_name,
      printer_name_fragment);

    fragment->printer_name.Set(
        printer_name_fragment.is_null() ? nullptr : printer_name_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->printer_name.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null printer_name in WebPrinterInfo struct");

    decltype(Traits::printer_id(input)) in_printer_id = Traits::printer_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->printer_id)::BaseType> printer_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_printer_id,
      printer_id_fragment);

    fragment->printer_id.Set(
        printer_id_fragment.is_null() ? nullptr : printer_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->printer_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null printer_id in WebPrinterInfo struct");

    decltype(Traits::printer_remote(input)) in_printer_remote = Traits::printer_remote(input);

    
    mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::WebPrinterInterfaceBase>>(
      in_printer_remote,
      &fragment->printer_remote,
      &fragment.message());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(!mojo::internal::IsHandleOrInterfaceValid(fragment->printer_remote)),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid printer_remote in WebPrinterInfo struct");
  }

  static bool Deserialize(::blink::mojom::internal::WebPrinterInfo_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::WebPrinterInfoDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::WebPrintingRangeDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::WebPrintingRangeDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::WebPrintingRange_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->from = Traits::from(input);

    fragment->to = Traits::to(input);
  }

  static bool Deserialize(::blink::mojom::internal::WebPrintingRange_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::WebPrintingRangeDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::WebPrintingMediaSizeDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::WebPrintingMediaSizeDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::WebPrintingMediaSize_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::x_dimension(input)) in_x_dimension = Traits::x_dimension(input);
    mojo::internal::MessageFragment<decltype(fragment->x_dimension)>
        x_dimension_fragment(fragment.message());
    x_dimension_fragment.Claim(&fragment->x_dimension);
    
    mojo::internal::Serialize<::blink::mojom::WebPrintingMediaSizeDimensionDataView>(
      in_x_dimension,
      x_dimension_fragment,
      true);

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->x_dimension.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null x_dimension in WebPrintingMediaSize struct");

    decltype(Traits::y_dimension(input)) in_y_dimension = Traits::y_dimension(input);
    mojo::internal::MessageFragment<decltype(fragment->y_dimension)>
        y_dimension_fragment(fragment.message());
    y_dimension_fragment.Claim(&fragment->y_dimension);
    
    mojo::internal::Serialize<::blink::mojom::WebPrintingMediaSizeDimensionDataView>(
      in_y_dimension,
      y_dimension_fragment,
      true);

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->y_dimension.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null y_dimension in WebPrintingMediaSize struct");
  }

  static bool Deserialize(::blink::mojom::internal::WebPrintingMediaSize_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::WebPrintingMediaSizeDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::WebPrintingMediaCollectionDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::WebPrintingMediaCollectionDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::WebPrintingMediaCollection_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::media_size(input)) in_media_size = Traits::media_size(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->media_size)::BaseType> media_size_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::blink::mojom::WebPrintingMediaSizeDataView>(
      in_media_size,
      media_size_fragment);

    fragment->media_size.Set(
        media_size_fragment.is_null() ? nullptr : media_size_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->media_size.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null media_size in WebPrintingMediaCollection struct");

    decltype(Traits::media_size_name(input)) in_media_size_name = Traits::media_size_name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->media_size_name)::BaseType> media_size_name_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_media_size_name,
      media_size_name_fragment);

    fragment->media_size_name.Set(
        media_size_name_fragment.is_null() ? nullptr : media_size_name_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->media_size_name.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null media_size_name in WebPrintingMediaCollection struct");
  }

  static bool Deserialize(::blink::mojom::internal::WebPrintingMediaCollection_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::WebPrintingMediaCollectionDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::WebPrinterAttributesDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::WebPrinterAttributesDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::WebPrinterAttributes_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->copies_default = Traits::copies_default(input);

    decltype(Traits::copies_supported(input)) in_copies_supported = Traits::copies_supported(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->copies_supported)::BaseType> copies_supported_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::blink::mojom::WebPrintingRangeDataView>(
      in_copies_supported,
      copies_supported_fragment);

    fragment->copies_supported.Set(
        copies_supported_fragment.is_null() ? nullptr : copies_supported_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->copies_supported.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null copies_supported in WebPrinterAttributes struct");

    decltype(Traits::media_col_default(input)) in_media_col_default = Traits::media_col_default(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->media_col_default)::BaseType> media_col_default_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::blink::mojom::WebPrintingMediaCollectionDataView>(
      in_media_col_default,
      media_col_default_fragment);

    fragment->media_col_default.Set(
        media_col_default_fragment.is_null() ? nullptr : media_col_default_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->media_col_default.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null media_col_default in WebPrinterAttributes struct");

    decltype(Traits::media_col_database(input)) in_media_col_database = Traits::media_col_database(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->media_col_database)::BaseType>
        media_col_database_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& media_col_database_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::WebPrintingMediaCollectionDataView>>(
      in_media_col_database,
      media_col_database_fragment,
      &media_col_database_validate_params);

    fragment->media_col_database.Set(
        media_col_database_fragment.is_null() ? nullptr : media_col_database_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->media_col_database.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null media_col_database in WebPrinterAttributes struct");

    decltype(Traits::media_source_default(input)) in_media_source_default = Traits::media_source_default(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->media_source_default)::BaseType> media_source_default_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_media_source_default,
      media_source_default_fragment);

    fragment->media_source_default.Set(
        media_source_default_fragment.is_null() ? nullptr : media_source_default_fragment.data());

    decltype(Traits::media_source_supported(input)) in_media_source_supported = Traits::media_source_supported(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->media_source_supported)::BaseType>
        media_source_supported_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& media_source_supported_validate_params =
        mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
      in_media_source_supported,
      media_source_supported_fragment,
      &media_source_supported_validate_params);

    fragment->media_source_supported.Set(
        media_source_supported_fragment.is_null() ? nullptr : media_source_supported_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->media_source_supported.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null media_source_supported in WebPrinterAttributes struct");

    
    mojo::internal::Serialize<::blink::mojom::WebPrintingMultipleDocumentHandling>(
      Traits::multiple_document_handling_default(input),
      &fragment->multiple_document_handling_default);

    decltype(Traits::multiple_document_handling_supported(input)) in_multiple_document_handling_supported = Traits::multiple_document_handling_supported(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->multiple_document_handling_supported)::BaseType>
        multiple_document_handling_supported_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& multiple_document_handling_supported_validate_params =
        mojo::internal::GetArrayOfEnumsValidator<0, false, ::blink::mojom::internal::WebPrintingMultipleDocumentHandling_Data::Validate>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::WebPrintingMultipleDocumentHandling>>(
      in_multiple_document_handling_supported,
      multiple_document_handling_supported_fragment,
      &multiple_document_handling_supported_validate_params);

    fragment->multiple_document_handling_supported.Set(
        multiple_document_handling_supported_fragment.is_null() ? nullptr : multiple_document_handling_supported_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->multiple_document_handling_supported.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null multiple_document_handling_supported in WebPrinterAttributes struct");

    
    mojo::internal::Serialize<::blink::mojom::WebPrintingOrientationRequested>(
      Traits::orientation_requested_default(input),
      &fragment->orientation_requested_default);

    decltype(Traits::orientation_requested_supported(input)) in_orientation_requested_supported = Traits::orientation_requested_supported(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->orientation_requested_supported)::BaseType>
        orientation_requested_supported_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& orientation_requested_supported_validate_params =
        mojo::internal::GetArrayOfEnumsValidator<0, false, ::blink::mojom::internal::WebPrintingOrientationRequested_Data::Validate>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::WebPrintingOrientationRequested>>(
      in_orientation_requested_supported,
      orientation_requested_supported_fragment,
      &orientation_requested_supported_validate_params);

    fragment->orientation_requested_supported.Set(
        orientation_requested_supported_fragment.is_null() ? nullptr : orientation_requested_supported_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->orientation_requested_supported.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null orientation_requested_supported in WebPrinterAttributes struct");

    decltype(Traits::printer_resolution_default(input)) in_printer_resolution_default = Traits::printer_resolution_default(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->printer_resolution_default)::BaseType> printer_resolution_default_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::gfx::mojom::SizeDataView>(
      in_printer_resolution_default,
      printer_resolution_default_fragment);

    fragment->printer_resolution_default.Set(
        printer_resolution_default_fragment.is_null() ? nullptr : printer_resolution_default_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->printer_resolution_default.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null printer_resolution_default in WebPrinterAttributes struct");

    decltype(Traits::printer_resolution_supported(input)) in_printer_resolution_supported = Traits::printer_resolution_supported(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->printer_resolution_supported)::BaseType>
        printer_resolution_supported_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& printer_resolution_supported_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::gfx::mojom::SizeDataView>>(
      in_printer_resolution_supported,
      printer_resolution_supported_fragment,
      &printer_resolution_supported_validate_params);

    fragment->printer_resolution_supported.Set(
        printer_resolution_supported_fragment.is_null() ? nullptr : printer_resolution_supported_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->printer_resolution_supported.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null printer_resolution_supported in WebPrinterAttributes struct");

    
    mojo::internal::Serialize<::blink::mojom::WebPrintColorMode>(
      Traits::print_color_mode_default(input),
      &fragment->print_color_mode_default);

    decltype(Traits::print_color_mode_supported(input)) in_print_color_mode_supported = Traits::print_color_mode_supported(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->print_color_mode_supported)::BaseType>
        print_color_mode_supported_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& print_color_mode_supported_validate_params =
        mojo::internal::GetArrayOfEnumsValidator<0, false, ::blink::mojom::internal::WebPrintColorMode_Data::Validate>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::WebPrintColorMode>>(
      in_print_color_mode_supported,
      print_color_mode_supported_fragment,
      &print_color_mode_supported_validate_params);

    fragment->print_color_mode_supported.Set(
        print_color_mode_supported_fragment.is_null() ? nullptr : print_color_mode_supported_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->print_color_mode_supported.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null print_color_mode_supported in WebPrinterAttributes struct");
    fragment->print_quality_default_$flag = Traits::print_quality_default(input).has_value();
    if (Traits::print_quality_default(input).has_value()) {
      
      mojo::internal::Serialize<::blink::mojom::WebPrintQuality>(
        Traits::print_quality_default(input).value(),
        &fragment->print_quality_default_$value);
    } else {
      fragment->print_quality_default_$value =
          static_cast<int32_t>(::blink::mojom::WebPrintQuality::kMinValue);
    }

    decltype(Traits::print_quality_supported(input)) in_print_quality_supported = Traits::print_quality_supported(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->print_quality_supported)::BaseType>
        print_quality_supported_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& print_quality_supported_validate_params =
        mojo::internal::GetArrayOfEnumsValidator<0, false, ::blink::mojom::internal::WebPrintQuality_Data::Validate>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::WebPrintQuality>>(
      in_print_quality_supported,
      print_quality_supported_fragment,
      &print_quality_supported_validate_params);

    fragment->print_quality_supported.Set(
        print_quality_supported_fragment.is_null() ? nullptr : print_quality_supported_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->print_quality_supported.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null print_quality_supported in WebPrinterAttributes struct");

    
    mojo::internal::Serialize<::blink::mojom::WebPrinterState>(
      Traits::printer_state(input),
      &fragment->printer_state);

    decltype(Traits::printer_state_message(input)) in_printer_state_message = Traits::printer_state_message(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->printer_state_message)::BaseType> printer_state_message_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_printer_state_message,
      printer_state_message_fragment);

    fragment->printer_state_message.Set(
        printer_state_message_fragment.is_null() ? nullptr : printer_state_message_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->printer_state_message.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null printer_state_message in WebPrinterAttributes struct");

    decltype(Traits::printer_state_reasons(input)) in_printer_state_reasons = Traits::printer_state_reasons(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->printer_state_reasons)::BaseType>
        printer_state_reasons_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& printer_state_reasons_validate_params =
        mojo::internal::GetArrayOfEnumsValidator<0, false, ::blink::mojom::internal::WebPrinterStateReason_Data::Validate>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::WebPrinterStateReason>>(
      in_printer_state_reasons,
      printer_state_reasons_fragment,
      &printer_state_reasons_validate_params);

    fragment->printer_state_reasons.Set(
        printer_state_reasons_fragment.is_null() ? nullptr : printer_state_reasons_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->printer_state_reasons.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null printer_state_reasons in WebPrinterAttributes struct");
    fragment->sides_default_$flag = Traits::sides_default(input).has_value();
    if (Traits::sides_default(input).has_value()) {
      
      mojo::internal::Serialize<::blink::mojom::WebPrintingSides>(
        Traits::sides_default(input).value(),
        &fragment->sides_default_$value);
    } else {
      fragment->sides_default_$value =
          static_cast<int32_t>(::blink::mojom::WebPrintingSides::kMinValue);
    }

    decltype(Traits::sides_supported(input)) in_sides_supported = Traits::sides_supported(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->sides_supported)::BaseType>
        sides_supported_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& sides_supported_validate_params =
        mojo::internal::GetArrayOfEnumsValidator<0, false, ::blink::mojom::internal::WebPrintingSides_Data::Validate>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::WebPrintingSides>>(
      in_sides_supported,
      sides_supported_fragment,
      &sides_supported_validate_params);

    fragment->sides_supported.Set(
        sides_supported_fragment.is_null() ? nullptr : sides_supported_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->sides_supported.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null sides_supported in WebPrinterAttributes struct");

    decltype(Traits::printer_id(input)) in_printer_id = Traits::printer_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->printer_id)::BaseType> printer_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_printer_id,
      printer_id_fragment);

    fragment->printer_id.Set(
        printer_id_fragment.is_null() ? nullptr : printer_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->printer_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null printer_id in WebPrinterAttributes struct");
  }

  static bool Deserialize(::blink::mojom::internal::WebPrinterAttributes_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::WebPrinterAttributesDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::WebPrintingMediaCollectionRequestedDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::WebPrintingMediaCollectionRequestedDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::WebPrintingMediaCollectionRequested_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::media_size(input)) in_media_size = Traits::media_size(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->media_size)::BaseType> media_size_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::gfx::mojom::SizeDataView>(
      in_media_size,
      media_size_fragment);

    fragment->media_size.Set(
        media_size_fragment.is_null() ? nullptr : media_size_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->media_size.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null media_size in WebPrintingMediaCollectionRequested struct");
  }

  static bool Deserialize(::blink::mojom::internal::WebPrintingMediaCollectionRequested_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::WebPrintingMediaCollectionRequestedDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::WebPrintJobTemplateAttributesDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::WebPrintJobTemplateAttributesDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::WebPrintJobTemplateAttributes_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::job_name(input)) in_job_name = Traits::job_name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->job_name)::BaseType> job_name_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_job_name,
      job_name_fragment);

    fragment->job_name.Set(
        job_name_fragment.is_null() ? nullptr : job_name_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->job_name.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null job_name in WebPrintJobTemplateAttributes struct");

    fragment->copies = Traits::copies(input);

    decltype(Traits::media_col(input)) in_media_col = Traits::media_col(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->media_col)::BaseType> media_col_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::blink::mojom::WebPrintingMediaCollectionRequestedDataView>(
      in_media_col,
      media_col_fragment);

    fragment->media_col.Set(
        media_col_fragment.is_null() ? nullptr : media_col_fragment.data());

    decltype(Traits::media_source(input)) in_media_source = Traits::media_source(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->media_source)::BaseType> media_source_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_media_source,
      media_source_fragment);

    fragment->media_source.Set(
        media_source_fragment.is_null() ? nullptr : media_source_fragment.data());
    fragment->multiple_document_handling_$flag = Traits::multiple_document_handling(input).has_value();
    if (Traits::multiple_document_handling(input).has_value()) {
      
      mojo::internal::Serialize<::blink::mojom::WebPrintingMultipleDocumentHandling>(
        Traits::multiple_document_handling(input).value(),
        &fragment->multiple_document_handling_$value);
    } else {
      fragment->multiple_document_handling_$value =
          static_cast<int32_t>(::blink::mojom::WebPrintingMultipleDocumentHandling::kMinValue);
    }
    fragment->orientation_requested_$flag = Traits::orientation_requested(input).has_value();
    if (Traits::orientation_requested(input).has_value()) {
      
      mojo::internal::Serialize<::blink::mojom::WebPrintingOrientationRequested>(
        Traits::orientation_requested(input).value(),
        &fragment->orientation_requested_$value);
    } else {
      fragment->orientation_requested_$value =
          static_cast<int32_t>(::blink::mojom::WebPrintingOrientationRequested::kMinValue);
    }

    decltype(Traits::printer_resolution(input)) in_printer_resolution = Traits::printer_resolution(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->printer_resolution)::BaseType> printer_resolution_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::gfx::mojom::SizeDataView>(
      in_printer_resolution,
      printer_resolution_fragment);

    fragment->printer_resolution.Set(
        printer_resolution_fragment.is_null() ? nullptr : printer_resolution_fragment.data());
    fragment->print_color_mode_$flag = Traits::print_color_mode(input).has_value();
    if (Traits::print_color_mode(input).has_value()) {
      
      mojo::internal::Serialize<::blink::mojom::WebPrintColorMode>(
        Traits::print_color_mode(input).value(),
        &fragment->print_color_mode_$value);
    } else {
      fragment->print_color_mode_$value =
          static_cast<int32_t>(::blink::mojom::WebPrintColorMode::kMinValue);
    }
    fragment->print_quality_$flag = Traits::print_quality(input).has_value();
    if (Traits::print_quality(input).has_value()) {
      
      mojo::internal::Serialize<::blink::mojom::WebPrintQuality>(
        Traits::print_quality(input).value(),
        &fragment->print_quality_$value);
    } else {
      fragment->print_quality_$value =
          static_cast<int32_t>(::blink::mojom::WebPrintQuality::kMinValue);
    }
    fragment->sides_$flag = Traits::sides(input).has_value();
    if (Traits::sides(input).has_value()) {
      
      mojo::internal::Serialize<::blink::mojom::WebPrintingSides>(
        Traits::sides(input).value(),
        &fragment->sides_$value);
    } else {
      fragment->sides_$value =
          static_cast<int32_t>(::blink::mojom::WebPrintingSides::kMinValue);
    }
  }

  static bool Deserialize(::blink::mojom::internal::WebPrintJobTemplateAttributes_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::WebPrintJobTemplateAttributesDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::WebPrintJobUpdateDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::WebPrintJobUpdateDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::WebPrintJobUpdate_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    
    mojo::internal::Serialize<::blink::mojom::WebPrintJobState>(
      Traits::state(input),
      &fragment->state);

    fragment->pages_printed = Traits::pages_printed(input);
  }

  static bool Deserialize(::blink::mojom::internal::WebPrintJobUpdate_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::WebPrintJobUpdateDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::WebPrintJobInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::WebPrintJobInfoDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::WebPrintJobInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::job_name(input)) in_job_name = Traits::job_name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->job_name)::BaseType> job_name_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_job_name,
      job_name_fragment);

    fragment->job_name.Set(
        job_name_fragment.is_null() ? nullptr : job_name_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->job_name.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null job_name in WebPrintJobInfo struct");

    fragment->job_pages = Traits::job_pages(input);

    decltype(Traits::observer(input)) in_observer = Traits::observer(input);

    
    mojo::internal::Serialize<mojo::InterfaceRequestDataView<::blink::mojom::WebPrintJobStateObserverInterfaceBase>>(
      in_observer,
      &fragment->observer,
      &fragment.message());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(!mojo::internal::IsHandleOrInterfaceValid(fragment->observer)),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid observer in WebPrintJobInfo struct");

    decltype(Traits::controller(input)) in_controller = Traits::controller(input);

    
    mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::WebPrintJobControllerInterfaceBase>>(
      in_controller,
      &fragment->controller,
      &fragment.message());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(!mojo::internal::IsHandleOrInterfaceValid(fragment->controller)),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid controller in WebPrintJobInfo struct");
  }

  static bool Deserialize(::blink::mojom::internal::WebPrintJobInfo_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::WebPrintJobInfoDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::WebPrintingMediaSizeDimensionDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::blink::mojom::WebPrintingMediaSizeDimensionDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::blink::mojom::internal::WebPrintingMediaSizeDimension_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::blink::mojom::WebPrintingMediaSizeDimensionDataView::Tag::kRange: {
    decltype(Traits::range(input))
    in_range = Traits::range(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_range)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::blink::mojom::WebPrintingRangeDataView>(
  in_range,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null range in WebPrintingMediaSizeDimension union");
    fragment->data.f_range.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::blink::mojom::WebPrintingMediaSizeDimensionDataView::Tag::kValue: {
    decltype(Traits::value(input))
    in_value = Traits::value(input);
    fragment->data.f_value = in_value;
    break;
  }
}
  }

  static bool Deserialize(::blink::mojom::internal::WebPrintingMediaSizeDimension_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::WebPrintingMediaSizeDimensionDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::GetPrintersResultDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::blink::mojom::GetPrintersResultDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::blink::mojom::internal::GetPrintersResult_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::blink::mojom::GetPrintersResultDataView::Tag::kPrinters: {
    decltype(Traits::printers(input))
    in_printers = Traits::printers(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_printers)::BaseType>
    value_fragment(fragment.message());
        constexpr const mojo::internal::ContainerValidateParams& printers_validate_params =
            mojo::internal::GetArrayValidator<0, false, nullptr>();
        
mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::WebPrinterInfoDataView>>(
  in_printers,
  value_fragment,
  &printers_validate_params);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null printers in GetPrintersResult union");
    fragment->data.f_printers.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::blink::mojom::GetPrintersResultDataView::Tag::kError: {
    decltype(Traits::error(input))
    in_error = Traits::error(input);
        
mojo::internal::Serialize<::blink::mojom::GetPrintersError>(
  in_error,
  &fragment->data.f_error);
    break;
  }
}
  }

  static bool Deserialize(::blink::mojom::internal::GetPrintersResult_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::GetPrintersResultDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::WebPrinterFetchResultDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::blink::mojom::WebPrinterFetchResultDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::blink::mojom::internal::WebPrinterFetchResult_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::blink::mojom::WebPrinterFetchResultDataView::Tag::kPrinterAttributes: {
    decltype(Traits::printer_attributes(input))
    in_printer_attributes = Traits::printer_attributes(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_printer_attributes)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::blink::mojom::WebPrinterAttributesDataView>(
  in_printer_attributes,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null printer_attributes in WebPrinterFetchResult union");
    fragment->data.f_printer_attributes.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::blink::mojom::WebPrinterFetchResultDataView::Tag::kError: {
    decltype(Traits::error(input))
    in_error = Traits::error(input);
        
mojo::internal::Serialize<::blink::mojom::WebPrinterFetchError>(
  in_error,
  &fragment->data.f_error);
    break;
  }
}
  }

  static bool Deserialize(::blink::mojom::internal::WebPrinterFetchResult_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::WebPrinterFetchResultDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::WebPrintResultDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::blink::mojom::WebPrintResultDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::blink::mojom::internal::WebPrintResult_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::blink::mojom::WebPrintResultDataView::Tag::kPrintJobInfo: {
    decltype(Traits::print_job_info(input))
    in_print_job_info = Traits::print_job_info(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_print_job_info)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::blink::mojom::WebPrintJobInfoDataView>(
  in_print_job_info,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null print_job_info in WebPrintResult union");
    fragment->data.f_print_job_info.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::blink::mojom::WebPrintResultDataView::Tag::kError: {
    decltype(Traits::error(input))
    in_error = Traits::error(input);
        
mojo::internal::Serialize<::blink::mojom::WebPrintError>(
  in_error,
  &fragment->data.f_error);
    break;
  }
}
  }

  static bool Deserialize(::blink::mojom::internal::WebPrintResult_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::WebPrintResultDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace blink::mojom {

inline void WebPrinterInfoDataView::GetPrinterNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->printer_name.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void WebPrinterInfoDataView::GetPrinterIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->printer_id.Get();
  *output = mojo::StringDataView(pointer, message_);
}




inline void WebPrintingMediaSizeDataView::GetXDimensionDataView(
    WebPrintingMediaSizeDimensionDataView* output) {
  auto pointer = &data_->x_dimension;
  *output = WebPrintingMediaSizeDimensionDataView(pointer, message_);
}
inline void WebPrintingMediaSizeDataView::GetYDimensionDataView(
    WebPrintingMediaSizeDimensionDataView* output) {
  auto pointer = &data_->y_dimension;
  *output = WebPrintingMediaSizeDimensionDataView(pointer, message_);
}


inline void WebPrintingMediaCollectionDataView::GetMediaSizeDataView(
    WebPrintingMediaSizeDataView* output) {
  auto pointer = data_->media_size.Get();
  *output = WebPrintingMediaSizeDataView(pointer, message_);
}
inline void WebPrintingMediaCollectionDataView::GetMediaSizeNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->media_size_name.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void WebPrinterAttributesDataView::GetCopiesSupportedDataView(
    WebPrintingRangeDataView* output) {
  auto pointer = data_->copies_supported.Get();
  *output = WebPrintingRangeDataView(pointer, message_);
}
inline void WebPrinterAttributesDataView::GetMediaColDefaultDataView(
    WebPrintingMediaCollectionDataView* output) {
  auto pointer = data_->media_col_default.Get();
  *output = WebPrintingMediaCollectionDataView(pointer, message_);
}
inline void WebPrinterAttributesDataView::GetMediaColDatabaseDataView(
    mojo::ArrayDataView<WebPrintingMediaCollectionDataView>* output) {
  auto pointer = data_->media_col_database.Get();
  *output = mojo::ArrayDataView<WebPrintingMediaCollectionDataView>(pointer, message_);
}
inline void WebPrinterAttributesDataView::GetMediaSourceDefaultDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->media_source_default.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void WebPrinterAttributesDataView::GetMediaSourceSupportedDataView(
    mojo::ArrayDataView<mojo::StringDataView>* output) {
  auto pointer = data_->media_source_supported.Get();
  *output = mojo::ArrayDataView<mojo::StringDataView>(pointer, message_);
}
inline void WebPrinterAttributesDataView::GetMultipleDocumentHandlingSupportedDataView(
    mojo::ArrayDataView<WebPrintingMultipleDocumentHandling>* output) {
  auto pointer = data_->multiple_document_handling_supported.Get();
  *output = mojo::ArrayDataView<WebPrintingMultipleDocumentHandling>(pointer, message_);
}
inline void WebPrinterAttributesDataView::GetOrientationRequestedSupportedDataView(
    mojo::ArrayDataView<WebPrintingOrientationRequested>* output) {
  auto pointer = data_->orientation_requested_supported.Get();
  *output = mojo::ArrayDataView<WebPrintingOrientationRequested>(pointer, message_);
}
inline void WebPrinterAttributesDataView::GetPrinterResolutionDefaultDataView(
    ::gfx::mojom::SizeDataView* output) {
  auto pointer = data_->printer_resolution_default.Get();
  *output = ::gfx::mojom::SizeDataView(pointer, message_);
}
inline void WebPrinterAttributesDataView::GetPrinterResolutionSupportedDataView(
    mojo::ArrayDataView<::gfx::mojom::SizeDataView>* output) {
  auto pointer = data_->printer_resolution_supported.Get();
  *output = mojo::ArrayDataView<::gfx::mojom::SizeDataView>(pointer, message_);
}
inline void WebPrinterAttributesDataView::GetPrintColorModeSupportedDataView(
    mojo::ArrayDataView<WebPrintColorMode>* output) {
  auto pointer = data_->print_color_mode_supported.Get();
  *output = mojo::ArrayDataView<WebPrintColorMode>(pointer, message_);
}
inline void WebPrinterAttributesDataView::GetPrintQualitySupportedDataView(
    mojo::ArrayDataView<WebPrintQuality>* output) {
  auto pointer = data_->print_quality_supported.Get();
  *output = mojo::ArrayDataView<WebPrintQuality>(pointer, message_);
}
inline void WebPrinterAttributesDataView::GetPrinterStateMessageDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->printer_state_message.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void WebPrinterAttributesDataView::GetPrinterStateReasonsDataView(
    mojo::ArrayDataView<WebPrinterStateReason>* output) {
  auto pointer = data_->printer_state_reasons.Get();
  *output = mojo::ArrayDataView<WebPrinterStateReason>(pointer, message_);
}
inline void WebPrinterAttributesDataView::GetSidesSupportedDataView(
    mojo::ArrayDataView<WebPrintingSides>* output) {
  auto pointer = data_->sides_supported.Get();
  *output = mojo::ArrayDataView<WebPrintingSides>(pointer, message_);
}
inline void WebPrinterAttributesDataView::GetPrinterIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->printer_id.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void WebPrintingMediaCollectionRequestedDataView::GetMediaSizeDataView(
    ::gfx::mojom::SizeDataView* output) {
  auto pointer = data_->media_size.Get();
  *output = ::gfx::mojom::SizeDataView(pointer, message_);
}


inline void WebPrintJobTemplateAttributesDataView::GetJobNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->job_name.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void WebPrintJobTemplateAttributesDataView::GetMediaColDataView(
    WebPrintingMediaCollectionRequestedDataView* output) {
  auto pointer = data_->media_col.Get();
  *output = WebPrintingMediaCollectionRequestedDataView(pointer, message_);
}
inline void WebPrintJobTemplateAttributesDataView::GetMediaSourceDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->media_source.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void WebPrintJobTemplateAttributesDataView::GetPrinterResolutionDataView(
    ::gfx::mojom::SizeDataView* output) {
  auto pointer = data_->printer_resolution.Get();
  *output = ::gfx::mojom::SizeDataView(pointer, message_);
}




inline void WebPrintJobInfoDataView::GetJobNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->job_name.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void WebPrintingMediaSizeDimensionDataView::GetRangeDataView(
    WebPrintingRangeDataView* output) const {
  CHECK(is_range());
  *output = WebPrintingRangeDataView(data_->data.f_range.Get(), message_);
}

inline void GetPrintersResultDataView::GetPrintersDataView(
    mojo::ArrayDataView<WebPrinterInfoDataView>* output) const {
  CHECK(is_printers());
  *output = mojo::ArrayDataView<WebPrinterInfoDataView>(data_->data.f_printers.Get(), message_);
}

inline void WebPrinterFetchResultDataView::GetPrinterAttributesDataView(
    WebPrinterAttributesDataView* output) const {
  CHECK(is_printer_attributes());
  *output = WebPrinterAttributesDataView(data_->data.f_printer_attributes.Get(), message_);
}

inline void WebPrintResultDataView::GetPrintJobInfoDataView(
    WebPrintJobInfoDataView* output) const {
  CHECK(is_print_job_info());
  *output = WebPrintJobInfoDataView(data_->data.f_print_job_info.Get(), message_);
}


}  // blink::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::blink::mojom::WebPrintingMultipleDocumentHandling> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::blink::mojom::WebPrintingMultipleDocumentHandling value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::blink::mojom::WebPrintingSides> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::blink::mojom::WebPrintingSides value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::blink::mojom::WebPrintQuality> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::blink::mojom::WebPrintQuality value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::blink::mojom::WebPrintColorMode> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::blink::mojom::WebPrintColorMode value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::blink::mojom::WebPrintingOrientationRequested> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::blink::mojom::WebPrintingOrientationRequested value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::blink::mojom::WebPrinterState> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::blink::mojom::WebPrinterState value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::blink::mojom::WebPrinterStateReason> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::blink::mojom::WebPrinterStateReason value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::blink::mojom::WebPrintJobState> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::blink::mojom::WebPrintJobState value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::blink::mojom::GetPrintersError> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::blink::mojom::GetPrintersError value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::blink::mojom::WebPrinterFetchError> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::blink::mojom::WebPrinterFetchError value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::blink::mojom::WebPrintError> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::blink::mojom::WebPrintError value);
};

} // namespace perfetto

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_PRINTING_WEB_PRINTING_MOJOM_SHARED_H_