// third_party/blink/public/mojom/printing/web_printing.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_PRINTING_WEB_PRINTING_MOJOM_SEND_VALIDATION_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_PRINTING_WEB_PRINTING_MOJOM_SEND_VALIDATION_H_

#include "third_party/blink/public/mojom/printing/web_printing.mojom-shared-internal.h"
#include "third_party/blink/public/mojom/blob/blob.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"

#include "third_party/blink/public/mojom/printing/web_printing.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization_send_validation.h"
#include "mojo/public/cpp/bindings/lib/has_send_validation_helper.h"

namespace mojo::internal {
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::blink::mojom::WebPrintingMultipleDocumentHandling, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::blink::mojom::WebPrintingSides, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::blink::mojom::WebPrintQuality, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::blink::mojom::WebPrintColorMode, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::blink::mojom::WebPrintingOrientationRequested, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::blink::mojom::WebPrinterState, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::blink::mojom::WebPrinterStateReason, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::blink::mojom::WebPrintJobState, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::blink::mojom::GetPrintersError, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::blink::mojom::WebPrinterFetchError, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::blink::mojom::WebPrintError, MaybeConstUserType>
    : std::false_type {};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::blink::mojom::WebPrinterInfoDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::WebPrinterInfoDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::WebPrinterInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::printer_name(input)) in_printer_name = Traits::printer_name(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->printer_name)::BaseType> printer_name_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_printer_name,
        printer_name_fragment);

      fragment->printer_name.Set(
          printer_name_fragment.is_null() ? nullptr : printer_name_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->printer_name.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null printer_name in WebPrinterInfo struct");

      decltype(Traits::printer_id(input)) in_printer_id = Traits::printer_id(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->printer_id)::BaseType> printer_id_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_printer_id,
        printer_id_fragment);

      fragment->printer_id.Set(
          printer_id_fragment.is_null() ? nullptr : printer_id_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->printer_id.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null printer_id in WebPrinterInfo struct");

      decltype(Traits::printer_remote(input)) in_printer_remote = Traits::printer_remote(input);

      
      mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::WebPrinterInterfaceBase>>(
        in_printer_remote,
        &fragment->printer_remote,
        &fragment.message());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(!mojo::internal::IsHandleOrInterfaceValid(fragment->printer_remote)),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
        "invalid printer_remote in WebPrinterInfo struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::blink::mojom::WebPrintingRangeDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::WebPrintingRangeDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::WebPrintingRange_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->from = Traits::from(input);

      fragment->to = Traits::to(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::blink::mojom::WebPrintingMediaSizeDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::WebPrintingMediaSizeDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::WebPrintingMediaSize_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::x_dimension(input)) in_x_dimension = Traits::x_dimension(input);
      mojo::internal::MessageFragment<decltype(fragment->x_dimension)>
          x_dimension_fragment(fragment.message());
      x_dimension_fragment.Claim(&fragment->x_dimension);
      
      mojo::internal::Serialize<::blink::mojom::WebPrintingMediaSizeDimensionDataView, send_validation>(
        in_x_dimension,
        x_dimension_fragment,
        true);

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->x_dimension.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null x_dimension in WebPrintingMediaSize struct");

      decltype(Traits::y_dimension(input)) in_y_dimension = Traits::y_dimension(input);
      mojo::internal::MessageFragment<decltype(fragment->y_dimension)>
          y_dimension_fragment(fragment.message());
      y_dimension_fragment.Claim(&fragment->y_dimension);
      
      mojo::internal::Serialize<::blink::mojom::WebPrintingMediaSizeDimensionDataView, send_validation>(
        in_y_dimension,
        y_dimension_fragment,
        true);

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->y_dimension.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null y_dimension in WebPrintingMediaSize struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::blink::mojom::WebPrintingMediaCollectionDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::WebPrintingMediaCollectionDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::WebPrintingMediaCollection_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::media_size(input)) in_media_size = Traits::media_size(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->media_size)::BaseType> media_size_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::blink::mojom::WebPrintingMediaSizeDataView, send_validation>(
        in_media_size,
        media_size_fragment);

      fragment->media_size.Set(
          media_size_fragment.is_null() ? nullptr : media_size_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->media_size.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null media_size in WebPrintingMediaCollection struct");

      decltype(Traits::media_size_name(input)) in_media_size_name = Traits::media_size_name(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->media_size_name)::BaseType> media_size_name_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_media_size_name,
        media_size_name_fragment);

      fragment->media_size_name.Set(
          media_size_name_fragment.is_null() ? nullptr : media_size_name_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->media_size_name.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null media_size_name in WebPrintingMediaCollection struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::blink::mojom::WebPrinterAttributesDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::WebPrinterAttributesDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::WebPrinterAttributes_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->copies_default = Traits::copies_default(input);

      decltype(Traits::copies_supported(input)) in_copies_supported = Traits::copies_supported(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->copies_supported)::BaseType> copies_supported_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::blink::mojom::WebPrintingRangeDataView, send_validation>(
        in_copies_supported,
        copies_supported_fragment);

      fragment->copies_supported.Set(
          copies_supported_fragment.is_null() ? nullptr : copies_supported_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->copies_supported.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null copies_supported in WebPrinterAttributes struct");

      decltype(Traits::media_col_default(input)) in_media_col_default = Traits::media_col_default(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->media_col_default)::BaseType> media_col_default_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::blink::mojom::WebPrintingMediaCollectionDataView, send_validation>(
        in_media_col_default,
        media_col_default_fragment);

      fragment->media_col_default.Set(
          media_col_default_fragment.is_null() ? nullptr : media_col_default_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->media_col_default.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null media_col_default in WebPrinterAttributes struct");

      decltype(Traits::media_col_database(input)) in_media_col_database = Traits::media_col_database(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->media_col_database)::BaseType>
          media_col_database_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& media_col_database_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::WebPrintingMediaCollectionDataView>, send_validation>(
        in_media_col_database,
        media_col_database_fragment,
        &media_col_database_validate_params);

      fragment->media_col_database.Set(
          media_col_database_fragment.is_null() ? nullptr : media_col_database_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->media_col_database.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null media_col_database in WebPrinterAttributes struct");

      decltype(Traits::media_source_default(input)) in_media_source_default = Traits::media_source_default(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->media_source_default)::BaseType> media_source_default_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_media_source_default,
        media_source_default_fragment);

      fragment->media_source_default.Set(
          media_source_default_fragment.is_null() ? nullptr : media_source_default_fragment.data());

      decltype(Traits::media_source_supported(input)) in_media_source_supported = Traits::media_source_supported(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->media_source_supported)::BaseType>
          media_source_supported_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& media_source_supported_validate_params =
          mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>, send_validation>(
        in_media_source_supported,
        media_source_supported_fragment,
        &media_source_supported_validate_params);

      fragment->media_source_supported.Set(
          media_source_supported_fragment.is_null() ? nullptr : media_source_supported_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->media_source_supported.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null media_source_supported in WebPrinterAttributes struct");

      
      mojo::internal::Serialize<::blink::mojom::WebPrintingMultipleDocumentHandling>(
        Traits::multiple_document_handling_default(input),
        &fragment->multiple_document_handling_default);

      decltype(Traits::multiple_document_handling_supported(input)) in_multiple_document_handling_supported = Traits::multiple_document_handling_supported(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->multiple_document_handling_supported)::BaseType>
          multiple_document_handling_supported_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& multiple_document_handling_supported_validate_params =
          mojo::internal::GetArrayOfEnumsValidator<0, false, ::blink::mojom::internal::WebPrintingMultipleDocumentHandling_Data::Validate>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::WebPrintingMultipleDocumentHandling>, send_validation>(
        in_multiple_document_handling_supported,
        multiple_document_handling_supported_fragment,
        &multiple_document_handling_supported_validate_params);

      fragment->multiple_document_handling_supported.Set(
          multiple_document_handling_supported_fragment.is_null() ? nullptr : multiple_document_handling_supported_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->multiple_document_handling_supported.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null multiple_document_handling_supported in WebPrinterAttributes struct");

      
      mojo::internal::Serialize<::blink::mojom::WebPrintingOrientationRequested>(
        Traits::orientation_requested_default(input),
        &fragment->orientation_requested_default);

      decltype(Traits::orientation_requested_supported(input)) in_orientation_requested_supported = Traits::orientation_requested_supported(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->orientation_requested_supported)::BaseType>
          orientation_requested_supported_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& orientation_requested_supported_validate_params =
          mojo::internal::GetArrayOfEnumsValidator<0, false, ::blink::mojom::internal::WebPrintingOrientationRequested_Data::Validate>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::WebPrintingOrientationRequested>, send_validation>(
        in_orientation_requested_supported,
        orientation_requested_supported_fragment,
        &orientation_requested_supported_validate_params);

      fragment->orientation_requested_supported.Set(
          orientation_requested_supported_fragment.is_null() ? nullptr : orientation_requested_supported_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->orientation_requested_supported.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null orientation_requested_supported in WebPrinterAttributes struct");

      decltype(Traits::printer_resolution_default(input)) in_printer_resolution_default = Traits::printer_resolution_default(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->printer_resolution_default)::BaseType> printer_resolution_default_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::SizeDataView, send_validation>(
        in_printer_resolution_default,
        printer_resolution_default_fragment);

      fragment->printer_resolution_default.Set(
          printer_resolution_default_fragment.is_null() ? nullptr : printer_resolution_default_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->printer_resolution_default.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null printer_resolution_default in WebPrinterAttributes struct");

      decltype(Traits::printer_resolution_supported(input)) in_printer_resolution_supported = Traits::printer_resolution_supported(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->printer_resolution_supported)::BaseType>
          printer_resolution_supported_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& printer_resolution_supported_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::gfx::mojom::SizeDataView>, send_validation>(
        in_printer_resolution_supported,
        printer_resolution_supported_fragment,
        &printer_resolution_supported_validate_params);

      fragment->printer_resolution_supported.Set(
          printer_resolution_supported_fragment.is_null() ? nullptr : printer_resolution_supported_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->printer_resolution_supported.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null printer_resolution_supported in WebPrinterAttributes struct");

      
      mojo::internal::Serialize<::blink::mojom::WebPrintColorMode>(
        Traits::print_color_mode_default(input),
        &fragment->print_color_mode_default);

      decltype(Traits::print_color_mode_supported(input)) in_print_color_mode_supported = Traits::print_color_mode_supported(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->print_color_mode_supported)::BaseType>
          print_color_mode_supported_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& print_color_mode_supported_validate_params =
          mojo::internal::GetArrayOfEnumsValidator<0, false, ::blink::mojom::internal::WebPrintColorMode_Data::Validate>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::WebPrintColorMode>, send_validation>(
        in_print_color_mode_supported,
        print_color_mode_supported_fragment,
        &print_color_mode_supported_validate_params);

      fragment->print_color_mode_supported.Set(
          print_color_mode_supported_fragment.is_null() ? nullptr : print_color_mode_supported_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->print_color_mode_supported.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null print_color_mode_supported in WebPrinterAttributes struct");
      fragment->print_quality_default_$flag = Traits::print_quality_default(input).has_value();
      if (Traits::print_quality_default(input).has_value()) {
        
        mojo::internal::Serialize<::blink::mojom::WebPrintQuality>(
          Traits::print_quality_default(input).value(),
          &fragment->print_quality_default_$value);
      } else {
        fragment->print_quality_default_$value =
            static_cast<int32_t>(::blink::mojom::WebPrintQuality::kMinValue);
      }

      decltype(Traits::print_quality_supported(input)) in_print_quality_supported = Traits::print_quality_supported(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->print_quality_supported)::BaseType>
          print_quality_supported_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& print_quality_supported_validate_params =
          mojo::internal::GetArrayOfEnumsValidator<0, false, ::blink::mojom::internal::WebPrintQuality_Data::Validate>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::WebPrintQuality>, send_validation>(
        in_print_quality_supported,
        print_quality_supported_fragment,
        &print_quality_supported_validate_params);

      fragment->print_quality_supported.Set(
          print_quality_supported_fragment.is_null() ? nullptr : print_quality_supported_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->print_quality_supported.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null print_quality_supported in WebPrinterAttributes struct");

      
      mojo::internal::Serialize<::blink::mojom::WebPrinterState>(
        Traits::printer_state(input),
        &fragment->printer_state);

      decltype(Traits::printer_state_message(input)) in_printer_state_message = Traits::printer_state_message(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->printer_state_message)::BaseType> printer_state_message_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_printer_state_message,
        printer_state_message_fragment);

      fragment->printer_state_message.Set(
          printer_state_message_fragment.is_null() ? nullptr : printer_state_message_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->printer_state_message.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null printer_state_message in WebPrinterAttributes struct");

      decltype(Traits::printer_state_reasons(input)) in_printer_state_reasons = Traits::printer_state_reasons(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->printer_state_reasons)::BaseType>
          printer_state_reasons_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& printer_state_reasons_validate_params =
          mojo::internal::GetArrayOfEnumsValidator<0, false, ::blink::mojom::internal::WebPrinterStateReason_Data::Validate>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::WebPrinterStateReason>, send_validation>(
        in_printer_state_reasons,
        printer_state_reasons_fragment,
        &printer_state_reasons_validate_params);

      fragment->printer_state_reasons.Set(
          printer_state_reasons_fragment.is_null() ? nullptr : printer_state_reasons_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->printer_state_reasons.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null printer_state_reasons in WebPrinterAttributes struct");
      fragment->sides_default_$flag = Traits::sides_default(input).has_value();
      if (Traits::sides_default(input).has_value()) {
        
        mojo::internal::Serialize<::blink::mojom::WebPrintingSides>(
          Traits::sides_default(input).value(),
          &fragment->sides_default_$value);
      } else {
        fragment->sides_default_$value =
            static_cast<int32_t>(::blink::mojom::WebPrintingSides::kMinValue);
      }

      decltype(Traits::sides_supported(input)) in_sides_supported = Traits::sides_supported(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->sides_supported)::BaseType>
          sides_supported_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& sides_supported_validate_params =
          mojo::internal::GetArrayOfEnumsValidator<0, false, ::blink::mojom::internal::WebPrintingSides_Data::Validate>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::WebPrintingSides>, send_validation>(
        in_sides_supported,
        sides_supported_fragment,
        &sides_supported_validate_params);

      fragment->sides_supported.Set(
          sides_supported_fragment.is_null() ? nullptr : sides_supported_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->sides_supported.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null sides_supported in WebPrinterAttributes struct");

      decltype(Traits::printer_id(input)) in_printer_id = Traits::printer_id(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->printer_id)::BaseType> printer_id_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_printer_id,
        printer_id_fragment);

      fragment->printer_id.Set(
          printer_id_fragment.is_null() ? nullptr : printer_id_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->printer_id.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null printer_id in WebPrinterAttributes struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::blink::mojom::WebPrintingMediaCollectionRequestedDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::WebPrintingMediaCollectionRequestedDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::WebPrintingMediaCollectionRequested_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::media_size(input)) in_media_size = Traits::media_size(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->media_size)::BaseType> media_size_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::SizeDataView, send_validation>(
        in_media_size,
        media_size_fragment);

      fragment->media_size.Set(
          media_size_fragment.is_null() ? nullptr : media_size_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->media_size.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null media_size in WebPrintingMediaCollectionRequested struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::blink::mojom::WebPrintJobTemplateAttributesDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::WebPrintJobTemplateAttributesDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::WebPrintJobTemplateAttributes_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::job_name(input)) in_job_name = Traits::job_name(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->job_name)::BaseType> job_name_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_job_name,
        job_name_fragment);

      fragment->job_name.Set(
          job_name_fragment.is_null() ? nullptr : job_name_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->job_name.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null job_name in WebPrintJobTemplateAttributes struct");

      fragment->copies = Traits::copies(input);

      decltype(Traits::media_col(input)) in_media_col = Traits::media_col(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->media_col)::BaseType> media_col_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::blink::mojom::WebPrintingMediaCollectionRequestedDataView, send_validation>(
        in_media_col,
        media_col_fragment);

      fragment->media_col.Set(
          media_col_fragment.is_null() ? nullptr : media_col_fragment.data());

      decltype(Traits::media_source(input)) in_media_source = Traits::media_source(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->media_source)::BaseType> media_source_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_media_source,
        media_source_fragment);

      fragment->media_source.Set(
          media_source_fragment.is_null() ? nullptr : media_source_fragment.data());
      fragment->multiple_document_handling_$flag = Traits::multiple_document_handling(input).has_value();
      if (Traits::multiple_document_handling(input).has_value()) {
        
        mojo::internal::Serialize<::blink::mojom::WebPrintingMultipleDocumentHandling>(
          Traits::multiple_document_handling(input).value(),
          &fragment->multiple_document_handling_$value);
      } else {
        fragment->multiple_document_handling_$value =
            static_cast<int32_t>(::blink::mojom::WebPrintingMultipleDocumentHandling::kMinValue);
      }
      fragment->orientation_requested_$flag = Traits::orientation_requested(input).has_value();
      if (Traits::orientation_requested(input).has_value()) {
        
        mojo::internal::Serialize<::blink::mojom::WebPrintingOrientationRequested>(
          Traits::orientation_requested(input).value(),
          &fragment->orientation_requested_$value);
      } else {
        fragment->orientation_requested_$value =
            static_cast<int32_t>(::blink::mojom::WebPrintingOrientationRequested::kMinValue);
      }

      decltype(Traits::printer_resolution(input)) in_printer_resolution = Traits::printer_resolution(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->printer_resolution)::BaseType> printer_resolution_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::SizeDataView, send_validation>(
        in_printer_resolution,
        printer_resolution_fragment);

      fragment->printer_resolution.Set(
          printer_resolution_fragment.is_null() ? nullptr : printer_resolution_fragment.data());
      fragment->print_color_mode_$flag = Traits::print_color_mode(input).has_value();
      if (Traits::print_color_mode(input).has_value()) {
        
        mojo::internal::Serialize<::blink::mojom::WebPrintColorMode>(
          Traits::print_color_mode(input).value(),
          &fragment->print_color_mode_$value);
      } else {
        fragment->print_color_mode_$value =
            static_cast<int32_t>(::blink::mojom::WebPrintColorMode::kMinValue);
      }
      fragment->print_quality_$flag = Traits::print_quality(input).has_value();
      if (Traits::print_quality(input).has_value()) {
        
        mojo::internal::Serialize<::blink::mojom::WebPrintQuality>(
          Traits::print_quality(input).value(),
          &fragment->print_quality_$value);
      } else {
        fragment->print_quality_$value =
            static_cast<int32_t>(::blink::mojom::WebPrintQuality::kMinValue);
      }
      fragment->sides_$flag = Traits::sides(input).has_value();
      if (Traits::sides(input).has_value()) {
        
        mojo::internal::Serialize<::blink::mojom::WebPrintingSides>(
          Traits::sides(input).value(),
          &fragment->sides_$value);
      } else {
        fragment->sides_$value =
            static_cast<int32_t>(::blink::mojom::WebPrintingSides::kMinValue);
      }
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::blink::mojom::WebPrintJobUpdateDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::WebPrintJobUpdateDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::WebPrintJobUpdate_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      
      mojo::internal::Serialize<::blink::mojom::WebPrintJobState>(
        Traits::state(input),
        &fragment->state);

      fragment->pages_printed = Traits::pages_printed(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::blink::mojom::WebPrintJobInfoDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::WebPrintJobInfoDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::WebPrintJobInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::job_name(input)) in_job_name = Traits::job_name(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->job_name)::BaseType> job_name_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_job_name,
        job_name_fragment);

      fragment->job_name.Set(
          job_name_fragment.is_null() ? nullptr : job_name_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->job_name.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null job_name in WebPrintJobInfo struct");

      fragment->job_pages = Traits::job_pages(input);

      decltype(Traits::observer(input)) in_observer = Traits::observer(input);

      
      mojo::internal::Serialize<mojo::InterfaceRequestDataView<::blink::mojom::WebPrintJobStateObserverInterfaceBase>>(
        in_observer,
        &fragment->observer,
        &fragment.message());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(!mojo::internal::IsHandleOrInterfaceValid(fragment->observer)),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
        "invalid observer in WebPrintJobInfo struct");

      decltype(Traits::controller(input)) in_controller = Traits::controller(input);

      
      mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::WebPrintJobControllerInterfaceBase>>(
        in_controller,
        &fragment->controller,
        &fragment.message());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(!mojo::internal::IsHandleOrInterfaceValid(fragment->controller)),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
        "invalid controller in WebPrintJobInfo struct");
  }
};
template <typename MaybeConstUserType, SendValidation send_validation>
struct SendValidationSerializer<::blink::mojom::WebPrintingMediaSizeDimensionDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::blink::mojom::WebPrintingMediaSizeDimensionDataView, UserType>;
  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::blink::mojom::internal::WebPrintingMediaSizeDimension_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::blink::mojom::WebPrintingMediaSizeDimensionDataView::Tag::kRange: {
    decltype(Traits::range(input))
    in_range = Traits::range(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_range)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::blink::mojom::WebPrintingRangeDataView, send_validation>(
  in_range,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null range in WebPrintingMediaSizeDimension union");
    fragment->data.f_range.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::blink::mojom::WebPrintingMediaSizeDimensionDataView::Tag::kValue: {
    decltype(Traits::value(input))
    in_value = Traits::value(input);
    fragment->data.f_value = in_value;
    break;
  }
}
  }
};
template <typename MaybeConstUserType, SendValidation send_validation>
struct SendValidationSerializer<::blink::mojom::GetPrintersResultDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::blink::mojom::GetPrintersResultDataView, UserType>;
  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::blink::mojom::internal::GetPrintersResult_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::blink::mojom::GetPrintersResultDataView::Tag::kPrinters: {
    decltype(Traits::printers(input))
    in_printers = Traits::printers(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_printers)::BaseType>
    value_fragment(fragment.message());
        constexpr const mojo::internal::ContainerValidateParams& printers_validate_params =
            mojo::internal::GetArrayValidator<0, false, nullptr>();
        
mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::WebPrinterInfoDataView>, send_validation>(
  in_printers,
  value_fragment,
  &printers_validate_params);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null printers in GetPrintersResult union");
    fragment->data.f_printers.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::blink::mojom::GetPrintersResultDataView::Tag::kError: {
    decltype(Traits::error(input))
    in_error = Traits::error(input);
        
mojo::internal::Serialize<::blink::mojom::GetPrintersError, send_validation>(
  in_error,
  &fragment->data.f_error);
    break;
  }
}
  }
};
template <typename MaybeConstUserType, SendValidation send_validation>
struct SendValidationSerializer<::blink::mojom::WebPrinterFetchResultDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::blink::mojom::WebPrinterFetchResultDataView, UserType>;
  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::blink::mojom::internal::WebPrinterFetchResult_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::blink::mojom::WebPrinterFetchResultDataView::Tag::kPrinterAttributes: {
    decltype(Traits::printer_attributes(input))
    in_printer_attributes = Traits::printer_attributes(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_printer_attributes)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::blink::mojom::WebPrinterAttributesDataView, send_validation>(
  in_printer_attributes,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null printer_attributes in WebPrinterFetchResult union");
    fragment->data.f_printer_attributes.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::blink::mojom::WebPrinterFetchResultDataView::Tag::kError: {
    decltype(Traits::error(input))
    in_error = Traits::error(input);
        
mojo::internal::Serialize<::blink::mojom::WebPrinterFetchError, send_validation>(
  in_error,
  &fragment->data.f_error);
    break;
  }
}
  }
};
template <typename MaybeConstUserType, SendValidation send_validation>
struct SendValidationSerializer<::blink::mojom::WebPrintResultDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::blink::mojom::WebPrintResultDataView, UserType>;
  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::blink::mojom::internal::WebPrintResult_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::blink::mojom::WebPrintResultDataView::Tag::kPrintJobInfo: {
    decltype(Traits::print_job_info(input))
    in_print_job_info = Traits::print_job_info(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_print_job_info)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::blink::mojom::WebPrintJobInfoDataView, send_validation>(
  in_print_job_info,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null print_job_info in WebPrintResult union");
    fragment->data.f_print_job_info.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::blink::mojom::WebPrintResultDataView::Tag::kError: {
    decltype(Traits::error(input))
    in_error = Traits::error(input);
        
mojo::internal::Serialize<::blink::mojom::WebPrintError, send_validation>(
  in_error,
  &fragment->data.f_error);
    break;
  }
}
  }
};

}  // namespace mojo::internal

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_PRINTING_WEB_PRINTING_MOJOM_SEND_VALIDATION_H_