// third_party/blink/public/mojom/printing/web_printing.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_PRINTING_WEB_PRINTING_MOJOM_DATA_VIEW_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_PRINTING_WEB_PRINTING_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/blink/public/mojom/printing/web_printing.mojom-shared-internal.h"
#include "third_party/blink/public/mojom/blob/blob.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"


namespace blink::mojom {
class WebPrinterInfoDataView;

class WebPrintingRangeDataView;

class WebPrintingMediaSizeDataView;

class WebPrintingMediaCollectionDataView;

class WebPrinterAttributesDataView;

class WebPrintingMediaCollectionRequestedDataView;

class WebPrintJobTemplateAttributesDataView;

class WebPrintJobUpdateDataView;

class WebPrintJobInfoDataView;

class WebPrintingMediaSizeDimensionDataView;
class GetPrintersResultDataView;
class WebPrinterFetchResultDataView;
class WebPrintResultDataView;


}  // blink::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::blink::mojom::WebPrinterInfoDataView> {
  using Data = ::blink::mojom::internal::WebPrinterInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::WebPrintingRangeDataView> {
  using Data = ::blink::mojom::internal::WebPrintingRange_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::WebPrintingMediaSizeDataView> {
  using Data = ::blink::mojom::internal::WebPrintingMediaSize_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::WebPrintingMediaCollectionDataView> {
  using Data = ::blink::mojom::internal::WebPrintingMediaCollection_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::WebPrinterAttributesDataView> {
  using Data = ::blink::mojom::internal::WebPrinterAttributes_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::WebPrintingMediaCollectionRequestedDataView> {
  using Data = ::blink::mojom::internal::WebPrintingMediaCollectionRequested_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::WebPrintJobTemplateAttributesDataView> {
  using Data = ::blink::mojom::internal::WebPrintJobTemplateAttributes_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::WebPrintJobUpdateDataView> {
  using Data = ::blink::mojom::internal::WebPrintJobUpdate_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::WebPrintJobInfoDataView> {
  using Data = ::blink::mojom::internal::WebPrintJobInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::WebPrintingMediaSizeDimensionDataView> {
  using Data = ::blink::mojom::internal::WebPrintingMediaSizeDimension_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

template <>
struct MojomTypeTraits<::blink::mojom::GetPrintersResultDataView> {
  using Data = ::blink::mojom::internal::GetPrintersResult_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

template <>
struct MojomTypeTraits<::blink::mojom::WebPrinterFetchResultDataView> {
  using Data = ::blink::mojom::internal::WebPrinterFetchResult_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

template <>
struct MojomTypeTraits<::blink::mojom::WebPrintResultDataView> {
  using Data = ::blink::mojom::internal::WebPrintResult_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

}  // namespace internal
}  // namespace mojo


namespace blink::mojom {


enum class WebPrintingMultipleDocumentHandling : int32_t {
  
  kSeparateDocumentsCollatedCopies = 0,
  
  kSeparateDocumentsUncollatedCopies = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, WebPrintingMultipleDocumentHandling value);
inline bool IsKnownEnumValue(WebPrintingMultipleDocumentHandling value) {
  return internal::WebPrintingMultipleDocumentHandling_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class WebPrintingSides : int32_t {
  
  kOneSided = 0,
  
  kTwoSidedLongEdge = 1,
  
  kTwoSidedShortEdge = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, WebPrintingSides value);
inline bool IsKnownEnumValue(WebPrintingSides value) {
  return internal::WebPrintingSides_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class WebPrintQuality : int32_t {
  
  kDraft = 0,
  
  kNormal = 1,
  
  kHigh = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, WebPrintQuality value);
inline bool IsKnownEnumValue(WebPrintQuality value) {
  return internal::WebPrintQuality_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class WebPrintColorMode : int32_t {
  
  kColor = 0,
  
  kMonochrome = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, WebPrintColorMode value);
inline bool IsKnownEnumValue(WebPrintColorMode value) {
  return internal::WebPrintColorMode_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class WebPrintingOrientationRequested : int32_t {
  
  kPortrait = 0,
  
  kLandscape = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, WebPrintingOrientationRequested value);
inline bool IsKnownEnumValue(WebPrintingOrientationRequested value) {
  return internal::WebPrintingOrientationRequested_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class WebPrinterState : int32_t {
  
  kIdle = 0,
  
  kProcessing = 1,
  
  kStopped = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, WebPrinterState value);
inline bool IsKnownEnumValue(WebPrinterState value) {
  return internal::WebPrinterState_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class WebPrinterStateReason : int32_t {
  
  kNone = 0,
  
  kOther = 1,
  
  kConnectingToDevice = 2,
  
  kCoverOpen = 3,
  
  kDeveloperEmpty = 4,
  
  kDeveloperLow = 5,
  
  kDoorOpen = 6,
  
  kFuserOverTemp = 7,
  
  kFuserUnderTemp = 8,
  
  kInputTrayMissing = 9,
  
  kInterlockOpen = 10,
  
  kInterpreterResourceUnavailable = 11,
  
  kMarkerSupplyEmpty = 12,
  
  kMarkerSupplyLow = 13,
  
  kMarkerWasteAlmostFull = 14,
  
  kMarkerWasteFull = 15,
  
  kMediaEmpty = 16,
  
  kMediaJam = 17,
  
  kMediaLow = 18,
  
  kMediaNeeded = 19,
  
  kMovingToPaused = 20,
  
  kOpcLifeOver = 21,
  
  kOpcNearEol = 22,
  
  kOutputAreaAlmostFull = 23,
  
  kOutputAreaFull = 24,
  
  kOutputTrayMissing = 25,
  
  kPaused = 26,
  
  kShutdown = 27,
  
  kSpoolAreaFull = 28,
  
  kStoppedPartly = 29,
  
  kStopping = 30,
  
  kTimedOut = 31,
  
  kTonerEmpty = 32,
  
  kTonerLow = 33,
  
  kCupsPkiExpired = 34,
  kMinValue = 0,
  kMaxValue = 34,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, WebPrinterStateReason value);
inline bool IsKnownEnumValue(WebPrinterStateReason value) {
  return internal::WebPrinterStateReason_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class WebPrintJobState : int32_t {
  
  kPending = 0,
  
  kProcessing = 1,
  
  kCompleted = 2,
  
  kCanceled = 3,
  
  kAborted = 4,
  kMinValue = 0,
  kMaxValue = 4,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, WebPrintJobState value);
inline bool IsKnownEnumValue(WebPrintJobState value) {
  return internal::WebPrintJobState_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class GetPrintersError : int32_t {
  
  kUserPermissionDenied = 0,
  kMinValue = 0,
  kMaxValue = 0,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, GetPrintersError value);
inline bool IsKnownEnumValue(GetPrintersError value) {
  return internal::GetPrintersError_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class WebPrinterFetchError : int32_t {
  
  kPrinterUnreachable = 0,
  
  kUserPermissionDenied = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, WebPrinterFetchError value);
inline bool IsKnownEnumValue(WebPrinterFetchError value) {
  return internal::WebPrinterFetchError_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class WebPrintError : int32_t {
  
  kPrinterUnreachable = 0,
  
  kDocumentMalformed = 1,
  
  kPrintJobTemplateAttributesMismatch = 2,
  
  kUserPermissionDenied = 3,
  kMinValue = 0,
  kMaxValue = 3,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, WebPrintError value);
inline bool IsKnownEnumValue(WebPrintError value) {
  return internal::WebPrintError_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class WebPrintJobStateObserverInterfaceBase {};

using WebPrintJobStateObserverPtrDataView =
    mojo::InterfacePtrDataView<WebPrintJobStateObserverInterfaceBase>;
using WebPrintJobStateObserverRequestDataView =
    mojo::InterfaceRequestDataView<WebPrintJobStateObserverInterfaceBase>;
using WebPrintJobStateObserverAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<WebPrintJobStateObserverInterfaceBase>;
using WebPrintJobStateObserverAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<WebPrintJobStateObserverInterfaceBase>;
class WebPrintJobControllerInterfaceBase {};

using WebPrintJobControllerPtrDataView =
    mojo::InterfacePtrDataView<WebPrintJobControllerInterfaceBase>;
using WebPrintJobControllerRequestDataView =
    mojo::InterfaceRequestDataView<WebPrintJobControllerInterfaceBase>;
using WebPrintJobControllerAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<WebPrintJobControllerInterfaceBase>;
using WebPrintJobControllerAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<WebPrintJobControllerInterfaceBase>;
class WebPrinterInterfaceBase {};

using WebPrinterPtrDataView =
    mojo::InterfacePtrDataView<WebPrinterInterfaceBase>;
using WebPrinterRequestDataView =
    mojo::InterfaceRequestDataView<WebPrinterInterfaceBase>;
using WebPrinterAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<WebPrinterInterfaceBase>;
using WebPrinterAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<WebPrinterInterfaceBase>;
class WebPrintingServiceInterfaceBase {};

using WebPrintingServicePtrDataView =
    mojo::InterfacePtrDataView<WebPrintingServiceInterfaceBase>;
using WebPrintingServiceRequestDataView =
    mojo::InterfaceRequestDataView<WebPrintingServiceInterfaceBase>;
using WebPrintingServiceAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<WebPrintingServiceInterfaceBase>;
using WebPrintingServiceAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<WebPrintingServiceInterfaceBase>;


class WebPrinterInfoDataView {
 public:
  WebPrinterInfoDataView() = default;

  WebPrinterInfoDataView(
      internal::WebPrinterInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetPrinterNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPrinterName(UserType* output) {
    
    auto* pointer = data_->printer_name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetPrinterIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPrinterId(UserType* output) {
    
    auto* pointer = data_->printer_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  UserType TakePrinterRemote() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::blink::mojom::WebPrinterInterfaceBase>>(
            &data_->printer_remote, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::WebPrinterInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class WebPrintingRangeDataView {
 public:
  WebPrintingRangeDataView() = default;

  WebPrintingRangeDataView(
      internal::WebPrintingRange_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  uint32_t from() const {
    return data_->from;
  }
  uint32_t to() const {
    return data_->to;
  }
 private:
  internal::WebPrintingRange_Data* data_ = nullptr;
};


class WebPrintingMediaSizeDataView {
 public:
  WebPrintingMediaSizeDataView() = default;

  WebPrintingMediaSizeDataView(
      internal::WebPrintingMediaSize_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetXDimensionDataView(
      WebPrintingMediaSizeDimensionDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadXDimension(UserType* output) {
    
    auto* pointer = !data_->x_dimension.is_null() ? &data_->x_dimension : nullptr;
    return mojo::internal::Deserialize<::blink::mojom::WebPrintingMediaSizeDimensionDataView>(
        pointer, output, message_);
  }
  inline void GetYDimensionDataView(
      WebPrintingMediaSizeDimensionDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadYDimension(UserType* output) {
    
    auto* pointer = !data_->y_dimension.is_null() ? &data_->y_dimension : nullptr;
    return mojo::internal::Deserialize<::blink::mojom::WebPrintingMediaSizeDimensionDataView>(
        pointer, output, message_);
  }
 private:
  internal::WebPrintingMediaSize_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class WebPrintingMediaCollectionDataView {
 public:
  WebPrintingMediaCollectionDataView() = default;

  WebPrintingMediaCollectionDataView(
      internal::WebPrintingMediaCollection_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetMediaSizeDataView(
      WebPrintingMediaSizeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMediaSize(UserType* output) {
    
    auto* pointer = data_->media_size.Get();
    return mojo::internal::Deserialize<::blink::mojom::WebPrintingMediaSizeDataView>(
        pointer, output, message_);
  }
  inline void GetMediaSizeNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMediaSizeName(UserType* output) {
    
    auto* pointer = data_->media_size_name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::WebPrintingMediaCollection_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class WebPrinterAttributesDataView {
 public:
  WebPrinterAttributesDataView() = default;

  WebPrinterAttributesDataView(
      internal::WebPrinterAttributes_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  uint32_t copies_default() const {
    return data_->copies_default;
  }
  inline void GetCopiesSupportedDataView(
      WebPrintingRangeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCopiesSupported(UserType* output) {
    
    auto* pointer = data_->copies_supported.Get();
    return mojo::internal::Deserialize<::blink::mojom::WebPrintingRangeDataView>(
        pointer, output, message_);
  }
  inline void GetMediaColDefaultDataView(
      WebPrintingMediaCollectionDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMediaColDefault(UserType* output) {
    
    auto* pointer = data_->media_col_default.Get();
    return mojo::internal::Deserialize<::blink::mojom::WebPrintingMediaCollectionDataView>(
        pointer, output, message_);
  }
  inline void GetMediaColDatabaseDataView(
      mojo::ArrayDataView<WebPrintingMediaCollectionDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMediaColDatabase(UserType* output) {
    
    auto* pointer = data_->media_col_database.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::WebPrintingMediaCollectionDataView>>(
        pointer, output, message_);
  }
  inline void GetMediaSourceDefaultDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMediaSourceDefault(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `media_source_default` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadMediaSourceDefault` instead "
    "of `ReadMediaSourceDefault if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->media_source_default.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetMediaSourceSupportedDataView(
      mojo::ArrayDataView<mojo::StringDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMediaSourceSupported(UserType* output) {
    
    auto* pointer = data_->media_source_supported.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<mojo::StringDataView>>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadMultipleDocumentHandlingDefault(UserType* output) const {
    auto data_value = data_->multiple_document_handling_default;
    return mojo::internal::Deserialize<::blink::mojom::WebPrintingMultipleDocumentHandling>(
        data_value, output);
  }
  WebPrintingMultipleDocumentHandling multiple_document_handling_default() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::WebPrintingMultipleDocumentHandling>(data_->multiple_document_handling_default));
  }
  inline void GetMultipleDocumentHandlingSupportedDataView(
      mojo::ArrayDataView<WebPrintingMultipleDocumentHandling>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMultipleDocumentHandlingSupported(UserType* output) {
    
    auto* pointer = data_->multiple_document_handling_supported.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::WebPrintingMultipleDocumentHandling>>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadOrientationRequestedDefault(UserType* output) const {
    auto data_value = data_->orientation_requested_default;
    return mojo::internal::Deserialize<::blink::mojom::WebPrintingOrientationRequested>(
        data_value, output);
  }
  WebPrintingOrientationRequested orientation_requested_default() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::WebPrintingOrientationRequested>(data_->orientation_requested_default));
  }
  inline void GetOrientationRequestedSupportedDataView(
      mojo::ArrayDataView<WebPrintingOrientationRequested>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOrientationRequestedSupported(UserType* output) {
    
    auto* pointer = data_->orientation_requested_supported.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::WebPrintingOrientationRequested>>(
        pointer, output, message_);
  }
  inline void GetPrinterResolutionDefaultDataView(
      ::gfx::mojom::SizeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPrinterResolutionDefault(UserType* output) {
    
    auto* pointer = data_->printer_resolution_default.Get();
    return mojo::internal::Deserialize<::gfx::mojom::SizeDataView>(
        pointer, output, message_);
  }
  inline void GetPrinterResolutionSupportedDataView(
      mojo::ArrayDataView<::gfx::mojom::SizeDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPrinterResolutionSupported(UserType* output) {
    
    auto* pointer = data_->printer_resolution_supported.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::gfx::mojom::SizeDataView>>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadPrintColorModeDefault(UserType* output) const {
    auto data_value = data_->print_color_mode_default;
    return mojo::internal::Deserialize<::blink::mojom::WebPrintColorMode>(
        data_value, output);
  }
  WebPrintColorMode print_color_mode_default() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::WebPrintColorMode>(data_->print_color_mode_default));
  }
  inline void GetPrintColorModeSupportedDataView(
      mojo::ArrayDataView<WebPrintColorMode>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPrintColorModeSupported(UserType* output) {
    
    auto* pointer = data_->print_color_mode_supported.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::WebPrintColorMode>>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadPrintQualityDefault(UserType* output) const {
    if (!data_->print_quality_default_$flag) {
      *output = std::nullopt;
      return true;
    }

    return mojo::internal::Deserialize<::blink::mojom::WebPrintQuality>(
        data_->print_quality_default_$value, &output->emplace());
  }
  std::optional<WebPrintQuality> print_quality_default() const {
    if (!data_->print_quality_default_$flag) {
      return std::nullopt;
    }
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::WebPrintQuality>(data_->print_quality_default_$value));
  }
  inline void GetPrintQualitySupportedDataView(
      mojo::ArrayDataView<WebPrintQuality>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPrintQualitySupported(UserType* output) {
    
    auto* pointer = data_->print_quality_supported.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::WebPrintQuality>>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadPrinterState(UserType* output) const {
    auto data_value = data_->printer_state;
    return mojo::internal::Deserialize<::blink::mojom::WebPrinterState>(
        data_value, output);
  }
  WebPrinterState printer_state() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::WebPrinterState>(data_->printer_state));
  }
  inline void GetPrinterStateMessageDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPrinterStateMessage(UserType* output) {
    
    auto* pointer = data_->printer_state_message.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetPrinterStateReasonsDataView(
      mojo::ArrayDataView<WebPrinterStateReason>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPrinterStateReasons(UserType* output) {
    
    auto* pointer = data_->printer_state_reasons.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::WebPrinterStateReason>>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadSidesDefault(UserType* output) const {
    if (!data_->sides_default_$flag) {
      *output = std::nullopt;
      return true;
    }

    return mojo::internal::Deserialize<::blink::mojom::WebPrintingSides>(
        data_->sides_default_$value, &output->emplace());
  }
  std::optional<WebPrintingSides> sides_default() const {
    if (!data_->sides_default_$flag) {
      return std::nullopt;
    }
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::WebPrintingSides>(data_->sides_default_$value));
  }
  inline void GetSidesSupportedDataView(
      mojo::ArrayDataView<WebPrintingSides>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSidesSupported(UserType* output) {
    
    auto* pointer = data_->sides_supported.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::WebPrintingSides>>(
        pointer, output, message_);
  }
  inline void GetPrinterIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPrinterId(UserType* output) {
    
    auto* pointer = data_->printer_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::WebPrinterAttributes_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class WebPrintingMediaCollectionRequestedDataView {
 public:
  WebPrintingMediaCollectionRequestedDataView() = default;

  WebPrintingMediaCollectionRequestedDataView(
      internal::WebPrintingMediaCollectionRequested_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetMediaSizeDataView(
      ::gfx::mojom::SizeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMediaSize(UserType* output) {
    
    auto* pointer = data_->media_size.Get();
    return mojo::internal::Deserialize<::gfx::mojom::SizeDataView>(
        pointer, output, message_);
  }
 private:
  internal::WebPrintingMediaCollectionRequested_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class WebPrintJobTemplateAttributesDataView {
 public:
  WebPrintJobTemplateAttributesDataView() = default;

  WebPrintJobTemplateAttributesDataView(
      internal::WebPrintJobTemplateAttributes_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetJobNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadJobName(UserType* output) {
    
    auto* pointer = data_->job_name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  uint32_t copies() const {
    return data_->copies;
  }
  inline void GetMediaColDataView(
      WebPrintingMediaCollectionRequestedDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMediaCol(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::WebPrintingMediaCollectionRequestedDataView, UserType>(),
    "Attempting to read the optional `media_col` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadMediaCol` instead "
    "of `ReadMediaCol if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->media_col.Get();
    return mojo::internal::Deserialize<::blink::mojom::WebPrintingMediaCollectionRequestedDataView>(
        pointer, output, message_);
  }
  inline void GetMediaSourceDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMediaSource(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `media_source` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadMediaSource` instead "
    "of `ReadMediaSource if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->media_source.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadMultipleDocumentHandling(UserType* output) const {
    if (!data_->multiple_document_handling_$flag) {
      *output = std::nullopt;
      return true;
    }

    return mojo::internal::Deserialize<::blink::mojom::WebPrintingMultipleDocumentHandling>(
        data_->multiple_document_handling_$value, &output->emplace());
  }
  std::optional<WebPrintingMultipleDocumentHandling> multiple_document_handling() const {
    if (!data_->multiple_document_handling_$flag) {
      return std::nullopt;
    }
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::WebPrintingMultipleDocumentHandling>(data_->multiple_document_handling_$value));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadOrientationRequested(UserType* output) const {
    if (!data_->orientation_requested_$flag) {
      *output = std::nullopt;
      return true;
    }

    return mojo::internal::Deserialize<::blink::mojom::WebPrintingOrientationRequested>(
        data_->orientation_requested_$value, &output->emplace());
  }
  std::optional<WebPrintingOrientationRequested> orientation_requested() const {
    if (!data_->orientation_requested_$flag) {
      return std::nullopt;
    }
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::WebPrintingOrientationRequested>(data_->orientation_requested_$value));
  }
  inline void GetPrinterResolutionDataView(
      ::gfx::mojom::SizeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPrinterResolution(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::gfx::mojom::SizeDataView, UserType>(),
    "Attempting to read the optional `printer_resolution` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadPrinterResolution` instead "
    "of `ReadPrinterResolution if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->printer_resolution.Get();
    return mojo::internal::Deserialize<::gfx::mojom::SizeDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadPrintColorMode(UserType* output) const {
    if (!data_->print_color_mode_$flag) {
      *output = std::nullopt;
      return true;
    }

    return mojo::internal::Deserialize<::blink::mojom::WebPrintColorMode>(
        data_->print_color_mode_$value, &output->emplace());
  }
  std::optional<WebPrintColorMode> print_color_mode() const {
    if (!data_->print_color_mode_$flag) {
      return std::nullopt;
    }
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::WebPrintColorMode>(data_->print_color_mode_$value));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadPrintQuality(UserType* output) const {
    if (!data_->print_quality_$flag) {
      *output = std::nullopt;
      return true;
    }

    return mojo::internal::Deserialize<::blink::mojom::WebPrintQuality>(
        data_->print_quality_$value, &output->emplace());
  }
  std::optional<WebPrintQuality> print_quality() const {
    if (!data_->print_quality_$flag) {
      return std::nullopt;
    }
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::WebPrintQuality>(data_->print_quality_$value));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadSides(UserType* output) const {
    if (!data_->sides_$flag) {
      *output = std::nullopt;
      return true;
    }

    return mojo::internal::Deserialize<::blink::mojom::WebPrintingSides>(
        data_->sides_$value, &output->emplace());
  }
  std::optional<WebPrintingSides> sides() const {
    if (!data_->sides_$flag) {
      return std::nullopt;
    }
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::WebPrintingSides>(data_->sides_$value));
  }
 private:
  internal::WebPrintJobTemplateAttributes_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class WebPrintJobUpdateDataView {
 public:
  WebPrintJobUpdateDataView() = default;

  WebPrintJobUpdateDataView(
      internal::WebPrintJobUpdate_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadState(UserType* output) const {
    auto data_value = data_->state;
    return mojo::internal::Deserialize<::blink::mojom::WebPrintJobState>(
        data_value, output);
  }
  WebPrintJobState state() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::WebPrintJobState>(data_->state));
  }
  uint32_t pages_printed() const {
    return data_->pages_printed;
  }
 private:
  internal::WebPrintJobUpdate_Data* data_ = nullptr;
};


class WebPrintJobInfoDataView {
 public:
  WebPrintJobInfoDataView() = default;

  WebPrintJobInfoDataView(
      internal::WebPrintJobInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetJobNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadJobName(UserType* output) {
    
    auto* pointer = data_->job_name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  uint32_t job_pages() const {
    return data_->job_pages;
  }
  template <typename UserType>
  UserType TakeObserver() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfaceRequestDataView<::blink::mojom::WebPrintJobStateObserverInterfaceBase>>(
            &data_->observer, &result, message_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  UserType TakeController() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::blink::mojom::WebPrintJobControllerInterfaceBase>>(
            &data_->controller, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::WebPrintJobInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class WebPrintingMediaSizeDimensionDataView {
 public:
  using Tag = internal::WebPrintingMediaSizeDimension_Data::WebPrintingMediaSizeDimension_Tag;

  WebPrintingMediaSizeDimensionDataView() = default;

  WebPrintingMediaSizeDimensionDataView(
      internal::WebPrintingMediaSizeDimension_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_range() const { return data_->tag == Tag::kRange; }
  inline void GetRangeDataView(
      WebPrintingRangeDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadRange(UserType* output) const {
    
    CHECK(is_range());
    return mojo::internal::Deserialize<::blink::mojom::WebPrintingRangeDataView>(
        data_->data.f_range.Get(), output, message_);
  }
  bool is_value() const { return data_->tag == Tag::kValue; }
  uint32_t value() const {
    CHECK(is_value());
    return data_->data.f_value;
  }

 private:
  internal::WebPrintingMediaSizeDimension_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



class GetPrintersResultDataView {
 public:
  using Tag = internal::GetPrintersResult_Data::GetPrintersResult_Tag;

  GetPrintersResultDataView() = default;

  GetPrintersResultDataView(
      internal::GetPrintersResult_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_printers() const { return data_->tag == Tag::kPrinters; }
  inline void GetPrintersDataView(
      mojo::ArrayDataView<WebPrinterInfoDataView>* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadPrinters(UserType* output) const {
    
    CHECK(is_printers());
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::WebPrinterInfoDataView>>(
        data_->data.f_printers.Get(), output, message_);
  }
  bool is_error() const { return data_->tag == Tag::kError; }
  template <typename UserType>
  [[nodiscard]] bool ReadError(UserType* output) const {
    CHECK(is_error());
    return mojo::internal::Deserialize<::blink::mojom::GetPrintersError>(
        data_->data.f_error, output);
  }
  GetPrintersError error() const {
    CHECK(is_error());
    // TODO(dcheng): This seems incorrect, as it bypasses enum traits.
    return ::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::GetPrintersError>(data_->data.f_error));
  }

 private:
  internal::GetPrintersResult_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



class WebPrinterFetchResultDataView {
 public:
  using Tag = internal::WebPrinterFetchResult_Data::WebPrinterFetchResult_Tag;

  WebPrinterFetchResultDataView() = default;

  WebPrinterFetchResultDataView(
      internal::WebPrinterFetchResult_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_printer_attributes() const { return data_->tag == Tag::kPrinterAttributes; }
  inline void GetPrinterAttributesDataView(
      WebPrinterAttributesDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadPrinterAttributes(UserType* output) const {
    
    CHECK(is_printer_attributes());
    return mojo::internal::Deserialize<::blink::mojom::WebPrinterAttributesDataView>(
        data_->data.f_printer_attributes.Get(), output, message_);
  }
  bool is_error() const { return data_->tag == Tag::kError; }
  template <typename UserType>
  [[nodiscard]] bool ReadError(UserType* output) const {
    CHECK(is_error());
    return mojo::internal::Deserialize<::blink::mojom::WebPrinterFetchError>(
        data_->data.f_error, output);
  }
  WebPrinterFetchError error() const {
    CHECK(is_error());
    // TODO(dcheng): This seems incorrect, as it bypasses enum traits.
    return ::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::WebPrinterFetchError>(data_->data.f_error));
  }

 private:
  internal::WebPrinterFetchResult_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



class WebPrintResultDataView {
 public:
  using Tag = internal::WebPrintResult_Data::WebPrintResult_Tag;

  WebPrintResultDataView() = default;

  WebPrintResultDataView(
      internal::WebPrintResult_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_print_job_info() const { return data_->tag == Tag::kPrintJobInfo; }
  inline void GetPrintJobInfoDataView(
      WebPrintJobInfoDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadPrintJobInfo(UserType* output) const {
    
    CHECK(is_print_job_info());
    return mojo::internal::Deserialize<::blink::mojom::WebPrintJobInfoDataView>(
        data_->data.f_print_job_info.Get(), output, message_);
  }
  bool is_error() const { return data_->tag == Tag::kError; }
  template <typename UserType>
  [[nodiscard]] bool ReadError(UserType* output) const {
    CHECK(is_error());
    return mojo::internal::Deserialize<::blink::mojom::WebPrintError>(
        data_->data.f_error, output);
  }
  WebPrintError error() const {
    CHECK(is_error());
    // TODO(dcheng): This seems incorrect, as it bypasses enum traits.
    return ::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::WebPrintError>(data_->data.f_error));
  }

 private:
  internal::WebPrintResult_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



}  // blink::mojom

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_PRINTING_WEB_PRINTING_MOJOM_DATA_VIEW_H_