// third_party/blink/public/mojom/presentation/presentation.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../../mojo/public/js/bindings.js';

import {
  Url as url_mojom_Url,
  UrlSpec as url_mojom_UrlSpec
} from '../../../../../url/mojom/url.mojom.m.js';


/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const ScreenAvailabilitySpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const ScreenAvailability = {
  
  UNKNOWN: 0,
  UNAVAILABLE: 1,
  SOURCE_NOT_SUPPORTED: 2,
  DISABLED: 3,
  AVAILABLE: 4,
  MIN_VALUE: 0,
  MAX_VALUE: 4,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const PresentationConnectionStateSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const PresentationConnectionState = {
  
  CONNECTING: 0,
  CONNECTED: 1,
  CLOSED: 2,
  TERMINATED: 3,
  MIN_VALUE: 0,
  MAX_VALUE: 3,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const PresentationConnectionCloseReasonSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const PresentationConnectionCloseReason = {
  
  CONNECTION_ERROR: 0,
  CLOSED: 1,
  WENT_AWAY: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const PresentationErrorTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const PresentationErrorType = {
  
  NO_AVAILABLE_SCREENS: 0,
  PRESENTATION_REQUEST_CANCELLED: 1,
  NO_PRESENTATION_FOUND: 2,
  PREVIOUS_START_IN_PROGRESS: 3,
  UNKNOWN: 4,
  MIN_VALUE: 0,
  MAX_VALUE: 4,
};



/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class PresentationConnectionPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.PresentationConnection', scope);
  }
}

/** @interface */
export class PresentationConnectionInterface {
  
  /**
   * @param { !PresentationConnectionMessage } message
   */

  onMessage(message) {}
  
  /**
   * @param { !PresentationConnectionState } state
   */

  didChangeState(state) {}
  
  /**
   * @param { !PresentationConnectionCloseReason } reason
   */

  didClose(reason) {}
}

/**
 * @implements { PresentationConnectionInterface }
 */
export class PresentationConnectionRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!PresentationConnectionPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          PresentationConnectionPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!PresentationConnectionPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !PresentationConnectionMessage } message
   */

  onMessage(
      message) {
    this.proxy.sendMessage(
        0,
        PresentationConnection_OnMessage_ParamsSpec.$,
        null,
        [
          message
        ],
        false);
  }

  
  /**
   * @param { !PresentationConnectionState } state
   */

  didChangeState(
      state) {
    this.proxy.sendMessage(
        1,
        PresentationConnection_DidChangeState_ParamsSpec.$,
        null,
        [
          state
        ],
        false);
  }

  
  /**
   * @param { !PresentationConnectionCloseReason } reason
   */

  didClose(
      reason) {
    this.proxy.sendMessage(
        2,
        PresentationConnection_DidClose_ParamsSpec.$,
        null,
        [
          reason
        ],
        false);
  }
}

/**
 * An object which receives request messages for the PresentationConnection
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PresentationConnectionReceiver {
  /**
   * @param {!PresentationConnectionInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!PresentationConnectionRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        PresentationConnectionRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!PresentationConnectionRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        PresentationConnection_OnMessage_ParamsSpec.$,
        null,
        impl.onMessage.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        PresentationConnection_DidChangeState_ParamsSpec.$,
        null,
        impl.didChangeState.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        PresentationConnection_DidClose_ParamsSpec.$,
        null,
        impl.didClose.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class PresentationConnection {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.PresentationConnection";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!PresentationConnectionRemote}
   */
  static getRemote() {
    let remote = new PresentationConnectionRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the PresentationConnection
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PresentationConnectionCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      PresentationConnectionRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!PresentationConnectionRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onMessage =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        PresentationConnection_OnMessage_ParamsSpec.$,
        null,
        this.onMessage.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.didChangeState =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        PresentationConnection_DidChangeState_ParamsSpec.$,
        null,
        this.didChangeState.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.didClose =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        PresentationConnection_DidClose_ParamsSpec.$,
        null,
        this.didClose.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class PresentationServicePendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.PresentationService', scope);
  }
}

/** @interface */
export class PresentationServiceInterface {
  
  /**
   * @param { !PresentationControllerRemote } controller
   */

  setController(controller) {}
  
  /**
   * @param { !PresentationReceiverRemote } receiver
   */

  setReceiver(receiver) {}
  
  /**
   * @param { !Array<!url_mojom_Url> } presentationUrls
   */

  setDefaultPresentationUrls(presentationUrls) {}
  
  /**
   * @param { !url_mojom_Url } availabilityUrl
   */

  listenForScreenAvailability(availabilityUrl) {}
  
  /**
   * @param { !url_mojom_Url } availabilityUrl
   */

  stopListeningForScreenAvailability(availabilityUrl) {}
  
  /**
   * @param { !Array<!url_mojom_Url> } presentationUrls
   * @return {!Promise<{
        result: ?PresentationConnectionResult,
        error: ?PresentationError,
   *  }>}
   */

  startPresentation(presentationUrls) {}
  
  /**
   * @param { !Array<!url_mojom_Url> } presentationUrls
   * @param { !string } presentationId
   * @return {!Promise<{
        result: ?PresentationConnectionResult,
        error: ?PresentationError,
   *  }>}
   */

  reconnectPresentation(presentationUrls, presentationId) {}
  
  /**
   * @param { !url_mojom_Url } presentationUrl
   * @param { !string } presentationId
   */

  closeConnection(presentationUrl, presentationId) {}
  
  /**
   * @param { !url_mojom_Url } presentationUrl
   * @param { !string } presentationId
   */

  terminate(presentationUrl, presentationId) {}
}

/**
 * @implements { PresentationServiceInterface }
 */
export class PresentationServiceRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!PresentationServicePendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          PresentationServicePendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!PresentationServicePendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !PresentationControllerRemote } controller
   */

  setController(
      controller) {
    this.proxy.sendMessage(
        0,
        PresentationService_SetController_ParamsSpec.$,
        null,
        [
          controller
        ],
        false);
  }

  
  /**
   * @param { !PresentationReceiverRemote } receiver
   */

  setReceiver(
      receiver) {
    this.proxy.sendMessage(
        1,
        PresentationService_SetReceiver_ParamsSpec.$,
        null,
        [
          receiver
        ],
        false);
  }

  
  /**
   * @param { !Array<!url_mojom_Url> } presentationUrls
   */

  setDefaultPresentationUrls(
      presentationUrls) {
    this.proxy.sendMessage(
        2,
        PresentationService_SetDefaultPresentationUrls_ParamsSpec.$,
        null,
        [
          presentationUrls
        ],
        false);
  }

  
  /**
   * @param { !url_mojom_Url } availabilityUrl
   */

  listenForScreenAvailability(
      availabilityUrl) {
    this.proxy.sendMessage(
        3,
        PresentationService_ListenForScreenAvailability_ParamsSpec.$,
        null,
        [
          availabilityUrl
        ],
        false);
  }

  
  /**
   * @param { !url_mojom_Url } availabilityUrl
   */

  stopListeningForScreenAvailability(
      availabilityUrl) {
    this.proxy.sendMessage(
        4,
        PresentationService_StopListeningForScreenAvailability_ParamsSpec.$,
        null,
        [
          availabilityUrl
        ],
        false);
  }

  
  /**
   * @param { !Array<!url_mojom_Url> } presentationUrls
   * @return {!Promise<{
        result: ?PresentationConnectionResult,
        error: ?PresentationError,
   *  }>}
   */

  startPresentation(
      presentationUrls) {
    return this.proxy.sendMessage(
        5,
        PresentationService_StartPresentation_ParamsSpec.$,
        PresentationService_StartPresentation_ResponseParamsSpec.$,
        [
          presentationUrls
        ],
        false);
  }

  
  /**
   * @param { !Array<!url_mojom_Url> } presentationUrls
   * @param { !string } presentationId
   * @return {!Promise<{
        result: ?PresentationConnectionResult,
        error: ?PresentationError,
   *  }>}
   */

  reconnectPresentation(
      presentationUrls,
      presentationId) {
    return this.proxy.sendMessage(
        6,
        PresentationService_ReconnectPresentation_ParamsSpec.$,
        PresentationService_ReconnectPresentation_ResponseParamsSpec.$,
        [
          presentationUrls,
          presentationId
        ],
        false);
  }

  
  /**
   * @param { !url_mojom_Url } presentationUrl
   * @param { !string } presentationId
   */

  closeConnection(
      presentationUrl,
      presentationId) {
    this.proxy.sendMessage(
        7,
        PresentationService_CloseConnection_ParamsSpec.$,
        null,
        [
          presentationUrl,
          presentationId
        ],
        false);
  }

  
  /**
   * @param { !url_mojom_Url } presentationUrl
   * @param { !string } presentationId
   */

  terminate(
      presentationUrl,
      presentationId) {
    this.proxy.sendMessage(
        8,
        PresentationService_Terminate_ParamsSpec.$,
        null,
        [
          presentationUrl,
          presentationId
        ],
        false);
  }
}

/**
 * An object which receives request messages for the PresentationService
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PresentationServiceReceiver {
  /**
   * @param {!PresentationServiceInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!PresentationServiceRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        PresentationServiceRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!PresentationServiceRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        PresentationService_SetController_ParamsSpec.$,
        null,
        impl.setController.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        PresentationService_SetReceiver_ParamsSpec.$,
        null,
        impl.setReceiver.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        PresentationService_SetDefaultPresentationUrls_ParamsSpec.$,
        null,
        impl.setDefaultPresentationUrls.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        PresentationService_ListenForScreenAvailability_ParamsSpec.$,
        null,
        impl.listenForScreenAvailability.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        PresentationService_StopListeningForScreenAvailability_ParamsSpec.$,
        null,
        impl.stopListeningForScreenAvailability.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        PresentationService_StartPresentation_ParamsSpec.$,
        PresentationService_StartPresentation_ResponseParamsSpec.$,
        impl.startPresentation.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        PresentationService_ReconnectPresentation_ParamsSpec.$,
        PresentationService_ReconnectPresentation_ResponseParamsSpec.$,
        impl.reconnectPresentation.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        PresentationService_CloseConnection_ParamsSpec.$,
        null,
        impl.closeConnection.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        8,
        PresentationService_Terminate_ParamsSpec.$,
        null,
        impl.terminate.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class PresentationService {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.PresentationService";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!PresentationServiceRemote}
   */
  static getRemote() {
    let remote = new PresentationServiceRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the PresentationService
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PresentationServiceCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      PresentationServiceRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!PresentationServiceRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setController =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        PresentationService_SetController_ParamsSpec.$,
        null,
        this.setController.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setReceiver =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        PresentationService_SetReceiver_ParamsSpec.$,
        null,
        this.setReceiver.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setDefaultPresentationUrls =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        PresentationService_SetDefaultPresentationUrls_ParamsSpec.$,
        null,
        this.setDefaultPresentationUrls.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.listenForScreenAvailability =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        PresentationService_ListenForScreenAvailability_ParamsSpec.$,
        null,
        this.listenForScreenAvailability.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.stopListeningForScreenAvailability =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        PresentationService_StopListeningForScreenAvailability_ParamsSpec.$,
        null,
        this.stopListeningForScreenAvailability.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.startPresentation =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        PresentationService_StartPresentation_ParamsSpec.$,
        PresentationService_StartPresentation_ResponseParamsSpec.$,
        this.startPresentation.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.reconnectPresentation =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        PresentationService_ReconnectPresentation_ParamsSpec.$,
        PresentationService_ReconnectPresentation_ResponseParamsSpec.$,
        this.reconnectPresentation.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.closeConnection =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        PresentationService_CloseConnection_ParamsSpec.$,
        null,
        this.closeConnection.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.terminate =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        8,
        PresentationService_Terminate_ParamsSpec.$,
        null,
        this.terminate.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class PresentationControllerPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.PresentationController', scope);
  }
}

/** @interface */
export class PresentationControllerInterface {
  
  /**
   * @param { !url_mojom_Url } url
   * @param { !ScreenAvailability } availability
   */

  onScreenAvailabilityUpdated(url, availability) {}
  
  /**
   * @param { !PresentationConnectionResult } result
   */

  onDefaultPresentationStarted(result) {}
  
  /**
   * @param { !PresentationInfo } presentationInfo
   * @param { !PresentationConnectionState } newState
   */

  onConnectionStateChanged(presentationInfo, newState) {}
  
  /**
   * @param { !PresentationInfo } presentationInfo
   * @param { !PresentationConnectionCloseReason } reason
   * @param { !string } message
   */

  onConnectionClosed(presentationInfo, reason, message) {}
}

/**
 * @implements { PresentationControllerInterface }
 */
export class PresentationControllerRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!PresentationControllerPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          PresentationControllerPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!PresentationControllerPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !url_mojom_Url } url
   * @param { !ScreenAvailability } availability
   */

  onScreenAvailabilityUpdated(
      url,
      availability) {
    this.proxy.sendMessage(
        0,
        PresentationController_OnScreenAvailabilityUpdated_ParamsSpec.$,
        null,
        [
          url,
          availability
        ],
        false);
  }

  
  /**
   * @param { !PresentationConnectionResult } result
   */

  onDefaultPresentationStarted(
      result) {
    this.proxy.sendMessage(
        1,
        PresentationController_OnDefaultPresentationStarted_ParamsSpec.$,
        null,
        [
          result
        ],
        false);
  }

  
  /**
   * @param { !PresentationInfo } presentationInfo
   * @param { !PresentationConnectionState } newState
   */

  onConnectionStateChanged(
      presentationInfo,
      newState) {
    this.proxy.sendMessage(
        2,
        PresentationController_OnConnectionStateChanged_ParamsSpec.$,
        null,
        [
          presentationInfo,
          newState
        ],
        false);
  }

  
  /**
   * @param { !PresentationInfo } presentationInfo
   * @param { !PresentationConnectionCloseReason } reason
   * @param { !string } message
   */

  onConnectionClosed(
      presentationInfo,
      reason,
      message) {
    this.proxy.sendMessage(
        3,
        PresentationController_OnConnectionClosed_ParamsSpec.$,
        null,
        [
          presentationInfo,
          reason,
          message
        ],
        false);
  }
}

/**
 * An object which receives request messages for the PresentationController
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PresentationControllerReceiver {
  /**
   * @param {!PresentationControllerInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!PresentationControllerRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        PresentationControllerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!PresentationControllerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        PresentationController_OnScreenAvailabilityUpdated_ParamsSpec.$,
        null,
        impl.onScreenAvailabilityUpdated.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        PresentationController_OnDefaultPresentationStarted_ParamsSpec.$,
        null,
        impl.onDefaultPresentationStarted.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        PresentationController_OnConnectionStateChanged_ParamsSpec.$,
        null,
        impl.onConnectionStateChanged.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        PresentationController_OnConnectionClosed_ParamsSpec.$,
        null,
        impl.onConnectionClosed.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class PresentationController {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.PresentationController";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!PresentationControllerRemote}
   */
  static getRemote() {
    let remote = new PresentationControllerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the PresentationController
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PresentationControllerCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      PresentationControllerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!PresentationControllerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onScreenAvailabilityUpdated =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        PresentationController_OnScreenAvailabilityUpdated_ParamsSpec.$,
        null,
        this.onScreenAvailabilityUpdated.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onDefaultPresentationStarted =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        PresentationController_OnDefaultPresentationStarted_ParamsSpec.$,
        null,
        this.onDefaultPresentationStarted.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onConnectionStateChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        PresentationController_OnConnectionStateChanged_ParamsSpec.$,
        null,
        this.onConnectionStateChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onConnectionClosed =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        PresentationController_OnConnectionClosed_ParamsSpec.$,
        null,
        this.onConnectionClosed.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class PresentationReceiverPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.PresentationReceiver', scope);
  }
}

/** @interface */
export class PresentationReceiverInterface {
  
  /**
   * @param { !PresentationConnectionResult } result
   */

  onReceiverConnectionAvailable(result) {}
}

/**
 * @implements { PresentationReceiverInterface }
 */
export class PresentationReceiverRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!PresentationReceiverPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          PresentationReceiverPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!PresentationReceiverPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !PresentationConnectionResult } result
   */

  onReceiverConnectionAvailable(
      result) {
    this.proxy.sendMessage(
        0,
        PresentationReceiver_OnReceiverConnectionAvailable_ParamsSpec.$,
        null,
        [
          result
        ],
        false);
  }
}

/**
 * An object which receives request messages for the PresentationReceiver
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PresentationReceiverReceiver {
  /**
   * @param {!PresentationReceiverInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!PresentationReceiverRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        PresentationReceiverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!PresentationReceiverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        PresentationReceiver_OnReceiverConnectionAvailable_ParamsSpec.$,
        null,
        impl.onReceiverConnectionAvailable.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class PresentationReceiver {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.PresentationReceiver";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!PresentationReceiverRemote}
   */
  static getRemote() {
    let remote = new PresentationReceiverRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the PresentationReceiver
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PresentationReceiverCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      PresentationReceiverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!PresentationReceiverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onReceiverConnectionAvailable =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        PresentationReceiver_OnReceiverConnectionAvailable_ParamsSpec.$,
        null,
        this.onReceiverConnectionAvailable.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PresentationInfoSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PresentationErrorSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PresentationConnectionResultSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PresentationConnection_OnMessage_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PresentationConnection_DidChangeState_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PresentationConnection_DidClose_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PresentationService_SetController_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PresentationService_SetReceiver_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PresentationService_SetDefaultPresentationUrls_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PresentationService_ListenForScreenAvailability_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PresentationService_StopListeningForScreenAvailability_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PresentationService_StartPresentation_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PresentationService_StartPresentation_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PresentationService_ReconnectPresentation_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PresentationService_ReconnectPresentation_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PresentationService_CloseConnection_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PresentationService_Terminate_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PresentationController_OnScreenAvailabilityUpdated_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PresentationController_OnDefaultPresentationStarted_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PresentationController_OnConnectionStateChanged_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PresentationController_OnConnectionClosed_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PresentationReceiver_OnReceiverConnectionAvailable_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType} }
 */
export const PresentationConnectionMessageSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    PresentationInfoSpec.$,
    'PresentationInfo',
    [
      mojo.internal.StructField(
        'url', 0,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'id', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class PresentationInfo {
  constructor() {
    /** @type { !url_mojom_Url } */
    this.url;
    /** @type { !string } */
    this.id;
  }
}



mojo.internal.Struct(
    PresentationErrorSpec.$,
    'PresentationError',
    [
      mojo.internal.StructField(
        'errorType', 0,
        0,
        PresentationErrorTypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'message', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class PresentationError {
  constructor() {
    /** @type { !PresentationErrorType } */
    this.errorType;
    /** @type { !string } */
    this.message;
  }
}



mojo.internal.Struct(
    PresentationConnectionResultSpec.$,
    'PresentationConnectionResult',
    [
      mojo.internal.StructField(
        'presentationInfo', 0,
        0,
        PresentationInfoSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'connectionRemote', 8,
        0,
        mojo.internal.InterfaceProxy(PresentationConnectionRemote),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'connectionReceiver', 16,
        0,
        mojo.internal.InterfaceRequest(PresentationConnectionPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class PresentationConnectionResult {
  constructor() {
    /** @type { !PresentationInfo } */
    this.presentationInfo;
    /** @type { !PresentationConnectionRemote } */
    this.connectionRemote;
    /** @type { !PresentationConnectionPendingReceiver } */
    this.connectionReceiver;
  }
}



mojo.internal.Struct(
    PresentationConnection_OnMessage_ParamsSpec.$,
    'PresentationConnection_OnMessage_Params',
    [
      mojo.internal.StructField(
        'message', 0,
        0,
        PresentationConnectionMessageSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class PresentationConnection_OnMessage_Params {
  constructor() {
    /** @type { !PresentationConnectionMessage } */
    this.message;
  }
}



mojo.internal.Struct(
    PresentationConnection_DidChangeState_ParamsSpec.$,
    'PresentationConnection_DidChangeState_Params',
    [
      mojo.internal.StructField(
        'state', 0,
        0,
        PresentationConnectionStateSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class PresentationConnection_DidChangeState_Params {
  constructor() {
    /** @type { !PresentationConnectionState } */
    this.state;
  }
}



mojo.internal.Struct(
    PresentationConnection_DidClose_ParamsSpec.$,
    'PresentationConnection_DidClose_Params',
    [
      mojo.internal.StructField(
        'reason', 0,
        0,
        PresentationConnectionCloseReasonSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class PresentationConnection_DidClose_Params {
  constructor() {
    /** @type { !PresentationConnectionCloseReason } */
    this.reason;
  }
}



mojo.internal.Struct(
    PresentationService_SetController_ParamsSpec.$,
    'PresentationService_SetController_Params',
    [
      mojo.internal.StructField(
        'controller', 0,
        0,
        mojo.internal.InterfaceProxy(PresentationControllerRemote),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class PresentationService_SetController_Params {
  constructor() {
    /** @type { !PresentationControllerRemote } */
    this.controller;
  }
}



mojo.internal.Struct(
    PresentationService_SetReceiver_ParamsSpec.$,
    'PresentationService_SetReceiver_Params',
    [
      mojo.internal.StructField(
        'receiver', 0,
        0,
        mojo.internal.InterfaceProxy(PresentationReceiverRemote),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class PresentationService_SetReceiver_Params {
  constructor() {
    /** @type { !PresentationReceiverRemote } */
    this.receiver;
  }
}



mojo.internal.Struct(
    PresentationService_SetDefaultPresentationUrls_ParamsSpec.$,
    'PresentationService_SetDefaultPresentationUrls_Params',
    [
      mojo.internal.StructField(
        'presentationUrls', 0,
        0,
        mojo.internal.Array(url_mojom_UrlSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class PresentationService_SetDefaultPresentationUrls_Params {
  constructor() {
    /** @type { !Array<!url_mojom_Url> } */
    this.presentationUrls;
  }
}



mojo.internal.Struct(
    PresentationService_ListenForScreenAvailability_ParamsSpec.$,
    'PresentationService_ListenForScreenAvailability_Params',
    [
      mojo.internal.StructField(
        'availabilityUrl', 0,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class PresentationService_ListenForScreenAvailability_Params {
  constructor() {
    /** @type { !url_mojom_Url } */
    this.availabilityUrl;
  }
}



mojo.internal.Struct(
    PresentationService_StopListeningForScreenAvailability_ParamsSpec.$,
    'PresentationService_StopListeningForScreenAvailability_Params',
    [
      mojo.internal.StructField(
        'availabilityUrl', 0,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class PresentationService_StopListeningForScreenAvailability_Params {
  constructor() {
    /** @type { !url_mojom_Url } */
    this.availabilityUrl;
  }
}



mojo.internal.Struct(
    PresentationService_StartPresentation_ParamsSpec.$,
    'PresentationService_StartPresentation_Params',
    [
      mojo.internal.StructField(
        'presentationUrls', 0,
        0,
        mojo.internal.Array(url_mojom_UrlSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class PresentationService_StartPresentation_Params {
  constructor() {
    /** @type { !Array<!url_mojom_Url> } */
    this.presentationUrls;
  }
}



mojo.internal.Struct(
    PresentationService_StartPresentation_ResponseParamsSpec.$,
    'PresentationService_StartPresentation_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        PresentationConnectionResultSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'error', 8,
        0,
        PresentationErrorSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class PresentationService_StartPresentation_ResponseParams {
  constructor() {
    /** @type { (PresentationConnectionResult|undefined) } */
    this.result;
    /** @type { (PresentationError|undefined) } */
    this.error;
  }
}



mojo.internal.Struct(
    PresentationService_ReconnectPresentation_ParamsSpec.$,
    'PresentationService_ReconnectPresentation_Params',
    [
      mojo.internal.StructField(
        'presentationUrls', 0,
        0,
        mojo.internal.Array(url_mojom_UrlSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'presentationId', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class PresentationService_ReconnectPresentation_Params {
  constructor() {
    /** @type { !Array<!url_mojom_Url> } */
    this.presentationUrls;
    /** @type { !string } */
    this.presentationId;
  }
}



mojo.internal.Struct(
    PresentationService_ReconnectPresentation_ResponseParamsSpec.$,
    'PresentationService_ReconnectPresentation_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        PresentationConnectionResultSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'error', 8,
        0,
        PresentationErrorSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class PresentationService_ReconnectPresentation_ResponseParams {
  constructor() {
    /** @type { (PresentationConnectionResult|undefined) } */
    this.result;
    /** @type { (PresentationError|undefined) } */
    this.error;
  }
}



mojo.internal.Struct(
    PresentationService_CloseConnection_ParamsSpec.$,
    'PresentationService_CloseConnection_Params',
    [
      mojo.internal.StructField(
        'presentationUrl', 0,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'presentationId', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class PresentationService_CloseConnection_Params {
  constructor() {
    /** @type { !url_mojom_Url } */
    this.presentationUrl;
    /** @type { !string } */
    this.presentationId;
  }
}



mojo.internal.Struct(
    PresentationService_Terminate_ParamsSpec.$,
    'PresentationService_Terminate_Params',
    [
      mojo.internal.StructField(
        'presentationUrl', 0,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'presentationId', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class PresentationService_Terminate_Params {
  constructor() {
    /** @type { !url_mojom_Url } */
    this.presentationUrl;
    /** @type { !string } */
    this.presentationId;
  }
}



mojo.internal.Struct(
    PresentationController_OnScreenAvailabilityUpdated_ParamsSpec.$,
    'PresentationController_OnScreenAvailabilityUpdated_Params',
    [
      mojo.internal.StructField(
        'url', 0,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'availability', 8,
        0,
        ScreenAvailabilitySpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class PresentationController_OnScreenAvailabilityUpdated_Params {
  constructor() {
    /** @type { !url_mojom_Url } */
    this.url;
    /** @type { !ScreenAvailability } */
    this.availability;
  }
}



mojo.internal.Struct(
    PresentationController_OnDefaultPresentationStarted_ParamsSpec.$,
    'PresentationController_OnDefaultPresentationStarted_Params',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        PresentationConnectionResultSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class PresentationController_OnDefaultPresentationStarted_Params {
  constructor() {
    /** @type { !PresentationConnectionResult } */
    this.result;
  }
}



mojo.internal.Struct(
    PresentationController_OnConnectionStateChanged_ParamsSpec.$,
    'PresentationController_OnConnectionStateChanged_Params',
    [
      mojo.internal.StructField(
        'presentationInfo', 0,
        0,
        PresentationInfoSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'newState', 8,
        0,
        PresentationConnectionStateSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class PresentationController_OnConnectionStateChanged_Params {
  constructor() {
    /** @type { !PresentationInfo } */
    this.presentationInfo;
    /** @type { !PresentationConnectionState } */
    this.newState;
  }
}



mojo.internal.Struct(
    PresentationController_OnConnectionClosed_ParamsSpec.$,
    'PresentationController_OnConnectionClosed_Params',
    [
      mojo.internal.StructField(
        'presentationInfo', 0,
        0,
        PresentationInfoSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'reason', 8,
        0,
        PresentationConnectionCloseReasonSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'message', 16,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class PresentationController_OnConnectionClosed_Params {
  constructor() {
    /** @type { !PresentationInfo } */
    this.presentationInfo;
    /** @type { !PresentationConnectionCloseReason } */
    this.reason;
    /** @type { !string } */
    this.message;
  }
}



mojo.internal.Struct(
    PresentationReceiver_OnReceiverConnectionAvailable_ParamsSpec.$,
    'PresentationReceiver_OnReceiverConnectionAvailable_Params',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        PresentationConnectionResultSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class PresentationReceiver_OnReceiverConnectionAvailable_Params {
  constructor() {
    /** @type { !PresentationConnectionResult } */
    this.result;
  }
}

mojo.internal.Union(
    PresentationConnectionMessageSpec.$, 'PresentationConnectionMessage',
    {
      'message': {
        'ordinal': 0,
        'type': mojo.internal.String,
      },
      'data': {
        'ordinal': 1,
        'type': mojo.internal.Array(mojo.internal.Uint8, false),
      },
    });

/**
 * @typedef { {
 *   message: (!string|undefined),
 *   data: (!Array<!number>|undefined),
 * } }
 */
export const PresentationConnectionMessage = {};
