// third_party/blink/public/mojom/presentation/presentation.mojom-blink-test-utils.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_PRESENTATION_PRESENTATION_MOJOM_BLINK_TEST_UTILS_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_PRESENTATION_PRESENTATION_MOJOM_BLINK_TEST_UTILS_H_

#include "third_party/blink/public/mojom/presentation/presentation.mojom-blink.h"
#include "third_party/blink/renderer/platform/platform_export.h"


namespace blink::mojom::blink {


class PLATFORM_EXPORT PresentationConnectionInterceptorForTesting : public PresentationConnection {
  virtual PresentationConnection* GetForwardingInterface() = 0;
  void OnMessage(PresentationConnectionMessagePtr message) override;
  void DidChangeState(PresentationConnectionState state) override;
  void DidClose(PresentationConnectionCloseReason reason) override;
};
class PLATFORM_EXPORT PresentationConnectionAsyncWaiter {
 public:
  explicit PresentationConnectionAsyncWaiter(PresentationConnection* proxy);

  PresentationConnectionAsyncWaiter(const PresentationConnectionAsyncWaiter&) = delete;
  PresentationConnectionAsyncWaiter& operator=(const PresentationConnectionAsyncWaiter&) = delete;

  ~PresentationConnectionAsyncWaiter();

 private:
  PresentationConnection* const proxy_;
};


class PLATFORM_EXPORT PresentationServiceInterceptorForTesting : public PresentationService {
  virtual PresentationService* GetForwardingInterface() = 0;
  void SetController(::mojo::PendingRemote<PresentationController> controller) override;
  void SetReceiver(::mojo::PendingRemote<PresentationReceiver> receiver) override;
  void SetDefaultPresentationUrls(const ::blink::Vector<::blink::KURL>& presentation_urls) override;
  void ListenForScreenAvailability(const ::blink::KURL& availability_url) override;
  void StopListeningForScreenAvailability(const ::blink::KURL& availability_url) override;
  void StartPresentation(const ::blink::Vector<::blink::KURL>& presentation_urls, StartPresentationCallback callback) override;
  void ReconnectPresentation(const ::blink::Vector<::blink::KURL>& presentation_urls, const ::blink::String& presentation_id, ReconnectPresentationCallback callback) override;
  void CloseConnection(const ::blink::KURL& presentation_url, const ::blink::String& presentation_id) override;
  void Terminate(const ::blink::KURL& presentation_url, const ::blink::String& presentation_id) override;
};
class PLATFORM_EXPORT PresentationServiceAsyncWaiter {
 public:
  explicit PresentationServiceAsyncWaiter(PresentationService* proxy);

  PresentationServiceAsyncWaiter(const PresentationServiceAsyncWaiter&) = delete;
  PresentationServiceAsyncWaiter& operator=(const PresentationServiceAsyncWaiter&) = delete;

  ~PresentationServiceAsyncWaiter();
  void StartPresentation(
      const ::blink::Vector<::blink::KURL>& presentation_urls, PresentationConnectionResultPtr* out_result, PresentationErrorPtr* out_error);
  
  void ReconnectPresentation(
      const ::blink::Vector<::blink::KURL>& presentation_urls, const ::blink::String& presentation_id, PresentationConnectionResultPtr* out_result, PresentationErrorPtr* out_error);
  

 private:
  PresentationService* const proxy_;
};


class PLATFORM_EXPORT PresentationControllerInterceptorForTesting : public PresentationController {
  virtual PresentationController* GetForwardingInterface() = 0;
  void OnScreenAvailabilityUpdated(const ::blink::KURL& url, ScreenAvailability availability) override;
  void OnDefaultPresentationStarted(PresentationConnectionResultPtr result) override;
  void OnConnectionStateChanged(PresentationInfoPtr presentation_info, PresentationConnectionState newState) override;
  void OnConnectionClosed(PresentationInfoPtr presentation_info, PresentationConnectionCloseReason reason, const ::blink::String& message) override;
};
class PLATFORM_EXPORT PresentationControllerAsyncWaiter {
 public:
  explicit PresentationControllerAsyncWaiter(PresentationController* proxy);

  PresentationControllerAsyncWaiter(const PresentationControllerAsyncWaiter&) = delete;
  PresentationControllerAsyncWaiter& operator=(const PresentationControllerAsyncWaiter&) = delete;

  ~PresentationControllerAsyncWaiter();

 private:
  PresentationController* const proxy_;
};


class PLATFORM_EXPORT PresentationReceiverInterceptorForTesting : public PresentationReceiver {
  virtual PresentationReceiver* GetForwardingInterface() = 0;
  void OnReceiverConnectionAvailable(PresentationConnectionResultPtr result) override;
};
class PLATFORM_EXPORT PresentationReceiverAsyncWaiter {
 public:
  explicit PresentationReceiverAsyncWaiter(PresentationReceiver* proxy);

  PresentationReceiverAsyncWaiter(const PresentationReceiverAsyncWaiter&) = delete;
  PresentationReceiverAsyncWaiter& operator=(const PresentationReceiverAsyncWaiter&) = delete;

  ~PresentationReceiverAsyncWaiter();

 private:
  PresentationReceiver* const proxy_;
};




}  // blink::mojom::blink

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_PRESENTATION_PRESENTATION_MOJOM_BLINK_TEST_UTILS_H_