// third_party/blink/public/mojom/prerender/prerender.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../../mojo/public/js/bindings.js';

import {
  Size as gfx_mojom_Size,
  SizeSpec as gfx_mojom_SizeSpec
} from '../../../../../ui/gfx/geometry/mojom/geometry.mojom.m.js';

import {
  Url as url_mojom_Url,
  UrlSpec as url_mojom_UrlSpec
} from '../../../../../url/mojom/url.mojom.m.js';

import {
  Referrer as blink_mojom_Referrer,
  ReferrerSpec as blink_mojom_ReferrerSpec
} from '../loader/referrer.mojom.m.js';


/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const PrerenderTriggerTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const PrerenderTriggerType = {
  
  kLinkRelPrerender: 0,
  kLinkRelNext: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};



/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class NoStatePrefetchProcessorPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.NoStatePrefetchProcessor', scope);
  }
}

/** @interface */
export class NoStatePrefetchProcessorInterface {
  
  /**
   * @param { !PrerenderAttributes } prerenderAttribute
   */

  start(prerenderAttribute) {}
  
  /**
   */

  cancel() {}
}

/**
 * @implements { NoStatePrefetchProcessorInterface }
 */
export class NoStatePrefetchProcessorRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!NoStatePrefetchProcessorPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          NoStatePrefetchProcessorPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!NoStatePrefetchProcessorPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !PrerenderAttributes } prerenderAttribute
   */

  start(
      prerenderAttribute) {
    this.proxy.sendMessage(
        0,
        NoStatePrefetchProcessor_Start_ParamsSpec.$,
        null,
        [
          prerenderAttribute
        ],
        false);
  }

  
  /**
   */

  cancel() {
    this.proxy.sendMessage(
        1,
        NoStatePrefetchProcessor_Cancel_ParamsSpec.$,
        null,
        [
        ],
        false);
  }
}

/**
 * An object which receives request messages for the NoStatePrefetchProcessor
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class NoStatePrefetchProcessorReceiver {
  /**
   * @param {!NoStatePrefetchProcessorInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!NoStatePrefetchProcessorRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        NoStatePrefetchProcessorRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!NoStatePrefetchProcessorRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        NoStatePrefetchProcessor_Start_ParamsSpec.$,
        null,
        impl.start.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        NoStatePrefetchProcessor_Cancel_ParamsSpec.$,
        null,
        impl.cancel.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class NoStatePrefetchProcessor {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.NoStatePrefetchProcessor";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!NoStatePrefetchProcessorRemote}
   */
  static getRemote() {
    let remote = new NoStatePrefetchProcessorRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the NoStatePrefetchProcessor
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class NoStatePrefetchProcessorCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      NoStatePrefetchProcessorRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!NoStatePrefetchProcessorRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.start =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        NoStatePrefetchProcessor_Start_ParamsSpec.$,
        null,
        this.start.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.cancel =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        NoStatePrefetchProcessor_Cancel_ParamsSpec.$,
        null,
        this.cancel.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PrerenderAttributesSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NoStatePrefetchProcessor_Start_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NoStatePrefetchProcessor_Cancel_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    PrerenderAttributesSpec.$,
    'PrerenderAttributes',
    [
      mojo.internal.StructField(
        'url', 0,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'triggerType', 8,
        0,
        PrerenderTriggerTypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'referrer', 16,
        0,
        blink_mojom_ReferrerSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'viewSize', 24,
        0,
        gfx_mojom_SizeSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 40],]);



/**
 * @record
 */
export class PrerenderAttributes {
  constructor() {
    /** @type { !url_mojom_Url } */
    this.url;
    /** @type { !PrerenderTriggerType } */
    this.triggerType;
    /** @type { !blink_mojom_Referrer } */
    this.referrer;
    /** @type { !gfx_mojom_Size } */
    this.viewSize;
  }
}



mojo.internal.Struct(
    NoStatePrefetchProcessor_Start_ParamsSpec.$,
    'NoStatePrefetchProcessor_Start_Params',
    [
      mojo.internal.StructField(
        'prerenderAttribute', 0,
        0,
        PrerenderAttributesSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class NoStatePrefetchProcessor_Start_Params {
  constructor() {
    /** @type { !PrerenderAttributes } */
    this.prerenderAttribute;
  }
}



mojo.internal.Struct(
    NoStatePrefetchProcessor_Cancel_ParamsSpec.$,
    'NoStatePrefetchProcessor_Cancel_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class NoStatePrefetchProcessor_Cancel_Params {
  constructor() {
  }
}

