// third_party/blink/public/mojom/prerender/prerender.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_PRERENDER_PRERENDER_MOJOM_DATA_VIEW_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_PRERENDER_PRERENDER_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/blink/public/mojom/prerender/prerender.mojom-shared-internal.h"
#include "third_party/blink/public/mojom/loader/referrer.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"


namespace blink::mojom {
class PrerenderAttributesDataView;



}  // blink::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::blink::mojom::PrerenderAttributesDataView> {
  using Data = ::blink::mojom::internal::PrerenderAttributes_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace blink::mojom {


enum class PrerenderTriggerType : int32_t {
  
  kLinkRelPrerender = 0,
  
  kLinkRelNext = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, PrerenderTriggerType value);
inline bool IsKnownEnumValue(PrerenderTriggerType value) {
  return internal::PrerenderTriggerType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class NoStatePrefetchProcessorInterfaceBase {};

using NoStatePrefetchProcessorPtrDataView =
    mojo::InterfacePtrDataView<NoStatePrefetchProcessorInterfaceBase>;
using NoStatePrefetchProcessorRequestDataView =
    mojo::InterfaceRequestDataView<NoStatePrefetchProcessorInterfaceBase>;
using NoStatePrefetchProcessorAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<NoStatePrefetchProcessorInterfaceBase>;
using NoStatePrefetchProcessorAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<NoStatePrefetchProcessorInterfaceBase>;


class PrerenderAttributesDataView {
 public:
  PrerenderAttributesDataView() = default;

  PrerenderAttributesDataView(
      internal::PrerenderAttributes_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUrl(UserType* output) {
    
    auto* pointer = data_->url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadTriggerType(UserType* output) const {
    auto data_value = data_->trigger_type;
    return mojo::internal::Deserialize<::blink::mojom::PrerenderTriggerType>(
        data_value, output);
  }
  PrerenderTriggerType trigger_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::PrerenderTriggerType>(data_->trigger_type));
  }
  inline void GetReferrerDataView(
      ::blink::mojom::ReferrerDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadReferrer(UserType* output) {
    
    auto* pointer = data_->referrer.Get();
    return mojo::internal::Deserialize<::blink::mojom::ReferrerDataView>(
        pointer, output, message_);
  }
  inline void GetViewSizeDataView(
      ::gfx::mojom::SizeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadViewSize(UserType* output) {
    
    auto* pointer = data_->view_size.Get();
    return mojo::internal::Deserialize<::gfx::mojom::SizeDataView>(
        pointer, output, message_);
  }
 private:
  internal::PrerenderAttributes_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // blink::mojom

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_PRERENDER_PRERENDER_MOJOM_DATA_VIEW_H_