// third_party/blink/public/mojom/permissions/permission.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'third_party/blink/public/mojom/permissions/permission.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('blink.mojom');
  var permission_status$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/permissions/permission_status.mojom', 'permission_status.mojom.js');
  }
  var origin$ =
      mojo.internal.exposeNamespace('url.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'url/mojom/origin.mojom', '../../../../../url/mojom/origin.mojom.js');
  }
  var geometry$ =
      mojo.internal.exposeNamespace('gfx.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'ui/gfx/geometry/mojom/geometry.mojom', '../../../../../ui/gfx/geometry/mojom/geometry.mojom.js');
  }


  var PermissionName = {};
  PermissionName.GEOLOCATION = 0;
  PermissionName.NOTIFICATIONS = 1;
  PermissionName.MIDI = 2;
  PermissionName.PROTECTED_MEDIA_IDENTIFIER = 3;
  PermissionName.DURABLE_STORAGE = 4;
  PermissionName.AUDIO_CAPTURE = 5;
  PermissionName.VIDEO_CAPTURE = 6;
  PermissionName.BACKGROUND_SYNC = 7;
  PermissionName.SENSORS = 8;
  PermissionName.CLIPBOARD_READ = 9;
  PermissionName.CLIPBOARD_WRITE = 10;
  PermissionName.PAYMENT_HANDLER = 11;
  PermissionName.BACKGROUND_FETCH = 12;
  PermissionName.IDLE_DETECTION = 13;
  PermissionName.PERIODIC_BACKGROUND_SYNC = 14;
  PermissionName.SCREEN_WAKE_LOCK = 15;
  PermissionName.SYSTEM_WAKE_LOCK = 16;
  PermissionName.NFC = 17;
  PermissionName.STORAGE_ACCESS = 18;
  PermissionName.WINDOW_MANAGEMENT = 19;
  PermissionName.LOCAL_FONTS = 20;
  PermissionName.DISPLAY_CAPTURE = 21;
  PermissionName.TOP_LEVEL_STORAGE_ACCESS = 22;
  PermissionName.CAPTURED_SURFACE_CONTROL = 23;
  PermissionName.SPEAKER_SELECTION = 24;
  PermissionName.KEYBOARD_LOCK = 25;
  PermissionName.POINTER_LOCK = 26;
  PermissionName.FULLSCREEN = 27;
  PermissionName.WEB_APP_INSTALLATION = 28;
  PermissionName.LOCAL_NETWORK_ACCESS = 29;
  PermissionName.VR = 30;
  PermissionName.AR = 31;
  PermissionName.HAND_TRACKING = 32;
  PermissionName.WEB_PRINTING = 33;
  PermissionName.SMART_CARD = 34;
  PermissionName.MIN_VALUE = 0;
  PermissionName.MAX_VALUE = 34;

  PermissionName.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
    case 4:
    case 5:
    case 6:
    case 7:
    case 8:
    case 9:
    case 10:
    case 11:
    case 12:
    case 13:
    case 14:
    case 15:
    case 16:
    case 17:
    case 18:
    case 19:
    case 20:
    case 21:
    case 22:
    case 23:
    case 24:
    case 25:
    case 26:
    case 27:
    case 28:
    case 29:
    case 30:
    case 31:
    case 32:
    case 33:
    case 34:
      return true;
    }
    return false;
  };

  PermissionName.toKnownEnumValue = function(value) {
    return value;
  };

  PermissionName.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var EmbeddedPermissionControlResult = {};
  EmbeddedPermissionControlResult.kDismissed = 0;
  EmbeddedPermissionControlResult.kGranted = 1;
  EmbeddedPermissionControlResult.kDenied = 2;
  EmbeddedPermissionControlResult.kNotSupported = 3;
  EmbeddedPermissionControlResult.kResolvedNoUserGesture = 4;
  EmbeddedPermissionControlResult.MIN_VALUE = 0;
  EmbeddedPermissionControlResult.MAX_VALUE = 4;

  EmbeddedPermissionControlResult.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
    case 4:
      return true;
    }
    return false;
  };

  EmbeddedPermissionControlResult.toKnownEnumValue = function(value) {
    return value;
  };

  EmbeddedPermissionControlResult.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };

  function MidiPermissionDescriptor(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MidiPermissionDescriptor.prototype.initDefaults_ = function() {
    this.sysex = false;
  };
  MidiPermissionDescriptor.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MidiPermissionDescriptor.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  MidiPermissionDescriptor.encodedSize = codec.kStructHeaderSize + 8;

  MidiPermissionDescriptor.decode = function(decoder) {
    var packed;
    var val = new MidiPermissionDescriptor();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.sysex = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  MidiPermissionDescriptor.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MidiPermissionDescriptor.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.sysex & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function ClipboardPermissionDescriptor(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ClipboardPermissionDescriptor.prototype.initDefaults_ = function() {
    this.hasUserGesture = false;
    this.willBeSanitized = false;
  };
  ClipboardPermissionDescriptor.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ClipboardPermissionDescriptor.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    return validator.validationError.NONE;
  };

  ClipboardPermissionDescriptor.encodedSize = codec.kStructHeaderSize + 8;

  ClipboardPermissionDescriptor.decode = function(decoder) {
    var packed;
    var val = new ClipboardPermissionDescriptor();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.hasUserGesture = (packed >> 0) & 1 ? true : false;
    val.willBeSanitized = (packed >> 1) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  ClipboardPermissionDescriptor.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ClipboardPermissionDescriptor.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.hasUserGesture & 1) << 0
    packed |= (val.willBeSanitized & 1) << 1
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function CameraDevicePermissionDescriptor(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  CameraDevicePermissionDescriptor.prototype.initDefaults_ = function() {
    this.panTiltZoom = false;
  };
  CameraDevicePermissionDescriptor.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  CameraDevicePermissionDescriptor.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  CameraDevicePermissionDescriptor.encodedSize = codec.kStructHeaderSize + 8;

  CameraDevicePermissionDescriptor.decode = function(decoder) {
    var packed;
    var val = new CameraDevicePermissionDescriptor();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.panTiltZoom = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  CameraDevicePermissionDescriptor.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(CameraDevicePermissionDescriptor.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.panTiltZoom & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function TopLevelStorageAccessPermissionDescriptor(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  TopLevelStorageAccessPermissionDescriptor.prototype.initDefaults_ = function() {
    this.requestedOrigin = null;
  };
  TopLevelStorageAccessPermissionDescriptor.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  TopLevelStorageAccessPermissionDescriptor.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate TopLevelStorageAccessPermissionDescriptor.requestedOrigin
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, origin$.Origin, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  TopLevelStorageAccessPermissionDescriptor.encodedSize = codec.kStructHeaderSize + 8;

  TopLevelStorageAccessPermissionDescriptor.decode = function(decoder) {
    var packed;
    var val = new TopLevelStorageAccessPermissionDescriptor();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.requestedOrigin =
        decoder.decodeStructPointer(origin$.Origin);
    return val;
  };

  TopLevelStorageAccessPermissionDescriptor.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(TopLevelStorageAccessPermissionDescriptor.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(origin$.Origin, val.requestedOrigin);
  };
  function FullscreenPermissionDescriptor(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FullscreenPermissionDescriptor.prototype.initDefaults_ = function() {
    this.allowWithoutUserGesture = false;
  };
  FullscreenPermissionDescriptor.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FullscreenPermissionDescriptor.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  FullscreenPermissionDescriptor.encodedSize = codec.kStructHeaderSize + 8;

  FullscreenPermissionDescriptor.decode = function(decoder) {
    var packed;
    var val = new FullscreenPermissionDescriptor();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.allowWithoutUserGesture = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  FullscreenPermissionDescriptor.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FullscreenPermissionDescriptor.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.allowWithoutUserGesture & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function PermissionDescriptor(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  PermissionDescriptor.prototype.initDefaults_ = function() {
    this.name = 0;
    this.extension = null;
  };
  PermissionDescriptor.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  PermissionDescriptor.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate PermissionDescriptor.name
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, PermissionName);
    if (err !== validator.validationError.NONE)
        return err;


    // validate PermissionDescriptor.extension
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 8, PermissionDescriptorExtension, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  PermissionDescriptor.encodedSize = codec.kStructHeaderSize + 24;

  PermissionDescriptor.decode = function(decoder) {
    var packed;
    var val = new PermissionDescriptor();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.name =
        decoder.decodeStruct(new codec.Enum(PermissionName));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.extension =
        decoder.decodeStruct(PermissionDescriptorExtension);
    return val;
  };

  PermissionDescriptor.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(PermissionDescriptor.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.name);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(PermissionDescriptorExtension, val.extension);
  };
  function GeolocationEmbeddedPermissionRequestDescriptor(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  GeolocationEmbeddedPermissionRequestDescriptor.prototype.initDefaults_ = function() {
    this.autolocate = false;
  };
  GeolocationEmbeddedPermissionRequestDescriptor.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  GeolocationEmbeddedPermissionRequestDescriptor.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  GeolocationEmbeddedPermissionRequestDescriptor.encodedSize = codec.kStructHeaderSize + 8;

  GeolocationEmbeddedPermissionRequestDescriptor.decode = function(decoder) {
    var packed;
    var val = new GeolocationEmbeddedPermissionRequestDescriptor();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.autolocate = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  GeolocationEmbeddedPermissionRequestDescriptor.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(GeolocationEmbeddedPermissionRequestDescriptor.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.autolocate & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function EmbeddedPermissionRequestDescriptor(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  EmbeddedPermissionRequestDescriptor.prototype.initDefaults_ = function() {
    this.elementPosition = null;
    this.geolocation = null;
  };
  EmbeddedPermissionRequestDescriptor.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  EmbeddedPermissionRequestDescriptor.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate EmbeddedPermissionRequestDescriptor.elementPosition
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, geometry$.Rect, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate EmbeddedPermissionRequestDescriptor.geolocation
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, GeolocationEmbeddedPermissionRequestDescriptor, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  EmbeddedPermissionRequestDescriptor.encodedSize = codec.kStructHeaderSize + 16;

  EmbeddedPermissionRequestDescriptor.decode = function(decoder) {
    var packed;
    var val = new EmbeddedPermissionRequestDescriptor();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.elementPosition =
        decoder.decodeStructPointer(geometry$.Rect);
    val.geolocation =
        decoder.decodeStructPointer(GeolocationEmbeddedPermissionRequestDescriptor);
    return val;
  };

  EmbeddedPermissionRequestDescriptor.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(EmbeddedPermissionRequestDescriptor.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(geometry$.Rect, val.elementPosition);
    encoder.encodeStructPointer(GeolocationEmbeddedPermissionRequestDescriptor, val.geolocation);
  };
  function PermissionObserver_OnPermissionStatusChange_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  PermissionObserver_OnPermissionStatusChange_Params.prototype.initDefaults_ = function() {
    this.status = 0;
  };
  PermissionObserver_OnPermissionStatusChange_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  PermissionObserver_OnPermissionStatusChange_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate PermissionObserver_OnPermissionStatusChange_Params.status
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, permission_status$.PermissionStatus);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  PermissionObserver_OnPermissionStatusChange_Params.encodedSize = codec.kStructHeaderSize + 8;

  PermissionObserver_OnPermissionStatusChange_Params.decode = function(decoder) {
    var packed;
    var val = new PermissionObserver_OnPermissionStatusChange_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.status =
        decoder.decodeStruct(new codec.Enum(permission_status$.PermissionStatus));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  PermissionObserver_OnPermissionStatusChange_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(PermissionObserver_OnPermissionStatusChange_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.status);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function EmbeddedPermissionControlClient_OnEmbeddedPermissionControlRegistered_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  EmbeddedPermissionControlClient_OnEmbeddedPermissionControlRegistered_Params.prototype.initDefaults_ = function() {
    this.allow = false;
    this.statuses = null;
  };
  EmbeddedPermissionControlClient_OnEmbeddedPermissionControlRegistered_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  EmbeddedPermissionControlClient_OnEmbeddedPermissionControlRegistered_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    // validate EmbeddedPermissionControlClient_OnEmbeddedPermissionControlRegistered_Params.statuses
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 8, 4, new codec.Enum(permission_status$.PermissionStatus), true, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  EmbeddedPermissionControlClient_OnEmbeddedPermissionControlRegistered_Params.encodedSize = codec.kStructHeaderSize + 16;

  EmbeddedPermissionControlClient_OnEmbeddedPermissionControlRegistered_Params.decode = function(decoder) {
    var packed;
    var val = new EmbeddedPermissionControlClient_OnEmbeddedPermissionControlRegistered_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.allow = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.statuses =
        decoder.decodeArrayPointer(new codec.Enum(permission_status$.PermissionStatus));
    return val;
  };

  EmbeddedPermissionControlClient_OnEmbeddedPermissionControlRegistered_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(EmbeddedPermissionControlClient_OnEmbeddedPermissionControlRegistered_Params.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.allow & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeArrayPointer(new codec.Enum(permission_status$.PermissionStatus), val.statuses);
  };
  function PermissionService_HasPermission_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  PermissionService_HasPermission_Params.prototype.initDefaults_ = function() {
    this.permission = null;
  };
  PermissionService_HasPermission_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  PermissionService_HasPermission_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate PermissionService_HasPermission_Params.permission
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, PermissionDescriptor, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  PermissionService_HasPermission_Params.encodedSize = codec.kStructHeaderSize + 8;

  PermissionService_HasPermission_Params.decode = function(decoder) {
    var packed;
    var val = new PermissionService_HasPermission_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.permission =
        decoder.decodeStructPointer(PermissionDescriptor);
    return val;
  };

  PermissionService_HasPermission_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(PermissionService_HasPermission_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(PermissionDescriptor, val.permission);
  };
  function PermissionService_HasPermission_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  PermissionService_HasPermission_ResponseParams.prototype.initDefaults_ = function() {
    this.status = 0;
  };
  PermissionService_HasPermission_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  PermissionService_HasPermission_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate PermissionService_HasPermission_ResponseParams.status
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, permission_status$.PermissionStatus);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  PermissionService_HasPermission_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  PermissionService_HasPermission_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new PermissionService_HasPermission_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.status =
        decoder.decodeStruct(new codec.Enum(permission_status$.PermissionStatus));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  PermissionService_HasPermission_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(PermissionService_HasPermission_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.status);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function PermissionService_RegisterPageEmbeddedPermissionControl_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  PermissionService_RegisterPageEmbeddedPermissionControl_Params.prototype.initDefaults_ = function() {
    this.permissions = null;
    this.descriptor = null;
    this.client = new EmbeddedPermissionControlClientPtr();
  };
  PermissionService_RegisterPageEmbeddedPermissionControl_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  PermissionService_RegisterPageEmbeddedPermissionControl_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate PermissionService_RegisterPageEmbeddedPermissionControl_Params.permissions
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 8, new codec.PointerTo(PermissionDescriptor), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate PermissionService_RegisterPageEmbeddedPermissionControl_Params.descriptor
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, EmbeddedPermissionRequestDescriptor, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate PermissionService_RegisterPageEmbeddedPermissionControl_Params.client
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 16, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  PermissionService_RegisterPageEmbeddedPermissionControl_Params.encodedSize = codec.kStructHeaderSize + 24;

  PermissionService_RegisterPageEmbeddedPermissionControl_Params.decode = function(decoder) {
    var packed;
    var val = new PermissionService_RegisterPageEmbeddedPermissionControl_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.permissions =
        decoder.decodeArrayPointer(new codec.PointerTo(PermissionDescriptor));
    val.descriptor =
        decoder.decodeStructPointer(EmbeddedPermissionRequestDescriptor);
    val.client =
        decoder.decodeStruct(new codec.Interface(EmbeddedPermissionControlClientPtr));
    return val;
  };

  PermissionService_RegisterPageEmbeddedPermissionControl_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(PermissionService_RegisterPageEmbeddedPermissionControl_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(new codec.PointerTo(PermissionDescriptor), val.permissions);
    encoder.encodeStructPointer(EmbeddedPermissionRequestDescriptor, val.descriptor);
    encoder.encodeStruct(new codec.Interface(EmbeddedPermissionControlClientPtr), val.client);
  };
  function PermissionService_RequestPageEmbeddedPermission_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  PermissionService_RequestPageEmbeddedPermission_Params.prototype.initDefaults_ = function() {
    this.permissions = null;
    this.descriptor = null;
  };
  PermissionService_RequestPageEmbeddedPermission_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  PermissionService_RequestPageEmbeddedPermission_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate PermissionService_RequestPageEmbeddedPermission_Params.permissions
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 8, new codec.PointerTo(PermissionDescriptor), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate PermissionService_RequestPageEmbeddedPermission_Params.descriptor
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, EmbeddedPermissionRequestDescriptor, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  PermissionService_RequestPageEmbeddedPermission_Params.encodedSize = codec.kStructHeaderSize + 16;

  PermissionService_RequestPageEmbeddedPermission_Params.decode = function(decoder) {
    var packed;
    var val = new PermissionService_RequestPageEmbeddedPermission_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.permissions =
        decoder.decodeArrayPointer(new codec.PointerTo(PermissionDescriptor));
    val.descriptor =
        decoder.decodeStructPointer(EmbeddedPermissionRequestDescriptor);
    return val;
  };

  PermissionService_RequestPageEmbeddedPermission_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(PermissionService_RequestPageEmbeddedPermission_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(new codec.PointerTo(PermissionDescriptor), val.permissions);
    encoder.encodeStructPointer(EmbeddedPermissionRequestDescriptor, val.descriptor);
  };
  function PermissionService_RequestPageEmbeddedPermission_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  PermissionService_RequestPageEmbeddedPermission_ResponseParams.prototype.initDefaults_ = function() {
    this.status = 0;
  };
  PermissionService_RequestPageEmbeddedPermission_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  PermissionService_RequestPageEmbeddedPermission_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate PermissionService_RequestPageEmbeddedPermission_ResponseParams.status
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, EmbeddedPermissionControlResult);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  PermissionService_RequestPageEmbeddedPermission_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  PermissionService_RequestPageEmbeddedPermission_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new PermissionService_RequestPageEmbeddedPermission_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.status =
        decoder.decodeStruct(new codec.Enum(EmbeddedPermissionControlResult));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  PermissionService_RequestPageEmbeddedPermission_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(PermissionService_RequestPageEmbeddedPermission_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.status);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function PermissionService_RequestPermission_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  PermissionService_RequestPermission_Params.prototype.initDefaults_ = function() {
    this.permission = null;
    this.userGesture = false;
  };
  PermissionService_RequestPermission_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  PermissionService_RequestPermission_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate PermissionService_RequestPermission_Params.permission
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, PermissionDescriptor, false);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  PermissionService_RequestPermission_Params.encodedSize = codec.kStructHeaderSize + 16;

  PermissionService_RequestPermission_Params.decode = function(decoder) {
    var packed;
    var val = new PermissionService_RequestPermission_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.permission =
        decoder.decodeStructPointer(PermissionDescriptor);
    packed = decoder.readUint8();
    val.userGesture = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  PermissionService_RequestPermission_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(PermissionService_RequestPermission_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(PermissionDescriptor, val.permission);
    packed = 0;
    packed |= (val.userGesture & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function PermissionService_RequestPermission_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  PermissionService_RequestPermission_ResponseParams.prototype.initDefaults_ = function() {
    this.status = 0;
  };
  PermissionService_RequestPermission_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  PermissionService_RequestPermission_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate PermissionService_RequestPermission_ResponseParams.status
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, permission_status$.PermissionStatus);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  PermissionService_RequestPermission_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  PermissionService_RequestPermission_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new PermissionService_RequestPermission_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.status =
        decoder.decodeStruct(new codec.Enum(permission_status$.PermissionStatus));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  PermissionService_RequestPermission_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(PermissionService_RequestPermission_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.status);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function PermissionService_RequestPermissions_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  PermissionService_RequestPermissions_Params.prototype.initDefaults_ = function() {
    this.permission = null;
    this.userGesture = false;
  };
  PermissionService_RequestPermissions_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  PermissionService_RequestPermissions_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate PermissionService_RequestPermissions_Params.permission
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 8, new codec.PointerTo(PermissionDescriptor), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  PermissionService_RequestPermissions_Params.encodedSize = codec.kStructHeaderSize + 16;

  PermissionService_RequestPermissions_Params.decode = function(decoder) {
    var packed;
    var val = new PermissionService_RequestPermissions_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.permission =
        decoder.decodeArrayPointer(new codec.PointerTo(PermissionDescriptor));
    packed = decoder.readUint8();
    val.userGesture = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  PermissionService_RequestPermissions_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(PermissionService_RequestPermissions_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(new codec.PointerTo(PermissionDescriptor), val.permission);
    packed = 0;
    packed |= (val.userGesture & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function PermissionService_RequestPermissions_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  PermissionService_RequestPermissions_ResponseParams.prototype.initDefaults_ = function() {
    this.statuses = null;
  };
  PermissionService_RequestPermissions_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  PermissionService_RequestPermissions_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate PermissionService_RequestPermissions_ResponseParams.statuses
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 4, new codec.Enum(permission_status$.PermissionStatus), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  PermissionService_RequestPermissions_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  PermissionService_RequestPermissions_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new PermissionService_RequestPermissions_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.statuses =
        decoder.decodeArrayPointer(new codec.Enum(permission_status$.PermissionStatus));
    return val;
  };

  PermissionService_RequestPermissions_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(PermissionService_RequestPermissions_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(new codec.Enum(permission_status$.PermissionStatus), val.statuses);
  };
  function PermissionService_RevokePermission_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  PermissionService_RevokePermission_Params.prototype.initDefaults_ = function() {
    this.permission = null;
  };
  PermissionService_RevokePermission_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  PermissionService_RevokePermission_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate PermissionService_RevokePermission_Params.permission
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, PermissionDescriptor, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  PermissionService_RevokePermission_Params.encodedSize = codec.kStructHeaderSize + 8;

  PermissionService_RevokePermission_Params.decode = function(decoder) {
    var packed;
    var val = new PermissionService_RevokePermission_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.permission =
        decoder.decodeStructPointer(PermissionDescriptor);
    return val;
  };

  PermissionService_RevokePermission_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(PermissionService_RevokePermission_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(PermissionDescriptor, val.permission);
  };
  function PermissionService_RevokePermission_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  PermissionService_RevokePermission_ResponseParams.prototype.initDefaults_ = function() {
    this.status = 0;
  };
  PermissionService_RevokePermission_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  PermissionService_RevokePermission_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate PermissionService_RevokePermission_ResponseParams.status
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, permission_status$.PermissionStatus);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  PermissionService_RevokePermission_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  PermissionService_RevokePermission_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new PermissionService_RevokePermission_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.status =
        decoder.decodeStruct(new codec.Enum(permission_status$.PermissionStatus));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  PermissionService_RevokePermission_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(PermissionService_RevokePermission_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.status);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function PermissionService_AddPermissionObserver_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  PermissionService_AddPermissionObserver_Params.prototype.initDefaults_ = function() {
    this.permission = null;
    this.lastKnownStatus = 0;
    this.observer = new PermissionObserverPtr();
  };
  PermissionService_AddPermissionObserver_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  PermissionService_AddPermissionObserver_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate PermissionService_AddPermissionObserver_Params.permission
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, PermissionDescriptor, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate PermissionService_AddPermissionObserver_Params.lastKnownStatus
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 8, permission_status$.PermissionStatus);
    if (err !== validator.validationError.NONE)
        return err;


    // validate PermissionService_AddPermissionObserver_Params.observer
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 12, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  PermissionService_AddPermissionObserver_Params.encodedSize = codec.kStructHeaderSize + 24;

  PermissionService_AddPermissionObserver_Params.decode = function(decoder) {
    var packed;
    var val = new PermissionService_AddPermissionObserver_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.permission =
        decoder.decodeStructPointer(PermissionDescriptor);
    val.lastKnownStatus =
        decoder.decodeStruct(new codec.Enum(permission_status$.PermissionStatus));
    val.observer =
        decoder.decodeStruct(new codec.Interface(PermissionObserverPtr));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  PermissionService_AddPermissionObserver_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(PermissionService_AddPermissionObserver_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(PermissionDescriptor, val.permission);
    encoder.encodeStruct(codec.Int32, val.lastKnownStatus);
    encoder.encodeStruct(new codec.Interface(PermissionObserverPtr), val.observer);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function PermissionService_AddPageEmbeddedPermissionObserver_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  PermissionService_AddPageEmbeddedPermissionObserver_Params.prototype.initDefaults_ = function() {
    this.permission = null;
    this.lastKnownStatus = 0;
    this.observer = new PermissionObserverPtr();
  };
  PermissionService_AddPageEmbeddedPermissionObserver_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  PermissionService_AddPageEmbeddedPermissionObserver_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate PermissionService_AddPageEmbeddedPermissionObserver_Params.permission
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, PermissionDescriptor, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate PermissionService_AddPageEmbeddedPermissionObserver_Params.lastKnownStatus
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 8, permission_status$.PermissionStatus);
    if (err !== validator.validationError.NONE)
        return err;


    // validate PermissionService_AddPageEmbeddedPermissionObserver_Params.observer
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 12, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  PermissionService_AddPageEmbeddedPermissionObserver_Params.encodedSize = codec.kStructHeaderSize + 24;

  PermissionService_AddPageEmbeddedPermissionObserver_Params.decode = function(decoder) {
    var packed;
    var val = new PermissionService_AddPageEmbeddedPermissionObserver_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.permission =
        decoder.decodeStructPointer(PermissionDescriptor);
    val.lastKnownStatus =
        decoder.decodeStruct(new codec.Enum(permission_status$.PermissionStatus));
    val.observer =
        decoder.decodeStruct(new codec.Interface(PermissionObserverPtr));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  PermissionService_AddPageEmbeddedPermissionObserver_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(PermissionService_AddPageEmbeddedPermissionObserver_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(PermissionDescriptor, val.permission);
    encoder.encodeStruct(codec.Int32, val.lastKnownStatus);
    encoder.encodeStruct(new codec.Interface(PermissionObserverPtr), val.observer);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function PermissionService_NotifyEventListener_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  PermissionService_NotifyEventListener_Params.prototype.initDefaults_ = function() {
    this.permission = null;
    this.eventType = null;
    this.isAdded = false;
  };
  PermissionService_NotifyEventListener_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  PermissionService_NotifyEventListener_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate PermissionService_NotifyEventListener_Params.permission
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, PermissionDescriptor, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate PermissionService_NotifyEventListener_Params.eventType
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  PermissionService_NotifyEventListener_Params.encodedSize = codec.kStructHeaderSize + 24;

  PermissionService_NotifyEventListener_Params.decode = function(decoder) {
    var packed;
    var val = new PermissionService_NotifyEventListener_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.permission =
        decoder.decodeStructPointer(PermissionDescriptor);
    val.eventType =
        decoder.decodeStruct(codec.String);
    packed = decoder.readUint8();
    val.isAdded = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  PermissionService_NotifyEventListener_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(PermissionService_NotifyEventListener_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(PermissionDescriptor, val.permission);
    encoder.encodeStruct(codec.String, val.eventType);
    packed = 0;
    packed |= (val.isAdded & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };

  function PermissionDescriptorExtension(value) {
    this.initDefault_();
    this.initValue_(value);
  }


  PermissionDescriptorExtension.Tags = {
    midi: 0,
    clipboard: 1,
    cameraDevice: 2,
    topLevelStorageAccess: 3,
    fullscreen: 4,
  };

  PermissionDescriptorExtension.prototype.initDefault_ = function() {
    this.$data = null;
    this.$tag = undefined;
  }

  PermissionDescriptorExtension.prototype.initValue_ = function(value) {
    if (value == undefined) {
      return;
    }

    var keys = Object.keys(value);
    if (keys.length == 0) {
      return;
    }

    if (keys.length > 1) {
      throw new TypeError("You may set only one member on a union.");
    }

    var fields = [
        "midi",
        "clipboard",
        "cameraDevice",
        "topLevelStorageAccess",
        "fullscreen",
    ];

    if (fields.indexOf(keys[0]) < 0) {
      throw new ReferenceError(keys[0] + " is not a PermissionDescriptorExtension member.");

    }

    this[keys[0]] = value[keys[0]];
  }
  Object.defineProperty(PermissionDescriptorExtension.prototype, "midi", {
    get: function() {
      if (this.$tag != PermissionDescriptorExtension.Tags.midi) {
        throw new ReferenceError(
            "PermissionDescriptorExtension.midi is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = PermissionDescriptorExtension.Tags.midi;
      this.$data = value;
    }
  });
  Object.defineProperty(PermissionDescriptorExtension.prototype, "clipboard", {
    get: function() {
      if (this.$tag != PermissionDescriptorExtension.Tags.clipboard) {
        throw new ReferenceError(
            "PermissionDescriptorExtension.clipboard is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = PermissionDescriptorExtension.Tags.clipboard;
      this.$data = value;
    }
  });
  Object.defineProperty(PermissionDescriptorExtension.prototype, "cameraDevice", {
    get: function() {
      if (this.$tag != PermissionDescriptorExtension.Tags.cameraDevice) {
        throw new ReferenceError(
            "PermissionDescriptorExtension.cameraDevice is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = PermissionDescriptorExtension.Tags.cameraDevice;
      this.$data = value;
    }
  });
  Object.defineProperty(PermissionDescriptorExtension.prototype, "topLevelStorageAccess", {
    get: function() {
      if (this.$tag != PermissionDescriptorExtension.Tags.topLevelStorageAccess) {
        throw new ReferenceError(
            "PermissionDescriptorExtension.topLevelStorageAccess is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = PermissionDescriptorExtension.Tags.topLevelStorageAccess;
      this.$data = value;
    }
  });
  Object.defineProperty(PermissionDescriptorExtension.prototype, "fullscreen", {
    get: function() {
      if (this.$tag != PermissionDescriptorExtension.Tags.fullscreen) {
        throw new ReferenceError(
            "PermissionDescriptorExtension.fullscreen is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = PermissionDescriptorExtension.Tags.fullscreen;
      this.$data = value;
    }
  });


    PermissionDescriptorExtension.encode = function(encoder, val) {
      if (val == null) {
        encoder.writeUint64(0);
        encoder.writeUint64(0);
        return;
      }
      if (val.$tag == undefined) {
        throw new TypeError("Cannot encode unions with an unknown member set.");
      }

      encoder.writeUint32(16);
      encoder.writeUint32(val.$tag);
      switch (val.$tag) {
        case PermissionDescriptorExtension.Tags.midi:
          encoder.encodeStructPointer(MidiPermissionDescriptor, val.midi);
          break;
        case PermissionDescriptorExtension.Tags.clipboard:
          encoder.encodeStructPointer(ClipboardPermissionDescriptor, val.clipboard);
          break;
        case PermissionDescriptorExtension.Tags.cameraDevice:
          encoder.encodeStructPointer(CameraDevicePermissionDescriptor, val.cameraDevice);
          break;
        case PermissionDescriptorExtension.Tags.topLevelStorageAccess:
          encoder.encodeStructPointer(TopLevelStorageAccessPermissionDescriptor, val.topLevelStorageAccess);
          break;
        case PermissionDescriptorExtension.Tags.fullscreen:
          encoder.encodeStructPointer(FullscreenPermissionDescriptor, val.fullscreen);
          break;
      }
      encoder.align();
    };


    PermissionDescriptorExtension.decode = function(decoder) {
      var size = decoder.readUint32();
      if (size == 0) {
        decoder.readUint32();
        decoder.readUint64();
        return null;
      }

      var result = new PermissionDescriptorExtension();
      var tag = decoder.readUint32();
      switch (tag) {
        case PermissionDescriptorExtension.Tags.midi:
          result.midi = decoder.decodeStructPointer(MidiPermissionDescriptor);
          break;
        case PermissionDescriptorExtension.Tags.clipboard:
          result.clipboard = decoder.decodeStructPointer(ClipboardPermissionDescriptor);
          break;
        case PermissionDescriptorExtension.Tags.cameraDevice:
          result.cameraDevice = decoder.decodeStructPointer(CameraDevicePermissionDescriptor);
          break;
        case PermissionDescriptorExtension.Tags.topLevelStorageAccess:
          result.topLevelStorageAccess = decoder.decodeStructPointer(TopLevelStorageAccessPermissionDescriptor);
          break;
        case PermissionDescriptorExtension.Tags.fullscreen:
          result.fullscreen = decoder.decodeStructPointer(FullscreenPermissionDescriptor);
          break;
      }
      decoder.align();

      return result;
    };


    PermissionDescriptorExtension.validate = function(messageValidator, offset) {
      var size = messageValidator.decodeUnionSize(offset);
      if (size != 16) {
        return validator.validationError.INVALID_UNION_SIZE;
      }

      var tag = messageValidator.decodeUnionTag(offset);
      var data_offset = offset + 8;
      var err;
      switch (tag) {
        case PermissionDescriptorExtension.Tags.midi:
          

    // validate PermissionDescriptorExtension.midi
    err = messageValidator.validateStructPointer(data_offset, MidiPermissionDescriptor, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
        case PermissionDescriptorExtension.Tags.clipboard:
          

    // validate PermissionDescriptorExtension.clipboard
    err = messageValidator.validateStructPointer(data_offset, ClipboardPermissionDescriptor, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
        case PermissionDescriptorExtension.Tags.cameraDevice:
          

    // validate PermissionDescriptorExtension.cameraDevice
    err = messageValidator.validateStructPointer(data_offset, CameraDevicePermissionDescriptor, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
        case PermissionDescriptorExtension.Tags.topLevelStorageAccess:
          

    // validate PermissionDescriptorExtension.topLevelStorageAccess
    err = messageValidator.validateStructPointer(data_offset, TopLevelStorageAccessPermissionDescriptor, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
        case PermissionDescriptorExtension.Tags.fullscreen:
          

    // validate PermissionDescriptorExtension.fullscreen
    err = messageValidator.validateStructPointer(data_offset, FullscreenPermissionDescriptor, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
      }

      return validator.validationError.NONE;
    };

  PermissionDescriptorExtension.encodedSize = 16;
  var kPermissionObserver_OnPermissionStatusChange_Name = 0;

  function PermissionObserverPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(PermissionObserver,
                                                   handleOrPtrInfo);
  }

  function PermissionObserverAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        PermissionObserver, associatedInterfacePtrInfo);
  }

  PermissionObserverAssociatedPtr.prototype =
      Object.create(PermissionObserverPtr.prototype);
  PermissionObserverAssociatedPtr.prototype.constructor =
      PermissionObserverAssociatedPtr;

  function PermissionObserverProxy(receiver) {
    this.receiver_ = receiver;
  }
  PermissionObserverPtr.prototype.onPermissionStatusChange = function() {
    return PermissionObserverProxy.prototype.onPermissionStatusChange
        .apply(this.ptr.getProxy(), arguments);
  };

  PermissionObserverProxy.prototype.onPermissionStatusChange = function(status) {
    var params_ = new PermissionObserver_OnPermissionStatusChange_Params();
    params_.status = status;
    var builder = new codec.MessageV0Builder(
        kPermissionObserver_OnPermissionStatusChange_Name,
        codec.align(PermissionObserver_OnPermissionStatusChange_Params.encodedSize));
    builder.encodeStruct(PermissionObserver_OnPermissionStatusChange_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function PermissionObserverStub(delegate) {
    this.delegate_ = delegate;
  }
  PermissionObserverStub.prototype.onPermissionStatusChange = function(status) {
    return this.delegate_ && this.delegate_.onPermissionStatusChange && this.delegate_.onPermissionStatusChange(status);
  }

  PermissionObserverStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kPermissionObserver_OnPermissionStatusChange_Name:
      var params = reader.decodeStruct(PermissionObserver_OnPermissionStatusChange_Params);
      this.onPermissionStatusChange(params.status);
      return true;
    default:
      return false;
    }
  };

  PermissionObserverStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  function validatePermissionObserverRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kPermissionObserver_OnPermissionStatusChange_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = PermissionObserver_OnPermissionStatusChange_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validatePermissionObserverResponse(messageValidator) {
    return validator.validationError.NONE;
  }

  var PermissionObserver = {
    name: 'blink.mojom.PermissionObserver',
    kVersion: 0,
    ptrClass: PermissionObserverPtr,
    proxyClass: PermissionObserverProxy,
    stubClass: PermissionObserverStub,
    validateRequest: validatePermissionObserverRequest,
    validateResponse: null,
  };
  PermissionObserverStub.prototype.validator = validatePermissionObserverRequest;
  PermissionObserverProxy.prototype.validator = null;
  var kEmbeddedPermissionControlClient_OnEmbeddedPermissionControlRegistered_Name = 0;

  function EmbeddedPermissionControlClientPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(EmbeddedPermissionControlClient,
                                                   handleOrPtrInfo);
  }

  function EmbeddedPermissionControlClientAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        EmbeddedPermissionControlClient, associatedInterfacePtrInfo);
  }

  EmbeddedPermissionControlClientAssociatedPtr.prototype =
      Object.create(EmbeddedPermissionControlClientPtr.prototype);
  EmbeddedPermissionControlClientAssociatedPtr.prototype.constructor =
      EmbeddedPermissionControlClientAssociatedPtr;

  function EmbeddedPermissionControlClientProxy(receiver) {
    this.receiver_ = receiver;
  }
  EmbeddedPermissionControlClientPtr.prototype.onEmbeddedPermissionControlRegistered = function() {
    return EmbeddedPermissionControlClientProxy.prototype.onEmbeddedPermissionControlRegistered
        .apply(this.ptr.getProxy(), arguments);
  };

  EmbeddedPermissionControlClientProxy.prototype.onEmbeddedPermissionControlRegistered = function(allow, statuses) {
    var params_ = new EmbeddedPermissionControlClient_OnEmbeddedPermissionControlRegistered_Params();
    params_.allow = allow;
    params_.statuses = statuses;
    var builder = new codec.MessageV0Builder(
        kEmbeddedPermissionControlClient_OnEmbeddedPermissionControlRegistered_Name,
        codec.align(EmbeddedPermissionControlClient_OnEmbeddedPermissionControlRegistered_Params.encodedSize));
    builder.encodeStruct(EmbeddedPermissionControlClient_OnEmbeddedPermissionControlRegistered_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function EmbeddedPermissionControlClientStub(delegate) {
    this.delegate_ = delegate;
  }
  EmbeddedPermissionControlClientStub.prototype.onEmbeddedPermissionControlRegistered = function(allow, statuses) {
    return this.delegate_ && this.delegate_.onEmbeddedPermissionControlRegistered && this.delegate_.onEmbeddedPermissionControlRegistered(allow, statuses);
  }

  EmbeddedPermissionControlClientStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kEmbeddedPermissionControlClient_OnEmbeddedPermissionControlRegistered_Name:
      var params = reader.decodeStruct(EmbeddedPermissionControlClient_OnEmbeddedPermissionControlRegistered_Params);
      this.onEmbeddedPermissionControlRegistered(params.allow, params.statuses);
      return true;
    default:
      return false;
    }
  };

  EmbeddedPermissionControlClientStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  function validateEmbeddedPermissionControlClientRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kEmbeddedPermissionControlClient_OnEmbeddedPermissionControlRegistered_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = EmbeddedPermissionControlClient_OnEmbeddedPermissionControlRegistered_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateEmbeddedPermissionControlClientResponse(messageValidator) {
    return validator.validationError.NONE;
  }

  var EmbeddedPermissionControlClient = {
    name: 'blink.mojom.EmbeddedPermissionControlClient',
    kVersion: 0,
    ptrClass: EmbeddedPermissionControlClientPtr,
    proxyClass: EmbeddedPermissionControlClientProxy,
    stubClass: EmbeddedPermissionControlClientStub,
    validateRequest: validateEmbeddedPermissionControlClientRequest,
    validateResponse: null,
  };
  EmbeddedPermissionControlClientStub.prototype.validator = validateEmbeddedPermissionControlClientRequest;
  EmbeddedPermissionControlClientProxy.prototype.validator = null;
  var kPermissionService_HasPermission_Name = 0;
  var kPermissionService_RegisterPageEmbeddedPermissionControl_Name = 1;
  var kPermissionService_RequestPageEmbeddedPermission_Name = 2;
  var kPermissionService_RequestPermission_Name = 3;
  var kPermissionService_RequestPermissions_Name = 4;
  var kPermissionService_RevokePermission_Name = 5;
  var kPermissionService_AddPermissionObserver_Name = 6;
  var kPermissionService_AddPageEmbeddedPermissionObserver_Name = 7;
  var kPermissionService_NotifyEventListener_Name = 8;

  function PermissionServicePtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(PermissionService,
                                                   handleOrPtrInfo);
  }

  function PermissionServiceAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        PermissionService, associatedInterfacePtrInfo);
  }

  PermissionServiceAssociatedPtr.prototype =
      Object.create(PermissionServicePtr.prototype);
  PermissionServiceAssociatedPtr.prototype.constructor =
      PermissionServiceAssociatedPtr;

  function PermissionServiceProxy(receiver) {
    this.receiver_ = receiver;
  }
  PermissionServicePtr.prototype.hasPermission = function() {
    return PermissionServiceProxy.prototype.hasPermission
        .apply(this.ptr.getProxy(), arguments);
  };

  PermissionServiceProxy.prototype.hasPermission = function(permission) {
    var params_ = new PermissionService_HasPermission_Params();
    params_.permission = permission;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kPermissionService_HasPermission_Name,
          codec.align(PermissionService_HasPermission_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(PermissionService_HasPermission_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(PermissionService_HasPermission_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  PermissionServicePtr.prototype.registerPageEmbeddedPermissionControl = function() {
    return PermissionServiceProxy.prototype.registerPageEmbeddedPermissionControl
        .apply(this.ptr.getProxy(), arguments);
  };

  PermissionServiceProxy.prototype.registerPageEmbeddedPermissionControl = function(permissions, descriptor, client) {
    var params_ = new PermissionService_RegisterPageEmbeddedPermissionControl_Params();
    params_.permissions = permissions;
    params_.descriptor = descriptor;
    params_.client = client;
    var builder = new codec.MessageV0Builder(
        kPermissionService_RegisterPageEmbeddedPermissionControl_Name,
        codec.align(PermissionService_RegisterPageEmbeddedPermissionControl_Params.encodedSize));
    builder.encodeStruct(PermissionService_RegisterPageEmbeddedPermissionControl_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  PermissionServicePtr.prototype.requestPageEmbeddedPermission = function() {
    return PermissionServiceProxy.prototype.requestPageEmbeddedPermission
        .apply(this.ptr.getProxy(), arguments);
  };

  PermissionServiceProxy.prototype.requestPageEmbeddedPermission = function(permissions, descriptor) {
    var params_ = new PermissionService_RequestPageEmbeddedPermission_Params();
    params_.permissions = permissions;
    params_.descriptor = descriptor;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kPermissionService_RequestPageEmbeddedPermission_Name,
          codec.align(PermissionService_RequestPageEmbeddedPermission_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(PermissionService_RequestPageEmbeddedPermission_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(PermissionService_RequestPageEmbeddedPermission_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  PermissionServicePtr.prototype.requestPermission = function() {
    return PermissionServiceProxy.prototype.requestPermission
        .apply(this.ptr.getProxy(), arguments);
  };

  PermissionServiceProxy.prototype.requestPermission = function(permission, userGesture) {
    var params_ = new PermissionService_RequestPermission_Params();
    params_.permission = permission;
    params_.userGesture = userGesture;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kPermissionService_RequestPermission_Name,
          codec.align(PermissionService_RequestPermission_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(PermissionService_RequestPermission_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(PermissionService_RequestPermission_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  PermissionServicePtr.prototype.requestPermissions = function() {
    return PermissionServiceProxy.prototype.requestPermissions
        .apply(this.ptr.getProxy(), arguments);
  };

  PermissionServiceProxy.prototype.requestPermissions = function(permission, userGesture) {
    var params_ = new PermissionService_RequestPermissions_Params();
    params_.permission = permission;
    params_.userGesture = userGesture;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kPermissionService_RequestPermissions_Name,
          codec.align(PermissionService_RequestPermissions_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(PermissionService_RequestPermissions_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(PermissionService_RequestPermissions_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  PermissionServicePtr.prototype.revokePermission = function() {
    return PermissionServiceProxy.prototype.revokePermission
        .apply(this.ptr.getProxy(), arguments);
  };

  PermissionServiceProxy.prototype.revokePermission = function(permission) {
    var params_ = new PermissionService_RevokePermission_Params();
    params_.permission = permission;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kPermissionService_RevokePermission_Name,
          codec.align(PermissionService_RevokePermission_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(PermissionService_RevokePermission_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(PermissionService_RevokePermission_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  PermissionServicePtr.prototype.addPermissionObserver = function() {
    return PermissionServiceProxy.prototype.addPermissionObserver
        .apply(this.ptr.getProxy(), arguments);
  };

  PermissionServiceProxy.prototype.addPermissionObserver = function(permission, lastKnownStatus, observer) {
    var params_ = new PermissionService_AddPermissionObserver_Params();
    params_.permission = permission;
    params_.lastKnownStatus = lastKnownStatus;
    params_.observer = observer;
    var builder = new codec.MessageV0Builder(
        kPermissionService_AddPermissionObserver_Name,
        codec.align(PermissionService_AddPermissionObserver_Params.encodedSize));
    builder.encodeStruct(PermissionService_AddPermissionObserver_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  PermissionServicePtr.prototype.addPageEmbeddedPermissionObserver = function() {
    return PermissionServiceProxy.prototype.addPageEmbeddedPermissionObserver
        .apply(this.ptr.getProxy(), arguments);
  };

  PermissionServiceProxy.prototype.addPageEmbeddedPermissionObserver = function(permission, lastKnownStatus, observer) {
    var params_ = new PermissionService_AddPageEmbeddedPermissionObserver_Params();
    params_.permission = permission;
    params_.lastKnownStatus = lastKnownStatus;
    params_.observer = observer;
    var builder = new codec.MessageV0Builder(
        kPermissionService_AddPageEmbeddedPermissionObserver_Name,
        codec.align(PermissionService_AddPageEmbeddedPermissionObserver_Params.encodedSize));
    builder.encodeStruct(PermissionService_AddPageEmbeddedPermissionObserver_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  PermissionServicePtr.prototype.notifyEventListener = function() {
    return PermissionServiceProxy.prototype.notifyEventListener
        .apply(this.ptr.getProxy(), arguments);
  };

  PermissionServiceProxy.prototype.notifyEventListener = function(permission, eventType, isAdded) {
    var params_ = new PermissionService_NotifyEventListener_Params();
    params_.permission = permission;
    params_.eventType = eventType;
    params_.isAdded = isAdded;
    var builder = new codec.MessageV0Builder(
        kPermissionService_NotifyEventListener_Name,
        codec.align(PermissionService_NotifyEventListener_Params.encodedSize));
    builder.encodeStruct(PermissionService_NotifyEventListener_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function PermissionServiceStub(delegate) {
    this.delegate_ = delegate;
  }
  PermissionServiceStub.prototype.hasPermission = function(permission) {
    return this.delegate_ && this.delegate_.hasPermission && this.delegate_.hasPermission(permission);
  }
  PermissionServiceStub.prototype.registerPageEmbeddedPermissionControl = function(permissions, descriptor, client) {
    return this.delegate_ && this.delegate_.registerPageEmbeddedPermissionControl && this.delegate_.registerPageEmbeddedPermissionControl(permissions, descriptor, client);
  }
  PermissionServiceStub.prototype.requestPageEmbeddedPermission = function(permissions, descriptor) {
    return this.delegate_ && this.delegate_.requestPageEmbeddedPermission && this.delegate_.requestPageEmbeddedPermission(permissions, descriptor);
  }
  PermissionServiceStub.prototype.requestPermission = function(permission, userGesture) {
    return this.delegate_ && this.delegate_.requestPermission && this.delegate_.requestPermission(permission, userGesture);
  }
  PermissionServiceStub.prototype.requestPermissions = function(permission, userGesture) {
    return this.delegate_ && this.delegate_.requestPermissions && this.delegate_.requestPermissions(permission, userGesture);
  }
  PermissionServiceStub.prototype.revokePermission = function(permission) {
    return this.delegate_ && this.delegate_.revokePermission && this.delegate_.revokePermission(permission);
  }
  PermissionServiceStub.prototype.addPermissionObserver = function(permission, lastKnownStatus, observer) {
    return this.delegate_ && this.delegate_.addPermissionObserver && this.delegate_.addPermissionObserver(permission, lastKnownStatus, observer);
  }
  PermissionServiceStub.prototype.addPageEmbeddedPermissionObserver = function(permission, lastKnownStatus, observer) {
    return this.delegate_ && this.delegate_.addPageEmbeddedPermissionObserver && this.delegate_.addPageEmbeddedPermissionObserver(permission, lastKnownStatus, observer);
  }
  PermissionServiceStub.prototype.notifyEventListener = function(permission, eventType, isAdded) {
    return this.delegate_ && this.delegate_.notifyEventListener && this.delegate_.notifyEventListener(permission, eventType, isAdded);
  }

  PermissionServiceStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kPermissionService_RegisterPageEmbeddedPermissionControl_Name:
      var params = reader.decodeStruct(PermissionService_RegisterPageEmbeddedPermissionControl_Params);
      this.registerPageEmbeddedPermissionControl(params.permissions, params.descriptor, params.client);
      return true;
    case kPermissionService_AddPermissionObserver_Name:
      var params = reader.decodeStruct(PermissionService_AddPermissionObserver_Params);
      this.addPermissionObserver(params.permission, params.lastKnownStatus, params.observer);
      return true;
    case kPermissionService_AddPageEmbeddedPermissionObserver_Name:
      var params = reader.decodeStruct(PermissionService_AddPageEmbeddedPermissionObserver_Params);
      this.addPageEmbeddedPermissionObserver(params.permission, params.lastKnownStatus, params.observer);
      return true;
    case kPermissionService_NotifyEventListener_Name:
      var params = reader.decodeStruct(PermissionService_NotifyEventListener_Params);
      this.notifyEventListener(params.permission, params.eventType, params.isAdded);
      return true;
    default:
      return false;
    }
  };

  PermissionServiceStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kPermissionService_HasPermission_Name:
      var params = reader.decodeStruct(PermissionService_HasPermission_Params);
      this.hasPermission(params.permission).then(function(response) {
        var responseParams =
            new PermissionService_HasPermission_ResponseParams();
        responseParams.status = response.status;
        var builder = new codec.MessageV1Builder(
            kPermissionService_HasPermission_Name,
            codec.align(PermissionService_HasPermission_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(PermissionService_HasPermission_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kPermissionService_RequestPageEmbeddedPermission_Name:
      var params = reader.decodeStruct(PermissionService_RequestPageEmbeddedPermission_Params);
      this.requestPageEmbeddedPermission(params.permissions, params.descriptor).then(function(response) {
        var responseParams =
            new PermissionService_RequestPageEmbeddedPermission_ResponseParams();
        responseParams.status = response.status;
        var builder = new codec.MessageV1Builder(
            kPermissionService_RequestPageEmbeddedPermission_Name,
            codec.align(PermissionService_RequestPageEmbeddedPermission_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(PermissionService_RequestPageEmbeddedPermission_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kPermissionService_RequestPermission_Name:
      var params = reader.decodeStruct(PermissionService_RequestPermission_Params);
      this.requestPermission(params.permission, params.userGesture).then(function(response) {
        var responseParams =
            new PermissionService_RequestPermission_ResponseParams();
        responseParams.status = response.status;
        var builder = new codec.MessageV1Builder(
            kPermissionService_RequestPermission_Name,
            codec.align(PermissionService_RequestPermission_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(PermissionService_RequestPermission_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kPermissionService_RequestPermissions_Name:
      var params = reader.decodeStruct(PermissionService_RequestPermissions_Params);
      this.requestPermissions(params.permission, params.userGesture).then(function(response) {
        var responseParams =
            new PermissionService_RequestPermissions_ResponseParams();
        responseParams.statuses = response.statuses;
        var builder = new codec.MessageV1Builder(
            kPermissionService_RequestPermissions_Name,
            codec.align(PermissionService_RequestPermissions_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(PermissionService_RequestPermissions_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kPermissionService_RevokePermission_Name:
      var params = reader.decodeStruct(PermissionService_RevokePermission_Params);
      this.revokePermission(params.permission).then(function(response) {
        var responseParams =
            new PermissionService_RevokePermission_ResponseParams();
        responseParams.status = response.status;
        var builder = new codec.MessageV1Builder(
            kPermissionService_RevokePermission_Name,
            codec.align(PermissionService_RevokePermission_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(PermissionService_RevokePermission_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    default:
      return false;
    }
  };

  function validatePermissionServiceRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kPermissionService_HasPermission_Name:
        if (message.expectsResponse())
          paramsClass = PermissionService_HasPermission_Params;
      break;
      case kPermissionService_RegisterPageEmbeddedPermissionControl_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = PermissionService_RegisterPageEmbeddedPermissionControl_Params;
      break;
      case kPermissionService_RequestPageEmbeddedPermission_Name:
        if (message.expectsResponse())
          paramsClass = PermissionService_RequestPageEmbeddedPermission_Params;
      break;
      case kPermissionService_RequestPermission_Name:
        if (message.expectsResponse())
          paramsClass = PermissionService_RequestPermission_Params;
      break;
      case kPermissionService_RequestPermissions_Name:
        if (message.expectsResponse())
          paramsClass = PermissionService_RequestPermissions_Params;
      break;
      case kPermissionService_RevokePermission_Name:
        if (message.expectsResponse())
          paramsClass = PermissionService_RevokePermission_Params;
      break;
      case kPermissionService_AddPermissionObserver_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = PermissionService_AddPermissionObserver_Params;
      break;
      case kPermissionService_AddPageEmbeddedPermissionObserver_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = PermissionService_AddPageEmbeddedPermissionObserver_Params;
      break;
      case kPermissionService_NotifyEventListener_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = PermissionService_NotifyEventListener_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validatePermissionServiceResponse(messageValidator) {
   var message = messageValidator.message;
   var paramsClass = null;
   switch (message.getName()) {
      case kPermissionService_HasPermission_Name:
        if (message.isResponse())
          paramsClass = PermissionService_HasPermission_ResponseParams;
        break;
      case kPermissionService_RequestPageEmbeddedPermission_Name:
        if (message.isResponse())
          paramsClass = PermissionService_RequestPageEmbeddedPermission_ResponseParams;
        break;
      case kPermissionService_RequestPermission_Name:
        if (message.isResponse())
          paramsClass = PermissionService_RequestPermission_ResponseParams;
        break;
      case kPermissionService_RequestPermissions_Name:
        if (message.isResponse())
          paramsClass = PermissionService_RequestPermissions_ResponseParams;
        break;
      case kPermissionService_RevokePermission_Name:
        if (message.isResponse())
          paramsClass = PermissionService_RevokePermission_ResponseParams;
        break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  var PermissionService = {
    name: 'blink.mojom.PermissionService',
    kVersion: 0,
    ptrClass: PermissionServicePtr,
    proxyClass: PermissionServiceProxy,
    stubClass: PermissionServiceStub,
    validateRequest: validatePermissionServiceRequest,
    validateResponse: validatePermissionServiceResponse,
  };
  PermissionServiceStub.prototype.validator = validatePermissionServiceRequest;
  PermissionServiceProxy.prototype.validator = validatePermissionServiceResponse;
  exports.PermissionName = PermissionName;
  exports.EmbeddedPermissionControlResult = EmbeddedPermissionControlResult;
  exports.MidiPermissionDescriptor = MidiPermissionDescriptor;
  exports.ClipboardPermissionDescriptor = ClipboardPermissionDescriptor;
  exports.CameraDevicePermissionDescriptor = CameraDevicePermissionDescriptor;
  exports.TopLevelStorageAccessPermissionDescriptor = TopLevelStorageAccessPermissionDescriptor;
  exports.FullscreenPermissionDescriptor = FullscreenPermissionDescriptor;
  exports.PermissionDescriptor = PermissionDescriptor;
  exports.GeolocationEmbeddedPermissionRequestDescriptor = GeolocationEmbeddedPermissionRequestDescriptor;
  exports.EmbeddedPermissionRequestDescriptor = EmbeddedPermissionRequestDescriptor;
  exports.PermissionDescriptorExtension = PermissionDescriptorExtension;
  exports.PermissionObserver = PermissionObserver;
  exports.PermissionObserverPtr = PermissionObserverPtr;
  exports.PermissionObserverAssociatedPtr = PermissionObserverAssociatedPtr;
  exports.EmbeddedPermissionControlClient = EmbeddedPermissionControlClient;
  exports.EmbeddedPermissionControlClientPtr = EmbeddedPermissionControlClientPtr;
  exports.EmbeddedPermissionControlClientAssociatedPtr = EmbeddedPermissionControlClientAssociatedPtr;
  exports.PermissionService = PermissionService;
  exports.PermissionServicePtr = PermissionServicePtr;
  exports.PermissionServiceAssociatedPtr = PermissionServiceAssociatedPtr;
})();