// third_party/blink/public/mojom/performance_manager/v8_detailed_memory_reporter.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_PERFORMANCE_MANAGER_V8_DETAILED_MEMORY_REPORTER_MOJOM_DATA_VIEW_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_PERFORMANCE_MANAGER_V8_DETAILED_MEMORY_REPORTER_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/blink/public/mojom/performance_manager/v8_detailed_memory_reporter.mojom-shared-internal.h"
#include "mojo/public/mojom/base/byte_count.mojom-shared.h"
#include "third_party/blink/public/mojom/tokens/tokens.mojom-shared.h"


namespace blink::mojom {
class PerContextV8MemoryUsageDataView;

class PerContextCanvasMemoryUsageDataView;

class PerIsolateV8MemoryUsageDataView;

class PerProcessV8MemoryUsageDataView;



}  // blink::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::blink::mojom::PerContextV8MemoryUsageDataView> {
  using Data = ::blink::mojom::internal::PerContextV8MemoryUsage_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::PerContextCanvasMemoryUsageDataView> {
  using Data = ::blink::mojom::internal::PerContextCanvasMemoryUsage_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::PerIsolateV8MemoryUsageDataView> {
  using Data = ::blink::mojom::internal::PerIsolateV8MemoryUsage_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::PerProcessV8MemoryUsageDataView> {
  using Data = ::blink::mojom::internal::PerProcessV8MemoryUsage_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace blink::mojom {


enum class V8DetailedMemoryReporter_Mode : int32_t {
  
  DEFAULT = 0,
  
  EAGER = 1,
  
  LAZY = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, V8DetailedMemoryReporter_Mode value);
inline bool IsKnownEnumValue(V8DetailedMemoryReporter_Mode value) {
  return internal::V8DetailedMemoryReporter_Mode_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class V8DetailedMemoryReporterInterfaceBase {};

using V8DetailedMemoryReporterPtrDataView =
    mojo::InterfacePtrDataView<V8DetailedMemoryReporterInterfaceBase>;
using V8DetailedMemoryReporterRequestDataView =
    mojo::InterfaceRequestDataView<V8DetailedMemoryReporterInterfaceBase>;
using V8DetailedMemoryReporterAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<V8DetailedMemoryReporterInterfaceBase>;
using V8DetailedMemoryReporterAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<V8DetailedMemoryReporterInterfaceBase>;


class PerContextV8MemoryUsageDataView {
 public:
  PerContextV8MemoryUsageDataView() = default;

  PerContextV8MemoryUsageDataView(
      internal::PerContextV8MemoryUsage_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetTokenDataView(
      ::blink::mojom::ExecutionContextTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadToken(UserType* output) {
    
    auto* pointer = !data_->token.is_null() ? &data_->token : nullptr;
    return mojo::internal::Deserialize<::blink::mojom::ExecutionContextTokenDataView>(
        pointer, output, message_);
  }
  inline void GetMemoryUsedDataView(
      ::mojo_base::mojom::ByteCountDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMemoryUsed(UserType* output) {
    
    auto* pointer = data_->memory_used.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::ByteCountDataView>(
        pointer, output, message_);
  }
  inline void GetUrlDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUrl(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `url` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadUrl` instead "
    "of `ReadUrl if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->url.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::PerContextV8MemoryUsage_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PerContextCanvasMemoryUsageDataView {
 public:
  PerContextCanvasMemoryUsageDataView() = default;

  PerContextCanvasMemoryUsageDataView(
      internal::PerContextCanvasMemoryUsage_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetTokenDataView(
      ::blink::mojom::ExecutionContextTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadToken(UserType* output) {
    
    auto* pointer = !data_->token.is_null() ? &data_->token : nullptr;
    return mojo::internal::Deserialize<::blink::mojom::ExecutionContextTokenDataView>(
        pointer, output, message_);
  }
  inline void GetMemoryUsedDataView(
      ::mojo_base::mojom::ByteCountDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMemoryUsed(UserType* output) {
    
    auto* pointer = data_->memory_used.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::ByteCountDataView>(
        pointer, output, message_);
  }
 private:
  internal::PerContextCanvasMemoryUsage_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PerIsolateV8MemoryUsageDataView {
 public:
  PerIsolateV8MemoryUsageDataView() = default;

  PerIsolateV8MemoryUsageDataView(
      internal::PerIsolateV8MemoryUsage_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  uint64_t num_detached_contexts() const {
    return data_->num_detached_contexts;
  }
  inline void GetDetachedMemoryUsedDataView(
      ::mojo_base::mojom::ByteCountDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDetachedMemoryUsed(UserType* output) {
    
    auto* pointer = data_->detached_memory_used.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::ByteCountDataView>(
        pointer, output, message_);
  }
  inline void GetSharedMemoryUsedDataView(
      ::mojo_base::mojom::ByteCountDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSharedMemoryUsed(UserType* output) {
    
    auto* pointer = data_->shared_memory_used.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::ByteCountDataView>(
        pointer, output, message_);
  }
  inline void GetBlinkMemoryUsedDataView(
      ::mojo_base::mojom::ByteCountDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBlinkMemoryUsed(UserType* output) {
    
    auto* pointer = data_->blink_memory_used.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::ByteCountDataView>(
        pointer, output, message_);
  }
  inline void GetContextsDataView(
      mojo::ArrayDataView<PerContextV8MemoryUsageDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadContexts(UserType* output) {
    
    auto* pointer = data_->contexts.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::PerContextV8MemoryUsageDataView>>(
        pointer, output, message_);
  }
  inline void GetCanvasContextsDataView(
      mojo::ArrayDataView<PerContextCanvasMemoryUsageDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCanvasContexts(UserType* output) {
    
    auto* pointer = data_->canvas_contexts.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::PerContextCanvasMemoryUsageDataView>>(
        pointer, output, message_);
  }
 private:
  internal::PerIsolateV8MemoryUsage_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PerProcessV8MemoryUsageDataView {
 public:
  PerProcessV8MemoryUsageDataView() = default;

  PerProcessV8MemoryUsageDataView(
      internal::PerProcessV8MemoryUsage_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetIsolatesDataView(
      mojo::ArrayDataView<PerIsolateV8MemoryUsageDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadIsolates(UserType* output) {
    
    auto* pointer = data_->isolates.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::PerIsolateV8MemoryUsageDataView>>(
        pointer, output, message_);
  }
 private:
  internal::PerProcessV8MemoryUsage_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // blink::mojom

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_PERFORMANCE_MANAGER_V8_DETAILED_MEMORY_REPORTER_MOJOM_DATA_VIEW_H_