// third_party/blink/public/mojom/peerconnection/webrtc_ip_handling_url_entry.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_PEERCONNECTION_WEBRTC_IP_HANDLING_URL_ENTRY_MOJOM_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_PEERCONNECTION_WEBRTC_IP_HANDLING_URL_ENTRY_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/peerconnection/webrtc_ip_handling_url_entry.mojom-features.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/peerconnection/webrtc_ip_handling_url_entry.mojom-shared.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/peerconnection/webrtc_ip_handling_url_entry.mojom-forward.h"  // IWYU pragma: export
#include "components/content_settings/core/common/content_settings.mojom.h"
#include "third_party/blink/public/mojom/peerconnection/webrtc_ip_handling_policy.mojom-forward.h"
#include <string>
#include <vector>




#include "third_party/blink/public/common/peerconnection/webrtc_ip_handling_url_entry_mojom_traits.h"
#include "third_party/blink/public/common/common_export.h"




namespace blink::mojom {








class BLINK_COMMON_EXPORT WebRtcIpHandlingUrlEntry {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<WebRtcIpHandlingUrlEntry, T>::value>;
  using DataView = WebRtcIpHandlingUrlEntryDataView;
  using Data_ = internal::WebRtcIpHandlingUrlEntry_Data;

  template <typename... Args>
  static WebRtcIpHandlingUrlEntryPtr New(Args&&... args) {
    return WebRtcIpHandlingUrlEntryPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static WebRtcIpHandlingUrlEntryPtr From(const U& u) {
    return mojo::TypeConverter<WebRtcIpHandlingUrlEntryPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, WebRtcIpHandlingUrlEntry>::Convert(*this);
  }


  WebRtcIpHandlingUrlEntry();

  WebRtcIpHandlingUrlEntry(
      const ::ContentSettingsPattern& url_pattern,
      ::blink::mojom::WebRtcIpHandlingPolicy handling);


  ~WebRtcIpHandlingUrlEntry();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = WebRtcIpHandlingUrlEntryPtr>
  WebRtcIpHandlingUrlEntryPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, WebRtcIpHandlingUrlEntry::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, WebRtcIpHandlingUrlEntry::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, WebRtcIpHandlingUrlEntry::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        WebRtcIpHandlingUrlEntry::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        WebRtcIpHandlingUrlEntry::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        WebRtcIpHandlingUrlEntry::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::WebRtcIpHandlingUrlEntry_UnserializedMessageContext<
            UserType, WebRtcIpHandlingUrlEntry::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<WebRtcIpHandlingUrlEntry::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return WebRtcIpHandlingUrlEntry::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::WebRtcIpHandlingUrlEntry_UnserializedMessageContext<
            UserType, WebRtcIpHandlingUrlEntry::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<WebRtcIpHandlingUrlEntry::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::ContentSettingsPattern url_pattern;
  
  ::blink::mojom::WebRtcIpHandlingPolicy handling;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, WebRtcIpHandlingUrlEntry::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, WebRtcIpHandlingUrlEntry::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, WebRtcIpHandlingUrlEntry::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, WebRtcIpHandlingUrlEntry::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
WebRtcIpHandlingUrlEntryPtr WebRtcIpHandlingUrlEntry::Clone() const {
  return New(
      mojo::Clone(url_pattern),
      mojo::Clone(handling)
  );
}

template <typename T, WebRtcIpHandlingUrlEntry::EnableIfSame<T>*>
bool WebRtcIpHandlingUrlEntry::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->url_pattern, other_struct.url_pattern))
    return false;
  if (!mojo::Equals(this->handling, other_struct.handling))
    return false;
  return true;
}

template <typename T, WebRtcIpHandlingUrlEntry::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.url_pattern < rhs.url_pattern)
    return true;
  if (rhs.url_pattern < lhs.url_pattern)
    return false;
  if (lhs.handling < rhs.handling)
    return true;
  if (rhs.handling < lhs.handling)
    return false;
  return false;
}


}  // blink::mojom

namespace mojo {


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::WebRtcIpHandlingUrlEntry::DataView,
                                         ::blink::mojom::WebRtcIpHandlingUrlEntryPtr> {
  static bool IsNull(const ::blink::mojom::WebRtcIpHandlingUrlEntryPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::WebRtcIpHandlingUrlEntryPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::WebRtcIpHandlingUrlEntry::url_pattern)& url_pattern(
      const ::blink::mojom::WebRtcIpHandlingUrlEntryPtr& input) {
    return input->url_pattern;
  }

  static decltype(::blink::mojom::WebRtcIpHandlingUrlEntry::handling) handling(
      const ::blink::mojom::WebRtcIpHandlingUrlEntryPtr& input) {
    return input->handling;
  }

  static bool Read(::blink::mojom::WebRtcIpHandlingUrlEntry::DataView input, ::blink::mojom::WebRtcIpHandlingUrlEntryPtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_PEERCONNECTION_WEBRTC_IP_HANDLING_URL_ENTRY_MOJOM_H_