// third_party/blink/public/mojom/peerconnection/peer_connection_tracker.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../../mojo/public/js/bindings.js';

import {
  ListValue as mojoBase_mojom_ListValue,
  ListValueSpec as mojoBase_mojom_ListValueSpec
} from '../../../../../mojo/public/mojom/base/values.mojom.m.js';


/**
 * @const { !number }
 */
export const SPEED_LIMIT_MAX = 100;


/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const DeviceThermalStateSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const DeviceThermalState = {
  
  kUnknown: 0,
  kNominal: 1,
  kFair: 2,
  kSerious: 3,
  kCritical: 4,
  MIN_VALUE: 0,
  MAX_VALUE: 4,
};



/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class PeerConnectionManagerPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.PeerConnectionManager', scope);
  }
}

/** @interface */
export class PeerConnectionManagerInterface {
  
  /**
   */

  onSuspend() {}
  
  /**
   * @param { !DeviceThermalState } thermalState
   */

  onThermalStateChange(thermalState) {}
  
  /**
   * @param { !number } peerConnectionLocalId
   * @param { !number } outputPeriodMs
   */

  startEventLog(peerConnectionLocalId, outputPeriodMs) {}
  
  /**
   * @param { !number } peerConnectionLocalId
   */

  stopEventLog(peerConnectionLocalId) {}
  
  /**
   * @param { !number } peerConnectionLocalId
   */

  startDataChannelLog(peerConnectionLocalId) {}
  
  /**
   * @param { !number } peerConnectionLocalId
   */

  stopDataChannelLog(peerConnectionLocalId) {}
  
  /**
   */

  getStandardStats() {}
  
  /**
   */

  getCurrentState() {}
}

/**
 * @implements { PeerConnectionManagerInterface }
 */
export class PeerConnectionManagerRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!PeerConnectionManagerPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          PeerConnectionManagerPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!PeerConnectionManagerPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   */

  onSuspend() {
    this.proxy.sendMessage(
        0,
        PeerConnectionManager_OnSuspend_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !DeviceThermalState } thermalState
   */

  onThermalStateChange(
      thermalState) {
    this.proxy.sendMessage(
        1,
        PeerConnectionManager_OnThermalStateChange_ParamsSpec.$,
        null,
        [
          thermalState
        ],
        false);
  }

  
  /**
   * @param { !number } peerConnectionLocalId
   * @param { !number } outputPeriodMs
   */

  startEventLog(
      peerConnectionLocalId,
      outputPeriodMs) {
    this.proxy.sendMessage(
        2,
        PeerConnectionManager_StartEventLog_ParamsSpec.$,
        null,
        [
          peerConnectionLocalId,
          outputPeriodMs
        ],
        false);
  }

  
  /**
   * @param { !number } peerConnectionLocalId
   */

  stopEventLog(
      peerConnectionLocalId) {
    this.proxy.sendMessage(
        3,
        PeerConnectionManager_StopEventLog_ParamsSpec.$,
        null,
        [
          peerConnectionLocalId
        ],
        false);
  }

  
  /**
   * @param { !number } peerConnectionLocalId
   */

  startDataChannelLog(
      peerConnectionLocalId) {
    this.proxy.sendMessage(
        4,
        PeerConnectionManager_StartDataChannelLog_ParamsSpec.$,
        null,
        [
          peerConnectionLocalId
        ],
        false);
  }

  
  /**
   * @param { !number } peerConnectionLocalId
   */

  stopDataChannelLog(
      peerConnectionLocalId) {
    this.proxy.sendMessage(
        5,
        PeerConnectionManager_StopDataChannelLog_ParamsSpec.$,
        null,
        [
          peerConnectionLocalId
        ],
        false);
  }

  
  /**
   */

  getStandardStats() {
    this.proxy.sendMessage(
        6,
        PeerConnectionManager_GetStandardStats_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  getCurrentState() {
    this.proxy.sendMessage(
        7,
        PeerConnectionManager_GetCurrentState_ParamsSpec.$,
        null,
        [
        ],
        false);
  }
}

/**
 * An object which receives request messages for the PeerConnectionManager
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PeerConnectionManagerReceiver {
  /**
   * @param {!PeerConnectionManagerInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!PeerConnectionManagerRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        PeerConnectionManagerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!PeerConnectionManagerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        PeerConnectionManager_OnSuspend_ParamsSpec.$,
        null,
        impl.onSuspend.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        PeerConnectionManager_OnThermalStateChange_ParamsSpec.$,
        null,
        impl.onThermalStateChange.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        PeerConnectionManager_StartEventLog_ParamsSpec.$,
        null,
        impl.startEventLog.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        PeerConnectionManager_StopEventLog_ParamsSpec.$,
        null,
        impl.stopEventLog.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        PeerConnectionManager_StartDataChannelLog_ParamsSpec.$,
        null,
        impl.startDataChannelLog.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        PeerConnectionManager_StopDataChannelLog_ParamsSpec.$,
        null,
        impl.stopDataChannelLog.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        PeerConnectionManager_GetStandardStats_ParamsSpec.$,
        null,
        impl.getStandardStats.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        PeerConnectionManager_GetCurrentState_ParamsSpec.$,
        null,
        impl.getCurrentState.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class PeerConnectionManager {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.PeerConnectionManager";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!PeerConnectionManagerRemote}
   */
  static getRemote() {
    let remote = new PeerConnectionManagerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the PeerConnectionManager
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PeerConnectionManagerCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      PeerConnectionManagerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!PeerConnectionManagerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onSuspend =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        PeerConnectionManager_OnSuspend_ParamsSpec.$,
        null,
        this.onSuspend.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onThermalStateChange =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        PeerConnectionManager_OnThermalStateChange_ParamsSpec.$,
        null,
        this.onThermalStateChange.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.startEventLog =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        PeerConnectionManager_StartEventLog_ParamsSpec.$,
        null,
        this.startEventLog.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.stopEventLog =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        PeerConnectionManager_StopEventLog_ParamsSpec.$,
        null,
        this.stopEventLog.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.startDataChannelLog =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        PeerConnectionManager_StartDataChannelLog_ParamsSpec.$,
        null,
        this.startDataChannelLog.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.stopDataChannelLog =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        PeerConnectionManager_StopDataChannelLog_ParamsSpec.$,
        null,
        this.stopDataChannelLog.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getStandardStats =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        PeerConnectionManager_GetStandardStats_ParamsSpec.$,
        null,
        this.getStandardStats.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getCurrentState =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        PeerConnectionManager_GetCurrentState_ParamsSpec.$,
        null,
        this.getCurrentState.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class PeerConnectionTrackerHostPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.PeerConnectionTrackerHost', scope);
  }
}

/** @interface */
export class PeerConnectionTrackerHostInterface {
  
  /**
   * @param { !PeerConnectionInfo } info
   */

  addPeerConnection(info) {}
  
  /**
   * @param { !number } lid
   */

  removePeerConnection(lid) {}
  
  /**
   * @param { !number } lid
   * @param { !string } type
   * @param { !string } value
   */

  updatePeerConnection(lid, type, value) {}
  
  /**
   * @param { !number } lid
   * @param { !string } sessionId
   */

  onPeerConnectionSessionIdSet(lid, sessionId) {}
  
  /**
   * @param { !number } requestId
   * @param { !boolean } audio
   * @param { !boolean } video
   * @param { !string } audioConstraints
   * @param { !string } videoConstraints
   */

  getUserMedia(requestId, audio, video, audioConstraints, videoConstraints) {}
  
  /**
   * @param { !number } requestId
   * @param { !string } streamId
   * @param { !string } audioTrackInfo
   * @param { !string } videoTrackInfo
   */

  getUserMediaSuccess(requestId, streamId, audioTrackInfo, videoTrackInfo) {}
  
  /**
   * @param { !number } requestId
   * @param { !string } error
   * @param { !string } errorMessage
   */

  getUserMediaFailure(requestId, error, errorMessage) {}
  
  /**
   * @param { !number } requestId
   * @param { !boolean } audio
   * @param { !boolean } video
   * @param { !string } audioConstraints
   * @param { !string } videoConstraints
   */

  getDisplayMedia(requestId, audio, video, audioConstraints, videoConstraints) {}
  
  /**
   * @param { !number } requestId
   * @param { !string } streamId
   * @param { !string } audioTrackInfo
   * @param { !string } videoTrackInfo
   */

  getDisplayMediaSuccess(requestId, streamId, audioTrackInfo, videoTrackInfo) {}
  
  /**
   * @param { !number } requestId
   * @param { !string } error
   * @param { !string } errorMessage
   */

  getDisplayMediaFailure(requestId, error, errorMessage) {}
  
  /**
   * @param { !number } lid
   * @param { !Array<!number> } output
   */

  webRtcEventLogWrite(lid, output) {}
  
  /**
   * @param { !number } lid
   * @param { !Array<!number> } output
   */

  webRtcDataChannelLogWrite(lid, output) {}
  
  /**
   * @param { !number } lid
   * @param { !mojoBase_mojom_ListValue } value
   */

  addStandardStats(lid, value) {}
}

/**
 * @implements { PeerConnectionTrackerHostInterface }
 */
export class PeerConnectionTrackerHostRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!PeerConnectionTrackerHostPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          PeerConnectionTrackerHostPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!PeerConnectionTrackerHostPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !PeerConnectionInfo } info
   */

  addPeerConnection(
      info) {
    this.proxy.sendMessage(
        0,
        PeerConnectionTrackerHost_AddPeerConnection_ParamsSpec.$,
        null,
        [
          info
        ],
        false);
  }

  
  /**
   * @param { !number } lid
   */

  removePeerConnection(
      lid) {
    this.proxy.sendMessage(
        1,
        PeerConnectionTrackerHost_RemovePeerConnection_ParamsSpec.$,
        null,
        [
          lid
        ],
        false);
  }

  
  /**
   * @param { !number } lid
   * @param { !string } type
   * @param { !string } value
   */

  updatePeerConnection(
      lid,
      type,
      value) {
    this.proxy.sendMessage(
        2,
        PeerConnectionTrackerHost_UpdatePeerConnection_ParamsSpec.$,
        null,
        [
          lid,
          type,
          value
        ],
        false);
  }

  
  /**
   * @param { !number } lid
   * @param { !string } sessionId
   */

  onPeerConnectionSessionIdSet(
      lid,
      sessionId) {
    this.proxy.sendMessage(
        3,
        PeerConnectionTrackerHost_OnPeerConnectionSessionIdSet_ParamsSpec.$,
        null,
        [
          lid,
          sessionId
        ],
        false);
  }

  
  /**
   * @param { !number } requestId
   * @param { !boolean } audio
   * @param { !boolean } video
   * @param { !string } audioConstraints
   * @param { !string } videoConstraints
   */

  getUserMedia(
      requestId,
      audio,
      video,
      audioConstraints,
      videoConstraints) {
    this.proxy.sendMessage(
        4,
        PeerConnectionTrackerHost_GetUserMedia_ParamsSpec.$,
        null,
        [
          requestId,
          audio,
          video,
          audioConstraints,
          videoConstraints
        ],
        false);
  }

  
  /**
   * @param { !number } requestId
   * @param { !string } streamId
   * @param { !string } audioTrackInfo
   * @param { !string } videoTrackInfo
   */

  getUserMediaSuccess(
      requestId,
      streamId,
      audioTrackInfo,
      videoTrackInfo) {
    this.proxy.sendMessage(
        5,
        PeerConnectionTrackerHost_GetUserMediaSuccess_ParamsSpec.$,
        null,
        [
          requestId,
          streamId,
          audioTrackInfo,
          videoTrackInfo
        ],
        false);
  }

  
  /**
   * @param { !number } requestId
   * @param { !string } error
   * @param { !string } errorMessage
   */

  getUserMediaFailure(
      requestId,
      error,
      errorMessage) {
    this.proxy.sendMessage(
        6,
        PeerConnectionTrackerHost_GetUserMediaFailure_ParamsSpec.$,
        null,
        [
          requestId,
          error,
          errorMessage
        ],
        false);
  }

  
  /**
   * @param { !number } requestId
   * @param { !boolean } audio
   * @param { !boolean } video
   * @param { !string } audioConstraints
   * @param { !string } videoConstraints
   */

  getDisplayMedia(
      requestId,
      audio,
      video,
      audioConstraints,
      videoConstraints) {
    this.proxy.sendMessage(
        7,
        PeerConnectionTrackerHost_GetDisplayMedia_ParamsSpec.$,
        null,
        [
          requestId,
          audio,
          video,
          audioConstraints,
          videoConstraints
        ],
        false);
  }

  
  /**
   * @param { !number } requestId
   * @param { !string } streamId
   * @param { !string } audioTrackInfo
   * @param { !string } videoTrackInfo
   */

  getDisplayMediaSuccess(
      requestId,
      streamId,
      audioTrackInfo,
      videoTrackInfo) {
    this.proxy.sendMessage(
        8,
        PeerConnectionTrackerHost_GetDisplayMediaSuccess_ParamsSpec.$,
        null,
        [
          requestId,
          streamId,
          audioTrackInfo,
          videoTrackInfo
        ],
        false);
  }

  
  /**
   * @param { !number } requestId
   * @param { !string } error
   * @param { !string } errorMessage
   */

  getDisplayMediaFailure(
      requestId,
      error,
      errorMessage) {
    this.proxy.sendMessage(
        9,
        PeerConnectionTrackerHost_GetDisplayMediaFailure_ParamsSpec.$,
        null,
        [
          requestId,
          error,
          errorMessage
        ],
        false);
  }

  
  /**
   * @param { !number } lid
   * @param { !Array<!number> } output
   */

  webRtcEventLogWrite(
      lid,
      output) {
    this.proxy.sendMessage(
        10,
        PeerConnectionTrackerHost_WebRtcEventLogWrite_ParamsSpec.$,
        null,
        [
          lid,
          output
        ],
        false);
  }

  
  /**
   * @param { !number } lid
   * @param { !Array<!number> } output
   */

  webRtcDataChannelLogWrite(
      lid,
      output) {
    this.proxy.sendMessage(
        11,
        PeerConnectionTrackerHost_WebRtcDataChannelLogWrite_ParamsSpec.$,
        null,
        [
          lid,
          output
        ],
        false);
  }

  
  /**
   * @param { !number } lid
   * @param { !mojoBase_mojom_ListValue } value
   */

  addStandardStats(
      lid,
      value) {
    this.proxy.sendMessage(
        12,
        PeerConnectionTrackerHost_AddStandardStats_ParamsSpec.$,
        null,
        [
          lid,
          value
        ],
        false);
  }
}

/**
 * An object which receives request messages for the PeerConnectionTrackerHost
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PeerConnectionTrackerHostReceiver {
  /**
   * @param {!PeerConnectionTrackerHostInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!PeerConnectionTrackerHostRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        PeerConnectionTrackerHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!PeerConnectionTrackerHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        PeerConnectionTrackerHost_AddPeerConnection_ParamsSpec.$,
        null,
        impl.addPeerConnection.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        PeerConnectionTrackerHost_RemovePeerConnection_ParamsSpec.$,
        null,
        impl.removePeerConnection.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        PeerConnectionTrackerHost_UpdatePeerConnection_ParamsSpec.$,
        null,
        impl.updatePeerConnection.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        PeerConnectionTrackerHost_OnPeerConnectionSessionIdSet_ParamsSpec.$,
        null,
        impl.onPeerConnectionSessionIdSet.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        PeerConnectionTrackerHost_GetUserMedia_ParamsSpec.$,
        null,
        impl.getUserMedia.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        PeerConnectionTrackerHost_GetUserMediaSuccess_ParamsSpec.$,
        null,
        impl.getUserMediaSuccess.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        PeerConnectionTrackerHost_GetUserMediaFailure_ParamsSpec.$,
        null,
        impl.getUserMediaFailure.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        PeerConnectionTrackerHost_GetDisplayMedia_ParamsSpec.$,
        null,
        impl.getDisplayMedia.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        8,
        PeerConnectionTrackerHost_GetDisplayMediaSuccess_ParamsSpec.$,
        null,
        impl.getDisplayMediaSuccess.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        9,
        PeerConnectionTrackerHost_GetDisplayMediaFailure_ParamsSpec.$,
        null,
        impl.getDisplayMediaFailure.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        10,
        PeerConnectionTrackerHost_WebRtcEventLogWrite_ParamsSpec.$,
        null,
        impl.webRtcEventLogWrite.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        11,
        PeerConnectionTrackerHost_WebRtcDataChannelLogWrite_ParamsSpec.$,
        null,
        impl.webRtcDataChannelLogWrite.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        12,
        PeerConnectionTrackerHost_AddStandardStats_ParamsSpec.$,
        null,
        impl.addStandardStats.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class PeerConnectionTrackerHost {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.PeerConnectionTrackerHost";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!PeerConnectionTrackerHostRemote}
   */
  static getRemote() {
    let remote = new PeerConnectionTrackerHostRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the PeerConnectionTrackerHost
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PeerConnectionTrackerHostCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      PeerConnectionTrackerHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!PeerConnectionTrackerHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.addPeerConnection =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        PeerConnectionTrackerHost_AddPeerConnection_ParamsSpec.$,
        null,
        this.addPeerConnection.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.removePeerConnection =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        PeerConnectionTrackerHost_RemovePeerConnection_ParamsSpec.$,
        null,
        this.removePeerConnection.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.updatePeerConnection =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        PeerConnectionTrackerHost_UpdatePeerConnection_ParamsSpec.$,
        null,
        this.updatePeerConnection.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onPeerConnectionSessionIdSet =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        PeerConnectionTrackerHost_OnPeerConnectionSessionIdSet_ParamsSpec.$,
        null,
        this.onPeerConnectionSessionIdSet.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getUserMedia =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        PeerConnectionTrackerHost_GetUserMedia_ParamsSpec.$,
        null,
        this.getUserMedia.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getUserMediaSuccess =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        PeerConnectionTrackerHost_GetUserMediaSuccess_ParamsSpec.$,
        null,
        this.getUserMediaSuccess.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getUserMediaFailure =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        PeerConnectionTrackerHost_GetUserMediaFailure_ParamsSpec.$,
        null,
        this.getUserMediaFailure.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getDisplayMedia =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        PeerConnectionTrackerHost_GetDisplayMedia_ParamsSpec.$,
        null,
        this.getDisplayMedia.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getDisplayMediaSuccess =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        8,
        PeerConnectionTrackerHost_GetDisplayMediaSuccess_ParamsSpec.$,
        null,
        this.getDisplayMediaSuccess.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getDisplayMediaFailure =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        9,
        PeerConnectionTrackerHost_GetDisplayMediaFailure_ParamsSpec.$,
        null,
        this.getDisplayMediaFailure.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.webRtcEventLogWrite =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        10,
        PeerConnectionTrackerHost_WebRtcEventLogWrite_ParamsSpec.$,
        null,
        this.webRtcEventLogWrite.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.webRtcDataChannelLogWrite =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        11,
        PeerConnectionTrackerHost_WebRtcDataChannelLogWrite_ParamsSpec.$,
        null,
        this.webRtcDataChannelLogWrite.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.addStandardStats =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        12,
        PeerConnectionTrackerHost_AddStandardStats_ParamsSpec.$,
        null,
        this.addStandardStats.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PeerConnectionInfoSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PeerConnectionManager_OnSuspend_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PeerConnectionManager_OnThermalStateChange_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PeerConnectionManager_StartEventLog_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PeerConnectionManager_StopEventLog_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PeerConnectionManager_StartDataChannelLog_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PeerConnectionManager_StopDataChannelLog_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PeerConnectionManager_GetStandardStats_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PeerConnectionManager_GetCurrentState_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PeerConnectionTrackerHost_AddPeerConnection_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PeerConnectionTrackerHost_RemovePeerConnection_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PeerConnectionTrackerHost_UpdatePeerConnection_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PeerConnectionTrackerHost_OnPeerConnectionSessionIdSet_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PeerConnectionTrackerHost_GetUserMedia_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PeerConnectionTrackerHost_GetUserMediaSuccess_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PeerConnectionTrackerHost_GetUserMediaFailure_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PeerConnectionTrackerHost_GetDisplayMedia_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PeerConnectionTrackerHost_GetDisplayMediaSuccess_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PeerConnectionTrackerHost_GetDisplayMediaFailure_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PeerConnectionTrackerHost_WebRtcEventLogWrite_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PeerConnectionTrackerHost_WebRtcDataChannelLogWrite_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PeerConnectionTrackerHost_AddStandardStats_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    PeerConnectionInfoSpec.$,
    'PeerConnectionInfo',
    [
      mojo.internal.StructField(
        'lid', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'rtcConfiguration', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'url', 16,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class PeerConnectionInfo {
  constructor() {
    /** @type { !number } */
    this.lid;
    /** @type { !string } */
    this.rtcConfiguration;
    /** @type { (string|undefined) } */
    this.url;
  }
}



mojo.internal.Struct(
    PeerConnectionManager_OnSuspend_ParamsSpec.$,
    'PeerConnectionManager_OnSuspend_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class PeerConnectionManager_OnSuspend_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    PeerConnectionManager_OnThermalStateChange_ParamsSpec.$,
    'PeerConnectionManager_OnThermalStateChange_Params',
    [
      mojo.internal.StructField(
        'thermalState', 0,
        0,
        DeviceThermalStateSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class PeerConnectionManager_OnThermalStateChange_Params {
  constructor() {
    /** @type { !DeviceThermalState } */
    this.thermalState;
  }
}



mojo.internal.Struct(
    PeerConnectionManager_StartEventLog_ParamsSpec.$,
    'PeerConnectionManager_StartEventLog_Params',
    [
      mojo.internal.StructField(
        'peerConnectionLocalId', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'outputPeriodMs', 4,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class PeerConnectionManager_StartEventLog_Params {
  constructor() {
    /** @type { !number } */
    this.peerConnectionLocalId;
    /** @type { !number } */
    this.outputPeriodMs;
  }
}



mojo.internal.Struct(
    PeerConnectionManager_StopEventLog_ParamsSpec.$,
    'PeerConnectionManager_StopEventLog_Params',
    [
      mojo.internal.StructField(
        'peerConnectionLocalId', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class PeerConnectionManager_StopEventLog_Params {
  constructor() {
    /** @type { !number } */
    this.peerConnectionLocalId;
  }
}



mojo.internal.Struct(
    PeerConnectionManager_StartDataChannelLog_ParamsSpec.$,
    'PeerConnectionManager_StartDataChannelLog_Params',
    [
      mojo.internal.StructField(
        'peerConnectionLocalId', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class PeerConnectionManager_StartDataChannelLog_Params {
  constructor() {
    /** @type { !number } */
    this.peerConnectionLocalId;
  }
}



mojo.internal.Struct(
    PeerConnectionManager_StopDataChannelLog_ParamsSpec.$,
    'PeerConnectionManager_StopDataChannelLog_Params',
    [
      mojo.internal.StructField(
        'peerConnectionLocalId', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class PeerConnectionManager_StopDataChannelLog_Params {
  constructor() {
    /** @type { !number } */
    this.peerConnectionLocalId;
  }
}



mojo.internal.Struct(
    PeerConnectionManager_GetStandardStats_ParamsSpec.$,
    'PeerConnectionManager_GetStandardStats_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class PeerConnectionManager_GetStandardStats_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    PeerConnectionManager_GetCurrentState_ParamsSpec.$,
    'PeerConnectionManager_GetCurrentState_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class PeerConnectionManager_GetCurrentState_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    PeerConnectionTrackerHost_AddPeerConnection_ParamsSpec.$,
    'PeerConnectionTrackerHost_AddPeerConnection_Params',
    [
      mojo.internal.StructField(
        'info', 0,
        0,
        PeerConnectionInfoSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class PeerConnectionTrackerHost_AddPeerConnection_Params {
  constructor() {
    /** @type { !PeerConnectionInfo } */
    this.info;
  }
}



mojo.internal.Struct(
    PeerConnectionTrackerHost_RemovePeerConnection_ParamsSpec.$,
    'PeerConnectionTrackerHost_RemovePeerConnection_Params',
    [
      mojo.internal.StructField(
        'lid', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class PeerConnectionTrackerHost_RemovePeerConnection_Params {
  constructor() {
    /** @type { !number } */
    this.lid;
  }
}



mojo.internal.Struct(
    PeerConnectionTrackerHost_UpdatePeerConnection_ParamsSpec.$,
    'PeerConnectionTrackerHost_UpdatePeerConnection_Params',
    [
      mojo.internal.StructField(
        'lid', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'type', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'value', 16,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class PeerConnectionTrackerHost_UpdatePeerConnection_Params {
  constructor() {
    /** @type { !number } */
    this.lid;
    /** @type { !string } */
    this.type;
    /** @type { !string } */
    this.value;
  }
}



mojo.internal.Struct(
    PeerConnectionTrackerHost_OnPeerConnectionSessionIdSet_ParamsSpec.$,
    'PeerConnectionTrackerHost_OnPeerConnectionSessionIdSet_Params',
    [
      mojo.internal.StructField(
        'lid', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'sessionId', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class PeerConnectionTrackerHost_OnPeerConnectionSessionIdSet_Params {
  constructor() {
    /** @type { !number } */
    this.lid;
    /** @type { !string } */
    this.sessionId;
  }
}



mojo.internal.Struct(
    PeerConnectionTrackerHost_GetUserMedia_ParamsSpec.$,
    'PeerConnectionTrackerHost_GetUserMedia_Params',
    [
      mojo.internal.StructField(
        'requestId', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'audio', 4,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'video', 4,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'audioConstraints', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'videoConstraints', 16,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class PeerConnectionTrackerHost_GetUserMedia_Params {
  constructor() {
    /** @type { !number } */
    this.requestId;
    /** @type { !boolean } */
    this.audio;
    /** @type { !boolean } */
    this.video;
    /** @type { !string } */
    this.audioConstraints;
    /** @type { !string } */
    this.videoConstraints;
  }
}



mojo.internal.Struct(
    PeerConnectionTrackerHost_GetUserMediaSuccess_ParamsSpec.$,
    'PeerConnectionTrackerHost_GetUserMediaSuccess_Params',
    [
      mojo.internal.StructField(
        'requestId', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'streamId', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'audioTrackInfo', 16,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'videoTrackInfo', 24,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 40],]);



/**
 * @record
 */
export class PeerConnectionTrackerHost_GetUserMediaSuccess_Params {
  constructor() {
    /** @type { !number } */
    this.requestId;
    /** @type { !string } */
    this.streamId;
    /** @type { !string } */
    this.audioTrackInfo;
    /** @type { !string } */
    this.videoTrackInfo;
  }
}



mojo.internal.Struct(
    PeerConnectionTrackerHost_GetUserMediaFailure_ParamsSpec.$,
    'PeerConnectionTrackerHost_GetUserMediaFailure_Params',
    [
      mojo.internal.StructField(
        'requestId', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'error', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'errorMessage', 16,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class PeerConnectionTrackerHost_GetUserMediaFailure_Params {
  constructor() {
    /** @type { !number } */
    this.requestId;
    /** @type { !string } */
    this.error;
    /** @type { !string } */
    this.errorMessage;
  }
}



mojo.internal.Struct(
    PeerConnectionTrackerHost_GetDisplayMedia_ParamsSpec.$,
    'PeerConnectionTrackerHost_GetDisplayMedia_Params',
    [
      mojo.internal.StructField(
        'requestId', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'audio', 4,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'video', 4,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'audioConstraints', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'videoConstraints', 16,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class PeerConnectionTrackerHost_GetDisplayMedia_Params {
  constructor() {
    /** @type { !number } */
    this.requestId;
    /** @type { !boolean } */
    this.audio;
    /** @type { !boolean } */
    this.video;
    /** @type { !string } */
    this.audioConstraints;
    /** @type { !string } */
    this.videoConstraints;
  }
}



mojo.internal.Struct(
    PeerConnectionTrackerHost_GetDisplayMediaSuccess_ParamsSpec.$,
    'PeerConnectionTrackerHost_GetDisplayMediaSuccess_Params',
    [
      mojo.internal.StructField(
        'requestId', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'streamId', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'audioTrackInfo', 16,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'videoTrackInfo', 24,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 40],]);



/**
 * @record
 */
export class PeerConnectionTrackerHost_GetDisplayMediaSuccess_Params {
  constructor() {
    /** @type { !number } */
    this.requestId;
    /** @type { !string } */
    this.streamId;
    /** @type { !string } */
    this.audioTrackInfo;
    /** @type { !string } */
    this.videoTrackInfo;
  }
}



mojo.internal.Struct(
    PeerConnectionTrackerHost_GetDisplayMediaFailure_ParamsSpec.$,
    'PeerConnectionTrackerHost_GetDisplayMediaFailure_Params',
    [
      mojo.internal.StructField(
        'requestId', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'error', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'errorMessage', 16,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class PeerConnectionTrackerHost_GetDisplayMediaFailure_Params {
  constructor() {
    /** @type { !number } */
    this.requestId;
    /** @type { !string } */
    this.error;
    /** @type { !string } */
    this.errorMessage;
  }
}



mojo.internal.Struct(
    PeerConnectionTrackerHost_WebRtcEventLogWrite_ParamsSpec.$,
    'PeerConnectionTrackerHost_WebRtcEventLogWrite_Params',
    [
      mojo.internal.StructField(
        'lid', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'output', 8,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class PeerConnectionTrackerHost_WebRtcEventLogWrite_Params {
  constructor() {
    /** @type { !number } */
    this.lid;
    /** @type { !Array<!number> } */
    this.output;
  }
}



mojo.internal.Struct(
    PeerConnectionTrackerHost_WebRtcDataChannelLogWrite_ParamsSpec.$,
    'PeerConnectionTrackerHost_WebRtcDataChannelLogWrite_Params',
    [
      mojo.internal.StructField(
        'lid', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'output', 8,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class PeerConnectionTrackerHost_WebRtcDataChannelLogWrite_Params {
  constructor() {
    /** @type { !number } */
    this.lid;
    /** @type { !Array<!number> } */
    this.output;
  }
}



mojo.internal.Struct(
    PeerConnectionTrackerHost_AddStandardStats_ParamsSpec.$,
    'PeerConnectionTrackerHost_AddStandardStats_Params',
    [
      mojo.internal.StructField(
        'lid', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'value', 8,
        0,
        mojoBase_mojom_ListValueSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class PeerConnectionTrackerHost_AddStandardStats_Params {
  constructor() {
    /** @type { !number } */
    this.lid;
    /** @type { !mojoBase_mojom_ListValue } */
    this.value;
  }
}

