// third_party/blink/public/mojom/payments/secure_payment_confirmation_service.mojom-lite-for-compile.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';

goog.require('mojo.internal');
goog.require('mojo.internal.interfaceSupport');

goog.require('blink.mojom.AuthenticatorStatus');
goog.require('blink.mojom.MakeCredentialAuthenticatorResponse');
goog.require('blink.mojom.PublicKeyCredentialCreationOptions');
goog.require('blink.mojom.WebAuthnDOMExceptionDetails');




goog.provide('payments.mojom.PaymentCredentialStorageStatus');
goog.provide('payments.mojom.PaymentCredentialStorageStatusSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
payments.mojom.PaymentCredentialStorageStatusSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
payments.mojom.PaymentCredentialStorageStatus = {
  
  SUCCESS: 0,
  FAILED_TO_STORE_CREDENTIAL: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};

goog.provide('payments.mojom.SecurePaymentConfirmationAvailabilityEnum');
goog.provide('payments.mojom.SecurePaymentConfirmationAvailabilityEnumSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
payments.mojom.SecurePaymentConfirmationAvailabilityEnumSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
payments.mojom.SecurePaymentConfirmationAvailabilityEnum = {
  
  kAvailable: 0,
  kUnavailableUnknownReason: 1,
  kUnavailableFeatureNotEnabled: 2,
  kUnavailableNoPermissionPolicy: 3,
  kUnavailableNoUserVerifyingPlatformAuthenticator: 4,
  MIN_VALUE: 0,
  MAX_VALUE: 4,
};



goog.provide('payments.mojom.SecurePaymentConfirmationService');
goog.provide('payments.mojom.SecurePaymentConfirmationServiceReceiver');
goog.provide('payments.mojom.SecurePaymentConfirmationServiceCallbackRouter');
goog.provide('payments.mojom.SecurePaymentConfirmationServiceInterface');
goog.provide('payments.mojom.SecurePaymentConfirmationServiceRemote');
goog.provide('payments.mojom.SecurePaymentConfirmationServicePendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
payments.mojom.SecurePaymentConfirmationServicePendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        payments.mojom.SecurePaymentConfirmationService.$interfaceName,
        scope);
  }
};

/** @interface */
payments.mojom.SecurePaymentConfirmationServiceInterface = class {
  
  /**
   * @return {!Promise<{
        availability: !payments.mojom.SecurePaymentConfirmationAvailabilityEnum,
   *  }>}
   */

  securePaymentConfirmationAvailability() {}
  
  /**
   * @param { !Array<!number> } credentialId
   * @param { !string } rpId
   * @param { !Array<!number> } userId
   * @return {!Promise<{
        status: !payments.mojom.PaymentCredentialStorageStatus,
   *  }>}
   */

  storePaymentCredential(credentialId, rpId, userId) {}
  
  /**
   * @param { !blink.mojom.PublicKeyCredentialCreationOptions } options
   * @return {!Promise<{
        status: !blink.mojom.AuthenticatorStatus,
        credential: ?blink.mojom.MakeCredentialAuthenticatorResponse,
        domExceptionDetails: ?blink.mojom.WebAuthnDOMExceptionDetails,
   *  }>}
   */

  makePaymentCredential(options) {}
};

/**
 * @export
 * @implements { payments.mojom.SecurePaymentConfirmationServiceInterface }
 */
payments.mojom.SecurePaymentConfirmationServiceRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!payments.mojom.SecurePaymentConfirmationServicePendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          payments.mojom.SecurePaymentConfirmationServicePendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!payments.mojom.SecurePaymentConfirmationServicePendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @return {!Promise<{
        availability: !payments.mojom.SecurePaymentConfirmationAvailabilityEnum,
   *  }>}
   */

  securePaymentConfirmationAvailability() {
    return this.proxy.sendMessage(
        0,
        payments.mojom.SecurePaymentConfirmationService_SecurePaymentConfirmationAvailability_ParamsSpec.$,
        payments.mojom.SecurePaymentConfirmationService_SecurePaymentConfirmationAvailability_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !Array<!number> } credentialId
   * @param { !string } rpId
   * @param { !Array<!number> } userId
   * @return {!Promise<{
        status: !payments.mojom.PaymentCredentialStorageStatus,
   *  }>}
   */

  storePaymentCredential(
      credentialId,
      rpId,
      userId) {
    return this.proxy.sendMessage(
        1,
        payments.mojom.SecurePaymentConfirmationService_StorePaymentCredential_ParamsSpec.$,
        payments.mojom.SecurePaymentConfirmationService_StorePaymentCredential_ResponseParamsSpec.$,
        [
          credentialId,
          rpId,
          userId
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.PublicKeyCredentialCreationOptions } options
   * @return {!Promise<{
        status: !blink.mojom.AuthenticatorStatus,
        credential: ?blink.mojom.MakeCredentialAuthenticatorResponse,
        domExceptionDetails: ?blink.mojom.WebAuthnDOMExceptionDetails,
   *  }>}
   */

  makePaymentCredential(
      options) {
    return this.proxy.sendMessage(
        2,
        payments.mojom.SecurePaymentConfirmationService_MakePaymentCredential_ParamsSpec.$,
        payments.mojom.SecurePaymentConfirmationService_MakePaymentCredential_ResponseParamsSpec.$,
        [
          options
        ],
        false);
  }
};

/**
 * An object which receives request messages for the SecurePaymentConfirmationService
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
payments.mojom.SecurePaymentConfirmationServiceReceiver = class {
  /**
   * @param {!payments.mojom.SecurePaymentConfirmationServiceInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!payments.mojom.SecurePaymentConfirmationServiceRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        payments.mojom.SecurePaymentConfirmationServiceRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!payments.mojom.SecurePaymentConfirmationServiceRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        payments.mojom.SecurePaymentConfirmationService_SecurePaymentConfirmationAvailability_ParamsSpec.$,
        payments.mojom.SecurePaymentConfirmationService_SecurePaymentConfirmationAvailability_ResponseParamsSpec.$,
        impl.securePaymentConfirmationAvailability.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        payments.mojom.SecurePaymentConfirmationService_StorePaymentCredential_ParamsSpec.$,
        payments.mojom.SecurePaymentConfirmationService_StorePaymentCredential_ResponseParamsSpec.$,
        impl.storePaymentCredential.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        payments.mojom.SecurePaymentConfirmationService_MakePaymentCredential_ParamsSpec.$,
        payments.mojom.SecurePaymentConfirmationService_MakePaymentCredential_ResponseParamsSpec.$,
        impl.makePaymentCredential.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
payments.mojom.SecurePaymentConfirmationService = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "payments.mojom.SecurePaymentConfirmationService";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!payments.mojom.SecurePaymentConfirmationServiceRemote}
   * @export
   */
  static getRemote() {
    let remote = new payments.mojom.SecurePaymentConfirmationServiceRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the SecurePaymentConfirmationService
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
payments.mojom.SecurePaymentConfirmationServiceCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      payments.mojom.SecurePaymentConfirmationServiceRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!payments.mojom.SecurePaymentConfirmationServiceRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.securePaymentConfirmationAvailability =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        payments.mojom.SecurePaymentConfirmationService_SecurePaymentConfirmationAvailability_ParamsSpec.$,
        payments.mojom.SecurePaymentConfirmationService_SecurePaymentConfirmationAvailability_ResponseParamsSpec.$,
        this.securePaymentConfirmationAvailability.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.storePaymentCredential =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        payments.mojom.SecurePaymentConfirmationService_StorePaymentCredential_ParamsSpec.$,
        payments.mojom.SecurePaymentConfirmationService_StorePaymentCredential_ResponseParamsSpec.$,
        this.storePaymentCredential.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.makePaymentCredential =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        payments.mojom.SecurePaymentConfirmationService_MakePaymentCredential_ParamsSpec.$,
        payments.mojom.SecurePaymentConfirmationService_MakePaymentCredential_ResponseParamsSpec.$,
        this.makePaymentCredential.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('payments.mojom.SecurePaymentConfirmationService_SecurePaymentConfirmationAvailability_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
payments.mojom.SecurePaymentConfirmationService_SecurePaymentConfirmationAvailability_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('payments.mojom.SecurePaymentConfirmationService_SecurePaymentConfirmationAvailability_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
payments.mojom.SecurePaymentConfirmationService_SecurePaymentConfirmationAvailability_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('payments.mojom.SecurePaymentConfirmationService_StorePaymentCredential_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
payments.mojom.SecurePaymentConfirmationService_StorePaymentCredential_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('payments.mojom.SecurePaymentConfirmationService_StorePaymentCredential_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
payments.mojom.SecurePaymentConfirmationService_StorePaymentCredential_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('payments.mojom.SecurePaymentConfirmationService_MakePaymentCredential_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
payments.mojom.SecurePaymentConfirmationService_MakePaymentCredential_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('payments.mojom.SecurePaymentConfirmationService_MakePaymentCredential_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
payments.mojom.SecurePaymentConfirmationService_MakePaymentCredential_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    payments.mojom.SecurePaymentConfirmationService_SecurePaymentConfirmationAvailability_ParamsSpec.$,
    'SecurePaymentConfirmationService_SecurePaymentConfirmationAvailability_Params',
    [
    ],
    [[0, 8],]);



goog.provide('payments.mojom.SecurePaymentConfirmationService_SecurePaymentConfirmationAvailability_Params');

/** @record */
payments.mojom.SecurePaymentConfirmationService_SecurePaymentConfirmationAvailability_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    payments.mojom.SecurePaymentConfirmationService_SecurePaymentConfirmationAvailability_ResponseParamsSpec.$,
    'SecurePaymentConfirmationService_SecurePaymentConfirmationAvailability_ResponseParams',
    [
      mojo.internal.StructField(
        'availability', 0,
        0,
        payments.mojom.SecurePaymentConfirmationAvailabilityEnumSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('payments.mojom.SecurePaymentConfirmationService_SecurePaymentConfirmationAvailability_ResponseParams');

/** @record */
payments.mojom.SecurePaymentConfirmationService_SecurePaymentConfirmationAvailability_ResponseParams = class {
  constructor() {
    /** @export { !payments.mojom.SecurePaymentConfirmationAvailabilityEnum } */
    this.availability;
  }
};



mojo.internal.Struct(
    payments.mojom.SecurePaymentConfirmationService_StorePaymentCredential_ParamsSpec.$,
    'SecurePaymentConfirmationService_StorePaymentCredential_Params',
    [
      mojo.internal.StructField(
        'credentialId', 0,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'rpId', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'userId', 16,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);



goog.provide('payments.mojom.SecurePaymentConfirmationService_StorePaymentCredential_Params');

/** @record */
payments.mojom.SecurePaymentConfirmationService_StorePaymentCredential_Params = class {
  constructor() {
    /** @export { !Array<!number> } */
    this.credentialId;
    /** @export { !string } */
    this.rpId;
    /** @export { !Array<!number> } */
    this.userId;
  }
};



mojo.internal.Struct(
    payments.mojom.SecurePaymentConfirmationService_StorePaymentCredential_ResponseParamsSpec.$,
    'SecurePaymentConfirmationService_StorePaymentCredential_ResponseParams',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        payments.mojom.PaymentCredentialStorageStatusSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('payments.mojom.SecurePaymentConfirmationService_StorePaymentCredential_ResponseParams');

/** @record */
payments.mojom.SecurePaymentConfirmationService_StorePaymentCredential_ResponseParams = class {
  constructor() {
    /** @export { !payments.mojom.PaymentCredentialStorageStatus } */
    this.status;
  }
};



mojo.internal.Struct(
    payments.mojom.SecurePaymentConfirmationService_MakePaymentCredential_ParamsSpec.$,
    'SecurePaymentConfirmationService_MakePaymentCredential_Params',
    [
      mojo.internal.StructField(
        'options', 0,
        0,
        blink.mojom.PublicKeyCredentialCreationOptionsSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('payments.mojom.SecurePaymentConfirmationService_MakePaymentCredential_Params');

/** @record */
payments.mojom.SecurePaymentConfirmationService_MakePaymentCredential_Params = class {
  constructor() {
    /** @export { !blink.mojom.PublicKeyCredentialCreationOptions } */
    this.options;
  }
};



mojo.internal.Struct(
    payments.mojom.SecurePaymentConfirmationService_MakePaymentCredential_ResponseParamsSpec.$,
    'SecurePaymentConfirmationService_MakePaymentCredential_ResponseParams',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        blink.mojom.AuthenticatorStatusSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'credential', 8,
        0,
        blink.mojom.MakeCredentialAuthenticatorResponseSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'domExceptionDetails', 16,
        0,
        blink.mojom.WebAuthnDOMExceptionDetailsSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);



goog.provide('payments.mojom.SecurePaymentConfirmationService_MakePaymentCredential_ResponseParams');

/** @record */
payments.mojom.SecurePaymentConfirmationService_MakePaymentCredential_ResponseParams = class {
  constructor() {
    /** @export { !blink.mojom.AuthenticatorStatus } */
    this.status;
    /** @export { (blink.mojom.MakeCredentialAuthenticatorResponse|undefined) } */
    this.credential;
    /** @export { (blink.mojom.WebAuthnDOMExceptionDetails|undefined) } */
    this.domExceptionDetails;
  }
};

