// third_party/blink/public/mojom/payments/payment_request.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../../mojo/public/js/bindings.js';

import {
  AddressErrors as payments_mojom_AddressErrors,
  AddressErrorsSpec as payments_mojom_AddressErrorsSpec,
  PaymentAddress as payments_mojom_PaymentAddress,
  PaymentAddressSpec as payments_mojom_PaymentAddressSpec,
  PaymentCurrencyAmount as payments_mojom_PaymentCurrencyAmount,
  PaymentCurrencyAmountSpec as payments_mojom_PaymentCurrencyAmountSpec,
  PaymentValidationErrors as payments_mojom_PaymentValidationErrors,
  PaymentValidationErrorsSpec as payments_mojom_PaymentValidationErrorsSpec
} from '../../../../../components/payments/mojom/payment_request_data.mojom.m.js';

import {
  TimeDelta as mojoBase_mojom_TimeDelta,
  TimeDeltaSpec as mojoBase_mojom_TimeDeltaSpec
} from '../../../../../mojo/public/mojom/base/time.mojom.m.js';

import {
  Origin as url_mojom_Origin,
  OriginSpec as url_mojom_OriginSpec
} from '../../../../../url/mojom/origin.mojom.m.js';

import {
  Url as url_mojom_Url,
  UrlSpec as url_mojom_UrlSpec
} from '../../../../../url/mojom/url.mojom.m.js';

import {
  AuthenticationExtensionsClientInputs as blink_mojom_AuthenticationExtensionsClientInputs,
  AuthenticationExtensionsClientInputsSpec as blink_mojom_AuthenticationExtensionsClientInputsSpec,
  GetAssertionAuthenticatorResponse as blink_mojom_GetAssertionAuthenticatorResponse,
  GetAssertionAuthenticatorResponseSpec as blink_mojom_GetAssertionAuthenticatorResponseSpec,
  PaymentCredentialInstrument as blink_mojom_PaymentCredentialInstrument,
  PaymentCredentialInstrumentSpec as blink_mojom_PaymentCredentialInstrumentSpec,
  PublicKeyCredentialParameters as blink_mojom_PublicKeyCredentialParameters,
  PublicKeyCredentialParametersSpec as blink_mojom_PublicKeyCredentialParametersSpec
} from '../webauthn/authenticator.mojom.m.js';


/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const PaymentErrorReasonSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const PaymentErrorReason = {
  
  UNKNOWN: 0,
  USER_CANCEL: 1,
  NOT_SUPPORTED: 2,
  NOT_SUPPORTED_FOR_INVALID_ORIGIN_OR_SSL: 3,
  ALREADY_SHOWING: 4,
  INVALID_DATA_FROM_RENDERER: 5,
  NOT_ALLOWED_ERROR: 6,
  USER_OPT_OUT: 7,
  USER_ACTIVATION_REQUIRED: 8,
  MIN_VALUE: 0,
  MAX_VALUE: 8,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const CanMakePaymentQueryResultSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const CanMakePaymentQueryResult = {
  
  CAN_MAKE_PAYMENT: 0,
  CANNOT_MAKE_PAYMENT: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const HasEnrolledInstrumentQueryResultSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const HasEnrolledInstrumentQueryResult = {
  
  HAS_ENROLLED_INSTRUMENT: 0,
  HAS_NO_ENROLLED_INSTRUMENT: 1,
  QUERY_QUOTA_EXCEEDED: 2,
  WARNING_HAS_ENROLLED_INSTRUMENT: 3,
  WARNING_HAS_NO_ENROLLED_INSTRUMENT: 4,
  MIN_VALUE: 0,
  MAX_VALUE: 4,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const AndroidPayEnvironmentSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const AndroidPayEnvironment = {
  
  PRODUCTION: 0,
  TEST: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const BasicCardNetworkSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const BasicCardNetwork = {
  
  AMEX: 0,
  DINERS: 1,
  DISCOVER: 2,
  JCB: 3,
  MASTERCARD: 4,
  MIR: 5,
  UNIONPAY: 6,
  VISA: 7,
  MIN_VALUE: 0,
  MAX_VALUE: 7,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const PaymentShippingTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const PaymentShippingType = {
  
  SHIPPING: 0,
  DELIVERY: 1,
  PICKUP: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const PaymentCompleteSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const PaymentComplete = {
  
  FAIL: 0,
  SUCCESS: 1,
  UNKNOWN: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};



/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class PaymentRequestClientPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'payments.mojom.PaymentRequestClient', scope);
  }
}

/** @interface */
export class PaymentRequestClientInterface {
  
  /**
   * @param { !string } methodName
   * @param { !string } stringifiedDetails
   */

  onPaymentMethodChange(methodName, stringifiedDetails) {}
  
  /**
   * @param { !payments_mojom_PaymentAddress } address
   */

  onShippingAddressChange(address) {}
  
  /**
   * @param { !string } shippingOptionId
   */

  onShippingOptionChange(shippingOptionId) {}
  
  /**
   * @param { !PayerDetail } detail
   */

  onPayerDetailChange(detail) {}
  
  /**
   * @param { !PaymentResponse } response
   */

  onPaymentResponse(response) {}
  
  /**
   * @param { !PaymentErrorReason } error
   * @param { !string } errorMessage
   */

  onError(error, errorMessage) {}
  
  /**
   */

  onComplete() {}
  
  /**
   * @param { !boolean } abortedSuccessfully
   */

  onAbort(abortedSuccessfully) {}
  
  /**
   * @param { !CanMakePaymentQueryResult } result
   */

  onCanMakePayment(result) {}
  
  /**
   * @param { !HasEnrolledInstrumentQueryResult } result
   */

  onHasEnrolledInstrument(result) {}
  
  /**
   */

  warnNoFavicon() {}
  
  /**
   * @param { !url_mojom_Url } url
   * @param { !url_mojom_Url } urlBeforeRedirects
   * @param { !boolean } didFollowRedirect
   * @return {!Promise<{
        allow: !boolean,
   *  }>}
   */

  allowConnectToSource(url, urlBeforeRedirects, didFollowRedirect) {}
}

/**
 * @implements { PaymentRequestClientInterface }
 */
export class PaymentRequestClientRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!PaymentRequestClientPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          PaymentRequestClientPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!PaymentRequestClientPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !string } methodName
   * @param { !string } stringifiedDetails
   */

  onPaymentMethodChange(
      methodName,
      stringifiedDetails) {
    this.proxy.sendMessage(
        0,
        PaymentRequestClient_OnPaymentMethodChange_ParamsSpec.$,
        null,
        [
          methodName,
          stringifiedDetails
        ],
        false);
  }

  
  /**
   * @param { !payments_mojom_PaymentAddress } address
   */

  onShippingAddressChange(
      address) {
    this.proxy.sendMessage(
        1,
        PaymentRequestClient_OnShippingAddressChange_ParamsSpec.$,
        null,
        [
          address
        ],
        false);
  }

  
  /**
   * @param { !string } shippingOptionId
   */

  onShippingOptionChange(
      shippingOptionId) {
    this.proxy.sendMessage(
        2,
        PaymentRequestClient_OnShippingOptionChange_ParamsSpec.$,
        null,
        [
          shippingOptionId
        ],
        false);
  }

  
  /**
   * @param { !PayerDetail } detail
   */

  onPayerDetailChange(
      detail) {
    this.proxy.sendMessage(
        3,
        PaymentRequestClient_OnPayerDetailChange_ParamsSpec.$,
        null,
        [
          detail
        ],
        false);
  }

  
  /**
   * @param { !PaymentResponse } response
   */

  onPaymentResponse(
      response) {
    this.proxy.sendMessage(
        4,
        PaymentRequestClient_OnPaymentResponse_ParamsSpec.$,
        null,
        [
          response
        ],
        false);
  }

  
  /**
   * @param { !PaymentErrorReason } error
   * @param { !string } errorMessage
   */

  onError(
      error,
      errorMessage) {
    this.proxy.sendMessage(
        5,
        PaymentRequestClient_OnError_ParamsSpec.$,
        null,
        [
          error,
          errorMessage
        ],
        false);
  }

  
  /**
   */

  onComplete() {
    this.proxy.sendMessage(
        6,
        PaymentRequestClient_OnComplete_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !boolean } abortedSuccessfully
   */

  onAbort(
      abortedSuccessfully) {
    this.proxy.sendMessage(
        7,
        PaymentRequestClient_OnAbort_ParamsSpec.$,
        null,
        [
          abortedSuccessfully
        ],
        false);
  }

  
  /**
   * @param { !CanMakePaymentQueryResult } result
   */

  onCanMakePayment(
      result) {
    this.proxy.sendMessage(
        8,
        PaymentRequestClient_OnCanMakePayment_ParamsSpec.$,
        null,
        [
          result
        ],
        false);
  }

  
  /**
   * @param { !HasEnrolledInstrumentQueryResult } result
   */

  onHasEnrolledInstrument(
      result) {
    this.proxy.sendMessage(
        9,
        PaymentRequestClient_OnHasEnrolledInstrument_ParamsSpec.$,
        null,
        [
          result
        ],
        false);
  }

  
  /**
   */

  warnNoFavicon() {
    this.proxy.sendMessage(
        10,
        PaymentRequestClient_WarnNoFavicon_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !url_mojom_Url } url
   * @param { !url_mojom_Url } urlBeforeRedirects
   * @param { !boolean } didFollowRedirect
   * @return {!Promise<{
        allow: !boolean,
   *  }>}
   */

  allowConnectToSource(
      url,
      urlBeforeRedirects,
      didFollowRedirect) {
    return this.proxy.sendMessage(
        11,
        PaymentRequestClient_AllowConnectToSource_ParamsSpec.$,
        PaymentRequestClient_AllowConnectToSource_ResponseParamsSpec.$,
        [
          url,
          urlBeforeRedirects,
          didFollowRedirect
        ],
        false);
  }
}

/**
 * An object which receives request messages for the PaymentRequestClient
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PaymentRequestClientReceiver {
  /**
   * @param {!PaymentRequestClientInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!PaymentRequestClientRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        PaymentRequestClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!PaymentRequestClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        PaymentRequestClient_OnPaymentMethodChange_ParamsSpec.$,
        null,
        impl.onPaymentMethodChange.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        PaymentRequestClient_OnShippingAddressChange_ParamsSpec.$,
        null,
        impl.onShippingAddressChange.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        PaymentRequestClient_OnShippingOptionChange_ParamsSpec.$,
        null,
        impl.onShippingOptionChange.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        PaymentRequestClient_OnPayerDetailChange_ParamsSpec.$,
        null,
        impl.onPayerDetailChange.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        PaymentRequestClient_OnPaymentResponse_ParamsSpec.$,
        null,
        impl.onPaymentResponse.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        PaymentRequestClient_OnError_ParamsSpec.$,
        null,
        impl.onError.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        PaymentRequestClient_OnComplete_ParamsSpec.$,
        null,
        impl.onComplete.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        PaymentRequestClient_OnAbort_ParamsSpec.$,
        null,
        impl.onAbort.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        8,
        PaymentRequestClient_OnCanMakePayment_ParamsSpec.$,
        null,
        impl.onCanMakePayment.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        9,
        PaymentRequestClient_OnHasEnrolledInstrument_ParamsSpec.$,
        null,
        impl.onHasEnrolledInstrument.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        10,
        PaymentRequestClient_WarnNoFavicon_ParamsSpec.$,
        null,
        impl.warnNoFavicon.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        11,
        PaymentRequestClient_AllowConnectToSource_ParamsSpec.$,
        PaymentRequestClient_AllowConnectToSource_ResponseParamsSpec.$,
        impl.allowConnectToSource.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class PaymentRequestClient {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "payments.mojom.PaymentRequestClient";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!PaymentRequestClientRemote}
   */
  static getRemote() {
    let remote = new PaymentRequestClientRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the PaymentRequestClient
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PaymentRequestClientCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      PaymentRequestClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!PaymentRequestClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onPaymentMethodChange =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        PaymentRequestClient_OnPaymentMethodChange_ParamsSpec.$,
        null,
        this.onPaymentMethodChange.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onShippingAddressChange =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        PaymentRequestClient_OnShippingAddressChange_ParamsSpec.$,
        null,
        this.onShippingAddressChange.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onShippingOptionChange =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        PaymentRequestClient_OnShippingOptionChange_ParamsSpec.$,
        null,
        this.onShippingOptionChange.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onPayerDetailChange =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        PaymentRequestClient_OnPayerDetailChange_ParamsSpec.$,
        null,
        this.onPayerDetailChange.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onPaymentResponse =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        PaymentRequestClient_OnPaymentResponse_ParamsSpec.$,
        null,
        this.onPaymentResponse.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onError =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        PaymentRequestClient_OnError_ParamsSpec.$,
        null,
        this.onError.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onComplete =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        PaymentRequestClient_OnComplete_ParamsSpec.$,
        null,
        this.onComplete.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onAbort =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        PaymentRequestClient_OnAbort_ParamsSpec.$,
        null,
        this.onAbort.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onCanMakePayment =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        8,
        PaymentRequestClient_OnCanMakePayment_ParamsSpec.$,
        null,
        this.onCanMakePayment.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onHasEnrolledInstrument =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        9,
        PaymentRequestClient_OnHasEnrolledInstrument_ParamsSpec.$,
        null,
        this.onHasEnrolledInstrument.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.warnNoFavicon =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        10,
        PaymentRequestClient_WarnNoFavicon_ParamsSpec.$,
        null,
        this.warnNoFavicon.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.allowConnectToSource =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        11,
        PaymentRequestClient_AllowConnectToSource_ParamsSpec.$,
        PaymentRequestClient_AllowConnectToSource_ResponseParamsSpec.$,
        this.allowConnectToSource.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class PaymentRequestPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'payments.mojom.PaymentRequest', scope);
  }
}

/** @interface */
export class PaymentRequestInterface {
  
  /**
   * @param { !PaymentRequestClientRemote } client
   * @param { !Array<!PaymentMethodData> } methodData
   * @param { !PaymentDetails } details
   * @param { !PaymentOptions } options
   */

  init(client, methodData, details, options) {}
  
  /**
   * @param { !boolean } waitForUpdatedDetails
   * @param { !boolean } hadUserActivation
   */

  show(waitForUpdatedDetails, hadUserActivation) {}
  
  /**
   * @param { !PaymentDetails } details
   */

  updateWith(details) {}
  
  /**
   */

  onPaymentDetailsNotUpdated() {}
  
  /**
   */

  abort() {}
  
  /**
   * @param { !PaymentComplete } result
   */

  complete(result) {}
  
  /**
   * @param { !payments_mojom_PaymentValidationErrors } errors
   */

  retry(errors) {}
  
  /**
   */

  canMakePayment() {}
  
  /**
   */

  hasEnrolledInstrument() {}
}

/**
 * @implements { PaymentRequestInterface }
 */
export class PaymentRequestRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!PaymentRequestPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          PaymentRequestPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!PaymentRequestPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !PaymentRequestClientRemote } client
   * @param { !Array<!PaymentMethodData> } methodData
   * @param { !PaymentDetails } details
   * @param { !PaymentOptions } options
   */

  init(
      client,
      methodData,
      details,
      options) {
    this.proxy.sendMessage(
        0,
        PaymentRequest_Init_ParamsSpec.$,
        null,
        [
          client,
          methodData,
          details,
          options
        ],
        false);
  }

  
  /**
   * @param { !boolean } waitForUpdatedDetails
   * @param { !boolean } hadUserActivation
   */

  show(
      waitForUpdatedDetails,
      hadUserActivation) {
    this.proxy.sendMessage(
        1,
        PaymentRequest_Show_ParamsSpec.$,
        null,
        [
          waitForUpdatedDetails,
          hadUserActivation
        ],
        false);
  }

  
  /**
   * @param { !PaymentDetails } details
   */

  updateWith(
      details) {
    this.proxy.sendMessage(
        2,
        PaymentRequest_UpdateWith_ParamsSpec.$,
        null,
        [
          details
        ],
        false);
  }

  
  /**
   */

  onPaymentDetailsNotUpdated() {
    this.proxy.sendMessage(
        3,
        PaymentRequest_OnPaymentDetailsNotUpdated_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  abort() {
    this.proxy.sendMessage(
        4,
        PaymentRequest_Abort_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !PaymentComplete } result
   */

  complete(
      result) {
    this.proxy.sendMessage(
        5,
        PaymentRequest_Complete_ParamsSpec.$,
        null,
        [
          result
        ],
        false);
  }

  
  /**
   * @param { !payments_mojom_PaymentValidationErrors } errors
   */

  retry(
      errors) {
    this.proxy.sendMessage(
        6,
        PaymentRequest_Retry_ParamsSpec.$,
        null,
        [
          errors
        ],
        false);
  }

  
  /**
   */

  canMakePayment() {
    this.proxy.sendMessage(
        7,
        PaymentRequest_CanMakePayment_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  hasEnrolledInstrument() {
    this.proxy.sendMessage(
        8,
        PaymentRequest_HasEnrolledInstrument_ParamsSpec.$,
        null,
        [
        ],
        false);
  }
}

/**
 * An object which receives request messages for the PaymentRequest
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PaymentRequestReceiver {
  /**
   * @param {!PaymentRequestInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!PaymentRequestRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        PaymentRequestRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!PaymentRequestRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        PaymentRequest_Init_ParamsSpec.$,
        null,
        impl.init.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        PaymentRequest_Show_ParamsSpec.$,
        null,
        impl.show.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        PaymentRequest_UpdateWith_ParamsSpec.$,
        null,
        impl.updateWith.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        PaymentRequest_OnPaymentDetailsNotUpdated_ParamsSpec.$,
        null,
        impl.onPaymentDetailsNotUpdated.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        PaymentRequest_Abort_ParamsSpec.$,
        null,
        impl.abort.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        PaymentRequest_Complete_ParamsSpec.$,
        null,
        impl.complete.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        PaymentRequest_Retry_ParamsSpec.$,
        null,
        impl.retry.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        PaymentRequest_CanMakePayment_ParamsSpec.$,
        null,
        impl.canMakePayment.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        8,
        PaymentRequest_HasEnrolledInstrument_ParamsSpec.$,
        null,
        impl.hasEnrolledInstrument.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class PaymentRequest {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "payments.mojom.PaymentRequest";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!PaymentRequestRemote}
   */
  static getRemote() {
    let remote = new PaymentRequestRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the PaymentRequest
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PaymentRequestCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      PaymentRequestRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!PaymentRequestRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.init =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        PaymentRequest_Init_ParamsSpec.$,
        null,
        this.init.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.show =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        PaymentRequest_Show_ParamsSpec.$,
        null,
        this.show.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.updateWith =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        PaymentRequest_UpdateWith_ParamsSpec.$,
        null,
        this.updateWith.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onPaymentDetailsNotUpdated =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        PaymentRequest_OnPaymentDetailsNotUpdated_ParamsSpec.$,
        null,
        this.onPaymentDetailsNotUpdated.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.abort =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        PaymentRequest_Abort_ParamsSpec.$,
        null,
        this.abort.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.complete =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        PaymentRequest_Complete_ParamsSpec.$,
        null,
        this.complete.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.retry =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        PaymentRequest_Retry_ParamsSpec.$,
        null,
        this.retry.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.canMakePayment =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        PaymentRequest_CanMakePayment_ParamsSpec.$,
        null,
        this.canMakePayment.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.hasEnrolledInstrument =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        8,
        PaymentRequest_HasEnrolledInstrument_ParamsSpec.$,
        null,
        this.hasEnrolledInstrument.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PaymentResponseSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PayerDetailSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PaymentItemSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PaymentShippingOptionSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SecurePaymentConfirmationRequestSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkOrIssuerInformationSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PaymentEntityLogoSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PaymentMethodDataSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PaymentDetailsModifierSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PaymentDetailsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PaymentOptionsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PaymentRequestClient_OnPaymentMethodChange_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PaymentRequestClient_OnShippingAddressChange_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PaymentRequestClient_OnShippingOptionChange_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PaymentRequestClient_OnPayerDetailChange_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PaymentRequestClient_OnPaymentResponse_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PaymentRequestClient_OnError_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PaymentRequestClient_OnComplete_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PaymentRequestClient_OnAbort_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PaymentRequestClient_OnCanMakePayment_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PaymentRequestClient_OnHasEnrolledInstrument_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PaymentRequestClient_WarnNoFavicon_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PaymentRequestClient_AllowConnectToSource_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PaymentRequestClient_AllowConnectToSource_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PaymentRequest_Init_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PaymentRequest_Show_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PaymentRequest_UpdateWith_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PaymentRequest_OnPaymentDetailsNotUpdated_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PaymentRequest_Abort_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PaymentRequest_Complete_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PaymentRequest_Retry_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PaymentRequest_CanMakePayment_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PaymentRequest_HasEnrolledInstrument_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    PaymentResponseSpec.$,
    'PaymentResponse',
    [
      mojo.internal.StructField(
        'methodName', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'stringifiedDetails', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'shippingAddress', 16,
        0,
        payments_mojom_PaymentAddressSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'shippingOption', 24,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'payer', 32,
        0,
        PayerDetailSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'getAssertionAuthenticatorResponse', 40,
        0,
        blink_mojom_GetAssertionAuthenticatorResponseSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 56],]);



/**
 * @record
 */
export class PaymentResponse {
  constructor() {
    /** @type { !string } */
    this.methodName;
    /** @type { !string } */
    this.stringifiedDetails;
    /** @type { (payments_mojom_PaymentAddress|undefined) } */
    this.shippingAddress;
    /** @type { (string|undefined) } */
    this.shippingOption;
    /** @type { !PayerDetail } */
    this.payer;
    /** @type { (blink_mojom_GetAssertionAuthenticatorResponse|undefined) } */
    this.getAssertionAuthenticatorResponse;
  }
}



mojo.internal.Struct(
    PayerDetailSpec.$,
    'PayerDetail',
    [
      mojo.internal.StructField(
        'email', 0,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'name', 8,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'phone', 16,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class PayerDetail {
  constructor() {
    /** @type { (string|undefined) } */
    this.email;
    /** @type { (string|undefined) } */
    this.name;
    /** @type { (string|undefined) } */
    this.phone;
  }
}



mojo.internal.Struct(
    PaymentItemSpec.$,
    'PaymentItem',
    [
      mojo.internal.StructField(
        'label', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'amount', 8,
        0,
        payments_mojom_PaymentCurrencyAmountSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'pending', 16,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class PaymentItem {
  constructor() {
    /** @type { !string } */
    this.label;
    /** @type { !payments_mojom_PaymentCurrencyAmount } */
    this.amount;
    /** @type { !boolean } */
    this.pending;
  }
}



mojo.internal.Struct(
    PaymentShippingOptionSpec.$,
    'PaymentShippingOption',
    [
      mojo.internal.StructField(
        'id', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'label', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'amount', 16,
        0,
        payments_mojom_PaymentCurrencyAmountSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'selected', 24,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 40],]);



/**
 * @record
 */
export class PaymentShippingOption {
  constructor() {
    /** @type { !string } */
    this.id;
    /** @type { !string } */
    this.label;
    /** @type { !payments_mojom_PaymentCurrencyAmount } */
    this.amount;
    /** @type { !boolean } */
    this.selected;
  }
}



mojo.internal.Struct(
    SecurePaymentConfirmationRequestSpec.$,
    'SecurePaymentConfirmationRequest',
    [
      mojo.internal.StructField(
        'credentialIds', 0,
        0,
        mojo.internal.Array(mojo.internal.Array(mojo.internal.Uint8, false), false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'challenge', 8,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'instrument', 16,
        0,
        blink_mojom_PaymentCredentialInstrumentSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'timeout', 24,
        0,
        mojoBase_mojom_TimeDeltaSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'payeeOrigin', 32,
        0,
        url_mojom_OriginSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'payeeName', 40,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'rpId', 48,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'extensions', 56,
        0,
        blink_mojom_AuthenticationExtensionsClientInputsSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'browserBoundPubKeyCredParams', 64,
        0,
        mojo.internal.Array(blink_mojom_PublicKeyCredentialParametersSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'showOptOut', 72,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'paymentEntitiesLogos', 80,
        0,
        mojo.internal.Array(PaymentEntityLogoSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 96],]);



/**
 * @record
 */
export class SecurePaymentConfirmationRequest {
  constructor() {
    /** @type { !Array<!Array<!number>> } */
    this.credentialIds;
    /** @type { !Array<!number> } */
    this.challenge;
    /** @type { !blink_mojom_PaymentCredentialInstrument } */
    this.instrument;
    /** @type { (mojoBase_mojom_TimeDelta|undefined) } */
    this.timeout;
    /** @type { (url_mojom_Origin|undefined) } */
    this.payeeOrigin;
    /** @type { (string|undefined) } */
    this.payeeName;
    /** @type { !string } */
    this.rpId;
    /** @type { (blink_mojom_AuthenticationExtensionsClientInputs|undefined) } */
    this.extensions;
    /** @type { !Array<!blink_mojom_PublicKeyCredentialParameters> } */
    this.browserBoundPubKeyCredParams;
    /** @type { !boolean } */
    this.showOptOut;
    /** @type { !Array<!PaymentEntityLogo> } */
    this.paymentEntitiesLogos;
  }
}



mojo.internal.Struct(
    NetworkOrIssuerInformationSpec.$,
    'NetworkOrIssuerInformation',
    [
      mojo.internal.StructField(
        'name', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'icon', 8,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class NetworkOrIssuerInformation {
  constructor() {
    /** @type { !string } */
    this.name;
    /** @type { !url_mojom_Url } */
    this.icon;
  }
}



mojo.internal.Struct(
    PaymentEntityLogoSpec.$,
    'PaymentEntityLogo',
    [
      mojo.internal.StructField(
        'url', 0,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'label', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class PaymentEntityLogo {
  constructor() {
    /** @type { !url_mojom_Url } */
    this.url;
    /** @type { !string } */
    this.label;
  }
}



mojo.internal.Struct(
    PaymentMethodDataSpec.$,
    'PaymentMethodData',
    [
      mojo.internal.StructField(
        'supportedMethod', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'stringifiedData', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'environment', 16,
        0,
        AndroidPayEnvironmentSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'minGooglePlayServicesVersion', 20,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'apiVersion', 24,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'supportedNetworks', 32,
        0,
        mojo.internal.Array(BasicCardNetworkSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'securePaymentConfirmation', 40,
        0,
        SecurePaymentConfirmationRequestSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 56],]);



/**
 * @record
 */
export class PaymentMethodData {
  constructor() {
    /** @type { !string } */
    this.supportedMethod;
    /** @type { !string } */
    this.stringifiedData;
    /** @type { !AndroidPayEnvironment } */
    this.environment;
    /** @type { !number } */
    this.minGooglePlayServicesVersion;
    /** @type { !number } */
    this.apiVersion;
    /** @type { !Array<!BasicCardNetwork> } */
    this.supportedNetworks;
    /** @type { (SecurePaymentConfirmationRequest|undefined) } */
    this.securePaymentConfirmation;
  }
}



mojo.internal.Struct(
    PaymentDetailsModifierSpec.$,
    'PaymentDetailsModifier',
    [
      mojo.internal.StructField(
        'total', 0,
        0,
        PaymentItemSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'additionalDisplayItems', 8,
        0,
        mojo.internal.Array(PaymentItemSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'methodData', 16,
        0,
        PaymentMethodDataSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class PaymentDetailsModifier {
  constructor() {
    /** @type { (PaymentItem|undefined) } */
    this.total;
    /** @type { !Array<!PaymentItem> } */
    this.additionalDisplayItems;
    /** @type { !PaymentMethodData } */
    this.methodData;
  }
}



mojo.internal.Struct(
    PaymentDetailsSpec.$,
    'PaymentDetails',
    [
      mojo.internal.StructField(
        'total', 0,
        0,
        PaymentItemSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'displayItems', 8,
        0,
        mojo.internal.Array(PaymentItemSpec.$, false),
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'shippingOptions', 16,
        0,
        mojo.internal.Array(PaymentShippingOptionSpec.$, false),
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'modifiers', 24,
        0,
        mojo.internal.Array(PaymentDetailsModifierSpec.$, false),
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'error', 32,
        0,
        mojo.internal.String,
        "",
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'shippingAddressErrors', 40,
        0,
        payments_mojom_AddressErrorsSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'id', 48,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'stringifiedPaymentMethodErrors', 56,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 72],]);



/**
 * @record
 */
export class PaymentDetails {
  constructor() {
    /** @type { (PaymentItem|undefined) } */
    this.total;
    /** @type { (Array<!PaymentItem>|undefined) } */
    this.displayItems;
    /** @type { (Array<!PaymentShippingOption>|undefined) } */
    this.shippingOptions;
    /** @type { (Array<!PaymentDetailsModifier>|undefined) } */
    this.modifiers;
    /** @type { !string } */
    this.error;
    /** @type { (payments_mojom_AddressErrors|undefined) } */
    this.shippingAddressErrors;
    /** @type { (string|undefined) } */
    this.id;
    /** @type { (string|undefined) } */
    this.stringifiedPaymentMethodErrors;
  }
}



mojo.internal.Struct(
    PaymentOptionsSpec.$,
    'PaymentOptions',
    [
      mojo.internal.StructField(
        'requestPayerName', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'requestPayerEmail', 0,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'requestPayerPhone', 0,
        2,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'requestShipping', 0,
        3,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'shippingType', 4,
        0,
        PaymentShippingTypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class PaymentOptions {
  constructor() {
    /** @type { !boolean } */
    this.requestPayerName;
    /** @type { !boolean } */
    this.requestPayerEmail;
    /** @type { !boolean } */
    this.requestPayerPhone;
    /** @type { !boolean } */
    this.requestShipping;
    /** @type { !PaymentShippingType } */
    this.shippingType;
  }
}



mojo.internal.Struct(
    PaymentRequestClient_OnPaymentMethodChange_ParamsSpec.$,
    'PaymentRequestClient_OnPaymentMethodChange_Params',
    [
      mojo.internal.StructField(
        'methodName', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'stringifiedDetails', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class PaymentRequestClient_OnPaymentMethodChange_Params {
  constructor() {
    /** @type { !string } */
    this.methodName;
    /** @type { !string } */
    this.stringifiedDetails;
  }
}



mojo.internal.Struct(
    PaymentRequestClient_OnShippingAddressChange_ParamsSpec.$,
    'PaymentRequestClient_OnShippingAddressChange_Params',
    [
      mojo.internal.StructField(
        'address', 0,
        0,
        payments_mojom_PaymentAddressSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class PaymentRequestClient_OnShippingAddressChange_Params {
  constructor() {
    /** @type { !payments_mojom_PaymentAddress } */
    this.address;
  }
}



mojo.internal.Struct(
    PaymentRequestClient_OnShippingOptionChange_ParamsSpec.$,
    'PaymentRequestClient_OnShippingOptionChange_Params',
    [
      mojo.internal.StructField(
        'shippingOptionId', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class PaymentRequestClient_OnShippingOptionChange_Params {
  constructor() {
    /** @type { !string } */
    this.shippingOptionId;
  }
}



mojo.internal.Struct(
    PaymentRequestClient_OnPayerDetailChange_ParamsSpec.$,
    'PaymentRequestClient_OnPayerDetailChange_Params',
    [
      mojo.internal.StructField(
        'detail', 0,
        0,
        PayerDetailSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class PaymentRequestClient_OnPayerDetailChange_Params {
  constructor() {
    /** @type { !PayerDetail } */
    this.detail;
  }
}



mojo.internal.Struct(
    PaymentRequestClient_OnPaymentResponse_ParamsSpec.$,
    'PaymentRequestClient_OnPaymentResponse_Params',
    [
      mojo.internal.StructField(
        'response', 0,
        0,
        PaymentResponseSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class PaymentRequestClient_OnPaymentResponse_Params {
  constructor() {
    /** @type { !PaymentResponse } */
    this.response;
  }
}



mojo.internal.Struct(
    PaymentRequestClient_OnError_ParamsSpec.$,
    'PaymentRequestClient_OnError_Params',
    [
      mojo.internal.StructField(
        'error', 0,
        0,
        PaymentErrorReasonSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'errorMessage', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class PaymentRequestClient_OnError_Params {
  constructor() {
    /** @type { !PaymentErrorReason } */
    this.error;
    /** @type { !string } */
    this.errorMessage;
  }
}



mojo.internal.Struct(
    PaymentRequestClient_OnComplete_ParamsSpec.$,
    'PaymentRequestClient_OnComplete_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class PaymentRequestClient_OnComplete_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    PaymentRequestClient_OnAbort_ParamsSpec.$,
    'PaymentRequestClient_OnAbort_Params',
    [
      mojo.internal.StructField(
        'abortedSuccessfully', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class PaymentRequestClient_OnAbort_Params {
  constructor() {
    /** @type { !boolean } */
    this.abortedSuccessfully;
  }
}



mojo.internal.Struct(
    PaymentRequestClient_OnCanMakePayment_ParamsSpec.$,
    'PaymentRequestClient_OnCanMakePayment_Params',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        CanMakePaymentQueryResultSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class PaymentRequestClient_OnCanMakePayment_Params {
  constructor() {
    /** @type { !CanMakePaymentQueryResult } */
    this.result;
  }
}



mojo.internal.Struct(
    PaymentRequestClient_OnHasEnrolledInstrument_ParamsSpec.$,
    'PaymentRequestClient_OnHasEnrolledInstrument_Params',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        HasEnrolledInstrumentQueryResultSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class PaymentRequestClient_OnHasEnrolledInstrument_Params {
  constructor() {
    /** @type { !HasEnrolledInstrumentQueryResult } */
    this.result;
  }
}



mojo.internal.Struct(
    PaymentRequestClient_WarnNoFavicon_ParamsSpec.$,
    'PaymentRequestClient_WarnNoFavicon_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class PaymentRequestClient_WarnNoFavicon_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    PaymentRequestClient_AllowConnectToSource_ParamsSpec.$,
    'PaymentRequestClient_AllowConnectToSource_Params',
    [
      mojo.internal.StructField(
        'url', 0,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'urlBeforeRedirects', 8,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'didFollowRedirect', 16,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class PaymentRequestClient_AllowConnectToSource_Params {
  constructor() {
    /** @type { !url_mojom_Url } */
    this.url;
    /** @type { !url_mojom_Url } */
    this.urlBeforeRedirects;
    /** @type { !boolean } */
    this.didFollowRedirect;
  }
}



mojo.internal.Struct(
    PaymentRequestClient_AllowConnectToSource_ResponseParamsSpec.$,
    'PaymentRequestClient_AllowConnectToSource_ResponseParams',
    [
      mojo.internal.StructField(
        'allow', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class PaymentRequestClient_AllowConnectToSource_ResponseParams {
  constructor() {
    /** @type { !boolean } */
    this.allow;
  }
}



mojo.internal.Struct(
    PaymentRequest_Init_ParamsSpec.$,
    'PaymentRequest_Init_Params',
    [
      mojo.internal.StructField(
        'client', 0,
        0,
        mojo.internal.InterfaceProxy(PaymentRequestClientRemote),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'methodData', 8,
        0,
        mojo.internal.Array(PaymentMethodDataSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'details', 16,
        0,
        PaymentDetailsSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'options', 24,
        0,
        PaymentOptionsSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 40],]);



/**
 * @record
 */
export class PaymentRequest_Init_Params {
  constructor() {
    /** @type { !PaymentRequestClientRemote } */
    this.client;
    /** @type { !Array<!PaymentMethodData> } */
    this.methodData;
    /** @type { !PaymentDetails } */
    this.details;
    /** @type { !PaymentOptions } */
    this.options;
  }
}



mojo.internal.Struct(
    PaymentRequest_Show_ParamsSpec.$,
    'PaymentRequest_Show_Params',
    [
      mojo.internal.StructField(
        'waitForUpdatedDetails', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'hadUserActivation', 0,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class PaymentRequest_Show_Params {
  constructor() {
    /** @type { !boolean } */
    this.waitForUpdatedDetails;
    /** @type { !boolean } */
    this.hadUserActivation;
  }
}



mojo.internal.Struct(
    PaymentRequest_UpdateWith_ParamsSpec.$,
    'PaymentRequest_UpdateWith_Params',
    [
      mojo.internal.StructField(
        'details', 0,
        0,
        PaymentDetailsSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class PaymentRequest_UpdateWith_Params {
  constructor() {
    /** @type { !PaymentDetails } */
    this.details;
  }
}



mojo.internal.Struct(
    PaymentRequest_OnPaymentDetailsNotUpdated_ParamsSpec.$,
    'PaymentRequest_OnPaymentDetailsNotUpdated_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class PaymentRequest_OnPaymentDetailsNotUpdated_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    PaymentRequest_Abort_ParamsSpec.$,
    'PaymentRequest_Abort_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class PaymentRequest_Abort_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    PaymentRequest_Complete_ParamsSpec.$,
    'PaymentRequest_Complete_Params',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        PaymentCompleteSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class PaymentRequest_Complete_Params {
  constructor() {
    /** @type { !PaymentComplete } */
    this.result;
  }
}



mojo.internal.Struct(
    PaymentRequest_Retry_ParamsSpec.$,
    'PaymentRequest_Retry_Params',
    [
      mojo.internal.StructField(
        'errors', 0,
        0,
        payments_mojom_PaymentValidationErrorsSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class PaymentRequest_Retry_Params {
  constructor() {
    /** @type { !payments_mojom_PaymentValidationErrors } */
    this.errors;
  }
}



mojo.internal.Struct(
    PaymentRequest_CanMakePayment_ParamsSpec.$,
    'PaymentRequest_CanMakePayment_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class PaymentRequest_CanMakePayment_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    PaymentRequest_HasEnrolledInstrument_ParamsSpec.$,
    'PaymentRequest_HasEnrolledInstrument_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class PaymentRequest_HasEnrolledInstrument_Params {
  constructor() {
  }
}

