// third_party/blink/public/mojom/payments/payment_request.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_PAYMENTS_PAYMENT_REQUEST_MOJOM_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_PAYMENTS_PAYMENT_REQUEST_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/payments/payment_request.mojom-features.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/payments/payment_request.mojom-shared.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/payments/payment_request.mojom-forward.h"  // IWYU pragma: export
#include "components/payments/mojom/payment_request_data.mojom.h"
#include "mojo/public/mojom/base/time.mojom.h"
#include "third_party/blink/public/mojom/payments/secure_payment_confirmation_service.mojom-forward.h"
#include "url/mojom/origin.mojom.h"
#include "url/mojom/url.mojom.h"
#include "third_party/blink/public/mojom/webauthn/authenticator.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "third_party/blink/public/common/common_export.h"




namespace payments::mojom {

class PaymentRequestClientProxy;

template <typename ImplRefTraits>
class PaymentRequestClientStub;

class PaymentRequestClientRequestValidator;
class PaymentRequestClientResponseValidator;


class BLINK_COMMON_EXPORT PaymentRequestClient
    : public PaymentRequestClientInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "payments.mojom.PaymentRequestClient";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = PaymentRequestClientInterfaceBase;
  using Proxy_ = PaymentRequestClientProxy;

  template <typename ImplRefTraits>
  using Stub_ = PaymentRequestClientStub<ImplRefTraits>;

  using RequestValidator_ = PaymentRequestClientRequestValidator;
  using ResponseValidator_ = PaymentRequestClientResponseValidator;
  enum MethodMinVersions : uint32_t {
    kOnPaymentMethodChangeMinVersion = 0,
    kOnShippingAddressChangeMinVersion = 0,
    kOnShippingOptionChangeMinVersion = 0,
    kOnPayerDetailChangeMinVersion = 0,
    kOnPaymentResponseMinVersion = 0,
    kOnErrorMinVersion = 0,
    kOnCompleteMinVersion = 0,
    kOnAbortMinVersion = 0,
    kOnCanMakePaymentMinVersion = 0,
    kOnHasEnrolledInstrumentMinVersion = 0,
    kWarnNoFaviconMinVersion = 0,
    kAllowConnectToSourceMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct OnPaymentMethodChange_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnShippingAddressChange_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnShippingOptionChange_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnPayerDetailChange_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnPaymentResponse_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnError_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnComplete_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnAbort_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnCanMakePayment_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnHasEnrolledInstrument_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct WarnNoFavicon_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct AllowConnectToSource_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~PaymentRequestClient() = default;

  virtual void OnPaymentMethodChange(const std::string& method_name, const std::string& stringified_details) = 0;

  virtual void OnShippingAddressChange(::payments::mojom::PaymentAddressPtr address) = 0;

  virtual void OnShippingOptionChange(const std::string& shipping_option_id) = 0;

  virtual void OnPayerDetailChange(PayerDetailPtr detail) = 0;

  virtual void OnPaymentResponse(PaymentResponsePtr response) = 0;

  virtual void OnError(PaymentErrorReason error, const std::string& error_message) = 0;

  virtual void OnComplete() = 0;

  virtual void OnAbort(bool aborted_successfully) = 0;

  virtual void OnCanMakePayment(CanMakePaymentQueryResult result) = 0;

  virtual void OnHasEnrolledInstrument(HasEnrolledInstrumentQueryResult result) = 0;

  virtual void WarnNoFavicon() = 0;

  using AllowConnectToSourceCallback = base::OnceCallback<void(bool)>;
  using AllowConnectToSourceMojoCallback = base::OnceCallback<void(bool)>;

  virtual void AllowConnectToSource(const ::GURL& url, const ::GURL& url_before_redirects, bool did_follow_redirect, AllowConnectToSourceCallback callback) = 0;
};

class PaymentRequestProxy;

template <typename ImplRefTraits>
class PaymentRequestStub;

class PaymentRequestRequestValidator;


class BLINK_COMMON_EXPORT PaymentRequest
    : public PaymentRequestInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "payments.mojom.PaymentRequest";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = PaymentRequestInterfaceBase;
  using Proxy_ = PaymentRequestProxy;

  template <typename ImplRefTraits>
  using Stub_ = PaymentRequestStub<ImplRefTraits>;

  using RequestValidator_ = PaymentRequestRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kInitMinVersion = 0,
    kShowMinVersion = 0,
    kUpdateWithMinVersion = 0,
    kOnPaymentDetailsNotUpdatedMinVersion = 0,
    kAbortMinVersion = 0,
    kCompleteMinVersion = 0,
    kRetryMinVersion = 0,
    kCanMakePaymentMinVersion = 0,
    kHasEnrolledInstrumentMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct Init_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Show_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct UpdateWith_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnPaymentDetailsNotUpdated_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Abort_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Complete_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Retry_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CanMakePayment_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct HasEnrolledInstrument_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~PaymentRequest() = default;

  virtual void Init(::mojo::PendingRemote<PaymentRequestClient> client, std::vector<PaymentMethodDataPtr> method_data, PaymentDetailsPtr details, PaymentOptionsPtr options) = 0;

  virtual void Show(bool wait_for_updated_details, bool had_user_activation) = 0;

  virtual void UpdateWith(PaymentDetailsPtr details) = 0;

  virtual void OnPaymentDetailsNotUpdated() = 0;

  virtual void Abort() = 0;

  virtual void Complete(PaymentComplete result) = 0;

  virtual void Retry(::payments::mojom::PaymentValidationErrorsPtr errors) = 0;

  virtual void CanMakePayment() = 0;

  virtual void HasEnrolledInstrument() = 0;
};



class BLINK_COMMON_EXPORT PaymentRequestClientProxy
    : public PaymentRequestClient {
 public:
  using InterfaceType = PaymentRequestClient;

  explicit PaymentRequestClientProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnPaymentMethodChange(const std::string& method_name, const std::string& stringified_details) final;
  
  void OnShippingAddressChange(::payments::mojom::PaymentAddressPtr address) final;
  
  void OnShippingOptionChange(const std::string& shipping_option_id) final;
  
  void OnPayerDetailChange(PayerDetailPtr detail) final;
  
  void OnPaymentResponse(PaymentResponsePtr response) final;
  
  void OnError(PaymentErrorReason error, const std::string& error_message) final;
  
  void OnComplete() final;
  
  void OnAbort(bool aborted_successfully) final;
  
  void OnCanMakePayment(CanMakePaymentQueryResult result) final;
  
  void OnHasEnrolledInstrument(HasEnrolledInstrumentQueryResult result) final;
  
  void WarnNoFavicon() final;
  
  void AllowConnectToSource(const ::GURL& url, const ::GURL& url_before_redirects, bool did_follow_redirect, AllowConnectToSourceCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class BLINK_COMMON_EXPORT PaymentRequestProxy
    : public PaymentRequest {
 public:
  using InterfaceType = PaymentRequest;

  explicit PaymentRequestProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void Init(::mojo::PendingRemote<PaymentRequestClient> client, std::vector<PaymentMethodDataPtr> method_data, PaymentDetailsPtr details, PaymentOptionsPtr options) final;
  
  void Show(bool wait_for_updated_details, bool had_user_activation) final;
  
  void UpdateWith(PaymentDetailsPtr details) final;
  
  void OnPaymentDetailsNotUpdated() final;
  
  void Abort() final;
  
  void Complete(PaymentComplete result) final;
  
  void Retry(::payments::mojom::PaymentValidationErrorsPtr errors) final;
  
  void CanMakePayment() final;
  
  void HasEnrolledInstrument() final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class BLINK_COMMON_EXPORT PaymentRequestClientStubDispatch {
 public:
  static bool Accept(PaymentRequestClient* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      PaymentRequestClient* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<PaymentRequestClient>>
class PaymentRequestClientStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  PaymentRequestClientStub() = default;
  ~PaymentRequestClientStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PaymentRequestClientStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PaymentRequestClientStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_COMMON_EXPORT PaymentRequestStubDispatch {
 public:
  static bool Accept(PaymentRequest* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      PaymentRequest* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<PaymentRequest>>
class PaymentRequestStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  PaymentRequestStub() = default;
  ~PaymentRequestStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PaymentRequestStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PaymentRequestStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_COMMON_EXPORT PaymentRequestClientRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_COMMON_EXPORT PaymentRequestRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_COMMON_EXPORT PaymentRequestClientResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};






class BLINK_COMMON_EXPORT PayerDetail {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<PayerDetail, T>::value>;
  using DataView = PayerDetailDataView;
  using Data_ = internal::PayerDetail_Data;

  template <typename... Args>
  static PayerDetailPtr New(Args&&... args) {
    return PayerDetailPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PayerDetailPtr From(const U& u) {
    return mojo::TypeConverter<PayerDetailPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PayerDetail>::Convert(*this);
  }


  PayerDetail();

  PayerDetail(
      const std::optional<std::string>& email,
      const std::optional<std::string>& name,
      const std::optional<std::string>& phone);


  ~PayerDetail();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PayerDetailPtr>
  PayerDetailPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, PayerDetail::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, PayerDetail::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, PayerDetail::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PayerDetail::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PayerDetail::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PayerDetail::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::PayerDetail_UnserializedMessageContext<
            UserType, PayerDetail::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<PayerDetail::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return PayerDetail::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::PayerDetail_UnserializedMessageContext<
            UserType, PayerDetail::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<PayerDetail::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::optional<std::string> email;
  
  std::optional<std::string> name;
  
  std::optional<std::string> phone;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, PayerDetail::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, PayerDetail::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, PayerDetail::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, PayerDetail::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}
















class BLINK_COMMON_EXPORT PaymentResponse {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<PaymentResponse, T>::value>;
  using DataView = PaymentResponseDataView;
  using Data_ = internal::PaymentResponse_Data;

  template <typename... Args>
  static PaymentResponsePtr New(Args&&... args) {
    return PaymentResponsePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PaymentResponsePtr From(const U& u) {
    return mojo::TypeConverter<PaymentResponsePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PaymentResponse>::Convert(*this);
  }


  PaymentResponse();

  PaymentResponse(
      const std::string& method_name,
      const std::string& stringified_details,
      ::payments::mojom::PaymentAddressPtr shipping_address,
      const std::optional<std::string>& shipping_option,
      PayerDetailPtr payer,
      ::blink::mojom::GetAssertionAuthenticatorResponsePtr get_assertion_authenticator_response);

PaymentResponse(const PaymentResponse&) = delete;
PaymentResponse& operator=(const PaymentResponse&) = delete;

  ~PaymentResponse();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PaymentResponsePtr>
  PaymentResponsePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, PaymentResponse::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, PaymentResponse::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, PaymentResponse::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PaymentResponse::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PaymentResponse::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PaymentResponse::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::PaymentResponse_UnserializedMessageContext<
            UserType, PaymentResponse::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<PaymentResponse::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return PaymentResponse::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::PaymentResponse_UnserializedMessageContext<
            UserType, PaymentResponse::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<PaymentResponse::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string method_name;
  
  std::string stringified_details;
  
  ::payments::mojom::PaymentAddressPtr shipping_address;
  
  std::optional<std::string> shipping_option;
  
  PayerDetailPtr payer;
  
  ::blink::mojom::GetAssertionAuthenticatorResponsePtr get_assertion_authenticator_response;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, PaymentResponse::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, PaymentResponse::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, PaymentResponse::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, PaymentResponse::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






class BLINK_COMMON_EXPORT PaymentItem {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<PaymentItem, T>::value>;
  using DataView = PaymentItemDataView;
  using Data_ = internal::PaymentItem_Data;

  template <typename... Args>
  static PaymentItemPtr New(Args&&... args) {
    return PaymentItemPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PaymentItemPtr From(const U& u) {
    return mojo::TypeConverter<PaymentItemPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PaymentItem>::Convert(*this);
  }


  PaymentItem();

  PaymentItem(
      const std::string& label,
      ::payments::mojom::PaymentCurrencyAmountPtr amount,
      bool pending);

PaymentItem(const PaymentItem&) = delete;
PaymentItem& operator=(const PaymentItem&) = delete;

  ~PaymentItem();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PaymentItemPtr>
  PaymentItemPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, PaymentItem::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, PaymentItem::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, PaymentItem::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PaymentItem::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PaymentItem::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PaymentItem::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::PaymentItem_UnserializedMessageContext<
            UserType, PaymentItem::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<PaymentItem::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return PaymentItem::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::PaymentItem_UnserializedMessageContext<
            UserType, PaymentItem::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<PaymentItem::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string label;
  
  ::payments::mojom::PaymentCurrencyAmountPtr amount;
  
  bool pending;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, PaymentItem::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, PaymentItem::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, PaymentItem::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, PaymentItem::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_COMMON_EXPORT PaymentShippingOption {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<PaymentShippingOption, T>::value>;
  using DataView = PaymentShippingOptionDataView;
  using Data_ = internal::PaymentShippingOption_Data;

  template <typename... Args>
  static PaymentShippingOptionPtr New(Args&&... args) {
    return PaymentShippingOptionPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PaymentShippingOptionPtr From(const U& u) {
    return mojo::TypeConverter<PaymentShippingOptionPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PaymentShippingOption>::Convert(*this);
  }


  PaymentShippingOption();

  PaymentShippingOption(
      const std::string& id,
      const std::string& label,
      ::payments::mojom::PaymentCurrencyAmountPtr amount,
      bool selected);

PaymentShippingOption(const PaymentShippingOption&) = delete;
PaymentShippingOption& operator=(const PaymentShippingOption&) = delete;

  ~PaymentShippingOption();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PaymentShippingOptionPtr>
  PaymentShippingOptionPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, PaymentShippingOption::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, PaymentShippingOption::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, PaymentShippingOption::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PaymentShippingOption::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PaymentShippingOption::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PaymentShippingOption::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::PaymentShippingOption_UnserializedMessageContext<
            UserType, PaymentShippingOption::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<PaymentShippingOption::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return PaymentShippingOption::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::PaymentShippingOption_UnserializedMessageContext<
            UserType, PaymentShippingOption::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<PaymentShippingOption::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string id;
  
  std::string label;
  
  ::payments::mojom::PaymentCurrencyAmountPtr amount;
  
  bool selected;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, PaymentShippingOption::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, PaymentShippingOption::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, PaymentShippingOption::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, PaymentShippingOption::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_COMMON_EXPORT SecurePaymentConfirmationRequest {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SecurePaymentConfirmationRequest, T>::value>;
  using DataView = SecurePaymentConfirmationRequestDataView;
  using Data_ = internal::SecurePaymentConfirmationRequest_Data;

  template <typename... Args>
  static SecurePaymentConfirmationRequestPtr New(Args&&... args) {
    return SecurePaymentConfirmationRequestPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SecurePaymentConfirmationRequestPtr From(const U& u) {
    return mojo::TypeConverter<SecurePaymentConfirmationRequestPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SecurePaymentConfirmationRequest>::Convert(*this);
  }


  SecurePaymentConfirmationRequest();

  SecurePaymentConfirmationRequest(
      std::vector<std::vector<uint8_t>> credential_ids,
      std::vector<uint8_t> challenge,
      ::blink::mojom::PaymentCredentialInstrumentPtr instrument,
      std::optional<::base::TimeDelta> timeout,
      const std::optional<::url::Origin>& payee_origin,
      const std::optional<std::string>& payee_name,
      const std::string& rp_id,
      ::blink::mojom::AuthenticationExtensionsClientInputsPtr extensions,
      std::vector<::device::PublicKeyCredentialParams::CredentialInfo> browser_bound_pub_key_cred_params,
      bool show_opt_out,
      std::vector<PaymentEntityLogoPtr> payment_entities_logos);

SecurePaymentConfirmationRequest(const SecurePaymentConfirmationRequest&) = delete;
SecurePaymentConfirmationRequest& operator=(const SecurePaymentConfirmationRequest&) = delete;

  ~SecurePaymentConfirmationRequest();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SecurePaymentConfirmationRequestPtr>
  SecurePaymentConfirmationRequestPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SecurePaymentConfirmationRequest::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SecurePaymentConfirmationRequest::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SecurePaymentConfirmationRequest::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SecurePaymentConfirmationRequest::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SecurePaymentConfirmationRequest::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SecurePaymentConfirmationRequest::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SecurePaymentConfirmationRequest_UnserializedMessageContext<
            UserType, SecurePaymentConfirmationRequest::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SecurePaymentConfirmationRequest::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SecurePaymentConfirmationRequest::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SecurePaymentConfirmationRequest_UnserializedMessageContext<
            UserType, SecurePaymentConfirmationRequest::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SecurePaymentConfirmationRequest::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::vector<std::vector<uint8_t>> credential_ids;
  
  std::vector<uint8_t> challenge;
  
  ::blink::mojom::PaymentCredentialInstrumentPtr instrument;
  
  std::optional<::base::TimeDelta> timeout;
  
  std::optional<::url::Origin> payee_origin;
  
  std::optional<std::string> payee_name;
  
  std::string rp_id;
  
  ::blink::mojom::AuthenticationExtensionsClientInputsPtr extensions;
  
  std::vector<::device::PublicKeyCredentialParams::CredentialInfo> browser_bound_pub_key_cred_params;
  
  bool show_opt_out;
  
  std::vector<PaymentEntityLogoPtr> payment_entities_logos;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SecurePaymentConfirmationRequest::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SecurePaymentConfirmationRequest::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SecurePaymentConfirmationRequest::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SecurePaymentConfirmationRequest::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_COMMON_EXPORT NetworkOrIssuerInformation {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<NetworkOrIssuerInformation, T>::value>;
  using DataView = NetworkOrIssuerInformationDataView;
  using Data_ = internal::NetworkOrIssuerInformation_Data;

  template <typename... Args>
  static NetworkOrIssuerInformationPtr New(Args&&... args) {
    return NetworkOrIssuerInformationPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static NetworkOrIssuerInformationPtr From(const U& u) {
    return mojo::TypeConverter<NetworkOrIssuerInformationPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, NetworkOrIssuerInformation>::Convert(*this);
  }


  NetworkOrIssuerInformation();

  NetworkOrIssuerInformation(
      const std::string& name,
      const ::GURL& icon);


  ~NetworkOrIssuerInformation();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = NetworkOrIssuerInformationPtr>
  NetworkOrIssuerInformationPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, NetworkOrIssuerInformation::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, NetworkOrIssuerInformation::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, NetworkOrIssuerInformation::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        NetworkOrIssuerInformation::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        NetworkOrIssuerInformation::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        NetworkOrIssuerInformation::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::NetworkOrIssuerInformation_UnserializedMessageContext<
            UserType, NetworkOrIssuerInformation::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<NetworkOrIssuerInformation::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return NetworkOrIssuerInformation::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::NetworkOrIssuerInformation_UnserializedMessageContext<
            UserType, NetworkOrIssuerInformation::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<NetworkOrIssuerInformation::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string name;
  
  ::GURL icon;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, NetworkOrIssuerInformation::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, NetworkOrIssuerInformation::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, NetworkOrIssuerInformation::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, NetworkOrIssuerInformation::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_COMMON_EXPORT PaymentEntityLogo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<PaymentEntityLogo, T>::value>;
  using DataView = PaymentEntityLogoDataView;
  using Data_ = internal::PaymentEntityLogo_Data;

  template <typename... Args>
  static PaymentEntityLogoPtr New(Args&&... args) {
    return PaymentEntityLogoPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PaymentEntityLogoPtr From(const U& u) {
    return mojo::TypeConverter<PaymentEntityLogoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PaymentEntityLogo>::Convert(*this);
  }


  PaymentEntityLogo();

  PaymentEntityLogo(
      const ::GURL& url,
      const std::string& label);


  ~PaymentEntityLogo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PaymentEntityLogoPtr>
  PaymentEntityLogoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, PaymentEntityLogo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, PaymentEntityLogo::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, PaymentEntityLogo::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PaymentEntityLogo::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PaymentEntityLogo::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PaymentEntityLogo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::PaymentEntityLogo_UnserializedMessageContext<
            UserType, PaymentEntityLogo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<PaymentEntityLogo::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return PaymentEntityLogo::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::PaymentEntityLogo_UnserializedMessageContext<
            UserType, PaymentEntityLogo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<PaymentEntityLogo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::GURL url;
  
  std::string label;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, PaymentEntityLogo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, PaymentEntityLogo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, PaymentEntityLogo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, PaymentEntityLogo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_COMMON_EXPORT PaymentMethodData {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<PaymentMethodData, T>::value>;
  using DataView = PaymentMethodDataDataView;
  using Data_ = internal::PaymentMethodData_Data;

  template <typename... Args>
  static PaymentMethodDataPtr New(Args&&... args) {
    return PaymentMethodDataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PaymentMethodDataPtr From(const U& u) {
    return mojo::TypeConverter<PaymentMethodDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PaymentMethodData>::Convert(*this);
  }


  PaymentMethodData();

  PaymentMethodData(
      const std::string& supported_method,
      const std::string& stringified_data,
      AndroidPayEnvironment environment,
      int32_t min_google_play_services_version,
      int32_t api_version,
      std::vector<BasicCardNetwork> supported_networks,
      SecurePaymentConfirmationRequestPtr secure_payment_confirmation);

PaymentMethodData(const PaymentMethodData&) = delete;
PaymentMethodData& operator=(const PaymentMethodData&) = delete;

  ~PaymentMethodData();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PaymentMethodDataPtr>
  PaymentMethodDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, PaymentMethodData::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, PaymentMethodData::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, PaymentMethodData::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PaymentMethodData::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PaymentMethodData::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PaymentMethodData::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::PaymentMethodData_UnserializedMessageContext<
            UserType, PaymentMethodData::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<PaymentMethodData::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return PaymentMethodData::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::PaymentMethodData_UnserializedMessageContext<
            UserType, PaymentMethodData::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<PaymentMethodData::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string supported_method;
  
  std::string stringified_data;
  
  AndroidPayEnvironment environment;
  
  int32_t min_google_play_services_version;
  
  int32_t api_version;
  
  std::vector<BasicCardNetwork> supported_networks;
  
  SecurePaymentConfirmationRequestPtr secure_payment_confirmation;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, PaymentMethodData::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, PaymentMethodData::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, PaymentMethodData::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, PaymentMethodData::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_COMMON_EXPORT PaymentDetailsModifier {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<PaymentDetailsModifier, T>::value>;
  using DataView = PaymentDetailsModifierDataView;
  using Data_ = internal::PaymentDetailsModifier_Data;

  template <typename... Args>
  static PaymentDetailsModifierPtr New(Args&&... args) {
    return PaymentDetailsModifierPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PaymentDetailsModifierPtr From(const U& u) {
    return mojo::TypeConverter<PaymentDetailsModifierPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PaymentDetailsModifier>::Convert(*this);
  }


  PaymentDetailsModifier();

  PaymentDetailsModifier(
      PaymentItemPtr total,
      std::vector<PaymentItemPtr> additional_display_items,
      PaymentMethodDataPtr method_data);

PaymentDetailsModifier(const PaymentDetailsModifier&) = delete;
PaymentDetailsModifier& operator=(const PaymentDetailsModifier&) = delete;

  ~PaymentDetailsModifier();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PaymentDetailsModifierPtr>
  PaymentDetailsModifierPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, PaymentDetailsModifier::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, PaymentDetailsModifier::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, PaymentDetailsModifier::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PaymentDetailsModifier::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PaymentDetailsModifier::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PaymentDetailsModifier::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::PaymentDetailsModifier_UnserializedMessageContext<
            UserType, PaymentDetailsModifier::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<PaymentDetailsModifier::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return PaymentDetailsModifier::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::PaymentDetailsModifier_UnserializedMessageContext<
            UserType, PaymentDetailsModifier::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<PaymentDetailsModifier::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  PaymentItemPtr total;
  
  std::vector<PaymentItemPtr> additional_display_items;
  
  PaymentMethodDataPtr method_data;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, PaymentDetailsModifier::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, PaymentDetailsModifier::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, PaymentDetailsModifier::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, PaymentDetailsModifier::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_COMMON_EXPORT PaymentDetails {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<PaymentDetails, T>::value>;
  using DataView = PaymentDetailsDataView;
  using Data_ = internal::PaymentDetails_Data;

  template <typename... Args>
  static PaymentDetailsPtr New(Args&&... args) {
    return PaymentDetailsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PaymentDetailsPtr From(const U& u) {
    return mojo::TypeConverter<PaymentDetailsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PaymentDetails>::Convert(*this);
  }


  PaymentDetails();

  PaymentDetails(
      PaymentItemPtr total,
      std::optional<std::vector<PaymentItemPtr>> display_items,
      std::optional<std::vector<PaymentShippingOptionPtr>> shipping_options,
      std::optional<std::vector<PaymentDetailsModifierPtr>> modifiers,
      const std::string& error,
      ::payments::mojom::AddressErrorsPtr shipping_address_errors,
      const std::optional<std::string>& id,
      const std::optional<std::string>& stringified_payment_method_errors);

PaymentDetails(const PaymentDetails&) = delete;
PaymentDetails& operator=(const PaymentDetails&) = delete;

  ~PaymentDetails();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PaymentDetailsPtr>
  PaymentDetailsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, PaymentDetails::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, PaymentDetails::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, PaymentDetails::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PaymentDetails::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PaymentDetails::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PaymentDetails::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::PaymentDetails_UnserializedMessageContext<
            UserType, PaymentDetails::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<PaymentDetails::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return PaymentDetails::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::PaymentDetails_UnserializedMessageContext<
            UserType, PaymentDetails::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<PaymentDetails::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  PaymentItemPtr total;
  
  std::optional<std::vector<PaymentItemPtr>> display_items;
  
  std::optional<std::vector<PaymentShippingOptionPtr>> shipping_options;
  
  std::optional<std::vector<PaymentDetailsModifierPtr>> modifiers;
  
  std::string error;
  
  ::payments::mojom::AddressErrorsPtr shipping_address_errors;
  
  std::optional<std::string> id;
  
  std::optional<std::string> stringified_payment_method_errors;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, PaymentDetails::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, PaymentDetails::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, PaymentDetails::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, PaymentDetails::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_COMMON_EXPORT PaymentOptions {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<PaymentOptions, T>::value>;
  using DataView = PaymentOptionsDataView;
  using Data_ = internal::PaymentOptions_Data;

  template <typename... Args>
  static PaymentOptionsPtr New(Args&&... args) {
    return PaymentOptionsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PaymentOptionsPtr From(const U& u) {
    return mojo::TypeConverter<PaymentOptionsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PaymentOptions>::Convert(*this);
  }


  PaymentOptions();

  PaymentOptions(
      bool request_payer_name,
      bool request_payer_email,
      bool request_payer_phone,
      bool request_shipping,
      PaymentShippingType shipping_type);


  ~PaymentOptions();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PaymentOptionsPtr>
  PaymentOptionsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, PaymentOptions::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, PaymentOptions::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, PaymentOptions::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PaymentOptions::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PaymentOptions::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PaymentOptions::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::PaymentOptions_UnserializedMessageContext<
            UserType, PaymentOptions::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<PaymentOptions::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return PaymentOptions::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::PaymentOptions_UnserializedMessageContext<
            UserType, PaymentOptions::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<PaymentOptions::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  bool request_payer_name;
  
  bool request_payer_email;
  
  bool request_payer_phone;
  
  bool request_shipping;
  
  PaymentShippingType shipping_type;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, PaymentOptions::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, PaymentOptions::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, PaymentOptions::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, PaymentOptions::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
PaymentResponsePtr PaymentResponse::Clone() const {
  return New(
      mojo::Clone(method_name),
      mojo::Clone(stringified_details),
      mojo::Clone(shipping_address),
      mojo::Clone(shipping_option),
      mojo::Clone(payer),
      mojo::Clone(get_assertion_authenticator_response)
  );
}

template <typename T, PaymentResponse::EnableIfSame<T>*>
bool PaymentResponse::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->method_name, other_struct.method_name))
    return false;
  if (!mojo::Equals(this->stringified_details, other_struct.stringified_details))
    return false;
  if (!mojo::Equals(this->shipping_address, other_struct.shipping_address))
    return false;
  if (!mojo::Equals(this->shipping_option, other_struct.shipping_option))
    return false;
  if (!mojo::Equals(this->payer, other_struct.payer))
    return false;
  if (!mojo::Equals(this->get_assertion_authenticator_response, other_struct.get_assertion_authenticator_response))
    return false;
  return true;
}

template <typename T, PaymentResponse::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.method_name < rhs.method_name)
    return true;
  if (rhs.method_name < lhs.method_name)
    return false;
  if (lhs.stringified_details < rhs.stringified_details)
    return true;
  if (rhs.stringified_details < lhs.stringified_details)
    return false;
  if (lhs.shipping_address < rhs.shipping_address)
    return true;
  if (rhs.shipping_address < lhs.shipping_address)
    return false;
  if (lhs.shipping_option < rhs.shipping_option)
    return true;
  if (rhs.shipping_option < lhs.shipping_option)
    return false;
  if (lhs.payer < rhs.payer)
    return true;
  if (rhs.payer < lhs.payer)
    return false;
  if (lhs.get_assertion_authenticator_response < rhs.get_assertion_authenticator_response)
    return true;
  if (rhs.get_assertion_authenticator_response < lhs.get_assertion_authenticator_response)
    return false;
  return false;
}
template <typename StructPtrType>
PayerDetailPtr PayerDetail::Clone() const {
  return New(
      mojo::Clone(email),
      mojo::Clone(name),
      mojo::Clone(phone)
  );
}

template <typename T, PayerDetail::EnableIfSame<T>*>
bool PayerDetail::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->email, other_struct.email))
    return false;
  if (!mojo::Equals(this->name, other_struct.name))
    return false;
  if (!mojo::Equals(this->phone, other_struct.phone))
    return false;
  return true;
}

template <typename T, PayerDetail::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.email < rhs.email)
    return true;
  if (rhs.email < lhs.email)
    return false;
  if (lhs.name < rhs.name)
    return true;
  if (rhs.name < lhs.name)
    return false;
  if (lhs.phone < rhs.phone)
    return true;
  if (rhs.phone < lhs.phone)
    return false;
  return false;
}
template <typename StructPtrType>
PaymentItemPtr PaymentItem::Clone() const {
  return New(
      mojo::Clone(label),
      mojo::Clone(amount),
      mojo::Clone(pending)
  );
}

template <typename T, PaymentItem::EnableIfSame<T>*>
bool PaymentItem::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->label, other_struct.label))
    return false;
  if (!mojo::Equals(this->amount, other_struct.amount))
    return false;
  if (!mojo::Equals(this->pending, other_struct.pending))
    return false;
  return true;
}

template <typename T, PaymentItem::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.label < rhs.label)
    return true;
  if (rhs.label < lhs.label)
    return false;
  if (lhs.amount < rhs.amount)
    return true;
  if (rhs.amount < lhs.amount)
    return false;
  if (lhs.pending < rhs.pending)
    return true;
  if (rhs.pending < lhs.pending)
    return false;
  return false;
}
template <typename StructPtrType>
PaymentShippingOptionPtr PaymentShippingOption::Clone() const {
  return New(
      mojo::Clone(id),
      mojo::Clone(label),
      mojo::Clone(amount),
      mojo::Clone(selected)
  );
}

template <typename T, PaymentShippingOption::EnableIfSame<T>*>
bool PaymentShippingOption::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->id, other_struct.id))
    return false;
  if (!mojo::Equals(this->label, other_struct.label))
    return false;
  if (!mojo::Equals(this->amount, other_struct.amount))
    return false;
  if (!mojo::Equals(this->selected, other_struct.selected))
    return false;
  return true;
}

template <typename T, PaymentShippingOption::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.id < rhs.id)
    return true;
  if (rhs.id < lhs.id)
    return false;
  if (lhs.label < rhs.label)
    return true;
  if (rhs.label < lhs.label)
    return false;
  if (lhs.amount < rhs.amount)
    return true;
  if (rhs.amount < lhs.amount)
    return false;
  if (lhs.selected < rhs.selected)
    return true;
  if (rhs.selected < lhs.selected)
    return false;
  return false;
}
template <typename StructPtrType>
SecurePaymentConfirmationRequestPtr SecurePaymentConfirmationRequest::Clone() const {
  return New(
      mojo::Clone(credential_ids),
      mojo::Clone(challenge),
      mojo::Clone(instrument),
      mojo::Clone(timeout),
      mojo::Clone(payee_origin),
      mojo::Clone(payee_name),
      mojo::Clone(rp_id),
      mojo::Clone(extensions),
      mojo::Clone(browser_bound_pub_key_cred_params),
      mojo::Clone(show_opt_out),
      mojo::Clone(payment_entities_logos)
  );
}

template <typename T, SecurePaymentConfirmationRequest::EnableIfSame<T>*>
bool SecurePaymentConfirmationRequest::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->credential_ids, other_struct.credential_ids))
    return false;
  if (!mojo::Equals(this->challenge, other_struct.challenge))
    return false;
  if (!mojo::Equals(this->instrument, other_struct.instrument))
    return false;
  if (!mojo::Equals(this->timeout, other_struct.timeout))
    return false;
  if (!mojo::Equals(this->payee_origin, other_struct.payee_origin))
    return false;
  if (!mojo::Equals(this->payee_name, other_struct.payee_name))
    return false;
  if (!mojo::Equals(this->rp_id, other_struct.rp_id))
    return false;
  if (!mojo::Equals(this->extensions, other_struct.extensions))
    return false;
  if (!mojo::Equals(this->browser_bound_pub_key_cred_params, other_struct.browser_bound_pub_key_cred_params))
    return false;
  if (!mojo::Equals(this->show_opt_out, other_struct.show_opt_out))
    return false;
  if (!mojo::Equals(this->payment_entities_logos, other_struct.payment_entities_logos))
    return false;
  return true;
}

template <typename T, SecurePaymentConfirmationRequest::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.credential_ids < rhs.credential_ids)
    return true;
  if (rhs.credential_ids < lhs.credential_ids)
    return false;
  if (lhs.challenge < rhs.challenge)
    return true;
  if (rhs.challenge < lhs.challenge)
    return false;
  if (lhs.instrument < rhs.instrument)
    return true;
  if (rhs.instrument < lhs.instrument)
    return false;
  if (lhs.timeout < rhs.timeout)
    return true;
  if (rhs.timeout < lhs.timeout)
    return false;
  if (lhs.payee_origin < rhs.payee_origin)
    return true;
  if (rhs.payee_origin < lhs.payee_origin)
    return false;
  if (lhs.payee_name < rhs.payee_name)
    return true;
  if (rhs.payee_name < lhs.payee_name)
    return false;
  if (lhs.rp_id < rhs.rp_id)
    return true;
  if (rhs.rp_id < lhs.rp_id)
    return false;
  if (lhs.extensions < rhs.extensions)
    return true;
  if (rhs.extensions < lhs.extensions)
    return false;
  if (lhs.browser_bound_pub_key_cred_params < rhs.browser_bound_pub_key_cred_params)
    return true;
  if (rhs.browser_bound_pub_key_cred_params < lhs.browser_bound_pub_key_cred_params)
    return false;
  if (lhs.show_opt_out < rhs.show_opt_out)
    return true;
  if (rhs.show_opt_out < lhs.show_opt_out)
    return false;
  if (lhs.payment_entities_logos < rhs.payment_entities_logos)
    return true;
  if (rhs.payment_entities_logos < lhs.payment_entities_logos)
    return false;
  return false;
}
template <typename StructPtrType>
NetworkOrIssuerInformationPtr NetworkOrIssuerInformation::Clone() const {
  return New(
      mojo::Clone(name),
      mojo::Clone(icon)
  );
}

template <typename T, NetworkOrIssuerInformation::EnableIfSame<T>*>
bool NetworkOrIssuerInformation::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->name, other_struct.name))
    return false;
  if (!mojo::Equals(this->icon, other_struct.icon))
    return false;
  return true;
}

template <typename T, NetworkOrIssuerInformation::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.name < rhs.name)
    return true;
  if (rhs.name < lhs.name)
    return false;
  if (lhs.icon < rhs.icon)
    return true;
  if (rhs.icon < lhs.icon)
    return false;
  return false;
}
template <typename StructPtrType>
PaymentEntityLogoPtr PaymentEntityLogo::Clone() const {
  return New(
      mojo::Clone(url),
      mojo::Clone(label)
  );
}

template <typename T, PaymentEntityLogo::EnableIfSame<T>*>
bool PaymentEntityLogo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->url, other_struct.url))
    return false;
  if (!mojo::Equals(this->label, other_struct.label))
    return false;
  return true;
}

template <typename T, PaymentEntityLogo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.url < rhs.url)
    return true;
  if (rhs.url < lhs.url)
    return false;
  if (lhs.label < rhs.label)
    return true;
  if (rhs.label < lhs.label)
    return false;
  return false;
}
template <typename StructPtrType>
PaymentMethodDataPtr PaymentMethodData::Clone() const {
  return New(
      mojo::Clone(supported_method),
      mojo::Clone(stringified_data),
      mojo::Clone(environment),
      mojo::Clone(min_google_play_services_version),
      mojo::Clone(api_version),
      mojo::Clone(supported_networks),
      mojo::Clone(secure_payment_confirmation)
  );
}

template <typename T, PaymentMethodData::EnableIfSame<T>*>
bool PaymentMethodData::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->supported_method, other_struct.supported_method))
    return false;
  if (!mojo::Equals(this->stringified_data, other_struct.stringified_data))
    return false;
  if (!mojo::Equals(this->environment, other_struct.environment))
    return false;
  if (!mojo::Equals(this->min_google_play_services_version, other_struct.min_google_play_services_version))
    return false;
  if (!mojo::Equals(this->api_version, other_struct.api_version))
    return false;
  if (!mojo::Equals(this->supported_networks, other_struct.supported_networks))
    return false;
  if (!mojo::Equals(this->secure_payment_confirmation, other_struct.secure_payment_confirmation))
    return false;
  return true;
}

template <typename T, PaymentMethodData::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.supported_method < rhs.supported_method)
    return true;
  if (rhs.supported_method < lhs.supported_method)
    return false;
  if (lhs.stringified_data < rhs.stringified_data)
    return true;
  if (rhs.stringified_data < lhs.stringified_data)
    return false;
  if (lhs.environment < rhs.environment)
    return true;
  if (rhs.environment < lhs.environment)
    return false;
  if (lhs.min_google_play_services_version < rhs.min_google_play_services_version)
    return true;
  if (rhs.min_google_play_services_version < lhs.min_google_play_services_version)
    return false;
  if (lhs.api_version < rhs.api_version)
    return true;
  if (rhs.api_version < lhs.api_version)
    return false;
  if (lhs.supported_networks < rhs.supported_networks)
    return true;
  if (rhs.supported_networks < lhs.supported_networks)
    return false;
  if (lhs.secure_payment_confirmation < rhs.secure_payment_confirmation)
    return true;
  if (rhs.secure_payment_confirmation < lhs.secure_payment_confirmation)
    return false;
  return false;
}
template <typename StructPtrType>
PaymentDetailsModifierPtr PaymentDetailsModifier::Clone() const {
  return New(
      mojo::Clone(total),
      mojo::Clone(additional_display_items),
      mojo::Clone(method_data)
  );
}

template <typename T, PaymentDetailsModifier::EnableIfSame<T>*>
bool PaymentDetailsModifier::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->total, other_struct.total))
    return false;
  if (!mojo::Equals(this->additional_display_items, other_struct.additional_display_items))
    return false;
  if (!mojo::Equals(this->method_data, other_struct.method_data))
    return false;
  return true;
}

template <typename T, PaymentDetailsModifier::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.total < rhs.total)
    return true;
  if (rhs.total < lhs.total)
    return false;
  if (lhs.additional_display_items < rhs.additional_display_items)
    return true;
  if (rhs.additional_display_items < lhs.additional_display_items)
    return false;
  if (lhs.method_data < rhs.method_data)
    return true;
  if (rhs.method_data < lhs.method_data)
    return false;
  return false;
}
template <typename StructPtrType>
PaymentDetailsPtr PaymentDetails::Clone() const {
  return New(
      mojo::Clone(total),
      mojo::Clone(display_items),
      mojo::Clone(shipping_options),
      mojo::Clone(modifiers),
      mojo::Clone(error),
      mojo::Clone(shipping_address_errors),
      mojo::Clone(id),
      mojo::Clone(stringified_payment_method_errors)
  );
}

template <typename T, PaymentDetails::EnableIfSame<T>*>
bool PaymentDetails::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->total, other_struct.total))
    return false;
  if (!mojo::Equals(this->display_items, other_struct.display_items))
    return false;
  if (!mojo::Equals(this->shipping_options, other_struct.shipping_options))
    return false;
  if (!mojo::Equals(this->modifiers, other_struct.modifiers))
    return false;
  if (!mojo::Equals(this->error, other_struct.error))
    return false;
  if (!mojo::Equals(this->shipping_address_errors, other_struct.shipping_address_errors))
    return false;
  if (!mojo::Equals(this->id, other_struct.id))
    return false;
  if (!mojo::Equals(this->stringified_payment_method_errors, other_struct.stringified_payment_method_errors))
    return false;
  return true;
}

template <typename T, PaymentDetails::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.total < rhs.total)
    return true;
  if (rhs.total < lhs.total)
    return false;
  if (lhs.display_items < rhs.display_items)
    return true;
  if (rhs.display_items < lhs.display_items)
    return false;
  if (lhs.shipping_options < rhs.shipping_options)
    return true;
  if (rhs.shipping_options < lhs.shipping_options)
    return false;
  if (lhs.modifiers < rhs.modifiers)
    return true;
  if (rhs.modifiers < lhs.modifiers)
    return false;
  if (lhs.error < rhs.error)
    return true;
  if (rhs.error < lhs.error)
    return false;
  if (lhs.shipping_address_errors < rhs.shipping_address_errors)
    return true;
  if (rhs.shipping_address_errors < lhs.shipping_address_errors)
    return false;
  if (lhs.id < rhs.id)
    return true;
  if (rhs.id < lhs.id)
    return false;
  if (lhs.stringified_payment_method_errors < rhs.stringified_payment_method_errors)
    return true;
  if (rhs.stringified_payment_method_errors < lhs.stringified_payment_method_errors)
    return false;
  return false;
}
template <typename StructPtrType>
PaymentOptionsPtr PaymentOptions::Clone() const {
  return New(
      mojo::Clone(request_payer_name),
      mojo::Clone(request_payer_email),
      mojo::Clone(request_payer_phone),
      mojo::Clone(request_shipping),
      mojo::Clone(shipping_type)
  );
}

template <typename T, PaymentOptions::EnableIfSame<T>*>
bool PaymentOptions::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->request_payer_name, other_struct.request_payer_name))
    return false;
  if (!mojo::Equals(this->request_payer_email, other_struct.request_payer_email))
    return false;
  if (!mojo::Equals(this->request_payer_phone, other_struct.request_payer_phone))
    return false;
  if (!mojo::Equals(this->request_shipping, other_struct.request_shipping))
    return false;
  if (!mojo::Equals(this->shipping_type, other_struct.shipping_type))
    return false;
  return true;
}

template <typename T, PaymentOptions::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.request_payer_name < rhs.request_payer_name)
    return true;
  if (rhs.request_payer_name < lhs.request_payer_name)
    return false;
  if (lhs.request_payer_email < rhs.request_payer_email)
    return true;
  if (rhs.request_payer_email < lhs.request_payer_email)
    return false;
  if (lhs.request_payer_phone < rhs.request_payer_phone)
    return true;
  if (rhs.request_payer_phone < lhs.request_payer_phone)
    return false;
  if (lhs.request_shipping < rhs.request_shipping)
    return true;
  if (rhs.request_shipping < lhs.request_shipping)
    return false;
  if (lhs.shipping_type < rhs.shipping_type)
    return true;
  if (rhs.shipping_type < lhs.shipping_type)
    return false;
  return false;
}


}  // payments::mojom

namespace mojo {


template <>
struct BLINK_COMMON_EXPORT StructTraits<::payments::mojom::PaymentResponse::DataView,
                                         ::payments::mojom::PaymentResponsePtr> {
  static bool IsNull(const ::payments::mojom::PaymentResponsePtr& input) { return !input; }
  static void SetToNull(::payments::mojom::PaymentResponsePtr* output) { output->reset(); }

  static const decltype(::payments::mojom::PaymentResponse::method_name)& method_name(
      const ::payments::mojom::PaymentResponsePtr& input) {
    return input->method_name;
  }

  static const decltype(::payments::mojom::PaymentResponse::stringified_details)& stringified_details(
      const ::payments::mojom::PaymentResponsePtr& input) {
    return input->stringified_details;
  }

  static const decltype(::payments::mojom::PaymentResponse::shipping_address)& shipping_address(
      const ::payments::mojom::PaymentResponsePtr& input) {
    return input->shipping_address;
  }

  static const decltype(::payments::mojom::PaymentResponse::shipping_option)& shipping_option(
      const ::payments::mojom::PaymentResponsePtr& input) {
    return input->shipping_option;
  }

  static const decltype(::payments::mojom::PaymentResponse::payer)& payer(
      const ::payments::mojom::PaymentResponsePtr& input) {
    return input->payer;
  }

  static const decltype(::payments::mojom::PaymentResponse::get_assertion_authenticator_response)& get_assertion_authenticator_response(
      const ::payments::mojom::PaymentResponsePtr& input) {
    return input->get_assertion_authenticator_response;
  }

  static bool Read(::payments::mojom::PaymentResponse::DataView input, ::payments::mojom::PaymentResponsePtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::payments::mojom::PayerDetail::DataView,
                                         ::payments::mojom::PayerDetailPtr> {
  static bool IsNull(const ::payments::mojom::PayerDetailPtr& input) { return !input; }
  static void SetToNull(::payments::mojom::PayerDetailPtr* output) { output->reset(); }

  static const decltype(::payments::mojom::PayerDetail::email)& email(
      const ::payments::mojom::PayerDetailPtr& input) {
    return input->email;
  }

  static const decltype(::payments::mojom::PayerDetail::name)& name(
      const ::payments::mojom::PayerDetailPtr& input) {
    return input->name;
  }

  static const decltype(::payments::mojom::PayerDetail::phone)& phone(
      const ::payments::mojom::PayerDetailPtr& input) {
    return input->phone;
  }

  static bool Read(::payments::mojom::PayerDetail::DataView input, ::payments::mojom::PayerDetailPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::payments::mojom::PaymentItem::DataView,
                                         ::payments::mojom::PaymentItemPtr> {
  static bool IsNull(const ::payments::mojom::PaymentItemPtr& input) { return !input; }
  static void SetToNull(::payments::mojom::PaymentItemPtr* output) { output->reset(); }

  static const decltype(::payments::mojom::PaymentItem::label)& label(
      const ::payments::mojom::PaymentItemPtr& input) {
    return input->label;
  }

  static const decltype(::payments::mojom::PaymentItem::amount)& amount(
      const ::payments::mojom::PaymentItemPtr& input) {
    return input->amount;
  }

  static decltype(::payments::mojom::PaymentItem::pending) pending(
      const ::payments::mojom::PaymentItemPtr& input) {
    return input->pending;
  }

  static bool Read(::payments::mojom::PaymentItem::DataView input, ::payments::mojom::PaymentItemPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::payments::mojom::PaymentShippingOption::DataView,
                                         ::payments::mojom::PaymentShippingOptionPtr> {
  static bool IsNull(const ::payments::mojom::PaymentShippingOptionPtr& input) { return !input; }
  static void SetToNull(::payments::mojom::PaymentShippingOptionPtr* output) { output->reset(); }

  static const decltype(::payments::mojom::PaymentShippingOption::id)& id(
      const ::payments::mojom::PaymentShippingOptionPtr& input) {
    return input->id;
  }

  static const decltype(::payments::mojom::PaymentShippingOption::label)& label(
      const ::payments::mojom::PaymentShippingOptionPtr& input) {
    return input->label;
  }

  static const decltype(::payments::mojom::PaymentShippingOption::amount)& amount(
      const ::payments::mojom::PaymentShippingOptionPtr& input) {
    return input->amount;
  }

  static decltype(::payments::mojom::PaymentShippingOption::selected) selected(
      const ::payments::mojom::PaymentShippingOptionPtr& input) {
    return input->selected;
  }

  static bool Read(::payments::mojom::PaymentShippingOption::DataView input, ::payments::mojom::PaymentShippingOptionPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::payments::mojom::SecurePaymentConfirmationRequest::DataView,
                                         ::payments::mojom::SecurePaymentConfirmationRequestPtr> {
  static bool IsNull(const ::payments::mojom::SecurePaymentConfirmationRequestPtr& input) { return !input; }
  static void SetToNull(::payments::mojom::SecurePaymentConfirmationRequestPtr* output) { output->reset(); }

  static const decltype(::payments::mojom::SecurePaymentConfirmationRequest::credential_ids)& credential_ids(
      const ::payments::mojom::SecurePaymentConfirmationRequestPtr& input) {
    return input->credential_ids;
  }

  static const decltype(::payments::mojom::SecurePaymentConfirmationRequest::challenge)& challenge(
      const ::payments::mojom::SecurePaymentConfirmationRequestPtr& input) {
    return input->challenge;
  }

  static const decltype(::payments::mojom::SecurePaymentConfirmationRequest::instrument)& instrument(
      const ::payments::mojom::SecurePaymentConfirmationRequestPtr& input) {
    return input->instrument;
  }

  static const decltype(::payments::mojom::SecurePaymentConfirmationRequest::timeout)& timeout(
      const ::payments::mojom::SecurePaymentConfirmationRequestPtr& input) {
    return input->timeout;
  }

  static const decltype(::payments::mojom::SecurePaymentConfirmationRequest::payee_origin)& payee_origin(
      const ::payments::mojom::SecurePaymentConfirmationRequestPtr& input) {
    return input->payee_origin;
  }

  static const decltype(::payments::mojom::SecurePaymentConfirmationRequest::payee_name)& payee_name(
      const ::payments::mojom::SecurePaymentConfirmationRequestPtr& input) {
    return input->payee_name;
  }

  static const decltype(::payments::mojom::SecurePaymentConfirmationRequest::rp_id)& rp_id(
      const ::payments::mojom::SecurePaymentConfirmationRequestPtr& input) {
    return input->rp_id;
  }

  static const decltype(::payments::mojom::SecurePaymentConfirmationRequest::extensions)& extensions(
      const ::payments::mojom::SecurePaymentConfirmationRequestPtr& input) {
    return input->extensions;
  }

  static const decltype(::payments::mojom::SecurePaymentConfirmationRequest::browser_bound_pub_key_cred_params)& browser_bound_pub_key_cred_params(
      const ::payments::mojom::SecurePaymentConfirmationRequestPtr& input) {
    return input->browser_bound_pub_key_cred_params;
  }

  static decltype(::payments::mojom::SecurePaymentConfirmationRequest::show_opt_out) show_opt_out(
      const ::payments::mojom::SecurePaymentConfirmationRequestPtr& input) {
    return input->show_opt_out;
  }

  static const decltype(::payments::mojom::SecurePaymentConfirmationRequest::payment_entities_logos)& payment_entities_logos(
      const ::payments::mojom::SecurePaymentConfirmationRequestPtr& input) {
    return input->payment_entities_logos;
  }

  static bool Read(::payments::mojom::SecurePaymentConfirmationRequest::DataView input, ::payments::mojom::SecurePaymentConfirmationRequestPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::payments::mojom::NetworkOrIssuerInformation::DataView,
                                         ::payments::mojom::NetworkOrIssuerInformationPtr> {
  static bool IsNull(const ::payments::mojom::NetworkOrIssuerInformationPtr& input) { return !input; }
  static void SetToNull(::payments::mojom::NetworkOrIssuerInformationPtr* output) { output->reset(); }

  static const decltype(::payments::mojom::NetworkOrIssuerInformation::name)& name(
      const ::payments::mojom::NetworkOrIssuerInformationPtr& input) {
    return input->name;
  }

  static const decltype(::payments::mojom::NetworkOrIssuerInformation::icon)& icon(
      const ::payments::mojom::NetworkOrIssuerInformationPtr& input) {
    return input->icon;
  }

  static bool Read(::payments::mojom::NetworkOrIssuerInformation::DataView input, ::payments::mojom::NetworkOrIssuerInformationPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::payments::mojom::PaymentEntityLogo::DataView,
                                         ::payments::mojom::PaymentEntityLogoPtr> {
  static bool IsNull(const ::payments::mojom::PaymentEntityLogoPtr& input) { return !input; }
  static void SetToNull(::payments::mojom::PaymentEntityLogoPtr* output) { output->reset(); }

  static const decltype(::payments::mojom::PaymentEntityLogo::url)& url(
      const ::payments::mojom::PaymentEntityLogoPtr& input) {
    return input->url;
  }

  static const decltype(::payments::mojom::PaymentEntityLogo::label)& label(
      const ::payments::mojom::PaymentEntityLogoPtr& input) {
    return input->label;
  }

  static bool Read(::payments::mojom::PaymentEntityLogo::DataView input, ::payments::mojom::PaymentEntityLogoPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::payments::mojom::PaymentMethodData::DataView,
                                         ::payments::mojom::PaymentMethodDataPtr> {
  static bool IsNull(const ::payments::mojom::PaymentMethodDataPtr& input) { return !input; }
  static void SetToNull(::payments::mojom::PaymentMethodDataPtr* output) { output->reset(); }

  static const decltype(::payments::mojom::PaymentMethodData::supported_method)& supported_method(
      const ::payments::mojom::PaymentMethodDataPtr& input) {
    return input->supported_method;
  }

  static const decltype(::payments::mojom::PaymentMethodData::stringified_data)& stringified_data(
      const ::payments::mojom::PaymentMethodDataPtr& input) {
    return input->stringified_data;
  }

  static decltype(::payments::mojom::PaymentMethodData::environment) environment(
      const ::payments::mojom::PaymentMethodDataPtr& input) {
    return input->environment;
  }

  static decltype(::payments::mojom::PaymentMethodData::min_google_play_services_version) min_google_play_services_version(
      const ::payments::mojom::PaymentMethodDataPtr& input) {
    return input->min_google_play_services_version;
  }

  static decltype(::payments::mojom::PaymentMethodData::api_version) api_version(
      const ::payments::mojom::PaymentMethodDataPtr& input) {
    return input->api_version;
  }

  static const decltype(::payments::mojom::PaymentMethodData::supported_networks)& supported_networks(
      const ::payments::mojom::PaymentMethodDataPtr& input) {
    return input->supported_networks;
  }

  static const decltype(::payments::mojom::PaymentMethodData::secure_payment_confirmation)& secure_payment_confirmation(
      const ::payments::mojom::PaymentMethodDataPtr& input) {
    return input->secure_payment_confirmation;
  }

  static bool Read(::payments::mojom::PaymentMethodData::DataView input, ::payments::mojom::PaymentMethodDataPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::payments::mojom::PaymentDetailsModifier::DataView,
                                         ::payments::mojom::PaymentDetailsModifierPtr> {
  static bool IsNull(const ::payments::mojom::PaymentDetailsModifierPtr& input) { return !input; }
  static void SetToNull(::payments::mojom::PaymentDetailsModifierPtr* output) { output->reset(); }

  static const decltype(::payments::mojom::PaymentDetailsModifier::total)& total(
      const ::payments::mojom::PaymentDetailsModifierPtr& input) {
    return input->total;
  }

  static const decltype(::payments::mojom::PaymentDetailsModifier::additional_display_items)& additional_display_items(
      const ::payments::mojom::PaymentDetailsModifierPtr& input) {
    return input->additional_display_items;
  }

  static const decltype(::payments::mojom::PaymentDetailsModifier::method_data)& method_data(
      const ::payments::mojom::PaymentDetailsModifierPtr& input) {
    return input->method_data;
  }

  static bool Read(::payments::mojom::PaymentDetailsModifier::DataView input, ::payments::mojom::PaymentDetailsModifierPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::payments::mojom::PaymentDetails::DataView,
                                         ::payments::mojom::PaymentDetailsPtr> {
  static bool IsNull(const ::payments::mojom::PaymentDetailsPtr& input) { return !input; }
  static void SetToNull(::payments::mojom::PaymentDetailsPtr* output) { output->reset(); }

  static const decltype(::payments::mojom::PaymentDetails::total)& total(
      const ::payments::mojom::PaymentDetailsPtr& input) {
    return input->total;
  }

  static const decltype(::payments::mojom::PaymentDetails::display_items)& display_items(
      const ::payments::mojom::PaymentDetailsPtr& input) {
    return input->display_items;
  }

  static const decltype(::payments::mojom::PaymentDetails::shipping_options)& shipping_options(
      const ::payments::mojom::PaymentDetailsPtr& input) {
    return input->shipping_options;
  }

  static const decltype(::payments::mojom::PaymentDetails::modifiers)& modifiers(
      const ::payments::mojom::PaymentDetailsPtr& input) {
    return input->modifiers;
  }

  static const decltype(::payments::mojom::PaymentDetails::error)& error(
      const ::payments::mojom::PaymentDetailsPtr& input) {
    return input->error;
  }

  static const decltype(::payments::mojom::PaymentDetails::shipping_address_errors)& shipping_address_errors(
      const ::payments::mojom::PaymentDetailsPtr& input) {
    return input->shipping_address_errors;
  }

  static const decltype(::payments::mojom::PaymentDetails::id)& id(
      const ::payments::mojom::PaymentDetailsPtr& input) {
    return input->id;
  }

  static const decltype(::payments::mojom::PaymentDetails::stringified_payment_method_errors)& stringified_payment_method_errors(
      const ::payments::mojom::PaymentDetailsPtr& input) {
    return input->stringified_payment_method_errors;
  }

  static bool Read(::payments::mojom::PaymentDetails::DataView input, ::payments::mojom::PaymentDetailsPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::payments::mojom::PaymentOptions::DataView,
                                         ::payments::mojom::PaymentOptionsPtr> {
  static bool IsNull(const ::payments::mojom::PaymentOptionsPtr& input) { return !input; }
  static void SetToNull(::payments::mojom::PaymentOptionsPtr* output) { output->reset(); }

  static decltype(::payments::mojom::PaymentOptions::request_payer_name) request_payer_name(
      const ::payments::mojom::PaymentOptionsPtr& input) {
    return input->request_payer_name;
  }

  static decltype(::payments::mojom::PaymentOptions::request_payer_email) request_payer_email(
      const ::payments::mojom::PaymentOptionsPtr& input) {
    return input->request_payer_email;
  }

  static decltype(::payments::mojom::PaymentOptions::request_payer_phone) request_payer_phone(
      const ::payments::mojom::PaymentOptionsPtr& input) {
    return input->request_payer_phone;
  }

  static decltype(::payments::mojom::PaymentOptions::request_shipping) request_shipping(
      const ::payments::mojom::PaymentOptionsPtr& input) {
    return input->request_shipping;
  }

  static decltype(::payments::mojom::PaymentOptions::shipping_type) shipping_type(
      const ::payments::mojom::PaymentOptionsPtr& input) {
    return input->shipping_type;
  }

  static bool Read(::payments::mojom::PaymentOptions::DataView input, ::payments::mojom::PaymentOptionsPtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_PAYMENTS_PAYMENT_REQUEST_MOJOM_H_