// third_party/blink/public/mojom/payments/payment_request.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_PAYMENTS_PAYMENT_REQUEST_MOJOM_SEND_VALIDATION_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_PAYMENTS_PAYMENT_REQUEST_MOJOM_SEND_VALIDATION_H_

#include "third_party/blink/public/mojom/payments/payment_request.mojom-shared-internal.h"
#include "components/payments/mojom/payment_request_data.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "third_party/blink/public/mojom/payments/secure_payment_confirmation_service.mojom-shared.h"
#include "url/mojom/origin.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"
#include "third_party/blink/public/mojom/webauthn/authenticator.mojom-shared.h"

#include "third_party/blink/public/mojom/payments/payment_request.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization_send_validation.h"
#include "mojo/public/cpp/bindings/lib/has_send_validation_helper.h"

namespace mojo::internal {
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::payments::mojom::PaymentErrorReason, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::payments::mojom::CanMakePaymentQueryResult, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::payments::mojom::HasEnrolledInstrumentQueryResult, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::payments::mojom::AndroidPayEnvironment, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::payments::mojom::BasicCardNetwork, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::payments::mojom::PaymentShippingType, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::payments::mojom::PaymentComplete, MaybeConstUserType>
    : std::false_type {};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::payments::mojom::PaymentResponseDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::payments::mojom::PaymentResponseDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::payments::mojom::internal::PaymentResponse_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::method_name(input)) in_method_name = Traits::method_name(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->method_name)::BaseType> method_name_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_method_name,
        method_name_fragment);

      fragment->method_name.Set(
          method_name_fragment.is_null() ? nullptr : method_name_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->method_name.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null method_name in PaymentResponse struct");

      decltype(Traits::stringified_details(input)) in_stringified_details = Traits::stringified_details(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->stringified_details)::BaseType> stringified_details_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_stringified_details,
        stringified_details_fragment);

      fragment->stringified_details.Set(
          stringified_details_fragment.is_null() ? nullptr : stringified_details_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->stringified_details.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null stringified_details in PaymentResponse struct");

      decltype(Traits::shipping_address(input)) in_shipping_address = Traits::shipping_address(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->shipping_address)::BaseType> shipping_address_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::payments::mojom::PaymentAddressDataView, send_validation>(
        in_shipping_address,
        shipping_address_fragment);

      fragment->shipping_address.Set(
          shipping_address_fragment.is_null() ? nullptr : shipping_address_fragment.data());

      decltype(Traits::shipping_option(input)) in_shipping_option = Traits::shipping_option(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->shipping_option)::BaseType> shipping_option_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_shipping_option,
        shipping_option_fragment);

      fragment->shipping_option.Set(
          shipping_option_fragment.is_null() ? nullptr : shipping_option_fragment.data());

      decltype(Traits::payer(input)) in_payer = Traits::payer(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->payer)::BaseType> payer_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::payments::mojom::PayerDetailDataView, send_validation>(
        in_payer,
        payer_fragment);

      fragment->payer.Set(
          payer_fragment.is_null() ? nullptr : payer_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->payer.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null payer in PaymentResponse struct");

      decltype(Traits::get_assertion_authenticator_response(input)) in_get_assertion_authenticator_response = Traits::get_assertion_authenticator_response(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->get_assertion_authenticator_response)::BaseType> get_assertion_authenticator_response_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::blink::mojom::GetAssertionAuthenticatorResponseDataView, send_validation>(
        in_get_assertion_authenticator_response,
        get_assertion_authenticator_response_fragment);

      fragment->get_assertion_authenticator_response.Set(
          get_assertion_authenticator_response_fragment.is_null() ? nullptr : get_assertion_authenticator_response_fragment.data());
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::payments::mojom::PayerDetailDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::payments::mojom::PayerDetailDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::payments::mojom::internal::PayerDetail_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::email(input)) in_email = Traits::email(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->email)::BaseType> email_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_email,
        email_fragment);

      fragment->email.Set(
          email_fragment.is_null() ? nullptr : email_fragment.data());

      decltype(Traits::name(input)) in_name = Traits::name(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->name)::BaseType> name_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_name,
        name_fragment);

      fragment->name.Set(
          name_fragment.is_null() ? nullptr : name_fragment.data());

      decltype(Traits::phone(input)) in_phone = Traits::phone(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->phone)::BaseType> phone_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_phone,
        phone_fragment);

      fragment->phone.Set(
          phone_fragment.is_null() ? nullptr : phone_fragment.data());
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::payments::mojom::PaymentItemDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::payments::mojom::PaymentItemDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::payments::mojom::internal::PaymentItem_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::label(input)) in_label = Traits::label(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->label)::BaseType> label_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_label,
        label_fragment);

      fragment->label.Set(
          label_fragment.is_null() ? nullptr : label_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->label.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null label in PaymentItem struct");

      decltype(Traits::amount(input)) in_amount = Traits::amount(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->amount)::BaseType> amount_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::payments::mojom::PaymentCurrencyAmountDataView, send_validation>(
        in_amount,
        amount_fragment);

      fragment->amount.Set(
          amount_fragment.is_null() ? nullptr : amount_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->amount.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null amount in PaymentItem struct");

      fragment->pending = Traits::pending(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::payments::mojom::PaymentShippingOptionDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::payments::mojom::PaymentShippingOptionDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::payments::mojom::internal::PaymentShippingOption_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::id(input)) in_id = Traits::id(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->id)::BaseType> id_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_id,
        id_fragment);

      fragment->id.Set(
          id_fragment.is_null() ? nullptr : id_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->id.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null id in PaymentShippingOption struct");

      decltype(Traits::label(input)) in_label = Traits::label(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->label)::BaseType> label_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_label,
        label_fragment);

      fragment->label.Set(
          label_fragment.is_null() ? nullptr : label_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->label.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null label in PaymentShippingOption struct");

      decltype(Traits::amount(input)) in_amount = Traits::amount(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->amount)::BaseType> amount_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::payments::mojom::PaymentCurrencyAmountDataView, send_validation>(
        in_amount,
        amount_fragment);

      fragment->amount.Set(
          amount_fragment.is_null() ? nullptr : amount_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->amount.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null amount in PaymentShippingOption struct");

      fragment->selected = Traits::selected(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::payments::mojom::SecurePaymentConfirmationRequestDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::payments::mojom::SecurePaymentConfirmationRequestDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::payments::mojom::internal::SecurePaymentConfirmationRequest_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::credential_ids(input)) in_credential_ids = Traits::credential_ids(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->credential_ids)::BaseType>
          credential_ids_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& credential_ids_validate_params =
          mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<mojo::ArrayDataView<uint8_t>>, send_validation>(
        in_credential_ids,
        credential_ids_fragment,
        &credential_ids_validate_params);

      fragment->credential_ids.Set(
          credential_ids_fragment.is_null() ? nullptr : credential_ids_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->credential_ids.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null credential_ids in SecurePaymentConfirmationRequest struct");

      decltype(Traits::challenge(input)) in_challenge = Traits::challenge(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->challenge)::BaseType>
          challenge_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& challenge_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>, send_validation>(
        in_challenge,
        challenge_fragment,
        &challenge_validate_params);

      fragment->challenge.Set(
          challenge_fragment.is_null() ? nullptr : challenge_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->challenge.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null challenge in SecurePaymentConfirmationRequest struct");

      decltype(Traits::instrument(input)) in_instrument = Traits::instrument(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->instrument)::BaseType> instrument_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::blink::mojom::PaymentCredentialInstrumentDataView, send_validation>(
        in_instrument,
        instrument_fragment);

      fragment->instrument.Set(
          instrument_fragment.is_null() ? nullptr : instrument_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->instrument.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null instrument in SecurePaymentConfirmationRequest struct");

      decltype(Traits::timeout(input)) in_timeout = Traits::timeout(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->timeout)::BaseType> timeout_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView, send_validation>(
        in_timeout,
        timeout_fragment);

      fragment->timeout.Set(
          timeout_fragment.is_null() ? nullptr : timeout_fragment.data());

      decltype(Traits::payee_origin(input)) in_payee_origin = Traits::payee_origin(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->payee_origin)::BaseType> payee_origin_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::url::mojom::OriginDataView, send_validation>(
        in_payee_origin,
        payee_origin_fragment);

      fragment->payee_origin.Set(
          payee_origin_fragment.is_null() ? nullptr : payee_origin_fragment.data());

      decltype(Traits::payee_name(input)) in_payee_name = Traits::payee_name(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->payee_name)::BaseType> payee_name_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_payee_name,
        payee_name_fragment);

      fragment->payee_name.Set(
          payee_name_fragment.is_null() ? nullptr : payee_name_fragment.data());

      decltype(Traits::rp_id(input)) in_rp_id = Traits::rp_id(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->rp_id)::BaseType> rp_id_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_rp_id,
        rp_id_fragment);

      fragment->rp_id.Set(
          rp_id_fragment.is_null() ? nullptr : rp_id_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->rp_id.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null rp_id in SecurePaymentConfirmationRequest struct");

      decltype(Traits::extensions(input)) in_extensions = Traits::extensions(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->extensions)::BaseType> extensions_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::blink::mojom::AuthenticationExtensionsClientInputsDataView, send_validation>(
        in_extensions,
        extensions_fragment);

      fragment->extensions.Set(
          extensions_fragment.is_null() ? nullptr : extensions_fragment.data());

      decltype(Traits::browser_bound_pub_key_cred_params(input)) in_browser_bound_pub_key_cred_params = Traits::browser_bound_pub_key_cred_params(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->browser_bound_pub_key_cred_params)::BaseType>
          browser_bound_pub_key_cred_params_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& browser_bound_pub_key_cred_params_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::PublicKeyCredentialParametersDataView>, send_validation>(
        in_browser_bound_pub_key_cred_params,
        browser_bound_pub_key_cred_params_fragment,
        &browser_bound_pub_key_cred_params_validate_params);

      fragment->browser_bound_pub_key_cred_params.Set(
          browser_bound_pub_key_cred_params_fragment.is_null() ? nullptr : browser_bound_pub_key_cred_params_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->browser_bound_pub_key_cred_params.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null browser_bound_pub_key_cred_params in SecurePaymentConfirmationRequest struct");

      fragment->show_opt_out = Traits::show_opt_out(input);

      decltype(Traits::payment_entities_logos(input)) in_payment_entities_logos = Traits::payment_entities_logos(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->payment_entities_logos)::BaseType>
          payment_entities_logos_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& payment_entities_logos_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::payments::mojom::PaymentEntityLogoDataView>, send_validation>(
        in_payment_entities_logos,
        payment_entities_logos_fragment,
        &payment_entities_logos_validate_params);

      fragment->payment_entities_logos.Set(
          payment_entities_logos_fragment.is_null() ? nullptr : payment_entities_logos_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->payment_entities_logos.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null payment_entities_logos in SecurePaymentConfirmationRequest struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::payments::mojom::NetworkOrIssuerInformationDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::payments::mojom::NetworkOrIssuerInformationDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::payments::mojom::internal::NetworkOrIssuerInformation_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::name(input)) in_name = Traits::name(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->name)::BaseType> name_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_name,
        name_fragment);

      fragment->name.Set(
          name_fragment.is_null() ? nullptr : name_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->name.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null name in NetworkOrIssuerInformation struct");

      decltype(Traits::icon(input)) in_icon = Traits::icon(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->icon)::BaseType> icon_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::url::mojom::UrlDataView, send_validation>(
        in_icon,
        icon_fragment);

      fragment->icon.Set(
          icon_fragment.is_null() ? nullptr : icon_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->icon.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null icon in NetworkOrIssuerInformation struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::payments::mojom::PaymentEntityLogoDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::payments::mojom::PaymentEntityLogoDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::payments::mojom::internal::PaymentEntityLogo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::url(input)) in_url = Traits::url(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->url)::BaseType> url_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::url::mojom::UrlDataView, send_validation>(
        in_url,
        url_fragment);

      fragment->url.Set(
          url_fragment.is_null() ? nullptr : url_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->url.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null url in PaymentEntityLogo struct");

      decltype(Traits::label(input)) in_label = Traits::label(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->label)::BaseType> label_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_label,
        label_fragment);

      fragment->label.Set(
          label_fragment.is_null() ? nullptr : label_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->label.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null label in PaymentEntityLogo struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::payments::mojom::PaymentMethodDataDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::payments::mojom::PaymentMethodDataDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::payments::mojom::internal::PaymentMethodData_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::supported_method(input)) in_supported_method = Traits::supported_method(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->supported_method)::BaseType> supported_method_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_supported_method,
        supported_method_fragment);

      fragment->supported_method.Set(
          supported_method_fragment.is_null() ? nullptr : supported_method_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->supported_method.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null supported_method in PaymentMethodData struct");

      decltype(Traits::stringified_data(input)) in_stringified_data = Traits::stringified_data(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->stringified_data)::BaseType> stringified_data_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_stringified_data,
        stringified_data_fragment);

      fragment->stringified_data.Set(
          stringified_data_fragment.is_null() ? nullptr : stringified_data_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->stringified_data.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null stringified_data in PaymentMethodData struct");

      
      mojo::internal::Serialize<::payments::mojom::AndroidPayEnvironment>(
        Traits::environment(input),
        &fragment->environment);

      fragment->min_google_play_services_version = Traits::min_google_play_services_version(input);

      fragment->api_version = Traits::api_version(input);

      decltype(Traits::supported_networks(input)) in_supported_networks = Traits::supported_networks(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->supported_networks)::BaseType>
          supported_networks_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& supported_networks_validate_params =
          mojo::internal::GetArrayOfEnumsValidator<0, false, ::payments::mojom::internal::BasicCardNetwork_Data::Validate>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::payments::mojom::BasicCardNetwork>, send_validation>(
        in_supported_networks,
        supported_networks_fragment,
        &supported_networks_validate_params);

      fragment->supported_networks.Set(
          supported_networks_fragment.is_null() ? nullptr : supported_networks_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->supported_networks.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null supported_networks in PaymentMethodData struct");

      decltype(Traits::secure_payment_confirmation(input)) in_secure_payment_confirmation = Traits::secure_payment_confirmation(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->secure_payment_confirmation)::BaseType> secure_payment_confirmation_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::payments::mojom::SecurePaymentConfirmationRequestDataView, send_validation>(
        in_secure_payment_confirmation,
        secure_payment_confirmation_fragment);

      fragment->secure_payment_confirmation.Set(
          secure_payment_confirmation_fragment.is_null() ? nullptr : secure_payment_confirmation_fragment.data());
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::payments::mojom::PaymentDetailsModifierDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::payments::mojom::PaymentDetailsModifierDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::payments::mojom::internal::PaymentDetailsModifier_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::total(input)) in_total = Traits::total(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->total)::BaseType> total_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::payments::mojom::PaymentItemDataView, send_validation>(
        in_total,
        total_fragment);

      fragment->total.Set(
          total_fragment.is_null() ? nullptr : total_fragment.data());

      decltype(Traits::additional_display_items(input)) in_additional_display_items = Traits::additional_display_items(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->additional_display_items)::BaseType>
          additional_display_items_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& additional_display_items_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::payments::mojom::PaymentItemDataView>, send_validation>(
        in_additional_display_items,
        additional_display_items_fragment,
        &additional_display_items_validate_params);

      fragment->additional_display_items.Set(
          additional_display_items_fragment.is_null() ? nullptr : additional_display_items_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->additional_display_items.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null additional_display_items in PaymentDetailsModifier struct");

      decltype(Traits::method_data(input)) in_method_data = Traits::method_data(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->method_data)::BaseType> method_data_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::payments::mojom::PaymentMethodDataDataView, send_validation>(
        in_method_data,
        method_data_fragment);

      fragment->method_data.Set(
          method_data_fragment.is_null() ? nullptr : method_data_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->method_data.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null method_data in PaymentDetailsModifier struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::payments::mojom::PaymentDetailsDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::payments::mojom::PaymentDetailsDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::payments::mojom::internal::PaymentDetails_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::total(input)) in_total = Traits::total(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->total)::BaseType> total_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::payments::mojom::PaymentItemDataView, send_validation>(
        in_total,
        total_fragment);

      fragment->total.Set(
          total_fragment.is_null() ? nullptr : total_fragment.data());

      decltype(Traits::display_items(input)) in_display_items = Traits::display_items(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->display_items)::BaseType>
          display_items_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& display_items_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::payments::mojom::PaymentItemDataView>, send_validation>(
        in_display_items,
        display_items_fragment,
        &display_items_validate_params);

      fragment->display_items.Set(
          display_items_fragment.is_null() ? nullptr : display_items_fragment.data());

      decltype(Traits::shipping_options(input)) in_shipping_options = Traits::shipping_options(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->shipping_options)::BaseType>
          shipping_options_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& shipping_options_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::payments::mojom::PaymentShippingOptionDataView>, send_validation>(
        in_shipping_options,
        shipping_options_fragment,
        &shipping_options_validate_params);

      fragment->shipping_options.Set(
          shipping_options_fragment.is_null() ? nullptr : shipping_options_fragment.data());

      decltype(Traits::modifiers(input)) in_modifiers = Traits::modifiers(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->modifiers)::BaseType>
          modifiers_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& modifiers_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::payments::mojom::PaymentDetailsModifierDataView>, send_validation>(
        in_modifiers,
        modifiers_fragment,
        &modifiers_validate_params);

      fragment->modifiers.Set(
          modifiers_fragment.is_null() ? nullptr : modifiers_fragment.data());

      decltype(Traits::error(input)) in_error = Traits::error(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->error)::BaseType> error_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_error,
        error_fragment);

      fragment->error.Set(
          error_fragment.is_null() ? nullptr : error_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->error.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null error in PaymentDetails struct");

      decltype(Traits::shipping_address_errors(input)) in_shipping_address_errors = Traits::shipping_address_errors(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->shipping_address_errors)::BaseType> shipping_address_errors_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::payments::mojom::AddressErrorsDataView, send_validation>(
        in_shipping_address_errors,
        shipping_address_errors_fragment);

      fragment->shipping_address_errors.Set(
          shipping_address_errors_fragment.is_null() ? nullptr : shipping_address_errors_fragment.data());

      decltype(Traits::id(input)) in_id = Traits::id(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->id)::BaseType> id_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_id,
        id_fragment);

      fragment->id.Set(
          id_fragment.is_null() ? nullptr : id_fragment.data());

      decltype(Traits::stringified_payment_method_errors(input)) in_stringified_payment_method_errors = Traits::stringified_payment_method_errors(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->stringified_payment_method_errors)::BaseType> stringified_payment_method_errors_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_stringified_payment_method_errors,
        stringified_payment_method_errors_fragment);

      fragment->stringified_payment_method_errors.Set(
          stringified_payment_method_errors_fragment.is_null() ? nullptr : stringified_payment_method_errors_fragment.data());
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::payments::mojom::PaymentOptionsDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::payments::mojom::PaymentOptionsDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::payments::mojom::internal::PaymentOptions_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->request_payer_name = Traits::request_payer_name(input);

      fragment->request_payer_email = Traits::request_payer_email(input);

      fragment->request_payer_phone = Traits::request_payer_phone(input);

      fragment->request_shipping = Traits::request_shipping(input);

      
      mojo::internal::Serialize<::payments::mojom::PaymentShippingType>(
        Traits::shipping_type(input),
        &fragment->shipping_type);
  }
};

}  // namespace mojo::internal

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_PAYMENTS_PAYMENT_REQUEST_MOJOM_SEND_VALIDATION_H_