// third_party/blink/public/mojom/payments/payment_request.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_PAYMENTS_PAYMENT_REQUEST_MOJOM_DATA_VIEW_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_PAYMENTS_PAYMENT_REQUEST_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/blink/public/mojom/payments/payment_request.mojom-shared-internal.h"
#include "components/payments/mojom/payment_request_data.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "third_party/blink/public/mojom/payments/secure_payment_confirmation_service.mojom-shared.h"
#include "url/mojom/origin.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"
#include "third_party/blink/public/mojom/webauthn/authenticator.mojom-shared.h"


namespace payments::mojom {
class PaymentResponseDataView;

class PayerDetailDataView;

class PaymentItemDataView;

class PaymentShippingOptionDataView;

class SecurePaymentConfirmationRequestDataView;

class NetworkOrIssuerInformationDataView;

class PaymentEntityLogoDataView;

class PaymentMethodDataDataView;

class PaymentDetailsModifierDataView;

class PaymentDetailsDataView;

class PaymentOptionsDataView;



}  // payments::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::payments::mojom::PaymentResponseDataView> {
  using Data = ::payments::mojom::internal::PaymentResponse_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::payments::mojom::PayerDetailDataView> {
  using Data = ::payments::mojom::internal::PayerDetail_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::payments::mojom::PaymentItemDataView> {
  using Data = ::payments::mojom::internal::PaymentItem_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::payments::mojom::PaymentShippingOptionDataView> {
  using Data = ::payments::mojom::internal::PaymentShippingOption_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::payments::mojom::SecurePaymentConfirmationRequestDataView> {
  using Data = ::payments::mojom::internal::SecurePaymentConfirmationRequest_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::payments::mojom::NetworkOrIssuerInformationDataView> {
  using Data = ::payments::mojom::internal::NetworkOrIssuerInformation_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::payments::mojom::PaymentEntityLogoDataView> {
  using Data = ::payments::mojom::internal::PaymentEntityLogo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::payments::mojom::PaymentMethodDataDataView> {
  using Data = ::payments::mojom::internal::PaymentMethodData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::payments::mojom::PaymentDetailsModifierDataView> {
  using Data = ::payments::mojom::internal::PaymentDetailsModifier_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::payments::mojom::PaymentDetailsDataView> {
  using Data = ::payments::mojom::internal::PaymentDetails_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::payments::mojom::PaymentOptionsDataView> {
  using Data = ::payments::mojom::internal::PaymentOptions_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace payments::mojom {


enum class PaymentErrorReason : int32_t {
  
  UNKNOWN = 0,
  
  USER_CANCEL = 1,
  
  NOT_SUPPORTED = 2,
  
  NOT_SUPPORTED_FOR_INVALID_ORIGIN_OR_SSL = 3,
  
  ALREADY_SHOWING = 4,
  
  INVALID_DATA_FROM_RENDERER = 5,
  
  NOT_ALLOWED_ERROR = 6,
  
  USER_OPT_OUT = 7,
  
  USER_ACTIVATION_REQUIRED = 8,
  kMinValue = 0,
  kMaxValue = 8,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, PaymentErrorReason value);
inline bool IsKnownEnumValue(PaymentErrorReason value) {
  return internal::PaymentErrorReason_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class CanMakePaymentQueryResult : int32_t {
  
  CAN_MAKE_PAYMENT = 0,
  
  CANNOT_MAKE_PAYMENT = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, CanMakePaymentQueryResult value);
inline bool IsKnownEnumValue(CanMakePaymentQueryResult value) {
  return internal::CanMakePaymentQueryResult_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class HasEnrolledInstrumentQueryResult : int32_t {
  
  HAS_ENROLLED_INSTRUMENT = 0,
  
  HAS_NO_ENROLLED_INSTRUMENT = 1,
  
  QUERY_QUOTA_EXCEEDED = 2,
  
  WARNING_HAS_ENROLLED_INSTRUMENT = 3,
  
  WARNING_HAS_NO_ENROLLED_INSTRUMENT = 4,
  kMinValue = 0,
  kMaxValue = 4,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, HasEnrolledInstrumentQueryResult value);
inline bool IsKnownEnumValue(HasEnrolledInstrumentQueryResult value) {
  return internal::HasEnrolledInstrumentQueryResult_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class AndroidPayEnvironment : int32_t {
  
  PRODUCTION = 0,
  
  TEST = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, AndroidPayEnvironment value);
inline bool IsKnownEnumValue(AndroidPayEnvironment value) {
  return internal::AndroidPayEnvironment_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class BasicCardNetwork : int32_t {
  
  AMEX = 0,
  
  DINERS = 1,
  
  DISCOVER = 2,
  
  JCB = 3,
  
  MASTERCARD = 4,
  
  MIR = 5,
  
  UNIONPAY = 6,
  
  VISA = 7,
  kMinValue = 0,
  kMaxValue = 7,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, BasicCardNetwork value);
inline bool IsKnownEnumValue(BasicCardNetwork value) {
  return internal::BasicCardNetwork_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class PaymentShippingType : int32_t {
  
  SHIPPING = 0,
  
  DELIVERY = 1,
  
  PICKUP = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, PaymentShippingType value);
inline bool IsKnownEnumValue(PaymentShippingType value) {
  return internal::PaymentShippingType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class PaymentComplete : int32_t {
  
  FAIL = 0,
  
  SUCCESS = 1,
  
  UNKNOWN = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, PaymentComplete value);
inline bool IsKnownEnumValue(PaymentComplete value) {
  return internal::PaymentComplete_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class PaymentRequestClientInterfaceBase {};

using PaymentRequestClientPtrDataView =
    mojo::InterfacePtrDataView<PaymentRequestClientInterfaceBase>;
using PaymentRequestClientRequestDataView =
    mojo::InterfaceRequestDataView<PaymentRequestClientInterfaceBase>;
using PaymentRequestClientAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<PaymentRequestClientInterfaceBase>;
using PaymentRequestClientAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<PaymentRequestClientInterfaceBase>;
class PaymentRequestInterfaceBase {};

using PaymentRequestPtrDataView =
    mojo::InterfacePtrDataView<PaymentRequestInterfaceBase>;
using PaymentRequestRequestDataView =
    mojo::InterfaceRequestDataView<PaymentRequestInterfaceBase>;
using PaymentRequestAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<PaymentRequestInterfaceBase>;
using PaymentRequestAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<PaymentRequestInterfaceBase>;


class PaymentResponseDataView {
 public:
  PaymentResponseDataView() = default;

  PaymentResponseDataView(
      internal::PaymentResponse_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetMethodNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMethodName(UserType* output) {
    
    auto* pointer = data_->method_name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetStringifiedDetailsDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadStringifiedDetails(UserType* output) {
    
    auto* pointer = data_->stringified_details.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetShippingAddressDataView(
      ::payments::mojom::PaymentAddressDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadShippingAddress(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::payments::mojom::PaymentAddressDataView, UserType>(),
    "Attempting to read the optional `shipping_address` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadShippingAddress` instead "
    "of `ReadShippingAddress if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->shipping_address.Get();
    return mojo::internal::Deserialize<::payments::mojom::PaymentAddressDataView>(
        pointer, output, message_);
  }
  inline void GetShippingOptionDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadShippingOption(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `shipping_option` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadShippingOption` instead "
    "of `ReadShippingOption if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->shipping_option.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetPayerDataView(
      PayerDetailDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPayer(UserType* output) {
    
    auto* pointer = data_->payer.Get();
    return mojo::internal::Deserialize<::payments::mojom::PayerDetailDataView>(
        pointer, output, message_);
  }
  inline void GetGetAssertionAuthenticatorResponseDataView(
      ::blink::mojom::GetAssertionAuthenticatorResponseDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadGetAssertionAuthenticatorResponse(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::GetAssertionAuthenticatorResponseDataView, UserType>(),
    "Attempting to read the optional `get_assertion_authenticator_response` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadGetAssertionAuthenticatorResponse` instead "
    "of `ReadGetAssertionAuthenticatorResponse if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->get_assertion_authenticator_response.Get();
    return mojo::internal::Deserialize<::blink::mojom::GetAssertionAuthenticatorResponseDataView>(
        pointer, output, message_);
  }
 private:
  internal::PaymentResponse_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PayerDetailDataView {
 public:
  PayerDetailDataView() = default;

  PayerDetailDataView(
      internal::PayerDetail_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetEmailDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadEmail(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `email` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadEmail` instead "
    "of `ReadEmail if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->email.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadName(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `name` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadName` instead "
    "of `ReadName if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetPhoneDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPhone(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `phone` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadPhone` instead "
    "of `ReadPhone if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->phone.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::PayerDetail_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PaymentItemDataView {
 public:
  PaymentItemDataView() = default;

  PaymentItemDataView(
      internal::PaymentItem_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetLabelDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLabel(UserType* output) {
    
    auto* pointer = data_->label.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetAmountDataView(
      ::payments::mojom::PaymentCurrencyAmountDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAmount(UserType* output) {
    
    auto* pointer = data_->amount.Get();
    return mojo::internal::Deserialize<::payments::mojom::PaymentCurrencyAmountDataView>(
        pointer, output, message_);
  }
  bool pending() const {
    return data_->pending;
  }
 private:
  internal::PaymentItem_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PaymentShippingOptionDataView {
 public:
  PaymentShippingOptionDataView() = default;

  PaymentShippingOptionDataView(
      internal::PaymentShippingOption_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadId(UserType* output) {
    
    auto* pointer = data_->id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetLabelDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLabel(UserType* output) {
    
    auto* pointer = data_->label.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetAmountDataView(
      ::payments::mojom::PaymentCurrencyAmountDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAmount(UserType* output) {
    
    auto* pointer = data_->amount.Get();
    return mojo::internal::Deserialize<::payments::mojom::PaymentCurrencyAmountDataView>(
        pointer, output, message_);
  }
  bool selected() const {
    return data_->selected;
  }
 private:
  internal::PaymentShippingOption_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class SecurePaymentConfirmationRequestDataView {
 public:
  SecurePaymentConfirmationRequestDataView() = default;

  SecurePaymentConfirmationRequestDataView(
      internal::SecurePaymentConfirmationRequest_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetCredentialIdsDataView(
      mojo::ArrayDataView<mojo::ArrayDataView<uint8_t>>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCredentialIds(UserType* output) {
    
    auto* pointer = data_->credential_ids.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<mojo::ArrayDataView<uint8_t>>>(
        pointer, output, message_);
  }
  inline void GetChallengeDataView(
      mojo::ArrayDataView<uint8_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadChallenge(UserType* output) {
    
    auto* pointer = data_->challenge.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint8_t>>(
        pointer, output, message_);
  }
  inline void GetInstrumentDataView(
      ::blink::mojom::PaymentCredentialInstrumentDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInstrument(UserType* output) {
    
    auto* pointer = data_->instrument.Get();
    return mojo::internal::Deserialize<::blink::mojom::PaymentCredentialInstrumentDataView>(
        pointer, output, message_);
  }
  inline void GetTimeoutDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTimeout(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::TimeDeltaDataView, UserType>(),
    "Attempting to read the optional `timeout` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadTimeout` instead "
    "of `ReadTimeout if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->timeout.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
  inline void GetPayeeOriginDataView(
      ::url::mojom::OriginDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPayeeOrigin(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::url::mojom::OriginDataView, UserType>(),
    "Attempting to read the optional `payee_origin` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadPayeeOrigin` instead "
    "of `ReadPayeeOrigin if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->payee_origin.Get();
    return mojo::internal::Deserialize<::url::mojom::OriginDataView>(
        pointer, output, message_);
  }
  inline void GetPayeeNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPayeeName(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `payee_name` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadPayeeName` instead "
    "of `ReadPayeeName if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->payee_name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetRpIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRpId(UserType* output) {
    
    auto* pointer = data_->rp_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetExtensionsDataView(
      ::blink::mojom::AuthenticationExtensionsClientInputsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadExtensions(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::AuthenticationExtensionsClientInputsDataView, UserType>(),
    "Attempting to read the optional `extensions` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadExtensions` instead "
    "of `ReadExtensions if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->extensions.Get();
    return mojo::internal::Deserialize<::blink::mojom::AuthenticationExtensionsClientInputsDataView>(
        pointer, output, message_);
  }
  inline void GetBrowserBoundPubKeyCredParamsDataView(
      mojo::ArrayDataView<::blink::mojom::PublicKeyCredentialParametersDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBrowserBoundPubKeyCredParams(UserType* output) {
    
    auto* pointer = data_->browser_bound_pub_key_cred_params.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::PublicKeyCredentialParametersDataView>>(
        pointer, output, message_);
  }
  bool show_opt_out() const {
    return data_->show_opt_out;
  }
  inline void GetPaymentEntitiesLogosDataView(
      mojo::ArrayDataView<PaymentEntityLogoDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPaymentEntitiesLogos(UserType* output) {
    
    auto* pointer = data_->payment_entities_logos.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::payments::mojom::PaymentEntityLogoDataView>>(
        pointer, output, message_);
  }
 private:
  internal::SecurePaymentConfirmationRequest_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class NetworkOrIssuerInformationDataView {
 public:
  NetworkOrIssuerInformationDataView() = default;

  NetworkOrIssuerInformationDataView(
      internal::NetworkOrIssuerInformation_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadName(UserType* output) {
    
    auto* pointer = data_->name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetIconDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadIcon(UserType* output) {
    
    auto* pointer = data_->icon.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
 private:
  internal::NetworkOrIssuerInformation_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PaymentEntityLogoDataView {
 public:
  PaymentEntityLogoDataView() = default;

  PaymentEntityLogoDataView(
      internal::PaymentEntityLogo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUrl(UserType* output) {
    
    auto* pointer = data_->url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetLabelDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLabel(UserType* output) {
    
    auto* pointer = data_->label.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::PaymentEntityLogo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PaymentMethodDataDataView {
 public:
  PaymentMethodDataDataView() = default;

  PaymentMethodDataDataView(
      internal::PaymentMethodData_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetSupportedMethodDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSupportedMethod(UserType* output) {
    
    auto* pointer = data_->supported_method.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetStringifiedDataDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadStringifiedData(UserType* output) {
    
    auto* pointer = data_->stringified_data.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadEnvironment(UserType* output) const {
    auto data_value = data_->environment;
    return mojo::internal::Deserialize<::payments::mojom::AndroidPayEnvironment>(
        data_value, output);
  }
  AndroidPayEnvironment environment() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::payments::mojom::AndroidPayEnvironment>(data_->environment));
  }
  int32_t min_google_play_services_version() const {
    return data_->min_google_play_services_version;
  }
  int32_t api_version() const {
    return data_->api_version;
  }
  inline void GetSupportedNetworksDataView(
      mojo::ArrayDataView<BasicCardNetwork>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSupportedNetworks(UserType* output) {
    
    auto* pointer = data_->supported_networks.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::payments::mojom::BasicCardNetwork>>(
        pointer, output, message_);
  }
  inline void GetSecurePaymentConfirmationDataView(
      SecurePaymentConfirmationRequestDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSecurePaymentConfirmation(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::payments::mojom::SecurePaymentConfirmationRequestDataView, UserType>(),
    "Attempting to read the optional `secure_payment_confirmation` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadSecurePaymentConfirmation` instead "
    "of `ReadSecurePaymentConfirmation if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->secure_payment_confirmation.Get();
    return mojo::internal::Deserialize<::payments::mojom::SecurePaymentConfirmationRequestDataView>(
        pointer, output, message_);
  }
 private:
  internal::PaymentMethodData_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PaymentDetailsModifierDataView {
 public:
  PaymentDetailsModifierDataView() = default;

  PaymentDetailsModifierDataView(
      internal::PaymentDetailsModifier_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetTotalDataView(
      PaymentItemDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTotal(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::payments::mojom::PaymentItemDataView, UserType>(),
    "Attempting to read the optional `total` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadTotal` instead "
    "of `ReadTotal if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->total.Get();
    return mojo::internal::Deserialize<::payments::mojom::PaymentItemDataView>(
        pointer, output, message_);
  }
  inline void GetAdditionalDisplayItemsDataView(
      mojo::ArrayDataView<PaymentItemDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAdditionalDisplayItems(UserType* output) {
    
    auto* pointer = data_->additional_display_items.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::payments::mojom::PaymentItemDataView>>(
        pointer, output, message_);
  }
  inline void GetMethodDataDataView(
      PaymentMethodDataDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMethodData(UserType* output) {
    
    auto* pointer = data_->method_data.Get();
    return mojo::internal::Deserialize<::payments::mojom::PaymentMethodDataDataView>(
        pointer, output, message_);
  }
 private:
  internal::PaymentDetailsModifier_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PaymentDetailsDataView {
 public:
  PaymentDetailsDataView() = default;

  PaymentDetailsDataView(
      internal::PaymentDetails_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetTotalDataView(
      PaymentItemDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTotal(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::payments::mojom::PaymentItemDataView, UserType>(),
    "Attempting to read the optional `total` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadTotal` instead "
    "of `ReadTotal if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->total.Get();
    return mojo::internal::Deserialize<::payments::mojom::PaymentItemDataView>(
        pointer, output, message_);
  }
  inline void GetDisplayItemsDataView(
      mojo::ArrayDataView<PaymentItemDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDisplayItems(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::ArrayDataView<::payments::mojom::PaymentItemDataView>, UserType>(),
    "Attempting to read the optional `display_items` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadDisplayItems` instead "
    "of `ReadDisplayItems if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->display_items.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::payments::mojom::PaymentItemDataView>>(
        pointer, output, message_);
  }
  inline void GetShippingOptionsDataView(
      mojo::ArrayDataView<PaymentShippingOptionDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadShippingOptions(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::ArrayDataView<::payments::mojom::PaymentShippingOptionDataView>, UserType>(),
    "Attempting to read the optional `shipping_options` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadShippingOptions` instead "
    "of `ReadShippingOptions if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->shipping_options.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::payments::mojom::PaymentShippingOptionDataView>>(
        pointer, output, message_);
  }
  inline void GetModifiersDataView(
      mojo::ArrayDataView<PaymentDetailsModifierDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadModifiers(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::ArrayDataView<::payments::mojom::PaymentDetailsModifierDataView>, UserType>(),
    "Attempting to read the optional `modifiers` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadModifiers` instead "
    "of `ReadModifiers if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->modifiers.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::payments::mojom::PaymentDetailsModifierDataView>>(
        pointer, output, message_);
  }
  inline void GetErrorDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadError(UserType* output) {
    
    auto* pointer = data_->error.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetShippingAddressErrorsDataView(
      ::payments::mojom::AddressErrorsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadShippingAddressErrors(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::payments::mojom::AddressErrorsDataView, UserType>(),
    "Attempting to read the optional `shipping_address_errors` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadShippingAddressErrors` instead "
    "of `ReadShippingAddressErrors if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->shipping_address_errors.Get();
    return mojo::internal::Deserialize<::payments::mojom::AddressErrorsDataView>(
        pointer, output, message_);
  }
  inline void GetIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadId(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `id` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadId` instead "
    "of `ReadId if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetStringifiedPaymentMethodErrorsDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadStringifiedPaymentMethodErrors(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `stringified_payment_method_errors` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadStringifiedPaymentMethodErrors` instead "
    "of `ReadStringifiedPaymentMethodErrors if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->stringified_payment_method_errors.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::PaymentDetails_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PaymentOptionsDataView {
 public:
  PaymentOptionsDataView() = default;

  PaymentOptionsDataView(
      internal::PaymentOptions_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool request_payer_name() const {
    return data_->request_payer_name;
  }
  bool request_payer_email() const {
    return data_->request_payer_email;
  }
  bool request_payer_phone() const {
    return data_->request_payer_phone;
  }
  bool request_shipping() const {
    return data_->request_shipping;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadShippingType(UserType* output) const {
    auto data_value = data_->shipping_type;
    return mojo::internal::Deserialize<::payments::mojom::PaymentShippingType>(
        data_value, output);
  }
  PaymentShippingType shipping_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::payments::mojom::PaymentShippingType>(data_->shipping_type));
  }
 private:
  internal::PaymentOptions_Data* data_ = nullptr;
};


}  // payments::mojom

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_PAYMENTS_PAYMENT_REQUEST_MOJOM_DATA_VIEW_H_