// third_party/blink/public/mojom/payments/payment_request.mojom-blink-test-utils.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_PAYMENTS_PAYMENT_REQUEST_MOJOM_BLINK_TEST_UTILS_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_PAYMENTS_PAYMENT_REQUEST_MOJOM_BLINK_TEST_UTILS_H_

#include "third_party/blink/public/mojom/payments/payment_request.mojom-blink.h"
#include "third_party/blink/renderer/platform/platform_export.h"


namespace payments::mojom::blink {


class PLATFORM_EXPORT PaymentRequestClientInterceptorForTesting : public PaymentRequestClient {
  virtual PaymentRequestClient* GetForwardingInterface() = 0;
  void OnPaymentMethodChange(const ::blink::String& method_name, const ::blink::String& stringified_details) override;
  void OnShippingAddressChange(::payments::mojom::blink::PaymentAddressPtr address) override;
  void OnShippingOptionChange(const ::blink::String& shipping_option_id) override;
  void OnPayerDetailChange(PayerDetailPtr detail) override;
  void OnPaymentResponse(PaymentResponsePtr response) override;
  void OnError(PaymentErrorReason error, const ::blink::String& error_message) override;
  void OnComplete() override;
  void OnAbort(bool aborted_successfully) override;
  void OnCanMakePayment(CanMakePaymentQueryResult result) override;
  void OnHasEnrolledInstrument(HasEnrolledInstrumentQueryResult result) override;
  void WarnNoFavicon() override;
  void AllowConnectToSource(const ::blink::KURL& url, const ::blink::KURL& url_before_redirects, bool did_follow_redirect, AllowConnectToSourceCallback callback) override;
};
class PLATFORM_EXPORT PaymentRequestClientAsyncWaiter {
 public:
  explicit PaymentRequestClientAsyncWaiter(PaymentRequestClient* proxy);

  PaymentRequestClientAsyncWaiter(const PaymentRequestClientAsyncWaiter&) = delete;
  PaymentRequestClientAsyncWaiter& operator=(const PaymentRequestClientAsyncWaiter&) = delete;

  ~PaymentRequestClientAsyncWaiter();
  void AllowConnectToSource(
      const ::blink::KURL& url, const ::blink::KURL& url_before_redirects, bool did_follow_redirect, bool* out_allow);
  bool AllowConnectToSource(const ::blink::KURL& url, const ::blink::KURL& url_before_redirects, bool did_follow_redirect);

 private:
  PaymentRequestClient* const proxy_;
};


class PLATFORM_EXPORT PaymentRequestInterceptorForTesting : public PaymentRequest {
  virtual PaymentRequest* GetForwardingInterface() = 0;
  void Init(::mojo::PendingRemote<PaymentRequestClient> client, ::blink::Vector<PaymentMethodDataPtr> method_data, PaymentDetailsPtr details, PaymentOptionsPtr options) override;
  void Show(bool wait_for_updated_details, bool had_user_activation) override;
  void UpdateWith(PaymentDetailsPtr details) override;
  void OnPaymentDetailsNotUpdated() override;
  void Abort() override;
  void Complete(PaymentComplete result) override;
  void Retry(::payments::mojom::blink::PaymentValidationErrorsPtr errors) override;
  void CanMakePayment() override;
  void HasEnrolledInstrument() override;
};
class PLATFORM_EXPORT PaymentRequestAsyncWaiter {
 public:
  explicit PaymentRequestAsyncWaiter(PaymentRequest* proxy);

  PaymentRequestAsyncWaiter(const PaymentRequestAsyncWaiter&) = delete;
  PaymentRequestAsyncWaiter& operator=(const PaymentRequestAsyncWaiter&) = delete;

  ~PaymentRequestAsyncWaiter();

 private:
  PaymentRequest* const proxy_;
};




}  // payments::mojom::blink

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_PAYMENTS_PAYMENT_REQUEST_MOJOM_BLINK_TEST_UTILS_H_