// third_party/blink/public/mojom/payments/payment_handler_host.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_PAYMENTS_PAYMENT_HANDLER_HOST_MOJOM_SEND_VALIDATION_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_PAYMENTS_PAYMENT_HANDLER_HOST_MOJOM_SEND_VALIDATION_H_

#include "third_party/blink/public/mojom/payments/payment_handler_host.mojom-shared-internal.h"
#include "components/payments/mojom/payment_request_data.mojom-shared.h"
#include "third_party/blink/public/mojom/payments/payment_request.mojom-shared.h"

#include "third_party/blink/public/mojom/payments/payment_handler_host.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization_send_validation.h"

namespace mojo::internal {

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::payments::mojom::PaymentHandlerMethodDataDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::payments::mojom::PaymentHandlerMethodDataDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::payments::mojom::internal::PaymentHandlerMethodData_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::method_name(input)) in_method_name = Traits::method_name(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->method_name)::BaseType> method_name_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_method_name,
        method_name_fragment);

      fragment->method_name.Set(
          method_name_fragment.is_null() ? nullptr : method_name_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->method_name.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null method_name in PaymentHandlerMethodData struct");

      decltype(Traits::stringified_data(input)) in_stringified_data = Traits::stringified_data(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->stringified_data)::BaseType> stringified_data_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_stringified_data,
        stringified_data_fragment);

      fragment->stringified_data.Set(
          stringified_data_fragment.is_null() ? nullptr : stringified_data_fragment.data());
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::payments::mojom::PaymentHandlerModifierDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::payments::mojom::PaymentHandlerModifierDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::payments::mojom::internal::PaymentHandlerModifier_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::total(input)) in_total = Traits::total(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->total)::BaseType> total_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::payments::mojom::PaymentCurrencyAmountDataView, send_validation>(
        in_total,
        total_fragment);

      fragment->total.Set(
          total_fragment.is_null() ? nullptr : total_fragment.data());

      decltype(Traits::method_data(input)) in_method_data = Traits::method_data(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->method_data)::BaseType> method_data_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::payments::mojom::PaymentHandlerMethodDataDataView, send_validation>(
        in_method_data,
        method_data_fragment);

      fragment->method_data.Set(
          method_data_fragment.is_null() ? nullptr : method_data_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->method_data.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null method_data in PaymentHandlerModifier struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::payments::mojom::PaymentRequestDetailsUpdateDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::payments::mojom::PaymentRequestDetailsUpdateDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::payments::mojom::internal::PaymentRequestDetailsUpdate_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::total(input)) in_total = Traits::total(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->total)::BaseType> total_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::payments::mojom::PaymentCurrencyAmountDataView, send_validation>(
        in_total,
        total_fragment);

      fragment->total.Set(
          total_fragment.is_null() ? nullptr : total_fragment.data());

      decltype(Traits::shipping_options(input)) in_shipping_options = Traits::shipping_options(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->shipping_options)::BaseType>
          shipping_options_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& shipping_options_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::payments::mojom::PaymentShippingOptionDataView>, send_validation>(
        in_shipping_options,
        shipping_options_fragment,
        &shipping_options_validate_params);

      fragment->shipping_options.Set(
          shipping_options_fragment.is_null() ? nullptr : shipping_options_fragment.data());

      decltype(Traits::modifiers(input)) in_modifiers = Traits::modifiers(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->modifiers)::BaseType>
          modifiers_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& modifiers_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::payments::mojom::PaymentHandlerModifierDataView>, send_validation>(
        in_modifiers,
        modifiers_fragment,
        &modifiers_validate_params);

      fragment->modifiers.Set(
          modifiers_fragment.is_null() ? nullptr : modifiers_fragment.data());

      decltype(Traits::error(input)) in_error = Traits::error(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->error)::BaseType> error_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_error,
        error_fragment);

      fragment->error.Set(
          error_fragment.is_null() ? nullptr : error_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->error.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null error in PaymentRequestDetailsUpdate struct");

      decltype(Traits::stringified_payment_method_errors(input)) in_stringified_payment_method_errors = Traits::stringified_payment_method_errors(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->stringified_payment_method_errors)::BaseType> stringified_payment_method_errors_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_stringified_payment_method_errors,
        stringified_payment_method_errors_fragment);

      fragment->stringified_payment_method_errors.Set(
          stringified_payment_method_errors_fragment.is_null() ? nullptr : stringified_payment_method_errors_fragment.data());

      decltype(Traits::shipping_address_errors(input)) in_shipping_address_errors = Traits::shipping_address_errors(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->shipping_address_errors)::BaseType> shipping_address_errors_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::payments::mojom::AddressErrorsDataView, send_validation>(
        in_shipping_address_errors,
        shipping_address_errors_fragment);

      fragment->shipping_address_errors.Set(
          shipping_address_errors_fragment.is_null() ? nullptr : shipping_address_errors_fragment.data());
  }
};

}  // namespace mojo::internal

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_PAYMENTS_PAYMENT_HANDLER_HOST_MOJOM_SEND_VALIDATION_H_