// third_party/blink/public/mojom/payments/payment_handler_host.mojom-lite.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';


mojo.internal.exportModule('payments.mojom');








/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
payments.mojom.PaymentHandlerHostPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        payments.mojom.PaymentHandlerHost.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { payments.mojom.PaymentHandlerHostInterface }
 */
payments.mojom.PaymentHandlerHostRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!payments.mojom.PaymentHandlerHostPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          payments.mojom.PaymentHandlerHostPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!payments.mojom.PaymentHandlerHostPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !payments.mojom.PaymentHandlerMethodData } methodData
   * @return {!Promise<{
        responseData: !payments.mojom.PaymentRequestDetailsUpdate,
   *  }>}
   */

  changePaymentMethod(
      methodData) {
    return this.proxy.sendMessage(
        0,
        payments.mojom.PaymentHandlerHost_ChangePaymentMethod_ParamsSpec.$,
        payments.mojom.PaymentHandlerHost_ChangePaymentMethod_ResponseParamsSpec.$,
        [
          methodData
        ],
        false);
  }

  
  /**
   * @param { !string } shippingOptionId
   * @return {!Promise<{
        responseData: !payments.mojom.PaymentRequestDetailsUpdate,
   *  }>}
   */

  changeShippingOption(
      shippingOptionId) {
    return this.proxy.sendMessage(
        1,
        payments.mojom.PaymentHandlerHost_ChangeShippingOption_ParamsSpec.$,
        payments.mojom.PaymentHandlerHost_ChangeShippingOption_ResponseParamsSpec.$,
        [
          shippingOptionId
        ],
        false);
  }

  
  /**
   * @param { !payments.mojom.PaymentAddress } shippingAddress
   * @return {!Promise<{
        responseData: !payments.mojom.PaymentRequestDetailsUpdate,
   *  }>}
   */

  changeShippingAddress(
      shippingAddress) {
    return this.proxy.sendMessage(
        2,
        payments.mojom.PaymentHandlerHost_ChangeShippingAddress_ParamsSpec.$,
        payments.mojom.PaymentHandlerHost_ChangeShippingAddress_ResponseParamsSpec.$,
        [
          shippingAddress
        ],
        false);
  }
};

/**
 * An object which receives request messages for the PaymentHandlerHost
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
payments.mojom.PaymentHandlerHostReceiver = class {
  /**
   * @param {!payments.mojom.PaymentHandlerHostInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!payments.mojom.PaymentHandlerHostRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        payments.mojom.PaymentHandlerHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!payments.mojom.PaymentHandlerHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        payments.mojom.PaymentHandlerHost_ChangePaymentMethod_ParamsSpec.$,
        payments.mojom.PaymentHandlerHost_ChangePaymentMethod_ResponseParamsSpec.$,
        impl.changePaymentMethod.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        payments.mojom.PaymentHandlerHost_ChangeShippingOption_ParamsSpec.$,
        payments.mojom.PaymentHandlerHost_ChangeShippingOption_ResponseParamsSpec.$,
        impl.changeShippingOption.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        payments.mojom.PaymentHandlerHost_ChangeShippingAddress_ParamsSpec.$,
        payments.mojom.PaymentHandlerHost_ChangeShippingAddress_ResponseParamsSpec.$,
        impl.changeShippingAddress.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
payments.mojom.PaymentHandlerHost = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "payments.mojom.PaymentHandlerHost";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!payments.mojom.PaymentHandlerHostRemote}
   * @export
   */
  static getRemote() {
    let remote = new payments.mojom.PaymentHandlerHostRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the PaymentHandlerHost
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
payments.mojom.PaymentHandlerHostCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      payments.mojom.PaymentHandlerHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!payments.mojom.PaymentHandlerHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.changePaymentMethod =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        payments.mojom.PaymentHandlerHost_ChangePaymentMethod_ParamsSpec.$,
        payments.mojom.PaymentHandlerHost_ChangePaymentMethod_ResponseParamsSpec.$,
        this.changePaymentMethod.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.changeShippingOption =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        payments.mojom.PaymentHandlerHost_ChangeShippingOption_ParamsSpec.$,
        payments.mojom.PaymentHandlerHost_ChangeShippingOption_ResponseParamsSpec.$,
        this.changeShippingOption.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.changeShippingAddress =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        payments.mojom.PaymentHandlerHost_ChangeShippingAddress_ParamsSpec.$,
        payments.mojom.PaymentHandlerHost_ChangeShippingAddress_ResponseParamsSpec.$,
        this.changeShippingAddress.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};



/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
payments.mojom.PaymentHandlerMethodDataSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
payments.mojom.PaymentHandlerModifierSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
payments.mojom.PaymentRequestDetailsUpdateSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
payments.mojom.PaymentHandlerHost_ChangePaymentMethod_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
payments.mojom.PaymentHandlerHost_ChangePaymentMethod_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
payments.mojom.PaymentHandlerHost_ChangeShippingOption_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
payments.mojom.PaymentHandlerHost_ChangeShippingOption_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
payments.mojom.PaymentHandlerHost_ChangeShippingAddress_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
payments.mojom.PaymentHandlerHost_ChangeShippingAddress_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    payments.mojom.PaymentHandlerMethodDataSpec.$,
    'PaymentHandlerMethodData',
    [
      mojo.internal.StructField(
        'methodName', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'stringifiedData', 8,
        0,
        mojo.internal.String,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
payments.mojom.PaymentHandlerMethodData = class {
  constructor() {
    /** @export { !string } */
    this.methodName;
    /** @export { (string|undefined) } */
    this.stringifiedData;
  }
};



mojo.internal.Struct(
    payments.mojom.PaymentHandlerModifierSpec.$,
    'PaymentHandlerModifier',
    [
      mojo.internal.StructField(
        'total', 0,
        0,
        payments.mojom.PaymentCurrencyAmountSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'methodData', 8,
        0,
        payments.mojom.PaymentHandlerMethodDataSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
payments.mojom.PaymentHandlerModifier = class {
  constructor() {
    /** @export { (payments.mojom.PaymentCurrencyAmount|undefined) } */
    this.total;
    /** @export { !payments.mojom.PaymentHandlerMethodData } */
    this.methodData;
  }
};



mojo.internal.Struct(
    payments.mojom.PaymentRequestDetailsUpdateSpec.$,
    'PaymentRequestDetailsUpdate',
    [
      mojo.internal.StructField(
        'total', 0,
        0,
        payments.mojom.PaymentCurrencyAmountSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'shippingOptions', 8,
        0,
        mojo.internal.Array(payments.mojom.PaymentShippingOptionSpec.$, false),
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'modifiers', 16,
        0,
        mojo.internal.Array(payments.mojom.PaymentHandlerModifierSpec.$, false),
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'error', 24,
        0,
        mojo.internal.String,
        "",
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'stringifiedPaymentMethodErrors', 32,
        0,
        mojo.internal.String,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'shippingAddressErrors', 40,
        0,
        payments.mojom.AddressErrorsSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 56],]);





/** @record */
payments.mojom.PaymentRequestDetailsUpdate = class {
  constructor() {
    /** @export { (payments.mojom.PaymentCurrencyAmount|undefined) } */
    this.total;
    /** @export { (Array<!payments.mojom.PaymentShippingOption>|undefined) } */
    this.shippingOptions;
    /** @export { (Array<!payments.mojom.PaymentHandlerModifier>|undefined) } */
    this.modifiers;
    /** @export { !string } */
    this.error;
    /** @export { (string|undefined) } */
    this.stringifiedPaymentMethodErrors;
    /** @export { (payments.mojom.AddressErrors|undefined) } */
    this.shippingAddressErrors;
  }
};



mojo.internal.Struct(
    payments.mojom.PaymentHandlerHost_ChangePaymentMethod_ParamsSpec.$,
    'PaymentHandlerHost_ChangePaymentMethod_Params',
    [
      mojo.internal.StructField(
        'methodData', 0,
        0,
        payments.mojom.PaymentHandlerMethodDataSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
payments.mojom.PaymentHandlerHost_ChangePaymentMethod_Params = class {
  constructor() {
    /** @export { !payments.mojom.PaymentHandlerMethodData } */
    this.methodData;
  }
};



mojo.internal.Struct(
    payments.mojom.PaymentHandlerHost_ChangePaymentMethod_ResponseParamsSpec.$,
    'PaymentHandlerHost_ChangePaymentMethod_ResponseParams',
    [
      mojo.internal.StructField(
        'responseData', 0,
        0,
        payments.mojom.PaymentRequestDetailsUpdateSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
payments.mojom.PaymentHandlerHost_ChangePaymentMethod_ResponseParams = class {
  constructor() {
    /** @export { !payments.mojom.PaymentRequestDetailsUpdate } */
    this.responseData;
  }
};



mojo.internal.Struct(
    payments.mojom.PaymentHandlerHost_ChangeShippingOption_ParamsSpec.$,
    'PaymentHandlerHost_ChangeShippingOption_Params',
    [
      mojo.internal.StructField(
        'shippingOptionId', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
payments.mojom.PaymentHandlerHost_ChangeShippingOption_Params = class {
  constructor() {
    /** @export { !string } */
    this.shippingOptionId;
  }
};



mojo.internal.Struct(
    payments.mojom.PaymentHandlerHost_ChangeShippingOption_ResponseParamsSpec.$,
    'PaymentHandlerHost_ChangeShippingOption_ResponseParams',
    [
      mojo.internal.StructField(
        'responseData', 0,
        0,
        payments.mojom.PaymentRequestDetailsUpdateSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
payments.mojom.PaymentHandlerHost_ChangeShippingOption_ResponseParams = class {
  constructor() {
    /** @export { !payments.mojom.PaymentRequestDetailsUpdate } */
    this.responseData;
  }
};



mojo.internal.Struct(
    payments.mojom.PaymentHandlerHost_ChangeShippingAddress_ParamsSpec.$,
    'PaymentHandlerHost_ChangeShippingAddress_Params',
    [
      mojo.internal.StructField(
        'shippingAddress', 0,
        0,
        payments.mojom.PaymentAddressSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
payments.mojom.PaymentHandlerHost_ChangeShippingAddress_Params = class {
  constructor() {
    /** @export { !payments.mojom.PaymentAddress } */
    this.shippingAddress;
  }
};



mojo.internal.Struct(
    payments.mojom.PaymentHandlerHost_ChangeShippingAddress_ResponseParamsSpec.$,
    'PaymentHandlerHost_ChangeShippingAddress_ResponseParams',
    [
      mojo.internal.StructField(
        'responseData', 0,
        0,
        payments.mojom.PaymentRequestDetailsUpdateSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
payments.mojom.PaymentHandlerHost_ChangeShippingAddress_ResponseParams = class {
  constructor() {
    /** @export { !payments.mojom.PaymentRequestDetailsUpdate } */
    this.responseData;
  }
};

