// third_party/blink/public/mojom/payments/payment_app.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../../mojo/public/js/bindings.js';

import {
  PaymentAddress as payments_mojom_PaymentAddress,
  PaymentAddressSpec as payments_mojom_PaymentAddressSpec,
  PaymentCurrencyAmount as payments_mojom_PaymentCurrencyAmount,
  PaymentCurrencyAmountSpec as payments_mojom_PaymentCurrencyAmountSpec
} from '../../../../../components/payments/mojom/payment_request_data.mojom.m.js';

import {
  Url as url_mojom_Url,
  UrlSpec as url_mojom_UrlSpec
} from '../../../../../url/mojom/url.mojom.m.js';

import {
  ManifestImageResource as blink_mojom_ManifestImageResource,
  ManifestImageResourceSpec as blink_mojom_ManifestImageResourceSpec
} from '../manifest/manifest.mojom.m.js';

import {
  PaymentHandlerHostRemote as payments_mojom_PaymentHandlerHostRemote,
  PaymentHandlerHostPendingReceiver as payments_mojom_PaymentHandlerHostPendingReceiver
} from './payment_handler_host.mojom.m.js';

import {
  PaymentDetailsModifier as payments_mojom_PaymentDetailsModifier,
  PaymentDetailsModifierSpec as payments_mojom_PaymentDetailsModifierSpec,
  PaymentMethodData as payments_mojom_PaymentMethodData,
  PaymentMethodDataSpec as payments_mojom_PaymentMethodDataSpec,
  PaymentOptions as payments_mojom_PaymentOptions,
  PaymentOptionsSpec as payments_mojom_PaymentOptionsSpec,
  PaymentShippingOption as payments_mojom_PaymentShippingOption,
  PaymentShippingOptionSpec as payments_mojom_PaymentShippingOptionSpec
} from './payment_request.mojom.m.js';


/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const PaymentHandlerStatusSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const PaymentHandlerStatus = {
  
  SUCCESS: 0,
  NOT_FOUND: 1,
  NO_ACTIVE_WORKER: 2,
  STORAGE_OPERATION_FAILED: 3,
  FETCH_INSTRUMENT_ICON_FAILED: 4,
  FETCH_PAYMENT_APP_INFO_FAILED: 5,
  MIN_VALUE: 0,
  MAX_VALUE: 5,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const CanMakePaymentEventResponseTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const CanMakePaymentEventResponseType = {
  
  INCOGNITO: 0,
  NO_EXPLICITLY_VERIFIED_METHODS: 1,
  NOT_INSTALLED: 2,
  NO_URL_BASED_PAYMENT_METHODS: 3,
  BOOLEAN_CONVERSION_ERROR: 4,
  BROWSER_ERROR: 5,
  INTERNAL_ERROR: 6,
  NO_RESPONSE: 7,
  REJECT: 8,
  SUCCESS: 9,
  TIMEOUT: 10,
  MIN_VALUE: 0,
  MAX_VALUE: 10,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const PaymentEventResponseTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const PaymentEventResponseType = {
  
  PAYER_NAME_EMPTY: 0,
  PAYER_EMAIL_EMPTY: 1,
  PAYER_PHONE_EMPTY: 2,
  PAYMENT_DETAILS_ABSENT: 3,
  PAYMENT_DETAILS_NOT_OBJECT: 4,
  PAYMENT_DETAILS_STRINGIFY_ERROR: 5,
  PAYMENT_EVENT_BROWSER_ERROR: 6,
  PAYMENT_EVENT_INTERNAL_ERROR: 7,
  PAYMENT_EVENT_NO_RESPONSE: 8,
  PAYMENT_EVENT_REJECT: 9,
  PAYMENT_EVENT_SERVICE_WORKER_ERROR: 10,
  PAYMENT_EVENT_SUCCESS: 11,
  PAYMENT_EVENT_TIMEOUT: 12,
  PAYMENT_HANDLER_ACTIVITY_DIED: 13,
  PAYMENT_HANDLER_FAIL_TO_LOAD_MAIN_FRAME: 14,
  PAYMENT_HANDLER_INSECURE_NAVIGATION: 15,
  PAYMENT_HANDLER_INSTALL_FAILED: 16,
  PAYMENT_HANDLER_WINDOW_CLOSING: 17,
  PAYMENT_METHOD_NAME_EMPTY: 18,
  SHIPPING_ADDRESS_INVALID: 19,
  SHIPPING_OPTION_EMPTY: 20,
  MIN_VALUE: 0,
  MAX_VALUE: 20,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const PaymentDelegationSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const PaymentDelegation = {
  
  SHIPPING_ADDRESS: 0,
  PAYER_NAME: 1,
  PAYER_PHONE: 2,
  PAYER_EMAIL: 3,
  MIN_VALUE: 0,
  MAX_VALUE: 3,
};



/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class PaymentManagerPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'payments.mojom.PaymentManager', scope);
  }
}

/** @interface */
export class PaymentManagerInterface {
  
  /**
   * @param { !url_mojom_Url } contextUrl
   * @param { !string } serviceWorkerScope
   */

  init(contextUrl, serviceWorkerScope) {}
  
  /**
   * @param { !string } instrumentKey
   * @return {!Promise<{
        status: !PaymentHandlerStatus,
   *  }>}
   */

  deletePaymentInstrument(instrumentKey) {}
  
  /**
   * @param { !string } instrumentKey
   * @return {!Promise<{
        instrument: !PaymentInstrument,
        status: !PaymentHandlerStatus,
   *  }>}
   */

  getPaymentInstrument(instrumentKey) {}
  
  /**
   * @return {!Promise<{
        keys: !Array<!string>,
        status: !PaymentHandlerStatus,
   *  }>}
   */

  keysOfPaymentInstruments() {}
  
  /**
   * @param { !string } instrumentKey
   * @return {!Promise<{
        status: !PaymentHandlerStatus,
   *  }>}
   */

  hasPaymentInstrument(instrumentKey) {}
  
  /**
   * @param { !string } instrumentKey
   * @param { !PaymentInstrument } instrument
   * @return {!Promise<{
        status: !PaymentHandlerStatus,
   *  }>}
   */

  setPaymentInstrument(instrumentKey, instrument) {}
  
  /**
   * @return {!Promise<{
        status: !PaymentHandlerStatus,
   *  }>}
   */

  clearPaymentInstruments() {}
  
  /**
   * @param { !string } userHint
   */

  setUserHint(userHint) {}
  
  /**
   * @param { !Array<!PaymentDelegation> } delegations
   * @return {!Promise<{
        status: !PaymentHandlerStatus,
   *  }>}
   */

  enableDelegations(delegations) {}
}

/**
 * @implements { PaymentManagerInterface }
 */
export class PaymentManagerRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!PaymentManagerPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          PaymentManagerPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!PaymentManagerPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !url_mojom_Url } contextUrl
   * @param { !string } serviceWorkerScope
   */

  init(
      contextUrl,
      serviceWorkerScope) {
    this.proxy.sendMessage(
        0,
        PaymentManager_Init_ParamsSpec.$,
        null,
        [
          contextUrl,
          serviceWorkerScope
        ],
        false);
  }

  
  /**
   * @param { !string } instrumentKey
   * @return {!Promise<{
        status: !PaymentHandlerStatus,
   *  }>}
   */

  deletePaymentInstrument(
      instrumentKey) {
    return this.proxy.sendMessage(
        1,
        PaymentManager_DeletePaymentInstrument_ParamsSpec.$,
        PaymentManager_DeletePaymentInstrument_ResponseParamsSpec.$,
        [
          instrumentKey
        ],
        false);
  }

  
  /**
   * @param { !string } instrumentKey
   * @return {!Promise<{
        instrument: !PaymentInstrument,
        status: !PaymentHandlerStatus,
   *  }>}
   */

  getPaymentInstrument(
      instrumentKey) {
    return this.proxy.sendMessage(
        2,
        PaymentManager_GetPaymentInstrument_ParamsSpec.$,
        PaymentManager_GetPaymentInstrument_ResponseParamsSpec.$,
        [
          instrumentKey
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        keys: !Array<!string>,
        status: !PaymentHandlerStatus,
   *  }>}
   */

  keysOfPaymentInstruments() {
    return this.proxy.sendMessage(
        3,
        PaymentManager_KeysOfPaymentInstruments_ParamsSpec.$,
        PaymentManager_KeysOfPaymentInstruments_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !string } instrumentKey
   * @return {!Promise<{
        status: !PaymentHandlerStatus,
   *  }>}
   */

  hasPaymentInstrument(
      instrumentKey) {
    return this.proxy.sendMessage(
        4,
        PaymentManager_HasPaymentInstrument_ParamsSpec.$,
        PaymentManager_HasPaymentInstrument_ResponseParamsSpec.$,
        [
          instrumentKey
        ],
        false);
  }

  
  /**
   * @param { !string } instrumentKey
   * @param { !PaymentInstrument } instrument
   * @return {!Promise<{
        status: !PaymentHandlerStatus,
   *  }>}
   */

  setPaymentInstrument(
      instrumentKey,
      instrument) {
    return this.proxy.sendMessage(
        5,
        PaymentManager_SetPaymentInstrument_ParamsSpec.$,
        PaymentManager_SetPaymentInstrument_ResponseParamsSpec.$,
        [
          instrumentKey,
          instrument
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        status: !PaymentHandlerStatus,
   *  }>}
   */

  clearPaymentInstruments() {
    return this.proxy.sendMessage(
        6,
        PaymentManager_ClearPaymentInstruments_ParamsSpec.$,
        PaymentManager_ClearPaymentInstruments_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !string } userHint
   */

  setUserHint(
      userHint) {
    this.proxy.sendMessage(
        7,
        PaymentManager_SetUserHint_ParamsSpec.$,
        null,
        [
          userHint
        ],
        false);
  }

  
  /**
   * @param { !Array<!PaymentDelegation> } delegations
   * @return {!Promise<{
        status: !PaymentHandlerStatus,
   *  }>}
   */

  enableDelegations(
      delegations) {
    return this.proxy.sendMessage(
        8,
        PaymentManager_EnableDelegations_ParamsSpec.$,
        PaymentManager_EnableDelegations_ResponseParamsSpec.$,
        [
          delegations
        ],
        false);
  }
}

/**
 * An object which receives request messages for the PaymentManager
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PaymentManagerReceiver {
  /**
   * @param {!PaymentManagerInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!PaymentManagerRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        PaymentManagerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!PaymentManagerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        PaymentManager_Init_ParamsSpec.$,
        null,
        impl.init.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        PaymentManager_DeletePaymentInstrument_ParamsSpec.$,
        PaymentManager_DeletePaymentInstrument_ResponseParamsSpec.$,
        impl.deletePaymentInstrument.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        PaymentManager_GetPaymentInstrument_ParamsSpec.$,
        PaymentManager_GetPaymentInstrument_ResponseParamsSpec.$,
        impl.getPaymentInstrument.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        PaymentManager_KeysOfPaymentInstruments_ParamsSpec.$,
        PaymentManager_KeysOfPaymentInstruments_ResponseParamsSpec.$,
        impl.keysOfPaymentInstruments.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        PaymentManager_HasPaymentInstrument_ParamsSpec.$,
        PaymentManager_HasPaymentInstrument_ResponseParamsSpec.$,
        impl.hasPaymentInstrument.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        PaymentManager_SetPaymentInstrument_ParamsSpec.$,
        PaymentManager_SetPaymentInstrument_ResponseParamsSpec.$,
        impl.setPaymentInstrument.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        PaymentManager_ClearPaymentInstruments_ParamsSpec.$,
        PaymentManager_ClearPaymentInstruments_ResponseParamsSpec.$,
        impl.clearPaymentInstruments.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        PaymentManager_SetUserHint_ParamsSpec.$,
        null,
        impl.setUserHint.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        8,
        PaymentManager_EnableDelegations_ParamsSpec.$,
        PaymentManager_EnableDelegations_ResponseParamsSpec.$,
        impl.enableDelegations.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class PaymentManager {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "payments.mojom.PaymentManager";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!PaymentManagerRemote}
   */
  static getRemote() {
    let remote = new PaymentManagerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the PaymentManager
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PaymentManagerCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      PaymentManagerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!PaymentManagerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.init =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        PaymentManager_Init_ParamsSpec.$,
        null,
        this.init.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.deletePaymentInstrument =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        PaymentManager_DeletePaymentInstrument_ParamsSpec.$,
        PaymentManager_DeletePaymentInstrument_ResponseParamsSpec.$,
        this.deletePaymentInstrument.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getPaymentInstrument =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        PaymentManager_GetPaymentInstrument_ParamsSpec.$,
        PaymentManager_GetPaymentInstrument_ResponseParamsSpec.$,
        this.getPaymentInstrument.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.keysOfPaymentInstruments =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        PaymentManager_KeysOfPaymentInstruments_ParamsSpec.$,
        PaymentManager_KeysOfPaymentInstruments_ResponseParamsSpec.$,
        this.keysOfPaymentInstruments.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.hasPaymentInstrument =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        PaymentManager_HasPaymentInstrument_ParamsSpec.$,
        PaymentManager_HasPaymentInstrument_ResponseParamsSpec.$,
        this.hasPaymentInstrument.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setPaymentInstrument =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        PaymentManager_SetPaymentInstrument_ParamsSpec.$,
        PaymentManager_SetPaymentInstrument_ResponseParamsSpec.$,
        this.setPaymentInstrument.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.clearPaymentInstruments =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        PaymentManager_ClearPaymentInstruments_ParamsSpec.$,
        PaymentManager_ClearPaymentInstruments_ResponseParamsSpec.$,
        this.clearPaymentInstruments.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setUserHint =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        PaymentManager_SetUserHint_ParamsSpec.$,
        null,
        this.setUserHint.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.enableDelegations =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        8,
        PaymentManager_EnableDelegations_ParamsSpec.$,
        PaymentManager_EnableDelegations_ResponseParamsSpec.$,
        this.enableDelegations.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class PaymentHandlerResponseCallbackPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'payments.mojom.PaymentHandlerResponseCallback', scope);
  }
}

/** @interface */
export class PaymentHandlerResponseCallbackInterface {
  
  /**
   * @param { !boolean } paymentAborted
   */

  onResponseForAbortPayment(paymentAborted) {}
  
  /**
   * @param { !CanMakePaymentResponse } response
   */

  onResponseForCanMakePayment(response) {}
  
  /**
   * @param { !PaymentHandlerResponse } response
   */

  onResponseForPaymentRequest(response) {}
}

/**
 * @implements { PaymentHandlerResponseCallbackInterface }
 */
export class PaymentHandlerResponseCallbackRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!PaymentHandlerResponseCallbackPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          PaymentHandlerResponseCallbackPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!PaymentHandlerResponseCallbackPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !boolean } paymentAborted
   */

  onResponseForAbortPayment(
      paymentAborted) {
    this.proxy.sendMessage(
        0,
        PaymentHandlerResponseCallback_OnResponseForAbortPayment_ParamsSpec.$,
        null,
        [
          paymentAborted
        ],
        false);
  }

  
  /**
   * @param { !CanMakePaymentResponse } response
   */

  onResponseForCanMakePayment(
      response) {
    this.proxy.sendMessage(
        1,
        PaymentHandlerResponseCallback_OnResponseForCanMakePayment_ParamsSpec.$,
        null,
        [
          response
        ],
        false);
  }

  
  /**
   * @param { !PaymentHandlerResponse } response
   */

  onResponseForPaymentRequest(
      response) {
    this.proxy.sendMessage(
        2,
        PaymentHandlerResponseCallback_OnResponseForPaymentRequest_ParamsSpec.$,
        null,
        [
          response
        ],
        false);
  }
}

/**
 * An object which receives request messages for the PaymentHandlerResponseCallback
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PaymentHandlerResponseCallbackReceiver {
  /**
   * @param {!PaymentHandlerResponseCallbackInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!PaymentHandlerResponseCallbackRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        PaymentHandlerResponseCallbackRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!PaymentHandlerResponseCallbackRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        PaymentHandlerResponseCallback_OnResponseForAbortPayment_ParamsSpec.$,
        null,
        impl.onResponseForAbortPayment.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        PaymentHandlerResponseCallback_OnResponseForCanMakePayment_ParamsSpec.$,
        null,
        impl.onResponseForCanMakePayment.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        PaymentHandlerResponseCallback_OnResponseForPaymentRequest_ParamsSpec.$,
        null,
        impl.onResponseForPaymentRequest.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class PaymentHandlerResponseCallback {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "payments.mojom.PaymentHandlerResponseCallback";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!PaymentHandlerResponseCallbackRemote}
   */
  static getRemote() {
    let remote = new PaymentHandlerResponseCallbackRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the PaymentHandlerResponseCallback
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PaymentHandlerResponseCallbackCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      PaymentHandlerResponseCallbackRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!PaymentHandlerResponseCallbackRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onResponseForAbortPayment =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        PaymentHandlerResponseCallback_OnResponseForAbortPayment_ParamsSpec.$,
        null,
        this.onResponseForAbortPayment.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onResponseForCanMakePayment =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        PaymentHandlerResponseCallback_OnResponseForCanMakePayment_ParamsSpec.$,
        null,
        this.onResponseForCanMakePayment.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onResponseForPaymentRequest =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        PaymentHandlerResponseCallback_OnResponseForPaymentRequest_ParamsSpec.$,
        null,
        this.onResponseForPaymentRequest.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PaymentInstrumentSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CanMakePaymentEventDataSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PaymentRequestEventDataSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CanMakePaymentResponseSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PaymentHandlerResponseSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PaymentManager_Init_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PaymentManager_DeletePaymentInstrument_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PaymentManager_DeletePaymentInstrument_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PaymentManager_GetPaymentInstrument_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PaymentManager_GetPaymentInstrument_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PaymentManager_KeysOfPaymentInstruments_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PaymentManager_KeysOfPaymentInstruments_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PaymentManager_HasPaymentInstrument_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PaymentManager_HasPaymentInstrument_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PaymentManager_SetPaymentInstrument_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PaymentManager_SetPaymentInstrument_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PaymentManager_ClearPaymentInstruments_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PaymentManager_ClearPaymentInstruments_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PaymentManager_SetUserHint_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PaymentManager_EnableDelegations_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PaymentManager_EnableDelegations_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PaymentHandlerResponseCallback_OnResponseForAbortPayment_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PaymentHandlerResponseCallback_OnResponseForCanMakePayment_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PaymentHandlerResponseCallback_OnResponseForPaymentRequest_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    PaymentInstrumentSpec.$,
    'PaymentInstrument',
    [
      mojo.internal.StructField(
        'name', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'icons', 8,
        0,
        mojo.internal.Array(blink_mojom_ManifestImageResourceSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'method', 16,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class PaymentInstrument {
  constructor() {
    /** @type { !string } */
    this.name;
    /** @type { !Array<!blink_mojom_ManifestImageResource> } */
    this.icons;
    /** @type { !string } */
    this.method;
  }
}



mojo.internal.Struct(
    CanMakePaymentEventDataSpec.$,
    'CanMakePaymentEventData',
    [
      mojo.internal.StructField(
        'topOrigin', 0,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'paymentRequestOrigin', 8,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'methodData', 16,
        0,
        mojo.internal.Array(payments_mojom_PaymentMethodDataSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'modifiers', 24,
        0,
        mojo.internal.Array(payments_mojom_PaymentDetailsModifierSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 40],]);



/**
 * @record
 */
export class CanMakePaymentEventData {
  constructor() {
    /** @type { !url_mojom_Url } */
    this.topOrigin;
    /** @type { !url_mojom_Url } */
    this.paymentRequestOrigin;
    /** @type { !Array<!payments_mojom_PaymentMethodData> } */
    this.methodData;
    /** @type { !Array<!payments_mojom_PaymentDetailsModifier> } */
    this.modifiers;
  }
}



mojo.internal.Struct(
    PaymentRequestEventDataSpec.$,
    'PaymentRequestEventData',
    [
      mojo.internal.StructField(
        'topOrigin', 0,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'paymentRequestOrigin', 8,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'paymentRequestId', 16,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'methodData', 24,
        0,
        mojo.internal.Array(payments_mojom_PaymentMethodDataSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'total', 32,
        0,
        payments_mojom_PaymentCurrencyAmountSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'modifiers', 40,
        0,
        mojo.internal.Array(payments_mojom_PaymentDetailsModifierSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'instrumentKey', 48,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'paymentOptions', 56,
        0,
        payments_mojom_PaymentOptionsSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'shippingOptions', 64,
        0,
        mojo.internal.Array(payments_mojom_PaymentShippingOptionSpec.$, false),
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'paymentHandlerHost', 72,
        0,
        mojo.internal.InterfaceProxy(payments_mojom_PaymentHandlerHostRemote),
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 88],]);



/**
 * @record
 */
export class PaymentRequestEventData {
  constructor() {
    /** @type { !url_mojom_Url } */
    this.topOrigin;
    /** @type { !url_mojom_Url } */
    this.paymentRequestOrigin;
    /** @type { !string } */
    this.paymentRequestId;
    /** @type { !Array<!payments_mojom_PaymentMethodData> } */
    this.methodData;
    /** @type { !payments_mojom_PaymentCurrencyAmount } */
    this.total;
    /** @type { !Array<!payments_mojom_PaymentDetailsModifier> } */
    this.modifiers;
    /** @type { !string } */
    this.instrumentKey;
    /** @type { (payments_mojom_PaymentOptions|undefined) } */
    this.paymentOptions;
    /** @type { (Array<!payments_mojom_PaymentShippingOption>|undefined) } */
    this.shippingOptions;
    /** @type { (payments_mojom_PaymentHandlerHostRemote|undefined) } */
    this.paymentHandlerHost;
  }
}



mojo.internal.Struct(
    CanMakePaymentResponseSpec.$,
    'CanMakePaymentResponse',
    [
      mojo.internal.StructField(
        'responseType', 0,
        0,
        CanMakePaymentEventResponseTypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'canMakePayment', 4,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class CanMakePaymentResponse {
  constructor() {
    /** @type { !CanMakePaymentEventResponseType } */
    this.responseType;
    /** @type { !boolean } */
    this.canMakePayment;
  }
}



mojo.internal.Struct(
    PaymentHandlerResponseSpec.$,
    'PaymentHandlerResponse',
    [
      mojo.internal.StructField(
        'methodName', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'stringifiedDetails', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'responseType', 16,
        0,
        PaymentEventResponseTypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'payerName', 24,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'payerEmail', 32,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'payerPhone', 40,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'shippingAddress', 48,
        0,
        payments_mojom_PaymentAddressSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'shippingOption', 56,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 72],]);



/**
 * @record
 */
export class PaymentHandlerResponse {
  constructor() {
    /** @type { !string } */
    this.methodName;
    /** @type { !string } */
    this.stringifiedDetails;
    /** @type { !PaymentEventResponseType } */
    this.responseType;
    /** @type { (string|undefined) } */
    this.payerName;
    /** @type { (string|undefined) } */
    this.payerEmail;
    /** @type { (string|undefined) } */
    this.payerPhone;
    /** @type { (payments_mojom_PaymentAddress|undefined) } */
    this.shippingAddress;
    /** @type { (string|undefined) } */
    this.shippingOption;
  }
}



mojo.internal.Struct(
    PaymentManager_Init_ParamsSpec.$,
    'PaymentManager_Init_Params',
    [
      mojo.internal.StructField(
        'contextUrl', 0,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'serviceWorkerScope', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class PaymentManager_Init_Params {
  constructor() {
    /** @type { !url_mojom_Url } */
    this.contextUrl;
    /** @type { !string } */
    this.serviceWorkerScope;
  }
}



mojo.internal.Struct(
    PaymentManager_DeletePaymentInstrument_ParamsSpec.$,
    'PaymentManager_DeletePaymentInstrument_Params',
    [
      mojo.internal.StructField(
        'instrumentKey', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class PaymentManager_DeletePaymentInstrument_Params {
  constructor() {
    /** @type { !string } */
    this.instrumentKey;
  }
}



mojo.internal.Struct(
    PaymentManager_DeletePaymentInstrument_ResponseParamsSpec.$,
    'PaymentManager_DeletePaymentInstrument_ResponseParams',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        PaymentHandlerStatusSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class PaymentManager_DeletePaymentInstrument_ResponseParams {
  constructor() {
    /** @type { !PaymentHandlerStatus } */
    this.status;
  }
}



mojo.internal.Struct(
    PaymentManager_GetPaymentInstrument_ParamsSpec.$,
    'PaymentManager_GetPaymentInstrument_Params',
    [
      mojo.internal.StructField(
        'instrumentKey', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class PaymentManager_GetPaymentInstrument_Params {
  constructor() {
    /** @type { !string } */
    this.instrumentKey;
  }
}



mojo.internal.Struct(
    PaymentManager_GetPaymentInstrument_ResponseParamsSpec.$,
    'PaymentManager_GetPaymentInstrument_ResponseParams',
    [
      mojo.internal.StructField(
        'instrument', 0,
        0,
        PaymentInstrumentSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'status', 8,
        0,
        PaymentHandlerStatusSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class PaymentManager_GetPaymentInstrument_ResponseParams {
  constructor() {
    /** @type { !PaymentInstrument } */
    this.instrument;
    /** @type { !PaymentHandlerStatus } */
    this.status;
  }
}



mojo.internal.Struct(
    PaymentManager_KeysOfPaymentInstruments_ParamsSpec.$,
    'PaymentManager_KeysOfPaymentInstruments_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class PaymentManager_KeysOfPaymentInstruments_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    PaymentManager_KeysOfPaymentInstruments_ResponseParamsSpec.$,
    'PaymentManager_KeysOfPaymentInstruments_ResponseParams',
    [
      mojo.internal.StructField(
        'keys', 0,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'status', 8,
        0,
        PaymentHandlerStatusSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class PaymentManager_KeysOfPaymentInstruments_ResponseParams {
  constructor() {
    /** @type { !Array<!string> } */
    this.keys;
    /** @type { !PaymentHandlerStatus } */
    this.status;
  }
}



mojo.internal.Struct(
    PaymentManager_HasPaymentInstrument_ParamsSpec.$,
    'PaymentManager_HasPaymentInstrument_Params',
    [
      mojo.internal.StructField(
        'instrumentKey', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class PaymentManager_HasPaymentInstrument_Params {
  constructor() {
    /** @type { !string } */
    this.instrumentKey;
  }
}



mojo.internal.Struct(
    PaymentManager_HasPaymentInstrument_ResponseParamsSpec.$,
    'PaymentManager_HasPaymentInstrument_ResponseParams',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        PaymentHandlerStatusSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class PaymentManager_HasPaymentInstrument_ResponseParams {
  constructor() {
    /** @type { !PaymentHandlerStatus } */
    this.status;
  }
}



mojo.internal.Struct(
    PaymentManager_SetPaymentInstrument_ParamsSpec.$,
    'PaymentManager_SetPaymentInstrument_Params',
    [
      mojo.internal.StructField(
        'instrumentKey', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'instrument', 8,
        0,
        PaymentInstrumentSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class PaymentManager_SetPaymentInstrument_Params {
  constructor() {
    /** @type { !string } */
    this.instrumentKey;
    /** @type { !PaymentInstrument } */
    this.instrument;
  }
}



mojo.internal.Struct(
    PaymentManager_SetPaymentInstrument_ResponseParamsSpec.$,
    'PaymentManager_SetPaymentInstrument_ResponseParams',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        PaymentHandlerStatusSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class PaymentManager_SetPaymentInstrument_ResponseParams {
  constructor() {
    /** @type { !PaymentHandlerStatus } */
    this.status;
  }
}



mojo.internal.Struct(
    PaymentManager_ClearPaymentInstruments_ParamsSpec.$,
    'PaymentManager_ClearPaymentInstruments_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class PaymentManager_ClearPaymentInstruments_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    PaymentManager_ClearPaymentInstruments_ResponseParamsSpec.$,
    'PaymentManager_ClearPaymentInstruments_ResponseParams',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        PaymentHandlerStatusSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class PaymentManager_ClearPaymentInstruments_ResponseParams {
  constructor() {
    /** @type { !PaymentHandlerStatus } */
    this.status;
  }
}



mojo.internal.Struct(
    PaymentManager_SetUserHint_ParamsSpec.$,
    'PaymentManager_SetUserHint_Params',
    [
      mojo.internal.StructField(
        'userHint', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class PaymentManager_SetUserHint_Params {
  constructor() {
    /** @type { !string } */
    this.userHint;
  }
}



mojo.internal.Struct(
    PaymentManager_EnableDelegations_ParamsSpec.$,
    'PaymentManager_EnableDelegations_Params',
    [
      mojo.internal.StructField(
        'delegations', 0,
        0,
        mojo.internal.Array(PaymentDelegationSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class PaymentManager_EnableDelegations_Params {
  constructor() {
    /** @type { !Array<!PaymentDelegation> } */
    this.delegations;
  }
}



mojo.internal.Struct(
    PaymentManager_EnableDelegations_ResponseParamsSpec.$,
    'PaymentManager_EnableDelegations_ResponseParams',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        PaymentHandlerStatusSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class PaymentManager_EnableDelegations_ResponseParams {
  constructor() {
    /** @type { !PaymentHandlerStatus } */
    this.status;
  }
}



mojo.internal.Struct(
    PaymentHandlerResponseCallback_OnResponseForAbortPayment_ParamsSpec.$,
    'PaymentHandlerResponseCallback_OnResponseForAbortPayment_Params',
    [
      mojo.internal.StructField(
        'paymentAborted', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class PaymentHandlerResponseCallback_OnResponseForAbortPayment_Params {
  constructor() {
    /** @type { !boolean } */
    this.paymentAborted;
  }
}



mojo.internal.Struct(
    PaymentHandlerResponseCallback_OnResponseForCanMakePayment_ParamsSpec.$,
    'PaymentHandlerResponseCallback_OnResponseForCanMakePayment_Params',
    [
      mojo.internal.StructField(
        'response', 0,
        0,
        CanMakePaymentResponseSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class PaymentHandlerResponseCallback_OnResponseForCanMakePayment_Params {
  constructor() {
    /** @type { !CanMakePaymentResponse } */
    this.response;
  }
}



mojo.internal.Struct(
    PaymentHandlerResponseCallback_OnResponseForPaymentRequest_ParamsSpec.$,
    'PaymentHandlerResponseCallback_OnResponseForPaymentRequest_Params',
    [
      mojo.internal.StructField(
        'response', 0,
        0,
        PaymentHandlerResponseSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class PaymentHandlerResponseCallback_OnResponseForPaymentRequest_Params {
  constructor() {
    /** @type { !PaymentHandlerResponse } */
    this.response;
  }
}

