// third_party/blink/public/mojom/payments/payment_app.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_PAYMENTS_PAYMENT_APP_MOJOM_SHARED_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_PAYMENTS_PAYMENT_APP_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/payments/payment_app.mojom-shared-internal.h"
#include "components/payments/mojom/payment_request_data.mojom-shared.h"
#include "third_party/blink/public/mojom/manifest/manifest.mojom-shared.h"
#include "third_party/blink/public/mojom/payments/payment_request.mojom-shared.h"
#include "third_party/blink/public/mojom/payments/payment_handler_host.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "third_party/blink/public/mojom/payments/payment_app.mojom-data-view.h"
#include "base/component_export.h"




namespace std {

template <>
struct hash<::payments::mojom::PaymentHandlerStatus>
    : public mojo::internal::EnumHashImpl<::payments::mojom::PaymentHandlerStatus> {};

template <>
struct hash<::payments::mojom::CanMakePaymentEventResponseType>
    : public mojo::internal::EnumHashImpl<::payments::mojom::CanMakePaymentEventResponseType> {};

template <>
struct hash<::payments::mojom::PaymentEventResponseType>
    : public mojo::internal::EnumHashImpl<::payments::mojom::PaymentEventResponseType> {};

template <>
struct hash<::payments::mojom::PaymentDelegation>
    : public mojo::internal::EnumHashImpl<::payments::mojom::PaymentDelegation> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::payments::mojom::PaymentHandlerStatus, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::payments::mojom::PaymentHandlerStatus, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::payments::mojom::PaymentHandlerStatus>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::payments::mojom::CanMakePaymentEventResponseType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::payments::mojom::CanMakePaymentEventResponseType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::payments::mojom::CanMakePaymentEventResponseType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::payments::mojom::PaymentEventResponseType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::payments::mojom::PaymentEventResponseType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::payments::mojom::PaymentEventResponseType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::payments::mojom::PaymentDelegation, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::payments::mojom::PaymentDelegation, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::payments::mojom::PaymentDelegation>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::payments::mojom::PaymentInstrumentDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::payments::mojom::PaymentInstrumentDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::payments::mojom::internal::PaymentInstrument_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::name(input)) in_name = Traits::name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->name)::BaseType> name_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_name,
      name_fragment);

    fragment->name.Set(
        name_fragment.is_null() ? nullptr : name_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->name.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null name in PaymentInstrument struct");

    decltype(Traits::icons(input)) in_icons = Traits::icons(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->icons)::BaseType>
        icons_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& icons_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::ManifestImageResourceDataView>>(
      in_icons,
      icons_fragment,
      &icons_validate_params);

    fragment->icons.Set(
        icons_fragment.is_null() ? nullptr : icons_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->icons.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null icons in PaymentInstrument struct");

    decltype(Traits::method(input)) in_method = Traits::method(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->method)::BaseType> method_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_method,
      method_fragment);

    fragment->method.Set(
        method_fragment.is_null() ? nullptr : method_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->method.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null method in PaymentInstrument struct");
  }

  static bool Deserialize(::payments::mojom::internal::PaymentInstrument_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::payments::mojom::PaymentInstrumentDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::payments::mojom::CanMakePaymentEventDataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::payments::mojom::CanMakePaymentEventDataDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::payments::mojom::internal::CanMakePaymentEventData_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::top_origin(input)) in_top_origin = Traits::top_origin(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->top_origin)::BaseType> top_origin_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_top_origin,
      top_origin_fragment);

    fragment->top_origin.Set(
        top_origin_fragment.is_null() ? nullptr : top_origin_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->top_origin.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null top_origin in CanMakePaymentEventData struct");

    decltype(Traits::payment_request_origin(input)) in_payment_request_origin = Traits::payment_request_origin(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->payment_request_origin)::BaseType> payment_request_origin_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_payment_request_origin,
      payment_request_origin_fragment);

    fragment->payment_request_origin.Set(
        payment_request_origin_fragment.is_null() ? nullptr : payment_request_origin_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->payment_request_origin.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null payment_request_origin in CanMakePaymentEventData struct");

    decltype(Traits::method_data(input)) in_method_data = Traits::method_data(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->method_data)::BaseType>
        method_data_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& method_data_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::payments::mojom::PaymentMethodDataDataView>>(
      in_method_data,
      method_data_fragment,
      &method_data_validate_params);

    fragment->method_data.Set(
        method_data_fragment.is_null() ? nullptr : method_data_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->method_data.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null method_data in CanMakePaymentEventData struct");

    decltype(Traits::modifiers(input)) in_modifiers = Traits::modifiers(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->modifiers)::BaseType>
        modifiers_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& modifiers_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::payments::mojom::PaymentDetailsModifierDataView>>(
      in_modifiers,
      modifiers_fragment,
      &modifiers_validate_params);

    fragment->modifiers.Set(
        modifiers_fragment.is_null() ? nullptr : modifiers_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->modifiers.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null modifiers in CanMakePaymentEventData struct");
  }

  static bool Deserialize(::payments::mojom::internal::CanMakePaymentEventData_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::payments::mojom::CanMakePaymentEventDataDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::payments::mojom::PaymentRequestEventDataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::payments::mojom::PaymentRequestEventDataDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::payments::mojom::internal::PaymentRequestEventData_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::top_origin(input)) in_top_origin = Traits::top_origin(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->top_origin)::BaseType> top_origin_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_top_origin,
      top_origin_fragment);

    fragment->top_origin.Set(
        top_origin_fragment.is_null() ? nullptr : top_origin_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->top_origin.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null top_origin in PaymentRequestEventData struct");

    decltype(Traits::payment_request_origin(input)) in_payment_request_origin = Traits::payment_request_origin(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->payment_request_origin)::BaseType> payment_request_origin_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_payment_request_origin,
      payment_request_origin_fragment);

    fragment->payment_request_origin.Set(
        payment_request_origin_fragment.is_null() ? nullptr : payment_request_origin_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->payment_request_origin.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null payment_request_origin in PaymentRequestEventData struct");

    decltype(Traits::payment_request_id(input)) in_payment_request_id = Traits::payment_request_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->payment_request_id)::BaseType> payment_request_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_payment_request_id,
      payment_request_id_fragment);

    fragment->payment_request_id.Set(
        payment_request_id_fragment.is_null() ? nullptr : payment_request_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->payment_request_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null payment_request_id in PaymentRequestEventData struct");

    decltype(Traits::method_data(input)) in_method_data = Traits::method_data(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->method_data)::BaseType>
        method_data_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& method_data_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::payments::mojom::PaymentMethodDataDataView>>(
      in_method_data,
      method_data_fragment,
      &method_data_validate_params);

    fragment->method_data.Set(
        method_data_fragment.is_null() ? nullptr : method_data_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->method_data.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null method_data in PaymentRequestEventData struct");

    decltype(Traits::total(input)) in_total = Traits::total(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->total)::BaseType> total_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::payments::mojom::PaymentCurrencyAmountDataView>(
      in_total,
      total_fragment);

    fragment->total.Set(
        total_fragment.is_null() ? nullptr : total_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->total.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null total in PaymentRequestEventData struct");

    decltype(Traits::modifiers(input)) in_modifiers = Traits::modifiers(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->modifiers)::BaseType>
        modifiers_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& modifiers_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::payments::mojom::PaymentDetailsModifierDataView>>(
      in_modifiers,
      modifiers_fragment,
      &modifiers_validate_params);

    fragment->modifiers.Set(
        modifiers_fragment.is_null() ? nullptr : modifiers_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->modifiers.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null modifiers in PaymentRequestEventData struct");

    decltype(Traits::instrument_key(input)) in_instrument_key = Traits::instrument_key(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->instrument_key)::BaseType> instrument_key_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_instrument_key,
      instrument_key_fragment);

    fragment->instrument_key.Set(
        instrument_key_fragment.is_null() ? nullptr : instrument_key_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->instrument_key.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null instrument_key in PaymentRequestEventData struct");

    decltype(Traits::payment_options(input)) in_payment_options = Traits::payment_options(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->payment_options)::BaseType> payment_options_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::payments::mojom::PaymentOptionsDataView>(
      in_payment_options,
      payment_options_fragment);

    fragment->payment_options.Set(
        payment_options_fragment.is_null() ? nullptr : payment_options_fragment.data());

    decltype(Traits::shipping_options(input)) in_shipping_options = Traits::shipping_options(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->shipping_options)::BaseType>
        shipping_options_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& shipping_options_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::payments::mojom::PaymentShippingOptionDataView>>(
      in_shipping_options,
      shipping_options_fragment,
      &shipping_options_validate_params);

    fragment->shipping_options.Set(
        shipping_options_fragment.is_null() ? nullptr : shipping_options_fragment.data());

    decltype(Traits::payment_handler_host(input)) in_payment_handler_host = Traits::payment_handler_host(input);

    
    mojo::internal::Serialize<mojo::InterfacePtrDataView<::payments::mojom::PaymentHandlerHostInterfaceBase>>(
      in_payment_handler_host,
      &fragment->payment_handler_host,
      &fragment.message());
  }

  static bool Deserialize(::payments::mojom::internal::PaymentRequestEventData_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::payments::mojom::PaymentRequestEventDataDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::payments::mojom::CanMakePaymentResponseDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::payments::mojom::CanMakePaymentResponseDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::payments::mojom::internal::CanMakePaymentResponse_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    
    mojo::internal::Serialize<::payments::mojom::CanMakePaymentEventResponseType>(
      Traits::response_type(input),
      &fragment->response_type);

    fragment->can_make_payment = Traits::can_make_payment(input);
  }

  static bool Deserialize(::payments::mojom::internal::CanMakePaymentResponse_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::payments::mojom::CanMakePaymentResponseDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::payments::mojom::PaymentHandlerResponseDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::payments::mojom::PaymentHandlerResponseDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::payments::mojom::internal::PaymentHandlerResponse_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::method_name(input)) in_method_name = Traits::method_name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->method_name)::BaseType> method_name_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_method_name,
      method_name_fragment);

    fragment->method_name.Set(
        method_name_fragment.is_null() ? nullptr : method_name_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->method_name.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null method_name in PaymentHandlerResponse struct");

    decltype(Traits::stringified_details(input)) in_stringified_details = Traits::stringified_details(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->stringified_details)::BaseType> stringified_details_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_stringified_details,
      stringified_details_fragment);

    fragment->stringified_details.Set(
        stringified_details_fragment.is_null() ? nullptr : stringified_details_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->stringified_details.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null stringified_details in PaymentHandlerResponse struct");

    
    mojo::internal::Serialize<::payments::mojom::PaymentEventResponseType>(
      Traits::response_type(input),
      &fragment->response_type);

    decltype(Traits::payer_name(input)) in_payer_name = Traits::payer_name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->payer_name)::BaseType> payer_name_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_payer_name,
      payer_name_fragment);

    fragment->payer_name.Set(
        payer_name_fragment.is_null() ? nullptr : payer_name_fragment.data());

    decltype(Traits::payer_email(input)) in_payer_email = Traits::payer_email(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->payer_email)::BaseType> payer_email_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_payer_email,
      payer_email_fragment);

    fragment->payer_email.Set(
        payer_email_fragment.is_null() ? nullptr : payer_email_fragment.data());

    decltype(Traits::payer_phone(input)) in_payer_phone = Traits::payer_phone(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->payer_phone)::BaseType> payer_phone_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_payer_phone,
      payer_phone_fragment);

    fragment->payer_phone.Set(
        payer_phone_fragment.is_null() ? nullptr : payer_phone_fragment.data());

    decltype(Traits::shipping_address(input)) in_shipping_address = Traits::shipping_address(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->shipping_address)::BaseType> shipping_address_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::payments::mojom::PaymentAddressDataView>(
      in_shipping_address,
      shipping_address_fragment);

    fragment->shipping_address.Set(
        shipping_address_fragment.is_null() ? nullptr : shipping_address_fragment.data());

    decltype(Traits::shipping_option(input)) in_shipping_option = Traits::shipping_option(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->shipping_option)::BaseType> shipping_option_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_shipping_option,
      shipping_option_fragment);

    fragment->shipping_option.Set(
        shipping_option_fragment.is_null() ? nullptr : shipping_option_fragment.data());
  }

  static bool Deserialize(::payments::mojom::internal::PaymentHandlerResponse_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::payments::mojom::PaymentHandlerResponseDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace payments::mojom {

inline void PaymentInstrumentDataView::GetNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->name.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void PaymentInstrumentDataView::GetIconsDataView(
    mojo::ArrayDataView<::blink::mojom::ManifestImageResourceDataView>* output) {
  auto pointer = data_->icons.Get();
  *output = mojo::ArrayDataView<::blink::mojom::ManifestImageResourceDataView>(pointer, message_);
}
inline void PaymentInstrumentDataView::GetMethodDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->method.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void CanMakePaymentEventDataDataView::GetTopOriginDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->top_origin.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void CanMakePaymentEventDataDataView::GetPaymentRequestOriginDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->payment_request_origin.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void CanMakePaymentEventDataDataView::GetMethodDataDataView(
    mojo::ArrayDataView<::payments::mojom::PaymentMethodDataDataView>* output) {
  auto pointer = data_->method_data.Get();
  *output = mojo::ArrayDataView<::payments::mojom::PaymentMethodDataDataView>(pointer, message_);
}
inline void CanMakePaymentEventDataDataView::GetModifiersDataView(
    mojo::ArrayDataView<::payments::mojom::PaymentDetailsModifierDataView>* output) {
  auto pointer = data_->modifiers.Get();
  *output = mojo::ArrayDataView<::payments::mojom::PaymentDetailsModifierDataView>(pointer, message_);
}


inline void PaymentRequestEventDataDataView::GetTopOriginDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->top_origin.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void PaymentRequestEventDataDataView::GetPaymentRequestOriginDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->payment_request_origin.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void PaymentRequestEventDataDataView::GetPaymentRequestIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->payment_request_id.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void PaymentRequestEventDataDataView::GetMethodDataDataView(
    mojo::ArrayDataView<::payments::mojom::PaymentMethodDataDataView>* output) {
  auto pointer = data_->method_data.Get();
  *output = mojo::ArrayDataView<::payments::mojom::PaymentMethodDataDataView>(pointer, message_);
}
inline void PaymentRequestEventDataDataView::GetTotalDataView(
    ::payments::mojom::PaymentCurrencyAmountDataView* output) {
  auto pointer = data_->total.Get();
  *output = ::payments::mojom::PaymentCurrencyAmountDataView(pointer, message_);
}
inline void PaymentRequestEventDataDataView::GetModifiersDataView(
    mojo::ArrayDataView<::payments::mojom::PaymentDetailsModifierDataView>* output) {
  auto pointer = data_->modifiers.Get();
  *output = mojo::ArrayDataView<::payments::mojom::PaymentDetailsModifierDataView>(pointer, message_);
}
inline void PaymentRequestEventDataDataView::GetInstrumentKeyDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->instrument_key.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void PaymentRequestEventDataDataView::GetPaymentOptionsDataView(
    ::payments::mojom::PaymentOptionsDataView* output) {
  auto pointer = data_->payment_options.Get();
  *output = ::payments::mojom::PaymentOptionsDataView(pointer, message_);
}
inline void PaymentRequestEventDataDataView::GetShippingOptionsDataView(
    mojo::ArrayDataView<::payments::mojom::PaymentShippingOptionDataView>* output) {
  auto pointer = data_->shipping_options.Get();
  *output = mojo::ArrayDataView<::payments::mojom::PaymentShippingOptionDataView>(pointer, message_);
}




inline void PaymentHandlerResponseDataView::GetMethodNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->method_name.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void PaymentHandlerResponseDataView::GetStringifiedDetailsDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->stringified_details.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void PaymentHandlerResponseDataView::GetPayerNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->payer_name.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void PaymentHandlerResponseDataView::GetPayerEmailDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->payer_email.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void PaymentHandlerResponseDataView::GetPayerPhoneDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->payer_phone.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void PaymentHandlerResponseDataView::GetShippingAddressDataView(
    ::payments::mojom::PaymentAddressDataView* output) {
  auto pointer = data_->shipping_address.Get();
  *output = ::payments::mojom::PaymentAddressDataView(pointer, message_);
}
inline void PaymentHandlerResponseDataView::GetShippingOptionDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->shipping_option.Get();
  *output = mojo::StringDataView(pointer, message_);
}



}  // payments::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::payments::mojom::PaymentHandlerStatus> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::payments::mojom::PaymentHandlerStatus value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::payments::mojom::CanMakePaymentEventResponseType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::payments::mojom::CanMakePaymentEventResponseType value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::payments::mojom::PaymentEventResponseType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::payments::mojom::PaymentEventResponseType value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::payments::mojom::PaymentDelegation> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::payments::mojom::PaymentDelegation value);
};

} // namespace perfetto

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_PAYMENTS_PAYMENT_APP_MOJOM_SHARED_H_