// third_party/blink/public/mojom/payments/payment_app.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_PAYMENTS_PAYMENT_APP_MOJOM_DATA_VIEW_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_PAYMENTS_PAYMENT_APP_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/blink/public/mojom/payments/payment_app.mojom-shared-internal.h"
#include "components/payments/mojom/payment_request_data.mojom-shared.h"
#include "third_party/blink/public/mojom/manifest/manifest.mojom-shared.h"
#include "third_party/blink/public/mojom/payments/payment_request.mojom-shared.h"
#include "third_party/blink/public/mojom/payments/payment_handler_host.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"


namespace payments::mojom {
class PaymentInstrumentDataView;

class CanMakePaymentEventDataDataView;

class PaymentRequestEventDataDataView;

class CanMakePaymentResponseDataView;

class PaymentHandlerResponseDataView;



}  // payments::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::payments::mojom::PaymentInstrumentDataView> {
  using Data = ::payments::mojom::internal::PaymentInstrument_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::payments::mojom::CanMakePaymentEventDataDataView> {
  using Data = ::payments::mojom::internal::CanMakePaymentEventData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::payments::mojom::PaymentRequestEventDataDataView> {
  using Data = ::payments::mojom::internal::PaymentRequestEventData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::payments::mojom::CanMakePaymentResponseDataView> {
  using Data = ::payments::mojom::internal::CanMakePaymentResponse_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::payments::mojom::PaymentHandlerResponseDataView> {
  using Data = ::payments::mojom::internal::PaymentHandlerResponse_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace payments::mojom {


enum class PaymentHandlerStatus : int32_t {
  
  SUCCESS = 0,
  
  NOT_FOUND = 1,
  
  NO_ACTIVE_WORKER = 2,
  
  STORAGE_OPERATION_FAILED = 3,
  
  FETCH_INSTRUMENT_ICON_FAILED = 4,
  
  FETCH_PAYMENT_APP_INFO_FAILED = 5,
  kMinValue = 0,
  kMaxValue = 5,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, PaymentHandlerStatus value);
inline bool IsKnownEnumValue(PaymentHandlerStatus value) {
  return internal::PaymentHandlerStatus_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class CanMakePaymentEventResponseType : int32_t {
  
  INCOGNITO = 0,
  
  NO_EXPLICITLY_VERIFIED_METHODS = 1,
  
  NOT_INSTALLED = 2,
  
  NO_URL_BASED_PAYMENT_METHODS = 3,
  
  BOOLEAN_CONVERSION_ERROR = 4,
  
  BROWSER_ERROR = 5,
  
  INTERNAL_ERROR = 6,
  
  NO_RESPONSE = 7,
  
  REJECT = 8,
  
  SUCCESS = 9,
  
  TIMEOUT = 10,
  kMinValue = 0,
  kMaxValue = 10,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, CanMakePaymentEventResponseType value);
inline bool IsKnownEnumValue(CanMakePaymentEventResponseType value) {
  return internal::CanMakePaymentEventResponseType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class PaymentEventResponseType : int32_t {
  
  PAYER_NAME_EMPTY = 0,
  
  PAYER_EMAIL_EMPTY = 1,
  
  PAYER_PHONE_EMPTY = 2,
  
  PAYMENT_DETAILS_ABSENT = 3,
  
  PAYMENT_DETAILS_NOT_OBJECT = 4,
  
  PAYMENT_DETAILS_STRINGIFY_ERROR = 5,
  
  PAYMENT_EVENT_BROWSER_ERROR = 6,
  
  PAYMENT_EVENT_INTERNAL_ERROR = 7,
  
  PAYMENT_EVENT_NO_RESPONSE = 8,
  
  PAYMENT_EVENT_REJECT = 9,
  
  PAYMENT_EVENT_SERVICE_WORKER_ERROR = 10,
  
  PAYMENT_EVENT_SUCCESS = 11,
  
  PAYMENT_EVENT_TIMEOUT = 12,
  
  PAYMENT_HANDLER_ACTIVITY_DIED = 13,
  
  PAYMENT_HANDLER_FAIL_TO_LOAD_MAIN_FRAME = 14,
  
  PAYMENT_HANDLER_INSECURE_NAVIGATION = 15,
  
  PAYMENT_HANDLER_INSTALL_FAILED = 16,
  
  PAYMENT_HANDLER_WINDOW_CLOSING = 17,
  
  PAYMENT_METHOD_NAME_EMPTY = 18,
  
  SHIPPING_ADDRESS_INVALID = 19,
  
  SHIPPING_OPTION_EMPTY = 20,
  kMinValue = 0,
  kMaxValue = 20,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, PaymentEventResponseType value);
inline bool IsKnownEnumValue(PaymentEventResponseType value) {
  return internal::PaymentEventResponseType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class PaymentDelegation : int32_t {
  
  SHIPPING_ADDRESS = 0,
  
  PAYER_NAME = 1,
  
  PAYER_PHONE = 2,
  
  PAYER_EMAIL = 3,
  kMinValue = 0,
  kMaxValue = 3,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, PaymentDelegation value);
inline bool IsKnownEnumValue(PaymentDelegation value) {
  return internal::PaymentDelegation_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class PaymentManagerInterfaceBase {};

using PaymentManagerPtrDataView =
    mojo::InterfacePtrDataView<PaymentManagerInterfaceBase>;
using PaymentManagerRequestDataView =
    mojo::InterfaceRequestDataView<PaymentManagerInterfaceBase>;
using PaymentManagerAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<PaymentManagerInterfaceBase>;
using PaymentManagerAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<PaymentManagerInterfaceBase>;
class PaymentHandlerResponseCallbackInterfaceBase {};

using PaymentHandlerResponseCallbackPtrDataView =
    mojo::InterfacePtrDataView<PaymentHandlerResponseCallbackInterfaceBase>;
using PaymentHandlerResponseCallbackRequestDataView =
    mojo::InterfaceRequestDataView<PaymentHandlerResponseCallbackInterfaceBase>;
using PaymentHandlerResponseCallbackAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<PaymentHandlerResponseCallbackInterfaceBase>;
using PaymentHandlerResponseCallbackAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<PaymentHandlerResponseCallbackInterfaceBase>;


class PaymentInstrumentDataView {
 public:
  PaymentInstrumentDataView() = default;

  PaymentInstrumentDataView(
      internal::PaymentInstrument_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadName(UserType* output) {
    
    auto* pointer = data_->name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetIconsDataView(
      mojo::ArrayDataView<::blink::mojom::ManifestImageResourceDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadIcons(UserType* output) {
    
    auto* pointer = data_->icons.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::ManifestImageResourceDataView>>(
        pointer, output, message_);
  }
  inline void GetMethodDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMethod(UserType* output) {
    
    auto* pointer = data_->method.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::PaymentInstrument_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class CanMakePaymentEventDataDataView {
 public:
  CanMakePaymentEventDataDataView() = default;

  CanMakePaymentEventDataDataView(
      internal::CanMakePaymentEventData_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetTopOriginDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTopOrigin(UserType* output) {
    
    auto* pointer = data_->top_origin.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetPaymentRequestOriginDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPaymentRequestOrigin(UserType* output) {
    
    auto* pointer = data_->payment_request_origin.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetMethodDataDataView(
      mojo::ArrayDataView<::payments::mojom::PaymentMethodDataDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMethodData(UserType* output) {
    
    auto* pointer = data_->method_data.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::payments::mojom::PaymentMethodDataDataView>>(
        pointer, output, message_);
  }
  inline void GetModifiersDataView(
      mojo::ArrayDataView<::payments::mojom::PaymentDetailsModifierDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadModifiers(UserType* output) {
    
    auto* pointer = data_->modifiers.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::payments::mojom::PaymentDetailsModifierDataView>>(
        pointer, output, message_);
  }
 private:
  internal::CanMakePaymentEventData_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PaymentRequestEventDataDataView {
 public:
  PaymentRequestEventDataDataView() = default;

  PaymentRequestEventDataDataView(
      internal::PaymentRequestEventData_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetTopOriginDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTopOrigin(UserType* output) {
    
    auto* pointer = data_->top_origin.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetPaymentRequestOriginDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPaymentRequestOrigin(UserType* output) {
    
    auto* pointer = data_->payment_request_origin.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetPaymentRequestIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPaymentRequestId(UserType* output) {
    
    auto* pointer = data_->payment_request_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetMethodDataDataView(
      mojo::ArrayDataView<::payments::mojom::PaymentMethodDataDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMethodData(UserType* output) {
    
    auto* pointer = data_->method_data.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::payments::mojom::PaymentMethodDataDataView>>(
        pointer, output, message_);
  }
  inline void GetTotalDataView(
      ::payments::mojom::PaymentCurrencyAmountDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTotal(UserType* output) {
    
    auto* pointer = data_->total.Get();
    return mojo::internal::Deserialize<::payments::mojom::PaymentCurrencyAmountDataView>(
        pointer, output, message_);
  }
  inline void GetModifiersDataView(
      mojo::ArrayDataView<::payments::mojom::PaymentDetailsModifierDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadModifiers(UserType* output) {
    
    auto* pointer = data_->modifiers.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::payments::mojom::PaymentDetailsModifierDataView>>(
        pointer, output, message_);
  }
  inline void GetInstrumentKeyDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInstrumentKey(UserType* output) {
    
    auto* pointer = data_->instrument_key.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetPaymentOptionsDataView(
      ::payments::mojom::PaymentOptionsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPaymentOptions(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::payments::mojom::PaymentOptionsDataView, UserType>(),
    "Attempting to read the optional `payment_options` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadPaymentOptions` instead "
    "of `ReadPaymentOptions if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->payment_options.Get();
    return mojo::internal::Deserialize<::payments::mojom::PaymentOptionsDataView>(
        pointer, output, message_);
  }
  inline void GetShippingOptionsDataView(
      mojo::ArrayDataView<::payments::mojom::PaymentShippingOptionDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadShippingOptions(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::ArrayDataView<::payments::mojom::PaymentShippingOptionDataView>, UserType>(),
    "Attempting to read the optional `shipping_options` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadShippingOptions` instead "
    "of `ReadShippingOptions if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->shipping_options.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::payments::mojom::PaymentShippingOptionDataView>>(
        pointer, output, message_);
  }
  template <typename UserType>
  UserType TakePaymentHandlerHost() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::payments::mojom::PaymentHandlerHostInterfaceBase>>(
            &data_->payment_handler_host, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::PaymentRequestEventData_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class CanMakePaymentResponseDataView {
 public:
  CanMakePaymentResponseDataView() = default;

  CanMakePaymentResponseDataView(
      internal::CanMakePaymentResponse_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadResponseType(UserType* output) const {
    auto data_value = data_->response_type;
    return mojo::internal::Deserialize<::payments::mojom::CanMakePaymentEventResponseType>(
        data_value, output);
  }
  CanMakePaymentEventResponseType response_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::payments::mojom::CanMakePaymentEventResponseType>(data_->response_type));
  }
  bool can_make_payment() const {
    return data_->can_make_payment;
  }
 private:
  internal::CanMakePaymentResponse_Data* data_ = nullptr;
};


class PaymentHandlerResponseDataView {
 public:
  PaymentHandlerResponseDataView() = default;

  PaymentHandlerResponseDataView(
      internal::PaymentHandlerResponse_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetMethodNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMethodName(UserType* output) {
    
    auto* pointer = data_->method_name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetStringifiedDetailsDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadStringifiedDetails(UserType* output) {
    
    auto* pointer = data_->stringified_details.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadResponseType(UserType* output) const {
    auto data_value = data_->response_type;
    return mojo::internal::Deserialize<::payments::mojom::PaymentEventResponseType>(
        data_value, output);
  }
  PaymentEventResponseType response_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::payments::mojom::PaymentEventResponseType>(data_->response_type));
  }
  inline void GetPayerNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPayerName(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `payer_name` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadPayerName` instead "
    "of `ReadPayerName if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->payer_name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetPayerEmailDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPayerEmail(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `payer_email` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadPayerEmail` instead "
    "of `ReadPayerEmail if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->payer_email.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetPayerPhoneDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPayerPhone(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `payer_phone` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadPayerPhone` instead "
    "of `ReadPayerPhone if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->payer_phone.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetShippingAddressDataView(
      ::payments::mojom::PaymentAddressDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadShippingAddress(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::payments::mojom::PaymentAddressDataView, UserType>(),
    "Attempting to read the optional `shipping_address` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadShippingAddress` instead "
    "of `ReadShippingAddress if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->shipping_address.Get();
    return mojo::internal::Deserialize<::payments::mojom::PaymentAddressDataView>(
        pointer, output, message_);
  }
  inline void GetShippingOptionDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadShippingOption(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `shipping_option` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadShippingOption` instead "
    "of `ReadShippingOption if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->shipping_option.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::PaymentHandlerResponse_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // payments::mojom

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_PAYMENTS_PAYMENT_APP_MOJOM_DATA_VIEW_H_