// third_party/blink/public/mojom/payments/payment_app.mojom-blink-test-utils.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_PAYMENTS_PAYMENT_APP_MOJOM_BLINK_TEST_UTILS_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_PAYMENTS_PAYMENT_APP_MOJOM_BLINK_TEST_UTILS_H_

#include "third_party/blink/public/mojom/payments/payment_app.mojom-blink.h"
#include "third_party/blink/renderer/platform/platform_export.h"


namespace payments::mojom::blink {


class PLATFORM_EXPORT PaymentManagerInterceptorForTesting : public PaymentManager {
  virtual PaymentManager* GetForwardingInterface() = 0;
  void Init(const ::blink::KURL& context_url, const ::blink::String& service_worker_scope) override;
  void DeletePaymentInstrument(const ::blink::String& instrument_key, DeletePaymentInstrumentCallback callback) override;
  void GetPaymentInstrument(const ::blink::String& instrument_key, GetPaymentInstrumentCallback callback) override;
  void KeysOfPaymentInstruments(KeysOfPaymentInstrumentsCallback callback) override;
  void HasPaymentInstrument(const ::blink::String& instrument_key, HasPaymentInstrumentCallback callback) override;
  void SetPaymentInstrument(const ::blink::String& instrument_key, PaymentInstrumentPtr instrument, SetPaymentInstrumentCallback callback) override;
  void ClearPaymentInstruments(ClearPaymentInstrumentsCallback callback) override;
  void SetUserHint(const ::blink::String& user_hint) override;
  void EnableDelegations(const ::blink::Vector<PaymentDelegation>& delegations, EnableDelegationsCallback callback) override;
};
class PLATFORM_EXPORT PaymentManagerAsyncWaiter {
 public:
  explicit PaymentManagerAsyncWaiter(PaymentManager* proxy);

  PaymentManagerAsyncWaiter(const PaymentManagerAsyncWaiter&) = delete;
  PaymentManagerAsyncWaiter& operator=(const PaymentManagerAsyncWaiter&) = delete;

  ~PaymentManagerAsyncWaiter();
  void DeletePaymentInstrument(
      const ::blink::String& instrument_key, PaymentHandlerStatus* out_status);
  PaymentHandlerStatus DeletePaymentInstrument(const ::blink::String& instrument_key);
  void GetPaymentInstrument(
      const ::blink::String& instrument_key, PaymentInstrumentPtr* out_instrument, PaymentHandlerStatus* out_status);
  
  void KeysOfPaymentInstruments(
      ::blink::Vector<::blink::String>* out_keys, PaymentHandlerStatus* out_status);
  
  void HasPaymentInstrument(
      const ::blink::String& instrument_key, PaymentHandlerStatus* out_status);
  PaymentHandlerStatus HasPaymentInstrument(const ::blink::String& instrument_key);
  void SetPaymentInstrument(
      const ::blink::String& instrument_key, PaymentInstrumentPtr instrument, PaymentHandlerStatus* out_status);
  PaymentHandlerStatus SetPaymentInstrument(const ::blink::String& instrument_key, PaymentInstrumentPtr instrument);
  void ClearPaymentInstruments(
      PaymentHandlerStatus* out_status);
  PaymentHandlerStatus ClearPaymentInstruments();
  void EnableDelegations(
      const ::blink::Vector<PaymentDelegation>& delegations, PaymentHandlerStatus* out_status);
  PaymentHandlerStatus EnableDelegations(const ::blink::Vector<PaymentDelegation>& delegations);

 private:
  PaymentManager* const proxy_;
};


class PLATFORM_EXPORT PaymentHandlerResponseCallbackInterceptorForTesting : public PaymentHandlerResponseCallback {
  virtual PaymentHandlerResponseCallback* GetForwardingInterface() = 0;
  void OnResponseForAbortPayment(bool payment_aborted) override;
  void OnResponseForCanMakePayment(CanMakePaymentResponsePtr response) override;
  void OnResponseForPaymentRequest(PaymentHandlerResponsePtr response) override;
};
class PLATFORM_EXPORT PaymentHandlerResponseCallbackAsyncWaiter {
 public:
  explicit PaymentHandlerResponseCallbackAsyncWaiter(PaymentHandlerResponseCallback* proxy);

  PaymentHandlerResponseCallbackAsyncWaiter(const PaymentHandlerResponseCallbackAsyncWaiter&) = delete;
  PaymentHandlerResponseCallbackAsyncWaiter& operator=(const PaymentHandlerResponseCallbackAsyncWaiter&) = delete;

  ~PaymentHandlerResponseCallbackAsyncWaiter();

 private:
  PaymentHandlerResponseCallback* const proxy_;
};




}  // payments::mojom::blink

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_PAYMENTS_PAYMENT_APP_MOJOM_BLINK_TEST_UTILS_H_