// third_party/blink/public/mojom/parakeet/ad_request.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_PARAKEET_AD_REQUEST_MOJOM_SHARED_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_PARAKEET_AD_REQUEST_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/parakeet/ad_request.mojom-shared-internal.h"
#include "url/mojom/url.mojom-shared.h"




#include "third_party/blink/public/mojom/parakeet/ad_request.mojom-data-view.h"
#include "base/component_export.h"




namespace std {

template <>
struct hash<::blink::mojom::AdSignals>
    : public mojo::internal::EnumHashImpl<::blink::mojom::AdSignals> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::AdSignals, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::AdSignals, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::AdSignals>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::AdPropertiesDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::AdPropertiesDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::AdProperties_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::width(input)) in_width = Traits::width(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->width)::BaseType> width_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_width,
      width_fragment);

    fragment->width.Set(
        width_fragment.is_null() ? nullptr : width_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->width.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null width in AdProperties struct");

    decltype(Traits::height(input)) in_height = Traits::height(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->height)::BaseType> height_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_height,
      height_fragment);

    fragment->height.Set(
        height_fragment.is_null() ? nullptr : height_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->height.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null height in AdProperties struct");

    decltype(Traits::slot(input)) in_slot = Traits::slot(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->slot)::BaseType> slot_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_slot,
      slot_fragment);

    fragment->slot.Set(
        slot_fragment.is_null() ? nullptr : slot_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->slot.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null slot in AdProperties struct");

    decltype(Traits::lang(input)) in_lang = Traits::lang(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->lang)::BaseType> lang_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_lang,
      lang_fragment);

    fragment->lang.Set(
        lang_fragment.is_null() ? nullptr : lang_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->lang.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null lang in AdProperties struct");

    decltype(Traits::ad_type(input)) in_ad_type = Traits::ad_type(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->ad_type)::BaseType> ad_type_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_ad_type,
      ad_type_fragment);

    fragment->ad_type.Set(
        ad_type_fragment.is_null() ? nullptr : ad_type_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->ad_type.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null ad_type in AdProperties struct");

    fragment->bid_floor = Traits::bid_floor(input);
  }

  static bool Deserialize(::blink::mojom::internal::AdProperties_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::AdPropertiesDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::AdGeolocationDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::AdGeolocationDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::AdGeolocation_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->latitude = Traits::latitude(input);

    fragment->longitude = Traits::longitude(input);
  }

  static bool Deserialize(::blink::mojom::internal::AdGeolocation_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::AdGeolocationDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::AdTargetingDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::AdTargetingDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::AdTargeting_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::interests(input)) in_interests = Traits::interests(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->interests)::BaseType>
        interests_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& interests_validate_params =
        mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
      in_interests,
      interests_fragment,
      &interests_validate_params);

    fragment->interests.Set(
        interests_fragment.is_null() ? nullptr : interests_fragment.data());

    decltype(Traits::geolocation(input)) in_geolocation = Traits::geolocation(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->geolocation)::BaseType> geolocation_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::blink::mojom::AdGeolocationDataView>(
      in_geolocation,
      geolocation_fragment);

    fragment->geolocation.Set(
        geolocation_fragment.is_null() ? nullptr : geolocation_fragment.data());
  }

  static bool Deserialize(::blink::mojom::internal::AdTargeting_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::AdTargetingDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::AdRequestConfigDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::AdRequestConfigDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::AdRequestConfig_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::ad_request_url(input)) in_ad_request_url = Traits::ad_request_url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->ad_request_url)::BaseType> ad_request_url_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_ad_request_url,
      ad_request_url_fragment);

    fragment->ad_request_url.Set(
        ad_request_url_fragment.is_null() ? nullptr : ad_request_url_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->ad_request_url.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null ad_request_url in AdRequestConfig struct");

    decltype(Traits::ad_properties(input)) in_ad_properties = Traits::ad_properties(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->ad_properties)::BaseType>
        ad_properties_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& ad_properties_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::AdPropertiesDataView>>(
      in_ad_properties,
      ad_properties_fragment,
      &ad_properties_validate_params);

    fragment->ad_properties.Set(
        ad_properties_fragment.is_null() ? nullptr : ad_properties_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->ad_properties.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null ad_properties in AdRequestConfig struct");

    decltype(Traits::publisher_code(input)) in_publisher_code = Traits::publisher_code(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->publisher_code)::BaseType> publisher_code_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_publisher_code,
      publisher_code_fragment);

    fragment->publisher_code.Set(
        publisher_code_fragment.is_null() ? nullptr : publisher_code_fragment.data());

    decltype(Traits::targeting(input)) in_targeting = Traits::targeting(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->targeting)::BaseType> targeting_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::blink::mojom::AdTargetingDataView>(
      in_targeting,
      targeting_fragment);

    fragment->targeting.Set(
        targeting_fragment.is_null() ? nullptr : targeting_fragment.data());

    decltype(Traits::anonymized_proxied_signals(input)) in_anonymized_proxied_signals = Traits::anonymized_proxied_signals(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->anonymized_proxied_signals)::BaseType>
        anonymized_proxied_signals_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& anonymized_proxied_signals_validate_params =
        mojo::internal::GetArrayOfEnumsValidator<0, false, ::blink::mojom::internal::AdSignals_Data::Validate>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::AdSignals>>(
      in_anonymized_proxied_signals,
      anonymized_proxied_signals_fragment,
      &anonymized_proxied_signals_validate_params);

    fragment->anonymized_proxied_signals.Set(
        anonymized_proxied_signals_fragment.is_null() ? nullptr : anonymized_proxied_signals_fragment.data());

    decltype(Traits::fallback_source(input)) in_fallback_source = Traits::fallback_source(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->fallback_source)::BaseType> fallback_source_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_fallback_source,
      fallback_source_fragment);

    fragment->fallback_source.Set(
        fallback_source_fragment.is_null() ? nullptr : fallback_source_fragment.data());
  }

  static bool Deserialize(::blink::mojom::internal::AdRequestConfig_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::AdRequestConfigDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace blink::mojom {

inline void AdPropertiesDataView::GetWidthDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->width.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void AdPropertiesDataView::GetHeightDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->height.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void AdPropertiesDataView::GetSlotDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->slot.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void AdPropertiesDataView::GetLangDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->lang.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void AdPropertiesDataView::GetAdTypeDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->ad_type.Get();
  *output = mojo::StringDataView(pointer, message_);
}




inline void AdTargetingDataView::GetInterestsDataView(
    mojo::ArrayDataView<mojo::StringDataView>* output) {
  auto pointer = data_->interests.Get();
  *output = mojo::ArrayDataView<mojo::StringDataView>(pointer, message_);
}
inline void AdTargetingDataView::GetGeolocationDataView(
    AdGeolocationDataView* output) {
  auto pointer = data_->geolocation.Get();
  *output = AdGeolocationDataView(pointer, message_);
}


inline void AdRequestConfigDataView::GetAdRequestUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->ad_request_url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void AdRequestConfigDataView::GetAdPropertiesDataView(
    mojo::ArrayDataView<AdPropertiesDataView>* output) {
  auto pointer = data_->ad_properties.Get();
  *output = mojo::ArrayDataView<AdPropertiesDataView>(pointer, message_);
}
inline void AdRequestConfigDataView::GetPublisherCodeDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->publisher_code.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void AdRequestConfigDataView::GetTargetingDataView(
    AdTargetingDataView* output) {
  auto pointer = data_->targeting.Get();
  *output = AdTargetingDataView(pointer, message_);
}
inline void AdRequestConfigDataView::GetAnonymizedProxiedSignalsDataView(
    mojo::ArrayDataView<AdSignals>* output) {
  auto pointer = data_->anonymized_proxied_signals.Get();
  *output = mojo::ArrayDataView<AdSignals>(pointer, message_);
}
inline void AdRequestConfigDataView::GetFallbackSourceDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->fallback_source.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}



}  // blink::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::blink::mojom::AdSignals> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::blink::mojom::AdSignals value);
};

} // namespace perfetto

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_PARAKEET_AD_REQUEST_MOJOM_SHARED_H_