// third_party/blink/public/mojom/parakeet/ad_request.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_PARAKEET_AD_REQUEST_MOJOM_DATA_VIEW_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_PARAKEET_AD_REQUEST_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/blink/public/mojom/parakeet/ad_request.mojom-shared-internal.h"
#include "url/mojom/url.mojom-shared.h"


namespace blink::mojom {
class AdPropertiesDataView;

class AdGeolocationDataView;

class AdTargetingDataView;

class AdRequestConfigDataView;



}  // blink::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::blink::mojom::AdPropertiesDataView> {
  using Data = ::blink::mojom::internal::AdProperties_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::AdGeolocationDataView> {
  using Data = ::blink::mojom::internal::AdGeolocation_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::AdTargetingDataView> {
  using Data = ::blink::mojom::internal::AdTargeting_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::AdRequestConfigDataView> {
  using Data = ::blink::mojom::internal::AdRequestConfig_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace blink::mojom {


enum class AdSignals : int32_t {
  
  kCourseGeolocation = 0,
  
  kCourseUserAgent = 1,
  
  kTargeting = 2,
  
  kUserAdInterests = 3,
  kMinValue = 0,
  kMaxValue = 3,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, AdSignals value);
inline bool IsKnownEnumValue(AdSignals value) {
  return internal::AdSignals_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


class AdPropertiesDataView {
 public:
  AdPropertiesDataView() = default;

  AdPropertiesDataView(
      internal::AdProperties_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetWidthDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadWidth(UserType* output) {
    
    auto* pointer = data_->width.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetHeightDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadHeight(UserType* output) {
    
    auto* pointer = data_->height.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetSlotDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSlot(UserType* output) {
    
    auto* pointer = data_->slot.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetLangDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLang(UserType* output) {
    
    auto* pointer = data_->lang.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetAdTypeDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAdType(UserType* output) {
    
    auto* pointer = data_->ad_type.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  double bid_floor() const {
    return data_->bid_floor;
  }
 private:
  internal::AdProperties_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class AdGeolocationDataView {
 public:
  AdGeolocationDataView() = default;

  AdGeolocationDataView(
      internal::AdGeolocation_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  double latitude() const {
    return data_->latitude;
  }
  double longitude() const {
    return data_->longitude;
  }
 private:
  internal::AdGeolocation_Data* data_ = nullptr;
};


class AdTargetingDataView {
 public:
  AdTargetingDataView() = default;

  AdTargetingDataView(
      internal::AdTargeting_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetInterestsDataView(
      mojo::ArrayDataView<mojo::StringDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInterests(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::ArrayDataView<mojo::StringDataView>, UserType>(),
    "Attempting to read the optional `interests` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadInterests` instead "
    "of `ReadInterests if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->interests.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<mojo::StringDataView>>(
        pointer, output, message_);
  }
  inline void GetGeolocationDataView(
      AdGeolocationDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadGeolocation(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::AdGeolocationDataView, UserType>(),
    "Attempting to read the optional `geolocation` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadGeolocation` instead "
    "of `ReadGeolocation if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->geolocation.Get();
    return mojo::internal::Deserialize<::blink::mojom::AdGeolocationDataView>(
        pointer, output, message_);
  }
 private:
  internal::AdTargeting_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class AdRequestConfigDataView {
 public:
  AdRequestConfigDataView() = default;

  AdRequestConfigDataView(
      internal::AdRequestConfig_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetAdRequestUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAdRequestUrl(UserType* output) {
    
    auto* pointer = data_->ad_request_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetAdPropertiesDataView(
      mojo::ArrayDataView<AdPropertiesDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAdProperties(UserType* output) {
    
    auto* pointer = data_->ad_properties.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::AdPropertiesDataView>>(
        pointer, output, message_);
  }
  inline void GetPublisherCodeDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPublisherCode(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `publisher_code` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadPublisherCode` instead "
    "of `ReadPublisherCode if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->publisher_code.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetTargetingDataView(
      AdTargetingDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTargeting(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::AdTargetingDataView, UserType>(),
    "Attempting to read the optional `targeting` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadTargeting` instead "
    "of `ReadTargeting if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->targeting.Get();
    return mojo::internal::Deserialize<::blink::mojom::AdTargetingDataView>(
        pointer, output, message_);
  }
  inline void GetAnonymizedProxiedSignalsDataView(
      mojo::ArrayDataView<AdSignals>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAnonymizedProxiedSignals(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::ArrayDataView<::blink::mojom::AdSignals>, UserType>(),
    "Attempting to read the optional `anonymized_proxied_signals` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadAnonymizedProxiedSignals` instead "
    "of `ReadAnonymizedProxiedSignals if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->anonymized_proxied_signals.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::AdSignals>>(
        pointer, output, message_);
  }
  inline void GetFallbackSourceDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFallbackSource(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::url::mojom::UrlDataView, UserType>(),
    "Attempting to read the optional `fallback_source` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadFallbackSource` instead "
    "of `ReadFallbackSource if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->fallback_source.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
 private:
  internal::AdRequestConfig_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // blink::mojom

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_PARAKEET_AD_REQUEST_MOJOM_DATA_VIEW_H_