// third_party/blink/public/mojom/page_state/page_state.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_PAGE_STATE_PAGE_STATE_MOJOM_BLINK_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_PAGE_STATE_PAGE_STATE_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/page_state/page_state.mojom-features.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/page_state/page_state.mojom-shared.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/page_state/page_state.mojom-blink-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/string16.mojom-blink.h"
#include "mojo/public/mojom/base/time.mojom-blink.h"
#include "services/network/public/mojom/referrer_policy.mojom-blink-forward.h"
#include "url/mojom/url.mojom-blink.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-blink.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"




#include "third_party/blink/renderer/core/core_export.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace blink::mojom::blink {












class CORE_EXPORT Element {
 public:
  using DataView = ElementDataView;
  using Data_ = internal::Element_Data;
  using Tag = Data_::Element_Tag;

  template <typename... Args>
  static ElementPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |blob_uuid|.
  static ElementPtr NewBlobUuid(
      const ::blink::String& value);
  // Construct an instance holding |bytes|.
  static ElementPtr NewBytes(
      ::blink::Vector<uint8_t> value);
  // Construct an instance holding |file|.
  static ElementPtr NewFile(
      FilePtr value);
  // Construct an instance holding |DEPRECATED_file_system_file|.
  static ElementPtr NewDeprecatedFileSystemFile(
      DEPRECATED_FileSystemFilePtr value);

  template <typename U>
  static ElementPtr From(const U& u) {
    return mojo::TypeConverter<ElementPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, Element>::Convert(*this);
  }
  ~Element();

  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  Element(const Element& other) = delete;
  Element& operator=(const Element& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = ElementPtr>
  ElementPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, Element>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, Element>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  Tag which() const {
    return tag_;
  }

  bool is_blob_uuid() const { return tag_ == Tag::kBlobUuid; }
  const ::blink::String& get_blob_uuid() const {
    CHECK(tag_ == Tag::kBlobUuid);
    return data_.blob_uuid;
  }
  ::blink::String& get_blob_uuid() {
    CHECK(tag_ == Tag::kBlobUuid);
    return data_.blob_uuid;
  }
  void set_blob_uuid(const ::blink::String& blob_uuid);

  bool is_bytes() const { return tag_ == Tag::kBytes; }
  const ::blink::Vector<uint8_t>& get_bytes() const {
    CHECK(tag_ == Tag::kBytes);
    return data_.bytes;
  }
  ::blink::Vector<uint8_t>& get_bytes() {
    CHECK(tag_ == Tag::kBytes);
    return data_.bytes;
  }
  void set_bytes(::blink::Vector<uint8_t> bytes);

  bool is_file() const { return tag_ == Tag::kFile; }
  const FilePtr& get_file() const {
    CHECK(tag_ == Tag::kFile);
    return data_.file;
  }
  FilePtr& get_file() {
    CHECK(tag_ == Tag::kFile);
    return data_.file;
  }
  void set_file(FilePtr file);

  bool is_DEPRECATED_file_system_file() const { return tag_ == Tag::kDeprecatedFileSystemFile; }
  const DEPRECATED_FileSystemFilePtr& get_DEPRECATED_file_system_file() const {
    CHECK(tag_ == Tag::kDeprecatedFileSystemFile);
    return data_.DEPRECATED_file_system_file;
  }
  DEPRECATED_FileSystemFilePtr& get_DEPRECATED_file_system_file() {
    CHECK(tag_ == Tag::kDeprecatedFileSystemFile);
    return data_.DEPRECATED_file_system_file;
  }
  void set_DEPRECATED_file_system_file(DEPRECATED_FileSystemFilePtr DEPRECATED_file_system_file);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        Element::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<Element::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kBlobUuid)>,
        const ::blink::String& value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kBytes)>,
        ::blink::Vector<uint8_t> value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kFile)>,
        FilePtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kDeprecatedFileSystemFile)>,
        DEPRECATED_FileSystemFilePtr value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    ::blink::String blob_uuid;
    ::blink::Vector<uint8_t> bytes;
    FilePtr file;
    DEPRECATED_FileSystemFilePtr DEPRECATED_file_system_file;
  };

  Element(
      std::in_place_index_t<static_cast<size_t>(Tag::kBlobUuid)>,
      const ::blink::String& value);
  Element(
      std::in_place_index_t<static_cast<size_t>(Tag::kBytes)>,
      ::blink::Vector<uint8_t> value);
  Element(
      std::in_place_index_t<static_cast<size_t>(Tag::kFile)>,
      FilePtr value);
  Element(
      std::in_place_index_t<static_cast<size_t>(Tag::kDeprecatedFileSystemFile)>,
      DEPRECATED_FileSystemFilePtr value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};





class CORE_EXPORT DEPRECATED_FileSystemFile {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<DEPRECATED_FileSystemFile, T>::value>;
  using DataView = DEPRECATED_FileSystemFileDataView;
  using Data_ = internal::DEPRECATED_FileSystemFile_Data;

  template <typename... Args>
  static DEPRECATED_FileSystemFilePtr New(Args&&... args) {
    return DEPRECATED_FileSystemFilePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static DEPRECATED_FileSystemFilePtr From(const U& u) {
    return mojo::TypeConverter<DEPRECATED_FileSystemFilePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, DEPRECATED_FileSystemFile>::Convert(*this);
  }


  DEPRECATED_FileSystemFile();

  DEPRECATED_FileSystemFile(
      const ::blink::KURL& filesystem_url,
      uint64_t offset,
      uint64_t length,
      ::base::Time modification_time);


  ~DEPRECATED_FileSystemFile();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = DEPRECATED_FileSystemFilePtr>
  DEPRECATED_FileSystemFilePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, DEPRECATED_FileSystemFile::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, DEPRECATED_FileSystemFile::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, DEPRECATED_FileSystemFile::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DEPRECATED_FileSystemFile::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DEPRECATED_FileSystemFile::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        DEPRECATED_FileSystemFile::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::DEPRECATED_FileSystemFile_UnserializedMessageContext<
            UserType, DEPRECATED_FileSystemFile::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<DEPRECATED_FileSystemFile::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return DEPRECATED_FileSystemFile::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::DEPRECATED_FileSystemFile_UnserializedMessageContext<
            UserType, DEPRECATED_FileSystemFile::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<DEPRECATED_FileSystemFile::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::KURL filesystem_url;
  
  uint64_t offset;
  
  uint64_t length;
  
  ::base::Time modification_time;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, DEPRECATED_FileSystemFile::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, DEPRECATED_FileSystemFile::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, DEPRECATED_FileSystemFile::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, DEPRECATED_FileSystemFile::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class CORE_EXPORT File {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<File, T>::value>;
  using DataView = FileDataView;
  using Data_ = internal::File_Data;

  template <typename... Args>
  static FilePtr New(Args&&... args) {
    return FilePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static FilePtr From(const U& u) {
    return mojo::TypeConverter<FilePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, File>::Convert(*this);
  }


  File();

  File(
      const ::blink::String& path,
      uint64_t offset,
      uint64_t length,
      ::base::Time modification_time);


  ~File();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = FilePtr>
  FilePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, File::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, File::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, File::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        File::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        File::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        File::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::File_UnserializedMessageContext<
            UserType, File::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<File::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return File::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::File_UnserializedMessageContext<
            UserType, File::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<File::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::String path;
  
  uint64_t offset;
  
  uint64_t length;
  
  ::base::Time modification_time;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, File::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, File::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, File::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, File::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class CORE_EXPORT RequestBody {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<RequestBody, T>::value>;
  using DataView = RequestBodyDataView;
  using Data_ = internal::RequestBody_Data;

  template <typename... Args>
  static RequestBodyPtr New(Args&&... args) {
    return RequestBodyPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static RequestBodyPtr From(const U& u) {
    return mojo::TypeConverter<RequestBodyPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, RequestBody>::Convert(*this);
  }


  RequestBody();

  RequestBody(
      ::blink::Vector<ElementPtr> elements,
      int64_t identifier,
      bool contains_sensitive_info);

RequestBody(const RequestBody&) = delete;
RequestBody& operator=(const RequestBody&) = delete;

  ~RequestBody();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = RequestBodyPtr>
  RequestBodyPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, RequestBody::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, RequestBody::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, RequestBody::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        RequestBody::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        RequestBody::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        RequestBody::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::RequestBody_UnserializedMessageContext<
            UserType, RequestBody::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<RequestBody::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return RequestBody::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::RequestBody_UnserializedMessageContext<
            UserType, RequestBody::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<RequestBody::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::Vector<ElementPtr> elements;
  
  int64_t identifier;
  
  bool contains_sensitive_info;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, RequestBody::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, RequestBody::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, RequestBody::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, RequestBody::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class CORE_EXPORT HttpBody {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<HttpBody, T>::value>;
  using DataView = HttpBodyDataView;
  using Data_ = internal::HttpBody_Data;

  template <typename... Args>
  static HttpBodyPtr New(Args&&... args) {
    return HttpBodyPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static HttpBodyPtr From(const U& u) {
    return mojo::TypeConverter<HttpBodyPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, HttpBody>::Convert(*this);
  }


  HttpBody();

  HttpBody(
      const ::blink::String& http_content_type,
      RequestBodyPtr request_body,
      bool contains_passwords);

HttpBody(const HttpBody&) = delete;
HttpBody& operator=(const HttpBody&) = delete;

  ~HttpBody();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = HttpBodyPtr>
  HttpBodyPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, HttpBody::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, HttpBody::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, HttpBody::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        HttpBody::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        HttpBody::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        HttpBody::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::HttpBody_UnserializedMessageContext<
            UserType, HttpBody::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<HttpBody::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return HttpBody::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::HttpBody_UnserializedMessageContext<
            UserType, HttpBody::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<HttpBody::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::String http_content_type;
  
  RequestBodyPtr request_body;
  
  bool contains_passwords;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, HttpBody::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, HttpBody::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, HttpBody::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, HttpBody::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class CORE_EXPORT ViewState {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ViewState, T>::value>;
  using DataView = ViewStateDataView;
  using Data_ = internal::ViewState_Data;

  template <typename... Args>
  static ViewStatePtr New(Args&&... args) {
    return ViewStatePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ViewStatePtr From(const U& u) {
    return mojo::TypeConverter<ViewStatePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ViewState>::Convert(*this);
  }


  ViewState();

  ViewState(
      const ::gfx::PointF& visual_viewport_scroll_offset,
      const ::gfx::Point& scroll_offset,
      double page_scale_factor);

  ViewState(
      const ::gfx::PointF& visual_viewport_scroll_offset,
      const ::gfx::Point& scroll_offset,
      double page_scale_factor,
      const ::blink::String& scroll_anchor_selector,
      const std::optional<::gfx::PointF>& scroll_anchor_offset,
      uint64_t scroll_anchor_simhash);


  ~ViewState();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ViewStatePtr>
  ViewStatePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ViewState::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ViewState::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ViewState::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ViewState::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ViewState::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ViewState::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ViewState_UnserializedMessageContext<
            UserType, ViewState::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ViewState::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ViewState::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ViewState_UnserializedMessageContext<
            UserType, ViewState::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ViewState::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::gfx::PointF visual_viewport_scroll_offset;
  
  ::gfx::Point scroll_offset;
  
  double page_scale_factor;
  
  ::blink::String scroll_anchor_selector;
  
  std::optional<::gfx::PointF> scroll_anchor_offset;
  
  uint64_t scroll_anchor_simhash;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ViewState::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ViewState::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ViewState::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ViewState::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class CORE_EXPORT FrameState {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<FrameState, T>::value>;
  using DataView = FrameStateDataView;
  using Data_ = internal::FrameState_Data;

  template <typename... Args>
  static FrameStatePtr New(Args&&... args) {
    return FrameStatePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static FrameStatePtr From(const U& u) {
    return mojo::TypeConverter<FrameStatePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, FrameState>::Convert(*this);
  }


  FrameState();

  FrameState(
      const ::blink::String& url_string,
      const ::blink::String& referrer,
      const ::blink::String& target,
      const ::blink::String& state_object,
      ::blink::Vector<::blink::String> document_state,
      ScrollRestorationType scroll_restoration_type,
      ViewStatePtr view_state,
      int64_t item_sequence_number,
      int64_t document_sequence_number,
      ::network::mojom::blink::ReferrerPolicy referrer_policy,
      HttpBodyPtr http_body,
      ::blink::Vector<FrameStatePtr> children);

  FrameState(
      const ::blink::String& url_string,
      const ::blink::String& referrer,
      const ::blink::String& target,
      const ::blink::String& state_object,
      ::blink::Vector<::blink::String> document_state,
      ScrollRestorationType scroll_restoration_type,
      ViewStatePtr view_state,
      int64_t item_sequence_number,
      int64_t document_sequence_number,
      ::network::mojom::blink::ReferrerPolicy referrer_policy,
      HttpBodyPtr http_body,
      ::blink::Vector<FrameStatePtr> children,
      const ::blink::String& initiator_origin);

  FrameState(
      const ::blink::String& url_string,
      const ::blink::String& referrer,
      const ::blink::String& target,
      const ::blink::String& state_object,
      ::blink::Vector<::blink::String> document_state,
      ScrollRestorationType scroll_restoration_type,
      ViewStatePtr view_state,
      int64_t item_sequence_number,
      int64_t document_sequence_number,
      ::network::mojom::blink::ReferrerPolicy referrer_policy,
      HttpBodyPtr http_body,
      ::blink::Vector<FrameStatePtr> children,
      const ::blink::String& initiator_origin,
      const ::blink::String& navigation_api_key,
      const ::blink::String& navigation_api_id);

  FrameState(
      const ::blink::String& url_string,
      const ::blink::String& referrer,
      const ::blink::String& target,
      const ::blink::String& state_object,
      ::blink::Vector<::blink::String> document_state,
      ScrollRestorationType scroll_restoration_type,
      ViewStatePtr view_state,
      int64_t item_sequence_number,
      int64_t document_sequence_number,
      ::network::mojom::blink::ReferrerPolicy referrer_policy,
      HttpBodyPtr http_body,
      ::blink::Vector<FrameStatePtr> children,
      const ::blink::String& initiator_origin,
      const ::blink::String& navigation_api_key,
      const ::blink::String& navigation_api_id,
      const ::blink::String& navigation_api_state);

  FrameState(
      const ::blink::String& url_string,
      const ::blink::String& referrer,
      const ::blink::String& target,
      const ::blink::String& state_object,
      ::blink::Vector<::blink::String> document_state,
      ScrollRestorationType scroll_restoration_type,
      ViewStatePtr view_state,
      int64_t item_sequence_number,
      int64_t document_sequence_number,
      ::network::mojom::blink::ReferrerPolicy referrer_policy,
      HttpBodyPtr http_body,
      ::blink::Vector<FrameStatePtr> children,
      const ::blink::String& initiator_origin,
      const ::blink::String& navigation_api_key,
      const ::blink::String& navigation_api_id,
      const ::blink::String& navigation_api_state,
      bool protect_url_in_navigation_api);

  FrameState(
      const ::blink::String& url_string,
      const ::blink::String& referrer,
      const ::blink::String& target,
      const ::blink::String& state_object,
      ::blink::Vector<::blink::String> document_state,
      ScrollRestorationType scroll_restoration_type,
      ViewStatePtr view_state,
      int64_t item_sequence_number,
      int64_t document_sequence_number,
      ::network::mojom::blink::ReferrerPolicy referrer_policy,
      HttpBodyPtr http_body,
      ::blink::Vector<FrameStatePtr> children,
      const ::blink::String& initiator_origin,
      const ::blink::String& navigation_api_key,
      const ::blink::String& navigation_api_id,
      const ::blink::String& navigation_api_state,
      bool protect_url_in_navigation_api,
      const ::blink::String& initiator_base_url_string);

FrameState(const FrameState&) = delete;
FrameState& operator=(const FrameState&) = delete;

  ~FrameState();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = FrameStatePtr>
  FrameStatePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, FrameState::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, FrameState::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, FrameState::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        FrameState::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        FrameState::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        FrameState::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::FrameState_UnserializedMessageContext<
            UserType, FrameState::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<FrameState::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return FrameState::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::FrameState_UnserializedMessageContext<
            UserType, FrameState::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<FrameState::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::String url_string;
  
  ::blink::String referrer;
  
  ::blink::String target;
  
  ::blink::String state_object;
  
  ::blink::Vector<::blink::String> document_state;
  
  ScrollRestorationType scroll_restoration_type;
  
  ViewStatePtr view_state;
  
  int64_t item_sequence_number;
  
  int64_t document_sequence_number;
  
  ::network::mojom::blink::ReferrerPolicy referrer_policy;
  
  HttpBodyPtr http_body;
  
  ::blink::Vector<FrameStatePtr> children;
  
  ::blink::String initiator_origin;
  
  ::blink::String navigation_api_key;
  
  ::blink::String navigation_api_id;
  
  ::blink::String navigation_api_state;
  
  bool protect_url_in_navigation_api;
  
  ::blink::String initiator_base_url_string;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, FrameState::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, FrameState::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, FrameState::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, FrameState::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class CORE_EXPORT PageState {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<PageState, T>::value>;
  using DataView = PageStateDataView;
  using Data_ = internal::PageState_Data;

  template <typename... Args>
  static PageStatePtr New(Args&&... args) {
    return PageStatePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PageStatePtr From(const U& u) {
    return mojo::TypeConverter<PageStatePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PageState>::Convert(*this);
  }


  PageState();

  PageState(
      ::blink::Vector<::blink::String> referenced_files,
      FrameStatePtr top);

PageState(const PageState&) = delete;
PageState& operator=(const PageState&) = delete;

  ~PageState();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PageStatePtr>
  PageStatePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, PageState::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, PageState::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, PageState::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PageState::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PageState::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PageState::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::PageState_UnserializedMessageContext<
            UserType, PageState::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<PageState::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return PageState::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::PageState_UnserializedMessageContext<
            UserType, PageState::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<PageState::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::Vector<::blink::String> referenced_files;
  
  FrameStatePtr top;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, PageState::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, PageState::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, PageState::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, PageState::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename UnionPtrType>
ElementPtr Element::Clone() const {
  switch (tag_) {
    case Tag::kBlobUuid:
      return NewBlobUuid(
          mojo::Clone(data_.blob_uuid));
    case Tag::kBytes:
      return NewBytes(
          mojo::Clone(data_.bytes));
    case Tag::kFile:
      return NewFile(
          mojo::Clone(data_.file));
    case Tag::kDeprecatedFileSystemFile:
      return NewDeprecatedFileSystemFile(
          mojo::Clone(data_.DEPRECATED_file_system_file));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, Element>::value>::type*>
bool Element::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kBlobUuid:
      return mojo::Equals(data_.blob_uuid, other.data_.blob_uuid);
    case Tag::kBytes:
      return mojo::Equals(data_.bytes, other.data_.bytes);
    case Tag::kFile:
      return mojo::Equals(data_.file, other.data_.file);
    case Tag::kDeprecatedFileSystemFile:
      return mojo::Equals(data_.DEPRECATED_file_system_file, other.data_.DEPRECATED_file_system_file);
  }

  return false;
}
template <typename StructPtrType>
DEPRECATED_FileSystemFilePtr DEPRECATED_FileSystemFile::Clone() const {
  return New(
      mojo::Clone(filesystem_url),
      mojo::Clone(offset),
      mojo::Clone(length),
      mojo::Clone(modification_time)
  );
}

template <typename T, DEPRECATED_FileSystemFile::EnableIfSame<T>*>
bool DEPRECATED_FileSystemFile::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->filesystem_url, other_struct.filesystem_url))
    return false;
  if (!mojo::Equals(this->offset, other_struct.offset))
    return false;
  if (!mojo::Equals(this->length, other_struct.length))
    return false;
  if (!mojo::Equals(this->modification_time, other_struct.modification_time))
    return false;
  return true;
}

template <typename T, DEPRECATED_FileSystemFile::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.filesystem_url < rhs.filesystem_url)
    return true;
  if (rhs.filesystem_url < lhs.filesystem_url)
    return false;
  if (lhs.offset < rhs.offset)
    return true;
  if (rhs.offset < lhs.offset)
    return false;
  if (lhs.length < rhs.length)
    return true;
  if (rhs.length < lhs.length)
    return false;
  if (lhs.modification_time < rhs.modification_time)
    return true;
  if (rhs.modification_time < lhs.modification_time)
    return false;
  return false;
}
template <typename StructPtrType>
FilePtr File::Clone() const {
  return New(
      mojo::Clone(path),
      mojo::Clone(offset),
      mojo::Clone(length),
      mojo::Clone(modification_time)
  );
}

template <typename T, File::EnableIfSame<T>*>
bool File::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->path, other_struct.path))
    return false;
  if (!mojo::Equals(this->offset, other_struct.offset))
    return false;
  if (!mojo::Equals(this->length, other_struct.length))
    return false;
  if (!mojo::Equals(this->modification_time, other_struct.modification_time))
    return false;
  return true;
}

template <typename T, File::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.path < rhs.path)
    return true;
  if (rhs.path < lhs.path)
    return false;
  if (lhs.offset < rhs.offset)
    return true;
  if (rhs.offset < lhs.offset)
    return false;
  if (lhs.length < rhs.length)
    return true;
  if (rhs.length < lhs.length)
    return false;
  if (lhs.modification_time < rhs.modification_time)
    return true;
  if (rhs.modification_time < lhs.modification_time)
    return false;
  return false;
}
template <typename StructPtrType>
RequestBodyPtr RequestBody::Clone() const {
  return New(
      mojo::Clone(elements),
      mojo::Clone(identifier),
      mojo::Clone(contains_sensitive_info)
  );
}

template <typename T, RequestBody::EnableIfSame<T>*>
bool RequestBody::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->elements, other_struct.elements))
    return false;
  if (!mojo::Equals(this->identifier, other_struct.identifier))
    return false;
  if (!mojo::Equals(this->contains_sensitive_info, other_struct.contains_sensitive_info))
    return false;
  return true;
}

template <typename T, RequestBody::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.elements < rhs.elements)
    return true;
  if (rhs.elements < lhs.elements)
    return false;
  if (lhs.identifier < rhs.identifier)
    return true;
  if (rhs.identifier < lhs.identifier)
    return false;
  if (lhs.contains_sensitive_info < rhs.contains_sensitive_info)
    return true;
  if (rhs.contains_sensitive_info < lhs.contains_sensitive_info)
    return false;
  return false;
}
template <typename StructPtrType>
HttpBodyPtr HttpBody::Clone() const {
  return New(
      mojo::Clone(http_content_type),
      mojo::Clone(request_body),
      mojo::Clone(contains_passwords)
  );
}

template <typename T, HttpBody::EnableIfSame<T>*>
bool HttpBody::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->http_content_type, other_struct.http_content_type))
    return false;
  if (!mojo::Equals(this->request_body, other_struct.request_body))
    return false;
  if (!mojo::Equals(this->contains_passwords, other_struct.contains_passwords))
    return false;
  return true;
}

template <typename T, HttpBody::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.http_content_type < rhs.http_content_type)
    return true;
  if (rhs.http_content_type < lhs.http_content_type)
    return false;
  if (lhs.request_body < rhs.request_body)
    return true;
  if (rhs.request_body < lhs.request_body)
    return false;
  if (lhs.contains_passwords < rhs.contains_passwords)
    return true;
  if (rhs.contains_passwords < lhs.contains_passwords)
    return false;
  return false;
}
template <typename StructPtrType>
ViewStatePtr ViewState::Clone() const {
  return New(
      mojo::Clone(visual_viewport_scroll_offset),
      mojo::Clone(scroll_offset),
      mojo::Clone(page_scale_factor),
      mojo::Clone(scroll_anchor_selector),
      mojo::Clone(scroll_anchor_offset),
      mojo::Clone(scroll_anchor_simhash)
  );
}

template <typename T, ViewState::EnableIfSame<T>*>
bool ViewState::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->visual_viewport_scroll_offset, other_struct.visual_viewport_scroll_offset))
    return false;
  if (!mojo::Equals(this->scroll_offset, other_struct.scroll_offset))
    return false;
  if (!mojo::Equals(this->page_scale_factor, other_struct.page_scale_factor))
    return false;
  if (!mojo::Equals(this->scroll_anchor_selector, other_struct.scroll_anchor_selector))
    return false;
  if (!mojo::Equals(this->scroll_anchor_offset, other_struct.scroll_anchor_offset))
    return false;
  if (!mojo::Equals(this->scroll_anchor_simhash, other_struct.scroll_anchor_simhash))
    return false;
  return true;
}

template <typename T, ViewState::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.visual_viewport_scroll_offset < rhs.visual_viewport_scroll_offset)
    return true;
  if (rhs.visual_viewport_scroll_offset < lhs.visual_viewport_scroll_offset)
    return false;
  if (lhs.scroll_offset < rhs.scroll_offset)
    return true;
  if (rhs.scroll_offset < lhs.scroll_offset)
    return false;
  if (lhs.page_scale_factor < rhs.page_scale_factor)
    return true;
  if (rhs.page_scale_factor < lhs.page_scale_factor)
    return false;
  if (lhs.scroll_anchor_selector < rhs.scroll_anchor_selector)
    return true;
  if (rhs.scroll_anchor_selector < lhs.scroll_anchor_selector)
    return false;
  if (lhs.scroll_anchor_offset < rhs.scroll_anchor_offset)
    return true;
  if (rhs.scroll_anchor_offset < lhs.scroll_anchor_offset)
    return false;
  if (lhs.scroll_anchor_simhash < rhs.scroll_anchor_simhash)
    return true;
  if (rhs.scroll_anchor_simhash < lhs.scroll_anchor_simhash)
    return false;
  return false;
}
template <typename StructPtrType>
FrameStatePtr FrameState::Clone() const {
  return New(
      mojo::Clone(url_string),
      mojo::Clone(referrer),
      mojo::Clone(target),
      mojo::Clone(state_object),
      mojo::Clone(document_state),
      mojo::Clone(scroll_restoration_type),
      mojo::Clone(view_state),
      mojo::Clone(item_sequence_number),
      mojo::Clone(document_sequence_number),
      mojo::Clone(referrer_policy),
      mojo::Clone(http_body),
      mojo::Clone(children),
      mojo::Clone(initiator_origin),
      mojo::Clone(navigation_api_key),
      mojo::Clone(navigation_api_id),
      mojo::Clone(navigation_api_state),
      mojo::Clone(protect_url_in_navigation_api),
      mojo::Clone(initiator_base_url_string)
  );
}

template <typename T, FrameState::EnableIfSame<T>*>
bool FrameState::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->url_string, other_struct.url_string))
    return false;
  if (!mojo::Equals(this->referrer, other_struct.referrer))
    return false;
  if (!mojo::Equals(this->target, other_struct.target))
    return false;
  if (!mojo::Equals(this->state_object, other_struct.state_object))
    return false;
  if (!mojo::Equals(this->document_state, other_struct.document_state))
    return false;
  if (!mojo::Equals(this->scroll_restoration_type, other_struct.scroll_restoration_type))
    return false;
  if (!mojo::Equals(this->view_state, other_struct.view_state))
    return false;
  if (!mojo::Equals(this->item_sequence_number, other_struct.item_sequence_number))
    return false;
  if (!mojo::Equals(this->document_sequence_number, other_struct.document_sequence_number))
    return false;
  if (!mojo::Equals(this->referrer_policy, other_struct.referrer_policy))
    return false;
  if (!mojo::Equals(this->http_body, other_struct.http_body))
    return false;
  if (!mojo::Equals(this->children, other_struct.children))
    return false;
  if (!mojo::Equals(this->initiator_origin, other_struct.initiator_origin))
    return false;
  if (!mojo::Equals(this->navigation_api_key, other_struct.navigation_api_key))
    return false;
  if (!mojo::Equals(this->navigation_api_id, other_struct.navigation_api_id))
    return false;
  if (!mojo::Equals(this->navigation_api_state, other_struct.navigation_api_state))
    return false;
  if (!mojo::Equals(this->protect_url_in_navigation_api, other_struct.protect_url_in_navigation_api))
    return false;
  if (!mojo::Equals(this->initiator_base_url_string, other_struct.initiator_base_url_string))
    return false;
  return true;
}

template <typename T, FrameState::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.url_string < rhs.url_string)
    return true;
  if (rhs.url_string < lhs.url_string)
    return false;
  if (lhs.referrer < rhs.referrer)
    return true;
  if (rhs.referrer < lhs.referrer)
    return false;
  if (lhs.target < rhs.target)
    return true;
  if (rhs.target < lhs.target)
    return false;
  if (lhs.state_object < rhs.state_object)
    return true;
  if (rhs.state_object < lhs.state_object)
    return false;
  if (lhs.document_state < rhs.document_state)
    return true;
  if (rhs.document_state < lhs.document_state)
    return false;
  if (lhs.scroll_restoration_type < rhs.scroll_restoration_type)
    return true;
  if (rhs.scroll_restoration_type < lhs.scroll_restoration_type)
    return false;
  if (lhs.view_state < rhs.view_state)
    return true;
  if (rhs.view_state < lhs.view_state)
    return false;
  if (lhs.item_sequence_number < rhs.item_sequence_number)
    return true;
  if (rhs.item_sequence_number < lhs.item_sequence_number)
    return false;
  if (lhs.document_sequence_number < rhs.document_sequence_number)
    return true;
  if (rhs.document_sequence_number < lhs.document_sequence_number)
    return false;
  if (lhs.referrer_policy < rhs.referrer_policy)
    return true;
  if (rhs.referrer_policy < lhs.referrer_policy)
    return false;
  if (lhs.http_body < rhs.http_body)
    return true;
  if (rhs.http_body < lhs.http_body)
    return false;
  if (lhs.children < rhs.children)
    return true;
  if (rhs.children < lhs.children)
    return false;
  if (lhs.initiator_origin < rhs.initiator_origin)
    return true;
  if (rhs.initiator_origin < lhs.initiator_origin)
    return false;
  if (lhs.navigation_api_key < rhs.navigation_api_key)
    return true;
  if (rhs.navigation_api_key < lhs.navigation_api_key)
    return false;
  if (lhs.navigation_api_id < rhs.navigation_api_id)
    return true;
  if (rhs.navigation_api_id < lhs.navigation_api_id)
    return false;
  if (lhs.navigation_api_state < rhs.navigation_api_state)
    return true;
  if (rhs.navigation_api_state < lhs.navigation_api_state)
    return false;
  if (lhs.protect_url_in_navigation_api < rhs.protect_url_in_navigation_api)
    return true;
  if (rhs.protect_url_in_navigation_api < lhs.protect_url_in_navigation_api)
    return false;
  if (lhs.initiator_base_url_string < rhs.initiator_base_url_string)
    return true;
  if (rhs.initiator_base_url_string < lhs.initiator_base_url_string)
    return false;
  return false;
}
template <typename StructPtrType>
PageStatePtr PageState::Clone() const {
  return New(
      mojo::Clone(referenced_files),
      mojo::Clone(top)
  );
}

template <typename T, PageState::EnableIfSame<T>*>
bool PageState::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->referenced_files, other_struct.referenced_files))
    return false;
  if (!mojo::Equals(this->top, other_struct.top))
    return false;
  return true;
}

template <typename T, PageState::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.referenced_files < rhs.referenced_files)
    return true;
  if (rhs.referenced_files < lhs.referenced_files)
    return false;
  if (lhs.top < rhs.top)
    return true;
  if (rhs.top < lhs.top)
    return false;
  return false;
}


}  // blink::mojom::blink

namespace mojo {


template <>
struct CORE_EXPORT StructTraits<::blink::mojom::blink::DEPRECATED_FileSystemFile::DataView,
                                         ::blink::mojom::blink::DEPRECATED_FileSystemFilePtr> {
  static bool IsNull(const ::blink::mojom::blink::DEPRECATED_FileSystemFilePtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::DEPRECATED_FileSystemFilePtr* output) { output->reset(); }

  static const decltype(::blink::mojom::blink::DEPRECATED_FileSystemFile::filesystem_url)& filesystem_url(
      const ::blink::mojom::blink::DEPRECATED_FileSystemFilePtr& input) {
    return input->filesystem_url;
  }

  static decltype(::blink::mojom::blink::DEPRECATED_FileSystemFile::offset) offset(
      const ::blink::mojom::blink::DEPRECATED_FileSystemFilePtr& input) {
    return input->offset;
  }

  static decltype(::blink::mojom::blink::DEPRECATED_FileSystemFile::length) length(
      const ::blink::mojom::blink::DEPRECATED_FileSystemFilePtr& input) {
    return input->length;
  }

  static const decltype(::blink::mojom::blink::DEPRECATED_FileSystemFile::modification_time)& modification_time(
      const ::blink::mojom::blink::DEPRECATED_FileSystemFilePtr& input) {
    return input->modification_time;
  }

  static bool Read(::blink::mojom::blink::DEPRECATED_FileSystemFile::DataView input, ::blink::mojom::blink::DEPRECATED_FileSystemFilePtr* output);
};


template <>
struct CORE_EXPORT StructTraits<::blink::mojom::blink::File::DataView,
                                         ::blink::mojom::blink::FilePtr> {
  static bool IsNull(const ::blink::mojom::blink::FilePtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::FilePtr* output) { output->reset(); }

  static const decltype(::blink::mojom::blink::File::path)& path(
      const ::blink::mojom::blink::FilePtr& input) {
    return input->path;
  }

  static decltype(::blink::mojom::blink::File::offset) offset(
      const ::blink::mojom::blink::FilePtr& input) {
    return input->offset;
  }

  static decltype(::blink::mojom::blink::File::length) length(
      const ::blink::mojom::blink::FilePtr& input) {
    return input->length;
  }

  static const decltype(::blink::mojom::blink::File::modification_time)& modification_time(
      const ::blink::mojom::blink::FilePtr& input) {
    return input->modification_time;
  }

  static bool Read(::blink::mojom::blink::File::DataView input, ::blink::mojom::blink::FilePtr* output);
};


template <>
struct CORE_EXPORT StructTraits<::blink::mojom::blink::RequestBody::DataView,
                                         ::blink::mojom::blink::RequestBodyPtr> {
  static bool IsNull(const ::blink::mojom::blink::RequestBodyPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::RequestBodyPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::blink::RequestBody::elements)& elements(
      const ::blink::mojom::blink::RequestBodyPtr& input) {
    return input->elements;
  }

  static decltype(::blink::mojom::blink::RequestBody::identifier) identifier(
      const ::blink::mojom::blink::RequestBodyPtr& input) {
    return input->identifier;
  }

  static decltype(::blink::mojom::blink::RequestBody::contains_sensitive_info) contains_sensitive_info(
      const ::blink::mojom::blink::RequestBodyPtr& input) {
    return input->contains_sensitive_info;
  }

  static bool Read(::blink::mojom::blink::RequestBody::DataView input, ::blink::mojom::blink::RequestBodyPtr* output);
};


template <>
struct CORE_EXPORT StructTraits<::blink::mojom::blink::HttpBody::DataView,
                                         ::blink::mojom::blink::HttpBodyPtr> {
  static bool IsNull(const ::blink::mojom::blink::HttpBodyPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::HttpBodyPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::blink::HttpBody::http_content_type)& http_content_type(
      const ::blink::mojom::blink::HttpBodyPtr& input) {
    return input->http_content_type;
  }

  static const decltype(::blink::mojom::blink::HttpBody::request_body)& request_body(
      const ::blink::mojom::blink::HttpBodyPtr& input) {
    return input->request_body;
  }

  static decltype(::blink::mojom::blink::HttpBody::contains_passwords) contains_passwords(
      const ::blink::mojom::blink::HttpBodyPtr& input) {
    return input->contains_passwords;
  }

  static bool Read(::blink::mojom::blink::HttpBody::DataView input, ::blink::mojom::blink::HttpBodyPtr* output);
};


template <>
struct CORE_EXPORT StructTraits<::blink::mojom::blink::ViewState::DataView,
                                         ::blink::mojom::blink::ViewStatePtr> {
  static bool IsNull(const ::blink::mojom::blink::ViewStatePtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::ViewStatePtr* output) { output->reset(); }

  static const decltype(::blink::mojom::blink::ViewState::visual_viewport_scroll_offset)& visual_viewport_scroll_offset(
      const ::blink::mojom::blink::ViewStatePtr& input) {
    return input->visual_viewport_scroll_offset;
  }

  static const decltype(::blink::mojom::blink::ViewState::scroll_offset)& scroll_offset(
      const ::blink::mojom::blink::ViewStatePtr& input) {
    return input->scroll_offset;
  }

  static decltype(::blink::mojom::blink::ViewState::page_scale_factor) page_scale_factor(
      const ::blink::mojom::blink::ViewStatePtr& input) {
    return input->page_scale_factor;
  }

  static const decltype(::blink::mojom::blink::ViewState::scroll_anchor_selector)& scroll_anchor_selector(
      const ::blink::mojom::blink::ViewStatePtr& input) {
    return input->scroll_anchor_selector;
  }

  static const decltype(::blink::mojom::blink::ViewState::scroll_anchor_offset)& scroll_anchor_offset(
      const ::blink::mojom::blink::ViewStatePtr& input) {
    return input->scroll_anchor_offset;
  }

  static decltype(::blink::mojom::blink::ViewState::scroll_anchor_simhash) scroll_anchor_simhash(
      const ::blink::mojom::blink::ViewStatePtr& input) {
    return input->scroll_anchor_simhash;
  }

  static bool Read(::blink::mojom::blink::ViewState::DataView input, ::blink::mojom::blink::ViewStatePtr* output);
};


template <>
struct CORE_EXPORT StructTraits<::blink::mojom::blink::FrameState::DataView,
                                         ::blink::mojom::blink::FrameStatePtr> {
  static bool IsNull(const ::blink::mojom::blink::FrameStatePtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::FrameStatePtr* output) { output->reset(); }

  static const decltype(::blink::mojom::blink::FrameState::url_string)& url_string(
      const ::blink::mojom::blink::FrameStatePtr& input) {
    return input->url_string;
  }

  static const decltype(::blink::mojom::blink::FrameState::referrer)& referrer(
      const ::blink::mojom::blink::FrameStatePtr& input) {
    return input->referrer;
  }

  static const decltype(::blink::mojom::blink::FrameState::target)& target(
      const ::blink::mojom::blink::FrameStatePtr& input) {
    return input->target;
  }

  static const decltype(::blink::mojom::blink::FrameState::state_object)& state_object(
      const ::blink::mojom::blink::FrameStatePtr& input) {
    return input->state_object;
  }

  static const decltype(::blink::mojom::blink::FrameState::document_state)& document_state(
      const ::blink::mojom::blink::FrameStatePtr& input) {
    return input->document_state;
  }

  static decltype(::blink::mojom::blink::FrameState::scroll_restoration_type) scroll_restoration_type(
      const ::blink::mojom::blink::FrameStatePtr& input) {
    return input->scroll_restoration_type;
  }

  static const decltype(::blink::mojom::blink::FrameState::view_state)& view_state(
      const ::blink::mojom::blink::FrameStatePtr& input) {
    return input->view_state;
  }

  static decltype(::blink::mojom::blink::FrameState::item_sequence_number) item_sequence_number(
      const ::blink::mojom::blink::FrameStatePtr& input) {
    return input->item_sequence_number;
  }

  static decltype(::blink::mojom::blink::FrameState::document_sequence_number) document_sequence_number(
      const ::blink::mojom::blink::FrameStatePtr& input) {
    return input->document_sequence_number;
  }

  static decltype(::blink::mojom::blink::FrameState::referrer_policy) referrer_policy(
      const ::blink::mojom::blink::FrameStatePtr& input) {
    return input->referrer_policy;
  }

  static const decltype(::blink::mojom::blink::FrameState::http_body)& http_body(
      const ::blink::mojom::blink::FrameStatePtr& input) {
    return input->http_body;
  }

  static const decltype(::blink::mojom::blink::FrameState::children)& children(
      const ::blink::mojom::blink::FrameStatePtr& input) {
    return input->children;
  }

  static const decltype(::blink::mojom::blink::FrameState::initiator_origin)& initiator_origin(
      const ::blink::mojom::blink::FrameStatePtr& input) {
    return input->initiator_origin;
  }

  static const decltype(::blink::mojom::blink::FrameState::navigation_api_key)& navigation_api_key(
      const ::blink::mojom::blink::FrameStatePtr& input) {
    return input->navigation_api_key;
  }

  static const decltype(::blink::mojom::blink::FrameState::navigation_api_id)& navigation_api_id(
      const ::blink::mojom::blink::FrameStatePtr& input) {
    return input->navigation_api_id;
  }

  static const decltype(::blink::mojom::blink::FrameState::navigation_api_state)& navigation_api_state(
      const ::blink::mojom::blink::FrameStatePtr& input) {
    return input->navigation_api_state;
  }

  static decltype(::blink::mojom::blink::FrameState::protect_url_in_navigation_api) protect_url_in_navigation_api(
      const ::blink::mojom::blink::FrameStatePtr& input) {
    return input->protect_url_in_navigation_api;
  }

  static const decltype(::blink::mojom::blink::FrameState::initiator_base_url_string)& initiator_base_url_string(
      const ::blink::mojom::blink::FrameStatePtr& input) {
    return input->initiator_base_url_string;
  }

  static bool Read(::blink::mojom::blink::FrameState::DataView input, ::blink::mojom::blink::FrameStatePtr* output);
};


template <>
struct CORE_EXPORT StructTraits<::blink::mojom::blink::PageState::DataView,
                                         ::blink::mojom::blink::PageStatePtr> {
  static bool IsNull(const ::blink::mojom::blink::PageStatePtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::PageStatePtr* output) { output->reset(); }

  static const decltype(::blink::mojom::blink::PageState::referenced_files)& referenced_files(
      const ::blink::mojom::blink::PageStatePtr& input) {
    return input->referenced_files;
  }

  static const decltype(::blink::mojom::blink::PageState::top)& top(
      const ::blink::mojom::blink::PageStatePtr& input) {
    return input->top;
  }

  static bool Read(::blink::mojom::blink::PageState::DataView input, ::blink::mojom::blink::PageStatePtr* output);
};


template <>
struct CORE_EXPORT UnionTraits<::blink::mojom::blink::Element::DataView,
                                        ::blink::mojom::blink::ElementPtr> {
  static bool IsNull(const ::blink::mojom::blink::ElementPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::ElementPtr* output) { output->reset(); }

  static ::blink::mojom::blink::Element::Tag GetTag(const ::blink::mojom::blink::ElementPtr& input) {
    return input->which();
  }

  static const ::blink::String& blob_uuid(const ::blink::mojom::blink::ElementPtr& input) {
    return input->get_blob_uuid();
  }

  static const ::blink::Vector<uint8_t>& bytes(const ::blink::mojom::blink::ElementPtr& input) {
    return input->get_bytes();
  }

  static const ::blink::mojom::blink::FilePtr& file(const ::blink::mojom::blink::ElementPtr& input) {
    return input->get_file();
  }

  static const ::blink::mojom::blink::DEPRECATED_FileSystemFilePtr& DEPRECATED_file_system_file(const ::blink::mojom::blink::ElementPtr& input) {
    return input->get_DEPRECATED_file_system_file();
  }

  static bool Read(::blink::mojom::blink::Element::DataView input, ::blink::mojom::blink::ElementPtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_PAGE_STATE_PAGE_STATE_MOJOM_BLINK_H_