// third_party/blink/public/mojom/page/widget.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'third_party/blink/public/mojom/page/widget.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('blink.mojom');
  var touch_action$ =
      mojo.internal.exposeNamespace('cc.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'cc/mojom/touch_action.mojom', '../../../../../cc/mojom/touch_action.mojom.js');
  }
  var text_direction$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/text_direction.mojom', '../../../../../mojo/public/mojom/base/text_direction.mojom.js');
  }
  var local_surface_id$ =
      mojo.internal.exposeNamespace('viz.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/viz/public/mojom/compositing/local_surface_id.mojom', '../../../../../services/viz/public/mojom/compositing/local_surface_id.mojom.js');
  }
  var bitmap$ =
      mojo.internal.exposeNamespace('skia.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'skia/public/mojom/bitmap.mojom', '../../../../../skia/public/mojom/bitmap.mojom.js');
  }
  var intrinsic_sizing_info$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/frame/intrinsic_sizing_info.mojom', '../frame/intrinsic_sizing_info.mojom.js');
  }
  var viewport_intersection_state$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/frame/viewport_intersection_state.mojom', '../frame/viewport_intersection_state.mojom.js');
  }
  var ime_host$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/input/ime_host.mojom', '../input/ime_host.mojom.js');
  }
  var touch_event$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/input/touch_event.mojom', '../input/touch_event.mojom.js');
  }
  var drag$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/drag/drag.mojom', '../drag/drag.mojom.js');
  }
  var platform_widget$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/widget/platform_widget.mojom', '../widget/platform_widget.mojom.js');
  }
  var device_emulation_params$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/widget/device_emulation_params.mojom', '../widget/device_emulation_params.mojom.js');
  }
  var visual_properties$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/widget/visual_properties.mojom', '../widget/visual_properties.mojom.js');
  }
  var drag_drop_types$ =
      mojo.internal.exposeNamespace('ui.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'ui/base/dragdrop/mojom/drag_drop_types.mojom', '../../../../../ui/base/dragdrop/mojom/drag_drop_types.mojom.js');
  }
  var ui_base_types$ =
      mojo.internal.exposeNamespace('ui.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'ui/base/mojom/ui_base_types.mojom', '../../../../../ui/base/mojom/ui_base_types.mojom.js');
  }
  var geometry$ =
      mojo.internal.exposeNamespace('gfx.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'ui/gfx/geometry/mojom/geometry.mojom', '../../../../../ui/gfx/geometry/mojom/geometry.mojom.js');
  }
  var range$ =
      mojo.internal.exposeNamespace('gfx.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'ui/gfx/range/mojom/range.mojom', '../../../../../ui/gfx/range/mojom/range.mojom.js');
  }
  var attributed_string$ =
      mojo.internal.exposeNamespace('ui.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'ui/base/mojom/attributed_string.mojom', '../../../../../ui/base/mojom/attributed_string.mojom.js');
  }


  var DeviceEmulationCacheBehavior = {};
  DeviceEmulationCacheBehavior.kClearCache = 0;
  DeviceEmulationCacheBehavior.kKeepCache = 1;
  DeviceEmulationCacheBehavior.MIN_VALUE = 0;
  DeviceEmulationCacheBehavior.MAX_VALUE = 1;

  DeviceEmulationCacheBehavior.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
      return true;
    }
    return false;
  };

  DeviceEmulationCacheBehavior.toKnownEnumValue = function(value) {
    return value;
  };

  DeviceEmulationCacheBehavior.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };

  function StylusWritingFocusResult(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  StylusWritingFocusResult.prototype.initDefaults_ = function() {
    this.focusedEditBounds = null;
    this.caretBounds = null;
  };
  StylusWritingFocusResult.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  StylusWritingFocusResult.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate StylusWritingFocusResult.focusedEditBounds
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, geometry$.Rect, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate StylusWritingFocusResult.caretBounds
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, geometry$.Rect, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  StylusWritingFocusResult.encodedSize = codec.kStructHeaderSize + 16;

  StylusWritingFocusResult.decode = function(decoder) {
    var packed;
    var val = new StylusWritingFocusResult();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.focusedEditBounds =
        decoder.decodeStructPointer(geometry$.Rect);
    val.caretBounds =
        decoder.decodeStructPointer(geometry$.Rect);
    return val;
  };

  StylusWritingFocusResult.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(StylusWritingFocusResult.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(geometry$.Rect, val.focusedEditBounds);
    encoder.encodeStructPointer(geometry$.Rect, val.caretBounds);
  };
  function FrameWidget_DragTargetDragEnter_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FrameWidget_DragTargetDragEnter_Params.prototype.initDefaults_ = function() {
    this.dragData = null;
    this.pointInViewport = null;
    this.screenPoint = null;
    this.operationsAllowed = null;
    this.keyModifiers = 0;
  };
  FrameWidget_DragTargetDragEnter_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FrameWidget_DragTargetDragEnter_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 48}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FrameWidget_DragTargetDragEnter_Params.dragData
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, drag$.DragData, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FrameWidget_DragTargetDragEnter_Params.pointInViewport
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, geometry$.PointF, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FrameWidget_DragTargetDragEnter_Params.screenPoint
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, geometry$.PointF, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FrameWidget_DragTargetDragEnter_Params.operationsAllowed
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 24, drag$.AllowedDragOperations, false);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  FrameWidget_DragTargetDragEnter_Params.encodedSize = codec.kStructHeaderSize + 40;

  FrameWidget_DragTargetDragEnter_Params.decode = function(decoder) {
    var packed;
    var val = new FrameWidget_DragTargetDragEnter_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.dragData =
        decoder.decodeStructPointer(drag$.DragData);
    val.pointInViewport =
        decoder.decodeStructPointer(geometry$.PointF);
    val.screenPoint =
        decoder.decodeStructPointer(geometry$.PointF);
    val.operationsAllowed =
        decoder.decodeStructPointer(drag$.AllowedDragOperations);
    val.keyModifiers =
        decoder.decodeStruct(codec.Uint32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  FrameWidget_DragTargetDragEnter_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FrameWidget_DragTargetDragEnter_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(drag$.DragData, val.dragData);
    encoder.encodeStructPointer(geometry$.PointF, val.pointInViewport);
    encoder.encodeStructPointer(geometry$.PointF, val.screenPoint);
    encoder.encodeStructPointer(drag$.AllowedDragOperations, val.operationsAllowed);
    encoder.encodeStruct(codec.Uint32, val.keyModifiers);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function FrameWidget_DragTargetDragEnter_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FrameWidget_DragTargetDragEnter_ResponseParams.prototype.initDefaults_ = function() {
    this.operation = 0;
    this.documentIsHandlingDrag = false;
  };
  FrameWidget_DragTargetDragEnter_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FrameWidget_DragTargetDragEnter_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FrameWidget_DragTargetDragEnter_ResponseParams.operation
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, drag_drop_types$.DragOperation);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  FrameWidget_DragTargetDragEnter_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  FrameWidget_DragTargetDragEnter_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new FrameWidget_DragTargetDragEnter_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.operation =
        decoder.decodeStruct(new codec.Enum(drag_drop_types$.DragOperation));
    packed = decoder.readUint8();
    val.documentIsHandlingDrag = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  FrameWidget_DragTargetDragEnter_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FrameWidget_DragTargetDragEnter_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.operation);
    packed = 0;
    packed |= (val.documentIsHandlingDrag & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function FrameWidget_DragTargetDragOver_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FrameWidget_DragTargetDragOver_Params.prototype.initDefaults_ = function() {
    this.pointInViewport = null;
    this.screenPoint = null;
    this.operationsAllowed = null;
    this.keyModifiers = 0;
  };
  FrameWidget_DragTargetDragOver_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FrameWidget_DragTargetDragOver_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 40}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FrameWidget_DragTargetDragOver_Params.pointInViewport
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, geometry$.PointF, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FrameWidget_DragTargetDragOver_Params.screenPoint
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, geometry$.PointF, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FrameWidget_DragTargetDragOver_Params.operationsAllowed
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, drag$.AllowedDragOperations, false);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  FrameWidget_DragTargetDragOver_Params.encodedSize = codec.kStructHeaderSize + 32;

  FrameWidget_DragTargetDragOver_Params.decode = function(decoder) {
    var packed;
    var val = new FrameWidget_DragTargetDragOver_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.pointInViewport =
        decoder.decodeStructPointer(geometry$.PointF);
    val.screenPoint =
        decoder.decodeStructPointer(geometry$.PointF);
    val.operationsAllowed =
        decoder.decodeStructPointer(drag$.AllowedDragOperations);
    val.keyModifiers =
        decoder.decodeStruct(codec.Uint32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  FrameWidget_DragTargetDragOver_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FrameWidget_DragTargetDragOver_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(geometry$.PointF, val.pointInViewport);
    encoder.encodeStructPointer(geometry$.PointF, val.screenPoint);
    encoder.encodeStructPointer(drag$.AllowedDragOperations, val.operationsAllowed);
    encoder.encodeStruct(codec.Uint32, val.keyModifiers);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function FrameWidget_DragTargetDragOver_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FrameWidget_DragTargetDragOver_ResponseParams.prototype.initDefaults_ = function() {
    this.operation = 0;
    this.documentIsHandlingDrag = false;
  };
  FrameWidget_DragTargetDragOver_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FrameWidget_DragTargetDragOver_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FrameWidget_DragTargetDragOver_ResponseParams.operation
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, drag_drop_types$.DragOperation);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  FrameWidget_DragTargetDragOver_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  FrameWidget_DragTargetDragOver_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new FrameWidget_DragTargetDragOver_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.operation =
        decoder.decodeStruct(new codec.Enum(drag_drop_types$.DragOperation));
    packed = decoder.readUint8();
    val.documentIsHandlingDrag = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  FrameWidget_DragTargetDragOver_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FrameWidget_DragTargetDragOver_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.operation);
    packed = 0;
    packed |= (val.documentIsHandlingDrag & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function FrameWidget_DragTargetDragLeave_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FrameWidget_DragTargetDragLeave_Params.prototype.initDefaults_ = function() {
    this.pointInViewport = null;
    this.screenPoint = null;
  };
  FrameWidget_DragTargetDragLeave_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FrameWidget_DragTargetDragLeave_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FrameWidget_DragTargetDragLeave_Params.pointInViewport
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, geometry$.PointF, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FrameWidget_DragTargetDragLeave_Params.screenPoint
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, geometry$.PointF, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FrameWidget_DragTargetDragLeave_Params.encodedSize = codec.kStructHeaderSize + 16;

  FrameWidget_DragTargetDragLeave_Params.decode = function(decoder) {
    var packed;
    var val = new FrameWidget_DragTargetDragLeave_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.pointInViewport =
        decoder.decodeStructPointer(geometry$.PointF);
    val.screenPoint =
        decoder.decodeStructPointer(geometry$.PointF);
    return val;
  };

  FrameWidget_DragTargetDragLeave_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FrameWidget_DragTargetDragLeave_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(geometry$.PointF, val.pointInViewport);
    encoder.encodeStructPointer(geometry$.PointF, val.screenPoint);
  };
  function FrameWidget_DragTargetDrop_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FrameWidget_DragTargetDrop_Params.prototype.initDefaults_ = function() {
    this.dragData = null;
    this.pointInViewport = null;
    this.screenPoint = null;
    this.keyModifiers = 0;
  };
  FrameWidget_DragTargetDrop_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FrameWidget_DragTargetDrop_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 40}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FrameWidget_DragTargetDrop_Params.dragData
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, drag$.DragData, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FrameWidget_DragTargetDrop_Params.pointInViewport
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, geometry$.PointF, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FrameWidget_DragTargetDrop_Params.screenPoint
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, geometry$.PointF, false);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  FrameWidget_DragTargetDrop_Params.encodedSize = codec.kStructHeaderSize + 32;

  FrameWidget_DragTargetDrop_Params.decode = function(decoder) {
    var packed;
    var val = new FrameWidget_DragTargetDrop_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.dragData =
        decoder.decodeStructPointer(drag$.DragData);
    val.pointInViewport =
        decoder.decodeStructPointer(geometry$.PointF);
    val.screenPoint =
        decoder.decodeStructPointer(geometry$.PointF);
    val.keyModifiers =
        decoder.decodeStruct(codec.Uint32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  FrameWidget_DragTargetDrop_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FrameWidget_DragTargetDrop_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(drag$.DragData, val.dragData);
    encoder.encodeStructPointer(geometry$.PointF, val.pointInViewport);
    encoder.encodeStructPointer(geometry$.PointF, val.screenPoint);
    encoder.encodeStruct(codec.Uint32, val.keyModifiers);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function FrameWidget_DragTargetDrop_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FrameWidget_DragTargetDrop_ResponseParams.prototype.initDefaults_ = function() {
  };
  FrameWidget_DragTargetDrop_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FrameWidget_DragTargetDrop_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FrameWidget_DragTargetDrop_ResponseParams.encodedSize = codec.kStructHeaderSize + 0;

  FrameWidget_DragTargetDrop_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new FrameWidget_DragTargetDrop_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  FrameWidget_DragTargetDrop_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FrameWidget_DragTargetDrop_ResponseParams.encodedSize);
    encoder.writeUint32(0);
  };
  function FrameWidget_DragSourceEndedAt_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FrameWidget_DragSourceEndedAt_Params.prototype.initDefaults_ = function() {
    this.pointInViewport = null;
    this.screenPoint = null;
    this.dragOperation = 0;
  };
  FrameWidget_DragSourceEndedAt_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FrameWidget_DragSourceEndedAt_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FrameWidget_DragSourceEndedAt_Params.pointInViewport
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, geometry$.PointF, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FrameWidget_DragSourceEndedAt_Params.screenPoint
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, geometry$.PointF, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FrameWidget_DragSourceEndedAt_Params.dragOperation
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 16, drag_drop_types$.DragOperation);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FrameWidget_DragSourceEndedAt_Params.encodedSize = codec.kStructHeaderSize + 24;

  FrameWidget_DragSourceEndedAt_Params.decode = function(decoder) {
    var packed;
    var val = new FrameWidget_DragSourceEndedAt_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.pointInViewport =
        decoder.decodeStructPointer(geometry$.PointF);
    val.screenPoint =
        decoder.decodeStructPointer(geometry$.PointF);
    val.dragOperation =
        decoder.decodeStruct(new codec.Enum(drag_drop_types$.DragOperation));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  FrameWidget_DragSourceEndedAt_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FrameWidget_DragSourceEndedAt_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(geometry$.PointF, val.pointInViewport);
    encoder.encodeStructPointer(geometry$.PointF, val.screenPoint);
    encoder.encodeStruct(codec.Int32, val.dragOperation);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function FrameWidget_DragSourceEndedAt_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FrameWidget_DragSourceEndedAt_ResponseParams.prototype.initDefaults_ = function() {
  };
  FrameWidget_DragSourceEndedAt_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FrameWidget_DragSourceEndedAt_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FrameWidget_DragSourceEndedAt_ResponseParams.encodedSize = codec.kStructHeaderSize + 0;

  FrameWidget_DragSourceEndedAt_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new FrameWidget_DragSourceEndedAt_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  FrameWidget_DragSourceEndedAt_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FrameWidget_DragSourceEndedAt_ResponseParams.encodedSize);
    encoder.writeUint32(0);
  };
  function FrameWidget_DragSourceSystemDragEnded_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FrameWidget_DragSourceSystemDragEnded_Params.prototype.initDefaults_ = function() {
  };
  FrameWidget_DragSourceSystemDragEnded_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FrameWidget_DragSourceSystemDragEnded_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FrameWidget_DragSourceSystemDragEnded_Params.encodedSize = codec.kStructHeaderSize + 0;

  FrameWidget_DragSourceSystemDragEnded_Params.decode = function(decoder) {
    var packed;
    var val = new FrameWidget_DragSourceSystemDragEnded_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  FrameWidget_DragSourceSystemDragEnded_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FrameWidget_DragSourceSystemDragEnded_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function FrameWidget_OnStartStylusWriting_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FrameWidget_OnStartStylusWriting_Params.prototype.initDefaults_ = function() {
  };
  FrameWidget_OnStartStylusWriting_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FrameWidget_OnStartStylusWriting_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FrameWidget_OnStartStylusWriting_Params.encodedSize = codec.kStructHeaderSize + 0;

  FrameWidget_OnStartStylusWriting_Params.decode = function(decoder) {
    var packed;
    var val = new FrameWidget_OnStartStylusWriting_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  FrameWidget_OnStartStylusWriting_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FrameWidget_OnStartStylusWriting_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function FrameWidget_OnStartStylusWriting_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FrameWidget_OnStartStylusWriting_ResponseParams.prototype.initDefaults_ = function() {
    this.focusResult = null;
  };
  FrameWidget_OnStartStylusWriting_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FrameWidget_OnStartStylusWriting_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FrameWidget_OnStartStylusWriting_ResponseParams.focusResult
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, StylusWritingFocusResult, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FrameWidget_OnStartStylusWriting_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  FrameWidget_OnStartStylusWriting_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new FrameWidget_OnStartStylusWriting_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.focusResult =
        decoder.decodeStructPointer(StylusWritingFocusResult);
    return val;
  };

  FrameWidget_OnStartStylusWriting_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FrameWidget_OnStartStylusWriting_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(StylusWritingFocusResult, val.focusResult);
  };
  function FrameWidget_SetBackgroundOpaque_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FrameWidget_SetBackgroundOpaque_Params.prototype.initDefaults_ = function() {
    this.opaque = false;
  };
  FrameWidget_SetBackgroundOpaque_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FrameWidget_SetBackgroundOpaque_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  FrameWidget_SetBackgroundOpaque_Params.encodedSize = codec.kStructHeaderSize + 8;

  FrameWidget_SetBackgroundOpaque_Params.decode = function(decoder) {
    var packed;
    var val = new FrameWidget_SetBackgroundOpaque_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.opaque = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  FrameWidget_SetBackgroundOpaque_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FrameWidget_SetBackgroundOpaque_Params.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.opaque & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function FrameWidget_SetTextDirection_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FrameWidget_SetTextDirection_Params.prototype.initDefaults_ = function() {
    this.direction = 0;
  };
  FrameWidget_SetTextDirection_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FrameWidget_SetTextDirection_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FrameWidget_SetTextDirection_Params.direction
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, text_direction$.TextDirection);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FrameWidget_SetTextDirection_Params.encodedSize = codec.kStructHeaderSize + 8;

  FrameWidget_SetTextDirection_Params.decode = function(decoder) {
    var packed;
    var val = new FrameWidget_SetTextDirection_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.direction =
        decoder.decodeStruct(new codec.Enum(text_direction$.TextDirection));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  FrameWidget_SetTextDirection_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FrameWidget_SetTextDirection_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.direction);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function FrameWidget_SetActive_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FrameWidget_SetActive_Params.prototype.initDefaults_ = function() {
    this.active = false;
  };
  FrameWidget_SetActive_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FrameWidget_SetActive_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  FrameWidget_SetActive_Params.encodedSize = codec.kStructHeaderSize + 8;

  FrameWidget_SetActive_Params.decode = function(decoder) {
    var packed;
    var val = new FrameWidget_SetActive_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.active = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  FrameWidget_SetActive_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FrameWidget_SetActive_Params.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.active & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function FrameWidget_SetInheritedEffectiveTouchActionForSubFrame_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FrameWidget_SetInheritedEffectiveTouchActionForSubFrame_Params.prototype.initDefaults_ = function() {
    this.touchAction = 0;
  };
  FrameWidget_SetInheritedEffectiveTouchActionForSubFrame_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FrameWidget_SetInheritedEffectiveTouchActionForSubFrame_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FrameWidget_SetInheritedEffectiveTouchActionForSubFrame_Params.touchAction
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, touch_action$.TouchAction);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FrameWidget_SetInheritedEffectiveTouchActionForSubFrame_Params.encodedSize = codec.kStructHeaderSize + 8;

  FrameWidget_SetInheritedEffectiveTouchActionForSubFrame_Params.decode = function(decoder) {
    var packed;
    var val = new FrameWidget_SetInheritedEffectiveTouchActionForSubFrame_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.touchAction =
        decoder.decodeStruct(new codec.Enum(touch_action$.TouchAction));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  FrameWidget_SetInheritedEffectiveTouchActionForSubFrame_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FrameWidget_SetInheritedEffectiveTouchActionForSubFrame_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.touchAction);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function FrameWidget_UpdateRenderThrottlingStatusForSubFrame_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FrameWidget_UpdateRenderThrottlingStatusForSubFrame_Params.prototype.initDefaults_ = function() {
    this.isThrottled = false;
    this.subtreeThrottled = false;
    this.displayLocked = false;
  };
  FrameWidget_UpdateRenderThrottlingStatusForSubFrame_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FrameWidget_UpdateRenderThrottlingStatusForSubFrame_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;




    return validator.validationError.NONE;
  };

  FrameWidget_UpdateRenderThrottlingStatusForSubFrame_Params.encodedSize = codec.kStructHeaderSize + 8;

  FrameWidget_UpdateRenderThrottlingStatusForSubFrame_Params.decode = function(decoder) {
    var packed;
    var val = new FrameWidget_UpdateRenderThrottlingStatusForSubFrame_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.isThrottled = (packed >> 0) & 1 ? true : false;
    val.subtreeThrottled = (packed >> 1) & 1 ? true : false;
    val.displayLocked = (packed >> 2) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  FrameWidget_UpdateRenderThrottlingStatusForSubFrame_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FrameWidget_UpdateRenderThrottlingStatusForSubFrame_Params.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.isThrottled & 1) << 0
    packed |= (val.subtreeThrottled & 1) << 1
    packed |= (val.displayLocked & 1) << 2
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function FrameWidget_SetIsInertForSubFrame_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FrameWidget_SetIsInertForSubFrame_Params.prototype.initDefaults_ = function() {
    this.inert = false;
  };
  FrameWidget_SetIsInertForSubFrame_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FrameWidget_SetIsInertForSubFrame_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  FrameWidget_SetIsInertForSubFrame_Params.encodedSize = codec.kStructHeaderSize + 8;

  FrameWidget_SetIsInertForSubFrame_Params.decode = function(decoder) {
    var packed;
    var val = new FrameWidget_SetIsInertForSubFrame_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.inert = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  FrameWidget_SetIsInertForSubFrame_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FrameWidget_SetIsInertForSubFrame_Params.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.inert & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function FrameWidget_GetStringAtPoint_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FrameWidget_GetStringAtPoint_Params.prototype.initDefaults_ = function() {
    this.pointInLocalRoot = null;
  };
  FrameWidget_GetStringAtPoint_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FrameWidget_GetStringAtPoint_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FrameWidget_GetStringAtPoint_Params.pointInLocalRoot
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, geometry$.Point, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FrameWidget_GetStringAtPoint_Params.encodedSize = codec.kStructHeaderSize + 8;

  FrameWidget_GetStringAtPoint_Params.decode = function(decoder) {
    var packed;
    var val = new FrameWidget_GetStringAtPoint_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.pointInLocalRoot =
        decoder.decodeStructPointer(geometry$.Point);
    return val;
  };

  FrameWidget_GetStringAtPoint_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FrameWidget_GetStringAtPoint_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(geometry$.Point, val.pointInLocalRoot);
  };
  function FrameWidget_GetStringAtPoint_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FrameWidget_GetStringAtPoint_ResponseParams.prototype.initDefaults_ = function() {
    this.string = null;
    this.baselinePoint = null;
  };
  FrameWidget_GetStringAtPoint_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FrameWidget_GetStringAtPoint_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FrameWidget_GetStringAtPoint_ResponseParams.string
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, attributed_string$.AttributedString, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FrameWidget_GetStringAtPoint_ResponseParams.baselinePoint
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, geometry$.Point, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FrameWidget_GetStringAtPoint_ResponseParams.encodedSize = codec.kStructHeaderSize + 16;

  FrameWidget_GetStringAtPoint_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new FrameWidget_GetStringAtPoint_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.string =
        decoder.decodeStructPointer(attributed_string$.AttributedString);
    val.baselinePoint =
        decoder.decodeStructPointer(geometry$.Point);
    return val;
  };

  FrameWidget_GetStringAtPoint_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FrameWidget_GetStringAtPoint_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(attributed_string$.AttributedString, val.string);
    encoder.encodeStructPointer(geometry$.Point, val.baselinePoint);
  };
  function FrameWidget_EnableDeviceEmulation_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FrameWidget_EnableDeviceEmulation_Params.prototype.initDefaults_ = function() {
    this.parameters = null;
    this.cacheBehavior = 0;
  };
  FrameWidget_EnableDeviceEmulation_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FrameWidget_EnableDeviceEmulation_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FrameWidget_EnableDeviceEmulation_Params.parameters
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, device_emulation_params$.DeviceEmulationParams, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FrameWidget_EnableDeviceEmulation_Params.cacheBehavior
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 8, DeviceEmulationCacheBehavior);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FrameWidget_EnableDeviceEmulation_Params.encodedSize = codec.kStructHeaderSize + 16;

  FrameWidget_EnableDeviceEmulation_Params.decode = function(decoder) {
    var packed;
    var val = new FrameWidget_EnableDeviceEmulation_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.parameters =
        decoder.decodeStructPointer(device_emulation_params$.DeviceEmulationParams);
    val.cacheBehavior =
        decoder.decodeStruct(new codec.Enum(DeviceEmulationCacheBehavior));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  FrameWidget_EnableDeviceEmulation_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FrameWidget_EnableDeviceEmulation_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(device_emulation_params$.DeviceEmulationParams, val.parameters);
    encoder.encodeStruct(codec.Int32, val.cacheBehavior);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function FrameWidget_DisableDeviceEmulation_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FrameWidget_DisableDeviceEmulation_Params.prototype.initDefaults_ = function() {
  };
  FrameWidget_DisableDeviceEmulation_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FrameWidget_DisableDeviceEmulation_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FrameWidget_DisableDeviceEmulation_Params.encodedSize = codec.kStructHeaderSize + 0;

  FrameWidget_DisableDeviceEmulation_Params.decode = function(decoder) {
    var packed;
    var val = new FrameWidget_DisableDeviceEmulation_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  FrameWidget_DisableDeviceEmulation_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FrameWidget_DisableDeviceEmulation_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function FrameWidget_BindWidgetCompositor_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FrameWidget_BindWidgetCompositor_Params.prototype.initDefaults_ = function() {
    this.host = new bindings.InterfaceRequest();
  };
  FrameWidget_BindWidgetCompositor_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FrameWidget_BindWidgetCompositor_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FrameWidget_BindWidgetCompositor_Params.host
    err = messageValidator.validateInterfaceRequest(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FrameWidget_BindWidgetCompositor_Params.encodedSize = codec.kStructHeaderSize + 8;

  FrameWidget_BindWidgetCompositor_Params.decode = function(decoder) {
    var packed;
    var val = new FrameWidget_BindWidgetCompositor_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.host =
        decoder.decodeStruct(codec.InterfaceRequest);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  FrameWidget_BindWidgetCompositor_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FrameWidget_BindWidgetCompositor_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.InterfaceRequest, val.host);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function FrameWidget_SetViewportIntersection_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FrameWidget_SetViewportIntersection_Params.prototype.initDefaults_ = function() {
    this.intersectionState = null;
    this.visualProperties = null;
  };
  FrameWidget_SetViewportIntersection_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FrameWidget_SetViewportIntersection_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FrameWidget_SetViewportIntersection_Params.intersectionState
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, viewport_intersection_state$.ViewportIntersectionState, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FrameWidget_SetViewportIntersection_Params.visualProperties
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, visual_properties$.VisualProperties, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FrameWidget_SetViewportIntersection_Params.encodedSize = codec.kStructHeaderSize + 16;

  FrameWidget_SetViewportIntersection_Params.decode = function(decoder) {
    var packed;
    var val = new FrameWidget_SetViewportIntersection_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.intersectionState =
        decoder.decodeStructPointer(viewport_intersection_state$.ViewportIntersectionState);
    val.visualProperties =
        decoder.decodeStructPointer(visual_properties$.VisualProperties);
    return val;
  };

  FrameWidget_SetViewportIntersection_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FrameWidget_SetViewportIntersection_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(viewport_intersection_state$.ViewportIntersectionState, val.intersectionState);
    encoder.encodeStructPointer(visual_properties$.VisualProperties, val.visualProperties);
  };
  function FrameWidget_NotifyClearedDisplayedGraphics_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FrameWidget_NotifyClearedDisplayedGraphics_Params.prototype.initDefaults_ = function() {
  };
  FrameWidget_NotifyClearedDisplayedGraphics_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FrameWidget_NotifyClearedDisplayedGraphics_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FrameWidget_NotifyClearedDisplayedGraphics_Params.encodedSize = codec.kStructHeaderSize + 0;

  FrameWidget_NotifyClearedDisplayedGraphics_Params.decode = function(decoder) {
    var packed;
    var val = new FrameWidget_NotifyClearedDisplayedGraphics_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  FrameWidget_NotifyClearedDisplayedGraphics_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FrameWidget_NotifyClearedDisplayedGraphics_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function FrameWidgetHost_AnimateDoubleTapZoomInMainFrame_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FrameWidgetHost_AnimateDoubleTapZoomInMainFrame_Params.prototype.initDefaults_ = function() {
    this.tapPoint = null;
    this.rectToZoom = null;
  };
  FrameWidgetHost_AnimateDoubleTapZoomInMainFrame_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FrameWidgetHost_AnimateDoubleTapZoomInMainFrame_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FrameWidgetHost_AnimateDoubleTapZoomInMainFrame_Params.tapPoint
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, geometry$.Point, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FrameWidgetHost_AnimateDoubleTapZoomInMainFrame_Params.rectToZoom
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, geometry$.Rect, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FrameWidgetHost_AnimateDoubleTapZoomInMainFrame_Params.encodedSize = codec.kStructHeaderSize + 16;

  FrameWidgetHost_AnimateDoubleTapZoomInMainFrame_Params.decode = function(decoder) {
    var packed;
    var val = new FrameWidgetHost_AnimateDoubleTapZoomInMainFrame_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.tapPoint =
        decoder.decodeStructPointer(geometry$.Point);
    val.rectToZoom =
        decoder.decodeStructPointer(geometry$.Rect);
    return val;
  };

  FrameWidgetHost_AnimateDoubleTapZoomInMainFrame_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FrameWidgetHost_AnimateDoubleTapZoomInMainFrame_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(geometry$.Point, val.tapPoint);
    encoder.encodeStructPointer(geometry$.Rect, val.rectToZoom);
  };
  function FrameWidgetHost_ZoomToFindInPageRectInMainFrame_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FrameWidgetHost_ZoomToFindInPageRectInMainFrame_Params.prototype.initDefaults_ = function() {
    this.rectToZoom = null;
  };
  FrameWidgetHost_ZoomToFindInPageRectInMainFrame_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FrameWidgetHost_ZoomToFindInPageRectInMainFrame_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FrameWidgetHost_ZoomToFindInPageRectInMainFrame_Params.rectToZoom
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, geometry$.Rect, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FrameWidgetHost_ZoomToFindInPageRectInMainFrame_Params.encodedSize = codec.kStructHeaderSize + 8;

  FrameWidgetHost_ZoomToFindInPageRectInMainFrame_Params.decode = function(decoder) {
    var packed;
    var val = new FrameWidgetHost_ZoomToFindInPageRectInMainFrame_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.rectToZoom =
        decoder.decodeStructPointer(geometry$.Rect);
    return val;
  };

  FrameWidgetHost_ZoomToFindInPageRectInMainFrame_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FrameWidgetHost_ZoomToFindInPageRectInMainFrame_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(geometry$.Rect, val.rectToZoom);
  };
  function FrameWidgetHost_SetHasTouchEventConsumers_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FrameWidgetHost_SetHasTouchEventConsumers_Params.prototype.initDefaults_ = function() {
    this.touchEventConsumers = null;
  };
  FrameWidgetHost_SetHasTouchEventConsumers_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FrameWidgetHost_SetHasTouchEventConsumers_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FrameWidgetHost_SetHasTouchEventConsumers_Params.touchEventConsumers
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, touch_event$.TouchEventConsumers, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FrameWidgetHost_SetHasTouchEventConsumers_Params.encodedSize = codec.kStructHeaderSize + 8;

  FrameWidgetHost_SetHasTouchEventConsumers_Params.decode = function(decoder) {
    var packed;
    var val = new FrameWidgetHost_SetHasTouchEventConsumers_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.touchEventConsumers =
        decoder.decodeStructPointer(touch_event$.TouchEventConsumers);
    return val;
  };

  FrameWidgetHost_SetHasTouchEventConsumers_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FrameWidgetHost_SetHasTouchEventConsumers_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(touch_event$.TouchEventConsumers, val.touchEventConsumers);
  };
  function FrameWidgetHost_IntrinsicSizingInfoChanged_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FrameWidgetHost_IntrinsicSizingInfoChanged_Params.prototype.initDefaults_ = function() {
    this.sizingInfo = null;
  };
  FrameWidgetHost_IntrinsicSizingInfoChanged_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FrameWidgetHost_IntrinsicSizingInfoChanged_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FrameWidgetHost_IntrinsicSizingInfoChanged_Params.sizingInfo
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, intrinsic_sizing_info$.IntrinsicSizingInfo, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FrameWidgetHost_IntrinsicSizingInfoChanged_Params.encodedSize = codec.kStructHeaderSize + 8;

  FrameWidgetHost_IntrinsicSizingInfoChanged_Params.decode = function(decoder) {
    var packed;
    var val = new FrameWidgetHost_IntrinsicSizingInfoChanged_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.sizingInfo =
        decoder.decodeStructPointer(intrinsic_sizing_info$.IntrinsicSizingInfo);
    return val;
  };

  FrameWidgetHost_IntrinsicSizingInfoChanged_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FrameWidgetHost_IntrinsicSizingInfoChanged_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(intrinsic_sizing_info$.IntrinsicSizingInfo, val.sizingInfo);
  };
  function FrameWidgetHost_AutoscrollStart_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FrameWidgetHost_AutoscrollStart_Params.prototype.initDefaults_ = function() {
    this.position = null;
  };
  FrameWidgetHost_AutoscrollStart_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FrameWidgetHost_AutoscrollStart_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FrameWidgetHost_AutoscrollStart_Params.position
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, geometry$.PointF, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FrameWidgetHost_AutoscrollStart_Params.encodedSize = codec.kStructHeaderSize + 8;

  FrameWidgetHost_AutoscrollStart_Params.decode = function(decoder) {
    var packed;
    var val = new FrameWidgetHost_AutoscrollStart_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.position =
        decoder.decodeStructPointer(geometry$.PointF);
    return val;
  };

  FrameWidgetHost_AutoscrollStart_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FrameWidgetHost_AutoscrollStart_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(geometry$.PointF, val.position);
  };
  function FrameWidgetHost_AutoscrollFling_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FrameWidgetHost_AutoscrollFling_Params.prototype.initDefaults_ = function() {
    this.velocity = null;
  };
  FrameWidgetHost_AutoscrollFling_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FrameWidgetHost_AutoscrollFling_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FrameWidgetHost_AutoscrollFling_Params.velocity
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, geometry$.Vector2dF, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FrameWidgetHost_AutoscrollFling_Params.encodedSize = codec.kStructHeaderSize + 8;

  FrameWidgetHost_AutoscrollFling_Params.decode = function(decoder) {
    var packed;
    var val = new FrameWidgetHost_AutoscrollFling_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.velocity =
        decoder.decodeStructPointer(geometry$.Vector2dF);
    return val;
  };

  FrameWidgetHost_AutoscrollFling_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FrameWidgetHost_AutoscrollFling_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(geometry$.Vector2dF, val.velocity);
  };
  function FrameWidgetHost_AutoscrollEnd_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FrameWidgetHost_AutoscrollEnd_Params.prototype.initDefaults_ = function() {
  };
  FrameWidgetHost_AutoscrollEnd_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FrameWidgetHost_AutoscrollEnd_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FrameWidgetHost_AutoscrollEnd_Params.encodedSize = codec.kStructHeaderSize + 0;

  FrameWidgetHost_AutoscrollEnd_Params.decode = function(decoder) {
    var packed;
    var val = new FrameWidgetHost_AutoscrollEnd_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  FrameWidgetHost_AutoscrollEnd_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FrameWidgetHost_AutoscrollEnd_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function PopupWidgetHost_RequestClosePopup_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  PopupWidgetHost_RequestClosePopup_Params.prototype.initDefaults_ = function() {
  };
  PopupWidgetHost_RequestClosePopup_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  PopupWidgetHost_RequestClosePopup_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  PopupWidgetHost_RequestClosePopup_Params.encodedSize = codec.kStructHeaderSize + 0;

  PopupWidgetHost_RequestClosePopup_Params.decode = function(decoder) {
    var packed;
    var val = new PopupWidgetHost_RequestClosePopup_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  PopupWidgetHost_RequestClosePopup_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(PopupWidgetHost_RequestClosePopup_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function PopupWidgetHost_ShowPopup_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  PopupWidgetHost_ShowPopup_Params.prototype.initDefaults_ = function() {
    this.initialRect = null;
    this.anchorRect = null;
  };
  PopupWidgetHost_ShowPopup_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  PopupWidgetHost_ShowPopup_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate PopupWidgetHost_ShowPopup_Params.initialRect
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, geometry$.Rect, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate PopupWidgetHost_ShowPopup_Params.anchorRect
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, geometry$.Rect, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  PopupWidgetHost_ShowPopup_Params.encodedSize = codec.kStructHeaderSize + 16;

  PopupWidgetHost_ShowPopup_Params.decode = function(decoder) {
    var packed;
    var val = new PopupWidgetHost_ShowPopup_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.initialRect =
        decoder.decodeStructPointer(geometry$.Rect);
    val.anchorRect =
        decoder.decodeStructPointer(geometry$.Rect);
    return val;
  };

  PopupWidgetHost_ShowPopup_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(PopupWidgetHost_ShowPopup_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(geometry$.Rect, val.initialRect);
    encoder.encodeStructPointer(geometry$.Rect, val.anchorRect);
  };
  function PopupWidgetHost_ShowPopup_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  PopupWidgetHost_ShowPopup_ResponseParams.prototype.initDefaults_ = function() {
  };
  PopupWidgetHost_ShowPopup_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  PopupWidgetHost_ShowPopup_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  PopupWidgetHost_ShowPopup_ResponseParams.encodedSize = codec.kStructHeaderSize + 0;

  PopupWidgetHost_ShowPopup_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new PopupWidgetHost_ShowPopup_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  PopupWidgetHost_ShowPopup_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(PopupWidgetHost_ShowPopup_ResponseParams.encodedSize);
    encoder.writeUint32(0);
  };
  function PopupWidgetHost_SetPopupBounds_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  PopupWidgetHost_SetPopupBounds_Params.prototype.initDefaults_ = function() {
    this.bounds = null;
  };
  PopupWidgetHost_SetPopupBounds_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  PopupWidgetHost_SetPopupBounds_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate PopupWidgetHost_SetPopupBounds_Params.bounds
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, geometry$.Rect, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  PopupWidgetHost_SetPopupBounds_Params.encodedSize = codec.kStructHeaderSize + 8;

  PopupWidgetHost_SetPopupBounds_Params.decode = function(decoder) {
    var packed;
    var val = new PopupWidgetHost_SetPopupBounds_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.bounds =
        decoder.decodeStructPointer(geometry$.Rect);
    return val;
  };

  PopupWidgetHost_SetPopupBounds_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(PopupWidgetHost_SetPopupBounds_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(geometry$.Rect, val.bounds);
  };
  function PopupWidgetHost_SetPopupBounds_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  PopupWidgetHost_SetPopupBounds_ResponseParams.prototype.initDefaults_ = function() {
  };
  PopupWidgetHost_SetPopupBounds_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  PopupWidgetHost_SetPopupBounds_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  PopupWidgetHost_SetPopupBounds_ResponseParams.encodedSize = codec.kStructHeaderSize + 0;

  PopupWidgetHost_SetPopupBounds_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new PopupWidgetHost_SetPopupBounds_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  PopupWidgetHost_SetPopupBounds_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(PopupWidgetHost_SetPopupBounds_ResponseParams.encodedSize);
    encoder.writeUint32(0);
  };
  var kFrameWidget_DragTargetDragEnter_Name = 0;
  var kFrameWidget_DragTargetDragOver_Name = 1;
  var kFrameWidget_DragTargetDragLeave_Name = 2;
  var kFrameWidget_DragTargetDrop_Name = 3;
  var kFrameWidget_DragSourceEndedAt_Name = 4;
  var kFrameWidget_DragSourceSystemDragEnded_Name = 5;
  var kFrameWidget_OnStartStylusWriting_Name = 6;
  var kFrameWidget_SetBackgroundOpaque_Name = 7;
  var kFrameWidget_SetTextDirection_Name = 8;
  var kFrameWidget_SetActive_Name = 9;
  var kFrameWidget_SetInheritedEffectiveTouchActionForSubFrame_Name = 10;
  var kFrameWidget_UpdateRenderThrottlingStatusForSubFrame_Name = 11;
  var kFrameWidget_SetIsInertForSubFrame_Name = 12;
  var kFrameWidget_GetStringAtPoint_Name = 13;
  var kFrameWidget_EnableDeviceEmulation_Name = 14;
  var kFrameWidget_DisableDeviceEmulation_Name = 15;
  var kFrameWidget_BindWidgetCompositor_Name = 16;
  var kFrameWidget_SetViewportIntersection_Name = 17;
  var kFrameWidget_NotifyClearedDisplayedGraphics_Name = 18;

  function FrameWidgetPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(FrameWidget,
                                                   handleOrPtrInfo);
  }

  function FrameWidgetAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        FrameWidget, associatedInterfacePtrInfo);
  }

  FrameWidgetAssociatedPtr.prototype =
      Object.create(FrameWidgetPtr.prototype);
  FrameWidgetAssociatedPtr.prototype.constructor =
      FrameWidgetAssociatedPtr;

  function FrameWidgetProxy(receiver) {
    this.receiver_ = receiver;
  }
  FrameWidgetPtr.prototype.dragTargetDragEnter = function() {
    return FrameWidgetProxy.prototype.dragTargetDragEnter
        .apply(this.ptr.getProxy(), arguments);
  };

  FrameWidgetProxy.prototype.dragTargetDragEnter = function(dragData, pointInViewport, screenPoint, operationsAllowed, keyModifiers) {
    var params_ = new FrameWidget_DragTargetDragEnter_Params();
    params_.dragData = dragData;
    params_.pointInViewport = pointInViewport;
    params_.screenPoint = screenPoint;
    params_.operationsAllowed = operationsAllowed;
    params_.keyModifiers = keyModifiers;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kFrameWidget_DragTargetDragEnter_Name,
          codec.align(FrameWidget_DragTargetDragEnter_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(FrameWidget_DragTargetDragEnter_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(FrameWidget_DragTargetDragEnter_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  FrameWidgetPtr.prototype.dragTargetDragOver = function() {
    return FrameWidgetProxy.prototype.dragTargetDragOver
        .apply(this.ptr.getProxy(), arguments);
  };

  FrameWidgetProxy.prototype.dragTargetDragOver = function(pointInViewport, screenPoint, operationsAllowed, keyModifiers) {
    var params_ = new FrameWidget_DragTargetDragOver_Params();
    params_.pointInViewport = pointInViewport;
    params_.screenPoint = screenPoint;
    params_.operationsAllowed = operationsAllowed;
    params_.keyModifiers = keyModifiers;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kFrameWidget_DragTargetDragOver_Name,
          codec.align(FrameWidget_DragTargetDragOver_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(FrameWidget_DragTargetDragOver_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(FrameWidget_DragTargetDragOver_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  FrameWidgetPtr.prototype.dragTargetDragLeave = function() {
    return FrameWidgetProxy.prototype.dragTargetDragLeave
        .apply(this.ptr.getProxy(), arguments);
  };

  FrameWidgetProxy.prototype.dragTargetDragLeave = function(pointInViewport, screenPoint) {
    var params_ = new FrameWidget_DragTargetDragLeave_Params();
    params_.pointInViewport = pointInViewport;
    params_.screenPoint = screenPoint;
    var builder = new codec.MessageV0Builder(
        kFrameWidget_DragTargetDragLeave_Name,
        codec.align(FrameWidget_DragTargetDragLeave_Params.encodedSize));
    builder.encodeStruct(FrameWidget_DragTargetDragLeave_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  FrameWidgetPtr.prototype.dragTargetDrop = function() {
    return FrameWidgetProxy.prototype.dragTargetDrop
        .apply(this.ptr.getProxy(), arguments);
  };

  FrameWidgetProxy.prototype.dragTargetDrop = function(dragData, pointInViewport, screenPoint, keyModifiers) {
    var params_ = new FrameWidget_DragTargetDrop_Params();
    params_.dragData = dragData;
    params_.pointInViewport = pointInViewport;
    params_.screenPoint = screenPoint;
    params_.keyModifiers = keyModifiers;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kFrameWidget_DragTargetDrop_Name,
          codec.align(FrameWidget_DragTargetDrop_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(FrameWidget_DragTargetDrop_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(FrameWidget_DragTargetDrop_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  FrameWidgetPtr.prototype.dragSourceEndedAt = function() {
    return FrameWidgetProxy.prototype.dragSourceEndedAt
        .apply(this.ptr.getProxy(), arguments);
  };

  FrameWidgetProxy.prototype.dragSourceEndedAt = function(pointInViewport, screenPoint, dragOperation) {
    var params_ = new FrameWidget_DragSourceEndedAt_Params();
    params_.pointInViewport = pointInViewport;
    params_.screenPoint = screenPoint;
    params_.dragOperation = dragOperation;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kFrameWidget_DragSourceEndedAt_Name,
          codec.align(FrameWidget_DragSourceEndedAt_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(FrameWidget_DragSourceEndedAt_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(FrameWidget_DragSourceEndedAt_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  FrameWidgetPtr.prototype.dragSourceSystemDragEnded = function() {
    return FrameWidgetProxy.prototype.dragSourceSystemDragEnded
        .apply(this.ptr.getProxy(), arguments);
  };

  FrameWidgetProxy.prototype.dragSourceSystemDragEnded = function() {
    var params_ = new FrameWidget_DragSourceSystemDragEnded_Params();
    var builder = new codec.MessageV0Builder(
        kFrameWidget_DragSourceSystemDragEnded_Name,
        codec.align(FrameWidget_DragSourceSystemDragEnded_Params.encodedSize));
    builder.encodeStruct(FrameWidget_DragSourceSystemDragEnded_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  FrameWidgetPtr.prototype.onStartStylusWriting = function() {
    return FrameWidgetProxy.prototype.onStartStylusWriting
        .apply(this.ptr.getProxy(), arguments);
  };

  FrameWidgetProxy.prototype.onStartStylusWriting = function() {
    var params_ = new FrameWidget_OnStartStylusWriting_Params();
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kFrameWidget_OnStartStylusWriting_Name,
          codec.align(FrameWidget_OnStartStylusWriting_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(FrameWidget_OnStartStylusWriting_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(FrameWidget_OnStartStylusWriting_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  FrameWidgetPtr.prototype.setBackgroundOpaque = function() {
    return FrameWidgetProxy.prototype.setBackgroundOpaque
        .apply(this.ptr.getProxy(), arguments);
  };

  FrameWidgetProxy.prototype.setBackgroundOpaque = function(opaque) {
    var params_ = new FrameWidget_SetBackgroundOpaque_Params();
    params_.opaque = opaque;
    var builder = new codec.MessageV0Builder(
        kFrameWidget_SetBackgroundOpaque_Name,
        codec.align(FrameWidget_SetBackgroundOpaque_Params.encodedSize));
    builder.encodeStruct(FrameWidget_SetBackgroundOpaque_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  FrameWidgetPtr.prototype.setTextDirection = function() {
    return FrameWidgetProxy.prototype.setTextDirection
        .apply(this.ptr.getProxy(), arguments);
  };

  FrameWidgetProxy.prototype.setTextDirection = function(direction) {
    var params_ = new FrameWidget_SetTextDirection_Params();
    params_.direction = direction;
    var builder = new codec.MessageV0Builder(
        kFrameWidget_SetTextDirection_Name,
        codec.align(FrameWidget_SetTextDirection_Params.encodedSize));
    builder.encodeStruct(FrameWidget_SetTextDirection_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  FrameWidgetPtr.prototype.setActive = function() {
    return FrameWidgetProxy.prototype.setActive
        .apply(this.ptr.getProxy(), arguments);
  };

  FrameWidgetProxy.prototype.setActive = function(active) {
    var params_ = new FrameWidget_SetActive_Params();
    params_.active = active;
    var builder = new codec.MessageV0Builder(
        kFrameWidget_SetActive_Name,
        codec.align(FrameWidget_SetActive_Params.encodedSize));
    builder.encodeStruct(FrameWidget_SetActive_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  FrameWidgetPtr.prototype.setInheritedEffectiveTouchActionForSubFrame = function() {
    return FrameWidgetProxy.prototype.setInheritedEffectiveTouchActionForSubFrame
        .apply(this.ptr.getProxy(), arguments);
  };

  FrameWidgetProxy.prototype.setInheritedEffectiveTouchActionForSubFrame = function(touchAction) {
    var params_ = new FrameWidget_SetInheritedEffectiveTouchActionForSubFrame_Params();
    params_.touchAction = touchAction;
    var builder = new codec.MessageV0Builder(
        kFrameWidget_SetInheritedEffectiveTouchActionForSubFrame_Name,
        codec.align(FrameWidget_SetInheritedEffectiveTouchActionForSubFrame_Params.encodedSize));
    builder.encodeStruct(FrameWidget_SetInheritedEffectiveTouchActionForSubFrame_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  FrameWidgetPtr.prototype.updateRenderThrottlingStatusForSubFrame = function() {
    return FrameWidgetProxy.prototype.updateRenderThrottlingStatusForSubFrame
        .apply(this.ptr.getProxy(), arguments);
  };

  FrameWidgetProxy.prototype.updateRenderThrottlingStatusForSubFrame = function(isThrottled, subtreeThrottled, displayLocked) {
    var params_ = new FrameWidget_UpdateRenderThrottlingStatusForSubFrame_Params();
    params_.isThrottled = isThrottled;
    params_.subtreeThrottled = subtreeThrottled;
    params_.displayLocked = displayLocked;
    var builder = new codec.MessageV0Builder(
        kFrameWidget_UpdateRenderThrottlingStatusForSubFrame_Name,
        codec.align(FrameWidget_UpdateRenderThrottlingStatusForSubFrame_Params.encodedSize));
    builder.encodeStruct(FrameWidget_UpdateRenderThrottlingStatusForSubFrame_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  FrameWidgetPtr.prototype.setIsInertForSubFrame = function() {
    return FrameWidgetProxy.prototype.setIsInertForSubFrame
        .apply(this.ptr.getProxy(), arguments);
  };

  FrameWidgetProxy.prototype.setIsInertForSubFrame = function(inert) {
    var params_ = new FrameWidget_SetIsInertForSubFrame_Params();
    params_.inert = inert;
    var builder = new codec.MessageV0Builder(
        kFrameWidget_SetIsInertForSubFrame_Name,
        codec.align(FrameWidget_SetIsInertForSubFrame_Params.encodedSize));
    builder.encodeStruct(FrameWidget_SetIsInertForSubFrame_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  FrameWidgetPtr.prototype.getStringAtPoint = function() {
    return FrameWidgetProxy.prototype.getStringAtPoint
        .apply(this.ptr.getProxy(), arguments);
  };

  FrameWidgetProxy.prototype.getStringAtPoint = function(pointInLocalRoot) {
    var params_ = new FrameWidget_GetStringAtPoint_Params();
    params_.pointInLocalRoot = pointInLocalRoot;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kFrameWidget_GetStringAtPoint_Name,
          codec.align(FrameWidget_GetStringAtPoint_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(FrameWidget_GetStringAtPoint_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(FrameWidget_GetStringAtPoint_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  FrameWidgetPtr.prototype.enableDeviceEmulation = function() {
    return FrameWidgetProxy.prototype.enableDeviceEmulation
        .apply(this.ptr.getProxy(), arguments);
  };

  FrameWidgetProxy.prototype.enableDeviceEmulation = function(parameters, cacheBehavior) {
    var params_ = new FrameWidget_EnableDeviceEmulation_Params();
    params_.parameters = parameters;
    params_.cacheBehavior = cacheBehavior;
    var builder = new codec.MessageV0Builder(
        kFrameWidget_EnableDeviceEmulation_Name,
        codec.align(FrameWidget_EnableDeviceEmulation_Params.encodedSize));
    builder.encodeStruct(FrameWidget_EnableDeviceEmulation_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  FrameWidgetPtr.prototype.disableDeviceEmulation = function() {
    return FrameWidgetProxy.prototype.disableDeviceEmulation
        .apply(this.ptr.getProxy(), arguments);
  };

  FrameWidgetProxy.prototype.disableDeviceEmulation = function() {
    var params_ = new FrameWidget_DisableDeviceEmulation_Params();
    var builder = new codec.MessageV0Builder(
        kFrameWidget_DisableDeviceEmulation_Name,
        codec.align(FrameWidget_DisableDeviceEmulation_Params.encodedSize));
    builder.encodeStruct(FrameWidget_DisableDeviceEmulation_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  FrameWidgetPtr.prototype.bindWidgetCompositor = function() {
    return FrameWidgetProxy.prototype.bindWidgetCompositor
        .apply(this.ptr.getProxy(), arguments);
  };

  FrameWidgetProxy.prototype.bindWidgetCompositor = function(host) {
    var params_ = new FrameWidget_BindWidgetCompositor_Params();
    params_.host = host;
    var builder = new codec.MessageV0Builder(
        kFrameWidget_BindWidgetCompositor_Name,
        codec.align(FrameWidget_BindWidgetCompositor_Params.encodedSize));
    builder.encodeStruct(FrameWidget_BindWidgetCompositor_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  FrameWidgetPtr.prototype.setViewportIntersection = function() {
    return FrameWidgetProxy.prototype.setViewportIntersection
        .apply(this.ptr.getProxy(), arguments);
  };

  FrameWidgetProxy.prototype.setViewportIntersection = function(intersectionState, visualProperties) {
    var params_ = new FrameWidget_SetViewportIntersection_Params();
    params_.intersectionState = intersectionState;
    params_.visualProperties = visualProperties;
    var builder = new codec.MessageV0Builder(
        kFrameWidget_SetViewportIntersection_Name,
        codec.align(FrameWidget_SetViewportIntersection_Params.encodedSize));
    builder.encodeStruct(FrameWidget_SetViewportIntersection_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  FrameWidgetPtr.prototype.notifyClearedDisplayedGraphics = function() {
    return FrameWidgetProxy.prototype.notifyClearedDisplayedGraphics
        .apply(this.ptr.getProxy(), arguments);
  };

  FrameWidgetProxy.prototype.notifyClearedDisplayedGraphics = function() {
    var params_ = new FrameWidget_NotifyClearedDisplayedGraphics_Params();
    var builder = new codec.MessageV0Builder(
        kFrameWidget_NotifyClearedDisplayedGraphics_Name,
        codec.align(FrameWidget_NotifyClearedDisplayedGraphics_Params.encodedSize));
    builder.encodeStruct(FrameWidget_NotifyClearedDisplayedGraphics_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function FrameWidgetStub(delegate) {
    this.delegate_ = delegate;
  }
  FrameWidgetStub.prototype.dragTargetDragEnter = function(dragData, pointInViewport, screenPoint, operationsAllowed, keyModifiers) {
    return this.delegate_ && this.delegate_.dragTargetDragEnter && this.delegate_.dragTargetDragEnter(dragData, pointInViewport, screenPoint, operationsAllowed, keyModifiers);
  }
  FrameWidgetStub.prototype.dragTargetDragOver = function(pointInViewport, screenPoint, operationsAllowed, keyModifiers) {
    return this.delegate_ && this.delegate_.dragTargetDragOver && this.delegate_.dragTargetDragOver(pointInViewport, screenPoint, operationsAllowed, keyModifiers);
  }
  FrameWidgetStub.prototype.dragTargetDragLeave = function(pointInViewport, screenPoint) {
    return this.delegate_ && this.delegate_.dragTargetDragLeave && this.delegate_.dragTargetDragLeave(pointInViewport, screenPoint);
  }
  FrameWidgetStub.prototype.dragTargetDrop = function(dragData, pointInViewport, screenPoint, keyModifiers) {
    return this.delegate_ && this.delegate_.dragTargetDrop && this.delegate_.dragTargetDrop(dragData, pointInViewport, screenPoint, keyModifiers);
  }
  FrameWidgetStub.prototype.dragSourceEndedAt = function(pointInViewport, screenPoint, dragOperation) {
    return this.delegate_ && this.delegate_.dragSourceEndedAt && this.delegate_.dragSourceEndedAt(pointInViewport, screenPoint, dragOperation);
  }
  FrameWidgetStub.prototype.dragSourceSystemDragEnded = function() {
    return this.delegate_ && this.delegate_.dragSourceSystemDragEnded && this.delegate_.dragSourceSystemDragEnded();
  }
  FrameWidgetStub.prototype.onStartStylusWriting = function() {
    return this.delegate_ && this.delegate_.onStartStylusWriting && this.delegate_.onStartStylusWriting();
  }
  FrameWidgetStub.prototype.setBackgroundOpaque = function(opaque) {
    return this.delegate_ && this.delegate_.setBackgroundOpaque && this.delegate_.setBackgroundOpaque(opaque);
  }
  FrameWidgetStub.prototype.setTextDirection = function(direction) {
    return this.delegate_ && this.delegate_.setTextDirection && this.delegate_.setTextDirection(direction);
  }
  FrameWidgetStub.prototype.setActive = function(active) {
    return this.delegate_ && this.delegate_.setActive && this.delegate_.setActive(active);
  }
  FrameWidgetStub.prototype.setInheritedEffectiveTouchActionForSubFrame = function(touchAction) {
    return this.delegate_ && this.delegate_.setInheritedEffectiveTouchActionForSubFrame && this.delegate_.setInheritedEffectiveTouchActionForSubFrame(touchAction);
  }
  FrameWidgetStub.prototype.updateRenderThrottlingStatusForSubFrame = function(isThrottled, subtreeThrottled, displayLocked) {
    return this.delegate_ && this.delegate_.updateRenderThrottlingStatusForSubFrame && this.delegate_.updateRenderThrottlingStatusForSubFrame(isThrottled, subtreeThrottled, displayLocked);
  }
  FrameWidgetStub.prototype.setIsInertForSubFrame = function(inert) {
    return this.delegate_ && this.delegate_.setIsInertForSubFrame && this.delegate_.setIsInertForSubFrame(inert);
  }
  FrameWidgetStub.prototype.getStringAtPoint = function(pointInLocalRoot) {
    return this.delegate_ && this.delegate_.getStringAtPoint && this.delegate_.getStringAtPoint(pointInLocalRoot);
  }
  FrameWidgetStub.prototype.enableDeviceEmulation = function(parameters, cacheBehavior) {
    return this.delegate_ && this.delegate_.enableDeviceEmulation && this.delegate_.enableDeviceEmulation(parameters, cacheBehavior);
  }
  FrameWidgetStub.prototype.disableDeviceEmulation = function() {
    return this.delegate_ && this.delegate_.disableDeviceEmulation && this.delegate_.disableDeviceEmulation();
  }
  FrameWidgetStub.prototype.bindWidgetCompositor = function(host) {
    return this.delegate_ && this.delegate_.bindWidgetCompositor && this.delegate_.bindWidgetCompositor(host);
  }
  FrameWidgetStub.prototype.setViewportIntersection = function(intersectionState, visualProperties) {
    return this.delegate_ && this.delegate_.setViewportIntersection && this.delegate_.setViewportIntersection(intersectionState, visualProperties);
  }
  FrameWidgetStub.prototype.notifyClearedDisplayedGraphics = function() {
    return this.delegate_ && this.delegate_.notifyClearedDisplayedGraphics && this.delegate_.notifyClearedDisplayedGraphics();
  }

  FrameWidgetStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kFrameWidget_DragTargetDragLeave_Name:
      var params = reader.decodeStruct(FrameWidget_DragTargetDragLeave_Params);
      this.dragTargetDragLeave(params.pointInViewport, params.screenPoint);
      return true;
    case kFrameWidget_DragSourceSystemDragEnded_Name:
      var params = reader.decodeStruct(FrameWidget_DragSourceSystemDragEnded_Params);
      this.dragSourceSystemDragEnded();
      return true;
    case kFrameWidget_SetBackgroundOpaque_Name:
      var params = reader.decodeStruct(FrameWidget_SetBackgroundOpaque_Params);
      this.setBackgroundOpaque(params.opaque);
      return true;
    case kFrameWidget_SetTextDirection_Name:
      var params = reader.decodeStruct(FrameWidget_SetTextDirection_Params);
      this.setTextDirection(params.direction);
      return true;
    case kFrameWidget_SetActive_Name:
      var params = reader.decodeStruct(FrameWidget_SetActive_Params);
      this.setActive(params.active);
      return true;
    case kFrameWidget_SetInheritedEffectiveTouchActionForSubFrame_Name:
      var params = reader.decodeStruct(FrameWidget_SetInheritedEffectiveTouchActionForSubFrame_Params);
      this.setInheritedEffectiveTouchActionForSubFrame(params.touchAction);
      return true;
    case kFrameWidget_UpdateRenderThrottlingStatusForSubFrame_Name:
      var params = reader.decodeStruct(FrameWidget_UpdateRenderThrottlingStatusForSubFrame_Params);
      this.updateRenderThrottlingStatusForSubFrame(params.isThrottled, params.subtreeThrottled, params.displayLocked);
      return true;
    case kFrameWidget_SetIsInertForSubFrame_Name:
      var params = reader.decodeStruct(FrameWidget_SetIsInertForSubFrame_Params);
      this.setIsInertForSubFrame(params.inert);
      return true;
    case kFrameWidget_EnableDeviceEmulation_Name:
      var params = reader.decodeStruct(FrameWidget_EnableDeviceEmulation_Params);
      this.enableDeviceEmulation(params.parameters, params.cacheBehavior);
      return true;
    case kFrameWidget_DisableDeviceEmulation_Name:
      var params = reader.decodeStruct(FrameWidget_DisableDeviceEmulation_Params);
      this.disableDeviceEmulation();
      return true;
    case kFrameWidget_BindWidgetCompositor_Name:
      var params = reader.decodeStruct(FrameWidget_BindWidgetCompositor_Params);
      this.bindWidgetCompositor(params.host);
      return true;
    case kFrameWidget_SetViewportIntersection_Name:
      var params = reader.decodeStruct(FrameWidget_SetViewportIntersection_Params);
      this.setViewportIntersection(params.intersectionState, params.visualProperties);
      return true;
    case kFrameWidget_NotifyClearedDisplayedGraphics_Name:
      var params = reader.decodeStruct(FrameWidget_NotifyClearedDisplayedGraphics_Params);
      this.notifyClearedDisplayedGraphics();
      return true;
    default:
      return false;
    }
  };

  FrameWidgetStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kFrameWidget_DragTargetDragEnter_Name:
      var params = reader.decodeStruct(FrameWidget_DragTargetDragEnter_Params);
      this.dragTargetDragEnter(params.dragData, params.pointInViewport, params.screenPoint, params.operationsAllowed, params.keyModifiers).then(function(response) {
        var responseParams =
            new FrameWidget_DragTargetDragEnter_ResponseParams();
        responseParams.operation = response.operation;
        responseParams.documentIsHandlingDrag = response.documentIsHandlingDrag;
        var builder = new codec.MessageV1Builder(
            kFrameWidget_DragTargetDragEnter_Name,
            codec.align(FrameWidget_DragTargetDragEnter_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(FrameWidget_DragTargetDragEnter_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kFrameWidget_DragTargetDragOver_Name:
      var params = reader.decodeStruct(FrameWidget_DragTargetDragOver_Params);
      this.dragTargetDragOver(params.pointInViewport, params.screenPoint, params.operationsAllowed, params.keyModifiers).then(function(response) {
        var responseParams =
            new FrameWidget_DragTargetDragOver_ResponseParams();
        responseParams.operation = response.operation;
        responseParams.documentIsHandlingDrag = response.documentIsHandlingDrag;
        var builder = new codec.MessageV1Builder(
            kFrameWidget_DragTargetDragOver_Name,
            codec.align(FrameWidget_DragTargetDragOver_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(FrameWidget_DragTargetDragOver_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kFrameWidget_DragTargetDrop_Name:
      var params = reader.decodeStruct(FrameWidget_DragTargetDrop_Params);
      this.dragTargetDrop(params.dragData, params.pointInViewport, params.screenPoint, params.keyModifiers).then(function(response) {
        var responseParams =
            new FrameWidget_DragTargetDrop_ResponseParams();
        var builder = new codec.MessageV1Builder(
            kFrameWidget_DragTargetDrop_Name,
            codec.align(FrameWidget_DragTargetDrop_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(FrameWidget_DragTargetDrop_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kFrameWidget_DragSourceEndedAt_Name:
      var params = reader.decodeStruct(FrameWidget_DragSourceEndedAt_Params);
      this.dragSourceEndedAt(params.pointInViewport, params.screenPoint, params.dragOperation).then(function(response) {
        var responseParams =
            new FrameWidget_DragSourceEndedAt_ResponseParams();
        var builder = new codec.MessageV1Builder(
            kFrameWidget_DragSourceEndedAt_Name,
            codec.align(FrameWidget_DragSourceEndedAt_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(FrameWidget_DragSourceEndedAt_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kFrameWidget_OnStartStylusWriting_Name:
      var params = reader.decodeStruct(FrameWidget_OnStartStylusWriting_Params);
      this.onStartStylusWriting().then(function(response) {
        var responseParams =
            new FrameWidget_OnStartStylusWriting_ResponseParams();
        responseParams.focusResult = response.focusResult;
        var builder = new codec.MessageV1Builder(
            kFrameWidget_OnStartStylusWriting_Name,
            codec.align(FrameWidget_OnStartStylusWriting_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(FrameWidget_OnStartStylusWriting_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kFrameWidget_GetStringAtPoint_Name:
      var params = reader.decodeStruct(FrameWidget_GetStringAtPoint_Params);
      this.getStringAtPoint(params.pointInLocalRoot).then(function(response) {
        var responseParams =
            new FrameWidget_GetStringAtPoint_ResponseParams();
        responseParams.string = response.string;
        responseParams.baselinePoint = response.baselinePoint;
        var builder = new codec.MessageV1Builder(
            kFrameWidget_GetStringAtPoint_Name,
            codec.align(FrameWidget_GetStringAtPoint_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(FrameWidget_GetStringAtPoint_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    default:
      return false;
    }
  };

  function validateFrameWidgetRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kFrameWidget_DragTargetDragEnter_Name:
        if (message.expectsResponse())
          paramsClass = FrameWidget_DragTargetDragEnter_Params;
      break;
      case kFrameWidget_DragTargetDragOver_Name:
        if (message.expectsResponse())
          paramsClass = FrameWidget_DragTargetDragOver_Params;
      break;
      case kFrameWidget_DragTargetDragLeave_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = FrameWidget_DragTargetDragLeave_Params;
      break;
      case kFrameWidget_DragTargetDrop_Name:
        if (message.expectsResponse())
          paramsClass = FrameWidget_DragTargetDrop_Params;
      break;
      case kFrameWidget_DragSourceEndedAt_Name:
        if (message.expectsResponse())
          paramsClass = FrameWidget_DragSourceEndedAt_Params;
      break;
      case kFrameWidget_DragSourceSystemDragEnded_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = FrameWidget_DragSourceSystemDragEnded_Params;
      break;
      case kFrameWidget_OnStartStylusWriting_Name:
        if (message.expectsResponse())
          paramsClass = FrameWidget_OnStartStylusWriting_Params;
      break;
      case kFrameWidget_SetBackgroundOpaque_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = FrameWidget_SetBackgroundOpaque_Params;
      break;
      case kFrameWidget_SetTextDirection_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = FrameWidget_SetTextDirection_Params;
      break;
      case kFrameWidget_SetActive_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = FrameWidget_SetActive_Params;
      break;
      case kFrameWidget_SetInheritedEffectiveTouchActionForSubFrame_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = FrameWidget_SetInheritedEffectiveTouchActionForSubFrame_Params;
      break;
      case kFrameWidget_UpdateRenderThrottlingStatusForSubFrame_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = FrameWidget_UpdateRenderThrottlingStatusForSubFrame_Params;
      break;
      case kFrameWidget_SetIsInertForSubFrame_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = FrameWidget_SetIsInertForSubFrame_Params;
      break;
      case kFrameWidget_GetStringAtPoint_Name:
        if (message.expectsResponse())
          paramsClass = FrameWidget_GetStringAtPoint_Params;
      break;
      case kFrameWidget_EnableDeviceEmulation_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = FrameWidget_EnableDeviceEmulation_Params;
      break;
      case kFrameWidget_DisableDeviceEmulation_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = FrameWidget_DisableDeviceEmulation_Params;
      break;
      case kFrameWidget_BindWidgetCompositor_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = FrameWidget_BindWidgetCompositor_Params;
      break;
      case kFrameWidget_SetViewportIntersection_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = FrameWidget_SetViewportIntersection_Params;
      break;
      case kFrameWidget_NotifyClearedDisplayedGraphics_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = FrameWidget_NotifyClearedDisplayedGraphics_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateFrameWidgetResponse(messageValidator) {
   var message = messageValidator.message;
   var paramsClass = null;
   switch (message.getName()) {
      case kFrameWidget_DragTargetDragEnter_Name:
        if (message.isResponse())
          paramsClass = FrameWidget_DragTargetDragEnter_ResponseParams;
        break;
      case kFrameWidget_DragTargetDragOver_Name:
        if (message.isResponse())
          paramsClass = FrameWidget_DragTargetDragOver_ResponseParams;
        break;
      case kFrameWidget_DragTargetDrop_Name:
        if (message.isResponse())
          paramsClass = FrameWidget_DragTargetDrop_ResponseParams;
        break;
      case kFrameWidget_DragSourceEndedAt_Name:
        if (message.isResponse())
          paramsClass = FrameWidget_DragSourceEndedAt_ResponseParams;
        break;
      case kFrameWidget_OnStartStylusWriting_Name:
        if (message.isResponse())
          paramsClass = FrameWidget_OnStartStylusWriting_ResponseParams;
        break;
      case kFrameWidget_GetStringAtPoint_Name:
        if (message.isResponse())
          paramsClass = FrameWidget_GetStringAtPoint_ResponseParams;
        break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  var FrameWidget = {
    name: 'blink.mojom.FrameWidget',
    kVersion: 0,
    ptrClass: FrameWidgetPtr,
    proxyClass: FrameWidgetProxy,
    stubClass: FrameWidgetStub,
    validateRequest: validateFrameWidgetRequest,
    validateResponse: validateFrameWidgetResponse,
  };
  FrameWidgetStub.prototype.validator = validateFrameWidgetRequest;
  FrameWidgetProxy.prototype.validator = validateFrameWidgetResponse;
  var kFrameWidgetHost_AnimateDoubleTapZoomInMainFrame_Name = 0;
  var kFrameWidgetHost_ZoomToFindInPageRectInMainFrame_Name = 1;
  var kFrameWidgetHost_SetHasTouchEventConsumers_Name = 2;
  var kFrameWidgetHost_IntrinsicSizingInfoChanged_Name = 3;
  var kFrameWidgetHost_AutoscrollStart_Name = 4;
  var kFrameWidgetHost_AutoscrollFling_Name = 5;
  var kFrameWidgetHost_AutoscrollEnd_Name = 6;

  function FrameWidgetHostPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(FrameWidgetHost,
                                                   handleOrPtrInfo);
  }

  function FrameWidgetHostAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        FrameWidgetHost, associatedInterfacePtrInfo);
  }

  FrameWidgetHostAssociatedPtr.prototype =
      Object.create(FrameWidgetHostPtr.prototype);
  FrameWidgetHostAssociatedPtr.prototype.constructor =
      FrameWidgetHostAssociatedPtr;

  function FrameWidgetHostProxy(receiver) {
    this.receiver_ = receiver;
  }
  FrameWidgetHostPtr.prototype.animateDoubleTapZoomInMainFrame = function() {
    return FrameWidgetHostProxy.prototype.animateDoubleTapZoomInMainFrame
        .apply(this.ptr.getProxy(), arguments);
  };

  FrameWidgetHostProxy.prototype.animateDoubleTapZoomInMainFrame = function(tapPoint, rectToZoom) {
    var params_ = new FrameWidgetHost_AnimateDoubleTapZoomInMainFrame_Params();
    params_.tapPoint = tapPoint;
    params_.rectToZoom = rectToZoom;
    var builder = new codec.MessageV0Builder(
        kFrameWidgetHost_AnimateDoubleTapZoomInMainFrame_Name,
        codec.align(FrameWidgetHost_AnimateDoubleTapZoomInMainFrame_Params.encodedSize));
    builder.encodeStruct(FrameWidgetHost_AnimateDoubleTapZoomInMainFrame_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  FrameWidgetHostPtr.prototype.zoomToFindInPageRectInMainFrame = function() {
    return FrameWidgetHostProxy.prototype.zoomToFindInPageRectInMainFrame
        .apply(this.ptr.getProxy(), arguments);
  };

  FrameWidgetHostProxy.prototype.zoomToFindInPageRectInMainFrame = function(rectToZoom) {
    var params_ = new FrameWidgetHost_ZoomToFindInPageRectInMainFrame_Params();
    params_.rectToZoom = rectToZoom;
    var builder = new codec.MessageV0Builder(
        kFrameWidgetHost_ZoomToFindInPageRectInMainFrame_Name,
        codec.align(FrameWidgetHost_ZoomToFindInPageRectInMainFrame_Params.encodedSize));
    builder.encodeStruct(FrameWidgetHost_ZoomToFindInPageRectInMainFrame_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  FrameWidgetHostPtr.prototype.setHasTouchEventConsumers = function() {
    return FrameWidgetHostProxy.prototype.setHasTouchEventConsumers
        .apply(this.ptr.getProxy(), arguments);
  };

  FrameWidgetHostProxy.prototype.setHasTouchEventConsumers = function(touchEventConsumers) {
    var params_ = new FrameWidgetHost_SetHasTouchEventConsumers_Params();
    params_.touchEventConsumers = touchEventConsumers;
    var builder = new codec.MessageV0Builder(
        kFrameWidgetHost_SetHasTouchEventConsumers_Name,
        codec.align(FrameWidgetHost_SetHasTouchEventConsumers_Params.encodedSize));
    builder.encodeStruct(FrameWidgetHost_SetHasTouchEventConsumers_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  FrameWidgetHostPtr.prototype.intrinsicSizingInfoChanged = function() {
    return FrameWidgetHostProxy.prototype.intrinsicSizingInfoChanged
        .apply(this.ptr.getProxy(), arguments);
  };

  FrameWidgetHostProxy.prototype.intrinsicSizingInfoChanged = function(sizingInfo) {
    var params_ = new FrameWidgetHost_IntrinsicSizingInfoChanged_Params();
    params_.sizingInfo = sizingInfo;
    var builder = new codec.MessageV0Builder(
        kFrameWidgetHost_IntrinsicSizingInfoChanged_Name,
        codec.align(FrameWidgetHost_IntrinsicSizingInfoChanged_Params.encodedSize));
    builder.encodeStruct(FrameWidgetHost_IntrinsicSizingInfoChanged_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  FrameWidgetHostPtr.prototype.autoscrollStart = function() {
    return FrameWidgetHostProxy.prototype.autoscrollStart
        .apply(this.ptr.getProxy(), arguments);
  };

  FrameWidgetHostProxy.prototype.autoscrollStart = function(position) {
    var params_ = new FrameWidgetHost_AutoscrollStart_Params();
    params_.position = position;
    var builder = new codec.MessageV0Builder(
        kFrameWidgetHost_AutoscrollStart_Name,
        codec.align(FrameWidgetHost_AutoscrollStart_Params.encodedSize));
    builder.encodeStruct(FrameWidgetHost_AutoscrollStart_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  FrameWidgetHostPtr.prototype.autoscrollFling = function() {
    return FrameWidgetHostProxy.prototype.autoscrollFling
        .apply(this.ptr.getProxy(), arguments);
  };

  FrameWidgetHostProxy.prototype.autoscrollFling = function(velocity) {
    var params_ = new FrameWidgetHost_AutoscrollFling_Params();
    params_.velocity = velocity;
    var builder = new codec.MessageV0Builder(
        kFrameWidgetHost_AutoscrollFling_Name,
        codec.align(FrameWidgetHost_AutoscrollFling_Params.encodedSize));
    builder.encodeStruct(FrameWidgetHost_AutoscrollFling_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  FrameWidgetHostPtr.prototype.autoscrollEnd = function() {
    return FrameWidgetHostProxy.prototype.autoscrollEnd
        .apply(this.ptr.getProxy(), arguments);
  };

  FrameWidgetHostProxy.prototype.autoscrollEnd = function() {
    var params_ = new FrameWidgetHost_AutoscrollEnd_Params();
    var builder = new codec.MessageV0Builder(
        kFrameWidgetHost_AutoscrollEnd_Name,
        codec.align(FrameWidgetHost_AutoscrollEnd_Params.encodedSize));
    builder.encodeStruct(FrameWidgetHost_AutoscrollEnd_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function FrameWidgetHostStub(delegate) {
    this.delegate_ = delegate;
  }
  FrameWidgetHostStub.prototype.animateDoubleTapZoomInMainFrame = function(tapPoint, rectToZoom) {
    return this.delegate_ && this.delegate_.animateDoubleTapZoomInMainFrame && this.delegate_.animateDoubleTapZoomInMainFrame(tapPoint, rectToZoom);
  }
  FrameWidgetHostStub.prototype.zoomToFindInPageRectInMainFrame = function(rectToZoom) {
    return this.delegate_ && this.delegate_.zoomToFindInPageRectInMainFrame && this.delegate_.zoomToFindInPageRectInMainFrame(rectToZoom);
  }
  FrameWidgetHostStub.prototype.setHasTouchEventConsumers = function(touchEventConsumers) {
    return this.delegate_ && this.delegate_.setHasTouchEventConsumers && this.delegate_.setHasTouchEventConsumers(touchEventConsumers);
  }
  FrameWidgetHostStub.prototype.intrinsicSizingInfoChanged = function(sizingInfo) {
    return this.delegate_ && this.delegate_.intrinsicSizingInfoChanged && this.delegate_.intrinsicSizingInfoChanged(sizingInfo);
  }
  FrameWidgetHostStub.prototype.autoscrollStart = function(position) {
    return this.delegate_ && this.delegate_.autoscrollStart && this.delegate_.autoscrollStart(position);
  }
  FrameWidgetHostStub.prototype.autoscrollFling = function(velocity) {
    return this.delegate_ && this.delegate_.autoscrollFling && this.delegate_.autoscrollFling(velocity);
  }
  FrameWidgetHostStub.prototype.autoscrollEnd = function() {
    return this.delegate_ && this.delegate_.autoscrollEnd && this.delegate_.autoscrollEnd();
  }

  FrameWidgetHostStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kFrameWidgetHost_AnimateDoubleTapZoomInMainFrame_Name:
      var params = reader.decodeStruct(FrameWidgetHost_AnimateDoubleTapZoomInMainFrame_Params);
      this.animateDoubleTapZoomInMainFrame(params.tapPoint, params.rectToZoom);
      return true;
    case kFrameWidgetHost_ZoomToFindInPageRectInMainFrame_Name:
      var params = reader.decodeStruct(FrameWidgetHost_ZoomToFindInPageRectInMainFrame_Params);
      this.zoomToFindInPageRectInMainFrame(params.rectToZoom);
      return true;
    case kFrameWidgetHost_SetHasTouchEventConsumers_Name:
      var params = reader.decodeStruct(FrameWidgetHost_SetHasTouchEventConsumers_Params);
      this.setHasTouchEventConsumers(params.touchEventConsumers);
      return true;
    case kFrameWidgetHost_IntrinsicSizingInfoChanged_Name:
      var params = reader.decodeStruct(FrameWidgetHost_IntrinsicSizingInfoChanged_Params);
      this.intrinsicSizingInfoChanged(params.sizingInfo);
      return true;
    case kFrameWidgetHost_AutoscrollStart_Name:
      var params = reader.decodeStruct(FrameWidgetHost_AutoscrollStart_Params);
      this.autoscrollStart(params.position);
      return true;
    case kFrameWidgetHost_AutoscrollFling_Name:
      var params = reader.decodeStruct(FrameWidgetHost_AutoscrollFling_Params);
      this.autoscrollFling(params.velocity);
      return true;
    case kFrameWidgetHost_AutoscrollEnd_Name:
      var params = reader.decodeStruct(FrameWidgetHost_AutoscrollEnd_Params);
      this.autoscrollEnd();
      return true;
    default:
      return false;
    }
  };

  FrameWidgetHostStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  function validateFrameWidgetHostRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kFrameWidgetHost_AnimateDoubleTapZoomInMainFrame_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = FrameWidgetHost_AnimateDoubleTapZoomInMainFrame_Params;
      break;
      case kFrameWidgetHost_ZoomToFindInPageRectInMainFrame_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = FrameWidgetHost_ZoomToFindInPageRectInMainFrame_Params;
      break;
      case kFrameWidgetHost_SetHasTouchEventConsumers_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = FrameWidgetHost_SetHasTouchEventConsumers_Params;
      break;
      case kFrameWidgetHost_IntrinsicSizingInfoChanged_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = FrameWidgetHost_IntrinsicSizingInfoChanged_Params;
      break;
      case kFrameWidgetHost_AutoscrollStart_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = FrameWidgetHost_AutoscrollStart_Params;
      break;
      case kFrameWidgetHost_AutoscrollFling_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = FrameWidgetHost_AutoscrollFling_Params;
      break;
      case kFrameWidgetHost_AutoscrollEnd_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = FrameWidgetHost_AutoscrollEnd_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateFrameWidgetHostResponse(messageValidator) {
    return validator.validationError.NONE;
  }

  var FrameWidgetHost = {
    name: 'blink.mojom.FrameWidgetHost',
    kVersion: 0,
    ptrClass: FrameWidgetHostPtr,
    proxyClass: FrameWidgetHostProxy,
    stubClass: FrameWidgetHostStub,
    validateRequest: validateFrameWidgetHostRequest,
    validateResponse: null,
  };
  FrameWidgetHostStub.prototype.validator = validateFrameWidgetHostRequest;
  FrameWidgetHostProxy.prototype.validator = null;
  var kPopupWidgetHost_RequestClosePopup_Name = 0;
  var kPopupWidgetHost_ShowPopup_Name = 1;
  var kPopupWidgetHost_SetPopupBounds_Name = 2;

  function PopupWidgetHostPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(PopupWidgetHost,
                                                   handleOrPtrInfo);
  }

  function PopupWidgetHostAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        PopupWidgetHost, associatedInterfacePtrInfo);
  }

  PopupWidgetHostAssociatedPtr.prototype =
      Object.create(PopupWidgetHostPtr.prototype);
  PopupWidgetHostAssociatedPtr.prototype.constructor =
      PopupWidgetHostAssociatedPtr;

  function PopupWidgetHostProxy(receiver) {
    this.receiver_ = receiver;
  }
  PopupWidgetHostPtr.prototype.requestClosePopup = function() {
    return PopupWidgetHostProxy.prototype.requestClosePopup
        .apply(this.ptr.getProxy(), arguments);
  };

  PopupWidgetHostProxy.prototype.requestClosePopup = function() {
    var params_ = new PopupWidgetHost_RequestClosePopup_Params();
    var builder = new codec.MessageV0Builder(
        kPopupWidgetHost_RequestClosePopup_Name,
        codec.align(PopupWidgetHost_RequestClosePopup_Params.encodedSize));
    builder.encodeStruct(PopupWidgetHost_RequestClosePopup_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  PopupWidgetHostPtr.prototype.showPopup = function() {
    return PopupWidgetHostProxy.prototype.showPopup
        .apply(this.ptr.getProxy(), arguments);
  };

  PopupWidgetHostProxy.prototype.showPopup = function(initialRect, anchorRect) {
    var params_ = new PopupWidgetHost_ShowPopup_Params();
    params_.initialRect = initialRect;
    params_.anchorRect = anchorRect;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kPopupWidgetHost_ShowPopup_Name,
          codec.align(PopupWidgetHost_ShowPopup_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(PopupWidgetHost_ShowPopup_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(PopupWidgetHost_ShowPopup_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  PopupWidgetHostPtr.prototype.setPopupBounds = function() {
    return PopupWidgetHostProxy.prototype.setPopupBounds
        .apply(this.ptr.getProxy(), arguments);
  };

  PopupWidgetHostProxy.prototype.setPopupBounds = function(bounds) {
    var params_ = new PopupWidgetHost_SetPopupBounds_Params();
    params_.bounds = bounds;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kPopupWidgetHost_SetPopupBounds_Name,
          codec.align(PopupWidgetHost_SetPopupBounds_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(PopupWidgetHost_SetPopupBounds_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(PopupWidgetHost_SetPopupBounds_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };

  function PopupWidgetHostStub(delegate) {
    this.delegate_ = delegate;
  }
  PopupWidgetHostStub.prototype.requestClosePopup = function() {
    return this.delegate_ && this.delegate_.requestClosePopup && this.delegate_.requestClosePopup();
  }
  PopupWidgetHostStub.prototype.showPopup = function(initialRect, anchorRect) {
    return this.delegate_ && this.delegate_.showPopup && this.delegate_.showPopup(initialRect, anchorRect);
  }
  PopupWidgetHostStub.prototype.setPopupBounds = function(bounds) {
    return this.delegate_ && this.delegate_.setPopupBounds && this.delegate_.setPopupBounds(bounds);
  }

  PopupWidgetHostStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kPopupWidgetHost_RequestClosePopup_Name:
      var params = reader.decodeStruct(PopupWidgetHost_RequestClosePopup_Params);
      this.requestClosePopup();
      return true;
    default:
      return false;
    }
  };

  PopupWidgetHostStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kPopupWidgetHost_ShowPopup_Name:
      var params = reader.decodeStruct(PopupWidgetHost_ShowPopup_Params);
      this.showPopup(params.initialRect, params.anchorRect).then(function(response) {
        var responseParams =
            new PopupWidgetHost_ShowPopup_ResponseParams();
        var builder = new codec.MessageV1Builder(
            kPopupWidgetHost_ShowPopup_Name,
            codec.align(PopupWidgetHost_ShowPopup_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(PopupWidgetHost_ShowPopup_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kPopupWidgetHost_SetPopupBounds_Name:
      var params = reader.decodeStruct(PopupWidgetHost_SetPopupBounds_Params);
      this.setPopupBounds(params.bounds).then(function(response) {
        var responseParams =
            new PopupWidgetHost_SetPopupBounds_ResponseParams();
        var builder = new codec.MessageV1Builder(
            kPopupWidgetHost_SetPopupBounds_Name,
            codec.align(PopupWidgetHost_SetPopupBounds_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(PopupWidgetHost_SetPopupBounds_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    default:
      return false;
    }
  };

  function validatePopupWidgetHostRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kPopupWidgetHost_RequestClosePopup_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = PopupWidgetHost_RequestClosePopup_Params;
      break;
      case kPopupWidgetHost_ShowPopup_Name:
        if (message.expectsResponse())
          paramsClass = PopupWidgetHost_ShowPopup_Params;
      break;
      case kPopupWidgetHost_SetPopupBounds_Name:
        if (message.expectsResponse())
          paramsClass = PopupWidgetHost_SetPopupBounds_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validatePopupWidgetHostResponse(messageValidator) {
   var message = messageValidator.message;
   var paramsClass = null;
   switch (message.getName()) {
      case kPopupWidgetHost_ShowPopup_Name:
        if (message.isResponse())
          paramsClass = PopupWidgetHost_ShowPopup_ResponseParams;
        break;
      case kPopupWidgetHost_SetPopupBounds_Name:
        if (message.isResponse())
          paramsClass = PopupWidgetHost_SetPopupBounds_ResponseParams;
        break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  var PopupWidgetHost = {
    name: 'blink.mojom.PopupWidgetHost',
    kVersion: 0,
    ptrClass: PopupWidgetHostPtr,
    proxyClass: PopupWidgetHostProxy,
    stubClass: PopupWidgetHostStub,
    validateRequest: validatePopupWidgetHostRequest,
    validateResponse: validatePopupWidgetHostResponse,
  };
  PopupWidgetHostStub.prototype.validator = validatePopupWidgetHostRequest;
  PopupWidgetHostProxy.prototype.validator = validatePopupWidgetHostResponse;
  exports.DeviceEmulationCacheBehavior = DeviceEmulationCacheBehavior;
  exports.StylusWritingFocusResult = StylusWritingFocusResult;
  exports.FrameWidget = FrameWidget;
  exports.FrameWidgetPtr = FrameWidgetPtr;
  exports.FrameWidgetAssociatedPtr = FrameWidgetAssociatedPtr;
  exports.FrameWidgetHost = FrameWidgetHost;
  exports.FrameWidgetHostPtr = FrameWidgetHostPtr;
  exports.FrameWidgetHostAssociatedPtr = FrameWidgetHostAssociatedPtr;
  exports.PopupWidgetHost = PopupWidgetHost;
  exports.PopupWidgetHostPtr = PopupWidgetHostPtr;
  exports.PopupWidgetHostAssociatedPtr = PopupWidgetHostAssociatedPtr;
})();