// third_party/blink/public/mojom/page/prerender_page_param.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_PAGE_PRERENDER_PAGE_PARAM_MOJOM_BLINK_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_PAGE_PRERENDER_PAGE_PARAM_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/page/prerender_page_param.mojom-features.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/page/prerender_page_param.mojom-shared.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/page/prerender_page_param.mojom-blink-forward.h"  // IWYU pragma: export

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"




#include "third_party/blink/renderer/core/core_export.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace blink::mojom::blink {





class CORE_EXPORT PrerenderParam {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<PrerenderParam, T>::value>;
  using DataView = PrerenderParamDataView;
  using Data_ = internal::PrerenderParam_Data;

  template <typename... Args>
  static PrerenderParamPtr New(Args&&... args) {
    return PrerenderParamPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PrerenderParamPtr From(const U& u) {
    return mojo::TypeConverter<PrerenderParamPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PrerenderParam>::Convert(*this);
  }


  PrerenderParam();

  PrerenderParam(
      const ::blink::String& page_metric_suffix,
      bool should_warm_up_compositor,
      bool should_prepare_paint_tree,
      bool should_pause_javascript_execution);


  ~PrerenderParam();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PrerenderParamPtr>
  PrerenderParamPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, PrerenderParam::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, PrerenderParam::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, PrerenderParam::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PrerenderParam::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PrerenderParam::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PrerenderParam::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::PrerenderParam_UnserializedMessageContext<
            UserType, PrerenderParam::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<PrerenderParam::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return PrerenderParam::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::PrerenderParam_UnserializedMessageContext<
            UserType, PrerenderParam::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<PrerenderParam::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::String page_metric_suffix;
  
  bool should_warm_up_compositor;
  
  bool should_prepare_paint_tree;
  
  bool should_pause_javascript_execution;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, PrerenderParam::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, PrerenderParam::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, PrerenderParam::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, PrerenderParam::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}




template <typename StructPtrType>
PrerenderParamPtr PrerenderParam::Clone() const {
  return New(
      mojo::Clone(page_metric_suffix),
      mojo::Clone(should_warm_up_compositor),
      mojo::Clone(should_prepare_paint_tree),
      mojo::Clone(should_pause_javascript_execution)
  );
}

template <typename T, PrerenderParam::EnableIfSame<T>*>
bool PrerenderParam::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->page_metric_suffix, other_struct.page_metric_suffix))
    return false;
  if (!mojo::Equals(this->should_warm_up_compositor, other_struct.should_warm_up_compositor))
    return false;
  if (!mojo::Equals(this->should_prepare_paint_tree, other_struct.should_prepare_paint_tree))
    return false;
  if (!mojo::Equals(this->should_pause_javascript_execution, other_struct.should_pause_javascript_execution))
    return false;
  return true;
}

template <typename T, PrerenderParam::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.page_metric_suffix < rhs.page_metric_suffix)
    return true;
  if (rhs.page_metric_suffix < lhs.page_metric_suffix)
    return false;
  if (lhs.should_warm_up_compositor < rhs.should_warm_up_compositor)
    return true;
  if (rhs.should_warm_up_compositor < lhs.should_warm_up_compositor)
    return false;
  if (lhs.should_prepare_paint_tree < rhs.should_prepare_paint_tree)
    return true;
  if (rhs.should_prepare_paint_tree < lhs.should_prepare_paint_tree)
    return false;
  if (lhs.should_pause_javascript_execution < rhs.should_pause_javascript_execution)
    return true;
  if (rhs.should_pause_javascript_execution < lhs.should_pause_javascript_execution)
    return false;
  return false;
}


}  // blink::mojom::blink

namespace mojo {


template <>
struct CORE_EXPORT StructTraits<::blink::mojom::blink::PrerenderParam::DataView,
                                         ::blink::mojom::blink::PrerenderParamPtr> {
  static bool IsNull(const ::blink::mojom::blink::PrerenderParamPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::PrerenderParamPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::blink::PrerenderParam::page_metric_suffix)& page_metric_suffix(
      const ::blink::mojom::blink::PrerenderParamPtr& input) {
    return input->page_metric_suffix;
  }

  static decltype(::blink::mojom::blink::PrerenderParam::should_warm_up_compositor) should_warm_up_compositor(
      const ::blink::mojom::blink::PrerenderParamPtr& input) {
    return input->should_warm_up_compositor;
  }

  static decltype(::blink::mojom::blink::PrerenderParam::should_prepare_paint_tree) should_prepare_paint_tree(
      const ::blink::mojom::blink::PrerenderParamPtr& input) {
    return input->should_prepare_paint_tree;
  }

  static decltype(::blink::mojom::blink::PrerenderParam::should_pause_javascript_execution) should_pause_javascript_execution(
      const ::blink::mojom::blink::PrerenderParamPtr& input) {
    return input->should_pause_javascript_execution;
  }

  static bool Read(::blink::mojom::blink::PrerenderParam::DataView input, ::blink::mojom::blink::PrerenderParamPtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_PAGE_PRERENDER_PAGE_PARAM_MOJOM_BLINK_H_