// third_party/blink/public/mojom/page/page.mojom-lite.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';


mojo.internal.exportModule('blink.mojom');





/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
blink.mojom.PagehideDispatchSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
blink.mojom.PagehideDispatch = {
  
  kNotDispatched: 0,
  kDispatchedNotPersisted: 1,
  kDispatchedPersisted: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};





/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.PageBroadcastPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.PageBroadcast.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { blink.mojom.PageBroadcastInterface }
 */
blink.mojom.PageBroadcastRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.PageBroadcastPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.PageBroadcastPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.PageBroadcastPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !blink.mojom.PageLifecycleState } state
   * @param { ?blink.mojom.PageRestoreParams } pageRestoreParams
   * @return {!Promise}
   */

  setPageLifecycleState(
      state,
      pageRestoreParams) {
    return this.proxy.sendMessage(
        0,
        blink.mojom.PageBroadcast_SetPageLifecycleState_ParamsSpec.$,
        blink.mojom.PageBroadcast_SetPageLifecycleState_ResponseParamsSpec.$,
        [
          state,
          pageRestoreParams
        ],
        false);
  }

  
  /**
   * @param { !boolean } isAudioPlaying
   */

  audioStateChanged(
      isAudioPlaying) {
    this.proxy.sendMessage(
        1,
        blink.mojom.PageBroadcast_AudioStateChanged_ParamsSpec.$,
        null,
        [
          isAudioPlaying
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.PrerenderPageActivationParams } prerenderPageActivationParams
   * @return {!Promise}
   */

  activatePrerenderedPage(
      prerenderPageActivationParams) {
    return this.proxy.sendMessage(
        2,
        blink.mojom.PageBroadcast_ActivatePrerenderedPage_ParamsSpec.$,
        blink.mojom.PageBroadcast_ActivatePrerenderedPage_ResponseParamsSpec.$,
        [
          prerenderPageActivationParams
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.WebPreferences } preferences
   */

  updateWebPreferences(
      preferences) {
    this.proxy.sendMessage(
        3,
        blink.mojom.PageBroadcast_UpdateWebPreferences_ParamsSpec.$,
        null,
        [
          preferences
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.RendererPreferences } preferences
   */

  updateRendererPreferences(
      preferences) {
    this.proxy.sendMessage(
        4,
        blink.mojom.PageBroadcast_UpdateRendererPreferences_ParamsSpec.$,
        null,
        [
          preferences
        ],
        false);
  }

  
  /**
   * @param { !number } index
   * @param { !number } length
   */

  setHistoryIndexAndLength(
      index,
      length) {
    this.proxy.sendMessage(
        5,
        blink.mojom.PageBroadcast_SetHistoryIndexAndLength_ParamsSpec.$,
        null,
        [
          index,
          length
        ],
        false);
  }

  
  /**
   * @param { ?skia.mojom.SkColor } color
   */

  setPageBaseBackgroundColor(
      color) {
    this.proxy.sendMessage(
        6,
        blink.mojom.PageBroadcast_SetPageBaseBackgroundColor_ParamsSpec.$,
        null,
        [
          color
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.RemoteFrameToken } token
   * @param { ?blink.mojom.FrameToken } openerFrameToken
   * @param { !blink.mojom.FrameReplicationState } replicationState
   * @param { !boolean } isLoading
   * @param { !mojoBase.mojom.UnguessableToken } devtoolsFrameToken
   * @param { ?mojoBase.mojom.UnguessableToken } navigationMetricsToken
   * @param { !blink.mojom.RemoteFrameInterfacesFromBrowser } remoteFrameInterfaces
   * @param { !blink.mojom.RemoteMainFrameInterfaces } remoteMainFrameInterfaces
   */

  createRemoteMainFrame(
      token,
      openerFrameToken,
      replicationState,
      isLoading,
      devtoolsFrameToken,
      navigationMetricsToken,
      remoteFrameInterfaces,
      remoteMainFrameInterfaces) {
    this.proxy.sendMessage(
        7,
        blink.mojom.PageBroadcast_CreateRemoteMainFrame_ParamsSpec.$,
        null,
        [
          token,
          openerFrameToken,
          replicationState,
          isLoading,
          devtoolsFrameToken,
          navigationMetricsToken,
          remoteFrameInterfaces,
          remoteMainFrameInterfaces
        ],
        false);
  }

  
  /**
   * @param { !mojoBase.mojom.UnguessableToken } browsingContextGroupToken
   */

  updatePageBrowsingContextGroup(
      browsingContextGroupToken) {
    this.proxy.sendMessage(
        8,
        blink.mojom.PageBroadcast_UpdatePageBrowsingContextGroup_ParamsSpec.$,
        null,
        [
          browsingContextGroupToken
        ],
        false);
  }

  
  /**
   * @param { !network.mojom.AttributionSupport } support
   */

  setPageAttributionSupport(
      support) {
    this.proxy.sendMessage(
        9,
        blink.mojom.PageBroadcast_SetPageAttributionSupport_ParamsSpec.$,
        null,
        [
          support
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.ColorProviderColorMaps } colorProviderColors
   */

  updateColorProviders(
      colorProviderColors) {
    this.proxy.sendMessage(
        10,
        blink.mojom.PageBroadcast_UpdateColorProviders_ParamsSpec.$,
        null,
        [
          colorProviderColors
        ],
        false);
  }

  
  /**
   * @param { !boolean } supportsDraggableRegions
   */

  setSupportsDraggableRegions(
      supportsDraggableRegions) {
    this.proxy.sendMessage(
        11,
        blink.mojom.PageBroadcast_SetSupportsDraggableRegions_ParamsSpec.$,
        null,
        [
          supportsDraggableRegions
        ],
        false);
  }
};

/**
 * An object which receives request messages for the PageBroadcast
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.PageBroadcastReceiver = class {
  /**
   * @param {!blink.mojom.PageBroadcastInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.PageBroadcastRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.PageBroadcastRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.PageBroadcastRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.PageBroadcast_SetPageLifecycleState_ParamsSpec.$,
        blink.mojom.PageBroadcast_SetPageLifecycleState_ResponseParamsSpec.$,
        impl.setPageLifecycleState.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        blink.mojom.PageBroadcast_AudioStateChanged_ParamsSpec.$,
        null,
        impl.audioStateChanged.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        blink.mojom.PageBroadcast_ActivatePrerenderedPage_ParamsSpec.$,
        blink.mojom.PageBroadcast_ActivatePrerenderedPage_ResponseParamsSpec.$,
        impl.activatePrerenderedPage.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        blink.mojom.PageBroadcast_UpdateWebPreferences_ParamsSpec.$,
        null,
        impl.updateWebPreferences.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        blink.mojom.PageBroadcast_UpdateRendererPreferences_ParamsSpec.$,
        null,
        impl.updateRendererPreferences.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        blink.mojom.PageBroadcast_SetHistoryIndexAndLength_ParamsSpec.$,
        null,
        impl.setHistoryIndexAndLength.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        blink.mojom.PageBroadcast_SetPageBaseBackgroundColor_ParamsSpec.$,
        null,
        impl.setPageBaseBackgroundColor.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        blink.mojom.PageBroadcast_CreateRemoteMainFrame_ParamsSpec.$,
        null,
        impl.createRemoteMainFrame.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        8,
        blink.mojom.PageBroadcast_UpdatePageBrowsingContextGroup_ParamsSpec.$,
        null,
        impl.updatePageBrowsingContextGroup.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        9,
        blink.mojom.PageBroadcast_SetPageAttributionSupport_ParamsSpec.$,
        null,
        impl.setPageAttributionSupport.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        10,
        blink.mojom.PageBroadcast_UpdateColorProviders_ParamsSpec.$,
        null,
        impl.updateColorProviders.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        11,
        blink.mojom.PageBroadcast_SetSupportsDraggableRegions_ParamsSpec.$,
        null,
        impl.setSupportsDraggableRegions.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.PageBroadcast = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.PageBroadcast";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.PageBroadcastRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.PageBroadcastRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the PageBroadcast
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.PageBroadcastCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.PageBroadcastRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.PageBroadcastRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setPageLifecycleState =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.PageBroadcast_SetPageLifecycleState_ParamsSpec.$,
        blink.mojom.PageBroadcast_SetPageLifecycleState_ResponseParamsSpec.$,
        this.setPageLifecycleState.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.audioStateChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        blink.mojom.PageBroadcast_AudioStateChanged_ParamsSpec.$,
        null,
        this.audioStateChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.activatePrerenderedPage =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        blink.mojom.PageBroadcast_ActivatePrerenderedPage_ParamsSpec.$,
        blink.mojom.PageBroadcast_ActivatePrerenderedPage_ResponseParamsSpec.$,
        this.activatePrerenderedPage.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.updateWebPreferences =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        blink.mojom.PageBroadcast_UpdateWebPreferences_ParamsSpec.$,
        null,
        this.updateWebPreferences.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.updateRendererPreferences =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        blink.mojom.PageBroadcast_UpdateRendererPreferences_ParamsSpec.$,
        null,
        this.updateRendererPreferences.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setHistoryIndexAndLength =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        blink.mojom.PageBroadcast_SetHistoryIndexAndLength_ParamsSpec.$,
        null,
        this.setHistoryIndexAndLength.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setPageBaseBackgroundColor =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        blink.mojom.PageBroadcast_SetPageBaseBackgroundColor_ParamsSpec.$,
        null,
        this.setPageBaseBackgroundColor.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.createRemoteMainFrame =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        blink.mojom.PageBroadcast_CreateRemoteMainFrame_ParamsSpec.$,
        null,
        this.createRemoteMainFrame.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.updatePageBrowsingContextGroup =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        8,
        blink.mojom.PageBroadcast_UpdatePageBrowsingContextGroup_ParamsSpec.$,
        null,
        this.updatePageBrowsingContextGroup.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setPageAttributionSupport =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        9,
        blink.mojom.PageBroadcast_SetPageAttributionSupport_ParamsSpec.$,
        null,
        this.setPageAttributionSupport.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.updateColorProviders =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        10,
        blink.mojom.PageBroadcast_UpdateColorProviders_ParamsSpec.$,
        null,
        this.updateColorProviders.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setSupportsDraggableRegions =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        11,
        blink.mojom.PageBroadcast_SetSupportsDraggableRegions_ParamsSpec.$,
        null,
        this.setSupportsDraggableRegions.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};



/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.PageLifecycleStateSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.PageRestoreParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ColorProviderColorMapsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.PrerenderPageActivationParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.PageBroadcast_SetPageLifecycleState_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.PageBroadcast_SetPageLifecycleState_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.PageBroadcast_AudioStateChanged_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.PageBroadcast_ActivatePrerenderedPage_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.PageBroadcast_ActivatePrerenderedPage_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.PageBroadcast_UpdateWebPreferences_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.PageBroadcast_UpdateRendererPreferences_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.PageBroadcast_SetHistoryIndexAndLength_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.PageBroadcast_SetPageBaseBackgroundColor_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.PageBroadcast_CreateRemoteMainFrame_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.PageBroadcast_UpdatePageBrowsingContextGroup_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.PageBroadcast_SetPageAttributionSupport_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.PageBroadcast_UpdateColorProviders_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.PageBroadcast_SetSupportsDraggableRegions_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    blink.mojom.PageLifecycleStateSpec.$,
    'PageLifecycleState',
    [
      mojo.internal.StructField(
        'isFrozen', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'visibility', 4,
        0,
        blink.mojom.PageVisibilityStateSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'isInBackForwardCache', 0,
        1,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'pagehideDispatch', 8,
        0,
        blink.mojom.PagehideDispatchSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'evictionEnabled', 0,
        2,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
blink.mojom.PageLifecycleState = class {
  constructor() {
    /** @export { !boolean } */
    this.isFrozen;
    /** @export { !blink.mojom.PageVisibilityState } */
    this.visibility;
    /** @export { !boolean } */
    this.isInBackForwardCache;
    /** @export { !blink.mojom.PagehideDispatch } */
    this.pagehideDispatch;
    /** @export { !boolean } */
    this.evictionEnabled;
  }
};



mojo.internal.Struct(
    blink.mojom.PageRestoreParamsSpec.$,
    'PageRestoreParams',
    [
      mojo.internal.StructField(
        'navigationStart', 0,
        0,
        mojoBase.mojom.TimeTicksSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'pendingHistoryListIndex', 8,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'currentHistoryListLength', 12,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'viewTransitionState', 16,
        0,
        blink.mojom.ViewTransitionStateSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);





/** @record */
blink.mojom.PageRestoreParams = class {
  constructor() {
    /** @export { !mojoBase.mojom.TimeTicks } */
    this.navigationStart;
    /** @export { !number } */
    this.pendingHistoryListIndex;
    /** @export { !number } */
    this.currentHistoryListLength;
    /** @export { (blink.mojom.ViewTransitionState|undefined) } */
    this.viewTransitionState;
  }
};



mojo.internal.Struct(
    blink.mojom.ColorProviderColorMapsSpec.$,
    'ColorProviderColorMaps',
    [
      mojo.internal.StructField(
        'lightColorsMap', 0,
        0,
        mojo.internal.Map(color.mojom.RendererColorIdSpec.$, skia.mojom.SkColorSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'darkColorsMap', 8,
        0,
        mojo.internal.Map(color.mojom.RendererColorIdSpec.$, skia.mojom.SkColorSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'forcedColorsMap', 16,
        0,
        mojo.internal.Map(color.mojom.RendererColorIdSpec.$, skia.mojom.SkColorSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);





/** @record */
blink.mojom.ColorProviderColorMaps = class {
  constructor() {
    /** @export { !Object<!color.mojom.RendererColorId, !skia.mojom.SkColor> } */
    this.lightColorsMap;
    /** @export { !Object<!color.mojom.RendererColorId, !skia.mojom.SkColor> } */
    this.darkColorsMap;
    /** @export { !Object<!color.mojom.RendererColorId, !skia.mojom.SkColor> } */
    this.forcedColorsMap;
  }
};



mojo.internal.Struct(
    blink.mojom.PrerenderPageActivationParamsSpec.$,
    'PrerenderPageActivationParams',
    [
      mojo.internal.StructField(
        'wasUserActivated', 0,
        0,
        blink.mojom.WasActivatedOptionSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'activationStart', 8,
        0,
        mojoBase.mojom.TimeTicksSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'viewTransitionState', 16,
        0,
        blink.mojom.ViewTransitionStateSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);





/** @record */
blink.mojom.PrerenderPageActivationParams = class {
  constructor() {
    /** @export { !blink.mojom.WasActivatedOption } */
    this.wasUserActivated;
    /** @export { (mojoBase.mojom.TimeTicks|undefined) } */
    this.activationStart;
    /** @export { (blink.mojom.ViewTransitionState|undefined) } */
    this.viewTransitionState;
  }
};



mojo.internal.Struct(
    blink.mojom.PageBroadcast_SetPageLifecycleState_ParamsSpec.$,
    'PageBroadcast_SetPageLifecycleState_Params',
    [
      mojo.internal.StructField(
        'state', 0,
        0,
        blink.mojom.PageLifecycleStateSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'pageRestoreParams', 8,
        0,
        blink.mojom.PageRestoreParamsSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
blink.mojom.PageBroadcast_SetPageLifecycleState_Params = class {
  constructor() {
    /** @export { !blink.mojom.PageLifecycleState } */
    this.state;
    /** @export { (blink.mojom.PageRestoreParams|undefined) } */
    this.pageRestoreParams;
  }
};



mojo.internal.Struct(
    blink.mojom.PageBroadcast_SetPageLifecycleState_ResponseParamsSpec.$,
    'PageBroadcast_SetPageLifecycleState_ResponseParams',
    [
    ],
    [[0, 8],]);





/** @record */
blink.mojom.PageBroadcast_SetPageLifecycleState_ResponseParams = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.PageBroadcast_AudioStateChanged_ParamsSpec.$,
    'PageBroadcast_AudioStateChanged_Params',
    [
      mojo.internal.StructField(
        'isAudioPlaying', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.PageBroadcast_AudioStateChanged_Params = class {
  constructor() {
    /** @export { !boolean } */
    this.isAudioPlaying;
  }
};



mojo.internal.Struct(
    blink.mojom.PageBroadcast_ActivatePrerenderedPage_ParamsSpec.$,
    'PageBroadcast_ActivatePrerenderedPage_Params',
    [
      mojo.internal.StructField(
        'prerenderPageActivationParams', 0,
        0,
        blink.mojom.PrerenderPageActivationParamsSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.PageBroadcast_ActivatePrerenderedPage_Params = class {
  constructor() {
    /** @export { !blink.mojom.PrerenderPageActivationParams } */
    this.prerenderPageActivationParams;
  }
};



mojo.internal.Struct(
    blink.mojom.PageBroadcast_ActivatePrerenderedPage_ResponseParamsSpec.$,
    'PageBroadcast_ActivatePrerenderedPage_ResponseParams',
    [
    ],
    [[0, 8],]);





/** @record */
blink.mojom.PageBroadcast_ActivatePrerenderedPage_ResponseParams = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.PageBroadcast_UpdateWebPreferences_ParamsSpec.$,
    'PageBroadcast_UpdateWebPreferences_Params',
    [
      mojo.internal.StructField(
        'preferences', 0,
        0,
        blink.mojom.WebPreferencesSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.PageBroadcast_UpdateWebPreferences_Params = class {
  constructor() {
    /** @export { !blink.mojom.WebPreferences } */
    this.preferences;
  }
};



mojo.internal.Struct(
    blink.mojom.PageBroadcast_UpdateRendererPreferences_ParamsSpec.$,
    'PageBroadcast_UpdateRendererPreferences_Params',
    [
      mojo.internal.StructField(
        'preferences', 0,
        0,
        blink.mojom.RendererPreferencesSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.PageBroadcast_UpdateRendererPreferences_Params = class {
  constructor() {
    /** @export { !blink.mojom.RendererPreferences } */
    this.preferences;
  }
};



mojo.internal.Struct(
    blink.mojom.PageBroadcast_SetHistoryIndexAndLength_ParamsSpec.$,
    'PageBroadcast_SetHistoryIndexAndLength_Params',
    [
      mojo.internal.StructField(
        'index', 0,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'length', 4,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.PageBroadcast_SetHistoryIndexAndLength_Params = class {
  constructor() {
    /** @export { !number } */
    this.index;
    /** @export { !number } */
    this.length;
  }
};



mojo.internal.Struct(
    blink.mojom.PageBroadcast_SetPageBaseBackgroundColor_ParamsSpec.$,
    'PageBroadcast_SetPageBaseBackgroundColor_Params',
    [
      mojo.internal.StructField(
        'color', 0,
        0,
        skia.mojom.SkColorSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.PageBroadcast_SetPageBaseBackgroundColor_Params = class {
  constructor() {
    /** @export { (skia.mojom.SkColor|undefined) } */
    this.color;
  }
};



mojo.internal.Struct(
    blink.mojom.PageBroadcast_CreateRemoteMainFrame_ParamsSpec.$,
    'PageBroadcast_CreateRemoteMainFrame_Params',
    [
      mojo.internal.StructField(
        'token', 0,
        0,
        blink.mojom.RemoteFrameTokenSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'openerFrameToken', 8,
        0,
        blink.mojom.FrameTokenSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'replicationState', 24,
        0,
        blink.mojom.FrameReplicationStateSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'isLoading', 32,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'devtoolsFrameToken', 40,
        0,
        mojoBase.mojom.UnguessableTokenSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'navigationMetricsToken', 48,
        0,
        mojoBase.mojom.UnguessableTokenSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'remoteFrameInterfaces', 56,
        0,
        blink.mojom.RemoteFrameInterfacesFromBrowserSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'remoteMainFrameInterfaces', 64,
        0,
        blink.mojom.RemoteMainFrameInterfacesSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 80],]);





/** @record */
blink.mojom.PageBroadcast_CreateRemoteMainFrame_Params = class {
  constructor() {
    /** @export { !blink.mojom.RemoteFrameToken } */
    this.token;
    /** @export { (blink.mojom.FrameToken|undefined) } */
    this.openerFrameToken;
    /** @export { !blink.mojom.FrameReplicationState } */
    this.replicationState;
    /** @export { !boolean } */
    this.isLoading;
    /** @export { !mojoBase.mojom.UnguessableToken } */
    this.devtoolsFrameToken;
    /** @export { (mojoBase.mojom.UnguessableToken|undefined) } */
    this.navigationMetricsToken;
    /** @export { !blink.mojom.RemoteFrameInterfacesFromBrowser } */
    this.remoteFrameInterfaces;
    /** @export { !blink.mojom.RemoteMainFrameInterfaces } */
    this.remoteMainFrameInterfaces;
  }
};



mojo.internal.Struct(
    blink.mojom.PageBroadcast_UpdatePageBrowsingContextGroup_ParamsSpec.$,
    'PageBroadcast_UpdatePageBrowsingContextGroup_Params',
    [
      mojo.internal.StructField(
        'browsingContextGroupToken', 0,
        0,
        mojoBase.mojom.UnguessableTokenSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.PageBroadcast_UpdatePageBrowsingContextGroup_Params = class {
  constructor() {
    /** @export { !mojoBase.mojom.UnguessableToken } */
    this.browsingContextGroupToken;
  }
};



mojo.internal.Struct(
    blink.mojom.PageBroadcast_SetPageAttributionSupport_ParamsSpec.$,
    'PageBroadcast_SetPageAttributionSupport_Params',
    [
      mojo.internal.StructField(
        'support', 0,
        0,
        network.mojom.AttributionSupportSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.PageBroadcast_SetPageAttributionSupport_Params = class {
  constructor() {
    /** @export { !network.mojom.AttributionSupport } */
    this.support;
  }
};



mojo.internal.Struct(
    blink.mojom.PageBroadcast_UpdateColorProviders_ParamsSpec.$,
    'PageBroadcast_UpdateColorProviders_Params',
    [
      mojo.internal.StructField(
        'colorProviderColors', 0,
        0,
        blink.mojom.ColorProviderColorMapsSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.PageBroadcast_UpdateColorProviders_Params = class {
  constructor() {
    /** @export { !blink.mojom.ColorProviderColorMaps } */
    this.colorProviderColors;
  }
};



mojo.internal.Struct(
    blink.mojom.PageBroadcast_SetSupportsDraggableRegions_ParamsSpec.$,
    'PageBroadcast_SetSupportsDraggableRegions_Params',
    [
      mojo.internal.StructField(
        'supportsDraggableRegions', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.PageBroadcast_SetSupportsDraggableRegions_Params = class {
  constructor() {
    /** @export { !boolean } */
    this.supportsDraggableRegions;
  }
};

