// third_party/blink/public/mojom/page/page.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/page/page.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/page/page.mojom-params-data.h"
#include "third_party/blink/public/mojom/page/page.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/page/page.mojom-blink-import-headers.h"
#include "third_party/blink/public/mojom/page/page.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"
#include "third_party/blink/public/common/frame/view_transition_state_mojom_traits.h"


namespace blink::mojom::blink {
PageLifecycleState::PageLifecycleState()
    : is_frozen(),
      visibility(),
      is_in_back_forward_cache(),
      pagehide_dispatch(),
      eviction_enabled() {}

PageLifecycleState::PageLifecycleState(
    bool is_frozen_in,
    ::blink::mojom::blink::PageVisibilityState visibility_in,
    bool is_in_back_forward_cache_in,
    PagehideDispatch pagehide_dispatch_in,
    bool eviction_enabled_in)
    : is_frozen(std::move(is_frozen_in)),
      visibility(std::move(visibility_in)),
      is_in_back_forward_cache(std::move(is_in_back_forward_cache_in)),
      pagehide_dispatch(std::move(pagehide_dispatch_in)),
      eviction_enabled(std::move(eviction_enabled_in)) {}

PageLifecycleState::~PageLifecycleState() = default;
size_t PageLifecycleState::Hash(size_t seed) const {
  seed = mojo::internal::WTFHash(seed, this->is_frozen);
  seed = mojo::internal::WTFHash(seed, this->visibility);
  seed = mojo::internal::WTFHash(seed, this->is_in_back_forward_cache);
  seed = mojo::internal::WTFHash(seed, this->pagehide_dispatch);
  seed = mojo::internal::WTFHash(seed, this->eviction_enabled);
  return seed;
}

void PageLifecycleState::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_frozen"), this->is_frozen,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "visibility"), this->visibility,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::mojom::blink::PageVisibilityState>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_in_back_forward_cache"), this->is_in_back_forward_cache,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "pagehide_dispatch"), this->pagehide_dispatch,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type PagehideDispatch>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "eviction_enabled"), this->eviction_enabled,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool PageLifecycleState::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
PageRestoreParams::PageRestoreParams()
    : navigation_start(),
      pending_history_list_index(),
      current_history_list_length(),
      view_transition_state() {}

PageRestoreParams::PageRestoreParams(
    ::base::TimeTicks navigation_start_in,
    int32_t pending_history_list_index_in,
    int32_t current_history_list_length_in,
    const std::optional<::blink::ViewTransitionState>& view_transition_state_in)
    : navigation_start(std::move(navigation_start_in)),
      pending_history_list_index(std::move(pending_history_list_index_in)),
      current_history_list_length(std::move(current_history_list_length_in)),
      view_transition_state(std::move(view_transition_state_in)) {}

PageRestoreParams::~PageRestoreParams() = default;

void PageRestoreParams::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "navigation_start"), this->navigation_start,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::TimeTicks>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "pending_history_list_index"), this->pending_history_list_index,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "current_history_list_length"), this->current_history_list_length,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "view_transition_state"), this->view_transition_state,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::blink::ViewTransitionState>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool PageRestoreParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ColorProviderColorMaps::ColorProviderColorMaps()
    : light_colors_map(),
      dark_colors_map(),
      forced_colors_map() {}

ColorProviderColorMaps::ColorProviderColorMaps(
    const ::blink::HashMap<::color::mojom::blink::RendererColorId, ::SkColor>& light_colors_map_in,
    const ::blink::HashMap<::color::mojom::blink::RendererColorId, ::SkColor>& dark_colors_map_in,
    const ::blink::HashMap<::color::mojom::blink::RendererColorId, ::SkColor>& forced_colors_map_in)
    : light_colors_map(std::move(light_colors_map_in)),
      dark_colors_map(std::move(dark_colors_map_in)),
      forced_colors_map(std::move(forced_colors_map_in)) {}

ColorProviderColorMaps::~ColorProviderColorMaps() = default;

void ColorProviderColorMaps::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "light_colors_map"), this->light_colors_map,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::HashMap<::color::mojom::blink::RendererColorId, ::SkColor>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "dark_colors_map"), this->dark_colors_map,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::HashMap<::color::mojom::blink::RendererColorId, ::SkColor>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "forced_colors_map"), this->forced_colors_map,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::HashMap<::color::mojom::blink::RendererColorId, ::SkColor>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ColorProviderColorMaps::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
PrerenderPageActivationParams::PrerenderPageActivationParams()
    : was_user_activated(),
      activation_start(),
      view_transition_state() {}

PrerenderPageActivationParams::PrerenderPageActivationParams(
    ::blink::mojom::blink::WasActivatedOption was_user_activated_in,
    std::optional<::base::TimeTicks> activation_start_in,
    const std::optional<::blink::ViewTransitionState>& view_transition_state_in)
    : was_user_activated(std::move(was_user_activated_in)),
      activation_start(std::move(activation_start_in)),
      view_transition_state(std::move(view_transition_state_in)) {}

PrerenderPageActivationParams::~PrerenderPageActivationParams() = default;

void PrerenderPageActivationParams::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "was_user_activated"), this->was_user_activated,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::mojom::blink::WasActivatedOption>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "activation_start"), this->activation_start,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<::base::TimeTicks>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "view_transition_state"), this->view_transition_state,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::blink::ViewTransitionState>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool PrerenderPageActivationParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

PageBroadcast::IPCStableHashFunction PageBroadcast::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::PageBroadcast>(message.name())) {
    case messages::PageBroadcast::kSetPageLifecycleState: {
      return &PageBroadcast::SetPageLifecycleState_Sym::IPCStableHash;
    }
    case messages::PageBroadcast::kAudioStateChanged: {
      return &PageBroadcast::AudioStateChanged_Sym::IPCStableHash;
    }
    case messages::PageBroadcast::kActivatePrerenderedPage: {
      return &PageBroadcast::ActivatePrerenderedPage_Sym::IPCStableHash;
    }
    case messages::PageBroadcast::kUpdateWebPreferences: {
      return &PageBroadcast::UpdateWebPreferences_Sym::IPCStableHash;
    }
    case messages::PageBroadcast::kUpdateRendererPreferences: {
      return &PageBroadcast::UpdateRendererPreferences_Sym::IPCStableHash;
    }
    case messages::PageBroadcast::kSetHistoryIndexAndLength: {
      return &PageBroadcast::SetHistoryIndexAndLength_Sym::IPCStableHash;
    }
    case messages::PageBroadcast::kSetPageBaseBackgroundColor: {
      return &PageBroadcast::SetPageBaseBackgroundColor_Sym::IPCStableHash;
    }
    case messages::PageBroadcast::kCreateRemoteMainFrame: {
      return &PageBroadcast::CreateRemoteMainFrame_Sym::IPCStableHash;
    }
    case messages::PageBroadcast::kUpdatePageBrowsingContextGroup: {
      return &PageBroadcast::UpdatePageBrowsingContextGroup_Sym::IPCStableHash;
    }
    case messages::PageBroadcast::kSetPageAttributionSupport: {
      return &PageBroadcast::SetPageAttributionSupport_Sym::IPCStableHash;
    }
    case messages::PageBroadcast::kUpdateColorProviders: {
      return &PageBroadcast::UpdateColorProviders_Sym::IPCStableHash;
    }
    case messages::PageBroadcast::kSetSupportsDraggableRegions: {
      return &PageBroadcast::SetSupportsDraggableRegions_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* PageBroadcast::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::PageBroadcast>(message.name())) {
      case messages::PageBroadcast::kSetPageLifecycleState:
            return "Receive blink::mojom::PageBroadcast::SetPageLifecycleState";
      case messages::PageBroadcast::kAudioStateChanged:
            return "Receive blink::mojom::PageBroadcast::AudioStateChanged";
      case messages::PageBroadcast::kActivatePrerenderedPage:
            return "Receive blink::mojom::PageBroadcast::ActivatePrerenderedPage";
      case messages::PageBroadcast::kUpdateWebPreferences:
            return "Receive blink::mojom::PageBroadcast::UpdateWebPreferences";
      case messages::PageBroadcast::kUpdateRendererPreferences:
            return "Receive blink::mojom::PageBroadcast::UpdateRendererPreferences";
      case messages::PageBroadcast::kSetHistoryIndexAndLength:
            return "Receive blink::mojom::PageBroadcast::SetHistoryIndexAndLength";
      case messages::PageBroadcast::kSetPageBaseBackgroundColor:
            return "Receive blink::mojom::PageBroadcast::SetPageBaseBackgroundColor";
      case messages::PageBroadcast::kCreateRemoteMainFrame:
            return "Receive blink::mojom::PageBroadcast::CreateRemoteMainFrame";
      case messages::PageBroadcast::kUpdatePageBrowsingContextGroup:
            return "Receive blink::mojom::PageBroadcast::UpdatePageBrowsingContextGroup";
      case messages::PageBroadcast::kSetPageAttributionSupport:
            return "Receive blink::mojom::PageBroadcast::SetPageAttributionSupport";
      case messages::PageBroadcast::kUpdateColorProviders:
            return "Receive blink::mojom::PageBroadcast::UpdateColorProviders";
      case messages::PageBroadcast::kSetSupportsDraggableRegions:
            return "Receive blink::mojom::PageBroadcast::SetSupportsDraggableRegions";
    }
  } else {
    switch (static_cast<messages::PageBroadcast>(message.name())) {
      case messages::PageBroadcast::kSetPageLifecycleState:
            return "Receive reply blink::mojom::PageBroadcast::SetPageLifecycleState";
      case messages::PageBroadcast::kAudioStateChanged:
            return "Receive reply blink::mojom::PageBroadcast::AudioStateChanged";
      case messages::PageBroadcast::kActivatePrerenderedPage:
            return "Receive reply blink::mojom::PageBroadcast::ActivatePrerenderedPage";
      case messages::PageBroadcast::kUpdateWebPreferences:
            return "Receive reply blink::mojom::PageBroadcast::UpdateWebPreferences";
      case messages::PageBroadcast::kUpdateRendererPreferences:
            return "Receive reply blink::mojom::PageBroadcast::UpdateRendererPreferences";
      case messages::PageBroadcast::kSetHistoryIndexAndLength:
            return "Receive reply blink::mojom::PageBroadcast::SetHistoryIndexAndLength";
      case messages::PageBroadcast::kSetPageBaseBackgroundColor:
            return "Receive reply blink::mojom::PageBroadcast::SetPageBaseBackgroundColor";
      case messages::PageBroadcast::kCreateRemoteMainFrame:
            return "Receive reply blink::mojom::PageBroadcast::CreateRemoteMainFrame";
      case messages::PageBroadcast::kUpdatePageBrowsingContextGroup:
            return "Receive reply blink::mojom::PageBroadcast::UpdatePageBrowsingContextGroup";
      case messages::PageBroadcast::kSetPageAttributionSupport:
            return "Receive reply blink::mojom::PageBroadcast::SetPageAttributionSupport";
      case messages::PageBroadcast::kUpdateColorProviders:
            return "Receive reply blink::mojom::PageBroadcast::UpdateColorProviders";
      case messages::PageBroadcast::kSetSupportsDraggableRegions:
            return "Receive reply blink::mojom::PageBroadcast::SetSupportsDraggableRegions";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t PageBroadcast::SetPageLifecycleState_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x6aceae11;  // IPCStableHash for blink::mojom::PageBroadcast::SetPageLifecycleState
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageBroadcast::AudioStateChanged_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x26ff49ba;  // IPCStableHash for blink::mojom::PageBroadcast::AudioStateChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageBroadcast::ActivatePrerenderedPage_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x8957cf9d;  // IPCStableHash for blink::mojom::PageBroadcast::ActivatePrerenderedPage
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageBroadcast::UpdateWebPreferences_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x9f0a9477;  // IPCStableHash for blink::mojom::PageBroadcast::UpdateWebPreferences
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageBroadcast::UpdateRendererPreferences_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xcee6f4ee;  // IPCStableHash for blink::mojom::PageBroadcast::UpdateRendererPreferences
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageBroadcast::SetHistoryIndexAndLength_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xd98e05b4;  // IPCStableHash for blink::mojom::PageBroadcast::SetHistoryIndexAndLength
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageBroadcast::SetPageBaseBackgroundColor_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xcecafdfd;  // IPCStableHash for blink::mojom::PageBroadcast::SetPageBaseBackgroundColor
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageBroadcast::CreateRemoteMainFrame_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xa8c7e1ec;  // IPCStableHash for blink::mojom::PageBroadcast::CreateRemoteMainFrame
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageBroadcast::UpdatePageBrowsingContextGroup_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x1b168feb;  // IPCStableHash for blink::mojom::PageBroadcast::UpdatePageBrowsingContextGroup
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageBroadcast::SetPageAttributionSupport_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xcd02a158;  // IPCStableHash for blink::mojom::PageBroadcast::SetPageAttributionSupport
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageBroadcast::UpdateColorProviders_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x6b1805d2;  // IPCStableHash for blink::mojom::PageBroadcast::UpdateColorProviders
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageBroadcast::SetSupportsDraggableRegions_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x3acc86c7;  // IPCStableHash for blink::mojom::PageBroadcast::SetSupportsDraggableRegions
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class PageBroadcast_SetPageLifecycleState_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PageBroadcast_SetPageLifecycleState_ForwardToCallback(
      PageBroadcast::SetPageLifecycleStateCallback callback
      ) : callback_(std::move(callback)) {
  }

  PageBroadcast_SetPageLifecycleState_ForwardToCallback(const PageBroadcast_SetPageLifecycleState_ForwardToCallback&) = delete;
  PageBroadcast_SetPageLifecycleState_ForwardToCallback& operator=(const PageBroadcast_SetPageLifecycleState_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PageBroadcast::SetPageLifecycleStateCallback callback_;
};

class PageBroadcast_ActivatePrerenderedPage_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PageBroadcast_ActivatePrerenderedPage_ForwardToCallback(
      PageBroadcast::ActivatePrerenderedPageCallback callback
      ) : callback_(std::move(callback)) {
  }

  PageBroadcast_ActivatePrerenderedPage_ForwardToCallback(const PageBroadcast_ActivatePrerenderedPage_ForwardToCallback&) = delete;
  PageBroadcast_ActivatePrerenderedPage_ForwardToCallback& operator=(const PageBroadcast_ActivatePrerenderedPage_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PageBroadcast::ActivatePrerenderedPageCallback callback_;
};

PageBroadcastProxy::PageBroadcastProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PageBroadcastProxy::SetPageLifecycleState(
    PageLifecycleStatePtr in_state, PageRestoreParamsPtr in_page_restore_params, SetPageLifecycleStateCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::PageBroadcast::SetPageLifecycleState", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("state"), in_state,
                        "<value of type PageLifecycleStatePtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("page_restore_params"), in_page_restore_params,
                        "<value of type PageRestoreParamsPtr>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageBroadcast::kSetPageLifecycleState), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::PageBroadcast_SetPageLifecycleState_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->state)::BaseType> state_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::PageLifecycleStateDataView>(
    in_state,
    state_fragment);

  params->state.Set(
      state_fragment.is_null() ? nullptr : state_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->state.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null state in PageBroadcast.SetPageLifecycleState request");
  mojo::internal::MessageFragment<
      typename decltype(params->page_restore_params)::BaseType> page_restore_params_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::PageRestoreParamsDataView>(
    in_page_restore_params,
    page_restore_params_fragment);

  params->page_restore_params.Set(
      page_restore_params_fragment.is_null() ? nullptr : page_restore_params_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageBroadcast::Name_);
  message.set_method_name("SetPageLifecycleState");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PageBroadcast_SetPageLifecycleState_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void PageBroadcastProxy::AudioStateChanged(
    bool in_is_audio_playing) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::PageBroadcast::AudioStateChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_audio_playing"), in_is_audio_playing,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageBroadcast::kAudioStateChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::PageBroadcast_AudioStateChanged_Params_Data> params(
          message);
  params.Allocate();

  params->is_audio_playing = in_is_audio_playing;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageBroadcast::Name_);
  message.set_method_name("AudioStateChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageBroadcastProxy::ActivatePrerenderedPage(
    PrerenderPageActivationParamsPtr in_prerender_page_activation_params, ActivatePrerenderedPageCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::PageBroadcast::ActivatePrerenderedPage", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("prerender_page_activation_params"), in_prerender_page_activation_params,
                        "<value of type PrerenderPageActivationParamsPtr>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageBroadcast::kActivatePrerenderedPage), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::PageBroadcast_ActivatePrerenderedPage_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->prerender_page_activation_params)::BaseType> prerender_page_activation_params_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::PrerenderPageActivationParamsDataView>(
    in_prerender_page_activation_params,
    prerender_page_activation_params_fragment);

  params->prerender_page_activation_params.Set(
      prerender_page_activation_params_fragment.is_null() ? nullptr : prerender_page_activation_params_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->prerender_page_activation_params.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null prerender_page_activation_params in PageBroadcast.ActivatePrerenderedPage request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageBroadcast::Name_);
  message.set_method_name("ActivatePrerenderedPage");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PageBroadcast_ActivatePrerenderedPage_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void PageBroadcastProxy::UpdateWebPreferences(
    const ::blink::web_pref::WebPreferences& in_preferences) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::PageBroadcast::UpdateWebPreferences", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("preferences"), in_preferences,
                        "<value of type const ::blink::web_pref::WebPreferences&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageBroadcast::kUpdateWebPreferences), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::PageBroadcast_UpdateWebPreferences_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->preferences)::BaseType> preferences_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::WebPreferencesDataView>(
    in_preferences,
    preferences_fragment);

  params->preferences.Set(
      preferences_fragment.is_null() ? nullptr : preferences_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->preferences.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null preferences in PageBroadcast.UpdateWebPreferences request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageBroadcast::Name_);
  message.set_method_name("UpdateWebPreferences");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageBroadcastProxy::UpdateRendererPreferences(
    const ::blink::RendererPreferences& in_preferences) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::PageBroadcast::UpdateRendererPreferences", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("preferences"), in_preferences,
                        "<value of type const ::blink::RendererPreferences&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageBroadcast::kUpdateRendererPreferences), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::PageBroadcast_UpdateRendererPreferences_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->preferences)::BaseType> preferences_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::RendererPreferencesDataView>(
    in_preferences,
    preferences_fragment);

  params->preferences.Set(
      preferences_fragment.is_null() ? nullptr : preferences_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->preferences.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null preferences in PageBroadcast.UpdateRendererPreferences request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageBroadcast::Name_);
  message.set_method_name("UpdateRendererPreferences");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageBroadcastProxy::SetHistoryIndexAndLength(
    int32_t in_index, int32_t in_length) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::PageBroadcast::SetHistoryIndexAndLength", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("index"), in_index,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("length"), in_length,
                        "<value of type int32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageBroadcast::kSetHistoryIndexAndLength), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::PageBroadcast_SetHistoryIndexAndLength_Params_Data> params(
          message);
  params.Allocate();

  params->index = in_index;

  params->length = in_length;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageBroadcast::Name_);
  message.set_method_name("SetHistoryIndexAndLength");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageBroadcastProxy::SetPageBaseBackgroundColor(
    std::optional<::SkColor> in_color) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::PageBroadcast::SetPageBaseBackgroundColor", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("color"), in_color,
                        "<value of type std::optional<::SkColor>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageBroadcast::kSetPageBaseBackgroundColor), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::PageBroadcast_SetPageBaseBackgroundColor_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->color)::BaseType> color_fragment(
          params.message());
  
  mojo::internal::Serialize<::skia::mojom::SkColorDataView>(
    in_color,
    color_fragment);

  params->color.Set(
      color_fragment.is_null() ? nullptr : color_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageBroadcast::Name_);
  message.set_method_name("SetPageBaseBackgroundColor");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageBroadcastProxy::CreateRemoteMainFrame(
    const ::blink::RemoteFrameToken& in_token, const std::optional<::blink::FrameToken>& in_opener_frame_token, ::blink::mojom::blink::FrameReplicationStatePtr in_replication_state, bool in_is_loading, const ::base::UnguessableToken& in_devtools_frame_token, const std::optional<::base::UnguessableToken>& in_navigation_metrics_token, ::blink::mojom::blink::RemoteFrameInterfacesFromBrowserPtr in_remote_frame_interfaces, ::blink::mojom::blink::RemoteMainFrameInterfacesPtr in_remote_main_frame_interfaces) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::PageBroadcast::CreateRemoteMainFrame", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("token"), in_token,
                        "<value of type const ::blink::RemoteFrameToken&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("opener_frame_token"), in_opener_frame_token,
                        "<value of type const std::optional<::blink::FrameToken>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("replication_state"), in_replication_state,
                        "<value of type ::blink::mojom::blink::FrameReplicationStatePtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_loading"), in_is_loading,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("devtools_frame_token"), in_devtools_frame_token,
                        "<value of type const ::base::UnguessableToken&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("navigation_metrics_token"), in_navigation_metrics_token,
                        "<value of type const std::optional<::base::UnguessableToken>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("remote_frame_interfaces"), in_remote_frame_interfaces,
                        "<value of type ::blink::mojom::blink::RemoteFrameInterfacesFromBrowserPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("remote_main_frame_interfaces"), in_remote_main_frame_interfaces,
                        "<value of type ::blink::mojom::blink::RemoteMainFrameInterfacesPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageBroadcast::kCreateRemoteMainFrame), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::PageBroadcast_CreateRemoteMainFrame_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->token)::BaseType> token_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::RemoteFrameTokenDataView>(
    in_token,
    token_fragment);

  params->token.Set(
      token_fragment.is_null() ? nullptr : token_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->token.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null token in PageBroadcast.CreateRemoteMainFrame request");
  mojo::internal::MessageFragment<decltype(params->opener_frame_token)>
      opener_frame_token_fragment(params.message());
  opener_frame_token_fragment.Claim(&params->opener_frame_token);
  
  mojo::internal::Serialize<::blink::mojom::FrameTokenDataView>(
    in_opener_frame_token,
    opener_frame_token_fragment,
    true);
  mojo::internal::MessageFragment<
      typename decltype(params->replication_state)::BaseType> replication_state_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::FrameReplicationStateDataView>(
    in_replication_state,
    replication_state_fragment);

  params->replication_state.Set(
      replication_state_fragment.is_null() ? nullptr : replication_state_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->replication_state.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null replication_state in PageBroadcast.CreateRemoteMainFrame request");

  params->is_loading = in_is_loading;
  mojo::internal::MessageFragment<
      typename decltype(params->devtools_frame_token)::BaseType> devtools_frame_token_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
    in_devtools_frame_token,
    devtools_frame_token_fragment);

  params->devtools_frame_token.Set(
      devtools_frame_token_fragment.is_null() ? nullptr : devtools_frame_token_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->devtools_frame_token.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null devtools_frame_token in PageBroadcast.CreateRemoteMainFrame request");
  mojo::internal::MessageFragment<
      typename decltype(params->navigation_metrics_token)::BaseType> navigation_metrics_token_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
    in_navigation_metrics_token,
    navigation_metrics_token_fragment);

  params->navigation_metrics_token.Set(
      navigation_metrics_token_fragment.is_null() ? nullptr : navigation_metrics_token_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->remote_frame_interfaces)::BaseType> remote_frame_interfaces_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::RemoteFrameInterfacesFromBrowserDataView>(
    in_remote_frame_interfaces,
    remote_frame_interfaces_fragment);

  params->remote_frame_interfaces.Set(
      remote_frame_interfaces_fragment.is_null() ? nullptr : remote_frame_interfaces_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->remote_frame_interfaces.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null remote_frame_interfaces in PageBroadcast.CreateRemoteMainFrame request");
  mojo::internal::MessageFragment<
      typename decltype(params->remote_main_frame_interfaces)::BaseType> remote_main_frame_interfaces_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::RemoteMainFrameInterfacesDataView>(
    in_remote_main_frame_interfaces,
    remote_main_frame_interfaces_fragment);

  params->remote_main_frame_interfaces.Set(
      remote_main_frame_interfaces_fragment.is_null() ? nullptr : remote_main_frame_interfaces_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->remote_main_frame_interfaces.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null remote_main_frame_interfaces in PageBroadcast.CreateRemoteMainFrame request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageBroadcast::Name_);
  message.set_method_name("CreateRemoteMainFrame");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageBroadcastProxy::UpdatePageBrowsingContextGroup(
    const ::base::UnguessableToken& in_browsing_context_group_token) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::PageBroadcast::UpdatePageBrowsingContextGroup", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("browsing_context_group_token"), in_browsing_context_group_token,
                        "<value of type const ::base::UnguessableToken&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageBroadcast::kUpdatePageBrowsingContextGroup), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::PageBroadcast_UpdatePageBrowsingContextGroup_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->browsing_context_group_token)::BaseType> browsing_context_group_token_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
    in_browsing_context_group_token,
    browsing_context_group_token_fragment);

  params->browsing_context_group_token.Set(
      browsing_context_group_token_fragment.is_null() ? nullptr : browsing_context_group_token_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->browsing_context_group_token.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null browsing_context_group_token in PageBroadcast.UpdatePageBrowsingContextGroup request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageBroadcast::Name_);
  message.set_method_name("UpdatePageBrowsingContextGroup");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageBroadcastProxy::SetPageAttributionSupport(
    ::network::mojom::blink::AttributionSupport in_support) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::PageBroadcast::SetPageAttributionSupport", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("support"), in_support,
                        "<value of type ::network::mojom::blink::AttributionSupport>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageBroadcast::kSetPageAttributionSupport), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::PageBroadcast_SetPageAttributionSupport_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::network::mojom::AttributionSupport>(
    in_support,
    &params->support);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageBroadcast::Name_);
  message.set_method_name("SetPageAttributionSupport");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageBroadcastProxy::UpdateColorProviders(
    const ::blink::ColorProviderColorMaps& in_color_provider_colors) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::PageBroadcast::UpdateColorProviders", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("color_provider_colors"), in_color_provider_colors,
                        "<value of type const ::blink::ColorProviderColorMaps&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageBroadcast::kUpdateColorProviders), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::PageBroadcast_UpdateColorProviders_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->color_provider_colors)::BaseType> color_provider_colors_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::ColorProviderColorMapsDataView>(
    in_color_provider_colors,
    color_provider_colors_fragment);

  params->color_provider_colors.Set(
      color_provider_colors_fragment.is_null() ? nullptr : color_provider_colors_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->color_provider_colors.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null color_provider_colors in PageBroadcast.UpdateColorProviders request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageBroadcast::Name_);
  message.set_method_name("UpdateColorProviders");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageBroadcastProxy::SetSupportsDraggableRegions(
    bool in_supports_draggable_regions) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::PageBroadcast::SetSupportsDraggableRegions", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("supports_draggable_regions"), in_supports_draggable_regions,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageBroadcast::kSetSupportsDraggableRegions), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::PageBroadcast_SetSupportsDraggableRegions_Params_Data> params(
          message);
  params.Allocate();

  params->supports_draggable_regions = in_supports_draggable_regions;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageBroadcast::Name_);
  message.set_method_name("SetSupportsDraggableRegions");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
class PageBroadcast_SetPageLifecycleState_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PageBroadcast::SetPageLifecycleStateCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PageBroadcast_SetPageLifecycleState_ProxyToResponder> proxy(
        new PageBroadcast_SetPageLifecycleState_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PageBroadcast_SetPageLifecycleState_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PageBroadcast_SetPageLifecycleState_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PageBroadcast_SetPageLifecycleState_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "PageBroadcast::SetPageLifecycleStateCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool PageBroadcast_SetPageLifecycleState_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PageBroadcast_SetPageLifecycleState_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PageBroadcast_SetPageLifecycleState_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for PageBroadcast.0
  bool success = true;
  PageBroadcast_SetPageLifecycleState_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PageBroadcast::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run();
  }
  return true;
}

void PageBroadcast_SetPageLifecycleState_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply blink::mojom::PageBroadcast::SetPageLifecycleState");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageBroadcast::kSetPageLifecycleState), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::PageBroadcast_SetPageLifecycleState_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageBroadcast::Name_);
  message.set_method_name("SetPageLifecycleState");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class PageBroadcast_ActivatePrerenderedPage_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PageBroadcast::ActivatePrerenderedPageCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PageBroadcast_ActivatePrerenderedPage_ProxyToResponder> proxy(
        new PageBroadcast_ActivatePrerenderedPage_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PageBroadcast_ActivatePrerenderedPage_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PageBroadcast_ActivatePrerenderedPage_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PageBroadcast_ActivatePrerenderedPage_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "PageBroadcast::ActivatePrerenderedPageCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool PageBroadcast_ActivatePrerenderedPage_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PageBroadcast_ActivatePrerenderedPage_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PageBroadcast_ActivatePrerenderedPage_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for PageBroadcast.2
  bool success = true;
  PageBroadcast_ActivatePrerenderedPage_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PageBroadcast::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run();
  }
  return true;
}

void PageBroadcast_ActivatePrerenderedPage_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply blink::mojom::PageBroadcast::ActivatePrerenderedPage");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageBroadcast::kActivatePrerenderedPage), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::PageBroadcast_ActivatePrerenderedPage_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageBroadcast::Name_);
  message.set_method_name("ActivatePrerenderedPage");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool PageBroadcastStubDispatch::Accept(
    PageBroadcast* impl,
    mojo::Message* message) {
  switch (static_cast<messages::PageBroadcast>(message->header()->name)) {
    case messages::PageBroadcast::kSetPageLifecycleState: {
      break;
    }
    case messages::PageBroadcast::kAudioStateChanged: {
      DCHECK(message->is_serialized());
      internal::PageBroadcast_AudioStateChanged_Params_Data* params =
          reinterpret_cast<internal::PageBroadcast_AudioStateChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageBroadcast.1
      bool success = true;
      bool p_is_audio_playing{};
      PageBroadcast_AudioStateChanged_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_is_audio_playing = input_data_view.is_audio_playing();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageBroadcast::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AudioStateChanged(        
        std::move(p_is_audio_playing));
      return true;
    }
    case messages::PageBroadcast::kActivatePrerenderedPage: {
      break;
    }
    case messages::PageBroadcast::kUpdateWebPreferences: {
      DCHECK(message->is_serialized());
      internal::PageBroadcast_UpdateWebPreferences_Params_Data* params =
          reinterpret_cast<internal::PageBroadcast_UpdateWebPreferences_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageBroadcast.3
      bool success = true;
      ::blink::web_pref::WebPreferences p_preferences{};
      PageBroadcast_UpdateWebPreferences_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPreferences(&p_preferences))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageBroadcast::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateWebPreferences(        
        std::move(p_preferences));
      return true;
    }
    case messages::PageBroadcast::kUpdateRendererPreferences: {
      DCHECK(message->is_serialized());
      internal::PageBroadcast_UpdateRendererPreferences_Params_Data* params =
          reinterpret_cast<internal::PageBroadcast_UpdateRendererPreferences_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageBroadcast.4
      bool success = true;
      ::blink::RendererPreferences p_preferences{};
      PageBroadcast_UpdateRendererPreferences_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPreferences(&p_preferences))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageBroadcast::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateRendererPreferences(        
        std::move(p_preferences));
      return true;
    }
    case messages::PageBroadcast::kSetHistoryIndexAndLength: {
      DCHECK(message->is_serialized());
      internal::PageBroadcast_SetHistoryIndexAndLength_Params_Data* params =
          reinterpret_cast<internal::PageBroadcast_SetHistoryIndexAndLength_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageBroadcast.5
      bool success = true;
      int32_t p_index{};
      int32_t p_length{};
      PageBroadcast_SetHistoryIndexAndLength_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_index = input_data_view.index();
      if (success)
        p_length = input_data_view.length();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageBroadcast::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetHistoryIndexAndLength(        
        std::move(p_index), 
        std::move(p_length));
      return true;
    }
    case messages::PageBroadcast::kSetPageBaseBackgroundColor: {
      DCHECK(message->is_serialized());
      internal::PageBroadcast_SetPageBaseBackgroundColor_Params_Data* params =
          reinterpret_cast<internal::PageBroadcast_SetPageBaseBackgroundColor_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageBroadcast.6
      bool success = true;
      std::optional<::SkColor> p_color{};
      PageBroadcast_SetPageBaseBackgroundColor_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadColor(&p_color))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageBroadcast::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetPageBaseBackgroundColor(        
        std::move(p_color));
      return true;
    }
    case messages::PageBroadcast::kCreateRemoteMainFrame: {
      DCHECK(message->is_serialized());
      internal::PageBroadcast_CreateRemoteMainFrame_Params_Data* params =
          reinterpret_cast<internal::PageBroadcast_CreateRemoteMainFrame_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageBroadcast.7
      bool success = true;
      ::blink::RemoteFrameToken p_token{};
      std::optional<::blink::FrameToken> p_opener_frame_token{};
      ::blink::mojom::blink::FrameReplicationStatePtr p_replication_state{};
      bool p_is_loading{};
      ::base::UnguessableToken p_devtools_frame_token{};
      std::optional<::base::UnguessableToken> p_navigation_metrics_token{};
      ::blink::mojom::blink::RemoteFrameInterfacesFromBrowserPtr p_remote_frame_interfaces{};
      ::blink::mojom::blink::RemoteMainFrameInterfacesPtr p_remote_main_frame_interfaces{};
      PageBroadcast_CreateRemoteMainFrame_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadToken(&p_token))
        success = false;
      if (success && !input_data_view.ReadOpenerFrameToken(&p_opener_frame_token))
        success = false;
      if (success && !input_data_view.ReadReplicationState(&p_replication_state))
        success = false;
      if (success)
        p_is_loading = input_data_view.is_loading();
      if (success && !input_data_view.ReadDevtoolsFrameToken(&p_devtools_frame_token))
        success = false;
      if (success && !input_data_view.ReadNavigationMetricsToken(&p_navigation_metrics_token))
        success = false;
      if (success && !input_data_view.ReadRemoteFrameInterfaces(&p_remote_frame_interfaces))
        success = false;
      if (success && !input_data_view.ReadRemoteMainFrameInterfaces(&p_remote_main_frame_interfaces))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageBroadcast::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateRemoteMainFrame(        
        std::move(p_token), 
        std::move(p_opener_frame_token), 
        std::move(p_replication_state), 
        std::move(p_is_loading), 
        std::move(p_devtools_frame_token), 
        std::move(p_navigation_metrics_token), 
        std::move(p_remote_frame_interfaces), 
        std::move(p_remote_main_frame_interfaces));
      return true;
    }
    case messages::PageBroadcast::kUpdatePageBrowsingContextGroup: {
      DCHECK(message->is_serialized());
      internal::PageBroadcast_UpdatePageBrowsingContextGroup_Params_Data* params =
          reinterpret_cast<internal::PageBroadcast_UpdatePageBrowsingContextGroup_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageBroadcast.8
      bool success = true;
      ::base::UnguessableToken p_browsing_context_group_token{};
      PageBroadcast_UpdatePageBrowsingContextGroup_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadBrowsingContextGroupToken(&p_browsing_context_group_token))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageBroadcast::Name_, 8, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdatePageBrowsingContextGroup(        
        std::move(p_browsing_context_group_token));
      return true;
    }
    case messages::PageBroadcast::kSetPageAttributionSupport: {
      DCHECK(message->is_serialized());
      internal::PageBroadcast_SetPageAttributionSupport_Params_Data* params =
          reinterpret_cast<internal::PageBroadcast_SetPageAttributionSupport_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageBroadcast.9
      bool success = true;
      ::network::mojom::blink::AttributionSupport p_support{};
      PageBroadcast_SetPageAttributionSupport_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSupport(&p_support))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageBroadcast::Name_, 9, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetPageAttributionSupport(        
        std::move(p_support));
      return true;
    }
    case messages::PageBroadcast::kUpdateColorProviders: {
      DCHECK(message->is_serialized());
      internal::PageBroadcast_UpdateColorProviders_Params_Data* params =
          reinterpret_cast<internal::PageBroadcast_UpdateColorProviders_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageBroadcast.10
      bool success = true;
      ::blink::ColorProviderColorMaps p_color_provider_colors{};
      PageBroadcast_UpdateColorProviders_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadColorProviderColors(&p_color_provider_colors))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageBroadcast::Name_, 10, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateColorProviders(        
        std::move(p_color_provider_colors));
      return true;
    }
    case messages::PageBroadcast::kSetSupportsDraggableRegions: {
      DCHECK(message->is_serialized());
      internal::PageBroadcast_SetSupportsDraggableRegions_Params_Data* params =
          reinterpret_cast<internal::PageBroadcast_SetSupportsDraggableRegions_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageBroadcast.11
      bool success = true;
      bool p_supports_draggable_regions{};
      PageBroadcast_SetSupportsDraggableRegions_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_supports_draggable_regions = input_data_view.supports_draggable_regions();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageBroadcast::Name_, 11, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetSupportsDraggableRegions(        
        std::move(p_supports_draggable_regions));
      return true;
    }
  }
  return false;
}

// static
bool PageBroadcastStubDispatch::AcceptWithResponder(
    PageBroadcast* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::PageBroadcast>(message->header()->name)) {
    case messages::PageBroadcast::kSetPageLifecycleState: {
      internal::PageBroadcast_SetPageLifecycleState_Params_Data* params =
          reinterpret_cast<
              internal::PageBroadcast_SetPageLifecycleState_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for PageBroadcast.0
      bool success = true;
      PageLifecycleStatePtr p_state{};
      PageRestoreParamsPtr p_page_restore_params{};
      PageBroadcast_SetPageLifecycleState_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadState(&p_state))
        success = false;
      if (success && !input_data_view.ReadPageRestoreParams(&p_page_restore_params))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageBroadcast::Name_, 0, false);
        return false;
      }
      auto callback =
          PageBroadcast_SetPageLifecycleState_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetPageLifecycleState(        
        std::move(p_state), 
        std::move(p_page_restore_params), std::move(callback));
      return true;
    }
    case messages::PageBroadcast::kAudioStateChanged: {
      break;
    }
    case messages::PageBroadcast::kActivatePrerenderedPage: {
      internal::PageBroadcast_ActivatePrerenderedPage_Params_Data* params =
          reinterpret_cast<
              internal::PageBroadcast_ActivatePrerenderedPage_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for PageBroadcast.2
      bool success = true;
      PrerenderPageActivationParamsPtr p_prerender_page_activation_params{};
      PageBroadcast_ActivatePrerenderedPage_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPrerenderPageActivationParams(&p_prerender_page_activation_params))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageBroadcast::Name_, 2, false);
        return false;
      }
      auto callback =
          PageBroadcast_ActivatePrerenderedPage_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ActivatePrerenderedPage(        
        std::move(p_prerender_page_activation_params), std::move(callback));
      return true;
    }
    case messages::PageBroadcast::kUpdateWebPreferences: {
      break;
    }
    case messages::PageBroadcast::kUpdateRendererPreferences: {
      break;
    }
    case messages::PageBroadcast::kSetHistoryIndexAndLength: {
      break;
    }
    case messages::PageBroadcast::kSetPageBaseBackgroundColor: {
      break;
    }
    case messages::PageBroadcast::kCreateRemoteMainFrame: {
      break;
    }
    case messages::PageBroadcast::kUpdatePageBrowsingContextGroup: {
      break;
    }
    case messages::PageBroadcast::kSetPageAttributionSupport: {
      break;
    }
    case messages::PageBroadcast::kUpdateColorProviders: {
      break;
    }
    case messages::PageBroadcast::kSetSupportsDraggableRegions: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kPageBroadcastValidationInfo[] = {
    { &internal::PageBroadcast_SetPageLifecycleState_Params_Data::Validate,
     &internal::PageBroadcast_SetPageLifecycleState_ResponseParams_Data::Validate},
    { &internal::PageBroadcast_AudioStateChanged_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageBroadcast_ActivatePrerenderedPage_Params_Data::Validate,
     &internal::PageBroadcast_ActivatePrerenderedPage_ResponseParams_Data::Validate},
    { &internal::PageBroadcast_UpdateWebPreferences_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageBroadcast_UpdateRendererPreferences_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageBroadcast_SetHistoryIndexAndLength_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageBroadcast_SetPageBaseBackgroundColor_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageBroadcast_CreateRemoteMainFrame_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageBroadcast_UpdatePageBrowsingContextGroup_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageBroadcast_SetPageAttributionSupport_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageBroadcast_UpdateColorProviders_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageBroadcast_SetSupportsDraggableRegions_Params_Data::Validate,
     nullptr /* no response */},
};

bool PageBroadcastRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::blink::PageBroadcast::Name_,
    kPageBroadcastValidationInfo);
}

bool PageBroadcastResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::blink::mojom::blink::PageBroadcast::Name_,
    kPageBroadcastValidationInfo);
}


}  // blink::mojom::blink


namespace mojo {


// static
bool StructTraits<::blink::mojom::blink::PageLifecycleState::DataView, ::blink::mojom::blink::PageLifecycleStatePtr>::Read(
    ::blink::mojom::blink::PageLifecycleState::DataView input,
    ::blink::mojom::blink::PageLifecycleStatePtr* output) {
  bool success = true;
  ::blink::mojom::blink::PageLifecycleStatePtr result(::blink::mojom::blink::PageLifecycleState::New());
  
      if (success)
        result->is_frozen = input.is_frozen();
      if (success && !input.ReadVisibility(&result->visibility))
        success = false;
      if (success)
        result->is_in_back_forward_cache = input.is_in_back_forward_cache();
      if (success && !input.ReadPagehideDispatch(&result->pagehide_dispatch))
        success = false;
      if (success)
        result->eviction_enabled = input.eviction_enabled();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::PageRestoreParams::DataView, ::blink::mojom::blink::PageRestoreParamsPtr>::Read(
    ::blink::mojom::blink::PageRestoreParams::DataView input,
    ::blink::mojom::blink::PageRestoreParamsPtr* output) {
  bool success = true;
  ::blink::mojom::blink::PageRestoreParamsPtr result(::blink::mojom::blink::PageRestoreParams::New());
  
      if (success && !input.ReadNavigationStart(&result->navigation_start))
        success = false;
      if (success)
        result->pending_history_list_index = input.pending_history_list_index();
      if (success)
        result->current_history_list_length = input.current_history_list_length();
      if (success && !input.ReadViewTransitionState(&result->view_transition_state))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::ColorProviderColorMaps::DataView, ::blink::mojom::blink::ColorProviderColorMapsPtr>::Read(
    ::blink::mojom::blink::ColorProviderColorMaps::DataView input,
    ::blink::mojom::blink::ColorProviderColorMapsPtr* output) {
  bool success = true;
  ::blink::mojom::blink::ColorProviderColorMapsPtr result(::blink::mojom::blink::ColorProviderColorMaps::New());
  
      if (success && !input.ReadLightColorsMap(&result->light_colors_map))
        success = false;
      if (success && !input.ReadDarkColorsMap(&result->dark_colors_map))
        success = false;
      if (success && !input.ReadForcedColorsMap(&result->forced_colors_map))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::PrerenderPageActivationParams::DataView, ::blink::mojom::blink::PrerenderPageActivationParamsPtr>::Read(
    ::blink::mojom::blink::PrerenderPageActivationParams::DataView input,
    ::blink::mojom::blink::PrerenderPageActivationParamsPtr* output) {
  bool success = true;
  ::blink::mojom::blink::PrerenderPageActivationParamsPtr result(::blink::mojom::blink::PrerenderPageActivationParams::New());
  
      if (success && !input.ReadWasUserActivated(&result->was_user_activated))
        success = false;
      if (success && !input.ReadActivationStart(&result->activation_start))
        success = false;
      if (success && !input.ReadViewTransitionState(&result->view_transition_state))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace blink::mojom::blink {


void PageBroadcastInterceptorForTesting::SetPageLifecycleState(PageLifecycleStatePtr state, PageRestoreParamsPtr page_restore_params, SetPageLifecycleStateCallback callback) {
  GetForwardingInterface()->SetPageLifecycleState(
    std::move(state)
    , 
    std::move(page_restore_params)
    , std::move(callback));
}
void PageBroadcastInterceptorForTesting::AudioStateChanged(bool is_audio_playing) {
  GetForwardingInterface()->AudioStateChanged(
    std::move(is_audio_playing)
    );
}
void PageBroadcastInterceptorForTesting::ActivatePrerenderedPage(PrerenderPageActivationParamsPtr prerender_page_activation_params, ActivatePrerenderedPageCallback callback) {
  GetForwardingInterface()->ActivatePrerenderedPage(
    std::move(prerender_page_activation_params)
    , std::move(callback));
}
void PageBroadcastInterceptorForTesting::UpdateWebPreferences(const ::blink::web_pref::WebPreferences& preferences) {
  GetForwardingInterface()->UpdateWebPreferences(
    std::move(preferences)
    );
}
void PageBroadcastInterceptorForTesting::UpdateRendererPreferences(const ::blink::RendererPreferences& preferences) {
  GetForwardingInterface()->UpdateRendererPreferences(
    std::move(preferences)
    );
}
void PageBroadcastInterceptorForTesting::SetHistoryIndexAndLength(int32_t index, int32_t length) {
  GetForwardingInterface()->SetHistoryIndexAndLength(
    std::move(index)
    , 
    std::move(length)
    );
}
void PageBroadcastInterceptorForTesting::SetPageBaseBackgroundColor(std::optional<::SkColor> color) {
  GetForwardingInterface()->SetPageBaseBackgroundColor(
    std::move(color)
    );
}
void PageBroadcastInterceptorForTesting::CreateRemoteMainFrame(const ::blink::RemoteFrameToken& token, const std::optional<::blink::FrameToken>& opener_frame_token, ::blink::mojom::blink::FrameReplicationStatePtr replication_state, bool is_loading, const ::base::UnguessableToken& devtools_frame_token, const std::optional<::base::UnguessableToken>& navigation_metrics_token, ::blink::mojom::blink::RemoteFrameInterfacesFromBrowserPtr remote_frame_interfaces, ::blink::mojom::blink::RemoteMainFrameInterfacesPtr remote_main_frame_interfaces) {
  GetForwardingInterface()->CreateRemoteMainFrame(
    std::move(token)
    , 
    std::move(opener_frame_token)
    , 
    std::move(replication_state)
    , 
    std::move(is_loading)
    , 
    std::move(devtools_frame_token)
    , 
    std::move(navigation_metrics_token)
    , 
    std::move(remote_frame_interfaces)
    , 
    std::move(remote_main_frame_interfaces)
    );
}
void PageBroadcastInterceptorForTesting::UpdatePageBrowsingContextGroup(const ::base::UnguessableToken& browsing_context_group_token) {
  GetForwardingInterface()->UpdatePageBrowsingContextGroup(
    std::move(browsing_context_group_token)
    );
}
void PageBroadcastInterceptorForTesting::SetPageAttributionSupport(::network::mojom::blink::AttributionSupport support) {
  GetForwardingInterface()->SetPageAttributionSupport(
    std::move(support)
    );
}
void PageBroadcastInterceptorForTesting::UpdateColorProviders(const ::blink::ColorProviderColorMaps& color_provider_colors) {
  GetForwardingInterface()->UpdateColorProviders(
    std::move(color_provider_colors)
    );
}
void PageBroadcastInterceptorForTesting::SetSupportsDraggableRegions(bool supports_draggable_regions) {
  GetForwardingInterface()->SetSupportsDraggableRegions(
    std::move(supports_draggable_regions)
    );
}
PageBroadcastAsyncWaiter::PageBroadcastAsyncWaiter(
    PageBroadcast* proxy) : proxy_(proxy) {}

PageBroadcastAsyncWaiter::~PageBroadcastAsyncWaiter() = default;


void PageBroadcastAsyncWaiter::SetPageLifecycleState(
    PageLifecycleStatePtr state, PageRestoreParamsPtr page_restore_params) {
  base::RunLoop loop;
  proxy_->SetPageLifecycleState(
      std::move(state),
      std::move(page_restore_params),
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}



void PageBroadcastAsyncWaiter::ActivatePrerenderedPage(
    PrerenderPageActivationParamsPtr prerender_page_activation_params) {
  base::RunLoop loop;
  proxy_->ActivatePrerenderedPage(
      std::move(prerender_page_activation_params),
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}








}  // blink::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif