// third_party/blink/public/mojom/origin_trials/origin_trials_settings.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_ORIGIN_TRIALS_ORIGIN_TRIALS_SETTINGS_MOJOM_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_ORIGIN_TRIALS_ORIGIN_TRIALS_SETTINGS_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/origin_trials/origin_trials_settings.mojom-features.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/origin_trials/origin_trials_settings.mojom-shared.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/origin_trials/origin_trials_settings.mojom-forward.h"  // IWYU pragma: export
#include <string>
#include <vector>




#include "third_party/blink/public/common/common_export.h"




namespace blink::mojom {








class BLINK_COMMON_EXPORT OriginTrialsSettings {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<OriginTrialsSettings, T>::value>;
  using DataView = OriginTrialsSettingsDataView;
  using Data_ = internal::OriginTrialsSettings_Data;

  template <typename... Args>
  static OriginTrialsSettingsPtr New(Args&&... args) {
    return OriginTrialsSettingsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static OriginTrialsSettingsPtr From(const U& u) {
    return mojo::TypeConverter<OriginTrialsSettingsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, OriginTrialsSettings>::Convert(*this);
  }


  OriginTrialsSettings();

  explicit OriginTrialsSettings(
      std::vector<std::string> disabled_tokens);


  ~OriginTrialsSettings();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = OriginTrialsSettingsPtr>
  OriginTrialsSettingsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, OriginTrialsSettings::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, OriginTrialsSettings::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, OriginTrialsSettings::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        OriginTrialsSettings::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        OriginTrialsSettings::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        OriginTrialsSettings::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::OriginTrialsSettings_UnserializedMessageContext<
            UserType, OriginTrialsSettings::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<OriginTrialsSettings::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return OriginTrialsSettings::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::OriginTrialsSettings_UnserializedMessageContext<
            UserType, OriginTrialsSettings::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<OriginTrialsSettings::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::vector<std::string> disabled_tokens;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, OriginTrialsSettings::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, OriginTrialsSettings::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, OriginTrialsSettings::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, OriginTrialsSettings::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
OriginTrialsSettingsPtr OriginTrialsSettings::Clone() const {
  return New(
      mojo::Clone(disabled_tokens)
  );
}

template <typename T, OriginTrialsSettings::EnableIfSame<T>*>
bool OriginTrialsSettings::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->disabled_tokens, other_struct.disabled_tokens))
    return false;
  return true;
}

template <typename T, OriginTrialsSettings::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.disabled_tokens < rhs.disabled_tokens)
    return true;
  if (rhs.disabled_tokens < lhs.disabled_tokens)
    return false;
  return false;
}


}  // blink::mojom

namespace mojo {


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::OriginTrialsSettings::DataView,
                                         ::blink::mojom::OriginTrialsSettingsPtr> {
  static bool IsNull(const ::blink::mojom::OriginTrialsSettingsPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::OriginTrialsSettingsPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::OriginTrialsSettings::disabled_tokens)& disabled_tokens(
      const ::blink::mojom::OriginTrialsSettingsPtr& input) {
    return input->disabled_tokens;
  }

  static bool Read(::blink::mojom::OriginTrialsSettings::DataView input, ::blink::mojom::OriginTrialsSettingsPtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_ORIGIN_TRIALS_ORIGIN_TRIALS_SETTINGS_MOJOM_H_