// third_party/blink/public/mojom/on_device_translation/translation_manager.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../../mojo/public/js/bindings.js';

import {
  ModelDownloadProgressObserverRemote as blink_mojom_ModelDownloadProgressObserverRemote,
  ModelDownloadProgressObserverPendingReceiver as blink_mojom_ModelDownloadProgressObserverPendingReceiver
} from '../ai/model_download_progress_observer.mojom.m.js';

import {
  TranslatorRemote as blink_mojom_TranslatorRemote,
  TranslatorPendingReceiver as blink_mojom_TranslatorPendingReceiver
} from './translator.mojom.m.js';


/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const CanCreateTranslatorResultSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const CanCreateTranslatorResult = {
  
  kReadily: 0,
  kAfterDownloadLibraryNotReady: 1,
  kAfterDownloadLanguagePackNotReady: 2,
  kAfterDownloadLibraryAndLanguagePackNotReady: 3,
  kAfterDownloadTranslatorCreationRequired: 4,
  kNoNotSupportedLanguage: 5,
  kNoServiceCrashed: 6,
  kNoDisallowedByPolicy: 7,
  kNoExceedsServiceCountLimitation: 8,
  kNoInvalidStoragePartition: 9,
  MIN_VALUE: 0,
  MAX_VALUE: 9,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const CreateTranslatorErrorSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const CreateTranslatorError = {
  
  kInvalidBinary: 1,
  kInvalidFunctionPointer: 2,
  kFailedToInitialize: 3,
  kFailedToCreateTranslator: 4,
  kServiceCrashed: 5,
  kDisallowedByPolicy: 6,
  kExceedsServiceCountLimitation: 7,
  kExceedsPendingTaskCountLimitation: 8,
  kInvalidVersion: 9,
  kInvalidStoragePartition: 10,
  MIN_VALUE: 1,
  MAX_VALUE: 10,
};



/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class TranslationManagerCreateTranslatorClientPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.TranslationManagerCreateTranslatorClient', scope);
  }
}

/** @interface */
export class TranslationManagerCreateTranslatorClientInterface {
  
  /**
   * @param { !CreateTranslatorResult } result
   * @param { ?TranslatorLanguageCode } sourceLang
   * @param { ?TranslatorLanguageCode } targetLang
   */

  onResult(result, sourceLang, targetLang) {}
}

/**
 * @implements { TranslationManagerCreateTranslatorClientInterface }
 */
export class TranslationManagerCreateTranslatorClientRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!TranslationManagerCreateTranslatorClientPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          TranslationManagerCreateTranslatorClientPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!TranslationManagerCreateTranslatorClientPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !CreateTranslatorResult } result
   * @param { ?TranslatorLanguageCode } sourceLang
   * @param { ?TranslatorLanguageCode } targetLang
   */

  onResult(
      result,
      sourceLang,
      targetLang) {
    this.proxy.sendMessage(
        0,
        TranslationManagerCreateTranslatorClient_OnResult_ParamsSpec.$,
        null,
        [
          result,
          sourceLang,
          targetLang
        ],
        false);
  }
}

/**
 * An object which receives request messages for the TranslationManagerCreateTranslatorClient
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class TranslationManagerCreateTranslatorClientReceiver {
  /**
   * @param {!TranslationManagerCreateTranslatorClientInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!TranslationManagerCreateTranslatorClientRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        TranslationManagerCreateTranslatorClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!TranslationManagerCreateTranslatorClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        TranslationManagerCreateTranslatorClient_OnResult_ParamsSpec.$,
        null,
        impl.onResult.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class TranslationManagerCreateTranslatorClient {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.TranslationManagerCreateTranslatorClient";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!TranslationManagerCreateTranslatorClientRemote}
   */
  static getRemote() {
    let remote = new TranslationManagerCreateTranslatorClientRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the TranslationManagerCreateTranslatorClient
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class TranslationManagerCreateTranslatorClientCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      TranslationManagerCreateTranslatorClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!TranslationManagerCreateTranslatorClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onResult =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        TranslationManagerCreateTranslatorClient_OnResult_ParamsSpec.$,
        null,
        this.onResult.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class TranslationManagerPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.TranslationManager', scope);
  }
}

/** @interface */
export class TranslationManagerInterface {
  
  /**
   * @param { !TranslationManagerCreateTranslatorClientRemote } client
   * @param { !TranslatorCreateOptions } options
   * @param { !boolean } addFakeDownloadDelay
   */

  createTranslator(client, options, addFakeDownloadDelay) {}
  
  /**
   * @param { !TranslatorLanguageCode } sourceLang
   * @param { !TranslatorLanguageCode } targetLang
   * @return {!Promise<{
        result: !CanCreateTranslatorResult,
   *  }>}
   */

  translationAvailable(sourceLang, targetLang) {}
}

/**
 * @implements { TranslationManagerInterface }
 */
export class TranslationManagerRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!TranslationManagerPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          TranslationManagerPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!TranslationManagerPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !TranslationManagerCreateTranslatorClientRemote } client
   * @param { !TranslatorCreateOptions } options
   * @param { !boolean } addFakeDownloadDelay
   */

  createTranslator(
      client,
      options,
      addFakeDownloadDelay) {
    this.proxy.sendMessage(
        0,
        TranslationManager_CreateTranslator_ParamsSpec.$,
        null,
        [
          client,
          options,
          addFakeDownloadDelay
        ],
        false);
  }

  
  /**
   * @param { !TranslatorLanguageCode } sourceLang
   * @param { !TranslatorLanguageCode } targetLang
   * @return {!Promise<{
        result: !CanCreateTranslatorResult,
   *  }>}
   */

  translationAvailable(
      sourceLang,
      targetLang) {
    return this.proxy.sendMessage(
        1,
        TranslationManager_TranslationAvailable_ParamsSpec.$,
        TranslationManager_TranslationAvailable_ResponseParamsSpec.$,
        [
          sourceLang,
          targetLang
        ],
        false);
  }
}

/**
 * An object which receives request messages for the TranslationManager
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class TranslationManagerReceiver {
  /**
   * @param {!TranslationManagerInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!TranslationManagerRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        TranslationManagerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!TranslationManagerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        TranslationManager_CreateTranslator_ParamsSpec.$,
        null,
        impl.createTranslator.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        TranslationManager_TranslationAvailable_ParamsSpec.$,
        TranslationManager_TranslationAvailable_ResponseParamsSpec.$,
        impl.translationAvailable.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class TranslationManager {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.TranslationManager";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!TranslationManagerRemote}
   */
  static getRemote() {
    let remote = new TranslationManagerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the TranslationManager
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class TranslationManagerCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      TranslationManagerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!TranslationManagerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.createTranslator =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        TranslationManager_CreateTranslator_ParamsSpec.$,
        null,
        this.createTranslator.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.translationAvailable =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        TranslationManager_TranslationAvailable_ParamsSpec.$,
        TranslationManager_TranslationAvailable_ResponseParamsSpec.$,
        this.translationAvailable.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const TranslatorLanguageCodeSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const TranslatorCreateOptionsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const TranslationManagerCreateTranslatorClient_OnResult_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const TranslationManager_CreateTranslator_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const TranslationManager_TranslationAvailable_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const TranslationManager_TranslationAvailable_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType} }
 */
export const CreateTranslatorResultSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    TranslatorLanguageCodeSpec.$,
    'TranslatorLanguageCode',
    [
      mojo.internal.StructField(
        'code', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class TranslatorLanguageCode {
  constructor() {
    /** @type { !string } */
    this.code;
  }
}



mojo.internal.Struct(
    TranslatorCreateOptionsSpec.$,
    'TranslatorCreateOptions',
    [
      mojo.internal.StructField(
        'sourceLang', 0,
        0,
        TranslatorLanguageCodeSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'targetLang', 8,
        0,
        TranslatorLanguageCodeSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'observerRemote', 16,
        0,
        mojo.internal.InterfaceProxy(blink_mojom_ModelDownloadProgressObserverRemote),
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class TranslatorCreateOptions {
  constructor() {
    /** @type { !TranslatorLanguageCode } */
    this.sourceLang;
    /** @type { !TranslatorLanguageCode } */
    this.targetLang;
    /** @type { (blink_mojom_ModelDownloadProgressObserverRemote|undefined) } */
    this.observerRemote;
  }
}



mojo.internal.Struct(
    TranslationManagerCreateTranslatorClient_OnResult_ParamsSpec.$,
    'TranslationManagerCreateTranslatorClient_OnResult_Params',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        CreateTranslatorResultSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'sourceLang', 16,
        0,
        TranslatorLanguageCodeSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'targetLang', 24,
        0,
        TranslatorLanguageCodeSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 40],]);



/**
 * @record
 */
export class TranslationManagerCreateTranslatorClient_OnResult_Params {
  constructor() {
    /** @type { !CreateTranslatorResult } */
    this.result;
    /** @type { (TranslatorLanguageCode|undefined) } */
    this.sourceLang;
    /** @type { (TranslatorLanguageCode|undefined) } */
    this.targetLang;
  }
}



mojo.internal.Struct(
    TranslationManager_CreateTranslator_ParamsSpec.$,
    'TranslationManager_CreateTranslator_Params',
    [
      mojo.internal.StructField(
        'client', 0,
        0,
        mojo.internal.InterfaceProxy(TranslationManagerCreateTranslatorClientRemote),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'options', 8,
        0,
        TranslatorCreateOptionsSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'addFakeDownloadDelay', 16,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class TranslationManager_CreateTranslator_Params {
  constructor() {
    /** @type { !TranslationManagerCreateTranslatorClientRemote } */
    this.client;
    /** @type { !TranslatorCreateOptions } */
    this.options;
    /** @type { !boolean } */
    this.addFakeDownloadDelay;
  }
}



mojo.internal.Struct(
    TranslationManager_TranslationAvailable_ParamsSpec.$,
    'TranslationManager_TranslationAvailable_Params',
    [
      mojo.internal.StructField(
        'sourceLang', 0,
        0,
        TranslatorLanguageCodeSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'targetLang', 8,
        0,
        TranslatorLanguageCodeSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class TranslationManager_TranslationAvailable_Params {
  constructor() {
    /** @type { !TranslatorLanguageCode } */
    this.sourceLang;
    /** @type { !TranslatorLanguageCode } */
    this.targetLang;
  }
}



mojo.internal.Struct(
    TranslationManager_TranslationAvailable_ResponseParamsSpec.$,
    'TranslationManager_TranslationAvailable_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        CanCreateTranslatorResultSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class TranslationManager_TranslationAvailable_ResponseParams {
  constructor() {
    /** @type { !CanCreateTranslatorResult } */
    this.result;
  }
}

mojo.internal.Union(
    CreateTranslatorResultSpec.$, 'CreateTranslatorResult',
    {
      'translator': {
        'ordinal': 0,
        'type': mojo.internal.InterfaceProxy(blink_mojom_TranslatorRemote),
      },
      'error': {
        'ordinal': 1,
        'type': CreateTranslatorErrorSpec.$,
      },
    });

/**
 * @typedef { {
 *   translator: (!blink_mojom_TranslatorRemote|undefined),
 *   error: (!CreateTranslatorError|undefined),
 * } }
 */
export const CreateTranslatorResult = {};
