// third_party/blink/public/mojom/on_device_translation/translation_manager.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'third_party/blink/public/mojom/on_device_translation/translation_manager.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('blink.mojom');
  var model_download_progress_observer$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/ai/model_download_progress_observer.mojom', '../ai/model_download_progress_observer.mojom.js');
  }
  var translator$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/on_device_translation/translator.mojom', 'translator.mojom.js');
  }


  var CanCreateTranslatorResult = {};
  CanCreateTranslatorResult.kReadily = 0;
  CanCreateTranslatorResult.kAfterDownloadLibraryNotReady = 1;
  CanCreateTranslatorResult.kAfterDownloadLanguagePackNotReady = 2;
  CanCreateTranslatorResult.kAfterDownloadLibraryAndLanguagePackNotReady = 3;
  CanCreateTranslatorResult.kAfterDownloadTranslatorCreationRequired = 4;
  CanCreateTranslatorResult.kNoNotSupportedLanguage = 5;
  CanCreateTranslatorResult.kNoServiceCrashed = 6;
  CanCreateTranslatorResult.kNoDisallowedByPolicy = 7;
  CanCreateTranslatorResult.kNoExceedsServiceCountLimitation = 8;
  CanCreateTranslatorResult.kNoInvalidStoragePartition = 9;
  CanCreateTranslatorResult.MIN_VALUE = 0;
  CanCreateTranslatorResult.MAX_VALUE = 9;

  CanCreateTranslatorResult.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
    case 4:
    case 5:
    case 6:
    case 7:
    case 8:
    case 9:
      return true;
    }
    return false;
  };

  CanCreateTranslatorResult.toKnownEnumValue = function(value) {
    return value;
  };

  CanCreateTranslatorResult.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var CreateTranslatorError = {};
  CreateTranslatorError.kInvalidBinary = 1;
  CreateTranslatorError.kInvalidFunctionPointer = 2;
  CreateTranslatorError.kFailedToInitialize = 3;
  CreateTranslatorError.kFailedToCreateTranslator = 4;
  CreateTranslatorError.kServiceCrashed = 5;
  CreateTranslatorError.kDisallowedByPolicy = 6;
  CreateTranslatorError.kExceedsServiceCountLimitation = 7;
  CreateTranslatorError.kExceedsPendingTaskCountLimitation = 8;
  CreateTranslatorError.kInvalidVersion = 9;
  CreateTranslatorError.kInvalidStoragePartition = 10;
  CreateTranslatorError.MIN_VALUE = 1;
  CreateTranslatorError.MAX_VALUE = 10;

  CreateTranslatorError.isKnownEnumValue = function(value) {
    switch (value) {
    case 1:
    case 2:
    case 3:
    case 4:
    case 5:
    case 6:
    case 7:
    case 8:
    case 9:
    case 10:
      return true;
    }
    return false;
  };

  CreateTranslatorError.toKnownEnumValue = function(value) {
    return value;
  };

  CreateTranslatorError.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };

  function TranslatorLanguageCode(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  TranslatorLanguageCode.prototype.initDefaults_ = function() {
    this.code = null;
  };
  TranslatorLanguageCode.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  TranslatorLanguageCode.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate TranslatorLanguageCode.code
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  TranslatorLanguageCode.encodedSize = codec.kStructHeaderSize + 8;

  TranslatorLanguageCode.decode = function(decoder) {
    var packed;
    var val = new TranslatorLanguageCode();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.code =
        decoder.decodeStruct(codec.String);
    return val;
  };

  TranslatorLanguageCode.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(TranslatorLanguageCode.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.code);
  };
  function TranslatorCreateOptions(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  TranslatorCreateOptions.prototype.initDefaults_ = function() {
    this.sourceLang = null;
    this.targetLang = null;
    this.observerRemote = new model_download_progress_observer$.ModelDownloadProgressObserverPtr();
  };
  TranslatorCreateOptions.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  TranslatorCreateOptions.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate TranslatorCreateOptions.sourceLang
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, TranslatorLanguageCode, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate TranslatorCreateOptions.targetLang
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, TranslatorLanguageCode, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate TranslatorCreateOptions.observerRemote
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 16, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  TranslatorCreateOptions.encodedSize = codec.kStructHeaderSize + 24;

  TranslatorCreateOptions.decode = function(decoder) {
    var packed;
    var val = new TranslatorCreateOptions();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.sourceLang =
        decoder.decodeStructPointer(TranslatorLanguageCode);
    val.targetLang =
        decoder.decodeStructPointer(TranslatorLanguageCode);
    val.observerRemote =
        decoder.decodeStruct(new codec.NullableInterface(model_download_progress_observer$.ModelDownloadProgressObserverPtr));
    return val;
  };

  TranslatorCreateOptions.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(TranslatorCreateOptions.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(TranslatorLanguageCode, val.sourceLang);
    encoder.encodeStructPointer(TranslatorLanguageCode, val.targetLang);
    encoder.encodeStruct(new codec.NullableInterface(model_download_progress_observer$.ModelDownloadProgressObserverPtr), val.observerRemote);
  };
  function TranslationManagerCreateTranslatorClient_OnResult_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  TranslationManagerCreateTranslatorClient_OnResult_Params.prototype.initDefaults_ = function() {
    this.result = null;
    this.sourceLang = null;
    this.targetLang = null;
  };
  TranslationManagerCreateTranslatorClient_OnResult_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  TranslationManagerCreateTranslatorClient_OnResult_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 40}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate TranslationManagerCreateTranslatorClient_OnResult_Params.result
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 0, CreateTranslatorResult, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate TranslationManagerCreateTranslatorClient_OnResult_Params.sourceLang
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, TranslatorLanguageCode, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate TranslationManagerCreateTranslatorClient_OnResult_Params.targetLang
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 24, TranslatorLanguageCode, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  TranslationManagerCreateTranslatorClient_OnResult_Params.encodedSize = codec.kStructHeaderSize + 32;

  TranslationManagerCreateTranslatorClient_OnResult_Params.decode = function(decoder) {
    var packed;
    var val = new TranslationManagerCreateTranslatorClient_OnResult_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.result =
        decoder.decodeStruct(CreateTranslatorResult);
    val.sourceLang =
        decoder.decodeStructPointer(TranslatorLanguageCode);
    val.targetLang =
        decoder.decodeStructPointer(TranslatorLanguageCode);
    return val;
  };

  TranslationManagerCreateTranslatorClient_OnResult_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(TranslationManagerCreateTranslatorClient_OnResult_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(CreateTranslatorResult, val.result);
    encoder.encodeStructPointer(TranslatorLanguageCode, val.sourceLang);
    encoder.encodeStructPointer(TranslatorLanguageCode, val.targetLang);
  };
  function TranslationManager_CreateTranslator_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  TranslationManager_CreateTranslator_Params.prototype.initDefaults_ = function() {
    this.client = new TranslationManagerCreateTranslatorClientPtr();
    this.options = null;
    this.addFakeDownloadDelay = false;
  };
  TranslationManager_CreateTranslator_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  TranslationManager_CreateTranslator_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate TranslationManager_CreateTranslator_Params.client
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 0, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate TranslationManager_CreateTranslator_Params.options
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, TranslatorCreateOptions, false);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  TranslationManager_CreateTranslator_Params.encodedSize = codec.kStructHeaderSize + 24;

  TranslationManager_CreateTranslator_Params.decode = function(decoder) {
    var packed;
    var val = new TranslationManager_CreateTranslator_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.client =
        decoder.decodeStruct(new codec.Interface(TranslationManagerCreateTranslatorClientPtr));
    val.options =
        decoder.decodeStructPointer(TranslatorCreateOptions);
    packed = decoder.readUint8();
    val.addFakeDownloadDelay = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  TranslationManager_CreateTranslator_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(TranslationManager_CreateTranslator_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(new codec.Interface(TranslationManagerCreateTranslatorClientPtr), val.client);
    encoder.encodeStructPointer(TranslatorCreateOptions, val.options);
    packed = 0;
    packed |= (val.addFakeDownloadDelay & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function TranslationManager_TranslationAvailable_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  TranslationManager_TranslationAvailable_Params.prototype.initDefaults_ = function() {
    this.sourceLang = null;
    this.targetLang = null;
  };
  TranslationManager_TranslationAvailable_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  TranslationManager_TranslationAvailable_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate TranslationManager_TranslationAvailable_Params.sourceLang
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, TranslatorLanguageCode, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate TranslationManager_TranslationAvailable_Params.targetLang
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, TranslatorLanguageCode, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  TranslationManager_TranslationAvailable_Params.encodedSize = codec.kStructHeaderSize + 16;

  TranslationManager_TranslationAvailable_Params.decode = function(decoder) {
    var packed;
    var val = new TranslationManager_TranslationAvailable_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.sourceLang =
        decoder.decodeStructPointer(TranslatorLanguageCode);
    val.targetLang =
        decoder.decodeStructPointer(TranslatorLanguageCode);
    return val;
  };

  TranslationManager_TranslationAvailable_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(TranslationManager_TranslationAvailable_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(TranslatorLanguageCode, val.sourceLang);
    encoder.encodeStructPointer(TranslatorLanguageCode, val.targetLang);
  };
  function TranslationManager_TranslationAvailable_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  TranslationManager_TranslationAvailable_ResponseParams.prototype.initDefaults_ = function() {
    this.result = 0;
  };
  TranslationManager_TranslationAvailable_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  TranslationManager_TranslationAvailable_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate TranslationManager_TranslationAvailable_ResponseParams.result
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, CanCreateTranslatorResult);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  TranslationManager_TranslationAvailable_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  TranslationManager_TranslationAvailable_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new TranslationManager_TranslationAvailable_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.result =
        decoder.decodeStruct(new codec.Enum(CanCreateTranslatorResult));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  TranslationManager_TranslationAvailable_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(TranslationManager_TranslationAvailable_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.result);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };

  function CreateTranslatorResult(value) {
    this.initDefault_();
    this.initValue_(value);
  }


  CreateTranslatorResult.Tags = {
    translator: 0,
    error: 1,
  };

  CreateTranslatorResult.prototype.initDefault_ = function() {
    this.$data = null;
    this.$tag = undefined;
  }

  CreateTranslatorResult.prototype.initValue_ = function(value) {
    if (value == undefined) {
      return;
    }

    var keys = Object.keys(value);
    if (keys.length == 0) {
      return;
    }

    if (keys.length > 1) {
      throw new TypeError("You may set only one member on a union.");
    }

    var fields = [
        "translator",
        "error",
    ];

    if (fields.indexOf(keys[0]) < 0) {
      throw new ReferenceError(keys[0] + " is not a CreateTranslatorResult member.");

    }

    this[keys[0]] = value[keys[0]];
  }
  Object.defineProperty(CreateTranslatorResult.prototype, "translator", {
    get: function() {
      if (this.$tag != CreateTranslatorResult.Tags.translator) {
        throw new ReferenceError(
            "CreateTranslatorResult.translator is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = CreateTranslatorResult.Tags.translator;
      this.$data = value;
    }
  });
  Object.defineProperty(CreateTranslatorResult.prototype, "error", {
    get: function() {
      if (this.$tag != CreateTranslatorResult.Tags.error) {
        throw new ReferenceError(
            "CreateTranslatorResult.error is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = CreateTranslatorResult.Tags.error;
      this.$data = value;
    }
  });


    CreateTranslatorResult.encode = function(encoder, val) {
      if (val == null) {
        encoder.writeUint64(0);
        encoder.writeUint64(0);
        return;
      }
      if (val.$tag == undefined) {
        throw new TypeError("Cannot encode unions with an unknown member set.");
      }

      encoder.writeUint32(16);
      encoder.writeUint32(val.$tag);
      switch (val.$tag) {
        case CreateTranslatorResult.Tags.translator:
          encoder.encodeStruct(new codec.Interface(translator$.TranslatorPtr), val.translator);
          break;
        case CreateTranslatorResult.Tags.error:
          encoder.encodeStruct(codec.Int32, val.error);
          break;
      }
      encoder.align();
    };


    CreateTranslatorResult.decode = function(decoder) {
      var size = decoder.readUint32();
      if (size == 0) {
        decoder.readUint32();
        decoder.readUint64();
        return null;
      }

      var result = new CreateTranslatorResult();
      var tag = decoder.readUint32();
      switch (tag) {
        case CreateTranslatorResult.Tags.translator:
          result.translator = decoder.decodeStruct(new codec.Interface(translator$.TranslatorPtr));
          break;
        case CreateTranslatorResult.Tags.error:
          result.error = decoder.decodeStruct(new codec.Enum(CreateTranslatorError));
          break;
      }
      decoder.align();

      return result;
    };


    CreateTranslatorResult.validate = function(messageValidator, offset) {
      var size = messageValidator.decodeUnionSize(offset);
      if (size != 16) {
        return validator.validationError.INVALID_UNION_SIZE;
      }

      var tag = messageValidator.decodeUnionTag(offset);
      var data_offset = offset + 8;
      var err;
      switch (tag) {
        case CreateTranslatorResult.Tags.translator:
          

    // validate CreateTranslatorResult.translator
    err = messageValidator.validateInterface(data_offset, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
        case CreateTranslatorResult.Tags.error:
          

    // validate CreateTranslatorResult.error
    err = messageValidator.validateEnum(data_offset, CreateTranslatorError);
    if (err !== validator.validationError.NONE)
        return err;
          break;
      }

      return validator.validationError.NONE;
    };

  CreateTranslatorResult.encodedSize = 16;
  var kTranslationManagerCreateTranslatorClient_OnResult_Name = 0;

  function TranslationManagerCreateTranslatorClientPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(TranslationManagerCreateTranslatorClient,
                                                   handleOrPtrInfo);
  }

  function TranslationManagerCreateTranslatorClientAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        TranslationManagerCreateTranslatorClient, associatedInterfacePtrInfo);
  }

  TranslationManagerCreateTranslatorClientAssociatedPtr.prototype =
      Object.create(TranslationManagerCreateTranslatorClientPtr.prototype);
  TranslationManagerCreateTranslatorClientAssociatedPtr.prototype.constructor =
      TranslationManagerCreateTranslatorClientAssociatedPtr;

  function TranslationManagerCreateTranslatorClientProxy(receiver) {
    this.receiver_ = receiver;
  }
  TranslationManagerCreateTranslatorClientPtr.prototype.onResult = function() {
    return TranslationManagerCreateTranslatorClientProxy.prototype.onResult
        .apply(this.ptr.getProxy(), arguments);
  };

  TranslationManagerCreateTranslatorClientProxy.prototype.onResult = function(result, sourceLang, targetLang) {
    var params_ = new TranslationManagerCreateTranslatorClient_OnResult_Params();
    params_.result = result;
    params_.sourceLang = sourceLang;
    params_.targetLang = targetLang;
    var builder = new codec.MessageV0Builder(
        kTranslationManagerCreateTranslatorClient_OnResult_Name,
        codec.align(TranslationManagerCreateTranslatorClient_OnResult_Params.encodedSize));
    builder.encodeStruct(TranslationManagerCreateTranslatorClient_OnResult_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function TranslationManagerCreateTranslatorClientStub(delegate) {
    this.delegate_ = delegate;
  }
  TranslationManagerCreateTranslatorClientStub.prototype.onResult = function(result, sourceLang, targetLang) {
    return this.delegate_ && this.delegate_.onResult && this.delegate_.onResult(result, sourceLang, targetLang);
  }

  TranslationManagerCreateTranslatorClientStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kTranslationManagerCreateTranslatorClient_OnResult_Name:
      var params = reader.decodeStruct(TranslationManagerCreateTranslatorClient_OnResult_Params);
      this.onResult(params.result, params.sourceLang, params.targetLang);
      return true;
    default:
      return false;
    }
  };

  TranslationManagerCreateTranslatorClientStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  function validateTranslationManagerCreateTranslatorClientRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kTranslationManagerCreateTranslatorClient_OnResult_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = TranslationManagerCreateTranslatorClient_OnResult_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateTranslationManagerCreateTranslatorClientResponse(messageValidator) {
    return validator.validationError.NONE;
  }

  var TranslationManagerCreateTranslatorClient = {
    name: 'blink.mojom.TranslationManagerCreateTranslatorClient',
    kVersion: 0,
    ptrClass: TranslationManagerCreateTranslatorClientPtr,
    proxyClass: TranslationManagerCreateTranslatorClientProxy,
    stubClass: TranslationManagerCreateTranslatorClientStub,
    validateRequest: validateTranslationManagerCreateTranslatorClientRequest,
    validateResponse: null,
  };
  TranslationManagerCreateTranslatorClientStub.prototype.validator = validateTranslationManagerCreateTranslatorClientRequest;
  TranslationManagerCreateTranslatorClientProxy.prototype.validator = null;
  var kTranslationManager_CreateTranslator_Name = 0;
  var kTranslationManager_TranslationAvailable_Name = 1;

  function TranslationManagerPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(TranslationManager,
                                                   handleOrPtrInfo);
  }

  function TranslationManagerAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        TranslationManager, associatedInterfacePtrInfo);
  }

  TranslationManagerAssociatedPtr.prototype =
      Object.create(TranslationManagerPtr.prototype);
  TranslationManagerAssociatedPtr.prototype.constructor =
      TranslationManagerAssociatedPtr;

  function TranslationManagerProxy(receiver) {
    this.receiver_ = receiver;
  }
  TranslationManagerPtr.prototype.createTranslator = function() {
    return TranslationManagerProxy.prototype.createTranslator
        .apply(this.ptr.getProxy(), arguments);
  };

  TranslationManagerProxy.prototype.createTranslator = function(client, options, addFakeDownloadDelay) {
    var params_ = new TranslationManager_CreateTranslator_Params();
    params_.client = client;
    params_.options = options;
    params_.addFakeDownloadDelay = addFakeDownloadDelay;
    var builder = new codec.MessageV0Builder(
        kTranslationManager_CreateTranslator_Name,
        codec.align(TranslationManager_CreateTranslator_Params.encodedSize));
    builder.encodeStruct(TranslationManager_CreateTranslator_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  TranslationManagerPtr.prototype.translationAvailable = function() {
    return TranslationManagerProxy.prototype.translationAvailable
        .apply(this.ptr.getProxy(), arguments);
  };

  TranslationManagerProxy.prototype.translationAvailable = function(sourceLang, targetLang) {
    var params_ = new TranslationManager_TranslationAvailable_Params();
    params_.sourceLang = sourceLang;
    params_.targetLang = targetLang;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kTranslationManager_TranslationAvailable_Name,
          codec.align(TranslationManager_TranslationAvailable_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(TranslationManager_TranslationAvailable_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(TranslationManager_TranslationAvailable_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };

  function TranslationManagerStub(delegate) {
    this.delegate_ = delegate;
  }
  TranslationManagerStub.prototype.createTranslator = function(client, options, addFakeDownloadDelay) {
    return this.delegate_ && this.delegate_.createTranslator && this.delegate_.createTranslator(client, options, addFakeDownloadDelay);
  }
  TranslationManagerStub.prototype.translationAvailable = function(sourceLang, targetLang) {
    return this.delegate_ && this.delegate_.translationAvailable && this.delegate_.translationAvailable(sourceLang, targetLang);
  }

  TranslationManagerStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kTranslationManager_CreateTranslator_Name:
      var params = reader.decodeStruct(TranslationManager_CreateTranslator_Params);
      this.createTranslator(params.client, params.options, params.addFakeDownloadDelay);
      return true;
    default:
      return false;
    }
  };

  TranslationManagerStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kTranslationManager_TranslationAvailable_Name:
      var params = reader.decodeStruct(TranslationManager_TranslationAvailable_Params);
      this.translationAvailable(params.sourceLang, params.targetLang).then(function(response) {
        var responseParams =
            new TranslationManager_TranslationAvailable_ResponseParams();
        responseParams.result = response.result;
        var builder = new codec.MessageV1Builder(
            kTranslationManager_TranslationAvailable_Name,
            codec.align(TranslationManager_TranslationAvailable_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(TranslationManager_TranslationAvailable_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    default:
      return false;
    }
  };

  function validateTranslationManagerRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kTranslationManager_CreateTranslator_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = TranslationManager_CreateTranslator_Params;
      break;
      case kTranslationManager_TranslationAvailable_Name:
        if (message.expectsResponse())
          paramsClass = TranslationManager_TranslationAvailable_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateTranslationManagerResponse(messageValidator) {
   var message = messageValidator.message;
   var paramsClass = null;
   switch (message.getName()) {
      case kTranslationManager_TranslationAvailable_Name:
        if (message.isResponse())
          paramsClass = TranslationManager_TranslationAvailable_ResponseParams;
        break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  var TranslationManager = {
    name: 'blink.mojom.TranslationManager',
    kVersion: 0,
    ptrClass: TranslationManagerPtr,
    proxyClass: TranslationManagerProxy,
    stubClass: TranslationManagerStub,
    validateRequest: validateTranslationManagerRequest,
    validateResponse: validateTranslationManagerResponse,
  };
  TranslationManagerStub.prototype.validator = validateTranslationManagerRequest;
  TranslationManagerProxy.prototype.validator = validateTranslationManagerResponse;
  exports.CanCreateTranslatorResult = CanCreateTranslatorResult;
  exports.CreateTranslatorError = CreateTranslatorError;
  exports.TranslatorLanguageCode = TranslatorLanguageCode;
  exports.TranslatorCreateOptions = TranslatorCreateOptions;
  exports.CreateTranslatorResult = CreateTranslatorResult;
  exports.TranslationManagerCreateTranslatorClient = TranslationManagerCreateTranslatorClient;
  exports.TranslationManagerCreateTranslatorClientPtr = TranslationManagerCreateTranslatorClientPtr;
  exports.TranslationManagerCreateTranslatorClientAssociatedPtr = TranslationManagerCreateTranslatorClientAssociatedPtr;
  exports.TranslationManager = TranslationManager;
  exports.TranslationManagerPtr = TranslationManagerPtr;
  exports.TranslationManagerAssociatedPtr = TranslationManagerAssociatedPtr;
})();