// third_party/blink/public/mojom/on_device_translation/translation_manager.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_ON_DEVICE_TRANSLATION_TRANSLATION_MANAGER_MOJOM_BLINK_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_ON_DEVICE_TRANSLATION_TRANSLATION_MANAGER_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/on_device_translation/translation_manager.mojom-features.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/on_device_translation/translation_manager.mojom-shared.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/on_device_translation/translation_manager.mojom-blink-forward.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/ai/model_download_progress_observer.mojom-blink-forward.h"
#include "third_party/blink/public/mojom/on_device_translation/translator.mojom-blink-forward.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "third_party/blink/renderer/platform/platform_export.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace blink::mojom::blink {

class TranslationManagerCreateTranslatorClientProxy;

template <typename ImplRefTraits>
class TranslationManagerCreateTranslatorClientStub;

class TranslationManagerCreateTranslatorClientRequestValidator;


class PLATFORM_EXPORT TranslationManagerCreateTranslatorClient
    : public TranslationManagerCreateTranslatorClientInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "blink.mojom.TranslationManagerCreateTranslatorClient";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = TranslationManagerCreateTranslatorClientInterfaceBase;
  using Proxy_ = TranslationManagerCreateTranslatorClientProxy;

  template <typename ImplRefTraits>
  using Stub_ = TranslationManagerCreateTranslatorClientStub<ImplRefTraits>;

  using RequestValidator_ = TranslationManagerCreateTranslatorClientRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOnResultMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct OnResult_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~TranslationManagerCreateTranslatorClient() = default;

  virtual void OnResult(CreateTranslatorResultPtr result, TranslatorLanguageCodePtr source_lang, TranslatorLanguageCodePtr target_lang) = 0;
};

class TranslationManagerProxy;

template <typename ImplRefTraits>
class TranslationManagerStub;

class TranslationManagerRequestValidator;
class TranslationManagerResponseValidator;


class PLATFORM_EXPORT TranslationManager
    : public TranslationManagerInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "blink.mojom.TranslationManager";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = TranslationManagerInterfaceBase;
  using Proxy_ = TranslationManagerProxy;

  template <typename ImplRefTraits>
  using Stub_ = TranslationManagerStub<ImplRefTraits>;

  using RequestValidator_ = TranslationManagerRequestValidator;
  using ResponseValidator_ = TranslationManagerResponseValidator;
  enum MethodMinVersions : uint32_t {
    kCreateTranslatorMinVersion = 0,
    kTranslationAvailableMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct CreateTranslator_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct TranslationAvailable_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~TranslationManager() = default;

  virtual void CreateTranslator(::mojo::PendingRemote<TranslationManagerCreateTranslatorClient> client, TranslatorCreateOptionsPtr options, bool add_fake_download_delay) = 0;

  using TranslationAvailableCallback = base::OnceCallback<void(CanCreateTranslatorResult)>;
  using TranslationAvailableMojoCallback = base::OnceCallback<void(CanCreateTranslatorResult)>;

  virtual void TranslationAvailable(TranslatorLanguageCodePtr source_lang, TranslatorLanguageCodePtr target_lang, TranslationAvailableCallback callback) = 0;
};



class PLATFORM_EXPORT TranslationManagerCreateTranslatorClientProxy
    : public TranslationManagerCreateTranslatorClient {
 public:
  using InterfaceType = TranslationManagerCreateTranslatorClient;

  explicit TranslationManagerCreateTranslatorClientProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnResult(CreateTranslatorResultPtr result, TranslatorLanguageCodePtr source_lang, TranslatorLanguageCodePtr target_lang) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class PLATFORM_EXPORT TranslationManagerProxy
    : public TranslationManager {
 public:
  using InterfaceType = TranslationManager;

  explicit TranslationManagerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void CreateTranslator(::mojo::PendingRemote<TranslationManagerCreateTranslatorClient> client, TranslatorCreateOptionsPtr options, bool add_fake_download_delay) final;
  
  void TranslationAvailable(TranslatorLanguageCodePtr source_lang, TranslatorLanguageCodePtr target_lang, TranslationAvailableCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class PLATFORM_EXPORT TranslationManagerCreateTranslatorClientStubDispatch {
 public:
  static bool Accept(TranslationManagerCreateTranslatorClient* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      TranslationManagerCreateTranslatorClient* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<TranslationManagerCreateTranslatorClient>>
class TranslationManagerCreateTranslatorClientStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  TranslationManagerCreateTranslatorClientStub() = default;
  ~TranslationManagerCreateTranslatorClientStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return TranslationManagerCreateTranslatorClientStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return TranslationManagerCreateTranslatorClientStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class PLATFORM_EXPORT TranslationManagerStubDispatch {
 public:
  static bool Accept(TranslationManager* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      TranslationManager* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<TranslationManager>>
class TranslationManagerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  TranslationManagerStub() = default;
  ~TranslationManagerStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return TranslationManagerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return TranslationManagerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class PLATFORM_EXPORT TranslationManagerCreateTranslatorClientRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class PLATFORM_EXPORT TranslationManagerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class PLATFORM_EXPORT TranslationManagerResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





class PLATFORM_EXPORT TranslatorLanguageCode {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<TranslatorLanguageCode, T>::value>;
  using DataView = TranslatorLanguageCodeDataView;
  using Data_ = internal::TranslatorLanguageCode_Data;

  template <typename... Args>
  static TranslatorLanguageCodePtr New(Args&&... args) {
    return TranslatorLanguageCodePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static TranslatorLanguageCodePtr From(const U& u) {
    return mojo::TypeConverter<TranslatorLanguageCodePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, TranslatorLanguageCode>::Convert(*this);
  }


  TranslatorLanguageCode();

  explicit TranslatorLanguageCode(
      const ::blink::String& code);


  ~TranslatorLanguageCode();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = TranslatorLanguageCodePtr>
  TranslatorLanguageCodePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, TranslatorLanguageCode::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, TranslatorLanguageCode::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, TranslatorLanguageCode::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        TranslatorLanguageCode::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        TranslatorLanguageCode::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        TranslatorLanguageCode::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::TranslatorLanguageCode_UnserializedMessageContext<
            UserType, TranslatorLanguageCode::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<TranslatorLanguageCode::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return TranslatorLanguageCode::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::TranslatorLanguageCode_UnserializedMessageContext<
            UserType, TranslatorLanguageCode::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<TranslatorLanguageCode::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::String code;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, TranslatorLanguageCode::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, TranslatorLanguageCode::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, TranslatorLanguageCode::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, TranslatorLanguageCode::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






class PLATFORM_EXPORT CreateTranslatorResult {
 public:
  using DataView = CreateTranslatorResultDataView;
  using Data_ = internal::CreateTranslatorResult_Data;
  using Tag = Data_::CreateTranslatorResult_Tag;

  template <typename... Args>
  static CreateTranslatorResultPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |translator|.
  static CreateTranslatorResultPtr NewTranslator(
      ::mojo::PendingRemote<::blink::mojom::blink::Translator> value);
  // Construct an instance holding |error|.
  static CreateTranslatorResultPtr NewError(
      CreateTranslatorError value);

  template <typename U>
  static CreateTranslatorResultPtr From(const U& u) {
    return mojo::TypeConverter<CreateTranslatorResultPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, CreateTranslatorResult>::Convert(*this);
  }
  ~CreateTranslatorResult();

  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  CreateTranslatorResult(const CreateTranslatorResult& other) = delete;
  CreateTranslatorResult& operator=(const CreateTranslatorResult& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = CreateTranslatorResultPtr>
  CreateTranslatorResultPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, CreateTranslatorResult>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, CreateTranslatorResult>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  Tag which() const {
    return tag_;
  }

  bool is_translator() const { return tag_ == Tag::kTranslator; }
  const ::mojo::PendingRemote<::blink::mojom::blink::Translator>& get_translator() const {
    CHECK(tag_ == Tag::kTranslator);
    return data_.translator;
  }
  ::mojo::PendingRemote<::blink::mojom::blink::Translator>& get_translator() {
    CHECK(tag_ == Tag::kTranslator);
    return data_.translator;
  }
  void set_translator(::mojo::PendingRemote<::blink::mojom::blink::Translator> translator);

  bool is_error() const { return tag_ == Tag::kError; }
  CreateTranslatorError get_error() const {
    CHECK(tag_ == Tag::kError);
    return data_.error;
  }
  void set_error(CreateTranslatorError error);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        CreateTranslatorResult::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<CreateTranslatorResult::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kTranslator)>,
        ::mojo::PendingRemote<::blink::mojom::blink::Translator> value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kError)>,
        CreateTranslatorError value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    ::mojo::PendingRemote<::blink::mojom::blink::Translator> translator;
    CreateTranslatorError error;
  };

  CreateTranslatorResult(
      std::in_place_index_t<static_cast<size_t>(Tag::kTranslator)>,
      ::mojo::PendingRemote<::blink::mojom::blink::Translator> value);
  CreateTranslatorResult(
      std::in_place_index_t<static_cast<size_t>(Tag::kError)>,
      CreateTranslatorError value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};






class PLATFORM_EXPORT TranslatorCreateOptions {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<TranslatorCreateOptions, T>::value>;
  using DataView = TranslatorCreateOptionsDataView;
  using Data_ = internal::TranslatorCreateOptions_Data;

  template <typename... Args>
  static TranslatorCreateOptionsPtr New(Args&&... args) {
    return TranslatorCreateOptionsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static TranslatorCreateOptionsPtr From(const U& u) {
    return mojo::TypeConverter<TranslatorCreateOptionsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, TranslatorCreateOptions>::Convert(*this);
  }


  TranslatorCreateOptions();

  TranslatorCreateOptions(
      TranslatorLanguageCodePtr source_lang,
      TranslatorLanguageCodePtr target_lang,
      ::mojo::PendingRemote<::blink::mojom::blink::ModelDownloadProgressObserver> observer_remote);

TranslatorCreateOptions(const TranslatorCreateOptions&) = delete;
TranslatorCreateOptions& operator=(const TranslatorCreateOptions&) = delete;

  ~TranslatorCreateOptions();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = TranslatorCreateOptionsPtr>
  TranslatorCreateOptionsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, TranslatorCreateOptions::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, TranslatorCreateOptions::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, TranslatorCreateOptions::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        TranslatorCreateOptions::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::TranslatorCreateOptions_UnserializedMessageContext<
            UserType, TranslatorCreateOptions::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<TranslatorCreateOptions::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return TranslatorCreateOptions::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::TranslatorCreateOptions_UnserializedMessageContext<
            UserType, TranslatorCreateOptions::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<TranslatorCreateOptions::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  TranslatorLanguageCodePtr source_lang;
  
  TranslatorLanguageCodePtr target_lang;
  
  ::mojo::PendingRemote<::blink::mojom::blink::ModelDownloadProgressObserver> observer_remote;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, TranslatorCreateOptions::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, TranslatorCreateOptions::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, TranslatorCreateOptions::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, TranslatorCreateOptions::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename UnionPtrType>
CreateTranslatorResultPtr CreateTranslatorResult::Clone() const {
  switch (tag_) {
    case Tag::kTranslator:
      return NewTranslator(
          mojo::Clone(data_.translator));
    case Tag::kError:
      return NewError(
          mojo::Clone(data_.error));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, CreateTranslatorResult>::value>::type*>
bool CreateTranslatorResult::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kTranslator:
      return mojo::Equals(data_.translator, other.data_.translator);
    case Tag::kError:
      return mojo::Equals(data_.error, other.data_.error);
  }

  return false;
}
template <typename StructPtrType>
TranslatorLanguageCodePtr TranslatorLanguageCode::Clone() const {
  return New(
      mojo::Clone(code)
  );
}

template <typename T, TranslatorLanguageCode::EnableIfSame<T>*>
bool TranslatorLanguageCode::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->code, other_struct.code))
    return false;
  return true;
}

template <typename T, TranslatorLanguageCode::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.code < rhs.code)
    return true;
  if (rhs.code < lhs.code)
    return false;
  return false;
}
template <typename StructPtrType>
TranslatorCreateOptionsPtr TranslatorCreateOptions::Clone() const {
  return New(
      mojo::Clone(source_lang),
      mojo::Clone(target_lang),
      mojo::Clone(observer_remote)
  );
}

template <typename T, TranslatorCreateOptions::EnableIfSame<T>*>
bool TranslatorCreateOptions::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->source_lang, other_struct.source_lang))
    return false;
  if (!mojo::Equals(this->target_lang, other_struct.target_lang))
    return false;
  if (!mojo::Equals(this->observer_remote, other_struct.observer_remote))
    return false;
  return true;
}

template <typename T, TranslatorCreateOptions::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.source_lang < rhs.source_lang)
    return true;
  if (rhs.source_lang < lhs.source_lang)
    return false;
  if (lhs.target_lang < rhs.target_lang)
    return true;
  if (rhs.target_lang < lhs.target_lang)
    return false;
  if (lhs.observer_remote < rhs.observer_remote)
    return true;
  if (rhs.observer_remote < lhs.observer_remote)
    return false;
  return false;
}


}  // blink::mojom::blink

namespace mojo {


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::TranslatorLanguageCode::DataView,
                                         ::blink::mojom::blink::TranslatorLanguageCodePtr> {
  static bool IsNull(const ::blink::mojom::blink::TranslatorLanguageCodePtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::TranslatorLanguageCodePtr* output) { output->reset(); }

  static const decltype(::blink::mojom::blink::TranslatorLanguageCode::code)& code(
      const ::blink::mojom::blink::TranslatorLanguageCodePtr& input) {
    return input->code;
  }

  static bool Read(::blink::mojom::blink::TranslatorLanguageCode::DataView input, ::blink::mojom::blink::TranslatorLanguageCodePtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::TranslatorCreateOptions::DataView,
                                         ::blink::mojom::blink::TranslatorCreateOptionsPtr> {
  static bool IsNull(const ::blink::mojom::blink::TranslatorCreateOptionsPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::TranslatorCreateOptionsPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::blink::TranslatorCreateOptions::source_lang)& source_lang(
      const ::blink::mojom::blink::TranslatorCreateOptionsPtr& input) {
    return input->source_lang;
  }

  static const decltype(::blink::mojom::blink::TranslatorCreateOptions::target_lang)& target_lang(
      const ::blink::mojom::blink::TranslatorCreateOptionsPtr& input) {
    return input->target_lang;
  }

  static  decltype(::blink::mojom::blink::TranslatorCreateOptions::observer_remote)& observer_remote(
       ::blink::mojom::blink::TranslatorCreateOptionsPtr& input) {
    return input->observer_remote;
  }

  static bool Read(::blink::mojom::blink::TranslatorCreateOptions::DataView input, ::blink::mojom::blink::TranslatorCreateOptionsPtr* output);
};


template <>
struct PLATFORM_EXPORT UnionTraits<::blink::mojom::blink::CreateTranslatorResult::DataView,
                                        ::blink::mojom::blink::CreateTranslatorResultPtr> {
  static bool IsNull(const ::blink::mojom::blink::CreateTranslatorResultPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::CreateTranslatorResultPtr* output) { output->reset(); }

  static ::blink::mojom::blink::CreateTranslatorResult::Tag GetTag(const ::blink::mojom::blink::CreateTranslatorResultPtr& input) {
    return input->which();
  }

  static  ::mojo::PendingRemote<::blink::mojom::blink::Translator>& translator( ::blink::mojom::blink::CreateTranslatorResultPtr& input) {
    return input->get_translator();
  }

  static  ::blink::mojom::blink::CreateTranslatorError error(const ::blink::mojom::blink::CreateTranslatorResultPtr& input) {
    return input->get_error();
  }

  static bool Read(::blink::mojom::blink::CreateTranslatorResult::DataView input, ::blink::mojom::blink::CreateTranslatorResultPtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_ON_DEVICE_TRANSLATION_TRANSLATION_MANAGER_MOJOM_BLINK_H_