// third_party/blink/public/mojom/notifications/notification_service.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../../mojo/public/js/bindings.js';

import {
  PermissionStatus as blink_mojom_PermissionStatus,
  PermissionStatusSpec as blink_mojom_PermissionStatusSpec
} from '../permissions/permission_status.mojom.m.js';

import {
  NotificationData as blink_mojom_NotificationData,
  NotificationDataSpec as blink_mojom_NotificationDataSpec,
  NotificationResources as blink_mojom_NotificationResources,
  NotificationResourcesSpec as blink_mojom_NotificationResourcesSpec
} from './notification.mojom.m.js';


/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const PersistentNotificationErrorSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const PersistentNotificationError = {
  
  NONE: 0,
  INTERNAL_ERROR: 1,
  PERMISSION_DENIED: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};



/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class NonPersistentNotificationListenerPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.NonPersistentNotificationListener', scope);
  }
}

/** @interface */
export class NonPersistentNotificationListenerInterface {
  
  /**
   */

  onShow() {}
  
  /**
   * @return {!Promise}
   */

  onClick() {}
  
  /**
   * @return {!Promise}
   */

  onClose() {}
}

/**
 * @implements { NonPersistentNotificationListenerInterface }
 */
export class NonPersistentNotificationListenerRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!NonPersistentNotificationListenerPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          NonPersistentNotificationListenerPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!NonPersistentNotificationListenerPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   */

  onShow() {
    this.proxy.sendMessage(
        0,
        NonPersistentNotificationListener_OnShow_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @return {!Promise}
   */

  onClick() {
    return this.proxy.sendMessage(
        1,
        NonPersistentNotificationListener_OnClick_ParamsSpec.$,
        NonPersistentNotificationListener_OnClick_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @return {!Promise}
   */

  onClose() {
    return this.proxy.sendMessage(
        2,
        NonPersistentNotificationListener_OnClose_ParamsSpec.$,
        NonPersistentNotificationListener_OnClose_ResponseParamsSpec.$,
        [
        ],
        false);
  }
}

/**
 * An object which receives request messages for the NonPersistentNotificationListener
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class NonPersistentNotificationListenerReceiver {
  /**
   * @param {!NonPersistentNotificationListenerInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!NonPersistentNotificationListenerRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        NonPersistentNotificationListenerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!NonPersistentNotificationListenerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        NonPersistentNotificationListener_OnShow_ParamsSpec.$,
        null,
        impl.onShow.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        NonPersistentNotificationListener_OnClick_ParamsSpec.$,
        NonPersistentNotificationListener_OnClick_ResponseParamsSpec.$,
        impl.onClick.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        NonPersistentNotificationListener_OnClose_ParamsSpec.$,
        NonPersistentNotificationListener_OnClose_ResponseParamsSpec.$,
        impl.onClose.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class NonPersistentNotificationListener {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.NonPersistentNotificationListener";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!NonPersistentNotificationListenerRemote}
   */
  static getRemote() {
    let remote = new NonPersistentNotificationListenerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the NonPersistentNotificationListener
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class NonPersistentNotificationListenerCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      NonPersistentNotificationListenerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!NonPersistentNotificationListenerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onShow =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        NonPersistentNotificationListener_OnShow_ParamsSpec.$,
        null,
        this.onShow.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onClick =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        NonPersistentNotificationListener_OnClick_ParamsSpec.$,
        NonPersistentNotificationListener_OnClick_ResponseParamsSpec.$,
        this.onClick.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onClose =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        NonPersistentNotificationListener_OnClose_ParamsSpec.$,
        NonPersistentNotificationListener_OnClose_ResponseParamsSpec.$,
        this.onClose.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class NotificationServicePendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.NotificationService', scope);
  }
}

/** @interface */
export class NotificationServiceInterface {
  
  /**
   * @return {!Promise<{
        status: !blink_mojom_PermissionStatus,
   *  }>}
   */

  getPermissionStatus() {}
  
  /**
   * @param { !string } token
   * @param { !blink_mojom_NotificationData } notificationData
   * @param { !blink_mojom_NotificationResources } notificationResources
   * @param { !NonPersistentNotificationListenerRemote } eventListener
   */

  displayNonPersistentNotification(token, notificationData, notificationResources, eventListener) {}
  
  /**
   * @param { !string } token
   */

  closeNonPersistentNotification(token) {}
  
  /**
   * @param { !bigint } serviceWorkerRegistrationId
   * @param { !blink_mojom_NotificationData } notificationData
   * @param { !blink_mojom_NotificationResources } notificationResources
   * @return {!Promise<{
        error: !PersistentNotificationError,
   *  }>}
   */

  displayPersistentNotification(serviceWorkerRegistrationId, notificationData, notificationResources) {}
  
  /**
   * @param { !string } notificationId
   */

  closePersistentNotification(notificationId) {}
  
  /**
   * @param { !bigint } serviceWorkerRegistrationId
   * @param { !string } filterTag
   * @param { !boolean } includeTriggered
   * @return {!Promise<{
        notificationIds: !Array<!string>,
        notificationDatas: !Array<!blink_mojom_NotificationData>,
   *  }>}
   */

  getNotifications(serviceWorkerRegistrationId, filterTag, includeTriggered) {}
}

/**
 * @implements { NotificationServiceInterface }
 */
export class NotificationServiceRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!NotificationServicePendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          NotificationServicePendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!NotificationServicePendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @return {!Promise<{
        status: !blink_mojom_PermissionStatus,
   *  }>}
   */

  getPermissionStatus() {
    return this.proxy.sendMessage(
        0,
        NotificationService_GetPermissionStatus_ParamsSpec.$,
        NotificationService_GetPermissionStatus_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !string } token
   * @param { !blink_mojom_NotificationData } notificationData
   * @param { !blink_mojom_NotificationResources } notificationResources
   * @param { !NonPersistentNotificationListenerRemote } eventListener
   */

  displayNonPersistentNotification(
      token,
      notificationData,
      notificationResources,
      eventListener) {
    this.proxy.sendMessage(
        1,
        NotificationService_DisplayNonPersistentNotification_ParamsSpec.$,
        null,
        [
          token,
          notificationData,
          notificationResources,
          eventListener
        ],
        false);
  }

  
  /**
   * @param { !string } token
   */

  closeNonPersistentNotification(
      token) {
    this.proxy.sendMessage(
        2,
        NotificationService_CloseNonPersistentNotification_ParamsSpec.$,
        null,
        [
          token
        ],
        false);
  }

  
  /**
   * @param { !bigint } serviceWorkerRegistrationId
   * @param { !blink_mojom_NotificationData } notificationData
   * @param { !blink_mojom_NotificationResources } notificationResources
   * @return {!Promise<{
        error: !PersistentNotificationError,
   *  }>}
   */

  displayPersistentNotification(
      serviceWorkerRegistrationId,
      notificationData,
      notificationResources) {
    return this.proxy.sendMessage(
        3,
        NotificationService_DisplayPersistentNotification_ParamsSpec.$,
        NotificationService_DisplayPersistentNotification_ResponseParamsSpec.$,
        [
          serviceWorkerRegistrationId,
          notificationData,
          notificationResources
        ],
        false);
  }

  
  /**
   * @param { !string } notificationId
   */

  closePersistentNotification(
      notificationId) {
    this.proxy.sendMessage(
        4,
        NotificationService_ClosePersistentNotification_ParamsSpec.$,
        null,
        [
          notificationId
        ],
        false);
  }

  
  /**
   * @param { !bigint } serviceWorkerRegistrationId
   * @param { !string } filterTag
   * @param { !boolean } includeTriggered
   * @return {!Promise<{
        notificationIds: !Array<!string>,
        notificationDatas: !Array<!blink_mojom_NotificationData>,
   *  }>}
   */

  getNotifications(
      serviceWorkerRegistrationId,
      filterTag,
      includeTriggered) {
    return this.proxy.sendMessage(
        5,
        NotificationService_GetNotifications_ParamsSpec.$,
        NotificationService_GetNotifications_ResponseParamsSpec.$,
        [
          serviceWorkerRegistrationId,
          filterTag,
          includeTriggered
        ],
        false);
  }
}

/**
 * An object which receives request messages for the NotificationService
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class NotificationServiceReceiver {
  /**
   * @param {!NotificationServiceInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!NotificationServiceRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        NotificationServiceRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!NotificationServiceRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        NotificationService_GetPermissionStatus_ParamsSpec.$,
        NotificationService_GetPermissionStatus_ResponseParamsSpec.$,
        impl.getPermissionStatus.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        NotificationService_DisplayNonPersistentNotification_ParamsSpec.$,
        null,
        impl.displayNonPersistentNotification.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        NotificationService_CloseNonPersistentNotification_ParamsSpec.$,
        null,
        impl.closeNonPersistentNotification.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        NotificationService_DisplayPersistentNotification_ParamsSpec.$,
        NotificationService_DisplayPersistentNotification_ResponseParamsSpec.$,
        impl.displayPersistentNotification.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        NotificationService_ClosePersistentNotification_ParamsSpec.$,
        null,
        impl.closePersistentNotification.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        NotificationService_GetNotifications_ParamsSpec.$,
        NotificationService_GetNotifications_ResponseParamsSpec.$,
        impl.getNotifications.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class NotificationService {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.NotificationService";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!NotificationServiceRemote}
   */
  static getRemote() {
    let remote = new NotificationServiceRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the NotificationService
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class NotificationServiceCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      NotificationServiceRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!NotificationServiceRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getPermissionStatus =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        NotificationService_GetPermissionStatus_ParamsSpec.$,
        NotificationService_GetPermissionStatus_ResponseParamsSpec.$,
        this.getPermissionStatus.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.displayNonPersistentNotification =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        NotificationService_DisplayNonPersistentNotification_ParamsSpec.$,
        null,
        this.displayNonPersistentNotification.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.closeNonPersistentNotification =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        NotificationService_CloseNonPersistentNotification_ParamsSpec.$,
        null,
        this.closeNonPersistentNotification.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.displayPersistentNotification =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        NotificationService_DisplayPersistentNotification_ParamsSpec.$,
        NotificationService_DisplayPersistentNotification_ResponseParamsSpec.$,
        this.displayPersistentNotification.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.closePersistentNotification =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        NotificationService_ClosePersistentNotification_ParamsSpec.$,
        null,
        this.closePersistentNotification.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getNotifications =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        NotificationService_GetNotifications_ParamsSpec.$,
        NotificationService_GetNotifications_ResponseParamsSpec.$,
        this.getNotifications.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NonPersistentNotificationListener_OnShow_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NonPersistentNotificationListener_OnClick_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NonPersistentNotificationListener_OnClick_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NonPersistentNotificationListener_OnClose_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NonPersistentNotificationListener_OnClose_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NotificationService_GetPermissionStatus_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NotificationService_GetPermissionStatus_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NotificationService_DisplayNonPersistentNotification_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NotificationService_CloseNonPersistentNotification_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NotificationService_DisplayPersistentNotification_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NotificationService_DisplayPersistentNotification_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NotificationService_ClosePersistentNotification_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NotificationService_GetNotifications_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NotificationService_GetNotifications_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    NonPersistentNotificationListener_OnShow_ParamsSpec.$,
    'NonPersistentNotificationListener_OnShow_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class NonPersistentNotificationListener_OnShow_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    NonPersistentNotificationListener_OnClick_ParamsSpec.$,
    'NonPersistentNotificationListener_OnClick_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class NonPersistentNotificationListener_OnClick_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    NonPersistentNotificationListener_OnClick_ResponseParamsSpec.$,
    'NonPersistentNotificationListener_OnClick_ResponseParams',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class NonPersistentNotificationListener_OnClick_ResponseParams {
  constructor() {
  }
}



mojo.internal.Struct(
    NonPersistentNotificationListener_OnClose_ParamsSpec.$,
    'NonPersistentNotificationListener_OnClose_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class NonPersistentNotificationListener_OnClose_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    NonPersistentNotificationListener_OnClose_ResponseParamsSpec.$,
    'NonPersistentNotificationListener_OnClose_ResponseParams',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class NonPersistentNotificationListener_OnClose_ResponseParams {
  constructor() {
  }
}



mojo.internal.Struct(
    NotificationService_GetPermissionStatus_ParamsSpec.$,
    'NotificationService_GetPermissionStatus_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class NotificationService_GetPermissionStatus_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    NotificationService_GetPermissionStatus_ResponseParamsSpec.$,
    'NotificationService_GetPermissionStatus_ResponseParams',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        blink_mojom_PermissionStatusSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class NotificationService_GetPermissionStatus_ResponseParams {
  constructor() {
    /** @type { !blink_mojom_PermissionStatus } */
    this.status;
  }
}



mojo.internal.Struct(
    NotificationService_DisplayNonPersistentNotification_ParamsSpec.$,
    'NotificationService_DisplayNonPersistentNotification_Params',
    [
      mojo.internal.StructField(
        'token', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'notificationData', 8,
        0,
        blink_mojom_NotificationDataSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'notificationResources', 16,
        0,
        blink_mojom_NotificationResourcesSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'eventListener', 24,
        0,
        mojo.internal.InterfaceProxy(NonPersistentNotificationListenerRemote),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 40],]);



/**
 * @record
 */
export class NotificationService_DisplayNonPersistentNotification_Params {
  constructor() {
    /** @type { !string } */
    this.token;
    /** @type { !blink_mojom_NotificationData } */
    this.notificationData;
    /** @type { !blink_mojom_NotificationResources } */
    this.notificationResources;
    /** @type { !NonPersistentNotificationListenerRemote } */
    this.eventListener;
  }
}



mojo.internal.Struct(
    NotificationService_CloseNonPersistentNotification_ParamsSpec.$,
    'NotificationService_CloseNonPersistentNotification_Params',
    [
      mojo.internal.StructField(
        'token', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class NotificationService_CloseNonPersistentNotification_Params {
  constructor() {
    /** @type { !string } */
    this.token;
  }
}



mojo.internal.Struct(
    NotificationService_DisplayPersistentNotification_ParamsSpec.$,
    'NotificationService_DisplayPersistentNotification_Params',
    [
      mojo.internal.StructField(
        'serviceWorkerRegistrationId', 0,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'notificationData', 8,
        0,
        blink_mojom_NotificationDataSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'notificationResources', 16,
        0,
        blink_mojom_NotificationResourcesSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class NotificationService_DisplayPersistentNotification_Params {
  constructor() {
    /** @type { !bigint } */
    this.serviceWorkerRegistrationId;
    /** @type { !blink_mojom_NotificationData } */
    this.notificationData;
    /** @type { !blink_mojom_NotificationResources } */
    this.notificationResources;
  }
}



mojo.internal.Struct(
    NotificationService_DisplayPersistentNotification_ResponseParamsSpec.$,
    'NotificationService_DisplayPersistentNotification_ResponseParams',
    [
      mojo.internal.StructField(
        'error', 0,
        0,
        PersistentNotificationErrorSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class NotificationService_DisplayPersistentNotification_ResponseParams {
  constructor() {
    /** @type { !PersistentNotificationError } */
    this.error;
  }
}



mojo.internal.Struct(
    NotificationService_ClosePersistentNotification_ParamsSpec.$,
    'NotificationService_ClosePersistentNotification_Params',
    [
      mojo.internal.StructField(
        'notificationId', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class NotificationService_ClosePersistentNotification_Params {
  constructor() {
    /** @type { !string } */
    this.notificationId;
  }
}



mojo.internal.Struct(
    NotificationService_GetNotifications_ParamsSpec.$,
    'NotificationService_GetNotifications_Params',
    [
      mojo.internal.StructField(
        'serviceWorkerRegistrationId', 0,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'filterTag', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'includeTriggered', 16,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class NotificationService_GetNotifications_Params {
  constructor() {
    /** @type { !bigint } */
    this.serviceWorkerRegistrationId;
    /** @type { !string } */
    this.filterTag;
    /** @type { !boolean } */
    this.includeTriggered;
  }
}



mojo.internal.Struct(
    NotificationService_GetNotifications_ResponseParamsSpec.$,
    'NotificationService_GetNotifications_ResponseParams',
    [
      mojo.internal.StructField(
        'notificationIds', 0,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'notificationDatas', 8,
        0,
        mojo.internal.Array(blink_mojom_NotificationDataSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class NotificationService_GetNotifications_ResponseParams {
  constructor() {
    /** @type { !Array<!string> } */
    this.notificationIds;
    /** @type { !Array<!blink_mojom_NotificationData> } */
    this.notificationDatas;
  }
}

