// third_party/blink/public/mojom/notifications/notification_service.mojom-lite.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';


mojo.internal.exportModule('blink.mojom');





/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
blink.mojom.PersistentNotificationErrorSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
blink.mojom.PersistentNotificationError = {
  
  NONE: 0,
  INTERNAL_ERROR: 1,
  PERMISSION_DENIED: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};





/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.NonPersistentNotificationListenerPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.NonPersistentNotificationListener.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { blink.mojom.NonPersistentNotificationListenerInterface }
 */
blink.mojom.NonPersistentNotificationListenerRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.NonPersistentNotificationListenerPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.NonPersistentNotificationListenerPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.NonPersistentNotificationListenerPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   */

  onShow() {
    this.proxy.sendMessage(
        0,
        blink.mojom.NonPersistentNotificationListener_OnShow_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @return {!Promise}
   */

  onClick() {
    return this.proxy.sendMessage(
        1,
        blink.mojom.NonPersistentNotificationListener_OnClick_ParamsSpec.$,
        blink.mojom.NonPersistentNotificationListener_OnClick_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @return {!Promise}
   */

  onClose() {
    return this.proxy.sendMessage(
        2,
        blink.mojom.NonPersistentNotificationListener_OnClose_ParamsSpec.$,
        blink.mojom.NonPersistentNotificationListener_OnClose_ResponseParamsSpec.$,
        [
        ],
        false);
  }
};

/**
 * An object which receives request messages for the NonPersistentNotificationListener
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.NonPersistentNotificationListenerReceiver = class {
  /**
   * @param {!blink.mojom.NonPersistentNotificationListenerInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.NonPersistentNotificationListenerRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.NonPersistentNotificationListenerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.NonPersistentNotificationListenerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.NonPersistentNotificationListener_OnShow_ParamsSpec.$,
        null,
        impl.onShow.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        blink.mojom.NonPersistentNotificationListener_OnClick_ParamsSpec.$,
        blink.mojom.NonPersistentNotificationListener_OnClick_ResponseParamsSpec.$,
        impl.onClick.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        blink.mojom.NonPersistentNotificationListener_OnClose_ParamsSpec.$,
        blink.mojom.NonPersistentNotificationListener_OnClose_ResponseParamsSpec.$,
        impl.onClose.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.NonPersistentNotificationListener = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.NonPersistentNotificationListener";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.NonPersistentNotificationListenerRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.NonPersistentNotificationListenerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the NonPersistentNotificationListener
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.NonPersistentNotificationListenerCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.NonPersistentNotificationListenerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.NonPersistentNotificationListenerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onShow =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.NonPersistentNotificationListener_OnShow_ParamsSpec.$,
        null,
        this.onShow.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onClick =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        blink.mojom.NonPersistentNotificationListener_OnClick_ParamsSpec.$,
        blink.mojom.NonPersistentNotificationListener_OnClick_ResponseParamsSpec.$,
        this.onClick.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onClose =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        blink.mojom.NonPersistentNotificationListener_OnClose_ParamsSpec.$,
        blink.mojom.NonPersistentNotificationListener_OnClose_ResponseParamsSpec.$,
        this.onClose.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.NotificationServicePendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.NotificationService.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { blink.mojom.NotificationServiceInterface }
 */
blink.mojom.NotificationServiceRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.NotificationServicePendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.NotificationServicePendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.NotificationServicePendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @return {!Promise<{
        status: !blink.mojom.PermissionStatus,
   *  }>}
   */

  getPermissionStatus() {
    return this.proxy.sendMessage(
        0,
        blink.mojom.NotificationService_GetPermissionStatus_ParamsSpec.$,
        blink.mojom.NotificationService_GetPermissionStatus_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !string } token
   * @param { !blink.mojom.NotificationData } notificationData
   * @param { !blink.mojom.NotificationResources } notificationResources
   * @param { !blink.mojom.NonPersistentNotificationListenerRemote } eventListener
   */

  displayNonPersistentNotification(
      token,
      notificationData,
      notificationResources,
      eventListener) {
    this.proxy.sendMessage(
        1,
        blink.mojom.NotificationService_DisplayNonPersistentNotification_ParamsSpec.$,
        null,
        [
          token,
          notificationData,
          notificationResources,
          eventListener
        ],
        false);
  }

  
  /**
   * @param { !string } token
   */

  closeNonPersistentNotification(
      token) {
    this.proxy.sendMessage(
        2,
        blink.mojom.NotificationService_CloseNonPersistentNotification_ParamsSpec.$,
        null,
        [
          token
        ],
        false);
  }

  
  /**
   * @param { !bigint } serviceWorkerRegistrationId
   * @param { !blink.mojom.NotificationData } notificationData
   * @param { !blink.mojom.NotificationResources } notificationResources
   * @return {!Promise<{
        error: !blink.mojom.PersistentNotificationError,
   *  }>}
   */

  displayPersistentNotification(
      serviceWorkerRegistrationId,
      notificationData,
      notificationResources) {
    return this.proxy.sendMessage(
        3,
        blink.mojom.NotificationService_DisplayPersistentNotification_ParamsSpec.$,
        blink.mojom.NotificationService_DisplayPersistentNotification_ResponseParamsSpec.$,
        [
          serviceWorkerRegistrationId,
          notificationData,
          notificationResources
        ],
        false);
  }

  
  /**
   * @param { !string } notificationId
   */

  closePersistentNotification(
      notificationId) {
    this.proxy.sendMessage(
        4,
        blink.mojom.NotificationService_ClosePersistentNotification_ParamsSpec.$,
        null,
        [
          notificationId
        ],
        false);
  }

  
  /**
   * @param { !bigint } serviceWorkerRegistrationId
   * @param { !string } filterTag
   * @param { !boolean } includeTriggered
   * @return {!Promise<{
        notificationIds: !Array<!string>,
        notificationDatas: !Array<!blink.mojom.NotificationData>,
   *  }>}
   */

  getNotifications(
      serviceWorkerRegistrationId,
      filterTag,
      includeTriggered) {
    return this.proxy.sendMessage(
        5,
        blink.mojom.NotificationService_GetNotifications_ParamsSpec.$,
        blink.mojom.NotificationService_GetNotifications_ResponseParamsSpec.$,
        [
          serviceWorkerRegistrationId,
          filterTag,
          includeTriggered
        ],
        false);
  }
};

/**
 * An object which receives request messages for the NotificationService
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.NotificationServiceReceiver = class {
  /**
   * @param {!blink.mojom.NotificationServiceInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.NotificationServiceRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.NotificationServiceRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.NotificationServiceRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.NotificationService_GetPermissionStatus_ParamsSpec.$,
        blink.mojom.NotificationService_GetPermissionStatus_ResponseParamsSpec.$,
        impl.getPermissionStatus.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        blink.mojom.NotificationService_DisplayNonPersistentNotification_ParamsSpec.$,
        null,
        impl.displayNonPersistentNotification.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        blink.mojom.NotificationService_CloseNonPersistentNotification_ParamsSpec.$,
        null,
        impl.closeNonPersistentNotification.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        blink.mojom.NotificationService_DisplayPersistentNotification_ParamsSpec.$,
        blink.mojom.NotificationService_DisplayPersistentNotification_ResponseParamsSpec.$,
        impl.displayPersistentNotification.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        blink.mojom.NotificationService_ClosePersistentNotification_ParamsSpec.$,
        null,
        impl.closePersistentNotification.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        blink.mojom.NotificationService_GetNotifications_ParamsSpec.$,
        blink.mojom.NotificationService_GetNotifications_ResponseParamsSpec.$,
        impl.getNotifications.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.NotificationService = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.NotificationService";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.NotificationServiceRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.NotificationServiceRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the NotificationService
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.NotificationServiceCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.NotificationServiceRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.NotificationServiceRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getPermissionStatus =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.NotificationService_GetPermissionStatus_ParamsSpec.$,
        blink.mojom.NotificationService_GetPermissionStatus_ResponseParamsSpec.$,
        this.getPermissionStatus.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.displayNonPersistentNotification =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        blink.mojom.NotificationService_DisplayNonPersistentNotification_ParamsSpec.$,
        null,
        this.displayNonPersistentNotification.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.closeNonPersistentNotification =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        blink.mojom.NotificationService_CloseNonPersistentNotification_ParamsSpec.$,
        null,
        this.closeNonPersistentNotification.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.displayPersistentNotification =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        blink.mojom.NotificationService_DisplayPersistentNotification_ParamsSpec.$,
        blink.mojom.NotificationService_DisplayPersistentNotification_ResponseParamsSpec.$,
        this.displayPersistentNotification.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.closePersistentNotification =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        blink.mojom.NotificationService_ClosePersistentNotification_ParamsSpec.$,
        null,
        this.closePersistentNotification.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getNotifications =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        blink.mojom.NotificationService_GetNotifications_ParamsSpec.$,
        blink.mojom.NotificationService_GetNotifications_ResponseParamsSpec.$,
        this.getNotifications.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};



/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.NonPersistentNotificationListener_OnShow_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.NonPersistentNotificationListener_OnClick_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.NonPersistentNotificationListener_OnClick_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.NonPersistentNotificationListener_OnClose_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.NonPersistentNotificationListener_OnClose_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.NotificationService_GetPermissionStatus_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.NotificationService_GetPermissionStatus_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.NotificationService_DisplayNonPersistentNotification_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.NotificationService_CloseNonPersistentNotification_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.NotificationService_DisplayPersistentNotification_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.NotificationService_DisplayPersistentNotification_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.NotificationService_ClosePersistentNotification_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.NotificationService_GetNotifications_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.NotificationService_GetNotifications_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    blink.mojom.NonPersistentNotificationListener_OnShow_ParamsSpec.$,
    'NonPersistentNotificationListener_OnShow_Params',
    [
    ],
    [[0, 8],]);





/** @record */
blink.mojom.NonPersistentNotificationListener_OnShow_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.NonPersistentNotificationListener_OnClick_ParamsSpec.$,
    'NonPersistentNotificationListener_OnClick_Params',
    [
    ],
    [[0, 8],]);





/** @record */
blink.mojom.NonPersistentNotificationListener_OnClick_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.NonPersistentNotificationListener_OnClick_ResponseParamsSpec.$,
    'NonPersistentNotificationListener_OnClick_ResponseParams',
    [
    ],
    [[0, 8],]);





/** @record */
blink.mojom.NonPersistentNotificationListener_OnClick_ResponseParams = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.NonPersistentNotificationListener_OnClose_ParamsSpec.$,
    'NonPersistentNotificationListener_OnClose_Params',
    [
    ],
    [[0, 8],]);





/** @record */
blink.mojom.NonPersistentNotificationListener_OnClose_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.NonPersistentNotificationListener_OnClose_ResponseParamsSpec.$,
    'NonPersistentNotificationListener_OnClose_ResponseParams',
    [
    ],
    [[0, 8],]);





/** @record */
blink.mojom.NonPersistentNotificationListener_OnClose_ResponseParams = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.NotificationService_GetPermissionStatus_ParamsSpec.$,
    'NotificationService_GetPermissionStatus_Params',
    [
    ],
    [[0, 8],]);





/** @record */
blink.mojom.NotificationService_GetPermissionStatus_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.NotificationService_GetPermissionStatus_ResponseParamsSpec.$,
    'NotificationService_GetPermissionStatus_ResponseParams',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        blink.mojom.PermissionStatusSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.NotificationService_GetPermissionStatus_ResponseParams = class {
  constructor() {
    /** @export { !blink.mojom.PermissionStatus } */
    this.status;
  }
};



mojo.internal.Struct(
    blink.mojom.NotificationService_DisplayNonPersistentNotification_ParamsSpec.$,
    'NotificationService_DisplayNonPersistentNotification_Params',
    [
      mojo.internal.StructField(
        'token', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'notificationData', 8,
        0,
        blink.mojom.NotificationDataSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'notificationResources', 16,
        0,
        blink.mojom.NotificationResourcesSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'eventListener', 24,
        0,
        mojo.internal.InterfaceProxy(blink.mojom.NonPersistentNotificationListenerRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 40],]);





/** @record */
blink.mojom.NotificationService_DisplayNonPersistentNotification_Params = class {
  constructor() {
    /** @export { !string } */
    this.token;
    /** @export { !blink.mojom.NotificationData } */
    this.notificationData;
    /** @export { !blink.mojom.NotificationResources } */
    this.notificationResources;
    /** @export { !blink.mojom.NonPersistentNotificationListenerRemote } */
    this.eventListener;
  }
};



mojo.internal.Struct(
    blink.mojom.NotificationService_CloseNonPersistentNotification_ParamsSpec.$,
    'NotificationService_CloseNonPersistentNotification_Params',
    [
      mojo.internal.StructField(
        'token', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.NotificationService_CloseNonPersistentNotification_Params = class {
  constructor() {
    /** @export { !string } */
    this.token;
  }
};



mojo.internal.Struct(
    blink.mojom.NotificationService_DisplayPersistentNotification_ParamsSpec.$,
    'NotificationService_DisplayPersistentNotification_Params',
    [
      mojo.internal.StructField(
        'serviceWorkerRegistrationId', 0,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'notificationData', 8,
        0,
        blink.mojom.NotificationDataSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'notificationResources', 16,
        0,
        blink.mojom.NotificationResourcesSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);





/** @record */
blink.mojom.NotificationService_DisplayPersistentNotification_Params = class {
  constructor() {
    /** @export { !bigint } */
    this.serviceWorkerRegistrationId;
    /** @export { !blink.mojom.NotificationData } */
    this.notificationData;
    /** @export { !blink.mojom.NotificationResources } */
    this.notificationResources;
  }
};



mojo.internal.Struct(
    blink.mojom.NotificationService_DisplayPersistentNotification_ResponseParamsSpec.$,
    'NotificationService_DisplayPersistentNotification_ResponseParams',
    [
      mojo.internal.StructField(
        'error', 0,
        0,
        blink.mojom.PersistentNotificationErrorSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.NotificationService_DisplayPersistentNotification_ResponseParams = class {
  constructor() {
    /** @export { !blink.mojom.PersistentNotificationError } */
    this.error;
  }
};



mojo.internal.Struct(
    blink.mojom.NotificationService_ClosePersistentNotification_ParamsSpec.$,
    'NotificationService_ClosePersistentNotification_Params',
    [
      mojo.internal.StructField(
        'notificationId', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.NotificationService_ClosePersistentNotification_Params = class {
  constructor() {
    /** @export { !string } */
    this.notificationId;
  }
};



mojo.internal.Struct(
    blink.mojom.NotificationService_GetNotifications_ParamsSpec.$,
    'NotificationService_GetNotifications_Params',
    [
      mojo.internal.StructField(
        'serviceWorkerRegistrationId', 0,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'filterTag', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'includeTriggered', 16,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);





/** @record */
blink.mojom.NotificationService_GetNotifications_Params = class {
  constructor() {
    /** @export { !bigint } */
    this.serviceWorkerRegistrationId;
    /** @export { !string } */
    this.filterTag;
    /** @export { !boolean } */
    this.includeTriggered;
  }
};



mojo.internal.Struct(
    blink.mojom.NotificationService_GetNotifications_ResponseParamsSpec.$,
    'NotificationService_GetNotifications_ResponseParams',
    [
      mojo.internal.StructField(
        'notificationIds', 0,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'notificationDatas', 8,
        0,
        mojo.internal.Array(blink.mojom.NotificationDataSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
blink.mojom.NotificationService_GetNotifications_ResponseParams = class {
  constructor() {
    /** @export { !Array<!string> } */
    this.notificationIds;
    /** @export { !Array<!blink.mojom.NotificationData> } */
    this.notificationDatas;
  }
};

