// third_party/blink/public/mojom/navigation/prefetched_signed_exchange_info.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_NAVIGATION_PREFETCHED_SIGNED_EXCHANGE_INFO_MOJOM_SHARED_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_NAVIGATION_PREFETCHED_SIGNED_EXCHANGE_INFO_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/navigation/prefetched_signed_exchange_info.mojom-shared-internal.h"
#include "mojo/public/mojom/base/byte_string.mojom-shared.h"
#include "services/network/public/mojom/url_loader_factory.mojom-shared.h"
#include "services/network/public/mojom/url_loader.mojom-shared.h"
#include "services/network/public/mojom/url_response_head.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"


#include "mojo/public/cpp/bindings/native_enum.h"
#include "mojo/public/cpp/bindings/lib/native_struct_serialization.h"

#include "third_party/blink/public/mojom/navigation/prefetched_signed_exchange_info.mojom-data-view.h"
#include "base/component_export.h"




namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::SHA256HashValueDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::SHA256HashValueDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::SHA256HashValue_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::data(input)) in_data = Traits::data(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->data)::BaseType> data_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::ByteStringDataView>(
      in_data,
      data_fragment);

    fragment->data.Set(
        data_fragment.is_null() ? nullptr : data_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->data.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null data in SHA256HashValue struct");
  }

  static bool Deserialize(::blink::mojom::internal::SHA256HashValue_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::SHA256HashValueDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::PrefetchedSignedExchangeInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::PrefetchedSignedExchangeInfoDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::PrefetchedSignedExchangeInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::outer_url(input)) in_outer_url = Traits::outer_url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->outer_url)::BaseType> outer_url_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_outer_url,
      outer_url_fragment);

    fragment->outer_url.Set(
        outer_url_fragment.is_null() ? nullptr : outer_url_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->outer_url.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null outer_url in PrefetchedSignedExchangeInfo struct");

    decltype(Traits::header_integrity(input)) in_header_integrity = Traits::header_integrity(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->header_integrity)::BaseType> header_integrity_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::blink::mojom::SHA256HashValueDataView>(
      in_header_integrity,
      header_integrity_fragment);

    fragment->header_integrity.Set(
        header_integrity_fragment.is_null() ? nullptr : header_integrity_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->header_integrity.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null header_integrity in PrefetchedSignedExchangeInfo struct");

    decltype(Traits::inner_url(input)) in_inner_url = Traits::inner_url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->inner_url)::BaseType> inner_url_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_inner_url,
      inner_url_fragment);

    fragment->inner_url.Set(
        inner_url_fragment.is_null() ? nullptr : inner_url_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->inner_url.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null inner_url in PrefetchedSignedExchangeInfo struct");

    decltype(Traits::inner_response(input)) in_inner_response = Traits::inner_response(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->inner_response)::BaseType> inner_response_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::network::mojom::URLResponseHeadDataView>(
      in_inner_response,
      inner_response_fragment);

    fragment->inner_response.Set(
        inner_response_fragment.is_null() ? nullptr : inner_response_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->inner_response.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null inner_response in PrefetchedSignedExchangeInfo struct");

    decltype(Traits::loader_factory_handle(input)) in_loader_factory_handle = Traits::loader_factory_handle(input);

    
    mojo::internal::Serialize<mojo::InterfacePtrDataView<::network::mojom::URLLoaderFactoryInterfaceBase>>(
      in_loader_factory_handle,
      &fragment->loader_factory_handle,
      &fragment.message());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(!mojo::internal::IsHandleOrInterfaceValid(fragment->loader_factory_handle)),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid loader_factory_handle in PrefetchedSignedExchangeInfo struct");
  }

  static bool Deserialize(::blink::mojom::internal::PrefetchedSignedExchangeInfo_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::PrefetchedSignedExchangeInfoDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace blink::mojom {

inline void SHA256HashValueDataView::GetDataDataView(
    ::mojo_base::mojom::ByteStringDataView* output) {
  auto pointer = data_->data.Get();
  *output = ::mojo_base::mojom::ByteStringDataView(pointer, message_);
}


inline void PrefetchedSignedExchangeInfoDataView::GetOuterUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->outer_url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void PrefetchedSignedExchangeInfoDataView::GetHeaderIntegrityDataView(
    SHA256HashValueDataView* output) {
  auto pointer = data_->header_integrity.Get();
  *output = SHA256HashValueDataView(pointer, message_);
}
inline void PrefetchedSignedExchangeInfoDataView::GetInnerUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->inner_url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void PrefetchedSignedExchangeInfoDataView::GetInnerResponseDataView(
    ::network::mojom::URLResponseHeadDataView* output) {
  auto pointer = data_->inner_response.Get();
  *output = ::network::mojom::URLResponseHeadDataView(pointer, message_);
}



}  // blink::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_NAVIGATION_PREFETCHED_SIGNED_EXCHANGE_INFO_MOJOM_SHARED_H_