// third_party/blink/public/mojom/navigation/prefetched_signed_exchange_info.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_NAVIGATION_PREFETCHED_SIGNED_EXCHANGE_INFO_MOJOM_DATA_VIEW_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_NAVIGATION_PREFETCHED_SIGNED_EXCHANGE_INFO_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/blink/public/mojom/navigation/prefetched_signed_exchange_info.mojom-shared-internal.h"
#include "mojo/public/mojom/base/byte_string.mojom-shared.h"
#include "services/network/public/mojom/url_loader_factory.mojom-shared.h"
#include "services/network/public/mojom/url_loader.mojom-shared.h"
#include "services/network/public/mojom/url_response_head.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"


namespace blink::mojom {
class SHA256HashValueDataView;

class PrefetchedSignedExchangeInfoDataView;



}  // blink::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::blink::mojom::SHA256HashValueDataView> {
  using Data = ::blink::mojom::internal::SHA256HashValue_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::PrefetchedSignedExchangeInfoDataView> {
  using Data = ::blink::mojom::internal::PrefetchedSignedExchangeInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace blink::mojom {


class SHA256HashValueDataView {
 public:
  SHA256HashValueDataView() = default;

  SHA256HashValueDataView(
      internal::SHA256HashValue_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetDataDataView(
      ::mojo_base::mojom::ByteStringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadData(UserType* output) {
    
    auto* pointer = data_->data.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::ByteStringDataView>(
        pointer, output, message_);
  }
 private:
  internal::SHA256HashValue_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PrefetchedSignedExchangeInfoDataView {
 public:
  PrefetchedSignedExchangeInfoDataView() = default;

  PrefetchedSignedExchangeInfoDataView(
      internal::PrefetchedSignedExchangeInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetOuterUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOuterUrl(UserType* output) {
    
    auto* pointer = data_->outer_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetHeaderIntegrityDataView(
      SHA256HashValueDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadHeaderIntegrity(UserType* output) {
    
    auto* pointer = data_->header_integrity.Get();
    return mojo::internal::Deserialize<::blink::mojom::SHA256HashValueDataView>(
        pointer, output, message_);
  }
  inline void GetInnerUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInnerUrl(UserType* output) {
    
    auto* pointer = data_->inner_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetInnerResponseDataView(
      ::network::mojom::URLResponseHeadDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInnerResponse(UserType* output) {
    
    auto* pointer = data_->inner_response.Get();
    return mojo::internal::Deserialize<::network::mojom::URLResponseHeadDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  UserType TakeLoaderFactoryHandle() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::network::mojom::URLLoaderFactoryInterfaceBase>>(
            &data_->loader_factory_handle, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::PrefetchedSignedExchangeInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // blink::mojom

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_NAVIGATION_PREFETCHED_SIGNED_EXCHANGE_INFO_MOJOM_DATA_VIEW_H_