// third_party/blink/public/mojom/navigation/navigation_policy.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_NAVIGATION_NAVIGATION_POLICY_MOJOM_BLINK_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_NAVIGATION_NAVIGATION_POLICY_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/navigation/navigation_policy.mojom-features.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/navigation/navigation_policy.mojom-shared.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/navigation/navigation_policy.mojom-blink-forward.h"  // IWYU pragma: export

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"




#include "third_party/blink/public/common/navigation/navigation_policy_mojom_traits.h"
#include "third_party/blink/renderer/platform/platform_export.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace blink::mojom::blink {









class PLATFORM_EXPORT NavigationDownloadTypes {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<NavigationDownloadTypes, T>::value>;
  using DataView = NavigationDownloadTypesDataView;
  using Data_ = internal::NavigationDownloadTypes_Data;

  template <typename... Args>
  static NavigationDownloadTypesPtr New(Args&&... args) {
    return NavigationDownloadTypesPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static NavigationDownloadTypesPtr From(const U& u) {
    return mojo::TypeConverter<NavigationDownloadTypesPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, NavigationDownloadTypes>::Convert(*this);
  }


  NavigationDownloadTypes();

  NavigationDownloadTypes(
      bool view_source,
      bool interstitial,
      bool opener_cross_origin,
      bool ad_frame_no_gesture,
      bool ad_frame,
      bool sandbox,
      bool no_gesture);


  ~NavigationDownloadTypes();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = NavigationDownloadTypesPtr>
  NavigationDownloadTypesPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, NavigationDownloadTypes::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, NavigationDownloadTypes::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, NavigationDownloadTypes::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        NavigationDownloadTypes::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        NavigationDownloadTypes::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        NavigationDownloadTypes::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::NavigationDownloadTypes_UnserializedMessageContext<
            UserType, NavigationDownloadTypes::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<NavigationDownloadTypes::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return NavigationDownloadTypes::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::NavigationDownloadTypes_UnserializedMessageContext<
            UserType, NavigationDownloadTypes::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<NavigationDownloadTypes::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  bool view_source;
  
  bool interstitial;
  
  bool opener_cross_origin;
  
  bool ad_frame_no_gesture;
  
  bool ad_frame;
  
  bool sandbox;
  
  bool no_gesture;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, NavigationDownloadTypes::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, NavigationDownloadTypes::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, NavigationDownloadTypes::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, NavigationDownloadTypes::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class PLATFORM_EXPORT NavigationDownloadPolicy {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<NavigationDownloadPolicy, T>::value>;
  using DataView = NavigationDownloadPolicyDataView;
  using Data_ = internal::NavigationDownloadPolicy_Data;

  template <typename... Args>
  static NavigationDownloadPolicyPtr New(Args&&... args) {
    return NavigationDownloadPolicyPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static NavigationDownloadPolicyPtr From(const U& u) {
    return mojo::TypeConverter<NavigationDownloadPolicyPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, NavigationDownloadPolicy>::Convert(*this);
  }


  NavigationDownloadPolicy();

  NavigationDownloadPolicy(
      const ::blink::NavigationDownloadPolicy::NavigationDownloadTypes& observed_types,
      const ::blink::NavigationDownloadPolicy::NavigationDownloadTypes& disallowed_types);


  ~NavigationDownloadPolicy();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = NavigationDownloadPolicyPtr>
  NavigationDownloadPolicyPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, NavigationDownloadPolicy::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, NavigationDownloadPolicy::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, NavigationDownloadPolicy::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        NavigationDownloadPolicy::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        NavigationDownloadPolicy::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        NavigationDownloadPolicy::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::NavigationDownloadPolicy_UnserializedMessageContext<
            UserType, NavigationDownloadPolicy::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<NavigationDownloadPolicy::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return NavigationDownloadPolicy::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::NavigationDownloadPolicy_UnserializedMessageContext<
            UserType, NavigationDownloadPolicy::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<NavigationDownloadPolicy::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::NavigationDownloadPolicy::NavigationDownloadTypes observed_types;
  
  ::blink::NavigationDownloadPolicy::NavigationDownloadTypes disallowed_types;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, NavigationDownloadPolicy::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, NavigationDownloadPolicy::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, NavigationDownloadPolicy::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, NavigationDownloadPolicy::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
NavigationDownloadTypesPtr NavigationDownloadTypes::Clone() const {
  return New(
      mojo::Clone(view_source),
      mojo::Clone(interstitial),
      mojo::Clone(opener_cross_origin),
      mojo::Clone(ad_frame_no_gesture),
      mojo::Clone(ad_frame),
      mojo::Clone(sandbox),
      mojo::Clone(no_gesture)
  );
}

template <typename T, NavigationDownloadTypes::EnableIfSame<T>*>
bool NavigationDownloadTypes::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->view_source, other_struct.view_source))
    return false;
  if (!mojo::Equals(this->interstitial, other_struct.interstitial))
    return false;
  if (!mojo::Equals(this->opener_cross_origin, other_struct.opener_cross_origin))
    return false;
  if (!mojo::Equals(this->ad_frame_no_gesture, other_struct.ad_frame_no_gesture))
    return false;
  if (!mojo::Equals(this->ad_frame, other_struct.ad_frame))
    return false;
  if (!mojo::Equals(this->sandbox, other_struct.sandbox))
    return false;
  if (!mojo::Equals(this->no_gesture, other_struct.no_gesture))
    return false;
  return true;
}

template <typename T, NavigationDownloadTypes::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.view_source < rhs.view_source)
    return true;
  if (rhs.view_source < lhs.view_source)
    return false;
  if (lhs.interstitial < rhs.interstitial)
    return true;
  if (rhs.interstitial < lhs.interstitial)
    return false;
  if (lhs.opener_cross_origin < rhs.opener_cross_origin)
    return true;
  if (rhs.opener_cross_origin < lhs.opener_cross_origin)
    return false;
  if (lhs.ad_frame_no_gesture < rhs.ad_frame_no_gesture)
    return true;
  if (rhs.ad_frame_no_gesture < lhs.ad_frame_no_gesture)
    return false;
  if (lhs.ad_frame < rhs.ad_frame)
    return true;
  if (rhs.ad_frame < lhs.ad_frame)
    return false;
  if (lhs.sandbox < rhs.sandbox)
    return true;
  if (rhs.sandbox < lhs.sandbox)
    return false;
  if (lhs.no_gesture < rhs.no_gesture)
    return true;
  if (rhs.no_gesture < lhs.no_gesture)
    return false;
  return false;
}
template <typename StructPtrType>
NavigationDownloadPolicyPtr NavigationDownloadPolicy::Clone() const {
  return New(
      mojo::Clone(observed_types),
      mojo::Clone(disallowed_types)
  );
}

template <typename T, NavigationDownloadPolicy::EnableIfSame<T>*>
bool NavigationDownloadPolicy::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->observed_types, other_struct.observed_types))
    return false;
  if (!mojo::Equals(this->disallowed_types, other_struct.disallowed_types))
    return false;
  return true;
}

template <typename T, NavigationDownloadPolicy::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.observed_types < rhs.observed_types)
    return true;
  if (rhs.observed_types < lhs.observed_types)
    return false;
  if (lhs.disallowed_types < rhs.disallowed_types)
    return true;
  if (rhs.disallowed_types < lhs.disallowed_types)
    return false;
  return false;
}


}  // blink::mojom::blink

namespace mojo {


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::NavigationDownloadTypes::DataView,
                                         ::blink::mojom::blink::NavigationDownloadTypesPtr> {
  static bool IsNull(const ::blink::mojom::blink::NavigationDownloadTypesPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::NavigationDownloadTypesPtr* output) { output->reset(); }

  static decltype(::blink::mojom::blink::NavigationDownloadTypes::view_source) view_source(
      const ::blink::mojom::blink::NavigationDownloadTypesPtr& input) {
    return input->view_source;
  }

  static decltype(::blink::mojom::blink::NavigationDownloadTypes::interstitial) interstitial(
      const ::blink::mojom::blink::NavigationDownloadTypesPtr& input) {
    return input->interstitial;
  }

  static decltype(::blink::mojom::blink::NavigationDownloadTypes::opener_cross_origin) opener_cross_origin(
      const ::blink::mojom::blink::NavigationDownloadTypesPtr& input) {
    return input->opener_cross_origin;
  }

  static decltype(::blink::mojom::blink::NavigationDownloadTypes::ad_frame_no_gesture) ad_frame_no_gesture(
      const ::blink::mojom::blink::NavigationDownloadTypesPtr& input) {
    return input->ad_frame_no_gesture;
  }

  static decltype(::blink::mojom::blink::NavigationDownloadTypes::ad_frame) ad_frame(
      const ::blink::mojom::blink::NavigationDownloadTypesPtr& input) {
    return input->ad_frame;
  }

  static decltype(::blink::mojom::blink::NavigationDownloadTypes::sandbox) sandbox(
      const ::blink::mojom::blink::NavigationDownloadTypesPtr& input) {
    return input->sandbox;
  }

  static decltype(::blink::mojom::blink::NavigationDownloadTypes::no_gesture) no_gesture(
      const ::blink::mojom::blink::NavigationDownloadTypesPtr& input) {
    return input->no_gesture;
  }

  static bool Read(::blink::mojom::blink::NavigationDownloadTypes::DataView input, ::blink::mojom::blink::NavigationDownloadTypesPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::NavigationDownloadPolicy::DataView,
                                         ::blink::mojom::blink::NavigationDownloadPolicyPtr> {
  static bool IsNull(const ::blink::mojom::blink::NavigationDownloadPolicyPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::NavigationDownloadPolicyPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::blink::NavigationDownloadPolicy::observed_types)& observed_types(
      const ::blink::mojom::blink::NavigationDownloadPolicyPtr& input) {
    return input->observed_types;
  }

  static const decltype(::blink::mojom::blink::NavigationDownloadPolicy::disallowed_types)& disallowed_types(
      const ::blink::mojom::blink::NavigationDownloadPolicyPtr& input) {
    return input->disallowed_types;
  }

  static bool Read(::blink::mojom::blink::NavigationDownloadPolicy::DataView input, ::blink::mojom::blink::NavigationDownloadPolicyPtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_NAVIGATION_NAVIGATION_POLICY_MOJOM_BLINK_H_