// third_party/blink/public/mojom/navigation/navigation_params.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_NAVIGATION_NAVIGATION_PARAMS_MOJOM_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_NAVIGATION_NAVIGATION_PARAMS_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/navigation/navigation_params.mojom-features.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/navigation/navigation_params.mojom-shared.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/navigation/navigation_params.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/byte_string.mojom.h"
#include "mojo/public/mojom/base/time.mojom.h"
#include "mojo/public/mojom/base/unguessable_token.mojom.h"
#include "mojo/public/mojom/base/values.mojom.h"
#include "services/network/public/mojom/content_security_policy.mojom-forward.h"
#include "services/network/public/mojom/fetch_api.mojom-forward.h"
#include "services/network/public/mojom/source_location.mojom.h"
#include "services/network/public/mojom/storage_access_api.mojom.h"
#include "services/network/public/mojom/trust_tokens.mojom.h"
#include "services/network/public/mojom/url_loader.mojom.h"
#include "services/network/public/mojom/url_request.mojom.h"
#include "services/network/public/mojom/url_response_head.mojom.h"
#include "services/network/public/mojom/web_client_hints_types.mojom-forward.h"
#include "services/network/public/mojom/web_sandbox_flags.mojom-forward.h"
#include "services/viz/public/mojom/compositing/local_surface_id.mojom.h"
#include "third_party/blink/public/mojom/back_forward_cache_not_restored_reasons.mojom.h"
#include "third_party/blink/public/mojom/conversions/conversions.mojom.h"
#include "third_party/blink/public/mojom/fenced_frame/fenced_frame_config.mojom.h"
#include "third_party/blink/public/mojom/fetch/fetch_api_request.mojom-forward.h"
#include "third_party/blink/public/mojom/frame/frame_policy.mojom.h"
#include "third_party/blink/public/mojom/frame/view_transition_state.mojom.h"
#include "third_party/blink/public/mojom/lcp_critical_path_predictor/lcp_critical_path_predictor.mojom.h"
#include "third_party/blink/public/mojom/loader/mixed_content.mojom-forward.h"
#include "third_party/blink/public/mojom/loader/referrer.mojom.h"
#include "third_party/blink/public/mojom/messaging/task_attribution_id.mojom.h"
#include "third_party/blink/public/mojom/navigation/navigation_api_history_entry_arrays.mojom.h"
#include "third_party/blink/public/mojom/navigation/navigation_initiator_activation_and_ad_status.mojom-forward.h"
#include "third_party/blink/public/mojom/navigation/navigation_policy.mojom.h"
#include "third_party/blink/public/mojom/navigation/prefetched_signed_exchange_info.mojom.h"
#include "third_party/blink/public/mojom/navigation/renderer_content_settings.mojom.h"
#include "third_party/blink/public/mojom/navigation/was_activated_option.mojom-forward.h"
#include "third_party/blink/public/mojom/page/page.mojom.h"
#include "third_party/blink/public/mojom/permissions/permission.mojom.h"
#include "third_party/blink/public/mojom/permissions/permission_status.mojom-forward.h"
#include "services/network/public/mojom/permissions_policy/permissions_policy.mojom-forward.h"
#include "third_party/blink/public/mojom/runtime_feature_state/runtime_feature.mojom.h"
#include "third_party/blink/public/mojom/storage_key/storage_key.mojom.h"
#include "third_party/blink/public/mojom/tokens/tokens.mojom.h"
#include "url/mojom/origin.mojom.h"
#include "url/mojom/url.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "mojo/public/cpp/bindings/lib/native_enum_serialization.h"
#include "mojo/public/cpp/bindings/lib/native_struct_serialization.h"
#include "third_party/blink/public/common/common_export.h"




namespace blink::mojom {













class BLINK_COMMON_EXPORT BeginNavigationParams {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<BeginNavigationParams, T>::value>;
  using DataView = BeginNavigationParamsDataView;
  using Data_ = internal::BeginNavigationParams_Data;

  template <typename... Args>
  static BeginNavigationParamsPtr New(Args&&... args) {
    return BeginNavigationParamsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static BeginNavigationParamsPtr From(const U& u) {
    return mojo::TypeConverter<BeginNavigationParamsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, BeginNavigationParams>::Convert(*this);
  }


  BeginNavigationParams();

  BeginNavigationParams(
      const std::optional<::blink::LocalFrameToken>& initiator_frame_token,
      const std::string& headers,
      int32_t load_flags,
      bool skip_service_worker,
      ::blink::mojom::RequestContextType request_context_type,
      ::blink::mojom::MixedContentContextType mixed_content_context_type,
      bool is_form_submission,
      bool was_initiated_by_link_click,
      ForceHistoryPush force_history_push,
      const ::GURL& searchable_form_url,
      const std::string& searchable_form_encoding,
      const ::GURL& client_side_redirect_url,
      std::optional<::base::Value::Dict> devtools_initiator,
      ::network::mojom::TrustTokenParamsPtr trust_token_params,
      const std::optional<::blink::Impression>& impression,
      ::base::TimeTicks before_unload_start,
      ::base::TimeTicks before_unload_end,
      ::blink::mojom::NavigationInitiatorActivationAndAdStatus initiator_activation_and_ad_status,
      bool is_container_initiated,
      ::net::StorageAccessApiStatus storage_access_api_status,
      bool has_rel_opener);

BeginNavigationParams(const BeginNavigationParams&) = delete;
BeginNavigationParams& operator=(const BeginNavigationParams&) = delete;

  ~BeginNavigationParams();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = BeginNavigationParamsPtr>
  BeginNavigationParamsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, BeginNavigationParams::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, BeginNavigationParams::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, BeginNavigationParams::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        BeginNavigationParams::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        BeginNavigationParams::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        BeginNavigationParams::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::BeginNavigationParams_UnserializedMessageContext<
            UserType, BeginNavigationParams::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<BeginNavigationParams::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return BeginNavigationParams::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::BeginNavigationParams_UnserializedMessageContext<
            UserType, BeginNavigationParams::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<BeginNavigationParams::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::optional<::blink::LocalFrameToken> initiator_frame_token;
  
  std::string headers;
  
  int32_t load_flags;
  
  bool skip_service_worker;
  
  ::blink::mojom::RequestContextType request_context_type;
  
  ::blink::mojom::MixedContentContextType mixed_content_context_type;
  
  bool is_form_submission;
  
  bool was_initiated_by_link_click;
  
  ForceHistoryPush force_history_push;
  
  ::GURL searchable_form_url;
  
  std::string searchable_form_encoding;
  
  ::GURL client_side_redirect_url;
  
  std::optional<::base::Value::Dict> devtools_initiator;
  
  ::network::mojom::TrustTokenParamsPtr trust_token_params;
  
  std::optional<::blink::Impression> impression;
  
  ::base::TimeTicks before_unload_start;
  
  ::base::TimeTicks before_unload_end;
  
  ::blink::mojom::NavigationInitiatorActivationAndAdStatus initiator_activation_and_ad_status;
  
  bool is_container_initiated;
  
  ::net::StorageAccessApiStatus storage_access_api_status;
  
  bool has_rel_opener;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, BeginNavigationParams::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, BeginNavigationParams::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, BeginNavigationParams::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, BeginNavigationParams::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_COMMON_EXPORT CommonNavigationParams {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<CommonNavigationParams, T>::value>;
  using DataView = CommonNavigationParamsDataView;
  using Data_ = internal::CommonNavigationParams_Data;

  template <typename... Args>
  static CommonNavigationParamsPtr New(Args&&... args) {
    return CommonNavigationParamsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static CommonNavigationParamsPtr From(const U& u) {
    return mojo::TypeConverter<CommonNavigationParamsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, CommonNavigationParams>::Convert(*this);
  }


  CommonNavigationParams();

  CommonNavigationParams(
      const ::GURL& url,
      const std::optional<::url::Origin>& initiator_origin,
      const std::optional<::GURL>& initiator_base_url,
      ::blink::mojom::ReferrerPtr referrer,
      int32_t transition,
      NavigationType navigation_type,
      const ::blink::NavigationDownloadPolicy& download_policy,
      bool should_replace_current_entry,
      const ::GURL& base_url_for_data_url,
      ::base::TimeTicks actual_navigation_start,
      ::base::TimeTicks navigation_start,
      const std::string& method,
      ::scoped_refptr<::network::ResourceRequestBody> post_data,
      ::network::mojom::SourceLocationPtr source_location,
      bool started_from_context_menu,
      bool has_user_gesture,
      bool text_fragment_token,
      ::network::mojom::CSPDisposition should_check_main_world_csp,
      std::vector<int32_t> initiator_origin_trial_features,
      const std::string& href_translate,
      bool is_history_navigation_in_new_child_frame,
      ::base::TimeTicks input_start,
      ::network::mojom::RequestDestination request_destination);

CommonNavigationParams(const CommonNavigationParams&) = delete;
CommonNavigationParams& operator=(const CommonNavigationParams&) = delete;

  ~CommonNavigationParams();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = CommonNavigationParamsPtr>
  CommonNavigationParamsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, CommonNavigationParams::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, CommonNavigationParams::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, CommonNavigationParams::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        CommonNavigationParams::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::CommonNavigationParams_UnserializedMessageContext<
            UserType, CommonNavigationParams::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<CommonNavigationParams::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return CommonNavigationParams::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::CommonNavigationParams_UnserializedMessageContext<
            UserType, CommonNavigationParams::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<CommonNavigationParams::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::GURL url;
  
  std::optional<::url::Origin> initiator_origin;
  
  std::optional<::GURL> initiator_base_url;
  
  ::blink::mojom::ReferrerPtr referrer;
  
  int32_t transition;
  
  NavigationType navigation_type;
  
  ::blink::NavigationDownloadPolicy download_policy;
  
  bool should_replace_current_entry;
  
  ::GURL base_url_for_data_url;
  
  ::base::TimeTicks actual_navigation_start;
  
  ::base::TimeTicks navigation_start;
  
  std::string method;
  
  ::scoped_refptr<::network::ResourceRequestBody> post_data;
  
  ::network::mojom::SourceLocationPtr source_location;
  
  bool started_from_context_menu;
  
  bool has_user_gesture;
  
  bool text_fragment_token;
  
  ::network::mojom::CSPDisposition should_check_main_world_csp;
  
  std::vector<int32_t> initiator_origin_trial_features;
  
  std::string href_translate;
  
  bool is_history_navigation_in_new_child_frame;
  
  ::base::TimeTicks input_start;
  
  ::network::mojom::RequestDestination request_destination;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, CommonNavigationParams::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, CommonNavigationParams::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, CommonNavigationParams::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, CommonNavigationParams::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_COMMON_EXPORT NavigationTiming {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<NavigationTiming, T>::value>;
  using DataView = NavigationTimingDataView;
  using Data_ = internal::NavigationTiming_Data;

  template <typename... Args>
  static NavigationTimingPtr New(Args&&... args) {
    return NavigationTimingPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static NavigationTimingPtr From(const U& u) {
    return mojo::TypeConverter<NavigationTimingPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, NavigationTiming>::Convert(*this);
  }


  NavigationTiming();

  NavigationTiming(
      ::base::TimeTicks redirect_start,
      ::base::TimeTicks redirect_end,
      ::base::TimeTicks fetch_start,
      ParentResourceTimingAccess parent_resource_timing_access);


  ~NavigationTiming();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = NavigationTimingPtr>
  NavigationTimingPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, NavigationTiming::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, NavigationTiming::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, NavigationTiming::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        NavigationTiming::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        NavigationTiming::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        NavigationTiming::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::NavigationTiming_UnserializedMessageContext<
            UserType, NavigationTiming::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<NavigationTiming::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return NavigationTiming::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::NavigationTiming_UnserializedMessageContext<
            UserType, NavigationTiming::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<NavigationTiming::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::base::TimeTicks redirect_start;
  
  ::base::TimeTicks redirect_end;
  
  ::base::TimeTicks fetch_start;
  
  ParentResourceTimingAccess parent_resource_timing_access;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, NavigationTiming::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, NavigationTiming::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, NavigationTiming::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, NavigationTiming::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_COMMON_EXPORT OldPageInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<OldPageInfo, T>::value>;
  using DataView = OldPageInfoDataView;
  using Data_ = internal::OldPageInfo_Data;

  template <typename... Args>
  static OldPageInfoPtr New(Args&&... args) {
    return OldPageInfoPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static OldPageInfoPtr From(const U& u) {
    return mojo::TypeConverter<OldPageInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, OldPageInfo>::Convert(*this);
  }


  OldPageInfo();

  OldPageInfo(
      const ::blink::LocalFrameToken& frame_token_for_old_main_frame,
      ::blink::mojom::PageLifecycleStatePtr new_lifecycle_state_for_old_page);

OldPageInfo(const OldPageInfo&) = delete;
OldPageInfo& operator=(const OldPageInfo&) = delete;

  ~OldPageInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = OldPageInfoPtr>
  OldPageInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, OldPageInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, OldPageInfo::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, OldPageInfo::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        OldPageInfo::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        OldPageInfo::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        OldPageInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::OldPageInfo_UnserializedMessageContext<
            UserType, OldPageInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<OldPageInfo::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return OldPageInfo::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::OldPageInfo_UnserializedMessageContext<
            UserType, OldPageInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<OldPageInfo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::LocalFrameToken frame_token_for_old_main_frame;
  
  ::blink::mojom::PageLifecycleStatePtr new_lifecycle_state_for_old_page;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, OldPageInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, OldPageInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, OldPageInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, OldPageInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_COMMON_EXPORT CommitNavigationParams {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<CommitNavigationParams, T>::value>;
  using DataView = CommitNavigationParamsDataView;
  using Data_ = internal::CommitNavigationParams_Data;

  template <typename... Args>
  static CommitNavigationParamsPtr New(Args&&... args) {
    return CommitNavigationParamsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static CommitNavigationParamsPtr From(const U& u) {
    return mojo::TypeConverter<CommitNavigationParamsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, CommitNavigationParams>::Convert(*this);
  }


  CommitNavigationParams();

  CommitNavigationParams(
      const ::url::Origin& origin_to_commit,
      const ::blink::StorageKey& storage_key,
      bool is_overriding_user_agent,
      std::vector<::GURL> redirects,
      std::vector<::network::mojom::URLResponseHeadPtr> redirect_response,
      std::vector<::net::RedirectInfo> redirect_infos,
      const std::string& post_content_type,
      const ::GURL& original_url,
      const std::string& original_method,
      bool can_load_local_resources,
      const std::string& page_state,
      int32_t nav_entry_id,
      const base::flat_map<std::string, bool>& subframe_unique_names,
      bool intended_as_new_entry,
      int32_t pending_history_list_index,
      int32_t current_history_list_index,
      int32_t current_history_list_length,
      bool was_discarded,
      bool is_view_source,
      bool should_clear_history_list,
      NavigationTimingPtr navigation_timing,
      ::blink::mojom::WasActivatedOption was_activated,
      const ::base::UnguessableToken& navigation_token,
      std::vector<::blink::mojom::PrefetchedSignedExchangeInfoPtr> prefetched_signed_exchanges,
      bool is_browser_initiated,
      bool has_ua_visual_transition,
      int64_t document_ukm_source_id,
      const ::blink::FramePolicy& frame_policy,
      std::vector<std::string> force_enabled_origin_trials,
      bool origin_agent_cluster,
      bool origin_agent_cluster_left_as_default,
      std::vector<::network::mojom::WebClientHintsType> enabled_client_hints,
      bool is_cross_site_cross_browsing_context_group,
      bool should_have_sticky_user_activation,
      OldPageInfoPtr old_page_info,
      int32_t http_response_code,
      ::blink::mojom::NavigationApiHistoryEntryArraysPtr navigation_api_history_entry_arrays,
      std::vector<::GURL> early_hints_preloaded_resources,
      ::base::TimeTicks commit_sent,
      const std::string& srcdoc_value,
      bool is_load_data_with_base_url,
      bool ancestor_or_self_has_cspee,
      const std::string& reduced_accept_language,
      ::network::mojom::NavigationDeliveryType navigation_delivery_type,
      const std::optional<::blink::ViewTransitionState>& view_transition_state,
      std::optional<::blink::scheduler::TaskAttributionId> soft_navigation_heuristics_task_id,
      const base::flat_map<::blink::mojom::RuntimeFeature, bool>& modified_runtime_features,
      const std::optional<::blink::FencedFrame::RedactedFencedFrameProperties>& fenced_frame_properties,
      ::blink::mojom::BackForwardCacheNotRestoredReasonsPtr not_restored_reasons,
      ::net::StorageAccessApiStatus load_with_storage_access,
      const std::optional<::base::UnguessableToken>& browsing_context_group_token,
      ::blink::mojom::LCPCriticalPathPredictorNavigationTimeHintPtr lcpp_hint,
      ::blink::mojom::RendererContentSettingsPtr content_settings,
      std::optional<uint64_t> visited_link_salt,
      const std::optional<::viz::LocalSurfaceId>& local_surface_id,
      const std::optional<base::flat_map<::blink::mojom::PermissionName, ::blink::mojom::PermissionStatus>>& initial_permission_statuses,
      bool should_skip_screenshot,
      bool force_new_document_sequence_number,
      const ::base::UnguessableToken& navigation_metrics_token,
      const std::optional<::blink::LocalFrameToken>& commit_target_frame_token,
      bool is_initial_webui);

CommitNavigationParams(const CommitNavigationParams&) = delete;
CommitNavigationParams& operator=(const CommitNavigationParams&) = delete;

  ~CommitNavigationParams();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = CommitNavigationParamsPtr>
  CommitNavigationParamsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, CommitNavigationParams::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, CommitNavigationParams::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, CommitNavigationParams::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        CommitNavigationParams::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::CommitNavigationParams_UnserializedMessageContext<
            UserType, CommitNavigationParams::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<CommitNavigationParams::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return CommitNavigationParams::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::CommitNavigationParams_UnserializedMessageContext<
            UserType, CommitNavigationParams::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<CommitNavigationParams::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::url::Origin origin_to_commit;
  
  ::blink::StorageKey storage_key;
  
  bool is_overriding_user_agent;
  
  std::vector<::GURL> redirects;
  
  std::vector<::network::mojom::URLResponseHeadPtr> redirect_response;
  
  std::vector<::net::RedirectInfo> redirect_infos;
  
  std::string post_content_type;
  
  ::GURL original_url;
  
  std::string original_method;
  
  bool can_load_local_resources;
  
  std::string page_state;
  
  int32_t nav_entry_id;
  
  base::flat_map<std::string, bool> subframe_unique_names;
  
  bool intended_as_new_entry;
  
  int32_t pending_history_list_index;
  
  int32_t current_history_list_index;
  
  int32_t current_history_list_length;
  
  bool was_discarded;
  
  bool is_view_source;
  
  bool should_clear_history_list;
  
  NavigationTimingPtr navigation_timing;
  
  ::blink::mojom::WasActivatedOption was_activated;
  
  ::base::UnguessableToken navigation_token;
  
  std::vector<::blink::mojom::PrefetchedSignedExchangeInfoPtr> prefetched_signed_exchanges;
  
  bool is_browser_initiated;
  
  bool has_ua_visual_transition;
  
  int64_t document_ukm_source_id;
  
  ::blink::FramePolicy frame_policy;
  
  std::vector<std::string> force_enabled_origin_trials;
  
  bool origin_agent_cluster;
  
  bool origin_agent_cluster_left_as_default;
  
  std::vector<::network::mojom::WebClientHintsType> enabled_client_hints;
  
  bool is_cross_site_cross_browsing_context_group;
  
  bool should_have_sticky_user_activation;
  
  OldPageInfoPtr old_page_info;
  
  int32_t http_response_code;
  
  ::blink::mojom::NavigationApiHistoryEntryArraysPtr navigation_api_history_entry_arrays;
  
  std::vector<::GURL> early_hints_preloaded_resources;
  
  ::base::TimeTicks commit_sent;
  
  std::string srcdoc_value;
  
  bool is_load_data_with_base_url;
  
  bool ancestor_or_self_has_cspee;
  
  std::string reduced_accept_language;
  
  ::network::mojom::NavigationDeliveryType navigation_delivery_type;
  
  std::optional<::blink::ViewTransitionState> view_transition_state;
  
  std::optional<::blink::scheduler::TaskAttributionId> soft_navigation_heuristics_task_id;
  
  base::flat_map<::blink::mojom::RuntimeFeature, bool> modified_runtime_features;
  
  std::optional<::blink::FencedFrame::RedactedFencedFrameProperties> fenced_frame_properties;
  
  ::blink::mojom::BackForwardCacheNotRestoredReasonsPtr not_restored_reasons;
  
  ::net::StorageAccessApiStatus load_with_storage_access;
  
  std::optional<::base::UnguessableToken> browsing_context_group_token;
  
  ::blink::mojom::LCPCriticalPathPredictorNavigationTimeHintPtr lcpp_hint;
  
  ::blink::mojom::RendererContentSettingsPtr content_settings;
  
  std::optional<uint64_t> visited_link_salt;
  
  std::optional<::viz::LocalSurfaceId> local_surface_id;
  
  std::optional<base::flat_map<::blink::mojom::PermissionName, ::blink::mojom::PermissionStatus>> initial_permission_statuses;
  
  bool should_skip_screenshot;
  
  bool force_new_document_sequence_number;
  
  ::base::UnguessableToken navigation_metrics_token;
  
  std::optional<::blink::LocalFrameToken> commit_target_frame_token;
  
  bool is_initial_webui;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, CommitNavigationParams::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, CommitNavigationParams::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, CommitNavigationParams::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, CommitNavigationParams::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_COMMON_EXPORT PageSwapEventParams {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<PageSwapEventParams, T>::value>;
  using DataView = PageSwapEventParamsDataView;
  using Data_ = internal::PageSwapEventParams_Data;

  template <typename... Args>
  static PageSwapEventParamsPtr New(Args&&... args) {
    return PageSwapEventParamsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PageSwapEventParamsPtr From(const U& u) {
    return mojo::TypeConverter<PageSwapEventParamsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PageSwapEventParams>::Convert(*this);
  }


  PageSwapEventParams();

  PageSwapEventParams(
      const ::GURL& url,
      const std::string& page_state,
      NavigationTypeForNavigationApi navigation_type);


  ~PageSwapEventParams();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PageSwapEventParamsPtr>
  PageSwapEventParamsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, PageSwapEventParams::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, PageSwapEventParams::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, PageSwapEventParams::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PageSwapEventParams::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PageSwapEventParams::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PageSwapEventParams::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::PageSwapEventParams_UnserializedMessageContext<
            UserType, PageSwapEventParams::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<PageSwapEventParams::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return PageSwapEventParams::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::PageSwapEventParams_UnserializedMessageContext<
            UserType, PageSwapEventParams::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<PageSwapEventParams::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::GURL url;
  
  std::string page_state;
  
  NavigationTypeForNavigationApi navigation_type;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, PageSwapEventParams::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, PageSwapEventParams::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, PageSwapEventParams::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, PageSwapEventParams::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
BeginNavigationParamsPtr BeginNavigationParams::Clone() const {
  return New(
      mojo::Clone(initiator_frame_token),
      mojo::Clone(headers),
      mojo::Clone(load_flags),
      mojo::Clone(skip_service_worker),
      mojo::Clone(request_context_type),
      mojo::Clone(mixed_content_context_type),
      mojo::Clone(is_form_submission),
      mojo::Clone(was_initiated_by_link_click),
      mojo::Clone(force_history_push),
      mojo::Clone(searchable_form_url),
      mojo::Clone(searchable_form_encoding),
      mojo::Clone(client_side_redirect_url),
      mojo::Clone(devtools_initiator),
      mojo::Clone(trust_token_params),
      mojo::Clone(impression),
      mojo::Clone(before_unload_start),
      mojo::Clone(before_unload_end),
      mojo::Clone(initiator_activation_and_ad_status),
      mojo::Clone(is_container_initiated),
      mojo::Clone(storage_access_api_status),
      mojo::Clone(has_rel_opener)
  );
}

template <typename T, BeginNavigationParams::EnableIfSame<T>*>
bool BeginNavigationParams::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->initiator_frame_token, other_struct.initiator_frame_token))
    return false;
  if (!mojo::Equals(this->headers, other_struct.headers))
    return false;
  if (!mojo::Equals(this->load_flags, other_struct.load_flags))
    return false;
  if (!mojo::Equals(this->skip_service_worker, other_struct.skip_service_worker))
    return false;
  if (!mojo::Equals(this->request_context_type, other_struct.request_context_type))
    return false;
  if (!mojo::Equals(this->mixed_content_context_type, other_struct.mixed_content_context_type))
    return false;
  if (!mojo::Equals(this->is_form_submission, other_struct.is_form_submission))
    return false;
  if (!mojo::Equals(this->was_initiated_by_link_click, other_struct.was_initiated_by_link_click))
    return false;
  if (!mojo::Equals(this->force_history_push, other_struct.force_history_push))
    return false;
  if (!mojo::Equals(this->searchable_form_url, other_struct.searchable_form_url))
    return false;
  if (!mojo::Equals(this->searchable_form_encoding, other_struct.searchable_form_encoding))
    return false;
  if (!mojo::Equals(this->client_side_redirect_url, other_struct.client_side_redirect_url))
    return false;
  if (!mojo::Equals(this->devtools_initiator, other_struct.devtools_initiator))
    return false;
  if (!mojo::Equals(this->trust_token_params, other_struct.trust_token_params))
    return false;
  if (!mojo::Equals(this->impression, other_struct.impression))
    return false;
  if (!mojo::Equals(this->before_unload_start, other_struct.before_unload_start))
    return false;
  if (!mojo::Equals(this->before_unload_end, other_struct.before_unload_end))
    return false;
  if (!mojo::Equals(this->initiator_activation_and_ad_status, other_struct.initiator_activation_and_ad_status))
    return false;
  if (!mojo::Equals(this->is_container_initiated, other_struct.is_container_initiated))
    return false;
  if (!mojo::Equals(this->storage_access_api_status, other_struct.storage_access_api_status))
    return false;
  if (!mojo::Equals(this->has_rel_opener, other_struct.has_rel_opener))
    return false;
  return true;
}

template <typename T, BeginNavigationParams::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.initiator_frame_token < rhs.initiator_frame_token)
    return true;
  if (rhs.initiator_frame_token < lhs.initiator_frame_token)
    return false;
  if (lhs.headers < rhs.headers)
    return true;
  if (rhs.headers < lhs.headers)
    return false;
  if (lhs.load_flags < rhs.load_flags)
    return true;
  if (rhs.load_flags < lhs.load_flags)
    return false;
  if (lhs.skip_service_worker < rhs.skip_service_worker)
    return true;
  if (rhs.skip_service_worker < lhs.skip_service_worker)
    return false;
  if (lhs.request_context_type < rhs.request_context_type)
    return true;
  if (rhs.request_context_type < lhs.request_context_type)
    return false;
  if (lhs.mixed_content_context_type < rhs.mixed_content_context_type)
    return true;
  if (rhs.mixed_content_context_type < lhs.mixed_content_context_type)
    return false;
  if (lhs.is_form_submission < rhs.is_form_submission)
    return true;
  if (rhs.is_form_submission < lhs.is_form_submission)
    return false;
  if (lhs.was_initiated_by_link_click < rhs.was_initiated_by_link_click)
    return true;
  if (rhs.was_initiated_by_link_click < lhs.was_initiated_by_link_click)
    return false;
  if (lhs.force_history_push < rhs.force_history_push)
    return true;
  if (rhs.force_history_push < lhs.force_history_push)
    return false;
  if (lhs.searchable_form_url < rhs.searchable_form_url)
    return true;
  if (rhs.searchable_form_url < lhs.searchable_form_url)
    return false;
  if (lhs.searchable_form_encoding < rhs.searchable_form_encoding)
    return true;
  if (rhs.searchable_form_encoding < lhs.searchable_form_encoding)
    return false;
  if (lhs.client_side_redirect_url < rhs.client_side_redirect_url)
    return true;
  if (rhs.client_side_redirect_url < lhs.client_side_redirect_url)
    return false;
  if (lhs.devtools_initiator < rhs.devtools_initiator)
    return true;
  if (rhs.devtools_initiator < lhs.devtools_initiator)
    return false;
  if (lhs.trust_token_params < rhs.trust_token_params)
    return true;
  if (rhs.trust_token_params < lhs.trust_token_params)
    return false;
  if (lhs.impression < rhs.impression)
    return true;
  if (rhs.impression < lhs.impression)
    return false;
  if (lhs.before_unload_start < rhs.before_unload_start)
    return true;
  if (rhs.before_unload_start < lhs.before_unload_start)
    return false;
  if (lhs.before_unload_end < rhs.before_unload_end)
    return true;
  if (rhs.before_unload_end < lhs.before_unload_end)
    return false;
  if (lhs.initiator_activation_and_ad_status < rhs.initiator_activation_and_ad_status)
    return true;
  if (rhs.initiator_activation_and_ad_status < lhs.initiator_activation_and_ad_status)
    return false;
  if (lhs.is_container_initiated < rhs.is_container_initiated)
    return true;
  if (rhs.is_container_initiated < lhs.is_container_initiated)
    return false;
  if (lhs.storage_access_api_status < rhs.storage_access_api_status)
    return true;
  if (rhs.storage_access_api_status < lhs.storage_access_api_status)
    return false;
  if (lhs.has_rel_opener < rhs.has_rel_opener)
    return true;
  if (rhs.has_rel_opener < lhs.has_rel_opener)
    return false;
  return false;
}
template <typename StructPtrType>
CommonNavigationParamsPtr CommonNavigationParams::Clone() const {
  return New(
      mojo::Clone(url),
      mojo::Clone(initiator_origin),
      mojo::Clone(initiator_base_url),
      mojo::Clone(referrer),
      mojo::Clone(transition),
      mojo::Clone(navigation_type),
      mojo::Clone(download_policy),
      mojo::Clone(should_replace_current_entry),
      mojo::Clone(base_url_for_data_url),
      mojo::Clone(actual_navigation_start),
      mojo::Clone(navigation_start),
      mojo::Clone(method),
      mojo::Clone(post_data),
      mojo::Clone(source_location),
      mojo::Clone(started_from_context_menu),
      mojo::Clone(has_user_gesture),
      mojo::Clone(text_fragment_token),
      mojo::Clone(should_check_main_world_csp),
      mojo::Clone(initiator_origin_trial_features),
      mojo::Clone(href_translate),
      mojo::Clone(is_history_navigation_in_new_child_frame),
      mojo::Clone(input_start),
      mojo::Clone(request_destination)
  );
}

template <typename T, CommonNavigationParams::EnableIfSame<T>*>
bool CommonNavigationParams::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->url, other_struct.url))
    return false;
  if (!mojo::Equals(this->initiator_origin, other_struct.initiator_origin))
    return false;
  if (!mojo::Equals(this->initiator_base_url, other_struct.initiator_base_url))
    return false;
  if (!mojo::Equals(this->referrer, other_struct.referrer))
    return false;
  if (!mojo::Equals(this->transition, other_struct.transition))
    return false;
  if (!mojo::Equals(this->navigation_type, other_struct.navigation_type))
    return false;
  if (!mojo::Equals(this->download_policy, other_struct.download_policy))
    return false;
  if (!mojo::Equals(this->should_replace_current_entry, other_struct.should_replace_current_entry))
    return false;
  if (!mojo::Equals(this->base_url_for_data_url, other_struct.base_url_for_data_url))
    return false;
  if (!mojo::Equals(this->actual_navigation_start, other_struct.actual_navigation_start))
    return false;
  if (!mojo::Equals(this->navigation_start, other_struct.navigation_start))
    return false;
  if (!mojo::Equals(this->method, other_struct.method))
    return false;
  if (!mojo::Equals(this->post_data, other_struct.post_data))
    return false;
  if (!mojo::Equals(this->source_location, other_struct.source_location))
    return false;
  if (!mojo::Equals(this->started_from_context_menu, other_struct.started_from_context_menu))
    return false;
  if (!mojo::Equals(this->has_user_gesture, other_struct.has_user_gesture))
    return false;
  if (!mojo::Equals(this->text_fragment_token, other_struct.text_fragment_token))
    return false;
  if (!mojo::Equals(this->should_check_main_world_csp, other_struct.should_check_main_world_csp))
    return false;
  if (!mojo::Equals(this->initiator_origin_trial_features, other_struct.initiator_origin_trial_features))
    return false;
  if (!mojo::Equals(this->href_translate, other_struct.href_translate))
    return false;
  if (!mojo::Equals(this->is_history_navigation_in_new_child_frame, other_struct.is_history_navigation_in_new_child_frame))
    return false;
  if (!mojo::Equals(this->input_start, other_struct.input_start))
    return false;
  if (!mojo::Equals(this->request_destination, other_struct.request_destination))
    return false;
  return true;
}

template <typename T, CommonNavigationParams::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.url < rhs.url)
    return true;
  if (rhs.url < lhs.url)
    return false;
  if (lhs.initiator_origin < rhs.initiator_origin)
    return true;
  if (rhs.initiator_origin < lhs.initiator_origin)
    return false;
  if (lhs.initiator_base_url < rhs.initiator_base_url)
    return true;
  if (rhs.initiator_base_url < lhs.initiator_base_url)
    return false;
  if (lhs.referrer < rhs.referrer)
    return true;
  if (rhs.referrer < lhs.referrer)
    return false;
  if (lhs.transition < rhs.transition)
    return true;
  if (rhs.transition < lhs.transition)
    return false;
  if (lhs.navigation_type < rhs.navigation_type)
    return true;
  if (rhs.navigation_type < lhs.navigation_type)
    return false;
  if (lhs.download_policy < rhs.download_policy)
    return true;
  if (rhs.download_policy < lhs.download_policy)
    return false;
  if (lhs.should_replace_current_entry < rhs.should_replace_current_entry)
    return true;
  if (rhs.should_replace_current_entry < lhs.should_replace_current_entry)
    return false;
  if (lhs.base_url_for_data_url < rhs.base_url_for_data_url)
    return true;
  if (rhs.base_url_for_data_url < lhs.base_url_for_data_url)
    return false;
  if (lhs.actual_navigation_start < rhs.actual_navigation_start)
    return true;
  if (rhs.actual_navigation_start < lhs.actual_navigation_start)
    return false;
  if (lhs.navigation_start < rhs.navigation_start)
    return true;
  if (rhs.navigation_start < lhs.navigation_start)
    return false;
  if (lhs.method < rhs.method)
    return true;
  if (rhs.method < lhs.method)
    return false;
  if (lhs.post_data < rhs.post_data)
    return true;
  if (rhs.post_data < lhs.post_data)
    return false;
  if (lhs.source_location < rhs.source_location)
    return true;
  if (rhs.source_location < lhs.source_location)
    return false;
  if (lhs.started_from_context_menu < rhs.started_from_context_menu)
    return true;
  if (rhs.started_from_context_menu < lhs.started_from_context_menu)
    return false;
  if (lhs.has_user_gesture < rhs.has_user_gesture)
    return true;
  if (rhs.has_user_gesture < lhs.has_user_gesture)
    return false;
  if (lhs.text_fragment_token < rhs.text_fragment_token)
    return true;
  if (rhs.text_fragment_token < lhs.text_fragment_token)
    return false;
  if (lhs.should_check_main_world_csp < rhs.should_check_main_world_csp)
    return true;
  if (rhs.should_check_main_world_csp < lhs.should_check_main_world_csp)
    return false;
  if (lhs.initiator_origin_trial_features < rhs.initiator_origin_trial_features)
    return true;
  if (rhs.initiator_origin_trial_features < lhs.initiator_origin_trial_features)
    return false;
  if (lhs.href_translate < rhs.href_translate)
    return true;
  if (rhs.href_translate < lhs.href_translate)
    return false;
  if (lhs.is_history_navigation_in_new_child_frame < rhs.is_history_navigation_in_new_child_frame)
    return true;
  if (rhs.is_history_navigation_in_new_child_frame < lhs.is_history_navigation_in_new_child_frame)
    return false;
  if (lhs.input_start < rhs.input_start)
    return true;
  if (rhs.input_start < lhs.input_start)
    return false;
  if (lhs.request_destination < rhs.request_destination)
    return true;
  if (rhs.request_destination < lhs.request_destination)
    return false;
  return false;
}
template <typename StructPtrType>
NavigationTimingPtr NavigationTiming::Clone() const {
  return New(
      mojo::Clone(redirect_start),
      mojo::Clone(redirect_end),
      mojo::Clone(fetch_start),
      mojo::Clone(parent_resource_timing_access)
  );
}

template <typename T, NavigationTiming::EnableIfSame<T>*>
bool NavigationTiming::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->redirect_start, other_struct.redirect_start))
    return false;
  if (!mojo::Equals(this->redirect_end, other_struct.redirect_end))
    return false;
  if (!mojo::Equals(this->fetch_start, other_struct.fetch_start))
    return false;
  if (!mojo::Equals(this->parent_resource_timing_access, other_struct.parent_resource_timing_access))
    return false;
  return true;
}

template <typename T, NavigationTiming::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.redirect_start < rhs.redirect_start)
    return true;
  if (rhs.redirect_start < lhs.redirect_start)
    return false;
  if (lhs.redirect_end < rhs.redirect_end)
    return true;
  if (rhs.redirect_end < lhs.redirect_end)
    return false;
  if (lhs.fetch_start < rhs.fetch_start)
    return true;
  if (rhs.fetch_start < lhs.fetch_start)
    return false;
  if (lhs.parent_resource_timing_access < rhs.parent_resource_timing_access)
    return true;
  if (rhs.parent_resource_timing_access < lhs.parent_resource_timing_access)
    return false;
  return false;
}
template <typename StructPtrType>
OldPageInfoPtr OldPageInfo::Clone() const {
  return New(
      mojo::Clone(frame_token_for_old_main_frame),
      mojo::Clone(new_lifecycle_state_for_old_page)
  );
}

template <typename T, OldPageInfo::EnableIfSame<T>*>
bool OldPageInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->frame_token_for_old_main_frame, other_struct.frame_token_for_old_main_frame))
    return false;
  if (!mojo::Equals(this->new_lifecycle_state_for_old_page, other_struct.new_lifecycle_state_for_old_page))
    return false;
  return true;
}

template <typename T, OldPageInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.frame_token_for_old_main_frame < rhs.frame_token_for_old_main_frame)
    return true;
  if (rhs.frame_token_for_old_main_frame < lhs.frame_token_for_old_main_frame)
    return false;
  if (lhs.new_lifecycle_state_for_old_page < rhs.new_lifecycle_state_for_old_page)
    return true;
  if (rhs.new_lifecycle_state_for_old_page < lhs.new_lifecycle_state_for_old_page)
    return false;
  return false;
}
template <typename StructPtrType>
CommitNavigationParamsPtr CommitNavigationParams::Clone() const {
  return New(
      mojo::Clone(origin_to_commit),
      mojo::Clone(storage_key),
      mojo::Clone(is_overriding_user_agent),
      mojo::Clone(redirects),
      mojo::Clone(redirect_response),
      mojo::Clone(redirect_infos),
      mojo::Clone(post_content_type),
      mojo::Clone(original_url),
      mojo::Clone(original_method),
      mojo::Clone(can_load_local_resources),
      mojo::Clone(page_state),
      mojo::Clone(nav_entry_id),
      mojo::Clone(subframe_unique_names),
      mojo::Clone(intended_as_new_entry),
      mojo::Clone(pending_history_list_index),
      mojo::Clone(current_history_list_index),
      mojo::Clone(current_history_list_length),
      mojo::Clone(was_discarded),
      mojo::Clone(is_view_source),
      mojo::Clone(should_clear_history_list),
      mojo::Clone(navigation_timing),
      mojo::Clone(was_activated),
      mojo::Clone(navigation_token),
      mojo::Clone(prefetched_signed_exchanges),
      mojo::Clone(is_browser_initiated),
      mojo::Clone(has_ua_visual_transition),
      mojo::Clone(document_ukm_source_id),
      mojo::Clone(frame_policy),
      mojo::Clone(force_enabled_origin_trials),
      mojo::Clone(origin_agent_cluster),
      mojo::Clone(origin_agent_cluster_left_as_default),
      mojo::Clone(enabled_client_hints),
      mojo::Clone(is_cross_site_cross_browsing_context_group),
      mojo::Clone(should_have_sticky_user_activation),
      mojo::Clone(old_page_info),
      mojo::Clone(http_response_code),
      mojo::Clone(navigation_api_history_entry_arrays),
      mojo::Clone(early_hints_preloaded_resources),
      mojo::Clone(commit_sent),
      mojo::Clone(srcdoc_value),
      mojo::Clone(is_load_data_with_base_url),
      mojo::Clone(ancestor_or_self_has_cspee),
      mojo::Clone(reduced_accept_language),
      mojo::Clone(navigation_delivery_type),
      mojo::Clone(view_transition_state),
      mojo::Clone(soft_navigation_heuristics_task_id),
      mojo::Clone(modified_runtime_features),
      mojo::Clone(fenced_frame_properties),
      mojo::Clone(not_restored_reasons),
      mojo::Clone(load_with_storage_access),
      mojo::Clone(browsing_context_group_token),
      mojo::Clone(lcpp_hint),
      mojo::Clone(content_settings),
      mojo::Clone(visited_link_salt),
      mojo::Clone(local_surface_id),
      mojo::Clone(initial_permission_statuses),
      mojo::Clone(should_skip_screenshot),
      mojo::Clone(force_new_document_sequence_number),
      mojo::Clone(navigation_metrics_token),
      mojo::Clone(commit_target_frame_token),
      mojo::Clone(is_initial_webui)
  );
}

template <typename T, CommitNavigationParams::EnableIfSame<T>*>
bool CommitNavigationParams::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->origin_to_commit, other_struct.origin_to_commit))
    return false;
  if (!mojo::Equals(this->storage_key, other_struct.storage_key))
    return false;
  if (!mojo::Equals(this->is_overriding_user_agent, other_struct.is_overriding_user_agent))
    return false;
  if (!mojo::Equals(this->redirects, other_struct.redirects))
    return false;
  if (!mojo::Equals(this->redirect_response, other_struct.redirect_response))
    return false;
  if (!mojo::Equals(this->redirect_infos, other_struct.redirect_infos))
    return false;
  if (!mojo::Equals(this->post_content_type, other_struct.post_content_type))
    return false;
  if (!mojo::Equals(this->original_url, other_struct.original_url))
    return false;
  if (!mojo::Equals(this->original_method, other_struct.original_method))
    return false;
  if (!mojo::Equals(this->can_load_local_resources, other_struct.can_load_local_resources))
    return false;
  if (!mojo::Equals(this->page_state, other_struct.page_state))
    return false;
  if (!mojo::Equals(this->nav_entry_id, other_struct.nav_entry_id))
    return false;
  if (!mojo::Equals(this->subframe_unique_names, other_struct.subframe_unique_names))
    return false;
  if (!mojo::Equals(this->intended_as_new_entry, other_struct.intended_as_new_entry))
    return false;
  if (!mojo::Equals(this->pending_history_list_index, other_struct.pending_history_list_index))
    return false;
  if (!mojo::Equals(this->current_history_list_index, other_struct.current_history_list_index))
    return false;
  if (!mojo::Equals(this->current_history_list_length, other_struct.current_history_list_length))
    return false;
  if (!mojo::Equals(this->was_discarded, other_struct.was_discarded))
    return false;
  if (!mojo::Equals(this->is_view_source, other_struct.is_view_source))
    return false;
  if (!mojo::Equals(this->should_clear_history_list, other_struct.should_clear_history_list))
    return false;
  if (!mojo::Equals(this->navigation_timing, other_struct.navigation_timing))
    return false;
  if (!mojo::Equals(this->was_activated, other_struct.was_activated))
    return false;
  if (!mojo::Equals(this->navigation_token, other_struct.navigation_token))
    return false;
  if (!mojo::Equals(this->prefetched_signed_exchanges, other_struct.prefetched_signed_exchanges))
    return false;
  if (!mojo::Equals(this->is_browser_initiated, other_struct.is_browser_initiated))
    return false;
  if (!mojo::Equals(this->has_ua_visual_transition, other_struct.has_ua_visual_transition))
    return false;
  if (!mojo::Equals(this->document_ukm_source_id, other_struct.document_ukm_source_id))
    return false;
  if (!mojo::Equals(this->frame_policy, other_struct.frame_policy))
    return false;
  if (!mojo::Equals(this->force_enabled_origin_trials, other_struct.force_enabled_origin_trials))
    return false;
  if (!mojo::Equals(this->origin_agent_cluster, other_struct.origin_agent_cluster))
    return false;
  if (!mojo::Equals(this->origin_agent_cluster_left_as_default, other_struct.origin_agent_cluster_left_as_default))
    return false;
  if (!mojo::Equals(this->enabled_client_hints, other_struct.enabled_client_hints))
    return false;
  if (!mojo::Equals(this->is_cross_site_cross_browsing_context_group, other_struct.is_cross_site_cross_browsing_context_group))
    return false;
  if (!mojo::Equals(this->should_have_sticky_user_activation, other_struct.should_have_sticky_user_activation))
    return false;
  if (!mojo::Equals(this->old_page_info, other_struct.old_page_info))
    return false;
  if (!mojo::Equals(this->http_response_code, other_struct.http_response_code))
    return false;
  if (!mojo::Equals(this->navigation_api_history_entry_arrays, other_struct.navigation_api_history_entry_arrays))
    return false;
  if (!mojo::Equals(this->early_hints_preloaded_resources, other_struct.early_hints_preloaded_resources))
    return false;
  if (!mojo::Equals(this->commit_sent, other_struct.commit_sent))
    return false;
  if (!mojo::Equals(this->srcdoc_value, other_struct.srcdoc_value))
    return false;
  if (!mojo::Equals(this->is_load_data_with_base_url, other_struct.is_load_data_with_base_url))
    return false;
  if (!mojo::Equals(this->ancestor_or_self_has_cspee, other_struct.ancestor_or_self_has_cspee))
    return false;
  if (!mojo::Equals(this->reduced_accept_language, other_struct.reduced_accept_language))
    return false;
  if (!mojo::Equals(this->navigation_delivery_type, other_struct.navigation_delivery_type))
    return false;
  if (!mojo::Equals(this->view_transition_state, other_struct.view_transition_state))
    return false;
  if (!mojo::Equals(this->soft_navigation_heuristics_task_id, other_struct.soft_navigation_heuristics_task_id))
    return false;
  if (!mojo::Equals(this->modified_runtime_features, other_struct.modified_runtime_features))
    return false;
  if (!mojo::Equals(this->fenced_frame_properties, other_struct.fenced_frame_properties))
    return false;
  if (!mojo::Equals(this->not_restored_reasons, other_struct.not_restored_reasons))
    return false;
  if (!mojo::Equals(this->load_with_storage_access, other_struct.load_with_storage_access))
    return false;
  if (!mojo::Equals(this->browsing_context_group_token, other_struct.browsing_context_group_token))
    return false;
  if (!mojo::Equals(this->lcpp_hint, other_struct.lcpp_hint))
    return false;
  if (!mojo::Equals(this->content_settings, other_struct.content_settings))
    return false;
  if (!mojo::Equals(this->visited_link_salt, other_struct.visited_link_salt))
    return false;
  if (!mojo::Equals(this->local_surface_id, other_struct.local_surface_id))
    return false;
  if (!mojo::Equals(this->initial_permission_statuses, other_struct.initial_permission_statuses))
    return false;
  if (!mojo::Equals(this->should_skip_screenshot, other_struct.should_skip_screenshot))
    return false;
  if (!mojo::Equals(this->force_new_document_sequence_number, other_struct.force_new_document_sequence_number))
    return false;
  if (!mojo::Equals(this->navigation_metrics_token, other_struct.navigation_metrics_token))
    return false;
  if (!mojo::Equals(this->commit_target_frame_token, other_struct.commit_target_frame_token))
    return false;
  if (!mojo::Equals(this->is_initial_webui, other_struct.is_initial_webui))
    return false;
  return true;
}

template <typename T, CommitNavigationParams::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.origin_to_commit < rhs.origin_to_commit)
    return true;
  if (rhs.origin_to_commit < lhs.origin_to_commit)
    return false;
  if (lhs.storage_key < rhs.storage_key)
    return true;
  if (rhs.storage_key < lhs.storage_key)
    return false;
  if (lhs.is_overriding_user_agent < rhs.is_overriding_user_agent)
    return true;
  if (rhs.is_overriding_user_agent < lhs.is_overriding_user_agent)
    return false;
  if (lhs.redirects < rhs.redirects)
    return true;
  if (rhs.redirects < lhs.redirects)
    return false;
  if (lhs.redirect_response < rhs.redirect_response)
    return true;
  if (rhs.redirect_response < lhs.redirect_response)
    return false;
  if (lhs.redirect_infos < rhs.redirect_infos)
    return true;
  if (rhs.redirect_infos < lhs.redirect_infos)
    return false;
  if (lhs.post_content_type < rhs.post_content_type)
    return true;
  if (rhs.post_content_type < lhs.post_content_type)
    return false;
  if (lhs.original_url < rhs.original_url)
    return true;
  if (rhs.original_url < lhs.original_url)
    return false;
  if (lhs.original_method < rhs.original_method)
    return true;
  if (rhs.original_method < lhs.original_method)
    return false;
  if (lhs.can_load_local_resources < rhs.can_load_local_resources)
    return true;
  if (rhs.can_load_local_resources < lhs.can_load_local_resources)
    return false;
  if (lhs.page_state < rhs.page_state)
    return true;
  if (rhs.page_state < lhs.page_state)
    return false;
  if (lhs.nav_entry_id < rhs.nav_entry_id)
    return true;
  if (rhs.nav_entry_id < lhs.nav_entry_id)
    return false;
  if (lhs.subframe_unique_names < rhs.subframe_unique_names)
    return true;
  if (rhs.subframe_unique_names < lhs.subframe_unique_names)
    return false;
  if (lhs.intended_as_new_entry < rhs.intended_as_new_entry)
    return true;
  if (rhs.intended_as_new_entry < lhs.intended_as_new_entry)
    return false;
  if (lhs.pending_history_list_index < rhs.pending_history_list_index)
    return true;
  if (rhs.pending_history_list_index < lhs.pending_history_list_index)
    return false;
  if (lhs.current_history_list_index < rhs.current_history_list_index)
    return true;
  if (rhs.current_history_list_index < lhs.current_history_list_index)
    return false;
  if (lhs.current_history_list_length < rhs.current_history_list_length)
    return true;
  if (rhs.current_history_list_length < lhs.current_history_list_length)
    return false;
  if (lhs.was_discarded < rhs.was_discarded)
    return true;
  if (rhs.was_discarded < lhs.was_discarded)
    return false;
  if (lhs.is_view_source < rhs.is_view_source)
    return true;
  if (rhs.is_view_source < lhs.is_view_source)
    return false;
  if (lhs.should_clear_history_list < rhs.should_clear_history_list)
    return true;
  if (rhs.should_clear_history_list < lhs.should_clear_history_list)
    return false;
  if (lhs.navigation_timing < rhs.navigation_timing)
    return true;
  if (rhs.navigation_timing < lhs.navigation_timing)
    return false;
  if (lhs.was_activated < rhs.was_activated)
    return true;
  if (rhs.was_activated < lhs.was_activated)
    return false;
  if (lhs.navigation_token < rhs.navigation_token)
    return true;
  if (rhs.navigation_token < lhs.navigation_token)
    return false;
  if (lhs.prefetched_signed_exchanges < rhs.prefetched_signed_exchanges)
    return true;
  if (rhs.prefetched_signed_exchanges < lhs.prefetched_signed_exchanges)
    return false;
  if (lhs.is_browser_initiated < rhs.is_browser_initiated)
    return true;
  if (rhs.is_browser_initiated < lhs.is_browser_initiated)
    return false;
  if (lhs.has_ua_visual_transition < rhs.has_ua_visual_transition)
    return true;
  if (rhs.has_ua_visual_transition < lhs.has_ua_visual_transition)
    return false;
  if (lhs.document_ukm_source_id < rhs.document_ukm_source_id)
    return true;
  if (rhs.document_ukm_source_id < lhs.document_ukm_source_id)
    return false;
  if (lhs.frame_policy < rhs.frame_policy)
    return true;
  if (rhs.frame_policy < lhs.frame_policy)
    return false;
  if (lhs.force_enabled_origin_trials < rhs.force_enabled_origin_trials)
    return true;
  if (rhs.force_enabled_origin_trials < lhs.force_enabled_origin_trials)
    return false;
  if (lhs.origin_agent_cluster < rhs.origin_agent_cluster)
    return true;
  if (rhs.origin_agent_cluster < lhs.origin_agent_cluster)
    return false;
  if (lhs.origin_agent_cluster_left_as_default < rhs.origin_agent_cluster_left_as_default)
    return true;
  if (rhs.origin_agent_cluster_left_as_default < lhs.origin_agent_cluster_left_as_default)
    return false;
  if (lhs.enabled_client_hints < rhs.enabled_client_hints)
    return true;
  if (rhs.enabled_client_hints < lhs.enabled_client_hints)
    return false;
  if (lhs.is_cross_site_cross_browsing_context_group < rhs.is_cross_site_cross_browsing_context_group)
    return true;
  if (rhs.is_cross_site_cross_browsing_context_group < lhs.is_cross_site_cross_browsing_context_group)
    return false;
  if (lhs.should_have_sticky_user_activation < rhs.should_have_sticky_user_activation)
    return true;
  if (rhs.should_have_sticky_user_activation < lhs.should_have_sticky_user_activation)
    return false;
  if (lhs.old_page_info < rhs.old_page_info)
    return true;
  if (rhs.old_page_info < lhs.old_page_info)
    return false;
  if (lhs.http_response_code < rhs.http_response_code)
    return true;
  if (rhs.http_response_code < lhs.http_response_code)
    return false;
  if (lhs.navigation_api_history_entry_arrays < rhs.navigation_api_history_entry_arrays)
    return true;
  if (rhs.navigation_api_history_entry_arrays < lhs.navigation_api_history_entry_arrays)
    return false;
  if (lhs.early_hints_preloaded_resources < rhs.early_hints_preloaded_resources)
    return true;
  if (rhs.early_hints_preloaded_resources < lhs.early_hints_preloaded_resources)
    return false;
  if (lhs.commit_sent < rhs.commit_sent)
    return true;
  if (rhs.commit_sent < lhs.commit_sent)
    return false;
  if (lhs.srcdoc_value < rhs.srcdoc_value)
    return true;
  if (rhs.srcdoc_value < lhs.srcdoc_value)
    return false;
  if (lhs.is_load_data_with_base_url < rhs.is_load_data_with_base_url)
    return true;
  if (rhs.is_load_data_with_base_url < lhs.is_load_data_with_base_url)
    return false;
  if (lhs.ancestor_or_self_has_cspee < rhs.ancestor_or_self_has_cspee)
    return true;
  if (rhs.ancestor_or_self_has_cspee < lhs.ancestor_or_self_has_cspee)
    return false;
  if (lhs.reduced_accept_language < rhs.reduced_accept_language)
    return true;
  if (rhs.reduced_accept_language < lhs.reduced_accept_language)
    return false;
  if (lhs.navigation_delivery_type < rhs.navigation_delivery_type)
    return true;
  if (rhs.navigation_delivery_type < lhs.navigation_delivery_type)
    return false;
  if (lhs.view_transition_state < rhs.view_transition_state)
    return true;
  if (rhs.view_transition_state < lhs.view_transition_state)
    return false;
  if (lhs.soft_navigation_heuristics_task_id < rhs.soft_navigation_heuristics_task_id)
    return true;
  if (rhs.soft_navigation_heuristics_task_id < lhs.soft_navigation_heuristics_task_id)
    return false;
  if (lhs.modified_runtime_features < rhs.modified_runtime_features)
    return true;
  if (rhs.modified_runtime_features < lhs.modified_runtime_features)
    return false;
  if (lhs.fenced_frame_properties < rhs.fenced_frame_properties)
    return true;
  if (rhs.fenced_frame_properties < lhs.fenced_frame_properties)
    return false;
  if (lhs.not_restored_reasons < rhs.not_restored_reasons)
    return true;
  if (rhs.not_restored_reasons < lhs.not_restored_reasons)
    return false;
  if (lhs.load_with_storage_access < rhs.load_with_storage_access)
    return true;
  if (rhs.load_with_storage_access < lhs.load_with_storage_access)
    return false;
  if (lhs.browsing_context_group_token < rhs.browsing_context_group_token)
    return true;
  if (rhs.browsing_context_group_token < lhs.browsing_context_group_token)
    return false;
  if (lhs.lcpp_hint < rhs.lcpp_hint)
    return true;
  if (rhs.lcpp_hint < lhs.lcpp_hint)
    return false;
  if (lhs.content_settings < rhs.content_settings)
    return true;
  if (rhs.content_settings < lhs.content_settings)
    return false;
  if (lhs.visited_link_salt < rhs.visited_link_salt)
    return true;
  if (rhs.visited_link_salt < lhs.visited_link_salt)
    return false;
  if (lhs.local_surface_id < rhs.local_surface_id)
    return true;
  if (rhs.local_surface_id < lhs.local_surface_id)
    return false;
  if (lhs.initial_permission_statuses < rhs.initial_permission_statuses)
    return true;
  if (rhs.initial_permission_statuses < lhs.initial_permission_statuses)
    return false;
  if (lhs.should_skip_screenshot < rhs.should_skip_screenshot)
    return true;
  if (rhs.should_skip_screenshot < lhs.should_skip_screenshot)
    return false;
  if (lhs.force_new_document_sequence_number < rhs.force_new_document_sequence_number)
    return true;
  if (rhs.force_new_document_sequence_number < lhs.force_new_document_sequence_number)
    return false;
  if (lhs.navigation_metrics_token < rhs.navigation_metrics_token)
    return true;
  if (rhs.navigation_metrics_token < lhs.navigation_metrics_token)
    return false;
  if (lhs.commit_target_frame_token < rhs.commit_target_frame_token)
    return true;
  if (rhs.commit_target_frame_token < lhs.commit_target_frame_token)
    return false;
  if (lhs.is_initial_webui < rhs.is_initial_webui)
    return true;
  if (rhs.is_initial_webui < lhs.is_initial_webui)
    return false;
  return false;
}
template <typename StructPtrType>
PageSwapEventParamsPtr PageSwapEventParams::Clone() const {
  return New(
      mojo::Clone(url),
      mojo::Clone(page_state),
      mojo::Clone(navigation_type)
  );
}

template <typename T, PageSwapEventParams::EnableIfSame<T>*>
bool PageSwapEventParams::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->url, other_struct.url))
    return false;
  if (!mojo::Equals(this->page_state, other_struct.page_state))
    return false;
  if (!mojo::Equals(this->navigation_type, other_struct.navigation_type))
    return false;
  return true;
}

template <typename T, PageSwapEventParams::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.url < rhs.url)
    return true;
  if (rhs.url < lhs.url)
    return false;
  if (lhs.page_state < rhs.page_state)
    return true;
  if (rhs.page_state < lhs.page_state)
    return false;
  if (lhs.navigation_type < rhs.navigation_type)
    return true;
  if (rhs.navigation_type < lhs.navigation_type)
    return false;
  return false;
}


}  // blink::mojom

namespace mojo {


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::BeginNavigationParams::DataView,
                                         ::blink::mojom::BeginNavigationParamsPtr> {
  static bool IsNull(const ::blink::mojom::BeginNavigationParamsPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::BeginNavigationParamsPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::BeginNavigationParams::initiator_frame_token)& initiator_frame_token(
      const ::blink::mojom::BeginNavigationParamsPtr& input) {
    return input->initiator_frame_token;
  }

  static const decltype(::blink::mojom::BeginNavigationParams::headers)& headers(
      const ::blink::mojom::BeginNavigationParamsPtr& input) {
    return input->headers;
  }

  static decltype(::blink::mojom::BeginNavigationParams::load_flags) load_flags(
      const ::blink::mojom::BeginNavigationParamsPtr& input) {
    return input->load_flags;
  }

  static decltype(::blink::mojom::BeginNavigationParams::skip_service_worker) skip_service_worker(
      const ::blink::mojom::BeginNavigationParamsPtr& input) {
    return input->skip_service_worker;
  }

  static decltype(::blink::mojom::BeginNavigationParams::request_context_type) request_context_type(
      const ::blink::mojom::BeginNavigationParamsPtr& input) {
    return input->request_context_type;
  }

  static decltype(::blink::mojom::BeginNavigationParams::mixed_content_context_type) mixed_content_context_type(
      const ::blink::mojom::BeginNavigationParamsPtr& input) {
    return input->mixed_content_context_type;
  }

  static decltype(::blink::mojom::BeginNavigationParams::is_form_submission) is_form_submission(
      const ::blink::mojom::BeginNavigationParamsPtr& input) {
    return input->is_form_submission;
  }

  static decltype(::blink::mojom::BeginNavigationParams::was_initiated_by_link_click) was_initiated_by_link_click(
      const ::blink::mojom::BeginNavigationParamsPtr& input) {
    return input->was_initiated_by_link_click;
  }

  static decltype(::blink::mojom::BeginNavigationParams::force_history_push) force_history_push(
      const ::blink::mojom::BeginNavigationParamsPtr& input) {
    return input->force_history_push;
  }

  static const decltype(::blink::mojom::BeginNavigationParams::searchable_form_url)& searchable_form_url(
      const ::blink::mojom::BeginNavigationParamsPtr& input) {
    return input->searchable_form_url;
  }

  static const decltype(::blink::mojom::BeginNavigationParams::searchable_form_encoding)& searchable_form_encoding(
      const ::blink::mojom::BeginNavigationParamsPtr& input) {
    return input->searchable_form_encoding;
  }

  static const decltype(::blink::mojom::BeginNavigationParams::client_side_redirect_url)& client_side_redirect_url(
      const ::blink::mojom::BeginNavigationParamsPtr& input) {
    return input->client_side_redirect_url;
  }

  static const decltype(::blink::mojom::BeginNavigationParams::devtools_initiator)& devtools_initiator(
      const ::blink::mojom::BeginNavigationParamsPtr& input) {
    return input->devtools_initiator;
  }

  static const decltype(::blink::mojom::BeginNavigationParams::trust_token_params)& trust_token_params(
      const ::blink::mojom::BeginNavigationParamsPtr& input) {
    return input->trust_token_params;
  }

  static const decltype(::blink::mojom::BeginNavigationParams::impression)& impression(
      const ::blink::mojom::BeginNavigationParamsPtr& input) {
    return input->impression;
  }

  static const decltype(::blink::mojom::BeginNavigationParams::before_unload_start)& before_unload_start(
      const ::blink::mojom::BeginNavigationParamsPtr& input) {
    return input->before_unload_start;
  }

  static const decltype(::blink::mojom::BeginNavigationParams::before_unload_end)& before_unload_end(
      const ::blink::mojom::BeginNavigationParamsPtr& input) {
    return input->before_unload_end;
  }

  static decltype(::blink::mojom::BeginNavigationParams::initiator_activation_and_ad_status) initiator_activation_and_ad_status(
      const ::blink::mojom::BeginNavigationParamsPtr& input) {
    return input->initiator_activation_and_ad_status;
  }

  static decltype(::blink::mojom::BeginNavigationParams::is_container_initiated) is_container_initiated(
      const ::blink::mojom::BeginNavigationParamsPtr& input) {
    return input->is_container_initiated;
  }

  static decltype(::blink::mojom::BeginNavigationParams::storage_access_api_status) storage_access_api_status(
      const ::blink::mojom::BeginNavigationParamsPtr& input) {
    return input->storage_access_api_status;
  }

  static decltype(::blink::mojom::BeginNavigationParams::has_rel_opener) has_rel_opener(
      const ::blink::mojom::BeginNavigationParamsPtr& input) {
    return input->has_rel_opener;
  }

  static bool Read(::blink::mojom::BeginNavigationParams::DataView input, ::blink::mojom::BeginNavigationParamsPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::CommonNavigationParams::DataView,
                                         ::blink::mojom::CommonNavigationParamsPtr> {
  static bool IsNull(const ::blink::mojom::CommonNavigationParamsPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::CommonNavigationParamsPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::CommonNavigationParams::url)& url(
      const ::blink::mojom::CommonNavigationParamsPtr& input) {
    return input->url;
  }

  static const decltype(::blink::mojom::CommonNavigationParams::initiator_origin)& initiator_origin(
      const ::blink::mojom::CommonNavigationParamsPtr& input) {
    return input->initiator_origin;
  }

  static const decltype(::blink::mojom::CommonNavigationParams::initiator_base_url)& initiator_base_url(
      const ::blink::mojom::CommonNavigationParamsPtr& input) {
    return input->initiator_base_url;
  }

  static const decltype(::blink::mojom::CommonNavigationParams::referrer)& referrer(
      const ::blink::mojom::CommonNavigationParamsPtr& input) {
    return input->referrer;
  }

  static decltype(::blink::mojom::CommonNavigationParams::transition) transition(
      const ::blink::mojom::CommonNavigationParamsPtr& input) {
    return input->transition;
  }

  static decltype(::blink::mojom::CommonNavigationParams::navigation_type) navigation_type(
      const ::blink::mojom::CommonNavigationParamsPtr& input) {
    return input->navigation_type;
  }

  static const decltype(::blink::mojom::CommonNavigationParams::download_policy)& download_policy(
      const ::blink::mojom::CommonNavigationParamsPtr& input) {
    return input->download_policy;
  }

  static decltype(::blink::mojom::CommonNavigationParams::should_replace_current_entry) should_replace_current_entry(
      const ::blink::mojom::CommonNavigationParamsPtr& input) {
    return input->should_replace_current_entry;
  }

  static const decltype(::blink::mojom::CommonNavigationParams::base_url_for_data_url)& base_url_for_data_url(
      const ::blink::mojom::CommonNavigationParamsPtr& input) {
    return input->base_url_for_data_url;
  }

  static const decltype(::blink::mojom::CommonNavigationParams::actual_navigation_start)& actual_navigation_start(
      const ::blink::mojom::CommonNavigationParamsPtr& input) {
    return input->actual_navigation_start;
  }

  static const decltype(::blink::mojom::CommonNavigationParams::navigation_start)& navigation_start(
      const ::blink::mojom::CommonNavigationParamsPtr& input) {
    return input->navigation_start;
  }

  static const decltype(::blink::mojom::CommonNavigationParams::method)& method(
      const ::blink::mojom::CommonNavigationParamsPtr& input) {
    return input->method;
  }

  static  decltype(::blink::mojom::CommonNavigationParams::post_data)& post_data(
       ::blink::mojom::CommonNavigationParamsPtr& input) {
    return input->post_data;
  }

  static const decltype(::blink::mojom::CommonNavigationParams::source_location)& source_location(
      const ::blink::mojom::CommonNavigationParamsPtr& input) {
    return input->source_location;
  }

  static decltype(::blink::mojom::CommonNavigationParams::started_from_context_menu) started_from_context_menu(
      const ::blink::mojom::CommonNavigationParamsPtr& input) {
    return input->started_from_context_menu;
  }

  static decltype(::blink::mojom::CommonNavigationParams::has_user_gesture) has_user_gesture(
      const ::blink::mojom::CommonNavigationParamsPtr& input) {
    return input->has_user_gesture;
  }

  static decltype(::blink::mojom::CommonNavigationParams::text_fragment_token) text_fragment_token(
      const ::blink::mojom::CommonNavigationParamsPtr& input) {
    return input->text_fragment_token;
  }

  static decltype(::blink::mojom::CommonNavigationParams::should_check_main_world_csp) should_check_main_world_csp(
      const ::blink::mojom::CommonNavigationParamsPtr& input) {
    return input->should_check_main_world_csp;
  }

  static const decltype(::blink::mojom::CommonNavigationParams::initiator_origin_trial_features)& initiator_origin_trial_features(
      const ::blink::mojom::CommonNavigationParamsPtr& input) {
    return input->initiator_origin_trial_features;
  }

  static const decltype(::blink::mojom::CommonNavigationParams::href_translate)& href_translate(
      const ::blink::mojom::CommonNavigationParamsPtr& input) {
    return input->href_translate;
  }

  static decltype(::blink::mojom::CommonNavigationParams::is_history_navigation_in_new_child_frame) is_history_navigation_in_new_child_frame(
      const ::blink::mojom::CommonNavigationParamsPtr& input) {
    return input->is_history_navigation_in_new_child_frame;
  }

  static const decltype(::blink::mojom::CommonNavigationParams::input_start)& input_start(
      const ::blink::mojom::CommonNavigationParamsPtr& input) {
    return input->input_start;
  }

  static decltype(::blink::mojom::CommonNavigationParams::request_destination) request_destination(
      const ::blink::mojom::CommonNavigationParamsPtr& input) {
    return input->request_destination;
  }

  static bool Read(::blink::mojom::CommonNavigationParams::DataView input, ::blink::mojom::CommonNavigationParamsPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::NavigationTiming::DataView,
                                         ::blink::mojom::NavigationTimingPtr> {
  static bool IsNull(const ::blink::mojom::NavigationTimingPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::NavigationTimingPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::NavigationTiming::redirect_start)& redirect_start(
      const ::blink::mojom::NavigationTimingPtr& input) {
    return input->redirect_start;
  }

  static const decltype(::blink::mojom::NavigationTiming::redirect_end)& redirect_end(
      const ::blink::mojom::NavigationTimingPtr& input) {
    return input->redirect_end;
  }

  static const decltype(::blink::mojom::NavigationTiming::fetch_start)& fetch_start(
      const ::blink::mojom::NavigationTimingPtr& input) {
    return input->fetch_start;
  }

  static decltype(::blink::mojom::NavigationTiming::parent_resource_timing_access) parent_resource_timing_access(
      const ::blink::mojom::NavigationTimingPtr& input) {
    return input->parent_resource_timing_access;
  }

  static bool Read(::blink::mojom::NavigationTiming::DataView input, ::blink::mojom::NavigationTimingPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::OldPageInfo::DataView,
                                         ::blink::mojom::OldPageInfoPtr> {
  static bool IsNull(const ::blink::mojom::OldPageInfoPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::OldPageInfoPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::OldPageInfo::frame_token_for_old_main_frame)& frame_token_for_old_main_frame(
      const ::blink::mojom::OldPageInfoPtr& input) {
    return input->frame_token_for_old_main_frame;
  }

  static const decltype(::blink::mojom::OldPageInfo::new_lifecycle_state_for_old_page)& new_lifecycle_state_for_old_page(
      const ::blink::mojom::OldPageInfoPtr& input) {
    return input->new_lifecycle_state_for_old_page;
  }

  static bool Read(::blink::mojom::OldPageInfo::DataView input, ::blink::mojom::OldPageInfoPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::CommitNavigationParams::DataView,
                                         ::blink::mojom::CommitNavigationParamsPtr> {
  static bool IsNull(const ::blink::mojom::CommitNavigationParamsPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::CommitNavigationParamsPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::CommitNavigationParams::origin_to_commit)& origin_to_commit(
      const ::blink::mojom::CommitNavigationParamsPtr& input) {
    return input->origin_to_commit;
  }

  static const decltype(::blink::mojom::CommitNavigationParams::storage_key)& storage_key(
      const ::blink::mojom::CommitNavigationParamsPtr& input) {
    return input->storage_key;
  }

  static decltype(::blink::mojom::CommitNavigationParams::is_overriding_user_agent) is_overriding_user_agent(
      const ::blink::mojom::CommitNavigationParamsPtr& input) {
    return input->is_overriding_user_agent;
  }

  static const decltype(::blink::mojom::CommitNavigationParams::redirects)& redirects(
      const ::blink::mojom::CommitNavigationParamsPtr& input) {
    return input->redirects;
  }

  static const decltype(::blink::mojom::CommitNavigationParams::redirect_response)& redirect_response(
      const ::blink::mojom::CommitNavigationParamsPtr& input) {
    return input->redirect_response;
  }

  static const decltype(::blink::mojom::CommitNavigationParams::redirect_infos)& redirect_infos(
      const ::blink::mojom::CommitNavigationParamsPtr& input) {
    return input->redirect_infos;
  }

  static const decltype(::blink::mojom::CommitNavigationParams::post_content_type)& post_content_type(
      const ::blink::mojom::CommitNavigationParamsPtr& input) {
    return input->post_content_type;
  }

  static const decltype(::blink::mojom::CommitNavigationParams::original_url)& original_url(
      const ::blink::mojom::CommitNavigationParamsPtr& input) {
    return input->original_url;
  }

  static const decltype(::blink::mojom::CommitNavigationParams::original_method)& original_method(
      const ::blink::mojom::CommitNavigationParamsPtr& input) {
    return input->original_method;
  }

  static decltype(::blink::mojom::CommitNavigationParams::can_load_local_resources) can_load_local_resources(
      const ::blink::mojom::CommitNavigationParamsPtr& input) {
    return input->can_load_local_resources;
  }

  static const decltype(::blink::mojom::CommitNavigationParams::page_state)& page_state(
      const ::blink::mojom::CommitNavigationParamsPtr& input) {
    return input->page_state;
  }

  static decltype(::blink::mojom::CommitNavigationParams::nav_entry_id) nav_entry_id(
      const ::blink::mojom::CommitNavigationParamsPtr& input) {
    return input->nav_entry_id;
  }

  static const decltype(::blink::mojom::CommitNavigationParams::subframe_unique_names)& subframe_unique_names(
      const ::blink::mojom::CommitNavigationParamsPtr& input) {
    return input->subframe_unique_names;
  }

  static decltype(::blink::mojom::CommitNavigationParams::intended_as_new_entry) intended_as_new_entry(
      const ::blink::mojom::CommitNavigationParamsPtr& input) {
    return input->intended_as_new_entry;
  }

  static decltype(::blink::mojom::CommitNavigationParams::pending_history_list_index) pending_history_list_index(
      const ::blink::mojom::CommitNavigationParamsPtr& input) {
    return input->pending_history_list_index;
  }

  static decltype(::blink::mojom::CommitNavigationParams::current_history_list_index) current_history_list_index(
      const ::blink::mojom::CommitNavigationParamsPtr& input) {
    return input->current_history_list_index;
  }

  static decltype(::blink::mojom::CommitNavigationParams::current_history_list_length) current_history_list_length(
      const ::blink::mojom::CommitNavigationParamsPtr& input) {
    return input->current_history_list_length;
  }

  static decltype(::blink::mojom::CommitNavigationParams::was_discarded) was_discarded(
      const ::blink::mojom::CommitNavigationParamsPtr& input) {
    return input->was_discarded;
  }

  static decltype(::blink::mojom::CommitNavigationParams::is_view_source) is_view_source(
      const ::blink::mojom::CommitNavigationParamsPtr& input) {
    return input->is_view_source;
  }

  static decltype(::blink::mojom::CommitNavigationParams::should_clear_history_list) should_clear_history_list(
      const ::blink::mojom::CommitNavigationParamsPtr& input) {
    return input->should_clear_history_list;
  }

  static const decltype(::blink::mojom::CommitNavigationParams::navigation_timing)& navigation_timing(
      const ::blink::mojom::CommitNavigationParamsPtr& input) {
    return input->navigation_timing;
  }

  static decltype(::blink::mojom::CommitNavigationParams::was_activated) was_activated(
      const ::blink::mojom::CommitNavigationParamsPtr& input) {
    return input->was_activated;
  }

  static const decltype(::blink::mojom::CommitNavigationParams::navigation_token)& navigation_token(
      const ::blink::mojom::CommitNavigationParamsPtr& input) {
    return input->navigation_token;
  }

  static  decltype(::blink::mojom::CommitNavigationParams::prefetched_signed_exchanges)& prefetched_signed_exchanges(
       ::blink::mojom::CommitNavigationParamsPtr& input) {
    return input->prefetched_signed_exchanges;
  }

  static decltype(::blink::mojom::CommitNavigationParams::is_browser_initiated) is_browser_initiated(
      const ::blink::mojom::CommitNavigationParamsPtr& input) {
    return input->is_browser_initiated;
  }

  static decltype(::blink::mojom::CommitNavigationParams::has_ua_visual_transition) has_ua_visual_transition(
      const ::blink::mojom::CommitNavigationParamsPtr& input) {
    return input->has_ua_visual_transition;
  }

  static decltype(::blink::mojom::CommitNavigationParams::document_ukm_source_id) document_ukm_source_id(
      const ::blink::mojom::CommitNavigationParamsPtr& input) {
    return input->document_ukm_source_id;
  }

  static const decltype(::blink::mojom::CommitNavigationParams::frame_policy)& frame_policy(
      const ::blink::mojom::CommitNavigationParamsPtr& input) {
    return input->frame_policy;
  }

  static const decltype(::blink::mojom::CommitNavigationParams::force_enabled_origin_trials)& force_enabled_origin_trials(
      const ::blink::mojom::CommitNavigationParamsPtr& input) {
    return input->force_enabled_origin_trials;
  }

  static decltype(::blink::mojom::CommitNavigationParams::origin_agent_cluster) origin_agent_cluster(
      const ::blink::mojom::CommitNavigationParamsPtr& input) {
    return input->origin_agent_cluster;
  }

  static decltype(::blink::mojom::CommitNavigationParams::origin_agent_cluster_left_as_default) origin_agent_cluster_left_as_default(
      const ::blink::mojom::CommitNavigationParamsPtr& input) {
    return input->origin_agent_cluster_left_as_default;
  }

  static const decltype(::blink::mojom::CommitNavigationParams::enabled_client_hints)& enabled_client_hints(
      const ::blink::mojom::CommitNavigationParamsPtr& input) {
    return input->enabled_client_hints;
  }

  static decltype(::blink::mojom::CommitNavigationParams::is_cross_site_cross_browsing_context_group) is_cross_site_cross_browsing_context_group(
      const ::blink::mojom::CommitNavigationParamsPtr& input) {
    return input->is_cross_site_cross_browsing_context_group;
  }

  static decltype(::blink::mojom::CommitNavigationParams::should_have_sticky_user_activation) should_have_sticky_user_activation(
      const ::blink::mojom::CommitNavigationParamsPtr& input) {
    return input->should_have_sticky_user_activation;
  }

  static const decltype(::blink::mojom::CommitNavigationParams::old_page_info)& old_page_info(
      const ::blink::mojom::CommitNavigationParamsPtr& input) {
    return input->old_page_info;
  }

  static decltype(::blink::mojom::CommitNavigationParams::http_response_code) http_response_code(
      const ::blink::mojom::CommitNavigationParamsPtr& input) {
    return input->http_response_code;
  }

  static const decltype(::blink::mojom::CommitNavigationParams::navigation_api_history_entry_arrays)& navigation_api_history_entry_arrays(
      const ::blink::mojom::CommitNavigationParamsPtr& input) {
    return input->navigation_api_history_entry_arrays;
  }

  static const decltype(::blink::mojom::CommitNavigationParams::early_hints_preloaded_resources)& early_hints_preloaded_resources(
      const ::blink::mojom::CommitNavigationParamsPtr& input) {
    return input->early_hints_preloaded_resources;
  }

  static const decltype(::blink::mojom::CommitNavigationParams::commit_sent)& commit_sent(
      const ::blink::mojom::CommitNavigationParamsPtr& input) {
    return input->commit_sent;
  }

  static const decltype(::blink::mojom::CommitNavigationParams::srcdoc_value)& srcdoc_value(
      const ::blink::mojom::CommitNavigationParamsPtr& input) {
    return input->srcdoc_value;
  }

  static decltype(::blink::mojom::CommitNavigationParams::is_load_data_with_base_url) is_load_data_with_base_url(
      const ::blink::mojom::CommitNavigationParamsPtr& input) {
    return input->is_load_data_with_base_url;
  }

  static decltype(::blink::mojom::CommitNavigationParams::ancestor_or_self_has_cspee) ancestor_or_self_has_cspee(
      const ::blink::mojom::CommitNavigationParamsPtr& input) {
    return input->ancestor_or_self_has_cspee;
  }

  static const decltype(::blink::mojom::CommitNavigationParams::reduced_accept_language)& reduced_accept_language(
      const ::blink::mojom::CommitNavigationParamsPtr& input) {
    return input->reduced_accept_language;
  }

  static decltype(::blink::mojom::CommitNavigationParams::navigation_delivery_type) navigation_delivery_type(
      const ::blink::mojom::CommitNavigationParamsPtr& input) {
    return input->navigation_delivery_type;
  }

  static const decltype(::blink::mojom::CommitNavigationParams::view_transition_state)& view_transition_state(
      const ::blink::mojom::CommitNavigationParamsPtr& input) {
    return input->view_transition_state;
  }

  static const decltype(::blink::mojom::CommitNavigationParams::soft_navigation_heuristics_task_id)& soft_navigation_heuristics_task_id(
      const ::blink::mojom::CommitNavigationParamsPtr& input) {
    return input->soft_navigation_heuristics_task_id;
  }

  static const decltype(::blink::mojom::CommitNavigationParams::modified_runtime_features)& modified_runtime_features(
      const ::blink::mojom::CommitNavigationParamsPtr& input) {
    return input->modified_runtime_features;
  }

  static const decltype(::blink::mojom::CommitNavigationParams::fenced_frame_properties)& fenced_frame_properties(
      const ::blink::mojom::CommitNavigationParamsPtr& input) {
    return input->fenced_frame_properties;
  }

  static const decltype(::blink::mojom::CommitNavigationParams::not_restored_reasons)& not_restored_reasons(
      const ::blink::mojom::CommitNavigationParamsPtr& input) {
    return input->not_restored_reasons;
  }

  static decltype(::blink::mojom::CommitNavigationParams::load_with_storage_access) load_with_storage_access(
      const ::blink::mojom::CommitNavigationParamsPtr& input) {
    return input->load_with_storage_access;
  }

  static const decltype(::blink::mojom::CommitNavigationParams::browsing_context_group_token)& browsing_context_group_token(
      const ::blink::mojom::CommitNavigationParamsPtr& input) {
    return input->browsing_context_group_token;
  }

  static const decltype(::blink::mojom::CommitNavigationParams::lcpp_hint)& lcpp_hint(
      const ::blink::mojom::CommitNavigationParamsPtr& input) {
    return input->lcpp_hint;
  }

  static const decltype(::blink::mojom::CommitNavigationParams::content_settings)& content_settings(
      const ::blink::mojom::CommitNavigationParamsPtr& input) {
    return input->content_settings;
  }

  static decltype(::blink::mojom::CommitNavigationParams::visited_link_salt) visited_link_salt(
      const ::blink::mojom::CommitNavigationParamsPtr& input) {
    return input->visited_link_salt;
  }

  static const decltype(::blink::mojom::CommitNavigationParams::local_surface_id)& local_surface_id(
      const ::blink::mojom::CommitNavigationParamsPtr& input) {
    return input->local_surface_id;
  }

  static const decltype(::blink::mojom::CommitNavigationParams::initial_permission_statuses)& initial_permission_statuses(
      const ::blink::mojom::CommitNavigationParamsPtr& input) {
    return input->initial_permission_statuses;
  }

  static decltype(::blink::mojom::CommitNavigationParams::should_skip_screenshot) should_skip_screenshot(
      const ::blink::mojom::CommitNavigationParamsPtr& input) {
    return input->should_skip_screenshot;
  }

  static decltype(::blink::mojom::CommitNavigationParams::force_new_document_sequence_number) force_new_document_sequence_number(
      const ::blink::mojom::CommitNavigationParamsPtr& input) {
    return input->force_new_document_sequence_number;
  }

  static const decltype(::blink::mojom::CommitNavigationParams::navigation_metrics_token)& navigation_metrics_token(
      const ::blink::mojom::CommitNavigationParamsPtr& input) {
    return input->navigation_metrics_token;
  }

  static const decltype(::blink::mojom::CommitNavigationParams::commit_target_frame_token)& commit_target_frame_token(
      const ::blink::mojom::CommitNavigationParamsPtr& input) {
    return input->commit_target_frame_token;
  }

  static decltype(::blink::mojom::CommitNavigationParams::is_initial_webui) is_initial_webui(
      const ::blink::mojom::CommitNavigationParamsPtr& input) {
    return input->is_initial_webui;
  }

  static bool Read(::blink::mojom::CommitNavigationParams::DataView input, ::blink::mojom::CommitNavigationParamsPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::PageSwapEventParams::DataView,
                                         ::blink::mojom::PageSwapEventParamsPtr> {
  static bool IsNull(const ::blink::mojom::PageSwapEventParamsPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::PageSwapEventParamsPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::PageSwapEventParams::url)& url(
      const ::blink::mojom::PageSwapEventParamsPtr& input) {
    return input->url;
  }

  static const decltype(::blink::mojom::PageSwapEventParams::page_state)& page_state(
      const ::blink::mojom::PageSwapEventParamsPtr& input) {
    return input->page_state;
  }

  static decltype(::blink::mojom::PageSwapEventParams::navigation_type) navigation_type(
      const ::blink::mojom::PageSwapEventParamsPtr& input) {
    return input->navigation_type;
  }

  static bool Read(::blink::mojom::PageSwapEventParams::DataView input, ::blink::mojom::PageSwapEventParamsPtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_NAVIGATION_NAVIGATION_PARAMS_MOJOM_H_