// third_party/blink/public/mojom/navigation/navigation_params.mojom-lite.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';


mojo.internal.exportModule('blink.mojom');





/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
blink.mojom.NavigationTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
blink.mojom.NavigationType = {
  
  RELOAD: 0,
  RELOAD_BYPASSING_CACHE: 1,
  RESTORE: 2,
  RESTORE_WITH_POST: 3,
  HISTORY_SAME_DOCUMENT: 4,
  HISTORY_DIFFERENT_DOCUMENT: 5,
  SAME_DOCUMENT: 6,
  DIFFERENT_DOCUMENT: 7,
  MIN_VALUE: 0,
  MAX_VALUE: 7,
};


/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
blink.mojom.NavigationTypeForNavigationApiSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
blink.mojom.NavigationTypeForNavigationApi = {
  
  kPush: 0,
  kTraverse: 1,
  kReplace: 2,
  kReload: 3,
  MIN_VALUE: 0,
  MAX_VALUE: 3,
};


/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
blink.mojom.ForceHistoryPushSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
blink.mojom.ForceHistoryPush = {
  
  kYes: 0,
  kNo: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};


/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
blink.mojom.ParentResourceTimingAccessSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
blink.mojom.ParentResourceTimingAccess = {
  
  kDoNotReport: 0,
  kReportWithoutResponseDetails: 1,
  kReportWithResponseDetails: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};




/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.BeginNavigationParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.CommonNavigationParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.NavigationTimingSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.OldPageInfoSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.CommitNavigationParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.PageSwapEventParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    blink.mojom.BeginNavigationParamsSpec.$,
    'BeginNavigationParams',
    [
      mojo.internal.StructField(
        'initiatorFrameToken', 0,
        0,
        blink.mojom.LocalFrameTokenSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'headers', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'loadFlags', 16,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'skipServiceWorker', 20,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'requestContextType', 24,
        0,
        blink.mojom.RequestContextTypeSpec.$,
        blink.mojom.RequestContextType.UNSPECIFIED,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'mixedContentContextType', 28,
        0,
        blink.mojom.MixedContentContextTypeSpec.$,
        blink.mojom.MixedContentContextType.kNotMixedContent,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'isFormSubmission', 20,
        1,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'wasInitiatedByLinkClick', 20,
        2,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'forceHistoryPush', 32,
        0,
        blink.mojom.ForceHistoryPushSpec.$,
        blink.mojom.ForceHistoryPush.kNo,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'searchableFormUrl', 40,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'searchableFormEncoding', 48,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'clientSideRedirectUrl', 56,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'devtoolsInitiator', 64,
        0,
        mojoBase.mojom.DictionaryValueSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'trustTokenParams', 72,
        0,
        network.mojom.TrustTokenParamsSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'impression', 80,
        0,
        blink.mojom.ImpressionSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'beforeUnloadStart', 88,
        0,
        mojoBase.mojom.TimeTicksSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'beforeUnloadEnd', 96,
        0,
        mojoBase.mojom.TimeTicksSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'initiatorActivationAndAdStatus', 36,
        0,
        blink.mojom.NavigationInitiatorActivationAndAdStatusSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'isContainerInitiated', 20,
        3,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'storageAccessApiStatus', 104,
        0,
        network.mojom.StorageAccessApiStatusSpec.$,
        network.mojom.StorageAccessApiStatus.kNone,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'hasRelOpener', 20,
        4,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 120],]);





/** @record */
blink.mojom.BeginNavigationParams = class {
  constructor() {
    /** @export { (blink.mojom.LocalFrameToken|undefined) } */
    this.initiatorFrameToken;
    /** @export { !string } */
    this.headers;
    /** @export { !number } */
    this.loadFlags;
    /** @export { !boolean } */
    this.skipServiceWorker;
    /** @export { !blink.mojom.RequestContextType } */
    this.requestContextType;
    /** @export { !blink.mojom.MixedContentContextType } */
    this.mixedContentContextType;
    /** @export { !boolean } */
    this.isFormSubmission;
    /** @export { !boolean } */
    this.wasInitiatedByLinkClick;
    /** @export { !blink.mojom.ForceHistoryPush } */
    this.forceHistoryPush;
    /** @export { !url.mojom.Url } */
    this.searchableFormUrl;
    /** @export { !string } */
    this.searchableFormEncoding;
    /** @export { !url.mojom.Url } */
    this.clientSideRedirectUrl;
    /** @export { (mojoBase.mojom.DictionaryValue|undefined) } */
    this.devtoolsInitiator;
    /** @export { (network.mojom.TrustTokenParams|undefined) } */
    this.trustTokenParams;
    /** @export { (blink.mojom.Impression|undefined) } */
    this.impression;
    /** @export { !mojoBase.mojom.TimeTicks } */
    this.beforeUnloadStart;
    /** @export { !mojoBase.mojom.TimeTicks } */
    this.beforeUnloadEnd;
    /** @export { !blink.mojom.NavigationInitiatorActivationAndAdStatus } */
    this.initiatorActivationAndAdStatus;
    /** @export { !boolean } */
    this.isContainerInitiated;
    /** @export { !network.mojom.StorageAccessApiStatus } */
    this.storageAccessApiStatus;
    /** @export { !boolean } */
    this.hasRelOpener;
  }
};



mojo.internal.Struct(
    blink.mojom.CommonNavigationParamsSpec.$,
    'CommonNavigationParams',
    [
      mojo.internal.StructField(
        'url', 0,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'initiatorOrigin', 8,
        0,
        url.mojom.OriginSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'initiatorBaseUrl', 16,
        0,
        url.mojom.UrlSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'referrer', 24,
        0,
        blink.mojom.ReferrerSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'transition', 32,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'navigationType', 36,
        0,
        blink.mojom.NavigationTypeSpec.$,
        blink.mojom.NavigationType.DIFFERENT_DOCUMENT,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'downloadPolicy', 40,
        0,
        blink.mojom.NavigationDownloadPolicySpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'shouldReplaceCurrentEntry', 48,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'baseUrlForDataUrl', 56,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'actualNavigationStart', 64,
        0,
        mojoBase.mojom.TimeTicksSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'navigationStart', 72,
        0,
        mojoBase.mojom.TimeTicksSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'method', 80,
        0,
        mojo.internal.String,
        "GET",
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'postData', 88,
        0,
        network.mojom.URLRequestBodySpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'sourceLocation', 96,
        0,
        network.mojom.SourceLocationSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'startedFromContextMenu', 48,
        1,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'hasUserGesture', 48,
        2,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'textFragmentToken', 48,
        3,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'shouldCheckMainWorldCsp', 52,
        0,
        network.mojom.CSPDispositionSpec.$,
        network.mojom.CSPDisposition.CHECK,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'initiatorOriginTrialFeatures', 104,
        0,
        mojo.internal.Array(mojo.internal.Int32, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'hrefTranslate', 112,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'isHistoryNavigationInNewChildFrame', 48,
        4,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'inputStart', 120,
        0,
        mojoBase.mojom.TimeTicksSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'requestDestination', 128,
        0,
        network.mojom.RequestDestinationSpec.$,
        network.mojom.RequestDestination.kEmpty,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 144],]);





/** @record */
blink.mojom.CommonNavigationParams = class {
  constructor() {
    /** @export { !url.mojom.Url } */
    this.url;
    /** @export { (url.mojom.Origin|undefined) } */
    this.initiatorOrigin;
    /** @export { (url.mojom.Url|undefined) } */
    this.initiatorBaseUrl;
    /** @export { !blink.mojom.Referrer } */
    this.referrer;
    /** @export { !number } */
    this.transition;
    /** @export { !blink.mojom.NavigationType } */
    this.navigationType;
    /** @export { !blink.mojom.NavigationDownloadPolicy } */
    this.downloadPolicy;
    /** @export { !boolean } */
    this.shouldReplaceCurrentEntry;
    /** @export { !url.mojom.Url } */
    this.baseUrlForDataUrl;
    /** @export { !mojoBase.mojom.TimeTicks } */
    this.actualNavigationStart;
    /** @export { !mojoBase.mojom.TimeTicks } */
    this.navigationStart;
    /** @export { !string } */
    this.method;
    /** @export { (network.mojom.URLRequestBody|undefined) } */
    this.postData;
    /** @export { !network.mojom.SourceLocation } */
    this.sourceLocation;
    /** @export { !boolean } */
    this.startedFromContextMenu;
    /** @export { !boolean } */
    this.hasUserGesture;
    /** @export { !boolean } */
    this.textFragmentToken;
    /** @export { !network.mojom.CSPDisposition } */
    this.shouldCheckMainWorldCsp;
    /** @export { !Array<!number> } */
    this.initiatorOriginTrialFeatures;
    /** @export { !string } */
    this.hrefTranslate;
    /** @export { !boolean } */
    this.isHistoryNavigationInNewChildFrame;
    /** @export { !mojoBase.mojom.TimeTicks } */
    this.inputStart;
    /** @export { !network.mojom.RequestDestination } */
    this.requestDestination;
  }
};



mojo.internal.Struct(
    blink.mojom.NavigationTimingSpec.$,
    'NavigationTiming',
    [
      mojo.internal.StructField(
        'redirectStart', 0,
        0,
        mojoBase.mojom.TimeTicksSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'redirectEnd', 8,
        0,
        mojoBase.mojom.TimeTicksSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'fetchStart', 16,
        0,
        mojoBase.mojom.TimeTicksSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'parentResourceTimingAccess', 24,
        0,
        blink.mojom.ParentResourceTimingAccessSpec.$,
        blink.mojom.ParentResourceTimingAccess.kDoNotReport,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 40],]);





/** @record */
blink.mojom.NavigationTiming = class {
  constructor() {
    /** @export { !mojoBase.mojom.TimeTicks } */
    this.redirectStart;
    /** @export { !mojoBase.mojom.TimeTicks } */
    this.redirectEnd;
    /** @export { !mojoBase.mojom.TimeTicks } */
    this.fetchStart;
    /** @export { !blink.mojom.ParentResourceTimingAccess } */
    this.parentResourceTimingAccess;
  }
};



mojo.internal.Struct(
    blink.mojom.OldPageInfoSpec.$,
    'OldPageInfo',
    [
      mojo.internal.StructField(
        'frameTokenForOldMainFrame', 0,
        0,
        blink.mojom.LocalFrameTokenSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'newLifecycleStateForOldPage', 8,
        0,
        blink.mojom.PageLifecycleStateSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
blink.mojom.OldPageInfo = class {
  constructor() {
    /** @export { !blink.mojom.LocalFrameToken } */
    this.frameTokenForOldMainFrame;
    /** @export { !blink.mojom.PageLifecycleState } */
    this.newLifecycleStateForOldPage;
  }
};



mojo.internal.Struct(
    blink.mojom.CommitNavigationParamsSpec.$,
    'CommitNavigationParams',
    [
      mojo.internal.StructField(
        'originToCommit', 0,
        0,
        url.mojom.OriginSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'storageKey', 8,
        0,
        blink.mojom.StorageKeySpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'isOverridingUserAgent', 16,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'redirects', 24,
        0,
        mojo.internal.Array(url.mojom.UrlSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'redirectResponse', 32,
        0,
        mojo.internal.Array(network.mojom.URLResponseHeadSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'redirectInfos', 40,
        0,
        mojo.internal.Array(network.mojom.URLRequestRedirectInfoSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'postContentType', 48,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'originalUrl', 56,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'originalMethod', 64,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'canLoadLocalResources', 16,
        1,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'pageState', 72,
        0,
        mojoBase.mojom.ByteStringSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'navEntryId', 20,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'subframeUniqueNames', 80,
        0,
        mojo.internal.Map(mojo.internal.String, mojo.internal.Bool, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'intendedAsNewEntry', 16,
        2,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'pendingHistoryListIndex', 88,
        0,
        mojo.internal.Int32,
        -1,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'currentHistoryListIndex', 92,
        0,
        mojo.internal.Int32,
        -1,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'currentHistoryListLength', 96,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'wasDiscarded', 16,
        3,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'isViewSource', 16,
        4,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'shouldClearHistoryList', 16,
        5,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'navigationTiming', 104,
        0,
        blink.mojom.NavigationTimingSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'wasActivated', 100,
        0,
        blink.mojom.WasActivatedOptionSpec.$,
        blink.mojom.WasActivatedOption.kUnknown,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'navigationToken', 112,
        0,
        mojoBase.mojom.UnguessableTokenSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'prefetchedSignedExchanges', 120,
        0,
        mojo.internal.Array(blink.mojom.PrefetchedSignedExchangeInfoSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'isBrowserInitiated', 16,
        6,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'hasUaVisualTransition', 16,
        7,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'documentUkmSourceId', 128,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'framePolicy', 136,
        0,
        blink.mojom.FramePolicySpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'forceEnabledOriginTrials', 144,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'originAgentCluster', 17,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'originAgentClusterLeftAsDefault', 17,
        1,
        mojo.internal.Bool,
        true,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'enabledClientHints', 152,
        0,
        mojo.internal.Array(network.mojom.WebClientHintsTypeSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'isCrossSiteCrossBrowsingContextGroup', 17,
        2,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'shouldHaveStickyUserActivation', 17,
        3,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'oldPageInfo', 160,
        0,
        blink.mojom.OldPageInfoSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'httpResponseCode', 168,
        0,
        mojo.internal.Int32,
        -1,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'navigationApiHistoryEntryArrays', 176,
        0,
        blink.mojom.NavigationApiHistoryEntryArraysSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'earlyHintsPreloadedResources', 184,
        0,
        mojo.internal.Array(url.mojom.UrlSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'commitSent', 192,
        0,
        mojoBase.mojom.TimeTicksSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'srcdocValue', 200,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'isLoadDataWithBaseUrl', 17,
        4,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'ancestorOrSelfHasCspee', 17,
        5,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'reducedAcceptLanguage', 208,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'navigationDeliveryType', 172,
        0,
        network.mojom.NavigationDeliveryTypeSpec.$,
        network.mojom.NavigationDeliveryType.kDefault,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'viewTransitionState', 216,
        0,
        blink.mojom.ViewTransitionStateSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'softNavigationHeuristicsTaskId', 224,
        0,
        blink.mojom.TaskAttributionIdSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'modifiedRuntimeFeatures', 232,
        0,
        mojo.internal.Map(blink.mojom.RuntimeFeatureSpec.$, mojo.internal.Bool, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'fencedFrameProperties', 240,
        0,
        blink.mojom.FencedFramePropertiesSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'notRestoredReasons', 248,
        0,
        blink.mojom.BackForwardCacheNotRestoredReasonsSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'loadWithStorageAccess', 256,
        0,
        network.mojom.StorageAccessApiStatusSpec.$,
        network.mojom.StorageAccessApiStatus.kNone,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'browsingContextGroupToken', 264,
        0,
        mojoBase.mojom.UnguessableTokenSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'lcppHint', 272,
        0,
        blink.mojom.LCPCriticalPathPredictorNavigationTimeHintSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'contentSettings', 280,
        0,
        blink.mojom.RendererContentSettingsSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'visited_link_salt_$flag', 17,
        6,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
        {
          isPrimary: true,
          linkedValueFieldName: "visited_link_salt_$value",
          originalFieldName: "visitedLinkSalt",
        }
      ),
      mojo.internal.StructField(
        'visited_link_salt_$value', 288,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
        {
          isPrimary: false,
          originalFieldName: "visitedLinkSalt",
        }
      ),
      mojo.internal.StructField(
        'localSurfaceId', 296,
        0,
        viz.mojom.LocalSurfaceIdSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'initialPermissionStatuses', 304,
        0,
        mojo.internal.Map(blink.mojom.PermissionNameSpec.$, blink.mojom.PermissionStatusSpec.$, false),
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'shouldSkipScreenshot', 17,
        7,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'forceNewDocumentSequenceNumber', 18,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'navigationMetricsToken', 312,
        0,
        mojoBase.mojom.UnguessableTokenSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'commitTargetFrameToken', 320,
        0,
        blink.mojom.LocalFrameTokenSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'isInitialWebui', 18,
        1,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 336],]);





/** @record */
blink.mojom.CommitNavigationParams = class {
  constructor() {
    /** @export { !url.mojom.Origin } */
    this.originToCommit;
    /** @export { !blink.mojom.StorageKey } */
    this.storageKey;
    /** @export { !boolean } */
    this.isOverridingUserAgent;
    /** @export { !Array<!url.mojom.Url> } */
    this.redirects;
    /** @export { !Array<!network.mojom.URLResponseHead> } */
    this.redirectResponse;
    /** @export { !Array<!network.mojom.URLRequestRedirectInfo> } */
    this.redirectInfos;
    /** @export { !string } */
    this.postContentType;
    /** @export { !url.mojom.Url } */
    this.originalUrl;
    /** @export { !string } */
    this.originalMethod;
    /** @export { !boolean } */
    this.canLoadLocalResources;
    /** @export { !mojoBase.mojom.ByteString } */
    this.pageState;
    /** @export { !number } */
    this.navEntryId;
    /** @export { !Object<!string, !boolean> } */
    this.subframeUniqueNames;
    /** @export { !boolean } */
    this.intendedAsNewEntry;
    /** @export { !number } */
    this.pendingHistoryListIndex;
    /** @export { !number } */
    this.currentHistoryListIndex;
    /** @export { !number } */
    this.currentHistoryListLength;
    /** @export { !boolean } */
    this.wasDiscarded;
    /** @export { !boolean } */
    this.isViewSource;
    /** @export { !boolean } */
    this.shouldClearHistoryList;
    /** @export { !blink.mojom.NavigationTiming } */
    this.navigationTiming;
    /** @export { !blink.mojom.WasActivatedOption } */
    this.wasActivated;
    /** @export { !mojoBase.mojom.UnguessableToken } */
    this.navigationToken;
    /** @export { !Array<!blink.mojom.PrefetchedSignedExchangeInfo> } */
    this.prefetchedSignedExchanges;
    /** @export { !boolean } */
    this.isBrowserInitiated;
    /** @export { !boolean } */
    this.hasUaVisualTransition;
    /** @export { !bigint } */
    this.documentUkmSourceId;
    /** @export { !blink.mojom.FramePolicy } */
    this.framePolicy;
    /** @export { !Array<!string> } */
    this.forceEnabledOriginTrials;
    /** @export { !boolean } */
    this.originAgentCluster;
    /** @export { !boolean } */
    this.originAgentClusterLeftAsDefault;
    /** @export { !Array<!network.mojom.WebClientHintsType> } */
    this.enabledClientHints;
    /** @export { !boolean } */
    this.isCrossSiteCrossBrowsingContextGroup;
    /** @export { !boolean } */
    this.shouldHaveStickyUserActivation;
    /** @export { (blink.mojom.OldPageInfo|undefined) } */
    this.oldPageInfo;
    /** @export { !number } */
    this.httpResponseCode;
    /** @export { !blink.mojom.NavigationApiHistoryEntryArrays } */
    this.navigationApiHistoryEntryArrays;
    /** @export { !Array<!url.mojom.Url> } */
    this.earlyHintsPreloadedResources;
    /** @export { !mojoBase.mojom.TimeTicks } */
    this.commitSent;
    /** @export { !string } */
    this.srcdocValue;
    /** @export { !boolean } */
    this.isLoadDataWithBaseUrl;
    /** @export { !boolean } */
    this.ancestorOrSelfHasCspee;
    /** @export { !string } */
    this.reducedAcceptLanguage;
    /** @export { !network.mojom.NavigationDeliveryType } */
    this.navigationDeliveryType;
    /** @export { (blink.mojom.ViewTransitionState|undefined) } */
    this.viewTransitionState;
    /** @export { (blink.mojom.TaskAttributionId|undefined) } */
    this.softNavigationHeuristicsTaskId;
    /** @export { !Object<!blink.mojom.RuntimeFeature, !boolean> } */
    this.modifiedRuntimeFeatures;
    /** @export { (blink.mojom.FencedFrameProperties|undefined) } */
    this.fencedFrameProperties;
    /** @export { (blink.mojom.BackForwardCacheNotRestoredReasons|undefined) } */
    this.notRestoredReasons;
    /** @export { !network.mojom.StorageAccessApiStatus } */
    this.loadWithStorageAccess;
    /** @export { (mojoBase.mojom.UnguessableToken|undefined) } */
    this.browsingContextGroupToken;
    /** @export { (blink.mojom.LCPCriticalPathPredictorNavigationTimeHint|undefined) } */
    this.lcppHint;
    /** @export { !blink.mojom.RendererContentSettings } */
    this.contentSettings;
    /** @export { (bigint|undefined) } */
    this.visitedLinkSalt;
    /** @export { (viz.mojom.LocalSurfaceId|undefined) } */
    this.localSurfaceId;
    /** @export { (Object<!blink.mojom.PermissionName, !blink.mojom.PermissionStatus>|undefined) } */
    this.initialPermissionStatuses;
    /** @export { !boolean } */
    this.shouldSkipScreenshot;
    /** @export { !boolean } */
    this.forceNewDocumentSequenceNumber;
    /** @export { !mojoBase.mojom.UnguessableToken } */
    this.navigationMetricsToken;
    /** @export { (blink.mojom.LocalFrameToken|undefined) } */
    this.commitTargetFrameToken;
    /** @export { !boolean } */
    this.isInitialWebui;
  }
};



mojo.internal.Struct(
    blink.mojom.PageSwapEventParamsSpec.$,
    'PageSwapEventParams',
    [
      mojo.internal.StructField(
        'url', 0,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'pageState', 8,
        0,
        mojoBase.mojom.ByteStringSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'navigationType', 16,
        0,
        blink.mojom.NavigationTypeForNavigationApiSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);





/** @record */
blink.mojom.PageSwapEventParams = class {
  constructor() {
    /** @export { !url.mojom.Url } */
    this.url;
    /** @export { !mojoBase.mojom.ByteString } */
    this.pageState;
    /** @export { !blink.mojom.NavigationTypeForNavigationApi } */
    this.navigationType;
  }
};

