// third_party/blink/public/mojom/navigation/navigation_params.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_NAVIGATION_NAVIGATION_PARAMS_MOJOM_DATA_VIEW_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_NAVIGATION_NAVIGATION_PARAMS_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/blink/public/mojom/navigation/navigation_params.mojom-shared-internal.h"
#include "mojo/public/mojom/base/byte_string.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-shared.h"
#include "mojo/public/mojom/base/values.mojom-shared.h"
#include "services/network/public/mojom/content_security_policy.mojom-shared.h"
#include "services/network/public/mojom/fetch_api.mojom-shared.h"
#include "services/network/public/mojom/source_location.mojom-shared.h"
#include "services/network/public/mojom/storage_access_api.mojom-shared.h"
#include "services/network/public/mojom/trust_tokens.mojom-shared.h"
#include "services/network/public/mojom/url_loader.mojom-shared.h"
#include "services/network/public/mojom/url_request.mojom-shared.h"
#include "services/network/public/mojom/url_response_head.mojom-shared.h"
#include "services/network/public/mojom/web_client_hints_types.mojom-shared.h"
#include "services/network/public/mojom/web_sandbox_flags.mojom-shared.h"
#include "services/viz/public/mojom/compositing/local_surface_id.mojom-shared.h"
#include "third_party/blink/public/mojom/back_forward_cache_not_restored_reasons.mojom-shared.h"
#include "third_party/blink/public/mojom/conversions/conversions.mojom-shared.h"
#include "third_party/blink/public/mojom/fenced_frame/fenced_frame_config.mojom-shared.h"
#include "third_party/blink/public/mojom/fetch/fetch_api_request.mojom-shared.h"
#include "third_party/blink/public/mojom/frame/frame_policy.mojom-shared.h"
#include "third_party/blink/public/mojom/frame/view_transition_state.mojom-shared.h"
#include "third_party/blink/public/mojom/lcp_critical_path_predictor/lcp_critical_path_predictor.mojom-shared.h"
#include "third_party/blink/public/mojom/loader/mixed_content.mojom-shared.h"
#include "third_party/blink/public/mojom/loader/referrer.mojom-shared.h"
#include "third_party/blink/public/mojom/messaging/task_attribution_id.mojom-shared.h"
#include "third_party/blink/public/mojom/navigation/navigation_api_history_entry_arrays.mojom-shared.h"
#include "third_party/blink/public/mojom/navigation/navigation_initiator_activation_and_ad_status.mojom-shared.h"
#include "third_party/blink/public/mojom/navigation/navigation_policy.mojom-shared.h"
#include "third_party/blink/public/mojom/navigation/prefetched_signed_exchange_info.mojom-shared.h"
#include "third_party/blink/public/mojom/navigation/renderer_content_settings.mojom-shared.h"
#include "third_party/blink/public/mojom/navigation/was_activated_option.mojom-shared.h"
#include "third_party/blink/public/mojom/page/page.mojom-shared.h"
#include "third_party/blink/public/mojom/permissions/permission.mojom-shared.h"
#include "third_party/blink/public/mojom/permissions/permission_status.mojom-shared.h"
#include "services/network/public/mojom/permissions_policy/permissions_policy.mojom-shared.h"
#include "third_party/blink/public/mojom/runtime_feature_state/runtime_feature.mojom-shared.h"
#include "third_party/blink/public/mojom/storage_key/storage_key.mojom-shared.h"
#include "third_party/blink/public/mojom/tokens/tokens.mojom-shared.h"
#include "url/mojom/origin.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"


namespace blink::mojom {
class BeginNavigationParamsDataView;

class CommonNavigationParamsDataView;

class NavigationTimingDataView;

class OldPageInfoDataView;

class CommitNavigationParamsDataView;

class PageSwapEventParamsDataView;



}  // blink::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::blink::mojom::BeginNavigationParamsDataView> {
  using Data = ::blink::mojom::internal::BeginNavigationParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::CommonNavigationParamsDataView> {
  using Data = ::blink::mojom::internal::CommonNavigationParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::NavigationTimingDataView> {
  using Data = ::blink::mojom::internal::NavigationTiming_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::OldPageInfoDataView> {
  using Data = ::blink::mojom::internal::OldPageInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::CommitNavigationParamsDataView> {
  using Data = ::blink::mojom::internal::CommitNavigationParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::PageSwapEventParamsDataView> {
  using Data = ::blink::mojom::internal::PageSwapEventParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace blink::mojom {


enum class NavigationType : int32_t {
  
  RELOAD = 0,
  
  RELOAD_BYPASSING_CACHE = 1,
  
  RESTORE = 2,
  
  RESTORE_WITH_POST = 3,
  
  HISTORY_SAME_DOCUMENT = 4,
  
  HISTORY_DIFFERENT_DOCUMENT = 5,
  
  SAME_DOCUMENT = 6,
  
  DIFFERENT_DOCUMENT = 7,
  kMinValue = 0,
  kMaxValue = 7,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, NavigationType value);
inline bool IsKnownEnumValue(NavigationType value) {
  return internal::NavigationType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class NavigationTypeForNavigationApi : int32_t {
  
  kPush = 0,
  
  kTraverse = 1,
  
  kReplace = 2,
  
  kReload = 3,
  kMinValue = 0,
  kMaxValue = 3,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, NavigationTypeForNavigationApi value);
inline bool IsKnownEnumValue(NavigationTypeForNavigationApi value) {
  return internal::NavigationTypeForNavigationApi_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class ForceHistoryPush : int32_t {
  
  kYes = 0,
  
  kNo = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, ForceHistoryPush value);
inline bool IsKnownEnumValue(ForceHistoryPush value) {
  return internal::ForceHistoryPush_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class ParentResourceTimingAccess : int32_t {
  
  kDoNotReport = 0,
  
  kReportWithoutResponseDetails = 1,
  
  kReportWithResponseDetails = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, ParentResourceTimingAccess value);
inline bool IsKnownEnumValue(ParentResourceTimingAccess value) {
  return internal::ParentResourceTimingAccess_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


class BeginNavigationParamsDataView {
 public:
  BeginNavigationParamsDataView() = default;

  BeginNavigationParamsDataView(
      internal::BeginNavigationParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetInitiatorFrameTokenDataView(
      ::blink::mojom::LocalFrameTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInitiatorFrameToken(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::LocalFrameTokenDataView, UserType>(),
    "Attempting to read the optional `initiator_frame_token` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadInitiatorFrameToken` instead "
    "of `ReadInitiatorFrameToken if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->initiator_frame_token.Get();
    return mojo::internal::Deserialize<::blink::mojom::LocalFrameTokenDataView>(
        pointer, output, message_);
  }
  inline void GetHeadersDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadHeaders(UserType* output) {
    
    auto* pointer = data_->headers.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  int32_t load_flags() const {
    return data_->load_flags;
  }
  bool skip_service_worker() const {
    return data_->skip_service_worker;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadRequestContextType(UserType* output) const {
    auto data_value = data_->request_context_type;
    return mojo::internal::Deserialize<::blink::mojom::RequestContextType>(
        data_value, output);
  }
  ::blink::mojom::RequestContextType request_context_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::RequestContextType>(data_->request_context_type));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadMixedContentContextType(UserType* output) const {
    auto data_value = data_->mixed_content_context_type;
    return mojo::internal::Deserialize<::blink::mojom::MixedContentContextType>(
        data_value, output);
  }
  ::blink::mojom::MixedContentContextType mixed_content_context_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::MixedContentContextType>(data_->mixed_content_context_type));
  }
  bool is_form_submission() const {
    return data_->is_form_submission;
  }
  bool was_initiated_by_link_click() const {
    return data_->was_initiated_by_link_click;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadForceHistoryPush(UserType* output) const {
    auto data_value = data_->force_history_push;
    return mojo::internal::Deserialize<::blink::mojom::ForceHistoryPush>(
        data_value, output);
  }
  ForceHistoryPush force_history_push() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::ForceHistoryPush>(data_->force_history_push));
  }
  inline void GetSearchableFormUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSearchableFormUrl(UserType* output) {
    
    auto* pointer = data_->searchable_form_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetSearchableFormEncodingDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSearchableFormEncoding(UserType* output) {
    
    auto* pointer = data_->searchable_form_encoding.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetClientSideRedirectUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadClientSideRedirectUrl(UserType* output) {
    
    auto* pointer = data_->client_side_redirect_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetDevtoolsInitiatorDataView(
      ::mojo_base::mojom::DictionaryValueDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDevtoolsInitiator(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::DictionaryValueDataView, UserType>(),
    "Attempting to read the optional `devtools_initiator` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadDevtoolsInitiator` instead "
    "of `ReadDevtoolsInitiator if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->devtools_initiator.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::DictionaryValueDataView>(
        pointer, output, message_);
  }
  inline void GetTrustTokenParamsDataView(
      ::network::mojom::TrustTokenParamsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTrustTokenParams(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::network::mojom::TrustTokenParamsDataView, UserType>(),
    "Attempting to read the optional `trust_token_params` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadTrustTokenParams` instead "
    "of `ReadTrustTokenParams if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->trust_token_params.Get();
    return mojo::internal::Deserialize<::network::mojom::TrustTokenParamsDataView>(
        pointer, output, message_);
  }
  inline void GetImpressionDataView(
      ::blink::mojom::ImpressionDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadImpression(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::ImpressionDataView, UserType>(),
    "Attempting to read the optional `impression` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadImpression` instead "
    "of `ReadImpression if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->impression.Get();
    return mojo::internal::Deserialize<::blink::mojom::ImpressionDataView>(
        pointer, output, message_);
  }
  inline void GetBeforeUnloadStartDataView(
      ::mojo_base::mojom::TimeTicksDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBeforeUnloadStart(UserType* output) {
    
    auto* pointer = data_->before_unload_start.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeTicksDataView>(
        pointer, output, message_);
  }
  inline void GetBeforeUnloadEndDataView(
      ::mojo_base::mojom::TimeTicksDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBeforeUnloadEnd(UserType* output) {
    
    auto* pointer = data_->before_unload_end.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeTicksDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadInitiatorActivationAndAdStatus(UserType* output) const {
    auto data_value = data_->initiator_activation_and_ad_status;
    return mojo::internal::Deserialize<::blink::mojom::NavigationInitiatorActivationAndAdStatus>(
        data_value, output);
  }
  ::blink::mojom::NavigationInitiatorActivationAndAdStatus initiator_activation_and_ad_status() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::NavigationInitiatorActivationAndAdStatus>(data_->initiator_activation_and_ad_status));
  }
  bool is_container_initiated() const {
    return data_->is_container_initiated;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadStorageAccessApiStatus(UserType* output) const {
    auto data_value = data_->storage_access_api_status;
    return mojo::internal::Deserialize<::network::mojom::StorageAccessApiStatus>(
        data_value, output);
  }
  ::network::mojom::StorageAccessApiStatus storage_access_api_status() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::StorageAccessApiStatus>(data_->storage_access_api_status));
  }
  bool has_rel_opener() const {
    return data_->has_rel_opener;
  }
 private:
  internal::BeginNavigationParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class CommonNavigationParamsDataView {
 public:
  CommonNavigationParamsDataView() = default;

  CommonNavigationParamsDataView(
      internal::CommonNavigationParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUrl(UserType* output) {
    
    auto* pointer = data_->url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetInitiatorOriginDataView(
      ::url::mojom::OriginDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInitiatorOrigin(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::url::mojom::OriginDataView, UserType>(),
    "Attempting to read the optional `initiator_origin` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadInitiatorOrigin` instead "
    "of `ReadInitiatorOrigin if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->initiator_origin.Get();
    return mojo::internal::Deserialize<::url::mojom::OriginDataView>(
        pointer, output, message_);
  }
  inline void GetInitiatorBaseUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInitiatorBaseUrl(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::url::mojom::UrlDataView, UserType>(),
    "Attempting to read the optional `initiator_base_url` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadInitiatorBaseUrl` instead "
    "of `ReadInitiatorBaseUrl if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->initiator_base_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetReferrerDataView(
      ::blink::mojom::ReferrerDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadReferrer(UserType* output) {
    
    auto* pointer = data_->referrer.Get();
    return mojo::internal::Deserialize<::blink::mojom::ReferrerDataView>(
        pointer, output, message_);
  }
  int32_t transition() const {
    return data_->transition;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadNavigationType(UserType* output) const {
    auto data_value = data_->navigation_type;
    return mojo::internal::Deserialize<::blink::mojom::NavigationType>(
        data_value, output);
  }
  NavigationType navigation_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::NavigationType>(data_->navigation_type));
  }
  inline void GetDownloadPolicyDataView(
      ::blink::mojom::NavigationDownloadPolicyDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDownloadPolicy(UserType* output) {
    
    auto* pointer = data_->download_policy.Get();
    return mojo::internal::Deserialize<::blink::mojom::NavigationDownloadPolicyDataView>(
        pointer, output, message_);
  }
  bool should_replace_current_entry() const {
    return data_->should_replace_current_entry;
  }
  inline void GetBaseUrlForDataUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBaseUrlForDataUrl(UserType* output) {
    
    auto* pointer = data_->base_url_for_data_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetActualNavigationStartDataView(
      ::mojo_base::mojom::TimeTicksDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadActualNavigationStart(UserType* output) {
    
    auto* pointer = data_->actual_navigation_start.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeTicksDataView>(
        pointer, output, message_);
  }
  inline void GetNavigationStartDataView(
      ::mojo_base::mojom::TimeTicksDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadNavigationStart(UserType* output) {
    
    auto* pointer = data_->navigation_start.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeTicksDataView>(
        pointer, output, message_);
  }
  inline void GetMethodDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMethod(UserType* output) {
    
    auto* pointer = data_->method.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetPostDataDataView(
      ::network::mojom::URLRequestBodyDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPostData(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::network::mojom::URLRequestBodyDataView, UserType>(),
    "Attempting to read the optional `post_data` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadPostData` instead "
    "of `ReadPostData if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->post_data.Get();
    return mojo::internal::Deserialize<::network::mojom::URLRequestBodyDataView>(
        pointer, output, message_);
  }
  inline void GetSourceLocationDataView(
      ::network::mojom::SourceLocationDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSourceLocation(UserType* output) {
    
    auto* pointer = data_->source_location.Get();
    return mojo::internal::Deserialize<::network::mojom::SourceLocationDataView>(
        pointer, output, message_);
  }
  bool started_from_context_menu() const {
    return data_->started_from_context_menu;
  }
  bool has_user_gesture() const {
    return data_->has_user_gesture;
  }
  bool text_fragment_token() const {
    return data_->text_fragment_token;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadShouldCheckMainWorldCsp(UserType* output) const {
    auto data_value = data_->should_check_main_world_csp;
    return mojo::internal::Deserialize<::network::mojom::CSPDisposition>(
        data_value, output);
  }
  ::network::mojom::CSPDisposition should_check_main_world_csp() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::CSPDisposition>(data_->should_check_main_world_csp));
  }
  inline void GetInitiatorOriginTrialFeaturesDataView(
      mojo::ArrayDataView<int32_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInitiatorOriginTrialFeatures(UserType* output) {
    
    auto* pointer = data_->initiator_origin_trial_features.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<int32_t>>(
        pointer, output, message_);
  }
  inline void GetHrefTranslateDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadHrefTranslate(UserType* output) {
    
    auto* pointer = data_->href_translate.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  bool is_history_navigation_in_new_child_frame() const {
    return data_->is_history_navigation_in_new_child_frame;
  }
  inline void GetInputStartDataView(
      ::mojo_base::mojom::TimeTicksDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInputStart(UserType* output) {
    
    auto* pointer = data_->input_start.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeTicksDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadRequestDestination(UserType* output) const {
    auto data_value = data_->request_destination;
    return mojo::internal::Deserialize<::network::mojom::RequestDestination>(
        data_value, output);
  }
  ::network::mojom::RequestDestination request_destination() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::RequestDestination>(data_->request_destination));
  }
 private:
  internal::CommonNavigationParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class NavigationTimingDataView {
 public:
  NavigationTimingDataView() = default;

  NavigationTimingDataView(
      internal::NavigationTiming_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetRedirectStartDataView(
      ::mojo_base::mojom::TimeTicksDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRedirectStart(UserType* output) {
    
    auto* pointer = data_->redirect_start.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeTicksDataView>(
        pointer, output, message_);
  }
  inline void GetRedirectEndDataView(
      ::mojo_base::mojom::TimeTicksDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRedirectEnd(UserType* output) {
    
    auto* pointer = data_->redirect_end.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeTicksDataView>(
        pointer, output, message_);
  }
  inline void GetFetchStartDataView(
      ::mojo_base::mojom::TimeTicksDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFetchStart(UserType* output) {
    
    auto* pointer = data_->fetch_start.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeTicksDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadParentResourceTimingAccess(UserType* output) const {
    auto data_value = data_->parent_resource_timing_access;
    return mojo::internal::Deserialize<::blink::mojom::ParentResourceTimingAccess>(
        data_value, output);
  }
  ParentResourceTimingAccess parent_resource_timing_access() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::ParentResourceTimingAccess>(data_->parent_resource_timing_access));
  }
 private:
  internal::NavigationTiming_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class OldPageInfoDataView {
 public:
  OldPageInfoDataView() = default;

  OldPageInfoDataView(
      internal::OldPageInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetFrameTokenForOldMainFrameDataView(
      ::blink::mojom::LocalFrameTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFrameTokenForOldMainFrame(UserType* output) {
    
    auto* pointer = data_->frame_token_for_old_main_frame.Get();
    return mojo::internal::Deserialize<::blink::mojom::LocalFrameTokenDataView>(
        pointer, output, message_);
  }
  inline void GetNewLifecycleStateForOldPageDataView(
      ::blink::mojom::PageLifecycleStateDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadNewLifecycleStateForOldPage(UserType* output) {
    
    auto* pointer = data_->new_lifecycle_state_for_old_page.Get();
    return mojo::internal::Deserialize<::blink::mojom::PageLifecycleStateDataView>(
        pointer, output, message_);
  }
 private:
  internal::OldPageInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class CommitNavigationParamsDataView {
 public:
  CommitNavigationParamsDataView() = default;

  CommitNavigationParamsDataView(
      internal::CommitNavigationParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetOriginToCommitDataView(
      ::url::mojom::OriginDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOriginToCommit(UserType* output) {
    
    auto* pointer = data_->origin_to_commit.Get();
    return mojo::internal::Deserialize<::url::mojom::OriginDataView>(
        pointer, output, message_);
  }
  inline void GetStorageKeyDataView(
      ::blink::mojom::StorageKeyDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadStorageKey(UserType* output) {
    
    auto* pointer = data_->storage_key.Get();
    return mojo::internal::Deserialize<::blink::mojom::StorageKeyDataView>(
        pointer, output, message_);
  }
  bool is_overriding_user_agent() const {
    return data_->is_overriding_user_agent;
  }
  inline void GetRedirectsDataView(
      mojo::ArrayDataView<::url::mojom::UrlDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRedirects(UserType* output) {
    
    auto* pointer = data_->redirects.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::url::mojom::UrlDataView>>(
        pointer, output, message_);
  }
  inline void GetRedirectResponseDataView(
      mojo::ArrayDataView<::network::mojom::URLResponseHeadDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRedirectResponse(UserType* output) {
    
    auto* pointer = data_->redirect_response.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::network::mojom::URLResponseHeadDataView>>(
        pointer, output, message_);
  }
  inline void GetRedirectInfosDataView(
      mojo::ArrayDataView<::network::mojom::URLRequestRedirectInfoDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRedirectInfos(UserType* output) {
    
    auto* pointer = data_->redirect_infos.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::network::mojom::URLRequestRedirectInfoDataView>>(
        pointer, output, message_);
  }
  inline void GetPostContentTypeDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPostContentType(UserType* output) {
    
    auto* pointer = data_->post_content_type.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetOriginalUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOriginalUrl(UserType* output) {
    
    auto* pointer = data_->original_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetOriginalMethodDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOriginalMethod(UserType* output) {
    
    auto* pointer = data_->original_method.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  bool can_load_local_resources() const {
    return data_->can_load_local_resources;
  }
  inline void GetPageStateDataView(
      ::mojo_base::mojom::ByteStringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPageState(UserType* output) {
    
    auto* pointer = data_->page_state.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::ByteStringDataView>(
        pointer, output, message_);
  }
  int32_t nav_entry_id() const {
    return data_->nav_entry_id;
  }
  inline void GetSubframeUniqueNamesDataView(
      mojo::MapDataView<mojo::StringDataView, bool>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSubframeUniqueNames(UserType* output) {
    
    auto* pointer = data_->subframe_unique_names.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<mojo::StringDataView, bool>>(
        pointer, output, message_);
  }
  bool intended_as_new_entry() const {
    return data_->intended_as_new_entry;
  }
  int32_t pending_history_list_index() const {
    return data_->pending_history_list_index;
  }
  int32_t current_history_list_index() const {
    return data_->current_history_list_index;
  }
  int32_t current_history_list_length() const {
    return data_->current_history_list_length;
  }
  bool was_discarded() const {
    return data_->was_discarded;
  }
  bool is_view_source() const {
    return data_->is_view_source;
  }
  bool should_clear_history_list() const {
    return data_->should_clear_history_list;
  }
  inline void GetNavigationTimingDataView(
      NavigationTimingDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadNavigationTiming(UserType* output) {
    
    auto* pointer = data_->navigation_timing.Get();
    return mojo::internal::Deserialize<::blink::mojom::NavigationTimingDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadWasActivated(UserType* output) const {
    auto data_value = data_->was_activated;
    return mojo::internal::Deserialize<::blink::mojom::WasActivatedOption>(
        data_value, output);
  }
  ::blink::mojom::WasActivatedOption was_activated() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::WasActivatedOption>(data_->was_activated));
  }
  inline void GetNavigationTokenDataView(
      ::mojo_base::mojom::UnguessableTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadNavigationToken(UserType* output) {
    
    auto* pointer = data_->navigation_token.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::UnguessableTokenDataView>(
        pointer, output, message_);
  }
  inline void GetPrefetchedSignedExchangesDataView(
      mojo::ArrayDataView<::blink::mojom::PrefetchedSignedExchangeInfoDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPrefetchedSignedExchanges(UserType* output) {
    
    auto* pointer = data_->prefetched_signed_exchanges.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::PrefetchedSignedExchangeInfoDataView>>(
        pointer, output, message_);
  }
  bool is_browser_initiated() const {
    return data_->is_browser_initiated;
  }
  bool has_ua_visual_transition() const {
    return data_->has_ua_visual_transition;
  }
  int64_t document_ukm_source_id() const {
    return data_->document_ukm_source_id;
  }
  inline void GetFramePolicyDataView(
      ::blink::mojom::FramePolicyDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFramePolicy(UserType* output) {
    
    auto* pointer = data_->frame_policy.Get();
    return mojo::internal::Deserialize<::blink::mojom::FramePolicyDataView>(
        pointer, output, message_);
  }
  inline void GetForceEnabledOriginTrialsDataView(
      mojo::ArrayDataView<mojo::StringDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadForceEnabledOriginTrials(UserType* output) {
    
    auto* pointer = data_->force_enabled_origin_trials.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<mojo::StringDataView>>(
        pointer, output, message_);
  }
  bool origin_agent_cluster() const {
    return data_->origin_agent_cluster;
  }
  bool origin_agent_cluster_left_as_default() const {
    return data_->origin_agent_cluster_left_as_default;
  }
  inline void GetEnabledClientHintsDataView(
      mojo::ArrayDataView<::network::mojom::WebClientHintsType>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadEnabledClientHints(UserType* output) {
    
    auto* pointer = data_->enabled_client_hints.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::network::mojom::WebClientHintsType>>(
        pointer, output, message_);
  }
  bool is_cross_site_cross_browsing_context_group() const {
    return data_->is_cross_site_cross_browsing_context_group;
  }
  bool should_have_sticky_user_activation() const {
    return data_->should_have_sticky_user_activation;
  }
  inline void GetOldPageInfoDataView(
      OldPageInfoDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOldPageInfo(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::OldPageInfoDataView, UserType>(),
    "Attempting to read the optional `old_page_info` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadOldPageInfo` instead "
    "of `ReadOldPageInfo if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->old_page_info.Get();
    return mojo::internal::Deserialize<::blink::mojom::OldPageInfoDataView>(
        pointer, output, message_);
  }
  int32_t http_response_code() const {
    return data_->http_response_code;
  }
  inline void GetNavigationApiHistoryEntryArraysDataView(
      ::blink::mojom::NavigationApiHistoryEntryArraysDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadNavigationApiHistoryEntryArrays(UserType* output) {
    
    auto* pointer = data_->navigation_api_history_entry_arrays.Get();
    return mojo::internal::Deserialize<::blink::mojom::NavigationApiHistoryEntryArraysDataView>(
        pointer, output, message_);
  }
  inline void GetEarlyHintsPreloadedResourcesDataView(
      mojo::ArrayDataView<::url::mojom::UrlDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadEarlyHintsPreloadedResources(UserType* output) {
    
    auto* pointer = data_->early_hints_preloaded_resources.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::url::mojom::UrlDataView>>(
        pointer, output, message_);
  }
  inline void GetCommitSentDataView(
      ::mojo_base::mojom::TimeTicksDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCommitSent(UserType* output) {
    
    auto* pointer = data_->commit_sent.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeTicksDataView>(
        pointer, output, message_);
  }
  inline void GetSrcdocValueDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSrcdocValue(UserType* output) {
    
    auto* pointer = data_->srcdoc_value.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  bool is_load_data_with_base_url() const {
    return data_->is_load_data_with_base_url;
  }
  bool ancestor_or_self_has_cspee() const {
    return data_->ancestor_or_self_has_cspee;
  }
  inline void GetReducedAcceptLanguageDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadReducedAcceptLanguage(UserType* output) {
    
    auto* pointer = data_->reduced_accept_language.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadNavigationDeliveryType(UserType* output) const {
    auto data_value = data_->navigation_delivery_type;
    return mojo::internal::Deserialize<::network::mojom::NavigationDeliveryType>(
        data_value, output);
  }
  ::network::mojom::NavigationDeliveryType navigation_delivery_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::NavigationDeliveryType>(data_->navigation_delivery_type));
  }
  inline void GetViewTransitionStateDataView(
      ::blink::mojom::ViewTransitionStateDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadViewTransitionState(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::ViewTransitionStateDataView, UserType>(),
    "Attempting to read the optional `view_transition_state` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadViewTransitionState` instead "
    "of `ReadViewTransitionState if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->view_transition_state.Get();
    return mojo::internal::Deserialize<::blink::mojom::ViewTransitionStateDataView>(
        pointer, output, message_);
  }
  inline void GetSoftNavigationHeuristicsTaskIdDataView(
      ::blink::mojom::TaskAttributionIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSoftNavigationHeuristicsTaskId(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::TaskAttributionIdDataView, UserType>(),
    "Attempting to read the optional `soft_navigation_heuristics_task_id` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadSoftNavigationHeuristicsTaskId` instead "
    "of `ReadSoftNavigationHeuristicsTaskId if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->soft_navigation_heuristics_task_id.Get();
    return mojo::internal::Deserialize<::blink::mojom::TaskAttributionIdDataView>(
        pointer, output, message_);
  }
  inline void GetModifiedRuntimeFeaturesDataView(
      mojo::MapDataView<::blink::mojom::RuntimeFeature, bool>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadModifiedRuntimeFeatures(UserType* output) {
    
    auto* pointer = data_->modified_runtime_features.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<::blink::mojom::RuntimeFeature, bool>>(
        pointer, output, message_);
  }
  inline void GetFencedFramePropertiesDataView(
      ::blink::mojom::FencedFramePropertiesDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFencedFrameProperties(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::FencedFramePropertiesDataView, UserType>(),
    "Attempting to read the optional `fenced_frame_properties` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadFencedFrameProperties` instead "
    "of `ReadFencedFrameProperties if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->fenced_frame_properties.Get();
    return mojo::internal::Deserialize<::blink::mojom::FencedFramePropertiesDataView>(
        pointer, output, message_);
  }
  inline void GetNotRestoredReasonsDataView(
      ::blink::mojom::BackForwardCacheNotRestoredReasonsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadNotRestoredReasons(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::BackForwardCacheNotRestoredReasonsDataView, UserType>(),
    "Attempting to read the optional `not_restored_reasons` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadNotRestoredReasons` instead "
    "of `ReadNotRestoredReasons if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->not_restored_reasons.Get();
    return mojo::internal::Deserialize<::blink::mojom::BackForwardCacheNotRestoredReasonsDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadLoadWithStorageAccess(UserType* output) const {
    auto data_value = data_->load_with_storage_access;
    return mojo::internal::Deserialize<::network::mojom::StorageAccessApiStatus>(
        data_value, output);
  }
  ::network::mojom::StorageAccessApiStatus load_with_storage_access() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::StorageAccessApiStatus>(data_->load_with_storage_access));
  }
  inline void GetBrowsingContextGroupTokenDataView(
      ::mojo_base::mojom::UnguessableTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBrowsingContextGroupToken(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::UnguessableTokenDataView, UserType>(),
    "Attempting to read the optional `browsing_context_group_token` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadBrowsingContextGroupToken` instead "
    "of `ReadBrowsingContextGroupToken if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->browsing_context_group_token.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::UnguessableTokenDataView>(
        pointer, output, message_);
  }
  inline void GetLcppHintDataView(
      ::blink::mojom::LCPCriticalPathPredictorNavigationTimeHintDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLcppHint(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::LCPCriticalPathPredictorNavigationTimeHintDataView, UserType>(),
    "Attempting to read the optional `lcpp_hint` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadLcppHint` instead "
    "of `ReadLcppHint if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->lcpp_hint.Get();
    return mojo::internal::Deserialize<::blink::mojom::LCPCriticalPathPredictorNavigationTimeHintDataView>(
        pointer, output, message_);
  }
  inline void GetContentSettingsDataView(
      ::blink::mojom::RendererContentSettingsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadContentSettings(UserType* output) {
    
    auto* pointer = data_->content_settings.Get();
    return mojo::internal::Deserialize<::blink::mojom::RendererContentSettingsDataView>(
        pointer, output, message_);
  }
  std::optional<uint64_t> visited_link_salt() const {

    return data_->visited_link_salt_$flag
        ? std::make_optional(data_->visited_link_salt_$value)
        : std::nullopt;
  }
  inline void GetLocalSurfaceIdDataView(
      ::viz::mojom::LocalSurfaceIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLocalSurfaceId(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::viz::mojom::LocalSurfaceIdDataView, UserType>(),
    "Attempting to read the optional `local_surface_id` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadLocalSurfaceId` instead "
    "of `ReadLocalSurfaceId if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->local_surface_id.Get();
    return mojo::internal::Deserialize<::viz::mojom::LocalSurfaceIdDataView>(
        pointer, output, message_);
  }
  inline void GetInitialPermissionStatusesDataView(
      mojo::MapDataView<::blink::mojom::PermissionName, ::blink::mojom::PermissionStatus>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInitialPermissionStatuses(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::MapDataView<::blink::mojom::PermissionName, ::blink::mojom::PermissionStatus>, UserType>(),
    "Attempting to read the optional `initial_permission_statuses` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadInitialPermissionStatuses` instead "
    "of `ReadInitialPermissionStatuses if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->initial_permission_statuses.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<::blink::mojom::PermissionName, ::blink::mojom::PermissionStatus>>(
        pointer, output, message_);
  }
  bool should_skip_screenshot() const {
    return data_->should_skip_screenshot;
  }
  bool force_new_document_sequence_number() const {
    return data_->force_new_document_sequence_number;
  }
  inline void GetNavigationMetricsTokenDataView(
      ::mojo_base::mojom::UnguessableTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadNavigationMetricsToken(UserType* output) {
    
    auto* pointer = data_->navigation_metrics_token.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::UnguessableTokenDataView>(
        pointer, output, message_);
  }
  inline void GetCommitTargetFrameTokenDataView(
      ::blink::mojom::LocalFrameTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCommitTargetFrameToken(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::LocalFrameTokenDataView, UserType>(),
    "Attempting to read the optional `commit_target_frame_token` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadCommitTargetFrameToken` instead "
    "of `ReadCommitTargetFrameToken if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->commit_target_frame_token.Get();
    return mojo::internal::Deserialize<::blink::mojom::LocalFrameTokenDataView>(
        pointer, output, message_);
  }
  bool is_initial_webui() const {
    return data_->is_initial_webui;
  }
 private:
  internal::CommitNavigationParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PageSwapEventParamsDataView {
 public:
  PageSwapEventParamsDataView() = default;

  PageSwapEventParamsDataView(
      internal::PageSwapEventParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUrl(UserType* output) {
    
    auto* pointer = data_->url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetPageStateDataView(
      ::mojo_base::mojom::ByteStringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPageState(UserType* output) {
    
    auto* pointer = data_->page_state.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::ByteStringDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadNavigationType(UserType* output) const {
    auto data_value = data_->navigation_type;
    return mojo::internal::Deserialize<::blink::mojom::NavigationTypeForNavigationApi>(
        data_value, output);
  }
  NavigationTypeForNavigationApi navigation_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::NavigationTypeForNavigationApi>(data_->navigation_type));
  }
 private:
  internal::PageSwapEventParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // blink::mojom

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_NAVIGATION_NAVIGATION_PARAMS_MOJOM_DATA_VIEW_H_